 #include "mbed.h"
 #include "TCS3200.h"

 TCS3200 color(A0, A1, A2, A3, A4);  //Create a TCS3200 object 
 //            S0    S1    S2     S3     OUT
 
 int main() {
     long red, green, blue, clear;
    
     //Set the scaling factor to 100%
     color.SetMode(TCS3200::SCALE_100);        

     while(1){
         //Read the HIGH pulse width in nS for each color.
         //The lower the value, the more of that color is detected 
         red = color.ReadRed();
         green = color.ReadGreen();
         blue = color.ReadBlue();
         clear = color.ReadClear();

         printf("RED: %10d     GREEN: %10d     BLUE: %10d     CLEAR: %10d    \n ", red, green, blue, clear);
            
         wait(0.1);
     }
 }