#ifndef KEYPAD_H
#define KEYPAD_H

#include "mbed.h"

#define  CHNG_CNT       4

 /*
  @code
  #include "mbed.h"
  #include "Keypad.h"
 
Keypad key(D10, D9, D8, D7, D6, D5, D4, D3);
 
 char key_table[] = { 
                      '1', '2', '3', 'A',
                      '4', '5', '6', 'B',
                      '7', '8', '9', 'C',
                      '*', '0', '#', 'D'
                    };
  int main() {
      uint32_t key_num;
      while(true) {
         while ((key_num = key.read()) != 0){
             printf("%c\r\n", *(key_table + key_num-1));
         }
         wait(1.0);  
     }
 }
 * @endcode
 */

class Keypad {
public:
    /** 4x4 keypad interface:
     *  @param key input port           A,B,C,D
     *  @param key output(scan) port    Q,X,Y,Z
     */
    Keypad(PinName qx, PinName kx, PinName ky, PinName kz,
           PinName ka, PinName kb, PinName kc, PinName kd);
                    
    /** Read key data into buffer
     *  @param none
     *  @return key number by ASCII code
     */
    uint8_t read(void);

protected:
    DigitalIn   *k_in[4];
    DigitalOut  *k_out[4];
    Ticker      tk;

    // key control
    enum State {Off_state, Off_to_on_transient, On_state, On_to_off_transient};
    volatile State  key_state[4][4];
    volatile int8_t key_transent_cntr[4][4];
    void key_scan(void);
    
    // buffer control
    #define BF_SIZE 20
    uint8_t         read_addr;
    uint8_t         write_addr;
    uint8_t         buf[BF_SIZE];
    void bf_put (char dat);
    int8_t bf_get (void);

};

#endif // KEYPAD_H

