 #include "mbed.h"
 #include "MFRC522.h"
#include "keypad.h"
#include "TextLCD.h"
 #define SPI_MOSI    D4
 #define SPI_MISO    D5
 #define SPI_SCLK    D3
 #define SPI_CS      A0//sda pin durumu farketmiyor.
 #define MF_RESET   A1//sda pin durumu farketmiyor.
char sifre[4],sayac=0;

 Serial     pc(USBTX, USBRX);
TextLCD lcd(PB_13, PB_14, PB_15, PB_1, PB_2, PB_12); // rs, e, d4-d7 pin bağlantıları

char Keytable[] = { '1', '2', '3', 'A',
'4', '5', '6', 'B',
'7', '8', '9', 'C',
'*', '0', '#', 'D'
};

uint32_t cbAfterInput(uint32_t index) {
wait_ms(400);


sifre[sayac]=Keytable[index];
 lcd.printf("*");

if(sayac==3)
{
if(sifre[0]=='4' && sifre[1]=='5' && sifre[2]=='6' && sifre[3]=='B')
{
     lcd.cls();
    pc.printf("Giris Basarili \n");
    lcd.printf("Giris Basarili");
    wait(3);
    lcd.cls();
    sayac=-1;
    for(char x=0;x<4;x++)
    {
        sifre[x]=0;
        }
    }
    else
    {
           lcd.cls();
          pc.printf("Giris Basarisiz \n");
    lcd.printf("Giris Basarisiz");
    wait(3);
    lcd.cls();
    sayac=-1;
    for(char x=0;x<4;x++)
    {
        sifre[x]=0;
        }
        }
    }
 sayac++;
return 0;
}

 MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);

 int main(void) {
   Keypad keypad(D13, D12, D11, D10, D9, D8, D7, D6);
keypad.CallAfterInput(&cbAfterInput);
keypad.Start();
   pc.baud(250000);

   // Init. RC522 Chip
   RfChip.PCD_Init();

   while (true) {
     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       wait_ms(100);
    
       continue;
     }


     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(100);
 
       continue;
     }


     // Print Card UID
     printf("Card UID: ");
     for (uint8_t i = 0; i < RfChip.uid.size; i++)
     {
       pc.printf(" %X", RfChip.uid.uidByte[i]);

     }
     printf("\n\r");
if(RfChip.uid.uidByte[0]==0x76 && RfChip.uid.uidByte[1]==0xEC
&& RfChip.uid.uidByte[2]==0xCA && RfChip.uid.uidByte[3]==0x1F)
{
     pc.printf("Giris Basarili \n");
     }
     // Print Card type
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
     printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
     wait_ms(500);
   }
 }