#include "mbed.h"
#include "TextLCD.h"
#include "Keypad.h"
#include <string>
#include "MFRC522.h"

#define SIFRE "**123A"  // sifreyi kendinize göre değistirebilirsiniz
#define uzunluk 6       // girdiğiniz sifre ne kadar uzunsa buraya sayısını giriniz

string sifre= "";
uint8_t hata=4;

char key_table[] = {
    '1', '2', '3', 'A',
    '4', '5', '6', 'B',
    '7', '8', '9', 'C',
    '*', '0', '#', 'D'
};

Keypad key(PA_12,PA_11,PB_12,PB_2,PB_1,PB_15,PB_14,PB_13);
TextLCD lcd(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0); // rs, e, d4-d7..

DigitalOut buzzer(D7);
Servo servo1(PA_15);

MFRC522 RfChip(PA_7, PA_6, PA_5, PB_6, PC_7);/**/


void hataliGiris()
{
    lcd.cls();
    lcd.printf("Hatali Giris..");
    for(uint8_t a = 10; a > 1; a--) {
        buzzer=1;
        wait_ms(50);
        buzzer=0;
        wait_ms(10);
    }
    buzzer=0;
    hata--;
    printf("Hatali Giris..");
    wait(3);
    lcd.cls();
    sifre = "";
    if(hata == 1) {
        hata = 4;
        lcd.printf("   saniye \n bekleyiniz..");
        for(uint8_t sure = 60; sure > 0; sure--) {
            lcd.locate(0,0);
            lcd.printf("%d ",sure);
            wait(1);
        }
    }
}

int main()
{
    uint32_t key_num;
    RfChip.PCD_Init();/**/

Onur:

    lcd.cls();
    lcd.printf("Sifre : ");
    printf("Sifre : ");

    while(true) {
        while ((key_num = key.read()) != 0) { // keypada her basıldığında
            
            buzzer=1;
            wait_ms(50);
            buzzer=0;

            lcd.printf("*");
            printf("%c", *(key_table + key_num-1));

            sifre += *(key_table + key_num-1); // keypad deki değerler sifre adlı değişkende toplanıyor

            if(uzunluk == sifre.length()) {


                if(sifre == SIFRE) {  // eger ki sifremiz dogruysa
                    lcd.cls();
                    lcd.printf("Giris Basarili..");
                    printf("Giris Basarili...");
                    wait(3);
                    lcd.cls();
                    sifre = "";
                    hata=4;
                    goto Onur;
                } else {    // eger sifre hataliysa
                    hataliGiris();
                    goto Onur;
                }
            }

        }
        wait(0.2);
        ///////////////////////  /*
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(100);
            continue;
        }

        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(100);
            continue;
        }

// kard ID si yazdırılıyor
        printf("Kart ID: ");
        for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            printf(" %X", RfChip.uid.uidByte[i]);
        }
        printf("\n");

// kendinize göre dğeiştirmeniz gerekiyor
        if(RfChip.uid.uidByte[0]==0x53 && RfChip.uid.uidByte[1]==0x25 && RfChip.uid.uidByte[2]==0xB6 && RfChip.uid.uidByte[3]== 0x0) {
            lcd.cls();
            lcd.printf("Giris Basarili..");
            printf("Giris Basarili...\n");
            wait(3);
            lcd.cls();
            sifre = "";
            hata=4;
            goto Onur;
        }

        else {  // RFID da okunan kart yanlis ise
            hataliGiris();
            goto Onur;
        }
    
    } // while(true) {
    return 0;
} // int main()