#include "mbed.h"
InterruptIn KBI_SW2(SW2);
InterruptIn KBI_SW3(SW3);
Serial pc(USBTX, USBRX, 9600);

void appeler_message(unsigned char afficheur, unsigned char message)
{
    pc.putc(0x01);
    pc.printf("%03u",afficheur);
    pc.putc(0x1D);
    pc.printf("%03u",message);
    pc.putc(0x04);
    wait(0.01);
}

void IT_SW2()
{
    appeler_message(17,2); // afficheur 17 message 2
}

void IT_SW3()
{
    appeler_message(17,3); // afficheur 17 message 3
}

main()
{
    KBI_SW2.fall(&IT_SW2);
    KBI_SW3.fall(&IT_SW3);

    while (1) {}
}