#include "mbed.h"

//           Alle 12 LEDs des M0-Boards zu einer Bitgruppe zusammenfassen
//        LSB                                                      MSB
//        2^0    2^1  2^2                                          2^11
BusOut lb(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//         D20   D19  D18  D17  D16  D15  D14  D13  D4   D3   D2   D1


// LSB         MS
// 2^0         2^3
// sw4 sw3 sw1 sw2
BusIn btn(P1_16, P0_23,P0_10,P0_15);

//sw4 ->D1 blinken
//sw3 ->D2 blinken
//sw2 ->D4 blinken
//sw1 ->D3 blinken



void ButtonBlinker1();

int main(void) 
{
    while(1)
    {
        ButtonBlinker1();        
    }
    
}

void ButtonBlinker1()
{
    if( btn & 1) //ist sw4 gedrückt
        lb = lb | 2048; //D1 setzen
    if( btn & 2) //ist sw3 gedrückt
        lb = lb | 1024; //D2 setzen
    if( btn & 4) //ist sw1 gedrückt
        lb = lb | 512; //D3 setzen
    if( btn & 8) //ist sw2 gedrückt
        lb = lb | 256; //D4 setzen
    wait_ms(200);//200ms augeschaltet lassen
    lb=0; //alle ausschalten
    wait_ms(200); //200ms ausgeschaltet lassen       
}