#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// defau9600 bauds, 8-bit data, no parity

//Arduino pin D0 & D1 is disconnected by default in nucleo board and hence serial O/P or I/P will not work.
// REFER ST USER MANUAL UM 1724

//O/P/ or I/P will work in ST link(USB to serial comm) or can also be used from CN3 connector of nucleo board. 
//------------------------------------

Serial _UART(PA_2, PA_3);
 
DigitalOut myled(PB_13);

DigitalOut Drive_En(PC_4);

DigitalIn button(PC_13);

const uint8_t size = 0x19;
char rx_buf[size+1];
char tx_buf[size+1];
bool CMD_key;
char valid;
uint8_t num_bytes;
int rcvd_ADDR,cmd,addr_ID,err_ID, req,ack,ach_M,ach_S,err_Status;



void resp_HB(uint8_t seq)      //presentees(submaster,slaves,listeners will respond back to the HB along with REQ and CMD ack status
{
    switch(seq)
    {
        case 0:
            sprintf(tx_buf,"$PEOTA,%u,%c", addr_ID, valid);
        break;
        case 1:
            sprintf(tx_buf,"$PEOTR,%u,%u,%c", addr_ID, req, valid);
        break;
        case 2:
            sprintf(tx_buf,"$PEOTK,%u,%u,%c", addr_ID, ack, valid);
        break;
        default:
            sprintf(tx_buf,"$PEOTA,%u,%c", addr_ID, valid);
        break;
    }
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void send_ack_CMD()
{
    sprintf(tx_buf,"$PEOTX,%u,%u,%c", addr_ID, cmd, valid);
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void send_CMD(uint8_t _adr)
{
    sprintf(tx_buf,"$PEOTC,%u,%u,%c", _adr, cmd, valid);
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void send_HB(uint8_t _adr)                   //master will send the haertbeat to all presentees at periodic intervals
{      
    sprintf(tx_buf,"$PEOTH,%u,%c", _adr, valid);
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void send_BROADCAST()             //addr 1-8 of leds,error=1 or 0(no error)
{
    sprintf(tx_buf,"$PEOTB,%u,%u,%c",err_ID,err_Status,valid);
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void send_ACH()
{
    sprintf(tx_buf,"$PEOTS,%u,%u,%c", ach_M, ach_S, valid);
    Drive_En = 1;              
    _UART.printf("%s\r\n",tx_buf);
    wait_ms(2);
    Drive_En = 0;
}

void read_SERIAL()
{
    myled = !myled;
    char rcvd_char;
    while(_UART.readable() && (num_bytes < size))
    {
        rcvd_char = _UART.getc();
        if(rcvd_char == '$')             //first character
            num_bytes = 0;
        else
            __nop();
            
        rx_buf[num_bytes] = rcvd_char;
        num_bytes++;
        if(rcvd_char == '\n')             //last character   
        {
            strtok(rx_buf,",");
            if(strcmp(rx_buf,"$PEOTH") == 0)                      //* present submaster,Slaves or lsitners receive HB *// 
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);        //address of connected device
                resp_HB(0);                                   //set flag when Heartbeat received
            }
            else if(strcmp(rx_buf,"$PEOTA") == 0)                  //* Master,submaster and Slaves receive  heartbeat resp *//
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);
                if(CMD_key)                   //ACK key or CMD_key here is detected from active slave
                {
                    send_ack_CMD();
                    CMD_key = false;
                }
                else
                    __nop();
            }
            else if(strcmp(rx_buf,"$PEOTB") == 0)                 //* submaster,Slaves or listener receive broadcast *//
            {
                sscanf(strtok (NULL,","), "%u", &err_ID);       //cmd extracted
                sscanf(strtok (NULL,","), "%u", &err_Status);
                send_BROADCAST();
            }
            else if(strcmp(rx_buf,"$PEOTC") == 0)                 //* submaster,Slaves or listener receive CMD *//
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);       //cmd extracted
                sscanf(strtok (NULL,","), "%u", &cmd);
                send_CMD(rcvd_ADDR);
            }
            else if(strcmp(rx_buf,"$PEOTX") == 0)                //* Master,submaster,Slave or listners receive CMD acknowledge *//
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);       //cmd extracted
                sscanf(strtok (NULL,","), "%u", &cmd);
                send_ack_CMD();        
            }
            else if(strcmp(rx_buf,"$PEOTS") == 0)                 //*active channel status recieved *//
            {
                send_ACH();
            }
            else if(strcmp(rx_buf,"$PEOTR") == 0)               //* control transfer request arrived*//
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);
                sscanf(strtok (NULL,","), "%u", &req);    //e.g $R req or $K ack 
                resp_HB(1);
            }
            else if(strcmp(rx_buf,"$PEOTK") == 0)               //* Master,submaster,Slave or listners receive CMD acknowledge *//
            {
                sscanf(strtok (NULL,","), "%u", &rcvd_ADDR);
                sscanf(strtok (NULL,","), "%u", &ack);    //e.g $R req or $K ack;
                resp_HB(2);
            }
            else
                __nop();
        }
        else
            __nop();
    }
}

 
int main() {
  int count = 0;
  addr_ID = 3;
  rcvd_ADDR = err_Status = err_Status = 0;
  valid = 'V';
  cmd = 0;
  req = 0;
  ack = 0;
  ach_M = 0;
  ach_S = 0;
  num_bytes = 0;
  CMD_key =false;
  _UART.baud(4800);
  wait_ms(1);
  _UART.format(8,SerialBase::None,1);
  wait_ms(1);
  _UART.attach(&read_SERIAL,SerialBase::RxIrq);
    wait_ms(1);
  Drive_En = 1; 
  _UART.printf("Hello World !\n");
  Drive_En = 0;
  wait_ms(1.5);
  myled = 1;
  
  while(1) 
  { 
    if ((!button) && (count <= 100))                       //
    {
        count = 200;
        CMD_key = true;
        Drive_En = 1; 
        _UART.printf("Hello World !\n");
        Drive_En = 0;
        wait_ms(1.5);
    }
    else if(button)
    {
        count =0;
        Drive_En = 0;
    }
    else
        __nop();
  }
}
 