#include "mbed.h"
#include "MCP23S17.h"
#include "pindefine.h"

Serial pc(USBTX,USBRX);

SPI _SPI3(SPI3_MOSI, SPI3_MISO, SPI3_SCK);  //for keyscan  mcp23s17

MCP23S17 mcp23s17_1(1,_SPI3, SPI3_CS1,SPI3_RST);  //class MCP23S17 object instance for mcp23s17 IC-1 key detection
MCP23S17 mcp23s17_2(2,_SPI3, SPI3_CS2,SPI3_RST);  //class MCP23S17 object instance for mcp23s17 IC-2 key detection

//interrupts definations
InterruptIn int_A(INT_A);       //8commands
InterruptIn int_B(INT_B);       //4  3commands+1ack
InterruptIn int_C(INT_C);       //4(3 controls(INC+,DEC-,TEST)+1 req) enbaled for all

enum AddrID
{
    eot_Master = 1,
    eot_Submaster,
    eot_Slave_MCR,
    eot_Slave_ER,
    eot_Listner_WP,
    eot_Listner_WS,
    eot_Listner_OPS,
    eot_Listner_ASP = 8
};

enum pin_STATUS
{
    _OFF =0,
    _ON =1
};

enum KEY
{
        FH=0,
        HH,
        SH,
        DSH,
        FS,
        HS,
        SS,
        DSS,
        STOP,
        STBY,
        FWE,
        FALSE0 = 11
};
enum KEY key_ID; 

enum CTRL
{
    REQ_ = 1,
    ACK_,
    FALSE1 = 3
};
enum CTRL ctrl_ID;

enum CHANNEL
{ 
    ch_A=1,
    ch_B,
    ch_C,
    ch_D=4
};          //keyscan channelA,B,C,Dof MCP23s17 1& 2 respectively
enum CHANNEL ch;

int cmd,req,ack;

class LED{
public:
    LED(PinName led);                                 //constructor declaration
    void set_Brightness(float bright);
    void ON();
    void OFF();
    void FLASHH();
private:
    Ticker _flash;
    bool on_off;
    bool Fllash;
    float brightness;
    PwmOut _LED;    
    void __flash();
};
LED::LED(PinName led): _LED(led)                         //constructor defination
{
    brightness = 0.000;
    on_off = false;
    Fllash = false;
    _LED = brightness;
}

void LED::set_Brightness(float bright)
{
    brightness = bright;
    if(!Fllash)
        _LED = bright;
    else
        __nop();
}

void LED::ON()
{
    _LED = brightness;
    Fllash = false;
    _flash.detach();
}

void LED::OFF()
{
    _LED = 0;
    Fllash = false;
    _flash.detach();
}

void LED::FLASHH()
{
    Fllash = true;
    _flash.attach(callback(this, &LED::__flash),0.5);
}

void LED::__flash()
{
    if(on_off)
        _LED = brightness;
    else
        _LED = 0;
    
    on_off = !on_off;
}

LED LED_CMD[9] = {_FH,_HH,_DSH,_FS,_HS,_SS,_DSS,_STOP,_STBY};    //ack and req exchanged

LED LED_CTRL[2] = {_REQ,_ACK};
LED LED_ACH[8] = {_WH,_BRDG,_MCR,_ER,_WP,_WS,_OPS,_ASP};

void CMD_handler(uint8_t CMD_ID)                             //function sacnning all the 11 command keys
{  
    if(CMD_ID != FALSE0)
        {
            cmd = CMD_ID;                                                                               //new cmd data updated any value between 1 to 11
            LED_CMD[cmd].FLASHH();
            wait_ms(10);
        }
    else
        __nop();
}

void CTRL_handler(uint8_t CTRL_ID)                        //handle  control transfer 
{
    if(CTRL_ID != FALSE1)
    {
        
            if(CTRL_ID == REQ_)
            {   
                req = REQ_;                     //req data updated 0 here, same int values as in enum
                LED_CTRL[REQ_-1].FLASHH();
            }
            else
                __nop();
            if(CTRL_ID == ACK_)
            {
                ack = ACK_;                     //ack data updated 2 here
                LED_CTRL[ACK_-1].FLASHH();
            }
            else
                __nop();
    }
    else 
        __nop(); //then do nothing
}

unsigned char read_KEY_SPI(int CH)
{
    char _key;
    uint8_t spi_err=0;
    switch(CH)
    {
        case 1:
        if(spi_err<3)
        {
            _key=mcp23s17_1.gpioa();                   // read(INTCAPA_ADDR);
            //if(mcp23s17_1.intcapa())                          //read(INTCAPA_ADDR)) again if some non zero value obtained           //if Interrupt pending
             //   {
            //        spi_err++;
             //   }
           // else
            //    {
            //        spi_err=0;
            //    }
        }
        else
        { 
            _key=0;
            LED_ACH[1].FLASHH();
        }
        break;
        
        case 2:
        if(spi_err<3)
        {
            _key=mcp23s17_1.gpiob();
           // if(mcp23s17_1.intcapb())             //if Interrupt pending
           //     {
          //          spi_err++;
          //      }
          //  else
           //     {
           //         spi_err=0;
           //     }
        }
        else
        {   
            _key=0;
        }
        break;
        
        case 3:
        if(spi_err<3)
        {
            _key=mcp23s17_2.gpioa();
           // if(mcp23s17_2.intcapa())            //if Interrupt pending
            //    {
            //        spi_err++;
            //    }
           // else
           //     {
           //         spi_err=0;
            //    }
        }
        else
        {   
            _key=0;
        }
        break;
        
        case 4:
        _key = mcp23s17_2.gpiob(); //address read PORTB of chip2
        break;
        default:
        _key = 0;
        break;
    }
    return(_key);
}
void read_KEY_A()                                 //PORTA of MCP23s17(1) for FH to DSS
{
    char key_status = 0;
    key_status = read_KEY_SPI(ch_A);    //to read portA of mcp23s17(1)
    pc.printf("PORTA button pressed == %d\n",key_status);
    wait_ms(2);
        switch(key_status)
        {
            case 0xfe:               //0xfe  GPA0
                key_ID = FH;
            break;
            case 0xfd:               //0xfe  GPA0
                key_ID = HH;
            break;
            case 0xfb:               //0xfe  GPA0
                key_ID = SH;
            break;
            case 0xf7:               //0xfe  GPA0
                key_ID = DSH;
            break;
            case 0xef:               //0xfe  GPA0
                key_ID = FS;
            break;
            case 0xdf:               //0xfe  GPA0
                key_ID = HS;
            break;
            case 0xbf:               //0xfe  GPA0
                key_ID = SS;
            break;
            case 0x7f:               //0xfe  GPA0
                key_ID = DSS;
            break;
            default:
                key_ID = FALSE0;
            break;
        }
        CMD_handler(key_ID);
}

void read_KEY_B()                          //PORTB of MCP23s17(1) to read STOP,STBY,FWE and ACK keys
{
    char key_status = 0;
    key_status = read_KEY_SPI(ch_B);   //to read portBof mcp23s17(1)
    pc.printf("PORTB button pressed == %d\n",key_status);
    wait_ms(2);
    if(key_status != 0xff)
    {   
        if(key_status==0xf7)
        {
            ctrl_ID = ACK_;               //control ACK button pressed
            CTRL_handler(ctrl_ID);
        }
        else
        {
            if(key_status == 0xfe)
                key_ID = STOP;
            else if(key_status == 0xfd)
                key_ID = STBY;
            else if(key_status == 0xfb)
                key_ID = FWE;
            else
            {
                key_ID = FALSE0;
                ctrl_ID = FALSE1;
            }
            CMD_handler(key_ID);
        }
    }
}
void read_KEY_C()                            // PORTA of MCP23s17(2) to read REQ,INC,DEC and TEST keys
{
    char key_status = 0;
    key_status = read_KEY_SPI(ch_C);   //to read portA of mcp23s17(2)
    pc.printf("PORTC button pressed == %d\n",key_status);
    if(key_status != 0xff)
    {
        if(key_status==0xfe)
        {
            ctrl_ID = REQ_;                    //control transfer REQ button pressed
            CTRL_handler(ctrl_ID);
        }
        else
        {
            __nop();
            /*
            if(key_status==0xfd)
                set_ID = INC;                     //setting key INC
            else if(key_status==0xfb)
                set_ID = DEC;                      //setting key DEC
            else if(key_status==0xf7)
                set_ID = TEST;                       //setting key TEST
            else 
            {  
                set_ID = FALSE2;                       //setting key TEST
                ctrl_ID = FALSE1;
            }
            
            SET_handler(set_ID);
            */
        }
    }
}
void mcp23s17_init()
{
    //device1 configuration
    mcp23s17_1.reset();           //reset on power-up
    wait_ms(1);
    mcp23s17_1.iodira(0xff);     //set 8-bits PORTA as inputs
    wait_ms(1);
    mcp23s17_1.iodirb(0xff);    //set 8-bits PORTb as inputs
    wait_ms(1);
    mcp23s17_1.ipola(0x00);
    wait_ms(1);
    mcp23s17_1.ipolb(0x00);
    wait_ms(1);
    mcp23s17_1.gpintena(0xff);
    wait_ms(1);
    mcp23s17_1.gpintenb(0xff);
    wait_ms(1);
    mcp23s17_1.defvala(0xff);
    wait_ms(1);
    mcp23s17_1.defvalb(0xff);
    wait_ms(1);
    mcp23s17_1.intcona(0xff);     //bank0,mirror disabled, SEQOP disabled, slew rate disabled,HAEN enabled,open drain enabled,interrupt active high,not allowed
    wait_ms(1);
    mcp23s17_1.intconb(0xff);
    wait_ms(1);
    mcp23s17_1.gppua(0xff);
    wait_ms(1);
    mcp23s17_1.gppub(0xff);
    wait_ms(1);
    
 
    
    //device2 configuration
    mcp23s17_2.reset();           //reset on power-up
    wait_ms(1);
    mcp23s17_2.iodira(0xff);     //set 8-bits PORTA as inputs
    wait_ms(1);
    mcp23s17_2.iodirb(0xff);    //set 8-bits PORTb as inputs
    wait_ms(1);
    mcp23s17_2.ipola(0x00);
    wait_ms(1);
    mcp23s17_2.ipolb(0x00);
    wait_ms(1);
    mcp23s17_2.gpintena(0xff);
    wait_ms(1);
    mcp23s17_2.gpintenb(0x00);      //interrupts disabled for address PORT
    wait_ms(1);
    mcp23s17_2.defvala(0xff);
    wait_ms(1);
    mcp23s17_2.defvalb(0xff);
    wait_ms(1);
    mcp23s17_2.intcona(0xff);    //bank0,mirror disabled, SEQOP disabled, slew rate disabled,HAEN enabled,open drain enabled,interrupt active high,not allowed
    wait_ms(1);
    mcp23s17_2.intconb(0xff);
    wait_ms(1);
    mcp23s17_2.gppua(0xff);
    wait_ms(1);
    mcp23s17_2.gppub(0xff);
    wait_ms(1);
}

void Spi3_Init()              //for mcp23s17
{
  _SPI3.format(8,0);         //8bit,mode 0
  _SPI3.frequency(1000000);  //1mhz   
}

void Led_Init()
{   
  
    for(uint8_t i=0;i<=8;i++)          //cmd led initialisation
    {
        LED_CMD[i].set_Brightness(1);        //setting period 100 ms
        wait_ms(1);
    }
    for(uint8_t i=0;i<=1;i++)         //ctrl led intialisation
    {
        LED_CTRL[i].set_Brightness(1);
        wait_ms(1);
    }
    for(uint8_t i=0; i<=7;i++)            //ach led initialisation
    {
        LED_ACH[i].set_Brightness(1);
        wait_ms(1);
    }
    
    for(uint8_t i=0;i<=8;i++)          //cmd led initialisation
    {
        LED_CMD[i].ON();                  //duty cycle 10%
        wait_ms(1);
    }
    for(uint8_t i=0;i<=1;i++)             //ctrl led intialisation
    {
        LED_CTRL[i].ON();
        wait_ms(1);
    }
    for(uint8_t i=0; i<=7;i++)            //ach led initialisation
    {
        LED_ACH[i].ON(); 
        wait_ms(1);
    } 
    
    wait(1);

    
    /* turning all leds OFF*/
    
    
    for(uint8_t i=0;i<=8;i++)          //cmd led initialisation
    {
        LED_CMD[i].OFF();                  //duty cycle 10%
        wait_ms(1);
    }
    for(uint8_t i=0;i<=1;i++)         //ctrl led intialisation
    {
        LED_CTRL[i].OFF();
        wait_ms(1);
    }
    for(uint8_t i=0; i<=7;i++)            //ach led initialisation
    {
        LED_ACH[i].OFF(); 
        wait_ms(1);
    } 
}

int main() 
{
    char key_status = 0;
    Led_Init();
    wait_ms(10); 
    Spi3_Init();
    wait_ms(10); 
    mcp23s17_init();
    wait(1);
       
    int_A.fall(&read_KEY_A);              //all key functions enabled for PORTA,B,C    
    wait_ms(2);    
    int_B.rise(&read_KEY_B);  
    wait_ms(2);              
    int_C.rise(&read_KEY_C);
    wait_ms(2);
        pc.printf("hello deep\n");
    wait_ms(10);                          //this delay is important
   // LED_CMD[1].FLASHH();                  //duty cycle 10%
    //LED_ACH[1].FLASHH();                  //test led
    key_status = read_KEY_SPI(ch_D);    //to read portA of mcp23s17(1)
    if(key_status == 0xfe)
        pc.printf("master eot\n");
    wait_ms(10);
        LED_ACH[1].FLASHH();
     wait_ms(10);
    while(1){
       
    }
}