#include "mbed.h"
#include <vector>
#include <string>
#include <list>
#include "Logger.h"
#include "Alarm.h"

InterruptIn ServiceBryter(p15);

Logger GlobalLogger;

std::vector<Alarm*> alarmList;

Serial pc(USBTX, USBRX);
Ticker DriftLoopTicker;
DigitalOut NORMAL(p25);
void DriftLoop(void);
bool gAlarmAktiv = false;

void komandoTolker(char komando);
void alarmOppsett();

void NullstillAlarm()
{
    GlobalLogger.Logg("Alarmen ble deaktivert");
    for (int i = 0; i < alarmList.size(); i++) {
        alarmList[i]->Reset();
    }
    gAlarmAktiv = false;
}
void enkeltstatus(int alarmNummer);
void totalstatus();
void resetstatus();

bool locked = true;

char s[256];
void readString() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    
    int i = 0;
    while(i < 255) {
        s[i] = pc.getc();
        if (s[i] == 0x0D) {
            printf("\n\r");
            s[i] = '\0';
            break;
        }
        printf("%c", s[i]);
        i++;
    }
    
    bool riktigPass = true;
    char pass[8] = "passord";
    for (int i = 0; i < 8; i++) {
        if (pass[i] != s[i])
            riktigPass = false;
    }
    //printf("%s\n\r", s);
    if (!locked) {
        komandoTolker(s[0]);
    }
    else if (riktigPass == true) {      
        locked = false;
        printf("Alarm er naa ulaast\n\r");
    }
    else
        printf("Ugyldig passord\n\r");

}

void komandoTolker(char komando)
{
    //char komando;
    //pc.scanf("%s", &komando);
    //Liste over komandoer:
    //Totalstatus  - skriver ut status på alle soner
    //Sone# staus -skriver ut status på enkeltsone
    if(komando == 't') {
        printf("Totaloversikt:\n\r");
        totalstatus();
    }
    else if (komando == '1')
        enkeltstatus(1);
    else if (komando == '2')
        enkeltstatus(2);
    else if (komando == '3')
        enkeltstatus(3);
    else if (komando == '4')
        enkeltstatus(4);
    else if (komando == '5')
        enkeltstatus(5);
    else if (komando == '6')
        enkeltstatus(6);
    else if (komando == '7')
        enkeltstatus(7);
    else if (komando == '8')
        enkeltstatus(8);
    else if (komando == 'r') {
        NullstillAlarm();
        printf("Alarm resatt\n\r");
        resetstatus();
    }
    else if (komando == 'p') {
        locked = true;
        printf("Enheten er naa passordbeskyttet\n\r");
    }
    else if (komando == 'h') {
        printf("Skriv \"t\" for totaloversikt\n\r");
        printf("Skriv et tall mellom 1 og 8 for enkelt alarmer\n\r");
        printf("Skriv \"r\" for aa resette alarm\n\r");
        printf("Skriv \"p\" for aa aktivere passordbeskyttelse\n\r");
    }
    else
        printf("Ugyldig komando: Trykk \"h\" for hjelp\n\r");
    
}

void enkeltstatus (int alarmNummer)
{
    printf("Alarm %d er: ", alarmNummer);
    if (alarmList[alarmNummer - 1]->AlarmTest() == true) {
        printf("Aktiv\n\r");
    }
    else {
        printf("Inaktiv\n\r");
    }
}


void totalstatus()
{
    for(int i = 0; i < alarmList.size(); i++) {
        printf("Alarm %d er: ", i + 1);
        if (alarmList[i]->AlarmTest() == true) {
            printf("Aktiv\n\r");
        }
        else {
            printf("Inaktiv\n\r");
        }
    }
}

void resetstatus()
{
    bool ingenAlarmerInaktiv = true;
    for(int i = 0; i < alarmList.size(); i++) {
        if (alarmList[i]->AlarmTest() == true) {
            printf("Alarm %d er: Aktiv\n\r", i+1);
            ingenAlarmerInaktiv = false;
        }
    }
    if (ingenAlarmerInaktiv == true)
        printf("Normal drift\n\r");
}

int main() 
{
    alarmOppsett();
    
    ServiceBryter.rise(&NullstillAlarm);
    pc.attach(&readString);
    DriftLoopTicker.attach(&DriftLoop, 0.05);
    
    while(1) {
        for (int i = 0; i < alarmList.size(); i++) {
            if (alarmList[i]->AlarmTest()) {
                alarmList[i]->LEDSet(1);
                gAlarmAktiv = true;
            }
            //else 
                //alarmList[i]->LEDSet(0);
        }
        //printf("\n\r%f", alarmList[0]->AlarmVoltage());
        wait(0.2);
    }
}

void DriftLoop(void)
{
    if (gAlarmAktiv)
        NORMAL = !NORMAL;
    else
        NORMAL = 0;
}

void alarmOppsett()
{
    Alarm * Sone1 = new Alarm("Sone1", p17, LED1);
    alarmList.push_back(Sone1);
    Alarm * Sone2 = new Alarm("Sone2", p17, LED2);
    alarmList.push_back(Sone2);
    Alarm * Sone3 = new Alarm("Sone3", p18, LED3);
    alarmList.push_back(Sone3);
    Alarm * Sone4 = new Alarm("Sone4", p18, LED4);
    alarmList.push_back(Sone4);
    Alarm * Sone5 = new Alarm("Sone5", p19, p21);
    alarmList.push_back(Sone5);
    Alarm * Sone6 = new Alarm("Sone6", p19, p22);
    alarmList.push_back(Sone6);
    Alarm * Sone7 = new Alarm("Sone7", p20, p23);
    alarmList.push_back(Sone7);
    Alarm * Sone8 = new Alarm("Sone8", p20, p24);
    alarmList.push_back(Sone8);
    
    for (int i = 4; i < alarmList.size(); i++) { alarmList[i]->LEDInverted(true); }
    
    for (int i = 0; i < alarmList.size(); i++) {
        if (i & 1) 
            alarmList[i]->AlarmVoltageAdd(0.6166);
        else 
            alarmList[i]->AlarmVoltageAdd(0.5);
        alarmList[i]->AlarmVoltageAdd(0.3815);
        for (int j = 1; j < 8; j++) { //får ledene til å blinke (fancy oppstart)
            alarmList[i]->LEDSet(j & 1);
            wait(0.01);
        }
        wait(0.01);
    }
    for (int i = 0; i < alarmList.size(); i++) {
        alarmList[i]->LEDSet(0);
    }
}
