#pragma once

#include "mbed.h"
#include <string>
#include <ctime>

LocalFileSystem local("local");

class Logger
{
public:
    Logger()
    {
        oppstartstid = time(NULL);
        logFile = fopen("/local/Logg.txt", "a");
        if (logFile == NULL) { // vis en error
            return;
        }
        fprintf(logFile, "\nStarting up system\n");
        fflush(logFile);
        wait(0.1);
        fclose(logFile);
    }
    ~Logger() {
        if (logFile)
            fclose(logFile);
    }
    
    void Logg(const std::string &melding) 
    {
      logFile = fopen("/local/Logg.txt", "a");
        if (logFile == NULL) { // vis en error
            return;
        }
        int tid = time(NULL) - oppstartstid;
        fprintf(logFile, "Tid: %d\t\t", tid);
        fputs(melding.c_str(),logFile);
        fputs("\n", logFile);
        fflush(logFile);
        wait(0.1);
        fclose(logFile);
        return;
    }
    

private:
    FILE * logFile;
    time_t oppstartstid;
};

