#include "mbed.h"
#include <vector>
#include <string>
#include <list>
#include "Logger.h"

extern Logger GlobalLogger;

class Alarm {
private:
    std::string alarmNavn; 
    std::vector<float> AlarmSpenninger;
    AnalogIn port;
    DigitalOut led;
    float feilmargin;
    bool LEDInvertStatus;
    bool alarmLogged;
        
public:
    Alarm(std::string alarmNavn, PinName portIn, PinName ledOut)
    : alarmNavn(alarmNavn), port(portIn), led(ledOut), feilmargin(0.05), LEDInvertStatus(false), alarmLogged(false)
    {
    }
    ~Alarm()
    {
    }
    void AlarmVoltageAdd(float spenning) { 
        AlarmSpenninger.push_back(spenning); 
    }
    void AddCurrentAlarmVoltage(void) {
        AlarmVoltageAdd(AlarmVoltage());
    }
    void AlarmVoltageCLearAll() {
        AlarmSpenninger.clear();
    }
    float AlarmVoltage (void) {
        return port.read();
    }
    void LEDSet(bool value) {
        if (LEDInvertStatus) led.write(!value);
        else led.write(value);
    }
    void LEDInverted(bool value) {
        LEDInvertStatus = value;
    }
    bool AlarmTest() {
        return test();
    }
    void Reset() {
        LEDSet(0);
        alarmLogged = false;
    }
    
    
private:    
    bool test() {
        bool resultat = false;        
        float portSpenning = port.read();
        for (int i = 0; i < AlarmSpenninger.size(); i++) {
            if (portSpenning + feilmargin > AlarmSpenninger[i] && portSpenning - feilmargin < AlarmSpenninger[i]) {
                resultat = true;
            }
        }
        if (resultat && !alarmLogged) {
            alarmLogged = true;
            std::string melding = alarmNavn + " ble aktivert!";
            GlobalLogger.Logg(melding);
        }
        return resultat;
    }

};
