#include <string.h>
#include "mbed.h"
#include "mantis_comms.h"
#include "commands.h"
#include "mantis_stepper.h"

#define PUBLIC  /* empty */
#define PRIVATE static

PRIVATE char buffer[64];

PRIVATE char* dtos(double var) {
    sprintf(buffer, "%g", var);
    return buffer;  // returns a pointer to buffer.
}

PRIVATE Timer timer1;


MantisComms *TitaniumLink;
PRIVATE mantis_stepper *Stepper;

void SetPosition(long index,long pos)
{
Stepper->SetTargetPosition(index,pos);
}


void SetSpeedMode(long index,long dir)
{
Stepper->MoveSpeedMode(0,dir);
}
void SetPosMode(long index)
{
//Stepper->SetPositionMode(index);
}

void StepperTest(long index)
{
//Stepper->StopInstant(0);    
Stepper->StopRamped(0);    
return;

Stepper->SetTargetPosition(index,0);
wait(1.5);

Stepper->SetTargetPosition(index,3000);
wait(0.7);
TitaniumLink->serialSend(dtos(Stepper->GetAbsPosition(0)),1);

Stepper->SetTargetPosition(index,1200);

return;

Stepper->SetTargetPosition(index,0);
wait(1);

Stepper->SetTargetPosition(index,300);
wait(0.21);
Stepper->SetTargetPosition(index,1300);
wait(0.25);
TitaniumLink->serialSend(dtos(Stepper->GetAbsPosition(0)),1);

Stepper->SetTargetPosition(index,520);


}


int main() {
    wait(0.1);
    timer1.start();
long speed=100000L;    
    TitaniumLink=new MantisComms(&runTitaniumCommand,PA_2,PA_3);
    
    Stepper= new  mantis_stepper(speed,1,PC_3);
    Stepper->AddMotor(PD_2,PA_0,50000,5000);
//    Stepper->AddMotor(PD_2,PA_0,10000,5000);

/*
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    Stepper->AddMotor(PC_9,PA_12,speed,speed);
    
    Stepper->SetSpeedMode(1,10);
    Stepper->SetSpeedMode(2,10);
    Stepper->SetSpeedMode(3,10);
    Stepper->SetSpeedMode(4,10);
    Stepper->SetSpeedMode(5,10);
    Stepper->SetSpeedMode(6,10);
    Stepper->SetSpeedMode(7,10);
*/
    
//    Stepper->AddMotor(PD_2,PA_0,50000L,50000L);
//    Stepper->AddMotor(PD_2,PA_0,50L,20L);
    Stepper->ZeroHome(0);
 //  Stepper->SetTargetPosition(0,100000L);
    
    while(1)
        {
        if(timer1.read_ms()>10)// 
            {
            timer1.reset();
            TitaniumLink->processComms();// parses the incomming commands from Titanium and calls runTitaniumCommand
            }   
        }
}

