/*
 * These commands aren't just for serial comms, the ones without serialSend can be called by the interface module as well
 */
#include "mantis_stepper.h"
#include "mbed.h"
#include "commands.h"
#include "mantis_comms.h"
#include <math.h>
#include <string.h>
#include <stdio.h>

#define COMMAND if(!strcmp(
#define ACTION  ,s))
#define convert (1.024/32767)
#define coefa ((float)0.1)//0.5
#define coefb ((float)0.05)

PRIVATE char buffer[64];

PRIVATE char* dtos(double var) {
    sprintf(buffer, "%g", var);
    return buffer;  // returns a pointer to buffer.
}

void SetPosition(long index,long pos);
void StepperTest(long index);
void SetSpeedMode(long index,long dir);
void SetPosMode(long index);



PRIVATE MantisComms *TitaniumLink; // keeping a reference to the comms interfaces here, allows them to inter-communicate



void TitaniumSend(const char *s)
{
TitaniumLink->serialSend(s,1);
}


/*This is the function that is "called back" from the manti_comms code. It's address is passed to the constructor:
  MantisComms::MantisComms(void (*CallBack)(const char *, double,const char *sPram,MantisComms *),PinName Tx,PinName Rx) */
PUBLIC void runTitaniumCommand(const char *s, double p,const char *sParam,MantisComms *TitaniumComms) {
/*    
s points to a string that contains any chars after the "=", or else \0    
p contains any numeric parameter after the "=" interpreted as a double
sParam points to a string that contains any params after the "="
*/

    COMMAND "D?" ACTION  {TitaniumComms->serialSend("123456",1);return;}                   else       //Return serial number
    COMMAND "FW?" ACTION  {TitaniumComms->serialSend("1.0",1);return;}                     else       //Return firmware version
    COMMAND "HW?" ACTION  {TitaniumComms->serialSend("1.0",1);return;}                     else       //Return hardware version
    COMMAND "ver?"  ACTION  {TitaniumComms->serialSend("1.1", 1);return;} 
    COMMAND "POS="  ACTION  {SetPosition(0,p);return;} 
    COMMAND "SPEEDMODE="  ACTION  {SetSpeedMode(0,p);return;} 
    COMMAND "POSMODE?"  ACTION  {SetPosMode(0);return;} 
    COMMAND "TEST?"  ACTION  {StepperTest(0);return;} 



}






