#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 18 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_BOLD_18
#define RB_LV_FONT_ROBOTO_BOLD_18 1
#endif

#if RB_LV_FONT_ROBOTO_BOLD_18

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xdf, 0xdc, 0xfc, 0xcf, 0xcb, 0xfb, 0xbf, 0xba,
    0xfa, 0xaf, 0xa9, 0xf9, 0x9f, 0x91, 0x21, 0x5b,
    0x5d, 0xfd, 0x8f, 0x80,

    /* U+22 "\"" */
    0x7f, 0x59, 0xf3, 0x7f, 0x59, 0xf2, 0x7f, 0x39,
    0xf1, 0x7f, 0x29, 0xf0, 0x6f, 0x9, 0xe0,

    /* U+23 "#" */
    0x0, 0x0, 0xea, 0x9, 0xf0, 0x0, 0x0, 0x2f,
    0x70, 0xdc, 0x0, 0x0, 0x5, 0xf3, 0xf, 0x80,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xf6, 0x7, 0x9e,
    0xe9, 0xcf, 0xa9, 0x30, 0x0, 0xdb, 0x8, 0xf0,
    0x0, 0x0, 0xf, 0x90, 0xae, 0x0, 0x0, 0x1,
    0xf7, 0xd, 0xc0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xfb, 0x3, 0x9c, 0xf9, 0xaf, 0xb9, 0x60, 0x0,
    0x9f, 0x5, 0xf4, 0x0, 0x0, 0xc, 0xc0, 0x7f,
    0x10, 0x0, 0x0, 0xf9, 0xa, 0xe0, 0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x20, 0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0,
    0x2b, 0xff, 0xe9, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xb0, 0x8, 0xff, 0x40, 0x9f, 0xf3, 0xa, 0xfd,
    0x0, 0x2f, 0xf6, 0x9, 0xff, 0x30, 0x1, 0x10,
    0x2, 0xff, 0xf9, 0x20, 0x0, 0x0, 0x3d, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x5c, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x8f, 0xf4, 0x1f, 0xf6, 0x0, 0x1f,
    0xf6, 0xe, 0xfc, 0x10, 0x6f, 0xf5, 0x6, 0xff,
    0xfe, 0xff, 0xd0, 0x0, 0x6e, 0xff, 0xfb, 0x20,
    0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x0,

    /* U+25 "%" */
    0x3, 0xcf, 0xd5, 0x0, 0x0, 0x0, 0x0, 0xee,
    0x8d, 0xf2, 0x0, 0x60, 0x0, 0x2f, 0x80, 0x5f,
    0x50, 0x9f, 0x10, 0x1, 0xfb, 0x18, 0xf4, 0x3f,
    0x60, 0x0, 0xa, 0xff, 0xfd, 0x1d, 0xc0, 0x0,
    0x0, 0x4, 0x75, 0x8, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x2b, 0xfd, 0x60, 0x0, 0x0, 0x6f, 0x3c,
    0xf9, 0xdf, 0x30, 0x0, 0x1f, 0x90, 0xfa, 0x3,
    0xf7, 0x0, 0xb, 0xe1, 0xf, 0xb0, 0x3f, 0x70,
    0x0, 0x75, 0x0, 0xcf, 0x9c, 0xf3, 0x0, 0x0,
    0x0, 0x1, 0xbf, 0xd6, 0x0,

    /* U+26 "&" */
    0x0, 0x19, 0xef, 0xb3, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xfe, 0x10, 0x0, 0x2, 0xff, 0x63, 0xdf,
    0x60, 0x0, 0x3, 0xff, 0x10, 0xcf, 0x60, 0x0,
    0x0, 0xff, 0x89, 0xfe, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xd2, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x30,
    0x27, 0x60, 0xa, 0xff, 0xdf, 0xe1, 0x7f, 0xc0,
    0x3f, 0xf6, 0x2e, 0xfc, 0xcf, 0x90, 0x5f, 0xf3,
    0x3, 0xff, 0xff, 0x50, 0x3f, 0xfa, 0x0, 0xaf,
    0xfd, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x6c, 0xfe, 0xc7, 0xbf, 0xf3,

    /* U+27 "'" */
    0x7f, 0x67, 0xf6, 0x7f, 0x57, 0xf4, 0x7f, 0x30,

    /* U+28 "(" */
    0x0, 0x1, 0x40, 0x2, 0xed, 0x0, 0xdf, 0x30,
    0x7f, 0x80, 0xe, 0xf1, 0x4, 0xfc, 0x0, 0x8f,
    0x80, 0xb, 0xf6, 0x0, 0xdf, 0x50, 0xe, 0xf4,
    0x0, 0xdf, 0x40, 0xc, 0xf5, 0x0, 0xaf, 0x70,
    0x6, 0xfa, 0x0, 0x1f, 0xe0, 0x0, 0xbf, 0x40,
    0x2, 0xfd, 0x0, 0x7, 0xfa, 0x0, 0x7, 0xa0,
    0x0, 0x0,

    /* U+29 ")" */
    0x23, 0x0, 0x0, 0x8f, 0x60, 0x0, 0x1d, 0xf3,
    0x0, 0x3, 0xfd, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x7f, 0xb0, 0x0, 0x4f, 0xf0, 0x0, 0x1f, 0xf2,
    0x0, 0xf, 0xf4, 0x0, 0xf, 0xf5, 0x0, 0xf,
    0xf4, 0x0, 0xf, 0xf3, 0x0, 0x2f, 0xf1, 0x0,
    0x5f, 0xd0, 0x0, 0xaf, 0x80, 0x0, 0xff, 0x10,
    0x8, 0xf8, 0x0, 0x5f, 0xc0, 0x0, 0x6b, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x6a, 0x38, 0xe1, 0x78, 0x8, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x6f, 0xfa, 0x30, 0x0, 0xc,
    0xed, 0xd1, 0x0, 0x9, 0xf6, 0x3f, 0xb0, 0x0,
    0x3a, 0x0, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+2B "+" */
    0x0, 0x3, 0x99, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x10, 0x0, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0,
    0x5, 0xff, 0x10, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x8f, 0xff, 0xff, 0xff, 0xf4, 0x25, 0x58,
    0xff, 0x65, 0x51, 0x0, 0x5, 0xff, 0x10, 0x0,
    0x0, 0x5, 0xff, 0x10, 0x0, 0x0, 0x5, 0xff,
    0x10, 0x0,

    /* U+2C "," */
    0xc, 0xf5, 0xc, 0xf5, 0xd, 0xf4, 0x1f, 0xf0,
    0x7f, 0x70, 0x5, 0x0,

    /* U+2D "-" */
    0x2, 0x22, 0x21, 0xf, 0xff, 0xfe, 0xf, 0xff,
    0xfe,

    /* U+2E "." */
    0x5b, 0x6d, 0xfe, 0x7f, 0x90,

    /* U+2F "/" */
    0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0xe, 0xf0,
    0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0, 0x8f, 0x50,
    0x0, 0x0, 0xdf, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x8, 0xf5, 0x0, 0x0, 0xd, 0xf1, 0x0,
    0x0, 0x2f, 0xb0, 0x0, 0x0, 0x7f, 0x60, 0x0,
    0x0, 0xdf, 0x10, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x7, 0xf6, 0x0, 0x0, 0xc, 0xf1, 0x0, 0x0,
    0x7, 0x60, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x2b, 0xff, 0xc5, 0x0, 0x2, 0xff, 0xff,
    0xff, 0x60, 0xa, 0xff, 0x53, 0xcf, 0xf0, 0xf,
    0xf9, 0x0, 0x4f, 0xf4, 0x1f, 0xf6, 0x0, 0x1f,
    0xf6, 0x2f, 0xf6, 0x0, 0x1f, 0xf7, 0x2f, 0xf6,
    0x0, 0x1f, 0xf7, 0x2f, 0xf6, 0x0, 0x1f, 0xf7,
    0x1f, 0xf6, 0x0, 0x1f, 0xf6, 0xf, 0xf9, 0x0,
    0x4f, 0xf4, 0xa, 0xff, 0x53, 0xcf, 0xf0, 0x2,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x2b, 0xff, 0xc5,
    0x0,

    /* U+31 "1" */
    0x0, 0x2, 0x8e, 0x1, 0x7d, 0xff, 0xf0, 0x8f,
    0xff, 0xff, 0x7, 0xb6, 0x9f, 0xf0, 0x0, 0x8,
    0xff, 0x0, 0x0, 0x8f, 0xf0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x8f, 0xf0, 0x0, 0x8, 0xff, 0x0,
    0x0, 0x8f, 0xf0, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x8f, 0xf0, 0x0, 0x8, 0xff, 0x0,

    /* U+32 "2" */
    0x0, 0x4b, 0xef, 0xc6, 0x0, 0x5, 0xff, 0xff,
    0xff, 0x90, 0xf, 0xfd, 0x33, 0xdf, 0xf1, 0x4f,
    0xf4, 0x0, 0x6f, 0xf3, 0x14, 0x40, 0x0, 0x7f,
    0xf1, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0x0,
    0xa, 0xff, 0x20, 0x0, 0x0, 0x9f, 0xf5, 0x0,
    0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x8f, 0xf7,
    0x0, 0x0, 0x7, 0xff, 0x91, 0x11, 0x11, 0x1f,
    0xff, 0xff, 0xff, 0xfa, 0x2f, 0xff, 0xff, 0xff,
    0xfa,

    /* U+33 "3" */
    0x0, 0x6c, 0xfe, 0xc6, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xa0, 0x2f, 0xfb, 0x23, 0xcf, 0xf1, 0x15,
    0x51, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x1, 0xbf,
    0xe0, 0x0, 0x8, 0xff, 0xfd, 0x30, 0x0, 0x8,
    0xff, 0xfe, 0x40, 0x0, 0x0, 0x2, 0xbf, 0xf1,
    0x0, 0x0, 0x0, 0x3f, 0xf6, 0x5d, 0xd2, 0x0,
    0x2f, 0xf6, 0x3f, 0xfc, 0x33, 0xcf, 0xf2, 0x9,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x6d, 0xff, 0xc6,
    0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x2f,
    0xff, 0x60, 0x0, 0x0, 0xcf, 0xff, 0x60, 0x0,
    0x6, 0xfe, 0xff, 0x60, 0x0, 0x1e, 0xf6, 0xff,
    0x60, 0x0, 0xaf, 0x92, 0xff, 0x60, 0x4, 0xfe,
    0x2, 0xff, 0x60, 0xd, 0xf5, 0x2, 0xff, 0x60,
    0x6f, 0xff, 0xff, 0xff, 0xfd, 0x7f, 0xff, 0xff,
    0xff, 0xfd, 0x1, 0x11, 0x13, 0xff, 0x71, 0x0,
    0x0, 0x2, 0xff, 0x60, 0x0, 0x0, 0x2, 0xff,
    0x60,

    /* U+35 "5" */
    0x1, 0xff, 0xff, 0xff, 0xf2, 0x3, 0xff, 0xff,
    0xff, 0xf2, 0x5, 0xff, 0x33, 0x33, 0x30, 0x6,
    0xfe, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xcf, 0xe9,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xb0, 0x4, 0x88,
    0x11, 0xaf, 0xf3, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xf, 0xf8, 0xe, 0xe7, 0x0,
    0x2f, 0xf7, 0xc, 0xff, 0x53, 0xbf, 0xf2, 0x3,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x2a, 0xef, 0xd6,
    0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x5b, 0xec, 0x0, 0x0, 0x1c, 0xff,
    0xfc, 0x0, 0x0, 0xcf, 0xf9, 0x42, 0x0, 0x6,
    0xff, 0x40, 0x0, 0x0, 0xc, 0xfc, 0xae, 0xfa,
    0x10, 0xf, 0xff, 0xff, 0xff, 0xd0, 0x1f, 0xff,
    0x52, 0xaf, 0xf5, 0x1f, 0xf7, 0x0, 0xf, 0xf8,
    0x1f, 0xf7, 0x0, 0xe, 0xfa, 0xe, 0xfa, 0x0,
    0xf, 0xf8, 0x9, 0xff, 0x62, 0xaf, 0xf3, 0x1,
    0xdf, 0xff, 0xff, 0xa0, 0x0, 0x19, 0xef, 0xd7,
    0x0,

    /* U+37 "7" */
    0x7f, 0xff, 0xff, 0xff, 0xf9, 0x7f, 0xff, 0xff,
    0xff, 0xf8, 0x1, 0x11, 0x11, 0x6f, 0xf2, 0x0,
    0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x2, 0xff,
    0x40, 0x0, 0x0, 0xa, 0xfd, 0x0, 0x0, 0x0,
    0x1f, 0xf6, 0x0, 0x0, 0x0, 0x8f, 0xf0, 0x0,
    0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0x7, 0xff,
    0x20, 0x0, 0x0, 0xe, 0xfb, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0xdf, 0xd0, 0x0,
    0x0,

    /* U+38 "8" */
    0x0, 0x3b, 0xef, 0xc6, 0x0, 0x4, 0xff, 0xff,
    0xff, 0x90, 0xc, 0xff, 0x42, 0xcf, 0xf1, 0xd,
    0xfb, 0x0, 0x5f, 0xf2, 0xa, 0xfe, 0x21, 0xbf,
    0xe0, 0x1, 0xcf, 0xff, 0xfe, 0x40, 0x1, 0xcf,
    0xff, 0xfe, 0x30, 0xb, 0xfe, 0x43, 0xbf, 0xf1,
    0x1f, 0xf7, 0x0, 0x2f, 0xf6, 0x2f, 0xf7, 0x0,
    0x2f, 0xf7, 0xe, 0xfe, 0x42, 0xbf, 0xf4, 0x6,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x4c, 0xff, 0xd7,
    0x0,

    /* U+39 "9" */
    0x0, 0x2a, 0xef, 0xb3, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x30, 0xc, 0xfe, 0x43, 0xef, 0xc0, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x3f, 0xf4, 0x0, 0x3f,
    0xf5, 0x2f, 0xf6, 0x0, 0x2f, 0xf6, 0xe, 0xfe,
    0x21, 0xaf, 0xf5, 0x7, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x6d, 0xfc, 0x9f, 0xf1, 0x0, 0x0, 0x0,
    0xbf, 0xc0, 0x0, 0x13, 0x5c, 0xff, 0x40, 0x0,
    0x5f, 0xff, 0xf6, 0x0, 0x0, 0x5f, 0xea, 0x30,
    0x0,

    /* U+3A ":" */
    0x8f, 0x8d, 0xfe, 0x5c, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xb5, 0xdf, 0xe8, 0xf9,

    /* U+3B ";" */
    0xa, 0xf6, 0xf, 0xfc, 0x7, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x31,
    0x9, 0xf9, 0x9, 0xf8, 0xa, 0xf6, 0xe, 0xf1,
    0x4f, 0x80, 0x2, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x5c, 0x0, 0x0, 0x17, 0xef,
    0xf0, 0x2, 0x9f, 0xff, 0xfb, 0x6, 0xff, 0xfd,
    0x71, 0x0, 0x8f, 0xfa, 0x10, 0x0, 0x4, 0xef,
    0xff, 0xb5, 0x0, 0x0, 0x5c, 0xff, 0xff, 0x0,
    0x0, 0x3, 0xaf, 0xf0, 0x0, 0x0, 0x0, 0x18,
    0x0,

    /* U+3D "=" */
    0xcf, 0xff, 0xff, 0xff, 0xc, 0xff, 0xff, 0xff,
    0xf0, 0x12, 0x22, 0x22, 0x22, 0x1, 0x22, 0x22,
    0x22, 0x20, 0xcf, 0xff, 0xff, 0xff, 0xc, 0xff,
    0xff, 0xff, 0xf0,

    /* U+3E ">" */
    0xb5, 0x0, 0x0, 0x0, 0xff, 0xe8, 0x10, 0x0,
    0xaf, 0xff, 0xfa, 0x30, 0x1, 0x6c, 0xff, 0xf9,
    0x0, 0x1, 0x8f, 0xfb, 0x4, 0xaf, 0xff, 0xe6,
    0xdf, 0xff, 0xd6, 0x0, 0xff, 0xb4, 0x0, 0x0,
    0x82, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x1, 0x9d, 0xfd, 0x80, 0x1, 0xef, 0xff, 0xff,
    0xc0, 0x7f, 0xf8, 0x2a, 0xff, 0x35, 0x99, 0x0,
    0x4f, 0xf4, 0x0, 0x0, 0x8, 0xff, 0x10, 0x0,
    0x7, 0xff, 0x70, 0x0, 0x5, 0xff, 0x80, 0x0,
    0x0, 0xcf, 0xa0, 0x0, 0x0, 0xd, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xb2,
    0x0, 0x0, 0x2, 0xff, 0x90, 0x0, 0x0, 0xc,
    0xe4, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x5, 0xbe, 0xfe, 0xb5, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xd9, 0x79, 0xcf, 0xc1, 0x0,
    0x0, 0x1e, 0xf5, 0x0, 0x0, 0x4, 0xed, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x3f, 0x70,
    0x3, 0xf9, 0x0, 0x2b, 0xfe, 0x80, 0xb, 0xe0,
    0x9, 0xf2, 0x2, 0xff, 0xad, 0xf5, 0x6, 0xf2,
    0xe, 0xd0, 0xb, 0xf5, 0x8, 0xf3, 0x3, 0xf4,
    0x1f, 0xa0, 0x1f, 0xd0, 0x9, 0xf2, 0x3, 0xf5,
    0x3f, 0x80, 0x5f, 0xa0, 0xb, 0xf0, 0x4, 0xf4,
    0x3f, 0x70, 0x6f, 0x80, 0xc, 0xf0, 0x6, 0xf2,
    0x2f, 0x80, 0x5f, 0xa0, 0x1f, 0xe0, 0xc, 0xd0,
    0xf, 0xb0, 0x1f, 0xf8, 0xde, 0xf9, 0xbf, 0x40,
    0xb, 0xf1, 0x5, 0xef, 0x82, 0xcf, 0xd5, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xa1, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xba, 0xac, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x4a, 0xdf, 0xec, 0x70, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x7f, 0xed, 0xf8,
    0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f, 0xe0, 0x0,
    0x0, 0x3, 0xff, 0x43, 0xff, 0x40, 0x0, 0x0,
    0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0, 0xe, 0xf9,
    0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f, 0xf2, 0x6,
    0xff, 0x50, 0x0, 0x3, 0xff, 0x80, 0xcf, 0xf0,
    0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+42 "B" */
    0xdf, 0xff, 0xff, 0xc7, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xc0, 0xdf, 0xd3, 0x34, 0xcf, 0xf3, 0xdf,
    0xc0, 0x0, 0x5f, 0xf5, 0xdf, 0xc0, 0x0, 0xaf,
    0xf1, 0xdf, 0xff, 0xff, 0xfe, 0x50, 0xdf, 0xff,
    0xff, 0xff, 0x80, 0xdf, 0xc0, 0x0, 0x8f, 0xf5,
    0xdf, 0xc0, 0x0, 0xf, 0xf9, 0xdf, 0xc0, 0x0,
    0x1f, 0xf9, 0xdf, 0xd2, 0x23, 0xbf, 0xf6, 0xdf,
    0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff, 0xd8,
    0x10,

    /* U+43 "C" */
    0x0, 0x5, 0xce, 0xfd, 0x80, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0xf0,
    0x1f, 0xf9, 0x0, 0x0, 0x38, 0x81, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x37, 0x71, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0,

    /* U+44 "D" */
    0xdf, 0xff, 0xfc, 0x70, 0x0, 0xdf, 0xff, 0xff,
    0xfd, 0x20, 0xdf, 0xd3, 0x38, 0xff, 0xd0, 0xdf,
    0xc0, 0x0, 0x7f, 0xf5, 0xdf, 0xc0, 0x0, 0xf,
    0xfb, 0xdf, 0xc0, 0x0, 0xd, 0xfd, 0xdf, 0xc0,
    0x0, 0xc, 0xfe, 0xdf, 0xc0, 0x0, 0xd, 0xfd,
    0xdf, 0xc0, 0x0, 0xf, 0xfb, 0xdf, 0xc0, 0x0,
    0x7f, 0xf6, 0xdf, 0xd3, 0x38, 0xff, 0xd0, 0xdf,
    0xff, 0xff, 0xfd, 0x20, 0xdf, 0xff, 0xfd, 0x70,
    0x0,

    /* U+45 "E" */
    0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff, 0xff, 0xff,
    0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff, 0xfd, 0xd,
    0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xff,
    0xff, 0xff, 0xb0,

    /* U+46 "F" */
    0xdf, 0xff, 0xff, 0xff, 0x7d, 0xff, 0xff, 0xff,
    0xf7, 0xdf, 0xd3, 0x33, 0x33, 0x1d, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfd,
    0x33, 0x33, 0x20, 0xdf, 0xff, 0xff, 0xfd, 0xd,
    0xff, 0xff, 0xff, 0xd0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0,
    0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0,
    0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x30, 0x4, 0xff, 0xd5, 0x37,
    0xff, 0xc0, 0xb, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xf, 0xfb, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0xcf,
    0xff, 0xf4, 0x1f, 0xf9, 0x0, 0xcf, 0xff, 0xf4,
    0xf, 0xfb, 0x0, 0x0, 0x6f, 0xf4, 0xb, 0xff,
    0x20, 0x0, 0x6f, 0xf4, 0x4, 0xff, 0xe6, 0x35,
    0xcf, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x4, 0xbe, 0xfe, 0xb6, 0x0,

    /* U+48 "H" */
    0xdf, 0xc0, 0x0, 0x1, 0xff, 0x9d, 0xfc, 0x0,
    0x0, 0x1f, 0xf9, 0xdf, 0xc0, 0x0, 0x1, 0xff,
    0x9d, 0xfc, 0x0, 0x0, 0x1f, 0xf9, 0xdf, 0xc0,
    0x0, 0x1, 0xff, 0x9d, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x9d, 0xfd,
    0x33, 0x33, 0x4f, 0xf9, 0xdf, 0xc0, 0x0, 0x1,
    0xff, 0x9d, 0xfc, 0x0, 0x0, 0x1f, 0xf9, 0xdf,
    0xc0, 0x0, 0x1, 0xff, 0x9d, 0xfc, 0x0, 0x0,
    0x1f, 0xf9, 0xdf, 0xc0, 0x0, 0x1, 0xff, 0x90,

    /* U+49 "I" */
    0xbf, 0xfb, 0xff, 0xbf, 0xfb, 0xff, 0xbf, 0xfb,
    0xff, 0xbf, 0xfb, 0xff, 0xbf, 0xfb, 0xff, 0xbf,
    0xfb, 0xff, 0xbf, 0xf0,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0xbf,
    0xe9, 0xff, 0x10, 0xd, 0xfd, 0x6f, 0xfa, 0x37,
    0xff, 0x90, 0xdf, 0xff, 0xff, 0xe1, 0x1, 0x9e,
    0xfe, 0x91, 0x0,

    /* U+4B "K" */
    0xdf, 0xc0, 0x0, 0x3f, 0xfe, 0x1d, 0xfc, 0x0,
    0x1d, 0xff, 0x40, 0xdf, 0xc0, 0xb, 0xff, 0x70,
    0xd, 0xfc, 0x7, 0xff, 0xb0, 0x0, 0xdf, 0xc3,
    0xff, 0xd0, 0x0, 0xd, 0xfd, 0xef, 0xf2, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0x50, 0x0, 0xd, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0xdf, 0xf7, 0x6f, 0xfa,
    0x0, 0xd, 0xfd, 0x0, 0xcf, 0xf4, 0x0, 0xdf,
    0xc0, 0x2, 0xff, 0xe0, 0xd, 0xfc, 0x0, 0x8,
    0xff, 0x90, 0xdf, 0xc0, 0x0, 0xd, 0xff, 0x40,

    /* U+4C "L" */
    0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0, 0x0,
    0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x1d, 0xff, 0xff, 0xff, 0xf6, 0xdf, 0xff,
    0xff, 0xff, 0x60,

    /* U+4D "M" */
    0xdf, 0xfc, 0x0, 0x0, 0x0, 0xff, 0xf9, 0xdf,
    0xff, 0x10, 0x0, 0x6, 0xff, 0xf9, 0xdf, 0xff,
    0x70, 0x0, 0xb, 0xff, 0xf9, 0xdf, 0xef, 0xc0,
    0x0, 0x1f, 0xfe, 0xf9, 0xdf, 0xaf, 0xf2, 0x0,
    0x6f, 0xcd, 0xf9, 0xdf, 0x9b, 0xf8, 0x0, 0xcf,
    0x7d, 0xf9, 0xdf, 0xa5, 0xfd, 0x1, 0xff, 0x1e,
    0xf9, 0xdf, 0xb0, 0xff, 0x37, 0xfb, 0xf, 0xf9,
    0xdf, 0xb0, 0xaf, 0x8c, 0xf5, 0xf, 0xf9, 0xdf,
    0xc0, 0x4f, 0xff, 0xf0, 0xf, 0xf9, 0xdf, 0xc0,
    0xe, 0xff, 0xa0, 0xf, 0xf9, 0xdf, 0xc0, 0x9,
    0xff, 0x40, 0xf, 0xf9, 0xdf, 0xc0, 0x3, 0xfe,
    0x0, 0xf, 0xf9,

    /* U+4E "N" */
    0xdf, 0xf1, 0x0, 0x1, 0xff, 0x8d, 0xff, 0xa0,
    0x0, 0x1f, 0xf8, 0xdf, 0xff, 0x40, 0x1, 0xff,
    0x8d, 0xff, 0xfd, 0x0, 0x1f, 0xf8, 0xdf, 0xef,
    0xf7, 0x1, 0xff, 0x8d, 0xfc, 0x9f, 0xf1, 0x1f,
    0xf8, 0xdf, 0xc1, 0xef, 0xa1, 0xff, 0x8d, 0xfc,
    0x6, 0xff, 0x5f, 0xf8, 0xdf, 0xc0, 0xc, 0xfe,
    0xff, 0x8d, 0xfc, 0x0, 0x3f, 0xff, 0xf8, 0xdf,
    0xc0, 0x0, 0x9f, 0xff, 0x8d, 0xfc, 0x0, 0x1,
    0xef, 0xf8, 0xdf, 0xc0, 0x0, 0x6, 0xff, 0x80,

    /* U+4F "O" */
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+50 "P" */
    0xdf, 0xff, 0xff, 0xd8, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xd1, 0xdf, 0xd3, 0x34, 0xaf, 0xf8, 0xdf,
    0xc0, 0x0, 0xd, 0xfd, 0xdf, 0xc0, 0x0, 0xc,
    0xfe, 0xdf, 0xc0, 0x0, 0x6f, 0xfb, 0xdf, 0xff,
    0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0xfc, 0x30,
    0xdf, 0xd3, 0x32, 0x10, 0x0, 0xdf, 0xc0, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0x0, 0xdf,
    0xc0, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0x0,

    /* U+51 "Q" */
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x4f, 0xf7, 0x3f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x4f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x3f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0x1f, 0xfa, 0x0, 0x0, 0x4f, 0xf7, 0xc, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x8f, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x4, 0xbe, 0xff, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52 "R" */
    0xdf, 0xff, 0xff, 0xd7, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xdf, 0xd3, 0x34, 0xcf, 0xf6,
    0xd, 0xfc, 0x0, 0x2, 0xff, 0x90, 0xdf, 0xc0,
    0x0, 0x1f, 0xf8, 0xd, 0xfc, 0x0, 0x1a, 0xff,
    0x50, 0xdf, 0xff, 0xff, 0xff, 0xb0, 0xd, 0xff,
    0xff, 0xff, 0x90, 0x0, 0xdf, 0xd3, 0x3e, 0xfd,
    0x0, 0xd, 0xfc, 0x0, 0x7f, 0xf5, 0x0, 0xdf,
    0xc0, 0x0, 0xef, 0xd0, 0xd, 0xfc, 0x0, 0x7,
    0xff, 0x50, 0xdf, 0xc0, 0x0, 0xe, 0xfd, 0x0,

    /* U+53 "S" */
    0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x70, 0xc, 0xff, 0x73, 0x5d, 0xff,
    0x10, 0xff, 0xb0, 0x0, 0x4f, 0xf5, 0xc, 0xfe,
    0x30, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xc7, 0x10,
    0x0, 0x0, 0x2b, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x2, 0x8e, 0xff, 0xb0, 0x13, 0x30, 0x0, 0x9,
    0xff, 0x44, 0xff, 0x60, 0x0, 0x4f, 0xf6, 0xe,
    0xfe, 0x63, 0x4c, 0xff, 0x40, 0x4f, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x29, 0xdf, 0xec, 0x60, 0x0,

    /* U+54 "T" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xca, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x23, 0x33, 0xdf, 0xe3, 0x33,
    0x20, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0,

    /* U+55 "U" */
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xdf, 0xd0, 0x0,
    0xf, 0xfb, 0x8f, 0xfa, 0x34, 0xbf, 0xf6, 0x1d,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x8d, 0xff, 0xc7,
    0x0,

    /* U+56 "V" */
    0xcf, 0xf2, 0x0, 0x0, 0x6f, 0xf8, 0x6f, 0xf6,
    0x0, 0x0, 0xaf, 0xf3, 0x1f, 0xfb, 0x0, 0x0,
    0xff, 0xd0, 0xb, 0xff, 0x0, 0x4, 0xff, 0x80,
    0x6, 0xff, 0x40, 0x8, 0xff, 0x20, 0x1, 0xff,
    0x90, 0xd, 0xfd, 0x0, 0x0, 0xbf, 0xe0, 0x2f,
    0xf7, 0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf2, 0x0,
    0x0, 0x1f, 0xf7, 0xbf, 0xc0, 0x0, 0x0, 0xb,
    0xfc, 0xff, 0x70, 0x0, 0x0, 0x5, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0,

    /* U+57 "W" */
    0x9f, 0xf0, 0x0, 0x5f, 0xf2, 0x0, 0x4f, 0xf5,
    0x5f, 0xf3, 0x0, 0x9f, 0xf5, 0x0, 0x7f, 0xf2,
    0x2f, 0xf6, 0x0, 0xcf, 0xf9, 0x0, 0xaf, 0xe0,
    0xe, 0xf9, 0x0, 0xff, 0xfc, 0x0, 0xdf, 0xb0,
    0xb, 0xfc, 0x3, 0xfe, 0xff, 0x0, 0xff, 0x70,
    0x7, 0xff, 0x7, 0xf9, 0xdf, 0x32, 0xff, 0x40,
    0x4, 0xff, 0x2b, 0xf5, 0x9f, 0x75, 0xff, 0x0,
    0x1, 0xff, 0x5e, 0xf1, 0x5f, 0xa8, 0xfd, 0x0,
    0x0, 0xdf, 0xbf, 0xe0, 0x1f, 0xeb, 0xf9, 0x0,
    0x0, 0x9f, 0xff, 0xa0, 0xd, 0xff, 0xf6, 0x0,
    0x0, 0x6f, 0xff, 0x60, 0xa, 0xff, 0xf2, 0x0,
    0x0, 0x3f, 0xff, 0x20, 0x6, 0xff, 0xf0, 0x0,
    0x0, 0xf, 0xfe, 0x0, 0x2, 0xff, 0xb0, 0x0,

    /* U+58 "X" */
    0x6f, 0xf9, 0x0, 0x2, 0xff, 0xd0, 0xd, 0xff,
    0x20, 0xa, 0xff, 0x40, 0x4, 0xff, 0xa0, 0x3f,
    0xfb, 0x0, 0x0, 0xbf, 0xf2, 0xbf, 0xf2, 0x0,
    0x0, 0x2f, 0xfd, 0xff, 0x80, 0x0, 0x0, 0x8,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x2, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x3f, 0xfd, 0xff, 0x90, 0x0, 0x0, 0xcf,
    0xf2, 0xbf, 0xf3, 0x0, 0x5, 0xff, 0x90, 0x2f,
    0xfc, 0x0, 0xe, 0xff, 0x10, 0xa, 0xff, 0x50,
    0x8f, 0xf8, 0x0, 0x1, 0xff, 0xe0,

    /* U+59 "Y" */
    0xbf, 0xf2, 0x0, 0x0, 0xff, 0xd0, 0x3f, 0xf9,
    0x0, 0x7, 0xff, 0x50, 0xb, 0xff, 0x10, 0xe,
    0xfd, 0x0, 0x3, 0xff, 0x70, 0x5f, 0xf5, 0x0,
    0x0, 0xbf, 0xe0, 0xcf, 0xc0, 0x0, 0x0, 0x3f,
    0xf9, 0xff, 0x40, 0x0, 0x0, 0xb, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,

    /* U+5A "Z" */
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x45, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x13, 0x33, 0x33, 0x7f, 0xf9,
    0x0, 0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x40, 0x0, 0x0, 0x4, 0xff, 0x80,
    0x0, 0x0, 0x1, 0xef, 0xd0, 0x0, 0x0, 0x0,
    0xaf, 0xf3, 0x0, 0x0, 0x0, 0x5f, 0xf8, 0x0,
    0x0, 0x0, 0x1e, 0xfc, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x53, 0x33, 0x33, 0x14, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x60,

    /* U+5B "[" */
    0x0, 0x0, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0x90,
    0xff, 0x90, 0xff, 0x90, 0xff, 0x90, 0xff, 0x90,
    0xff, 0x90, 0xff, 0x90, 0xff, 0x90, 0xff, 0x90,
    0xff, 0x90, 0xff, 0x90, 0xff, 0x90, 0xff, 0x90,
    0xff, 0x90, 0xff, 0xfd, 0xff, 0xfd,

    /* U+5C "\\" */
    0xdf, 0xc0, 0x0, 0x0, 0x7f, 0xf2, 0x0, 0x0,
    0x1f, 0xf8, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0,
    0x5, 0xff, 0x40, 0x0, 0x0, 0xff, 0x90, 0x0,
    0x0, 0x9f, 0xf0, 0x0, 0x0, 0x3f, 0xf5, 0x0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0x8, 0xff, 0x10,
    0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0x6f, 0xf3, 0x0, 0x0, 0x1f, 0xf9,
    0x0, 0x0, 0x6, 0x86,

    /* U+5D "]" */
    0x0, 0x0, 0xef, 0xfe, 0xef, 0xfe, 0xa, 0xfe,
    0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe,
    0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe,
    0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe, 0xa, 0xfe,
    0xa, 0xfe, 0xef, 0xfe, 0xef, 0xfe,

    /* U+5E "^" */
    0x0, 0x7, 0x70, 0x0, 0x0, 0x6f, 0xf4, 0x0,
    0x0, 0xcf, 0xfa, 0x0, 0x3, 0xfb, 0xdf, 0x10,
    0x9, 0xf5, 0x7f, 0x70, 0xf, 0xe0, 0x1f, 0xd0,
    0x6f, 0x90, 0xb, 0xf4,

    /* U+5F "_" */
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0x0,

    /* U+60 "`" */
    0x2c, 0xd6, 0x0, 0x6f, 0xf1, 0x0, 0x8f, 0xa0,

    /* U+61 "a" */
    0x0, 0x6c, 0xfe, 0xa2, 0x0, 0x9, 0xff, 0xff,
    0xff, 0x20, 0x1f, 0xf9, 0x3, 0xff, 0x80, 0x1,
    0x10, 0x0, 0xef, 0xa0, 0x1, 0x8d, 0xff, 0xff,
    0xa0, 0xd, 0xfe, 0x98, 0xff, 0xa0, 0x5f, 0xf4,
    0x0, 0xef, 0xa0, 0x5f, 0xf6, 0x16, 0xff, 0xa0,
    0x1e, 0xff, 0xff, 0xff, 0xb0, 0x2, 0xbf, 0xe8,
    0xaf, 0xe0,

    /* U+62 "b" */
    0xf, 0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0xf,
    0xf8, 0x0, 0x0, 0x0, 0xf, 0xf9, 0xaf, 0xe9,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xa0, 0xf, 0xfe,
    0x53, 0xcf, 0xf2, 0xf, 0xf8, 0x0, 0x3f, 0xf6,
    0xf, 0xf8, 0x0, 0xf, 0xf8, 0xf, 0xf8, 0x0,
    0xf, 0xf8, 0xf, 0xf8, 0x0, 0x2f, 0xf6, 0xf,
    0xfe, 0x42, 0xbf, 0xf2, 0xf, 0xff, 0xff, 0xff,
    0xa0, 0xf, 0xf6, 0xaf, 0xe9, 0x0,

    /* U+63 "c" */
    0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f, 0xff, 0xff,
    0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4, 0xff, 0x40,
    0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0, 0x48, 0x70,
    0xef, 0xc3, 0x3d, 0xfb, 0x5, 0xff, 0xff, 0xff,
    0x30, 0x4, 0xcf, 0xfb, 0x30,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x0, 0x7e, 0xfb, 0x8f,
    0xf2, 0x7, 0xff, 0xff, 0xff, 0xf2, 0xe, 0xfd,
    0x43, 0xdf, 0xf2, 0x3f, 0xf5, 0x0, 0x6f, 0xf2,
    0x5f, 0xf2, 0x0, 0x6f, 0xf2, 0x6f, 0xf2, 0x0,
    0x6f, 0xf2, 0x4f, 0xf4, 0x0, 0x6f, 0xf2, 0xf,
    0xfc, 0x0, 0xbf, 0xf2, 0x7, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x7e, 0xfc, 0x6f, 0xf2,

    /* U+65 "e" */
    0x0, 0x3b, 0xef, 0xc4, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x50, 0xd, 0xfd, 0x43, 0xcf, 0xd0, 0x2f,
    0xf5, 0x0, 0x4f, 0xf2, 0x4f, 0xff, 0xff, 0xff,
    0xf3, 0x5f, 0xfd, 0xcc, 0xcc, 0xc3, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0xd, 0xff, 0x62, 0x4d, 0x60,
    0x3, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x2a, 0xef,
    0xd8, 0x0,

    /* U+66 "f" */
    0x0, 0x1a, 0xef, 0x60, 0xd, 0xff, 0xf6, 0x3,
    0xff, 0x92, 0x10, 0x5f, 0xf3, 0x0, 0xcf, 0xff,
    0xff, 0x1b, 0xff, 0xff, 0xe1, 0x5, 0xff, 0x30,
    0x0, 0x5f, 0xf3, 0x0, 0x5, 0xff, 0x30, 0x0,
    0x5f, 0xf3, 0x0, 0x5, 0xff, 0x30, 0x0, 0x5f,
    0xf3, 0x0, 0x5, 0xff, 0x30, 0x0, 0x5f, 0xf3,
    0x0,

    /* U+67 "g" */
    0x0, 0x6d, 0xfd, 0x5f, 0xf4, 0x6, 0xff, 0xff,
    0xff, 0xf4, 0xe, 0xfe, 0x43, 0xbf, 0xf4, 0x4f,
    0xf6, 0x0, 0x4f, 0xf4, 0x5f, 0xf3, 0x0, 0x4f,
    0xf4, 0x5f, 0xf2, 0x0, 0x4f, 0xf4, 0x3f, 0xf6,
    0x0, 0x4f, 0xf4, 0xe, 0xfe, 0x43, 0xbf, 0xf4,
    0x6, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x6d, 0xfc,
    0x7f, 0xf4, 0x0, 0x10, 0x0, 0x6f, 0xf3, 0x3,
    0xe5, 0x13, 0xef, 0xe0, 0x9, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x7d, 0xfe, 0xb3, 0x0,

    /* U+68 "h" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x9f, 0xea,
    0x10, 0x1f, 0xff, 0xff, 0xff, 0x90, 0x1f, 0xfd,
    0x43, 0xdf, 0xf0, 0x1f, 0xf7, 0x0, 0x7f, 0xf1,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,

    /* U+69 "i" */
    0xa, 0xf7, 0xf, 0xfc, 0x6, 0xa3, 0x0, 0x0,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa,

    /* U+6A "j" */
    0x0, 0xbf, 0x60, 0xf, 0xfb, 0x0, 0x6a, 0x30,
    0x0, 0x0, 0x0, 0xef, 0xa0, 0xe, 0xfa, 0x0,
    0xef, 0xa0, 0xe, 0xfa, 0x0, 0xef, 0xa0, 0xe,
    0xfa, 0x0, 0xef, 0xa0, 0xe, 0xfa, 0x0, 0xef,
    0xa0, 0xe, 0xfa, 0x0, 0xef, 0xa2, 0x5f, 0xf8,
    0xdf, 0xff, 0x2b, 0xfd, 0x40,

    /* U+6B "k" */
    0xf, 0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0xf,
    0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x1, 0xef,
    0xe2, 0xf, 0xf8, 0xc, 0xff, 0x40, 0xf, 0xf8,
    0x9f, 0xf7, 0x0, 0xf, 0xfd, 0xff, 0x90, 0x0,
    0xf, 0xff, 0xff, 0x40, 0x0, 0xf, 0xff, 0xff,
    0xd0, 0x0, 0xf, 0xfd, 0x5f, 0xf8, 0x0, 0xf,
    0xf8, 0xa, 0xff, 0x30, 0xf, 0xf8, 0x1, 0xff,
    0xd0, 0xf, 0xf8, 0x0, 0x6f, 0xf7,

    /* U+6C "l" */
    0xef, 0xae, 0xfa, 0xef, 0xae, 0xfa, 0xef, 0xae,
    0xfa, 0xef, 0xae, 0xfa, 0xef, 0xae, 0xfa, 0xef,
    0xae, 0xfa, 0xef, 0xae, 0xfa,

    /* U+6D "m" */
    0xf, 0xf6, 0x9e, 0xfb, 0x15, 0xdf, 0xd5, 0x0,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xf2, 0xf,
    0xfe, 0x43, 0xdf, 0xf9, 0x27, 0xff, 0x70, 0xff,
    0x80, 0x8, 0xff, 0x10, 0xf, 0xf9, 0xf, 0xf8,
    0x0, 0x7f, 0xf0, 0x0, 0xff, 0x90, 0xff, 0x80,
    0x7, 0xff, 0x0, 0xf, 0xf9, 0xf, 0xf8, 0x0,
    0x7f, 0xf0, 0x0, 0xff, 0x90, 0xff, 0x80, 0x7,
    0xff, 0x0, 0xf, 0xf9, 0xf, 0xf8, 0x0, 0x7f,
    0xf0, 0x0, 0xff, 0x90, 0xff, 0x80, 0x7, 0xff,
    0x0, 0xf, 0xf9,

    /* U+6E "n" */
    0x1f, 0xf6, 0x9e, 0xea, 0x10, 0x1f, 0xff, 0xff,
    0xff, 0xa0, 0x1f, 0xfe, 0x43, 0xcf, 0xf0, 0x1f,
    0xf7, 0x0, 0x7f, 0xf1, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2,

    /* U+6F "o" */
    0x0, 0x3b, 0xef, 0xc5, 0x0, 0x4, 0xff, 0xff,
    0xff, 0x70, 0xe, 0xfe, 0x43, 0xcf, 0xf1, 0x3f,
    0xf5, 0x0, 0x3f, 0xf6, 0x6f, 0xf2, 0x0, 0xf,
    0xf9, 0x6f, 0xf2, 0x0, 0xf, 0xf8, 0x4f, 0xf5,
    0x0, 0x3f, 0xf6, 0xe, 0xfd, 0x43, 0xcf, 0xf1,
    0x4, 0xff, 0xff, 0xff, 0x70, 0x0, 0x3b, 0xff,
    0xc5, 0x0,

    /* U+70 "p" */
    0xf, 0xf8, 0xbe, 0xe9, 0x0, 0xf, 0xff, 0xff,
    0xff, 0x90, 0xf, 0xfd, 0x10, 0xbf, 0xf1, 0xf,
    0xf8, 0x0, 0x2f, 0xf5, 0xf, 0xf8, 0x0, 0xf,
    0xf7, 0xf, 0xf8, 0x0, 0x1f, 0xf7, 0xf, 0xf8,
    0x0, 0x3f, 0xf5, 0xf, 0xfe, 0x43, 0xcf, 0xf1,
    0xf, 0xff, 0xff, 0xff, 0x90, 0xf, 0xf9, 0xaf,
    0xe8, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0xf,
    0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0x0, 0xf, 0xf8, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x7e, 0xfb, 0x4f, 0xf2, 0x7, 0xff, 0xff,
    0xff, 0xf2, 0xe, 0xfd, 0x33, 0xdf, 0xf2, 0x4f,
    0xf5, 0x0, 0x6f, 0xf2, 0x5f, 0xf2, 0x0, 0x6f,
    0xf2, 0x6f, 0xf2, 0x0, 0x6f, 0xf2, 0x4f, 0xf5,
    0x0, 0x6f, 0xf2, 0xf, 0xfd, 0x34, 0xdf, 0xf2,
    0x7, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x7e, 0xfb,
    0x8f, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x0, 0x6f,
    0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf2,

    /* U+72 "r" */
    0x0, 0x0, 0x0, 0x0, 0xff, 0x8b, 0xf5, 0xf,
    0xff, 0xff, 0x50, 0xff, 0xf8, 0x62, 0xf, 0xf9,
    0x0, 0x0, 0xff, 0x80, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0xff, 0x80, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0xff, 0x80, 0x0, 0xf, 0xf8, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x7d, 0xfe, 0xa2, 0x0, 0xbf, 0xfe, 0xff,
    0xe1, 0x2f, 0xf6, 0x3, 0xff, 0x71, 0xff, 0x91,
    0x2, 0x21, 0x9, 0xff, 0xfd, 0x81, 0x0, 0x4,
    0xaf, 0xff, 0xe1, 0x24, 0x30, 0x5, 0xff, 0x85,
    0xff, 0x30, 0x1f, 0xf8, 0xc, 0xff, 0xef, 0xff,
    0x20, 0x8, 0xdf, 0xea, 0x20,

    /* U+74 "t" */
    0x4, 0x88, 0x0, 0x8, 0xff, 0x0, 0x8, 0xff,
    0x0, 0xef, 0xff, 0xfa, 0xdf, 0xff, 0xe9, 0x8,
    0xff, 0x0, 0x8, 0xff, 0x0, 0x8, 0xff, 0x0,
    0x8, 0xff, 0x0, 0x8, 0xff, 0x0, 0x7, 0xff,
    0x52, 0x3, 0xff, 0xfb, 0x0, 0x7e, 0xf9,

    /* U+75 "u" */
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0xf, 0xf7,
    0x0, 0x6f, 0xf2, 0xe, 0xfd, 0x34, 0xdf, 0xf2,
    0x9, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x9e, 0xeb,
    0x7f, 0xf2,

    /* U+76 "v" */
    0xbf, 0xe0, 0x0, 0xdf, 0xc6, 0xff, 0x20, 0x1f,
    0xf7, 0x1f, 0xf6, 0x5, 0xff, 0x20, 0xcf, 0xb0,
    0xaf, 0xd0, 0x7, 0xff, 0xe, 0xf8, 0x0, 0x1f,
    0xf6, 0xff, 0x30, 0x0, 0xcf, 0xef, 0xd0, 0x0,
    0x7, 0xff, 0xf8, 0x0, 0x0, 0x2f, 0xff, 0x30,
    0x0, 0x0, 0xdf, 0xe0, 0x0,

    /* U+77 "w" */
    0xaf, 0xc0, 0x7, 0xfa, 0x0, 0x9f, 0xd6, 0xff,
    0x0, 0xbf, 0xe0, 0xc, 0xf9, 0x2f, 0xf3, 0xf,
    0xff, 0x30, 0xff, 0x50, 0xef, 0x64, 0xff, 0xf7,
    0x3f, 0xf1, 0xa, 0xf9, 0x8f, 0x8f, 0xc6, 0xfd,
    0x0, 0x6f, 0xcd, 0xf1, 0xef, 0xaf, 0x90, 0x2,
    0xff, 0xfc, 0x9, 0xff, 0xf5, 0x0, 0xe, 0xff,
    0x80, 0x5f, 0xff, 0x10, 0x0, 0xbf, 0xf3, 0x0,
    0xff, 0xe0, 0x0, 0x7, 0xfe, 0x0, 0xc, 0xfa,
    0x0,

    /* U+78 "x" */
    0x6f, 0xf4, 0x1, 0xff, 0xa0, 0xd, 0xfd, 0xa,
    0xff, 0x10, 0x5, 0xff, 0x8f, 0xf8, 0x0, 0x0,
    0xcf, 0xff, 0xe0, 0x0, 0x0, 0x3f, 0xff, 0x60,
    0x0, 0x0, 0x5f, 0xff, 0x80, 0x0, 0x0, 0xdf,
    0xff, 0xf1, 0x0, 0x7, 0xff, 0x5f, 0xfa, 0x0,
    0x1e, 0xfb, 0x8, 0xff, 0x30, 0x8f, 0xf3, 0x0,
    0xef, 0xc0,

    /* U+79 "y" */
    0xcf, 0xe0, 0x0, 0xdf, 0xd0, 0x7f, 0xf3, 0x2,
    0xff, 0x80, 0x2f, 0xf7, 0x6, 0xff, 0x20, 0xc,
    0xfc, 0xb, 0xfd, 0x0, 0x7, 0xff, 0x1f, 0xf8,
    0x0, 0x2, 0xff, 0xaf, 0xf3, 0x0, 0x0, 0xdf,
    0xff, 0xd0, 0x0, 0x0, 0x7f, 0xff, 0x80, 0x0,
    0x0, 0x2f, 0xff, 0x30, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0x2,
    0x7f, 0xf3, 0x0, 0x0, 0xf, 0xff, 0xb0, 0x0,
    0x0, 0xd, 0xfa, 0x10, 0x0, 0x0,

    /* U+7A "z" */
    0x3f, 0xff, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff,
    0xf5, 0x2, 0x22, 0x4f, 0xfb, 0x0, 0x0, 0xd,
    0xfe, 0x10, 0x0, 0x9, 0xff, 0x40, 0x0, 0x4,
    0xff, 0x90, 0x0, 0x1, 0xef, 0xd0, 0x0, 0x0,
    0xbf, 0xf4, 0x11, 0x10, 0x4f, 0xff, 0xff, 0xff,
    0x85, 0xff, 0xff, 0xff, 0xf8,

    /* U+7B "{" */
    0x0, 0x1, 0x83, 0x0, 0x1d, 0xf7, 0x0, 0xaf,
    0xb0, 0x0, 0xef, 0x50, 0x0, 0xff, 0x40, 0x0,
    0xff, 0x40, 0x0, 0xff, 0x30, 0x6, 0xff, 0x0,
    0x8f, 0xf6, 0x0, 0x9f, 0xf4, 0x0, 0x7, 0xff,
    0x0, 0x1, 0xff, 0x30, 0x0, 0xff, 0x40, 0x0,
    0xff, 0x40, 0x0, 0xef, 0x50, 0x0, 0xaf, 0xa0,
    0x0, 0x2e, 0xf6, 0x0, 0x2, 0xa4,

    /* U+7C "|" */
    0x7f, 0x17, 0xf1, 0x7f, 0x17, 0xf1, 0x7f, 0x17,
    0xf1, 0x7f, 0x17, 0xf1, 0x7f, 0x17, 0xf1, 0x7f,
    0x17, 0xf1, 0x7f, 0x17, 0xf1, 0x7f, 0x15, 0xa0,

    /* U+7D "}" */
    0x48, 0x10, 0x0, 0x8f, 0xd1, 0x0, 0xc, 0xf9,
    0x0, 0x6, 0xfd, 0x0, 0x5, 0xff, 0x0, 0x5,
    0xff, 0x0, 0x4, 0xff, 0x0, 0x1, 0xff, 0x50,
    0x0, 0x7f, 0xf7, 0x0, 0x5f, 0xf8, 0x1, 0xff,
    0x70, 0x4, 0xff, 0x0, 0x5, 0xff, 0x0, 0x5,
    0xff, 0x0, 0x6, 0xfd, 0x0, 0xb, 0xf9, 0x0,
    0x7f, 0xe2, 0x0, 0x5a, 0x20, 0x0,

    /* U+7E "~" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xff,
    0x90, 0x2, 0xd8, 0x9, 0xff, 0xff, 0xb3, 0xaf,
    0x80, 0xef, 0x33, 0xdf, 0xff, 0xf2, 0xa, 0x80,
    0x1, 0xaf, 0xe5, 0x0,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0x7f, 0x9d, 0xfe, 0x4b, 0x50, 0x0, 0x12, 0x18,
    0xfa, 0x8f, 0xa9, 0xfb, 0x9f, 0xba, 0xfc, 0xaf,
    0xcb, 0xfd, 0xcf, 0xdc, 0xfe,

    /* U+A2 "¢" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x20, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0, 0x0,
    0x3c, 0xff, 0xe7, 0x0, 0x2, 0xff, 0xff, 0xff,
    0x80, 0xa, 0xfe, 0x31, 0xaf, 0xf0, 0xf, 0xf9,
    0x0, 0x2b, 0xb1, 0x1f, 0xf6, 0x0, 0x0, 0x0,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xe, 0xf9, 0x0,
    0x29, 0x91, 0x9, 0xff, 0x53, 0xbf, 0xf0, 0x1,
    0xef, 0xff, 0xff, 0x60, 0x0, 0x1a, 0xff, 0xc5,
    0x0, 0x0, 0x0, 0xaf, 0x20, 0x0, 0x0, 0x0,
    0xaf, 0x20, 0x0,

    /* U+A3 "£" */
    0x0, 0x3, 0xbf, 0xfc, 0x50, 0x0, 0x2, 0xff,
    0xff, 0xff, 0x70, 0x0, 0xaf, 0xf6, 0x4d, 0xff,
    0x0, 0xd, 0xfd, 0x0, 0x4b, 0xb1, 0x0, 0xdf,
    0xd0, 0x0, 0x0, 0x0, 0x2d, 0xfe, 0x22, 0x10,
    0x0, 0x2f, 0xff, 0xff, 0xf9, 0x0, 0x2, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0xaf, 0xf0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xc3, 0x33, 0x33, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x30,

    /* U+A4 "¤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x60,
    0x6a, 0xb9, 0x21, 0xb2, 0x1e, 0xfe, 0xff, 0xff,
    0xfe, 0xf9, 0x4, 0xff, 0x82, 0x4, 0xdf, 0xc0,
    0x6, 0xf8, 0x0, 0x0, 0x1e, 0xd0, 0xc, 0xe0,
    0x0, 0x0, 0x7, 0xf4, 0xe, 0xb0, 0x0, 0x0,
    0x3, 0xf6, 0xe, 0xb0, 0x0, 0x0, 0x2, 0xf6,
    0xc, 0xe0, 0x0, 0x0, 0x6, 0xf4, 0x8, 0xf5,
    0x0, 0x0, 0xc, 0xf0, 0x4, 0xff, 0x40, 0x1,
    0xaf, 0xc0, 0x1e, 0xff, 0xfd, 0xcf, 0xff, 0xf8,
    0x9, 0x72, 0xae, 0xfd, 0x71, 0xc3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+A5 "¥" */
    0xaf, 0xf1, 0x0, 0x6f, 0xf5, 0x3f, 0xf6, 0x0,
    0xcf, 0xd0, 0xc, 0xfd, 0x2, 0xff, 0x70, 0x5,
    0xff, 0x38, 0xff, 0x0, 0x0, 0xef, 0x9e, 0xf8,
    0x0, 0x0, 0x7f, 0xff, 0xf2, 0x0, 0x29, 0xaf,
    0xff, 0xe9, 0x60, 0x3f, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x8, 0xff, 0x10, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xa0, 0x29, 0x9c, 0xff, 0x99, 0x50, 0x0,
    0x8, 0xff, 0x10, 0x0, 0x0, 0x8, 0xff, 0x10,
    0x0,

    /* U+A6 "¦" */
    0xef, 0x6e, 0xf6, 0xef, 0x6e, 0xf6, 0xef, 0x6e,
    0xf6, 0xce, 0x50, 0x0, 0x33, 0x1e, 0xf6, 0xef,
    0x6e, 0xf6, 0xef, 0x6e, 0xf6, 0xef, 0x6e, 0xf6,

    /* U+A7 "§" */
    0x0, 0x2a, 0xdf, 0xeb, 0x40, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0x60, 0xc, 0xfe, 0x52, 0x4e, 0xff,
    0x0, 0xef, 0xa0, 0x0, 0x5d, 0xd1, 0xb, 0xff,
    0x71, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xfc, 0x71,
    0x0, 0x7, 0xff, 0xdf, 0xff, 0xf5, 0x0, 0xff,
    0x70, 0x28, 0xff, 0xf1, 0x2f, 0xf8, 0x0, 0x4,
    0xff, 0x50, 0xef, 0xfa, 0x40, 0x4f, 0xf4, 0x4,
    0xff, 0xff, 0xee, 0xfb, 0x0, 0x1, 0x8d, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x2, 0x8f, 0xfe, 0x1,
    0xbb, 0x40, 0x0, 0x7f, 0xf1, 0xf, 0xfd, 0x42,
    0x3c, 0xff, 0x0, 0x7f, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x4b, 0xdf, 0xeb, 0x50, 0x0,

    /* U+A8 "¨" */
    0x2, 0x20, 0x1, 0x30, 0x1f, 0xf2, 0xc, 0xf6,
    0xd, 0xd1, 0x9, 0xf4,

    /* U+A9 "©" */
    0x0, 0x0, 0x5b, 0xee, 0xb5, 0x0, 0x0, 0x0,
    0x1c, 0xd6, 0x33, 0x6d, 0xc1, 0x0, 0x0, 0xd9,
    0x1a, 0xfe, 0x91, 0x9c, 0x0, 0x7, 0xc0, 0xad,
    0x45, 0xe8, 0xc, 0x70, 0xe, 0x40, 0xf5, 0x0,
    0x8a, 0x4, 0xd0, 0x1f, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0xf1, 0x3d, 0x2, 0xf2, 0x0, 0x0, 0x0,
    0xd3, 0x2e, 0x1, 0xf4, 0x0, 0x68, 0x0, 0xf1,
    0xe, 0x20, 0xcc, 0x12, 0xd9, 0x3, 0xe0, 0x9,
    0xa0, 0x2d, 0xff, 0xc1, 0xa, 0x80, 0x1, 0xe6,
    0x0, 0x21, 0x0, 0x7e, 0x10, 0x0, 0x3e, 0xa3,
    0x0, 0x3a, 0xe3, 0x0, 0x0, 0x1, 0x9e, 0xff,
    0xe9, 0x10, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0,

    /* U+AA "ª" */
    0x9, 0xee, 0x90, 0x7f, 0x77, 0xf6, 0x13, 0x0,
    0xe9, 0x1a, 0xde, 0xfa, 0xae, 0x31, 0xea, 0xbe,
    0x57, 0xfa, 0x3d, 0xfb, 0xdc,

    /* U+AB "«" */
    0x0, 0x3, 0x20, 0x24, 0x0, 0x6, 0xf5, 0x1e,
    0xb0, 0x2, 0xfb, 0xb, 0xf2, 0x0, 0xcf, 0x26,
    0xf8, 0x0, 0x3f, 0xc0, 0xcf, 0x30, 0x0, 0x9f,
    0x43, 0xfb, 0x0, 0x0, 0xdd, 0x8, 0xf4, 0x0,
    0x3, 0xf7, 0xc, 0xd0,

    /* U+AC "¬" */
    0x78, 0x88, 0x88, 0x83, 0xef, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x2, 0x83,

    /* U+AD "­" */
    0x2, 0x22, 0x21, 0xf, 0xff, 0xfe, 0xf, 0xff,
    0xfe,

    /* U+AE "®" */
    0x0, 0x0, 0x5b, 0xee, 0xb5, 0x0, 0x0, 0x0,
    0x1c, 0xd6, 0x33, 0x6d, 0xc1, 0x0, 0x0, 0xd9,
    0x9f, 0xfe, 0x90, 0x9c, 0x0, 0x7, 0xc0, 0x9c,
    0x34, 0xe7, 0xc, 0x70, 0xe, 0x40, 0x9b, 0x0,
    0xaa, 0x4, 0xd0, 0x1f, 0x0, 0x9b, 0x2, 0xd8,
    0x0, 0xf1, 0x3d, 0x0, 0x9f, 0xff, 0xf1, 0x0,
    0xd3, 0x2e, 0x0, 0x9c, 0x34, 0xe8, 0x0, 0xf1,
    0xe, 0x20, 0x9b, 0x0, 0xaa, 0x3, 0xe0, 0x9,
    0xa0, 0x9b, 0x0, 0x9c, 0xa, 0x80, 0x1, 0xe6,
    0x12, 0x0, 0x12, 0x7e, 0x10, 0x0, 0x3e, 0xa3,
    0x0, 0x3a, 0xe3, 0x0, 0x0, 0x1, 0x9e, 0xff,
    0xe9, 0x10, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0,

    /* U+AF "¯" */
    0x48, 0x88, 0x88, 0x48, 0xff, 0xff, 0xf8,

    /* U+B0 "°" */
    0x0, 0x0, 0x1, 0xcf, 0xc1, 0xad, 0x5d, 0x9d,
    0x70, 0x7d, 0xbb, 0x2b, 0xa2, 0xef, 0xe2, 0x0,
    0x30, 0x0,

    /* U+B1 "±" */
    0x0, 0x2, 0x99, 0x0, 0x0, 0x0, 0x4f, 0xf0,
    0x0, 0x0, 0x4, 0xff, 0x0, 0x0, 0x33, 0x6f,
    0xf3, 0x32, 0x3f, 0xff, 0xff, 0xff, 0xd3, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x4, 0xff, 0x0, 0x0,
    0x0, 0x4f, 0xf0, 0x0, 0x0, 0x4, 0xff, 0x0,
    0x0, 0x22, 0x22, 0x22, 0x21, 0xf, 0xff, 0xff,
    0xff, 0x90, 0xff, 0xff, 0xff, 0xf9,

    /* U+B2 "²" */
    0x7, 0xef, 0xc2, 0x4, 0xfc, 0x8f, 0xb0, 0x36,
    0x21, 0xfd, 0x0, 0x0, 0xbf, 0x60, 0x1, 0xcf,
    0x60, 0x2, 0xdf, 0xa7, 0x70, 0x5f, 0xff, 0xff,
    0x10,

    /* U+B3 "³" */
    0x8, 0xef, 0xc3, 0x5, 0xfc, 0x8f, 0xd0, 0x0,
    0x1, 0xed, 0x0, 0x9, 0xff, 0x40, 0x12, 0x23,
    0xde, 0x6, 0xfc, 0x7f, 0xf0, 0x9, 0xef, 0xc4,
    0x0,

    /* U+B4 "´" */
    0x0, 0x8d, 0xc1, 0x3, 0xff, 0x40, 0xc, 0xf6,
    0x0,

    /* U+B5 "µ" */
    0xcf, 0xc0, 0x0, 0xdf, 0xbc, 0xfc, 0x0, 0xd,
    0xfb, 0xcf, 0xc0, 0x0, 0xdf, 0xbc, 0xfc, 0x0,
    0xd, 0xfb, 0xcf, 0xc0, 0x0, 0xdf, 0xbc, 0xfc,
    0x0, 0xd, 0xfb, 0xcf, 0xd0, 0x0, 0xdf, 0xbc,
    0xff, 0x30, 0x5f, 0xfb, 0xcf, 0xff, 0xff, 0xff,
    0xbc, 0xff, 0xef, 0xcd, 0xfb, 0xcf, 0xc0, 0x0,
    0x0, 0xc, 0xfc, 0x0, 0x0, 0x0, 0xcf, 0xc0,
    0x0, 0x0, 0xc, 0xfc, 0x0, 0x0, 0x0,

    /* U+B6 "¶" */
    0x0, 0x5c, 0xff, 0xfa, 0x7, 0xff, 0xff, 0xfa,
    0xf, 0xff, 0xff, 0xfa, 0x4f, 0xff, 0xff, 0xfa,
    0x5f, 0xff, 0xff, 0xfa, 0x2f, 0xff, 0xff, 0xfa,
    0xc, 0xff, 0xff, 0xfa, 0x2, 0xdf, 0xff, 0xfa,
    0x0, 0x4, 0x7a, 0xfa, 0x0, 0x0, 0x4, 0xfa,
    0x0, 0x0, 0x4, 0xfa, 0x0, 0x0, 0x4, 0xfa,
    0x0, 0x0, 0x4, 0xfa,

    /* U+B7 "·" */
    0x4c, 0x70, 0xbf, 0xf0, 0x6f, 0xa0,

    /* U+B8 "¸" */
    0x0, 0x10, 0x0, 0xff, 0x50, 0x5, 0xff, 0x20,
    0x8f, 0xf1, 0xc, 0xd5, 0x0,

    /* U+B9 "¹" */
    0x4, 0x98, 0xcf, 0xfa, 0x56, 0xfa, 0x2, 0xfa,
    0x2, 0xfa, 0x2, 0xfa, 0x2, 0xfa,

    /* U+BA "º" */
    0x8, 0xee, 0xa1, 0x8, 0xf7, 0x6f, 0xa0, 0xdb,
    0x0, 0x8f, 0xf, 0x90, 0x6, 0xf1, 0xda, 0x0,
    0x8f, 0x8, 0xf7, 0x6e, 0xa0, 0x8, 0xee, 0xa1,
    0x0,

    /* U+BB "»" */
    0x4, 0x10, 0x23, 0x0, 0x0, 0xcd, 0x5, 0xf5,
    0x0, 0x3, 0xf9, 0xc, 0xf1, 0x0, 0xa, 0xf4,
    0x3f, 0xc0, 0x0, 0x4f, 0xb0, 0xdf, 0x20, 0xc,
    0xf2, 0x5f, 0x90, 0x6, 0xf6, 0xe, 0xd0, 0x0,
    0xeb, 0x8, 0xf3, 0x0,

    /* U+BC "¼" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0x50,
    0x0, 0x5c, 0x10, 0x0, 0x37, 0xf5, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x7f, 0x50, 0x8, 0xf2, 0x0,
    0x0, 0x7, 0xf5, 0x2, 0xf8, 0x0, 0x0, 0x0,
    0x7f, 0x50, 0xcd, 0x1, 0x21, 0x0, 0x6, 0xf5,
    0x5f, 0x40, 0xcf, 0x70, 0x0, 0x0, 0xe, 0xb0,
    0x8f, 0xf7, 0x0, 0x0, 0x9, 0xf2, 0x3f, 0xbf,
    0x70, 0x0, 0x3, 0xf7, 0xe, 0x95, 0xf7, 0x0,
    0x0, 0xcd, 0x7, 0xff, 0xff, 0xf3, 0x0, 0x9,
    0x40, 0x38, 0x8b, 0xfb, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70,

    /* U+BD "½" */
    0x1, 0x6c, 0x20, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xf3, 0x0, 0x6, 0x50, 0x0, 0x26, 0xbf, 0x30,
    0x2, 0xf8, 0x0, 0x0, 0x9, 0xf3, 0x0, 0xbe,
    0x0, 0x0, 0x0, 0x9f, 0x30, 0x5f, 0x50, 0x0,
    0x0, 0x9, 0xf3, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0x9f, 0x38, 0xf2, 0x8e, 0xfb, 0x10, 0x1, 0x33,
    0xf8, 0x5f, 0xca, 0xf9, 0x0, 0x0, 0xbe, 0x4,
    0x82, 0x2f, 0xb0, 0x0, 0x5f, 0x50, 0x0, 0xb,
    0xf6, 0x0, 0xe, 0xb0, 0x0, 0xb, 0xf8, 0x0,
    0x5, 0xf2, 0x0, 0x1c, 0xf8, 0x22, 0x0, 0x1,
    0x0, 0x7, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x25, 0x55, 0x55,

    /* U+BE "¾" */
    0x0, 0x47, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xfd, 0x0, 0x0, 0x10, 0x0, 0x8, 0x71,
    0x9f, 0x40, 0x1, 0xe6, 0x0, 0x0, 0x0, 0x9f,
    0x30, 0x9, 0xf1, 0x0, 0x0, 0x3f, 0xfa, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0x3, 0x9f, 0x40, 0xcd,
    0x0, 0x0, 0x1e, 0xc3, 0x9f, 0x66, 0xf4, 0x2,
    0x20, 0x9, 0xff, 0xfc, 0x2e, 0xa0, 0x7f, 0xd0,
    0x0, 0x24, 0x30, 0x9f, 0x12, 0xff, 0xd0, 0x0,
    0x0, 0x3, 0xf7, 0xd, 0xdf, 0xd0, 0x0, 0x0,
    0xc, 0xd0, 0x8e, 0x1f, 0xd0, 0x0, 0x0, 0x6f,
    0x41, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x59, 0x0,
    0x88, 0x8f, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xd0,

    /* U+BF "¿" */
    0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xaf, 0xf1,
    0x0, 0x0, 0x2, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xca, 0x0, 0x0, 0x0,
    0x9f, 0xc0, 0x0, 0x0, 0x4f, 0xf7, 0x0, 0x0,
    0x3f, 0xfd, 0x0, 0x0, 0xd, 0xfe, 0x10, 0x0,
    0x4, 0xff, 0x50, 0x0, 0x0, 0x5f, 0xf3, 0x0,
    0xcc, 0x63, 0xff, 0x92, 0x9f, 0xf5, 0xc, 0xff,
    0xff, 0xfd, 0x0, 0x8, 0xdf, 0xd9, 0x10,

    /* U+C0 "À" */
    0x0, 0xa, 0xdb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+C1 "Á" */
    0x0, 0x0, 0x0, 0x8d, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+C2 "Â" */
    0x0, 0x0, 0x2e, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xed, 0xf3, 0x0, 0x0, 0x0, 0x1d, 0xf3,
    0x2e, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+C3 "Ã" */
    0x0, 0x2, 0x97, 0x22, 0xa3, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0x10, 0x0, 0x0, 0x1a, 0x41,
    0x79, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+C4 "Ä" */
    0x0, 0x2, 0x20, 0x1, 0x30, 0x0, 0x0, 0x2,
    0xff, 0x10, 0xef, 0x50, 0x0, 0x0, 0x1e, 0xd0,
    0xb, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+C5 "Å" */
    0x0, 0x0, 0x2c, 0xd4, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x52, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xc5,
    0x2e, 0x0, 0x0, 0x0, 0x0, 0x3, 0xcd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x7, 0xfe, 0xdf,
    0x80, 0x0, 0x0, 0x0, 0xdf, 0x98, 0xfe, 0x0,
    0x0, 0x0, 0x3f, 0xf4, 0x3f, 0xf4, 0x0, 0x0,
    0x8, 0xfe, 0x0, 0xdf, 0xa0, 0x0, 0x0, 0xef,
    0x90, 0x8, 0xff, 0x10, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0xff, 0xb3, 0x33, 0x39, 0xff, 0x20,
    0x6f, 0xf5, 0x0, 0x0, 0x3f, 0xf8, 0xc, 0xff,
    0x0, 0x0, 0x0, 0xef, 0xd0,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xa2, 0x22,
    0x21, 0x0, 0x0, 0x0, 0xef, 0xbe, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xf3, 0xdf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xfb, 0xc, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x8, 0xff, 0x30, 0xcf,
    0xff, 0xff, 0xf2, 0x0, 0x1, 0xff, 0xd4, 0x4c,
    0xfd, 0x22, 0x22, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0xa, 0xff, 0x30,
    0x0, 0x9f, 0xf2, 0x22, 0x22, 0x3, 0xff, 0xb0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf6, 0xbf, 0xf3,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x60,

    /* U+C7 "Ç" */
    0x0, 0x5, 0xce, 0xfd, 0x80, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0xf0,
    0x1f, 0xf9, 0x0, 0x0, 0x38, 0x81, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x37, 0x71, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0, 0x0, 0x0,
    0xf, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x9, 0xff, 0x10, 0x0,
    0x0, 0x0, 0xd, 0xc4, 0x0, 0x0,

    /* U+C8 "È" */
    0x4, 0xcd, 0x40, 0x0, 0x0, 0x8, 0xfe, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+C9 "É" */
    0x0, 0x0, 0x2c, 0xd6, 0x0, 0x0, 0xb, 0xfb,
    0x0, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+CA "Ê" */
    0x0, 0x9, 0xfb, 0x0, 0x0, 0x8, 0xfc, 0xfa,
    0x0, 0x7, 0xfa, 0x8, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+CB "Ë" */
    0x0, 0x40, 0x0, 0x31, 0x0, 0xaf, 0x80, 0x6f,
    0xd0, 0x7, 0xf5, 0x3, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+CC "Ì" */
    0x3c, 0xd5, 0x0, 0x7f, 0xe0, 0x0, 0x9f, 0x90,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0xb, 0xff, 0x0,
    0xbf, 0xf0, 0xb, 0xff, 0x0, 0xbf, 0xf0, 0xb,
    0xff, 0x0, 0xbf, 0xf0, 0xb, 0xff, 0x0, 0xbf,
    0xf0, 0xb, 0xff, 0x0, 0xbf, 0xf0, 0xb, 0xff,
    0x0, 0xbf, 0xf0,

    /* U+CD "Í" */
    0x1, 0xcd, 0x70, 0xbf, 0xb0, 0x4f, 0xd1, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0xb, 0xff, 0x0, 0xbf,
    0xf0, 0xb, 0xff, 0x0, 0xbf, 0xf0, 0xb, 0xff,
    0x0, 0xbf, 0xf0, 0xb, 0xff, 0x0, 0xbf, 0xf0,
    0xb, 0xff, 0x0, 0xbf, 0xf0, 0xb, 0xff, 0x0,
    0xbf, 0xf0, 0x0,

    /* U+CE "Î" */
    0x0, 0x9f, 0xc0, 0x0, 0x7f, 0xcf, 0xa0, 0x6f,
    0xb0, 0x7f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0xbf, 0xf0, 0x0,

    /* U+CF "Ï" */
    0x4, 0x0, 0x3, 0x19, 0xf9, 0x5, 0xfd, 0x7f,
    0x60, 0x3e, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0xbf, 0xf0, 0x0,

    /* U+D0 "Ð" */
    0x0, 0x9f, 0xff, 0xfd, 0x92, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x9f, 0xf3,
    0x36, 0xef, 0xf2, 0x0, 0x9, 0xff, 0x0, 0x2,
    0xff, 0xa0, 0x0, 0x9f, 0xf0, 0x0, 0xb, 0xff,
    0x1, 0xad, 0xff, 0xaa, 0x0, 0x9f, 0xf1, 0x2f,
    0xff, 0xff, 0xf0, 0x7, 0xff, 0x20, 0x9, 0xff,
    0x0, 0x0, 0x9f, 0xf1, 0x0, 0x9f, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x9, 0xff, 0x0, 0x3, 0xff,
    0xa0, 0x0, 0x9f, 0xf3, 0x36, 0xef, 0xf2, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x9f,
    0xff, 0xfd, 0x92, 0x0, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0x7, 0x93, 0x9, 0x60, 0x0, 0x9, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x97, 0x5, 0x96, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf1,
    0x0, 0x1, 0xff, 0x8d, 0xff, 0xa0, 0x0, 0x1f,
    0xf8, 0xdf, 0xff, 0x40, 0x1, 0xff, 0x8d, 0xff,
    0xfd, 0x0, 0x1f, 0xf8, 0xdf, 0xef, 0xf7, 0x1,
    0xff, 0x8d, 0xfc, 0x9f, 0xf1, 0x1f, 0xf8, 0xdf,
    0xc1, 0xef, 0xa1, 0xff, 0x8d, 0xfc, 0x6, 0xff,
    0x5f, 0xf8, 0xdf, 0xc0, 0xc, 0xfe, 0xff, 0x8d,
    0xfc, 0x0, 0x3f, 0xff, 0xf8, 0xdf, 0xc0, 0x0,
    0x9f, 0xff, 0x8d, 0xfc, 0x0, 0x1, 0xef, 0xf8,
    0xdf, 0xc0, 0x0, 0x6, 0xff, 0x80,

    /* U+D2 "Ò" */
    0x0, 0x9, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xc2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D3 "Ó" */
    0x0, 0x0, 0x0, 0x9f, 0xe2, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x30, 0x0, 0x0, 0x0, 0x9, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D4 "Ô" */
    0x0, 0x0, 0x2e, 0xf7, 0x0, 0x0, 0x0, 0x4,
    0xfd, 0x9f, 0x80, 0x0, 0x0, 0x7, 0x71, 0x5,
    0x82, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D5 "Õ" */
    0x0, 0x1, 0x88, 0x21, 0xa4, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0xa, 0x51, 0x69,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D6 "Ö" */
    0x0, 0x2, 0x20, 0x1, 0x30, 0x0, 0x0, 0x1f,
    0xf2, 0xc, 0xf7, 0x0, 0x0, 0xd, 0xe1, 0x9,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D7 "×" */
    0x2, 0x30, 0x0, 0x5, 0x1, 0xee, 0x20, 0x9,
    0xf7, 0x1d, 0xfe, 0x29, 0xff, 0x60, 0x1d, 0xff,
    0xff, 0x60, 0x0, 0x1e, 0xff, 0x80, 0x0, 0x6,
    0xff, 0xfd, 0x10, 0x5, 0xff, 0xae, 0xfc, 0x2,
    0xff, 0x90, 0x3f, 0xfa, 0x8, 0xa0, 0x0, 0x3d,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x3,
    0xbe, 0xfd, 0x7d, 0xa0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0x40, 0x3, 0xff, 0xe6, 0x4a, 0xff, 0xb0,
    0xb, 0xff, 0x20, 0x9, 0xff, 0xf3, 0xf, 0xfb,
    0x0, 0x3f, 0x9f, 0xf8, 0x1f, 0xf8, 0x0, 0xcd,
    0xf, 0xfa, 0x2f, 0xf7, 0x6, 0xf3, 0xf, 0xfb,
    0x2f, 0xf8, 0x1f, 0x90, 0xf, 0xfa, 0xf, 0xfb,
    0xae, 0x10, 0x2f, 0xf8, 0xb, 0xff, 0xf6, 0x0,
    0x9f, 0xf3, 0x3, 0xff, 0xf6, 0x49, 0xff, 0xc0,
    0x0, 0xaf, 0xff, 0xff, 0xfd, 0x20, 0x1, 0xfa,
    0xae, 0xfd, 0x81, 0x0, 0x4, 0x70, 0x0, 0x0,
    0x0, 0x0,

    /* U+D9 "Ù" */
    0x1, 0xdf, 0xb0, 0x0, 0x0, 0x0, 0x2e, 0xf5,
    0x0, 0x0, 0x0, 0x3, 0xcb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+DA "Ú" */
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0x8f,
    0xd0, 0x0, 0x0, 0x1, 0xcc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+DB "Û" */
    0x0, 0x6, 0xfe, 0x30, 0x0, 0x0, 0x8f, 0xac,
    0xf4, 0x0, 0x2, 0x86, 0x0, 0x77, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+DC "Ü" */
    0x0, 0x31, 0x0, 0x22, 0x0, 0x5, 0xfd, 0x1,
    0xff, 0x20, 0x3, 0xea, 0x0, 0xdd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+DD "Ý" */
    0x0, 0x0, 0x2, 0xcd, 0x60, 0x0, 0x0, 0x0,
    0xb, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf2, 0x0, 0x0, 0xff, 0xd0, 0x3f, 0xf9,
    0x0, 0x7, 0xff, 0x50, 0xb, 0xff, 0x10, 0xe,
    0xfd, 0x0, 0x3, 0xff, 0x70, 0x5f, 0xf5, 0x0,
    0x0, 0xbf, 0xe0, 0xcf, 0xc0, 0x0, 0x0, 0x3f,
    0xf9, 0xff, 0x40, 0x0, 0x0, 0xb, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,

    /* U+DE "Þ" */
    0xdf, 0xb0, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xfe, 0xb4, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0x70, 0xdf, 0xb1, 0x14, 0xdf,
    0xf1, 0xdf, 0xb0, 0x0, 0x4f, 0xf4, 0xdf, 0xb0,
    0x0, 0x3f, 0xf5, 0xdf, 0xb0, 0x2, 0xcf, 0xf2,
    0xdf, 0xff, 0xff, 0xff, 0x90, 0xdf, 0xff, 0xff,
    0xd7, 0x0, 0xdf, 0xb1, 0x10, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0x0,
    0x0,

    /* U+DF "ß" */
    0x2, 0xae, 0xfd, 0x60, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0x0, 0x8f, 0xf5, 0x2d, 0xff, 0x0, 0xcf,
    0xc0, 0x7, 0xff, 0x0, 0xcf, 0xb0, 0xb, 0xfc,
    0x0, 0xdf, 0xb0, 0x2f, 0xf5, 0x0, 0xdf, 0xb0,
    0x6f, 0xf2, 0x0, 0xdf, 0xb0, 0x4f, 0xfb, 0x0,
    0xdf, 0xb0, 0xa, 0xff, 0xb0, 0xdf, 0xb0, 0x0,
    0x9f, 0xf7, 0xdf, 0xb0, 0x0, 0xd, 0xfb, 0xdf,
    0xb1, 0x20, 0x1e, 0xfa, 0xdf, 0xb5, 0xff, 0xff,
    0xf4, 0xdf, 0xb6, 0xef, 0xeb, 0x40,

    /* U+E0 "à" */
    0x1, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x2f, 0xf4,
    0x0, 0x0, 0x0, 0x4, 0xca, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x9, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xf9,
    0x3, 0xff, 0x80, 0x1, 0x10, 0x0, 0xef, 0xa0,
    0x1, 0x8d, 0xff, 0xff, 0xa0, 0xd, 0xfe, 0x98,
    0xff, 0xa0, 0x5f, 0xf4, 0x0, 0xef, 0xa0, 0x5f,
    0xf6, 0x16, 0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff,
    0xb0, 0x2, 0xbf, 0xe8, 0xaf, 0xe0,

    /* U+E1 "á" */
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x9f,
    0xc0, 0x0, 0x0, 0x1, 0xcc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x9, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xf9,
    0x3, 0xff, 0x80, 0x1, 0x10, 0x0, 0xef, 0xa0,
    0x1, 0x8d, 0xff, 0xff, 0xa0, 0xd, 0xfe, 0x98,
    0xff, 0xa0, 0x5f, 0xf4, 0x0, 0xef, 0xa0, 0x5f,
    0xf6, 0x16, 0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff,
    0xb0, 0x2, 0xbf, 0xe8, 0xaf, 0xe0,

    /* U+E2 "â" */
    0x0, 0x6, 0xfe, 0x20, 0x0, 0x0, 0x7f, 0xbd,
    0xe2, 0x0, 0x3, 0xa8, 0x1, 0x98, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x9, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xf9,
    0x3, 0xff, 0x80, 0x1, 0x10, 0x0, 0xef, 0xa0,
    0x1, 0x8d, 0xff, 0xff, 0xa0, 0xd, 0xfe, 0x98,
    0xff, 0xa0, 0x5f, 0xf4, 0x0, 0xef, 0xa0, 0x5f,
    0xf6, 0x16, 0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff,
    0xb0, 0x2, 0xbf, 0xe8, 0xaf, 0xe0,

    /* U+E3 "ã" */
    0x0, 0x8f, 0xa1, 0x8f, 0x10, 0x3, 0xfc, 0xef,
    0xfc, 0x0, 0x4, 0xa1, 0x7, 0x91, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x9, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xf9,
    0x3, 0xff, 0x80, 0x1, 0x10, 0x0, 0xef, 0xa0,
    0x1, 0x8d, 0xff, 0xff, 0xa0, 0xd, 0xfe, 0x98,
    0xff, 0xa0, 0x5f, 0xf4, 0x0, 0xef, 0xa0, 0x5f,
    0xf6, 0x16, 0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff,
    0xb0, 0x2, 0xbf, 0xe8, 0xaf, 0xe0,

    /* U+E4 "ä" */
    0x4, 0xf9, 0x1, 0xdd, 0x0, 0x6, 0xfc, 0x2,
    0xff, 0x10, 0x0, 0x31, 0x0, 0x22, 0x0, 0x0,
    0x6c, 0xfe, 0xa2, 0x0, 0x9, 0xff, 0xff, 0xff,
    0x20, 0x1f, 0xf9, 0x3, 0xff, 0x80, 0x1, 0x10,
    0x0, 0xef, 0xa0, 0x1, 0x8d, 0xff, 0xff, 0xa0,
    0xd, 0xfe, 0x98, 0xff, 0xa0, 0x5f, 0xf4, 0x0,
    0xef, 0xa0, 0x5f, 0xf6, 0x16, 0xff, 0xa0, 0x1e,
    0xff, 0xff, 0xff, 0xb0, 0x2, 0xbf, 0xe8, 0xaf,
    0xe0,

    /* U+E5 "å" */
    0x0, 0x5, 0xdc, 0x20, 0x0, 0x0, 0xf, 0x16,
    0xb0, 0x0, 0x0, 0xf, 0x16, 0xb0, 0x0, 0x0,
    0x5, 0xdc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6c, 0xfe, 0xa2, 0x0, 0x9, 0xff,
    0xff, 0xff, 0x20, 0x1f, 0xf9, 0x3, 0xff, 0x80,
    0x1, 0x10, 0x0, 0xef, 0xa0, 0x1, 0x8d, 0xff,
    0xff, 0xa0, 0xd, 0xfe, 0x98, 0xff, 0xa0, 0x5f,
    0xf4, 0x0, 0xef, 0xa0, 0x5f, 0xf6, 0x16, 0xff,
    0xa0, 0x1e, 0xff, 0xff, 0xff, 0xb0, 0x2, 0xbf,
    0xe8, 0xaf, 0xe0,

    /* U+E6 "æ" */
    0x0, 0x5c, 0xee, 0xb3, 0x5c, 0xfe, 0xa1, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xf,
    0xfc, 0x34, 0xef, 0xfa, 0x25, 0xff, 0x60, 0x22,
    0x10, 0xa, 0xff, 0x0, 0xc, 0xfa, 0x2, 0x9e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0xef, 0xfd,
    0xce, 0xff, 0xcc, 0xcc, 0xc9, 0x5f, 0xf5, 0x0,
    0xaf, 0xf1, 0x0, 0x0, 0x5, 0xff, 0x72, 0x4d,
    0xff, 0xc3, 0x24, 0x90, 0x1e, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0x50, 0x2b, 0xef, 0xc6, 0x6,
    0xcf, 0xfc, 0x70,

    /* U+E7 "ç" */
    0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f, 0xff, 0xff,
    0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4, 0xff, 0x40,
    0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0, 0x48, 0x60,
    0xef, 0xc2, 0x3d, 0xfb, 0x5, 0xff, 0xff, 0xff,
    0x30, 0x4, 0xcf, 0xfb, 0x30, 0x0, 0x3, 0xfe,
    0x50, 0x0, 0x0, 0x4, 0xff, 0x0, 0x0, 0x0,
    0xbf, 0xe0, 0x0, 0x0, 0xf, 0xc3, 0x0,

    /* U+E8 "è" */
    0x2, 0xef, 0x90, 0x0, 0x0, 0x0, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x5, 0xda, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+E9 "é" */
    0x0, 0x0, 0x1e, 0xfa, 0x0, 0x0, 0x0, 0xaf,
    0xb0, 0x0, 0x0, 0x2, 0xcb, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+EA "ê" */
    0x0, 0x7, 0xfe, 0x20, 0x0, 0x0, 0x8f, 0xae,
    0xe2, 0x0, 0x3, 0xa7, 0x2, 0xa8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+EB "ë" */
    0x4, 0xf8, 0x1, 0xec, 0x0, 0x7, 0xfb, 0x3,
    0xff, 0x10, 0x0, 0x31, 0x0, 0x22, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x50, 0xd, 0xfd, 0x43, 0xcf, 0xd0, 0x2f, 0xf5,
    0x0, 0x4f, 0xf2, 0x4f, 0xff, 0xff, 0xff, 0xf3,
    0x5f, 0xfd, 0xcc, 0xcc, 0xc3, 0x3f, 0xf7, 0x0,
    0x0, 0x0, 0xd, 0xff, 0x62, 0x4d, 0x60, 0x3,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x2a, 0xef, 0xd8,
    0x0,

    /* U+EC "ì" */
    0x5f, 0xf4, 0x0, 0x7f, 0xe0, 0x0, 0x9d, 0x60,
    0x0, 0x0, 0x0, 0xdf, 0xb0, 0xd, 0xfb, 0x0,
    0xdf, 0xb0, 0xd, 0xfb, 0x0, 0xdf, 0xb0, 0xd,
    0xfb, 0x0, 0xdf, 0xb0, 0xd, 0xfb, 0x0, 0xdf,
    0xb0, 0xd, 0xfb,

    /* U+ED "í" */
    0x5, 0xff, 0x50, 0xef, 0x70, 0x6d, 0x80, 0x0,
    0x0, 0x0, 0xdf, 0xb0, 0xd, 0xfb, 0x0, 0xdf,
    0xb0, 0xd, 0xfb, 0x0, 0xdf, 0xb0, 0xd, 0xfb,
    0x0, 0xdf, 0xb0, 0xd, 0xfb, 0x0, 0xdf, 0xb0,
    0xd, 0xfb, 0x0,

    /* U+EE "î" */
    0x0, 0xbf, 0xa0, 0x1, 0xcf, 0x9f, 0xb0, 0x69,
    0x40, 0x49, 0x50, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd, 0xfb,
    0x0,

    /* U+EF "ï" */
    0x9f, 0x40, 0x5f, 0x8c, 0xf6, 0x7, 0xfb, 0x13,
    0x0, 0x3, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,

    /* U+F0 "ð" */
    0x0, 0x25, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf8,
    0x19, 0x40, 0x0, 0x9f, 0xff, 0xfd, 0x30, 0x0,
    0x2, 0xef, 0xfd, 0x0, 0x0, 0xb, 0xd9, 0xff,
    0x90, 0x0, 0x2, 0x0, 0xbf, 0xf1, 0x0, 0x5d,
    0xfe, 0xbf, 0xf6, 0x6, 0xff, 0xff, 0xff, 0xf9,
    0xe, 0xfe, 0x30, 0x4f, 0xfa, 0x2f, 0xf7, 0x0,
    0xd, 0xfb, 0x3f, 0xf5, 0x0, 0xe, 0xf9, 0x2f,
    0xf7, 0x0, 0x2f, 0xf6, 0xd, 0xfe, 0x53, 0xcf,
    0xf1, 0x3, 0xff, 0xff, 0xff, 0x50, 0x0, 0x2a,
    0xef, 0xc4, 0x0,

    /* U+F1 "ñ" */
    0x0, 0x6e, 0xb3, 0x5f, 0x40, 0x1, 0xfd, 0xdf,
    0xfe, 0x0, 0x2, 0xa3, 0x6, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x9e, 0xea,
    0x10, 0x1f, 0xff, 0xff, 0xff, 0xa0, 0x1f, 0xfe,
    0x43, 0xcf, 0xf0, 0x1f, 0xf7, 0x0, 0x7f, 0xf1,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,

    /* U+F2 "ò" */
    0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0x0, 0x1, 0xcc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+F3 "ó" */
    0x0, 0x0, 0xb, 0xfd, 0x10, 0x0, 0x0, 0x5f,
    0xe2, 0x0, 0x0, 0x0, 0xbc, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+F4 "ô" */
    0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x4f, 0xdb,
    0xf5, 0x0, 0x1, 0x99, 0x10, 0x89, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+F5 "õ" */
    0x0, 0x5e, 0xb3, 0x4f, 0x40, 0x0, 0xfd, 0xcf,
    0xfe, 0x0, 0x2, 0xa3, 0x6, 0x93, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+F6 "ö" */
    0x1, 0xec, 0x0, 0xbe, 0x20, 0x3, 0xff, 0x10,
    0xef, 0x40, 0x0, 0x22, 0x0, 0x13, 0x0, 0x0,
    0x3b, 0xef, 0xc5, 0x0, 0x4, 0xff, 0xff, 0xff,
    0x70, 0xe, 0xfe, 0x43, 0xcf, 0xf1, 0x3f, 0xf5,
    0x0, 0x3f, 0xf6, 0x6f, 0xf2, 0x0, 0xf, 0xf9,
    0x6f, 0xf2, 0x0, 0xf, 0xf8, 0x4f, 0xf5, 0x0,
    0x3f, 0xf6, 0xe, 0xfd, 0x43, 0xcf, 0xf1, 0x4,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x3b, 0xff, 0xc5,
    0x0,

    /* U+F7 "÷" */
    0x0, 0x1, 0xde, 0x30, 0x0, 0x0, 0x4, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x9a, 0x10, 0x0, 0x1,
    0x11, 0x11, 0x11, 0x10, 0x7f, 0xff, 0xff, 0xff,
    0xf9, 0x7f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9a, 0x10, 0x0,
    0x0, 0x4, 0xff, 0x70, 0x0, 0x0, 0x1, 0xde,
    0x30, 0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x3b, 0xef,
    0xdf, 0x10, 0x4, 0xff, 0xff, 0xff, 0x60, 0xe,
    0xfe, 0x48, 0xff, 0xf1, 0x3f, 0xf5, 0xd, 0xbf,
    0xf6, 0x6f, 0xf2, 0x5f, 0x1f, 0xf8, 0x6f, 0xf2,
    0xd9, 0xf, 0xf8, 0x3f, 0xfa, 0xf1, 0x3f, 0xf6,
    0xe, 0xff, 0xb3, 0xcf, 0xf1, 0x4, 0xff, 0xff,
    0xff, 0x70, 0x0, 0xce, 0xef, 0xc5, 0x0, 0x4,
    0xf2, 0x0, 0x0, 0x0,

    /* U+F9 "ù" */
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x1d, 0xf7,
    0x0, 0x0, 0x0, 0x2, 0xcc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+FA "ú" */
    0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x6f,
    0xe1, 0x0, 0x0, 0x0, 0xbc, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+FB "û" */
    0x0, 0x4, 0xff, 0x50, 0x0, 0x0, 0x5f, 0xbb,
    0xf5, 0x0, 0x1, 0x87, 0x0, 0x78, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+FC "ü" */
    0x1, 0xec, 0x0, 0xbe, 0x20, 0x3, 0xff, 0x0,
    0xef, 0x40, 0x0, 0x32, 0x0, 0x13, 0x0, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0xf, 0xf7, 0x0,
    0x6f, 0xf2, 0xe, 0xfd, 0x34, 0xdf, 0xf2, 0x9,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x9e, 0xeb, 0x7f,
    0xf2,

    /* U+FD "ý" */
    0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0x0, 0x5, 0xd9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0xdf,
    0xd0, 0x7f, 0xf3, 0x2, 0xff, 0x80, 0x2f, 0xf7,
    0x6, 0xff, 0x20, 0xc, 0xfc, 0xb, 0xfd, 0x0,
    0x7, 0xff, 0x1f, 0xf8, 0x0, 0x2, 0xff, 0xaf,
    0xf3, 0x0, 0x0, 0xdf, 0xff, 0xd0, 0x0, 0x0,
    0x7f, 0xff, 0x80, 0x0, 0x0, 0x2f, 0xff, 0x30,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0x2, 0x7f, 0xf3, 0x0, 0x0,
    0xf, 0xff, 0xb0, 0x0, 0x0, 0xd, 0xfa, 0x10,
    0x0, 0x0,

    /* U+FE "þ" */
    0xff, 0x80, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0x0, 0xff, 0x80, 0x0, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0xff, 0xaa, 0xfe, 0x90, 0xf, 0xff,
    0xff, 0xff, 0xa0, 0xff, 0xe4, 0x3c, 0xff, 0x2f,
    0xf8, 0x0, 0x3f, 0xf6, 0xff, 0x80, 0x0, 0xff,
    0x8f, 0xf8, 0x0, 0xf, 0xf7, 0xff, 0x80, 0x3,
    0xff, 0x5f, 0xfe, 0x43, 0xcf, 0xf1, 0xff, 0xff,
    0xff, 0xf9, 0xf, 0xfa, 0xaf, 0xe9, 0x0, 0xff,
    0x80, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0x0,

    /* U+FF "ÿ" */
    0x7, 0xf5, 0x3, 0xe9, 0x0, 0xa, 0xf8, 0x6,
    0xfd, 0x0, 0x0, 0x40, 0x0, 0x31, 0x0, 0xcf,
    0xe0, 0x0, 0xdf, 0xd0, 0x7f, 0xf3, 0x2, 0xff,
    0x80, 0x2f, 0xf7, 0x6, 0xff, 0x20, 0xc, 0xfc,
    0xb, 0xfd, 0x0, 0x7, 0xff, 0x1f, 0xf8, 0x0,
    0x2, 0xff, 0xaf, 0xf3, 0x0, 0x0, 0xdf, 0xff,
    0xd0, 0x0, 0x0, 0x7f, 0xff, 0x80, 0x0, 0x0,
    0x2f, 0xff, 0x30, 0x0, 0x0, 0xd, 0xfd, 0x0,
    0x0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0x2, 0x7f,
    0xf3, 0x0, 0x0, 0xf, 0xff, 0xb0, 0x0, 0x0,
    0xd, 0xfa, 0x10, 0x0, 0x0,

    /* U+100 "Ā" */
    0x0, 0xf, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x78, 0x88, 0x88, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x7, 0xfe, 0xdf, 0x80, 0x0, 0x0, 0x0, 0xdf,
    0x98, 0xfe, 0x0, 0x0, 0x0, 0x3f, 0xf4, 0x3f,
    0xf4, 0x0, 0x0, 0x8, 0xfe, 0x0, 0xdf, 0xa0,
    0x0, 0x0, 0xef, 0x90, 0x8, 0xff, 0x10, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xf6, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0xff, 0xb3, 0x33,
    0x39, 0xff, 0x20, 0x6f, 0xf5, 0x0, 0x0, 0x3f,
    0xf8, 0xc, 0xff, 0x0, 0x0, 0x0, 0xef, 0xd0,

    /* U+101 "ā" */
    0x2, 0xff, 0xff, 0xfe, 0x0, 0x1, 0x88, 0x88,
    0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6c, 0xfe, 0xa2, 0x0, 0x9, 0xff, 0xff, 0xff,
    0x20, 0x1f, 0xf9, 0x3, 0xff, 0x80, 0x1, 0x10,
    0x0, 0xef, 0xa0, 0x1, 0x8d, 0xff, 0xff, 0xa0,
    0xd, 0xfe, 0x98, 0xff, 0xa0, 0x5f, 0xf4, 0x0,
    0xef, 0xa0, 0x5f, 0xf6, 0x16, 0xff, 0xa0, 0x1e,
    0xff, 0xff, 0xff, 0xb0, 0x2, 0xbf, 0xe8, 0xaf,
    0xe0,

    /* U+102 "Ă" */
    0x0, 0x5, 0x40, 0x3, 0x50, 0x0, 0x0, 0x0,
    0xcf, 0x53, 0xee, 0x0, 0x0, 0x0, 0x3, 0xef,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x34, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0xed, 0xf8, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x43, 0xff, 0x40,
    0x0, 0x0, 0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f,
    0xf2, 0x6, 0xff, 0x50, 0x0, 0x3, 0xff, 0x80,
    0xcf, 0xf0, 0x0, 0x0, 0xe, 0xfd, 0x0,

    /* U+103 "ă" */
    0x1, 0xfd, 0x35, 0xfc, 0x0, 0x0, 0x7f, 0xff,
    0xe3, 0x0, 0x0, 0x1, 0x43, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x9, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xf9,
    0x3, 0xff, 0x80, 0x1, 0x10, 0x0, 0xef, 0xa0,
    0x1, 0x8d, 0xff, 0xff, 0xa0, 0xd, 0xfe, 0x98,
    0xff, 0xa0, 0x5f, 0xf4, 0x0, 0xef, 0xa0, 0x5f,
    0xf6, 0x16, 0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff,
    0xb0, 0x2, 0xbf, 0xe8, 0xaf, 0xe0,

    /* U+104 "Ą" */
    0x0, 0x0, 0x5f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x7f, 0xed, 0xf8,
    0x0, 0x0, 0x0, 0xd, 0xf9, 0x8f, 0xe0, 0x0,
    0x0, 0x3, 0xff, 0x43, 0xff, 0x40, 0x0, 0x0,
    0x8f, 0xe0, 0xd, 0xfa, 0x0, 0x0, 0xe, 0xf9,
    0x0, 0x8f, 0xf1, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xf, 0xfb, 0x33, 0x33, 0x9f, 0xf2, 0x6,
    0xff, 0x50, 0x0, 0x3, 0xff, 0x80, 0xcf, 0xf0,
    0x0, 0x0, 0xe, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xe5, 0x0,

    /* U+105 "ą" */
    0x0, 0x6c, 0xfe, 0xb2, 0x0, 0x9, 0xff, 0xff,
    0xff, 0x20, 0x1f, 0xf9, 0x3, 0xff, 0x80, 0x1,
    0x10, 0x0, 0xef, 0xa0, 0x1, 0x8d, 0xff, 0xff,
    0xa0, 0xd, 0xfe, 0x98, 0xff, 0xa0, 0x5f, 0xf4,
    0x0, 0xef, 0xa0, 0x5f, 0xf6, 0x16, 0xff, 0xa0,
    0x1e, 0xff, 0xff, 0xff, 0xc0, 0x2, 0xbf, 0xe8,
    0xaf, 0xe0, 0x0, 0x0, 0x2, 0xfc, 0x10, 0x0,
    0x0, 0x8, 0xf5, 0x0, 0x0, 0x0, 0x8, 0xfd,
    0x70, 0x0, 0x0, 0x1, 0xcf, 0x90,

    /* U+106 "Ć" */
    0x0, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x10, 0x0, 0x0, 0x0, 0xb, 0xc3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xce, 0xfd, 0x80, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0xf0,
    0x1f, 0xf9, 0x0, 0x0, 0x38, 0x81, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x37, 0x71, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0,

    /* U+107 "ć" */
    0x0, 0x0, 0x2f, 0xf8, 0x0, 0x0, 0xb, 0xfa,
    0x0, 0x0, 0x3, 0xda, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f,
    0xff, 0xff, 0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4,
    0xff, 0x40, 0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x48, 0x70, 0xef, 0xc3, 0x3d, 0xfb, 0x5, 0xff,
    0xff, 0xff, 0x30, 0x4, 0xcf, 0xfb, 0x30,

    /* U+108 "Ĉ" */
    0x0, 0x0, 0x4f, 0xf5, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0xaf, 0x60, 0x0, 0x0, 0x17, 0x70, 0x6,
    0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xce, 0xfd, 0x80, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0xf0,
    0x1f, 0xf9, 0x0, 0x0, 0x38, 0x81, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x37, 0x71, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0,

    /* U+109 "ĉ" */
    0x0, 0x9, 0xfd, 0x10, 0x0, 0x9, 0xfa, 0xed,
    0x10, 0x4, 0xa6, 0x3, 0xa7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f,
    0xff, 0xff, 0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4,
    0xff, 0x40, 0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x48, 0x70, 0xef, 0xc3, 0x3d, 0xfb, 0x5, 0xff,
    0xff, 0xff, 0x30, 0x4, 0xcf, 0xfb, 0x30,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x1d, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x5, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xce, 0xfd, 0x80, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0xc, 0xfe, 0x0, 0x0, 0xbf, 0xf0,
    0x1f, 0xf9, 0x0, 0x0, 0x38, 0x81, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x37, 0x71, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0,

    /* U+10B "ċ" */
    0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x8f, 0xe0,
    0x0, 0x0, 0x0, 0x63, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f,
    0xff, 0xff, 0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4,
    0xff, 0x40, 0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x48, 0x70, 0xef, 0xc3, 0x3d, 0xfb, 0x5, 0xff,
    0xff, 0xff, 0x30, 0x4, 0xcf, 0xfb, 0x30,

    /* U+10C "Č" */
    0x0, 0x1e, 0xf4, 0x3f, 0xf3, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x4f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x5, 0xce, 0xfd, 0x81, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfe, 0x20, 0x5, 0xff, 0xc5, 0x48,
    0xff, 0xb0, 0xc, 0xfe, 0x0, 0x0, 0x9f, 0xf1,
    0x1f, 0xf9, 0x0, 0x0, 0x1, 0x10, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x49, 0x91, 0xd, 0xfd,
    0x0, 0x0, 0xbf, 0xf0, 0x6, 0xff, 0xc5, 0x49,
    0xff, 0x90, 0x0, 0xaf, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x6, 0xcf, 0xfd, 0x70, 0x0,

    /* U+10D "č" */
    0x4, 0xfd, 0x18, 0xfb, 0x0, 0x4, 0xfe, 0xfa,
    0x0, 0x0, 0x4, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xb3, 0x0, 0x5f,
    0xff, 0xff, 0xf3, 0xe, 0xfd, 0x34, 0xef, 0xb4,
    0xff, 0x40, 0x6, 0xcb, 0x6f, 0xf2, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x48, 0x70, 0xef, 0xc3, 0x3d, 0xfb, 0x5, 0xff,
    0xff, 0xff, 0x30, 0x4, 0xcf, 0xfb, 0x30,

    /* U+10E "Ď" */
    0x6f, 0xc0, 0x9f, 0xb0, 0x0, 0x8, 0xfe, 0xfc,
    0x0, 0x0, 0x0, 0x9f, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xfc, 0x70,
    0x0, 0xdf, 0xff, 0xff, 0xfd, 0x20, 0xdf, 0xd3,
    0x38, 0xff, 0xd0, 0xdf, 0xc0, 0x0, 0x7f, 0xf5,
    0xdf, 0xc0, 0x0, 0xf, 0xfb, 0xdf, 0xc0, 0x0,
    0xd, 0xfd, 0xdf, 0xc0, 0x0, 0xc, 0xfe, 0xdf,
    0xc0, 0x0, 0xd, 0xfd, 0xdf, 0xc0, 0x0, 0xf,
    0xfb, 0xdf, 0xc0, 0x0, 0x7f, 0xf6, 0xdf, 0xd3,
    0x38, 0xff, 0xd0, 0xdf, 0xff, 0xff, 0xfd, 0x20,
    0xdf, 0xff, 0xfd, 0x70, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x8f, 0x50, 0x0,
    0x0, 0x6, 0xff, 0x29, 0xf3, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0xde, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x28, 0x60, 0x0, 0x7e, 0xfb, 0x8f, 0xf2, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0x20, 0x0, 0xe,
    0xfd, 0x43, 0xdf, 0xf2, 0x0, 0x3, 0xff, 0x50,
    0x6, 0xff, 0x20, 0x0, 0x5f, 0xf2, 0x0, 0x6f,
    0xf2, 0x0, 0x6, 0xff, 0x20, 0x6, 0xff, 0x20,
    0x0, 0x4f, 0xf4, 0x0, 0x6f, 0xf2, 0x0, 0x0,
    0xff, 0xc0, 0xb, 0xff, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x7, 0xef, 0xc6,
    0xff, 0x20, 0x0,

    /* U+110 "Đ" */
    0x0, 0x9f, 0xff, 0xfd, 0x92, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x9f, 0xf3,
    0x36, 0xef, 0xf2, 0x0, 0x9, 0xff, 0x0, 0x2,
    0xff, 0xa0, 0x0, 0x9f, 0xf0, 0x0, 0xb, 0xff,
    0x1, 0xad, 0xff, 0xaa, 0x0, 0x9f, 0xf1, 0x2f,
    0xff, 0xff, 0xf0, 0x7, 0xff, 0x20, 0x9, 0xff,
    0x0, 0x0, 0x9f, 0xf1, 0x0, 0x9f, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x9, 0xff, 0x0, 0x3, 0xff,
    0xa0, 0x0, 0x9f, 0xf3, 0x36, 0xef, 0xf2, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x9f,
    0xff, 0xfd, 0x92, 0x0, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x6,
    0xac, 0xff, 0xb5, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0, 0x7e,
    0xfb, 0x8f, 0xf2, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0x20, 0xe, 0xfd, 0x43, 0xdf, 0xf2, 0x3, 0xff,
    0x50, 0x6, 0xff, 0x20, 0x5f, 0xf2, 0x0, 0x6f,
    0xf2, 0x6, 0xff, 0x20, 0x6, 0xff, 0x20, 0x4f,
    0xf4, 0x0, 0x6f, 0xf2, 0x0, 0xff, 0xc0, 0xb,
    0xff, 0x20, 0x7, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x7, 0xef, 0xc6, 0xff, 0x20,

    /* U+112 "Ē" */
    0x7, 0xff, 0xff, 0xfa, 0x0, 0x38, 0x88, 0x88,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xfb, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xfd,
    0x33, 0x33, 0x32, 0xdf, 0xc0, 0x0, 0x0, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xfd,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xc2, 0x22,
    0x21, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfd, 0x33, 0x33, 0x32, 0xdf,
    0xff, 0xff, 0xff, 0xbd, 0xff, 0xff, 0xff, 0xfb,

    /* U+113 "ē" */
    0x3, 0xff, 0xff, 0xfd, 0x0, 0x1, 0x88, 0x88,
    0x86, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc4, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x50, 0xd, 0xfd, 0x43, 0xcf, 0xd0, 0x2f, 0xf5,
    0x0, 0x4f, 0xf2, 0x4f, 0xff, 0xff, 0xff, 0xf3,
    0x5f, 0xfd, 0xcc, 0xcc, 0xc3, 0x3f, 0xf7, 0x0,
    0x0, 0x0, 0xd, 0xff, 0x62, 0x4d, 0x60, 0x3,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x2a, 0xef, 0xd8,
    0x0,

    /* U+114 "Ĕ" */
    0x4, 0xb4, 0x2, 0xb6, 0x0, 0x2f, 0xe8, 0xdf,
    0x40, 0x0, 0x4c, 0xfd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+115 "ĕ" */
    0x2, 0xfc, 0x35, 0xfb, 0x0, 0x0, 0x8f, 0xff,
    0xe3, 0x0, 0x0, 0x1, 0x43, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+116 "Ė" */
    0x0, 0x1, 0x72, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+117 "ė" */
    0x0, 0x4, 0xeb, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x63, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+118 "Ę" */
    0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff, 0xff, 0xff,
    0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff, 0xfd, 0xd,
    0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x5, 0xfb, 0x0, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0xc, 0xfc, 0x40,
    0x0, 0x0, 0x4e, 0xf5, 0x0,

    /* U+119 "ę" */
    0x0, 0x2a, 0xef, 0xb3, 0x0, 0x2, 0xef, 0xff,
    0xff, 0x20, 0xb, 0xff, 0x53, 0xef, 0xb0, 0x1f,
    0xf9, 0x0, 0x6f, 0xf0, 0x4f, 0xf5, 0x0, 0x4f,
    0xf3, 0x5f, 0xff, 0xff, 0xff, 0xf4, 0x4f, 0xfd,
    0xcc, 0xcc, 0xc3, 0x1f, 0xf7, 0x0, 0x1, 0x0,
    0xa, 0xff, 0x74, 0x6e, 0x80, 0x1, 0xcf, 0xff,
    0xff, 0xa0, 0x0, 0x6, 0xbf, 0xe5, 0x0, 0x0,
    0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0xaf, 0xc6,
    0x0, 0x0, 0x0, 0x3d, 0xf7, 0x0,

    /* U+11A "Ě" */
    0x6, 0xfb, 0xa, 0xfa, 0x0, 0x8, 0xfe, 0xfb,
    0x0, 0x0, 0xa, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xbd, 0xff,
    0xff, 0xff, 0xfb, 0xdf, 0xd3, 0x33, 0x33, 0x2d,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xd0, 0xdf, 0xff, 0xff,
    0xfd, 0xd, 0xfc, 0x22, 0x22, 0x10, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x2d, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xb0,

    /* U+11B "ě" */
    0x3, 0xfd, 0x16, 0xfc, 0x0, 0x0, 0x3f, 0xef,
    0xb0, 0x0, 0x0, 0x4, 0xb9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc4,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0xd, 0xfd,
    0x43, 0xcf, 0xd0, 0x2f, 0xf5, 0x0, 0x4f, 0xf2,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfd, 0xcc,
    0xcc, 0xc3, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x62, 0x4d, 0x60, 0x3, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x2a, 0xef, 0xd8, 0x0,

    /* U+11C "Ĝ" */
    0x0, 0x0, 0x3e, 0xf6, 0x0, 0x0, 0x0, 0x4,
    0xfc, 0xaf, 0x60, 0x0, 0x0, 0x7, 0x70, 0x6,
    0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x30, 0x4, 0xff, 0xd5, 0x37,
    0xff, 0xc0, 0xb, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xf, 0xfb, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0xcf,
    0xff, 0xf4, 0x1f, 0xf9, 0x0, 0xcf, 0xff, 0xf4,
    0xf, 0xfb, 0x0, 0x0, 0x6f, 0xf4, 0xb, 0xff,
    0x20, 0x0, 0x6f, 0xf4, 0x4, 0xff, 0xe6, 0x35,
    0xcf, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x4, 0xbe, 0xfe, 0xb6, 0x0,

    /* U+11D "ĝ" */
    0x0, 0x6, 0xfe, 0x20, 0x0, 0x0, 0x7f, 0xbd,
    0xe2, 0x0, 0x2, 0xa8, 0x1, 0x99, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x5f,
    0xf4, 0x6, 0xff, 0xff, 0xff, 0xf4, 0xe, 0xfe,
    0x43, 0xbf, 0xf4, 0x4f, 0xf6, 0x0, 0x4f, 0xf4,
    0x5f, 0xf3, 0x0, 0x4f, 0xf4, 0x5f, 0xf2, 0x0,
    0x4f, 0xf4, 0x3f, 0xf6, 0x0, 0x4f, 0xf4, 0xe,
    0xfe, 0x43, 0xbf, 0xf4, 0x6, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x6d, 0xfc, 0x7f, 0xf4, 0x0, 0x10,
    0x0, 0x6f, 0xf3, 0x3, 0xe5, 0x13, 0xef, 0xe0,
    0x9, 0xff, 0xff, 0xff, 0x50, 0x0, 0x7d, 0xfe,
    0xb3, 0x0,

    /* U+11E "Ğ" */
    0x0, 0x9, 0xa0, 0x8, 0xb0, 0x0, 0x0, 0x9,
    0xfa, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x9e, 0xfb,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x30, 0x4, 0xff, 0xd5, 0x37,
    0xff, 0xc0, 0xb, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xf, 0xfb, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0xcf,
    0xff, 0xf4, 0x1f, 0xf9, 0x0, 0xcf, 0xff, 0xf4,
    0xf, 0xfb, 0x0, 0x0, 0x6f, 0xf4, 0xb, 0xff,
    0x20, 0x0, 0x6f, 0xf4, 0x4, 0xff, 0xe6, 0x35,
    0xcf, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x4, 0xbe, 0xfe, 0xb6, 0x0,

    /* U+11F "ğ" */
    0x1, 0xfb, 0x0, 0xfd, 0x0, 0x0, 0xdf, 0x47,
    0xf9, 0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x43, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x5f,
    0xf4, 0x6, 0xff, 0xff, 0xff, 0xf4, 0xe, 0xfe,
    0x43, 0xbf, 0xf4, 0x4f, 0xf6, 0x0, 0x4f, 0xf4,
    0x5f, 0xf3, 0x0, 0x4f, 0xf4, 0x5f, 0xf2, 0x0,
    0x4f, 0xf4, 0x3f, 0xf6, 0x0, 0x4f, 0xf4, 0xe,
    0xfe, 0x43, 0xbf, 0xf4, 0x6, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x6d, 0xfc, 0x7f, 0xf4, 0x0, 0x10,
    0x0, 0x6f, 0xf3, 0x3, 0xe5, 0x13, 0xef, 0xe0,
    0x9, 0xff, 0xff, 0xff, 0x50, 0x0, 0x7d, 0xfe,
    0xb3, 0x0,

    /* U+120 "Ġ" */
    0x0, 0x0, 0xc, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x30, 0x4, 0xff, 0xd5, 0x37,
    0xff, 0xc0, 0xb, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xf, 0xfb, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0xcf,
    0xff, 0xf4, 0x1f, 0xf9, 0x0, 0xcf, 0xff, 0xf4,
    0xf, 0xfb, 0x0, 0x0, 0x6f, 0xf4, 0xb, 0xff,
    0x20, 0x0, 0x6f, 0xf4, 0x4, 0xff, 0xe6, 0x35,
    0xcf, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x4, 0xbe, 0xfe, 0xb6, 0x0,

    /* U+121 "ġ" */
    0x0, 0x3, 0xec, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x64, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x5f,
    0xf4, 0x6, 0xff, 0xff, 0xff, 0xf4, 0xe, 0xfe,
    0x43, 0xbf, 0xf4, 0x4f, 0xf6, 0x0, 0x4f, 0xf4,
    0x5f, 0xf3, 0x0, 0x4f, 0xf4, 0x5f, 0xf2, 0x0,
    0x4f, 0xf4, 0x3f, 0xf6, 0x0, 0x4f, 0xf4, 0xe,
    0xfe, 0x43, 0xbf, 0xf4, 0x6, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x6d, 0xfc, 0x7f, 0xf4, 0x0, 0x10,
    0x0, 0x6f, 0xf3, 0x3, 0xe5, 0x13, 0xef, 0xe0,
    0x9, 0xff, 0xff, 0xff, 0x50, 0x0, 0x7d, 0xfe,
    0xb3, 0x0,

    /* U+122 "Ģ" */
    0x0, 0x5, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x30, 0x4, 0xff, 0xd5, 0x37,
    0xff, 0xc0, 0xb, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xf, 0xfb, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0xcf,
    0xff, 0xf4, 0x1f, 0xf9, 0x0, 0xcf, 0xff, 0xf4,
    0xf, 0xfb, 0x0, 0x0, 0x6f, 0xf4, 0xb, 0xff,
    0x20, 0x0, 0x6f, 0xf4, 0x4, 0xff, 0xe6, 0x35,
    0xcf, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x4, 0xbe, 0xfe, 0xb6, 0x0, 0x0, 0x0,
    0x4, 0x82, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x10, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0x1, 0x86, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d,
    0xfd, 0x5f, 0xf4, 0x6, 0xff, 0xff, 0xff, 0xf4,
    0xe, 0xfe, 0x43, 0xbf, 0xf4, 0x4f, 0xf6, 0x0,
    0x4f, 0xf4, 0x5f, 0xf3, 0x0, 0x4f, 0xf4, 0x5f,
    0xf2, 0x0, 0x4f, 0xf4, 0x3f, 0xf6, 0x0, 0x4f,
    0xf4, 0xe, 0xfe, 0x43, 0xbf, 0xf4, 0x6, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x6d, 0xfc, 0x7f, 0xf4,
    0x0, 0x10, 0x0, 0x6f, 0xf3, 0x3, 0xe5, 0x13,
    0xef, 0xe0, 0x9, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x7d, 0xfe, 0xb3, 0x0,

    /* U+124 "Ĥ" */
    0x0, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x0, 0xbf,
    0xcf, 0x60, 0x0, 0x0, 0xaf, 0x70, 0xbf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xc0,
    0x0, 0x1, 0xff, 0x9d, 0xfc, 0x0, 0x0, 0x1f,
    0xf9, 0xdf, 0xc0, 0x0, 0x1, 0xff, 0x9d, 0xfc,
    0x0, 0x0, 0x1f, 0xf9, 0xdf, 0xc0, 0x0, 0x1,
    0xff, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0x9d, 0xfd, 0x33, 0x33,
    0x4f, 0xf9, 0xdf, 0xc0, 0x0, 0x1, 0xff, 0x9d,
    0xfc, 0x0, 0x0, 0x1f, 0xf9, 0xdf, 0xc0, 0x0,
    0x1, 0xff, 0x9d, 0xfc, 0x0, 0x0, 0x1f, 0xf9,
    0xdf, 0xc0, 0x0, 0x1, 0xff, 0x90,

    /* U+125 "ĥ" */
    0x0, 0x3, 0x84, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0x60, 0x0, 0x5, 0xfb, 0x19, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x1f, 0xf7, 0x9f, 0xea, 0x10, 0x1f, 0xff, 0xff,
    0xff, 0x90, 0x1f, 0xfd, 0x43, 0xdf, 0xf0, 0x1f,
    0xf7, 0x0, 0x7f, 0xf1, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2,

    /* U+126 "Ħ" */
    0xb, 0xfe, 0x0, 0x0, 0xf, 0xfb, 0x0, 0xbf,
    0xe0, 0x0, 0x0, 0xff, 0xb0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc6, 0xef, 0xf9, 0x99, 0x99,
    0xff, 0xd7, 0xb, 0xfe, 0x0, 0x0, 0xf, 0xfb,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0xbf, 0xf3,
    0x33, 0x33, 0xff, 0xb0, 0xb, 0xfe, 0x0, 0x0,
    0xf, 0xfb, 0x0, 0xbf, 0xe0, 0x0, 0x0, 0xff,
    0xb0, 0xb, 0xfe, 0x0, 0x0, 0xf, 0xfb, 0x0,
    0xbf, 0xe0, 0x0, 0x0, 0xff, 0xb0, 0xb, 0xfe,
    0x0, 0x0, 0xf, 0xfb, 0x0,

    /* U+127 "ħ" */
    0x0, 0xdf, 0xb0, 0x0, 0x0, 0x4, 0xaf, 0xfe,
    0xa7, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xb7, 0xef, 0xb2, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0xdf, 0xf6, 0x2a, 0xff, 0x30, 0xd,
    0xfb, 0x0, 0x2f, 0xf5, 0x0, 0xdf, 0xb0, 0x2,
    0xff, 0x60, 0xd, 0xfb, 0x0, 0x2f, 0xf6, 0x0,
    0xdf, 0xb0, 0x2, 0xff, 0x60, 0xd, 0xfb, 0x0,
    0x2f, 0xf6, 0x0, 0xdf, 0xb0, 0x2, 0xff, 0x60,
    0xd, 0xfb, 0x0, 0x2f, 0xf6,

    /* U+128 "Ĩ" */
    0x6, 0x95, 0x7, 0x95, 0xff, 0xff, 0xfa, 0x69,
    0x4, 0x98, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0xbf, 0xf0, 0x0,

    /* U+129 "ĩ" */
    0x1c, 0xe6, 0xd, 0xb9, 0xfb, 0xff, 0xf6, 0x87,
    0x2, 0x96, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd, 0xfb,
    0x0,

    /* U+12A "Ī" */
    0x6f, 0xff, 0xff, 0xa3, 0x88, 0x88, 0x85, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff, 0x0,

    /* U+12B "ī" */
    0x8f, 0xff, 0xff, 0x84, 0x88, 0x88, 0x84, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,

    /* U+12C "Ĭ" */
    0x3b, 0x50, 0x2b, 0x61, 0xfe, 0x8c, 0xf5, 0x4,
    0xcf, 0xd6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0xbf, 0xf0, 0x0,

    /* U+12D "ĭ" */
    0x7f, 0x50, 0x6f, 0x62, 0xfe, 0x8e, 0xf2, 0x5,
    0xdf, 0xc4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xb0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0xd, 0xfb,
    0x0,

    /* U+12E "Į" */
    0xb, 0xff, 0xb, 0xff, 0xb, 0xff, 0xb, 0xff,
    0xb, 0xff, 0xb, 0xff, 0xb, 0xff, 0xb, 0xff,
    0xb, 0xff, 0xb, 0xff, 0xb, 0xff, 0xb, 0xff,
    0xd, 0xff, 0x3f, 0xc1, 0xbf, 0x20, 0xbf, 0xc5,
    0x3d, 0xf7,

    /* U+12F "į" */
    0xa, 0xf7, 0xf, 0xfc, 0x6, 0xa3, 0x0, 0x0,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xf, 0xfa, 0x5f, 0xa0, 0xdf, 0x0,
    0xef, 0xb3, 0x5e, 0xe4,

    /* U+130 "İ" */
    0x17, 0x29, 0xfd, 0x6f, 0x90, 0x0, 0xbf, 0xfb,
    0xff, 0xbf, 0xfb, 0xff, 0xbf, 0xfb, 0xff, 0xbf,
    0xfb, 0xff, 0xbf, 0xfb, 0xff, 0xbf, 0xfb, 0xff,
    0xbf, 0xf0,

    /* U+131 "ı" */
    0xdf, 0xbd, 0xfb, 0xdf, 0xbd, 0xfb, 0xdf, 0xbd,
    0xfb, 0xdf, 0xbd, 0xfb, 0xdf, 0xbd, 0xfb,

    /* U+132 "Ĳ" */
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0xf3, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x7f, 0xf3, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x7f, 0xf3, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x7f, 0xf3, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x7f, 0xf3, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x7f, 0xf3, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f,
    0xf3, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0xf3,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0xbf,
    0xf0, 0x5e, 0xe4, 0x0, 0x8f, 0xf1, 0xbf, 0xf0,
    0x3f, 0xfa, 0x12, 0xef, 0xd0, 0xbf, 0xf0, 0xa,
    0xff, 0xff, 0xff, 0x40, 0xbf, 0xf0, 0x0, 0x7d,
    0xfe, 0xb3, 0x0,

    /* U+133 "ĳ" */
    0xa, 0xf7, 0x1, 0xde, 0x30, 0xff, 0xc0, 0x4f,
    0xf7, 0x6, 0xa3, 0x0, 0x89, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x1, 0xff, 0x70, 0xef,
    0xa0, 0x1f, 0xf7, 0xe, 0xfa, 0x1, 0xff, 0x70,
    0xef, 0xa0, 0x1f, 0xf7, 0xe, 0xfa, 0x1, 0xff,
    0x70, 0xef, 0xa0, 0x1f, 0xf7, 0xe, 0xfa, 0x1,
    0xff, 0x70, 0xef, 0xa0, 0x1f, 0xf7, 0xe, 0xfa,
    0x1, 0xff, 0x70, 0xef, 0xa0, 0x1f, 0xf7, 0x0,
    0x0, 0x1, 0xff, 0x60, 0x0, 0x2, 0x8f, 0xf4,
    0x0, 0x1, 0xff, 0xfe, 0x0, 0x0, 0xe, 0xfb,
    0x20,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x1,
    0xcf, 0x8f, 0xc0, 0x0, 0x0, 0x58, 0x30, 0x38,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xe0, 0x9,
    0xff, 0x10, 0xd, 0xfd, 0x0, 0x6f, 0xfa, 0x37,
    0xff, 0x90, 0x0, 0xdf, 0xff, 0xff, 0xe1, 0x0,
    0x1, 0x9e, 0xfe, 0x91, 0x0, 0x0,

    /* U+135 "ĵ" */
    0x0, 0xcf, 0xa0, 0x1, 0xcf, 0x9f, 0xa0, 0x7a,
    0x40, 0x6a, 0x40, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xd0, 0x0, 0xb, 0xfd, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0xb, 0xfd, 0x0, 0x0, 0xbf, 0xd0, 0x0,
    0xb, 0xfd, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0xb,
    0xfd, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0xb, 0xfd,
    0x0, 0x0, 0xbf, 0xd0, 0x1, 0x3e, 0xfa, 0x0,
    0xaf, 0xff, 0x40, 0xa, 0xfd, 0x50, 0x0,

    /* U+136 "Ķ" */
    0xdf, 0xc0, 0x0, 0x3f, 0xfe, 0x1d, 0xfc, 0x0,
    0x1d, 0xff, 0x40, 0xdf, 0xc0, 0xb, 0xff, 0x70,
    0xd, 0xfc, 0x7, 0xff, 0xb0, 0x0, 0xdf, 0xc3,
    0xff, 0xd0, 0x0, 0xd, 0xfd, 0xef, 0xf2, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0x50, 0x0, 0xd, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0xdf, 0xf7, 0x6f, 0xfa,
    0x0, 0xd, 0xfd, 0x0, 0xcf, 0xf4, 0x0, 0xdf,
    0xc0, 0x2, 0xff, 0xe0, 0xd, 0xfc, 0x0, 0x8,
    0xff, 0x90, 0xdf, 0xc0, 0x0, 0xd, 0xff, 0x40,
    0x0, 0x18, 0x50, 0x0, 0x0, 0x0, 0x3, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0xa, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0xf, 0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0xf,
    0xf8, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x1, 0xef,
    0xe2, 0xf, 0xf8, 0xc, 0xff, 0x40, 0xf, 0xf8,
    0x9f, 0xf7, 0x0, 0xf, 0xfd, 0xff, 0x90, 0x0,
    0xf, 0xff, 0xff, 0x40, 0x0, 0xf, 0xff, 0xff,
    0xd0, 0x0, 0xf, 0xfd, 0x5f, 0xf8, 0x0, 0xf,
    0xf8, 0xa, 0xff, 0x30, 0xf, 0xf8, 0x1, 0xff,
    0xd0, 0xf, 0xf8, 0x0, 0x6f, 0xf7, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x0, 0x0, 0xfd, 0x0, 0x0,
    0x0, 0x2, 0xfa, 0x0, 0x0, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,

    /* U+138 "ĸ" */
    0xdf, 0xb0, 0x6, 0xff, 0xc0, 0xdf, 0xb0, 0x1e,
    0xff, 0x20, 0xdf, 0xb0, 0x9f, 0xf7, 0x0, 0xdf,
    0xb3, 0xff, 0xc0, 0x0, 0xdf, 0xff, 0xff, 0x20,
    0x0, 0xdf, 0xff, 0xff, 0x20, 0x0, 0xdf, 0xd8,
    0xff, 0xc0, 0x0, 0xdf, 0xb0, 0xaf, 0xf8, 0x0,
    0xdf, 0xb0, 0x1e, 0xff, 0x30, 0xdf, 0xb0, 0x5,
    0xff, 0xd0,

    /* U+139 "Ĺ" */
    0x2, 0xcd, 0x50, 0x0, 0x0, 0xcf, 0xa0, 0x0,
    0x0, 0x6f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0,
    0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf,
    0xd3, 0x33, 0x33, 0x1d, 0xff, 0xff, 0xff, 0xf6,
    0xdf, 0xff, 0xff, 0xff, 0x60,

    /* U+13A "ĺ" */
    0x4, 0xdc, 0x30, 0xef, 0x80, 0x8f, 0xa0, 0x0,
    0x0, 0x0, 0xef, 0xa0, 0xe, 0xfa, 0x0, 0xef,
    0xa0, 0xe, 0xfa, 0x0, 0xef, 0xa0, 0xe, 0xfa,
    0x0, 0xef, 0xa0, 0xe, 0xfa, 0x0, 0xef, 0xa0,
    0xe, 0xfa, 0x0, 0xef, 0xa0, 0xe, 0xfa, 0x0,
    0xef, 0xa0, 0xe, 0xfa, 0x0,

    /* U+13B "Ļ" */
    0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0, 0x0,
    0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x1d, 0xff, 0xff, 0xff, 0xf6, 0xdf, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x58, 0x10, 0x0, 0x0,
    0xa, 0xf3, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0,

    /* U+13C "ļ" */
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa, 0xe, 0xfa,
    0xe, 0xfa, 0xe, 0xfa, 0x4, 0x82, 0x8, 0xf4,
    0xb, 0xf1, 0xe, 0xa0, 0x1, 0x10,

    /* U+13D "Ľ" */
    0xdf, 0xc0, 0xe, 0xf0, 0xd, 0xfc, 0x0, 0xfd,
    0x0, 0xdf, 0xc0, 0x4f, 0x80, 0xd, 0xfc, 0x1,
    0x90, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x1d, 0xff, 0xff, 0xff, 0xf6, 0xdf, 0xff,
    0xff, 0xff, 0x60,

    /* U+13E "ľ" */
    0xef, 0xa0, 0xfd, 0xef, 0xa1, 0xfc, 0xef, 0xa5,
    0xf7, 0xef, 0xa3, 0xa0, 0xef, 0xa0, 0x0, 0xef,
    0xa0, 0x0, 0xef, 0xa0, 0x0, 0xef, 0xa0, 0x0,
    0xef, 0xa0, 0x0, 0xef, 0xa0, 0x0, 0xef, 0xa0,
    0x0, 0xef, 0xa0, 0x0, 0xef, 0xa0, 0x0, 0xef,
    0xa0, 0x0,

    /* U+13F "Ŀ" */
    0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0, 0x0,
    0x0, 0xdf, 0xc0, 0x0, 0x0, 0xd, 0xfc, 0x0,
    0x0, 0x0, 0xdf, 0xc0, 0x7f, 0x70, 0xd, 0xfc,
    0xb, 0xfb, 0x0, 0xdf, 0xc0, 0x27, 0x20, 0xd,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xd3, 0x33,
    0x33, 0x1d, 0xff, 0xff, 0xff, 0xf6, 0xdf, 0xff,
    0xff, 0xff, 0x60,

    /* U+140 "ŀ" */
    0xef, 0xa0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0xef,
    0xa0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0xef, 0xa0,
    0x0, 0xe, 0xfa, 0x6, 0x40, 0xef, 0xa6, 0xff,
    0xe, 0xfa, 0x3e, 0xc0, 0xef, 0xa0, 0x0, 0xe,
    0xfa, 0x0, 0x0, 0xef, 0xa0, 0x0, 0xe, 0xfa,
    0x0, 0x0, 0xef, 0xa0, 0x0, 0xe, 0xfa, 0x0,
    0x0,

    /* U+141 "Ł" */
    0x9, 0xff, 0x10, 0x0, 0x0, 0x9, 0xff, 0x10,
    0x0, 0x0, 0x9, 0xff, 0x10, 0x0, 0x0, 0x9,
    0xff, 0x10, 0x0, 0x0, 0x9, 0xff, 0x36, 0x0,
    0x0, 0xa, 0xff, 0xff, 0x0, 0x0, 0xbf, 0xff,
    0x61, 0x0, 0x0, 0x5b, 0xff, 0x10, 0x0, 0x0,
    0x9, 0xff, 0x10, 0x0, 0x0, 0x9, 0xff, 0x10,
    0x0, 0x0, 0x9, 0xff, 0x33, 0x33, 0x32, 0x9,
    0xff, 0xff, 0xff, 0xfa, 0x9, 0xff, 0xff, 0xff,
    0xfa,

    /* U+142 "ł" */
    0x9, 0xff, 0x0, 0x9, 0xff, 0x0, 0x9, 0xff,
    0x0, 0x9, 0xff, 0x0, 0x9, 0xff, 0x0, 0x9,
    0xff, 0x72, 0x1b, 0xff, 0xf2, 0xbf, 0xff, 0x10,
    0x4a, 0xff, 0x0, 0x9, 0xff, 0x0, 0x9, 0xff,
    0x0, 0x9, 0xff, 0x0, 0x9, 0xff, 0x0, 0x9,
    0xff, 0x0,

    /* U+143 "Ń" */
    0x0, 0x0, 0x4, 0xdc, 0x30, 0x0, 0x0, 0x0,
    0xef, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf1,
    0x0, 0x1, 0xff, 0x8d, 0xff, 0xa0, 0x0, 0x1f,
    0xf8, 0xdf, 0xff, 0x40, 0x1, 0xff, 0x8d, 0xff,
    0xfd, 0x0, 0x1f, 0xf8, 0xdf, 0xef, 0xf7, 0x1,
    0xff, 0x8d, 0xfc, 0x9f, 0xf1, 0x1f, 0xf8, 0xdf,
    0xc1, 0xef, 0xa1, 0xff, 0x8d, 0xfc, 0x6, 0xff,
    0x5f, 0xf8, 0xdf, 0xc0, 0xc, 0xfe, 0xff, 0x8d,
    0xfc, 0x0, 0x3f, 0xff, 0xf8, 0xdf, 0xc0, 0x0,
    0x9f, 0xff, 0x8d, 0xfc, 0x0, 0x1, 0xef, 0xf8,
    0xdf, 0xc0, 0x0, 0x6, 0xff, 0x80,

    /* U+144 "ń" */
    0x0, 0x0, 0xb, 0xfd, 0x0, 0x0, 0x0, 0x5f,
    0xe1, 0x0, 0x0, 0x0, 0xbc, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x9e, 0xea,
    0x10, 0x1f, 0xff, 0xff, 0xff, 0xa0, 0x1f, 0xfe,
    0x43, 0xcf, 0xf0, 0x1f, 0xf7, 0x0, 0x7f, 0xf1,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,

    /* U+145 "Ņ" */
    0xdf, 0xf1, 0x0, 0x1, 0xff, 0x8d, 0xff, 0xa0,
    0x0, 0x1f, 0xf8, 0xdf, 0xff, 0x40, 0x1, 0xff,
    0x8d, 0xff, 0xfd, 0x0, 0x1f, 0xf8, 0xdf, 0xef,
    0xf7, 0x1, 0xff, 0x8d, 0xfc, 0x9f, 0xf1, 0x1f,
    0xf8, 0xdf, 0xc1, 0xef, 0xa1, 0xff, 0x8d, 0xfc,
    0x6, 0xff, 0x5f, 0xf8, 0xdf, 0xc0, 0xc, 0xfe,
    0xff, 0x8d, 0xfc, 0x0, 0x3f, 0xff, 0xf8, 0xdf,
    0xc0, 0x0, 0x9f, 0xff, 0x8d, 0xfc, 0x0, 0x1,
    0xef, 0xf8, 0xdf, 0xc0, 0x0, 0x6, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x40, 0x0, 0x0,

    /* U+146 "ņ" */
    0x1f, 0xf6, 0x9e, 0xea, 0x10, 0x1f, 0xff, 0xff,
    0xff, 0xa0, 0x1f, 0xfe, 0x43, 0xcf, 0xf0, 0x1f,
    0xf7, 0x0, 0x7f, 0xf1, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x77, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x0, 0x0,

    /* U+147 "Ň" */
    0x0, 0xaf, 0x90, 0xcf, 0x70, 0x0, 0x0, 0xbf,
    0xef, 0x80, 0x0, 0x0, 0x0, 0xdf, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf1,
    0x0, 0x1, 0xff, 0x8d, 0xff, 0xa0, 0x0, 0x1f,
    0xf8, 0xdf, 0xff, 0x40, 0x1, 0xff, 0x8d, 0xff,
    0xfd, 0x0, 0x1f, 0xf8, 0xdf, 0xef, 0xf7, 0x1,
    0xff, 0x8d, 0xfc, 0x9f, 0xf1, 0x1f, 0xf8, 0xdf,
    0xc1, 0xef, 0xa1, 0xff, 0x8d, 0xfc, 0x6, 0xff,
    0x5f, 0xf8, 0xdf, 0xc0, 0xc, 0xfe, 0xff, 0x8d,
    0xfc, 0x0, 0x3f, 0xff, 0xf8, 0xdf, 0xc0, 0x0,
    0x9f, 0xff, 0x8d, 0xfc, 0x0, 0x1, 0xef, 0xf8,
    0xdf, 0xc0, 0x0, 0x6, 0xff, 0x80,

    /* U+148 "ň" */
    0x1, 0xdf, 0x43, 0xfe, 0x20, 0x0, 0x1d, 0xff,
    0xe2, 0x0, 0x0, 0x1, 0xaa, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x9e, 0xea,
    0x10, 0x1f, 0xff, 0xff, 0xff, 0xa0, 0x1f, 0xfe,
    0x43, 0xcf, 0xf0, 0x1f, 0xf7, 0x0, 0x7f, 0xf1,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,

    /* U+149 "ŉ" */
    0x4f, 0x80, 0x0, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x20, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x69, 0xee, 0xa1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xa0, 0x1, 0xff, 0xe4, 0x3c, 0xff, 0x0, 0x1f,
    0xf7, 0x0, 0x7f, 0xf1, 0x1, 0xff, 0x70, 0x6,
    0xff, 0x20, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1,
    0xff, 0x70, 0x6, 0xff, 0x20, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1, 0xff, 0x70, 0x6, 0xff, 0x20,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2,

    /* U+14A "Ŋ" */
    0xef, 0xf1, 0x0, 0x1, 0xff, 0x8e, 0xff, 0xa0,
    0x0, 0x1f, 0xf8, 0xef, 0xff, 0x30, 0x1, 0xff,
    0x8e, 0xff, 0xfc, 0x0, 0x1f, 0xf8, 0xef, 0xdf,
    0xf6, 0x1, 0xff, 0x8e, 0xfc, 0x8f, 0xe1, 0x1f,
    0xf8, 0xef, 0xc0, 0xef, 0x91, 0xff, 0x8e, 0xfc,
    0x5, 0xff, 0x4f, 0xf8, 0xef, 0xc0, 0xb, 0xfd,
    0xff, 0x8e, 0xfc, 0x0, 0x2f, 0xff, 0xf8, 0xef,
    0xc0, 0x0, 0x9f, 0xff, 0x8e, 0xfc, 0x0, 0x1,
    0xef, 0xf8, 0xef, 0xc0, 0x0, 0x6, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x2f, 0xf7, 0x0, 0x0, 0x0,
    0x39, 0xff, 0x50, 0x0, 0x0, 0x1f, 0xff, 0xe0,
    0x0, 0x0, 0x1, 0xee, 0xb2, 0x0,

    /* U+14B "ŋ" */
    0xf, 0xf5, 0x8e, 0xea, 0x10, 0xf, 0xfd, 0xff,
    0xff, 0xa0, 0xf, 0xfd, 0x43, 0xcf, 0xf0, 0xf,
    0xf7, 0x0, 0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x5f,
    0xf3, 0xf, 0xf7, 0x0, 0x5f, 0xf3, 0xf, 0xf7,
    0x0, 0x5f, 0xf3, 0xf, 0xf7, 0x0, 0x5f, 0xf3,
    0xf, 0xf7, 0x0, 0x5f, 0xf3, 0xf, 0xf7, 0x0,
    0x5f, 0xf3, 0x0, 0x0, 0x0, 0x5f, 0xf2, 0x0,
    0x0, 0x12, 0xbf, 0xf0, 0x0, 0x0, 0x5f, 0xff,
    0xa0, 0x0, 0x0, 0x5f, 0xe9, 0x0,

    /* U+14C "Ō" */
    0x0, 0xd, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x6,
    0x88, 0x88, 0x82, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xfc, 0x10, 0x4, 0xff,
    0xd6, 0x49, 0xff, 0xa0, 0xc, 0xff, 0x10, 0x0,
    0xaf, 0xf2, 0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7,
    0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6,
    0x0, 0x0, 0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0,
    0x1f, 0xf9, 0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7,
    0xb, 0xff, 0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff,
    0xd5, 0x4a, 0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff,
    0xfd, 0x10, 0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+14D "ō" */
    0x0, 0xff, 0xff, 0xff, 0x10, 0x0, 0x78, 0x88,
    0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xc5, 0x0, 0x4, 0xff, 0xff, 0xff,
    0x70, 0xe, 0xfe, 0x43, 0xcf, 0xf1, 0x3f, 0xf5,
    0x0, 0x3f, 0xf6, 0x6f, 0xf2, 0x0, 0xf, 0xf9,
    0x6f, 0xf2, 0x0, 0xf, 0xf8, 0x4f, 0xf5, 0x0,
    0x3f, 0xf6, 0xe, 0xfd, 0x43, 0xcf, 0xf1, 0x4,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x3b, 0xff, 0xc5,
    0x0,

    /* U+14E "Ŏ" */
    0x0, 0x4, 0x50, 0x3, 0x51, 0x0, 0x0, 0xa,
    0xf6, 0x3d, 0xf1, 0x0, 0x0, 0x2, 0xdf, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x3, 0x41, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+14F "ŏ" */
    0x0, 0xdf, 0x43, 0xef, 0x0, 0x0, 0x4f, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x44, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+150 "Ő" */
    0x0, 0x0, 0x2f, 0xe1, 0xcf, 0x70, 0x0, 0x0,
    0xbf, 0x47, 0xf9, 0x0, 0x0, 0x2, 0xb7, 0x1b,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x10, 0x4, 0xff, 0xd6, 0x49,
    0xff, 0xa0, 0xc, 0xff, 0x10, 0x0, 0xaf, 0xf2,
    0x1f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0x2f, 0xf7,
    0x0, 0x0, 0x1f, 0xf9, 0x3f, 0xf6, 0x0, 0x0,
    0xf, 0xfa, 0x2f, 0xf7, 0x0, 0x0, 0x1f, 0xf9,
    0xf, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xb, 0xff,
    0x10, 0x0, 0xaf, 0xf2, 0x4, 0xff, 0xd5, 0x4a,
    0xff, 0xa0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,

    /* U+151 "ő" */
    0x0, 0x4, 0xfd, 0x1d, 0xf5, 0x0, 0xd, 0xf2,
    0xaf, 0x70, 0x0, 0x4b, 0x53, 0xb8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xc5,
    0x0, 0x4, 0xff, 0xff, 0xff, 0x70, 0xe, 0xfe,
    0x43, 0xcf, 0xf1, 0x3f, 0xf5, 0x0, 0x3f, 0xf6,
    0x6f, 0xf2, 0x0, 0xf, 0xf9, 0x6f, 0xf2, 0x0,
    0xf, 0xf8, 0x4f, 0xf5, 0x0, 0x3f, 0xf6, 0xe,
    0xfd, 0x43, 0xcf, 0xf1, 0x4, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3b, 0xff, 0xc5, 0x0,

    /* U+152 "Œ" */
    0x0, 0x5, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x7, 0xff, 0xa3, 0x24, 0xff, 0xb6, 0x66,
    0x66, 0x20, 0xef, 0xc0, 0x0, 0x1f, 0xf9, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x1, 0xff, 0x90,
    0x0, 0x0, 0x2, 0xff, 0x60, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0x90, 0x2f, 0xf6, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xf9, 0x2, 0xff, 0x60, 0x0, 0x1f,
    0xf9, 0x22, 0x22, 0x10, 0x1f, 0xf7, 0x0, 0x1,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xef, 0xb0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x0, 0x7, 0xff, 0x70,
    0x1, 0xff, 0xa3, 0x33, 0x33, 0x10, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x5,
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,

    /* U+153 "œ" */
    0x0, 0x2a, 0xef, 0xc6, 0x7, 0xdf, 0xe8, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xb0,
    0xc, 0xfe, 0x53, 0xbf, 0xff, 0x92, 0x8f, 0xf4,
    0x1f, 0xf8, 0x0, 0x1f, 0xff, 0x0, 0xf, 0xf7,
    0x3f, 0xf5, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf8,
    0x3f, 0xf4, 0x0, 0xe, 0xff, 0xcc, 0xcc, 0xc7,
    0x1f, 0xf7, 0x0, 0x1f, 0xff, 0x10, 0x0, 0x0,
    0xc, 0xfe, 0x42, 0xbf, 0xff, 0xb3, 0x25, 0x90,
    0x3, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xf2,
    0x0, 0x2a, 0xef, 0xd6, 0x6, 0xdf, 0xfc, 0x60,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0x6d, 0xc2, 0x0, 0x0, 0x0, 0x1f,
    0xf6, 0x0, 0x0, 0x0, 0xa, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xd7, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xdf, 0xd3, 0x34, 0xcf, 0xf6, 0xd, 0xfc,
    0x0, 0x2, 0xff, 0x90, 0xdf, 0xc0, 0x0, 0x1f,
    0xf8, 0xd, 0xfc, 0x0, 0x1a, 0xff, 0x50, 0xdf,
    0xff, 0xff, 0xff, 0xb0, 0xd, 0xff, 0xff, 0xff,
    0x90, 0x0, 0xdf, 0xd3, 0x3e, 0xfd, 0x0, 0xd,
    0xfc, 0x0, 0x7f, 0xf5, 0x0, 0xdf, 0xc0, 0x0,
    0xef, 0xd0, 0xd, 0xfc, 0x0, 0x7, 0xff, 0x50,
    0xdf, 0xc0, 0x0, 0xe, 0xfd, 0x0,

    /* U+155 "ŕ" */
    0x0, 0x3, 0xff, 0x70, 0x0, 0xcf, 0x90, 0x0,
    0x4d, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf8,
    0xbf, 0x50, 0xff, 0xff, 0xf5, 0xf, 0xff, 0x86,
    0x20, 0xff, 0x90, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0xff, 0x80, 0x0, 0xf, 0xf8, 0x0, 0x0, 0xff,
    0x80, 0x0, 0xf, 0xf8, 0x0, 0x0, 0xff, 0x80,
    0x0,

    /* U+156 "Ŗ" */
    0xdf, 0xff, 0xff, 0xd7, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xdf, 0xd3, 0x34, 0xcf, 0xf6,
    0xd, 0xfc, 0x0, 0x2, 0xff, 0x90, 0xdf, 0xc0,
    0x0, 0x1f, 0xf8, 0xd, 0xfc, 0x0, 0x1a, 0xff,
    0x50, 0xdf, 0xff, 0xff, 0xff, 0xb0, 0xd, 0xff,
    0xff, 0xff, 0x90, 0x0, 0xdf, 0xd3, 0x3e, 0xfd,
    0x0, 0xd, 0xfc, 0x0, 0x7f, 0xf5, 0x0, 0xdf,
    0xc0, 0x0, 0xef, 0xd0, 0xd, 0xfc, 0x0, 0x7,
    0xff, 0x50, 0xdf, 0xc0, 0x0, 0xe, 0xfd, 0x0,
    0x0, 0x48, 0x20, 0x0, 0x0, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x0, 0x0, 0xff, 0x8b, 0xf5, 0xf,
    0xff, 0xff, 0x50, 0xff, 0xf8, 0x62, 0xf, 0xf9,
    0x0, 0x0, 0xff, 0x80, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0xff, 0x80, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0xff, 0x80, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x58,
    0x10, 0x0, 0xa, 0xf3, 0x0, 0x0, 0xdf, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+158 "Ř" */
    0xb, 0xf7, 0x1d, 0xf5, 0x0, 0x0, 0xd, 0xfe,
    0xf6, 0x0, 0x0, 0x0, 0x1e, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xd7, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xdf, 0xd3, 0x34, 0xcf, 0xf6, 0xd, 0xfc,
    0x0, 0x2, 0xff, 0x90, 0xdf, 0xc0, 0x0, 0x1f,
    0xf8, 0xd, 0xfc, 0x0, 0x1a, 0xff, 0x50, 0xdf,
    0xff, 0xff, 0xff, 0xb0, 0xd, 0xff, 0xff, 0xff,
    0x90, 0x0, 0xdf, 0xd3, 0x3e, 0xfd, 0x0, 0xd,
    0xfc, 0x0, 0x7f, 0xf5, 0x0, 0xdf, 0xc0, 0x0,
    0xef, 0xd0, 0xd, 0xfc, 0x0, 0x7, 0xff, 0x50,
    0xdf, 0xc0, 0x0, 0xe, 0xfd, 0x0,

    /* U+159 "ř" */
    0x5f, 0xc0, 0x9f, 0x90, 0x5, 0xfe, 0xf8, 0x0,
    0x0, 0x49, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf8, 0xbf, 0x50, 0xf, 0xff, 0xff, 0x50,
    0xf, 0xff, 0x86, 0x20, 0xf, 0xf9, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,

    /* U+15A "Ś" */
    0x0, 0x0, 0x2, 0xff, 0x80, 0x0, 0x0, 0x0,
    0xbf, 0xa0, 0x0, 0x0, 0x0, 0x3d, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0xdf, 0xeb, 0x40, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0x70, 0xc, 0xff, 0x73, 0x5d, 0xff, 0x10, 0xff,
    0xb0, 0x0, 0x4f, 0xf5, 0xc, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xc7, 0x10, 0x0, 0x0,
    0x2b, 0xff, 0xff, 0x90, 0x0, 0x0, 0x2, 0x8e,
    0xff, 0xb0, 0x13, 0x30, 0x0, 0x9, 0xff, 0x44,
    0xff, 0x60, 0x0, 0x4f, 0xf6, 0xe, 0xfe, 0x63,
    0x4c, 0xff, 0x40, 0x4f, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x29, 0xdf, 0xec, 0x60, 0x0,

    /* U+15B "ś" */
    0x0, 0x0, 0x2f, 0xf7, 0x0, 0x0, 0xc, 0xfa,
    0x0, 0x0, 0x4, 0xda, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0xfe, 0xa2, 0x0, 0xbf,
    0xfe, 0xff, 0xe1, 0x2f, 0xf6, 0x3, 0xff, 0x71,
    0xff, 0x91, 0x2, 0x21, 0x9, 0xff, 0xfd, 0x81,
    0x0, 0x4, 0xaf, 0xff, 0xe1, 0x24, 0x30, 0x5,
    0xff, 0x85, 0xff, 0x30, 0x1f, 0xf8, 0xc, 0xff,
    0xef, 0xff, 0x20, 0x8, 0xdf, 0xea, 0x20,

    /* U+15C "Ŝ" */
    0x0, 0x0, 0x9f, 0xd1, 0x0, 0x0, 0x0, 0xaf,
    0x8e, 0xe2, 0x0, 0x0, 0x38, 0x40, 0x17, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0xdf, 0xeb, 0x40, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0x70, 0xc, 0xff, 0x73, 0x5d, 0xff, 0x10, 0xff,
    0xb0, 0x0, 0x4f, 0xf5, 0xc, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xc7, 0x10, 0x0, 0x0,
    0x2b, 0xff, 0xff, 0x90, 0x0, 0x0, 0x2, 0x8e,
    0xff, 0xb0, 0x13, 0x30, 0x0, 0x9, 0xff, 0x44,
    0xff, 0x60, 0x0, 0x4f, 0xf6, 0xe, 0xfe, 0x63,
    0x4c, 0xff, 0x40, 0x4f, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x29, 0xdf, 0xec, 0x60, 0x0,

    /* U+15D "ŝ" */
    0x0, 0x9, 0xfd, 0x10, 0x0, 0xa, 0xf9, 0xfd,
    0x10, 0x5, 0xa6, 0x3, 0xa7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0xfe, 0xa2, 0x0, 0xbf,
    0xfe, 0xff, 0xe1, 0x2f, 0xf6, 0x3, 0xff, 0x71,
    0xff, 0x91, 0x2, 0x21, 0x9, 0xff, 0xfd, 0x81,
    0x0, 0x4, 0xaf, 0xff, 0xe1, 0x24, 0x30, 0x5,
    0xff, 0x85, 0xff, 0x30, 0x1f, 0xf8, 0xc, 0xff,
    0xef, 0xff, 0x20, 0x8, 0xdf, 0xea, 0x20,

    /* U+15E "Ş" */
    0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x70, 0xc, 0xff, 0x73, 0x5d, 0xff,
    0x10, 0xff, 0xb0, 0x0, 0x4f, 0xf5, 0xc, 0xfe,
    0x30, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xc7, 0x10,
    0x0, 0x0, 0x2b, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x2, 0x8e, 0xff, 0xb0, 0x13, 0x30, 0x0, 0x9,
    0xff, 0x44, 0xff, 0x60, 0x0, 0x4f, 0xf6, 0xe,
    0xfe, 0x63, 0x4c, 0xff, 0x40, 0x4f, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x29, 0xef, 0xfc, 0x60, 0x0,
    0x0, 0x5, 0xfd, 0x40, 0x0, 0x0, 0x0, 0x6,
    0xfd, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xb0, 0x0,
    0x0, 0x0, 0x2e, 0xa1, 0x0, 0x0,

    /* U+15F "ş" */
    0x0, 0x7d, 0xfe, 0xa2, 0x0, 0xbf, 0xfe, 0xff,
    0xe1, 0x2f, 0xf6, 0x3, 0xff, 0x71, 0xff, 0x91,
    0x2, 0x21, 0x9, 0xff, 0xfd, 0x81, 0x0, 0x5,
    0xbf, 0xff, 0xe1, 0x14, 0x30, 0x5, 0xff, 0x85,
    0xff, 0x30, 0x1f, 0xf8, 0xc, 0xff, 0xdf, 0xff,
    0x20, 0x8, 0xef, 0xfa, 0x20, 0x0, 0x6, 0xfc,
    0x20, 0x0, 0x0, 0x18, 0xfc, 0x0, 0x0, 0x2,
    0xcf, 0xb0, 0x0, 0x0, 0x3e, 0xa1, 0x0,

    /* U+160 "Š" */
    0x0, 0x5f, 0xd1, 0x8f, 0xc0, 0x0, 0x0, 0x7f,
    0xef, 0xd1, 0x0, 0x0, 0x0, 0xaf, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x29,
    0xdf, 0xec, 0x50, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xa0, 0xc, 0xff, 0x73, 0x4b, 0xff, 0x30, 0xff,
    0xb0, 0x0, 0x17, 0x72, 0xc, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xc7, 0x10, 0x0, 0x0,
    0x2b, 0xff, 0xff, 0x90, 0x0, 0x0, 0x2, 0x8e,
    0xff, 0xb0, 0x25, 0x51, 0x0, 0x9, 0xff, 0x44,
    0xff, 0x60, 0x0, 0x4f, 0xf6, 0xe, 0xfe, 0x63,
    0x4c, 0xff, 0x40, 0x4f, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x19, 0xdf, 0xec, 0x60, 0x0,

    /* U+161 "š" */
    0x5, 0xfc, 0x18, 0xfa, 0x0, 0x5, 0xfe, 0xfa,
    0x0, 0x0, 0x5, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0xfe, 0xa2, 0x0, 0xbf,
    0xfe, 0xff, 0xe1, 0x2f, 0xf6, 0x3, 0xff, 0x71,
    0xff, 0x91, 0x2, 0x21, 0x9, 0xff, 0xfd, 0x81,
    0x0, 0x4, 0xaf, 0xff, 0xe1, 0x24, 0x30, 0x5,
    0xff, 0x85, 0xff, 0x30, 0x1f, 0xf8, 0xc, 0xff,
    0xef, 0xff, 0x20, 0x8, 0xdf, 0xea, 0x20,

    /* U+162 "Ţ" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xca, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x23, 0x33, 0xdf, 0xe3, 0x33,
    0x20, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xe0, 0x0, 0x0,
    0x0, 0x8, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x2a,
    0xfa, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x90, 0x0,
    0x0, 0x0, 0x5e, 0x90, 0x0, 0x0,

    /* U+163 "ţ" */
    0x4, 0x88, 0x0, 0x0, 0x8f, 0xf0, 0x0, 0x8,
    0xff, 0x0, 0xe, 0xff, 0xff, 0xa0, 0xdf, 0xff,
    0xe9, 0x0, 0x8f, 0xf0, 0x0, 0x8, 0xff, 0x0,
    0x0, 0x8f, 0xf0, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x8f, 0xf0, 0x0, 0x7, 0xff, 0x52, 0x0, 0x3f,
    0xff, 0xb0, 0x0, 0x8f, 0xf9, 0x0, 0x4, 0xfe,
    0x50, 0x0, 0x5, 0xff, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x1f, 0xb2, 0x0,

    /* U+164 "Ť" */
    0x0, 0x7f, 0xb0, 0xaf, 0x90, 0x0, 0x0, 0x9f,
    0xef, 0xa0, 0x0, 0x0, 0x0, 0xbf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xca, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x23, 0x33, 0xdf, 0xe3, 0x33, 0x20, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0,
    0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0,

    /* U+165 "ť" */
    0x0, 0x0, 0x3, 0x83, 0x0, 0x0, 0x6, 0xf6,
    0x0, 0x0, 0x9, 0xf3, 0x4, 0x88, 0xe, 0xd0,
    0x8, 0xff, 0x1, 0x20, 0x8, 0xff, 0x0, 0x0,
    0xef, 0xff, 0xfa, 0x0, 0xdf, 0xff, 0xe9, 0x0,
    0x8, 0xff, 0x0, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x8, 0xff, 0x0, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x8, 0xff, 0x0, 0x0, 0x7, 0xff, 0x52, 0x0,
    0x3, 0xff, 0xfb, 0x0, 0x0, 0x7e, 0xf9, 0x0,

    /* U+166 "Ŧ" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xca, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x23, 0x33, 0xdf, 0xe3, 0x33,
    0x20, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x7a,
    0xef, 0xfa, 0x40, 0x0, 0xa, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x48, 0x80, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x8f, 0xf0, 0x0, 0xef, 0xff, 0xfa, 0xd, 0xff,
    0xfe, 0x90, 0x8, 0xff, 0x0, 0x2a, 0xdf, 0xfa,
    0x94, 0xff, 0xff, 0xfe, 0x0, 0x8f, 0xf0, 0x0,
    0x8, 0xff, 0x0, 0x0, 0x7f, 0xf5, 0x20, 0x4,
    0xff, 0xfb, 0x0, 0x7, 0xef, 0x90,

    /* U+168 "Ũ" */
    0x0, 0x39, 0x61, 0x4a, 0x10, 0x2, 0xff, 0xff,
    0xfd, 0x0, 0x3, 0xa2, 0x28, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+169 "ũ" */
    0x0, 0x6e, 0xb2, 0x5f, 0x40, 0x1, 0xfd, 0xdf,
    0xfe, 0x0, 0x2, 0xa2, 0x6, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+16A "Ū" */
    0x2, 0xff, 0xff, 0xff, 0x0, 0x1, 0x88, 0x88,
    0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xdf, 0xd0, 0x0, 0xf,
    0xfb, 0x8f, 0xfa, 0x34, 0xbf, 0xf6, 0x1d, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+16B "ū" */
    0x0, 0xff, 0xff, 0xff, 0x10, 0x0, 0x88, 0x88,
    0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0xf, 0xf7, 0x0,
    0x6f, 0xf2, 0xe, 0xfd, 0x34, 0xdf, 0xf2, 0x9,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x9e, 0xeb, 0x7f,
    0xf2,

    /* U+16C "Ŭ" */
    0x0, 0x53, 0x0, 0x44, 0x0, 0x0, 0xfe, 0x35,
    0xfc, 0x0, 0x0, 0x5f, 0xff, 0xe3, 0x0, 0x0,
    0x1, 0x43, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+16D "ŭ" */
    0x0, 0xee, 0x44, 0xef, 0x0, 0x0, 0x5f, 0xff,
    0xf6, 0x0, 0x0, 0x1, 0x44, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+16E "Ů" */
    0x0, 0x4, 0xdc, 0x20, 0x0, 0x0, 0xe, 0x25,
    0xb0, 0x0, 0x0, 0xf, 0x25, 0xc0, 0x0, 0x0,
    0x5, 0xdc, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xdf, 0xd0,
    0x0, 0xf, 0xfb, 0x8f, 0xfa, 0x34, 0xbf, 0xf6,
    0x1d, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x8d, 0xff,
    0xc7, 0x0,

    /* U+16F "ů" */
    0x0, 0x3, 0xcd, 0x40, 0x0, 0x0, 0xc, 0x43,
    0xe0, 0x0, 0x0, 0xd, 0x42, 0xe0, 0x0, 0x0,
    0x3, 0xcc, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0xf,
    0xf7, 0x0, 0x6f, 0xf2, 0xe, 0xfd, 0x34, 0xdf,
    0xf2, 0x9, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x9e,
    0xeb, 0x7f, 0xf2,

    /* U+170 "Ű" */
    0x0, 0x7, 0xfb, 0x2f, 0xf2, 0x0, 0x1f, 0xe1,
    0xcf, 0x40, 0x0, 0x6b, 0x35, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xdf, 0xd0, 0x0, 0xf, 0xfb, 0x8f, 0xfa,
    0x34, 0xbf, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x8d, 0xff, 0xc7, 0x0,

    /* U+171 "ű" */
    0x0, 0x5, 0xfd, 0x1e, 0xf4, 0x0, 0xe, 0xf2,
    0xaf, 0x60, 0x0, 0x5b, 0x53, 0xb7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7,
    0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2,
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0xf, 0xf7, 0x0, 0x6f, 0xf2, 0xe,
    0xfd, 0x34, 0xdf, 0xf2, 0x9, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x9e, 0xeb, 0x7f, 0xf2,

    /* U+172 "Ų" */
    0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0,
    0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff,
    0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd,
    0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd, 0xff, 0xa0,
    0x0, 0xd, 0xfd, 0xff, 0xa0, 0x0, 0xd, 0xfd,
    0xff, 0xa0, 0x0, 0xd, 0xfc, 0xdf, 0xd0, 0x0,
    0xf, 0xfb, 0x8f, 0xfa, 0x34, 0xbf, 0xf6, 0x1d,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x8d, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0, 0x0,
    0x4f, 0xea, 0x0, 0x0, 0x0, 0xa, 0xfd, 0x0,

    /* U+173 "ų" */
    0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0,
    0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0x1f,
    0xf7, 0x0, 0x6f, 0xf2, 0x1f, 0xf7, 0x0, 0x6f,
    0xf2, 0x1f, 0xf7, 0x0, 0x6f, 0xf2, 0xf, 0xf7,
    0x0, 0x6f, 0xf2, 0xe, 0xfd, 0x34, 0xdf, 0xf2,
    0x9, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x9e, 0xfb,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0xef, 0x40, 0x0,
    0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x4, 0xfe,
    0xa0, 0x0, 0x0, 0x0, 0xaf, 0xc0,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x0, 0x4f, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfe, 0xee, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xe2, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf0, 0x0, 0x5f, 0xf2, 0x0, 0x4f, 0xf5,
    0x5f, 0xf3, 0x0, 0x9f, 0xf5, 0x0, 0x7f, 0xf2,
    0x2f, 0xf6, 0x0, 0xcf, 0xf9, 0x0, 0xaf, 0xe0,
    0xe, 0xf9, 0x0, 0xff, 0xfc, 0x0, 0xdf, 0xb0,
    0xb, 0xfc, 0x3, 0xfe, 0xff, 0x0, 0xff, 0x70,
    0x7, 0xff, 0x7, 0xf9, 0xdf, 0x32, 0xff, 0x40,
    0x4, 0xff, 0x2b, 0xf5, 0x9f, 0x75, 0xff, 0x0,
    0x1, 0xff, 0x5e, 0xf1, 0x5f, 0xa8, 0xfd, 0x0,
    0x0, 0xdf, 0xbf, 0xe0, 0x1f, 0xeb, 0xf9, 0x0,
    0x0, 0x9f, 0xff, 0xa0, 0xd, 0xff, 0xf6, 0x0,
    0x0, 0x6f, 0xff, 0x60, 0xa, 0xff, 0xf2, 0x0,
    0x0, 0x3f, 0xff, 0x20, 0x6, 0xff, 0xf0, 0x0,
    0x0, 0xf, 0xfe, 0x0, 0x2, 0xff, 0xb0, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x0, 0xa, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0xb, 0xf8, 0xfc, 0x10, 0x0, 0x0, 0x4, 0x84,
    0x2, 0x85, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xc0, 0x7, 0xfa, 0x0, 0x9f,
    0xd6, 0xff, 0x0, 0xbf, 0xe0, 0xc, 0xf9, 0x2f,
    0xf3, 0xf, 0xff, 0x30, 0xff, 0x50, 0xef, 0x64,
    0xff, 0xf7, 0x3f, 0xf1, 0xa, 0xf9, 0x8f, 0x8f,
    0xc6, 0xfd, 0x0, 0x6f, 0xcd, 0xf1, 0xef, 0xaf,
    0x90, 0x2, 0xff, 0xfc, 0x9, 0xff, 0xf5, 0x0,
    0xe, 0xff, 0x80, 0x5f, 0xff, 0x10, 0x0, 0xbf,
    0xf3, 0x0, 0xff, 0xe0, 0x0, 0x7, 0xfe, 0x0,
    0xc, 0xfa, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x0, 0x6c, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xfe, 0xf8, 0x0, 0x0, 0x0, 0x6f, 0xb0, 0x9f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf2, 0x0, 0x0, 0xff, 0xd0, 0x3f, 0xf9,
    0x0, 0x7, 0xff, 0x50, 0xb, 0xff, 0x10, 0xe,
    0xfd, 0x0, 0x3, 0xff, 0x70, 0x5f, 0xf5, 0x0,
    0x0, 0xbf, 0xe0, 0xcf, 0xc0, 0x0, 0x0, 0x3f,
    0xf9, 0xff, 0x40, 0x0, 0x0, 0xb, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,

    /* U+177 "ŷ" */
    0x0, 0xa, 0xfc, 0x0, 0x0, 0x0, 0xcf, 0x8f,
    0xc1, 0x0, 0x5, 0x84, 0x2, 0x85, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0xdf,
    0xd0, 0x7f, 0xf3, 0x2, 0xff, 0x80, 0x2f, 0xf7,
    0x6, 0xff, 0x20, 0xc, 0xfc, 0xb, 0xfd, 0x0,
    0x7, 0xff, 0x1f, 0xf8, 0x0, 0x2, 0xff, 0xaf,
    0xf3, 0x0, 0x0, 0xdf, 0xff, 0xd0, 0x0, 0x0,
    0x7f, 0xff, 0x80, 0x0, 0x0, 0x2f, 0xff, 0x30,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0x2, 0x7f, 0xf3, 0x0, 0x0,
    0xf, 0xff, 0xb0, 0x0, 0x0, 0xd, 0xfa, 0x10,
    0x0, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0x4, 0x0, 0x3, 0x10, 0x0, 0x0, 0xaf,
    0x80, 0x6f, 0xd0, 0x0, 0x0, 0x7f, 0x50, 0x3e,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf2, 0x0, 0x0, 0xff, 0xd0, 0x3f, 0xf9,
    0x0, 0x7, 0xff, 0x50, 0xb, 0xff, 0x10, 0xe,
    0xfd, 0x0, 0x3, 0xff, 0x70, 0x5f, 0xf5, 0x0,
    0x0, 0xbf, 0xe0, 0xcf, 0xc0, 0x0, 0x0, 0x3f,
    0xf9, 0xff, 0x40, 0x0, 0x0, 0xb, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0x2, 0xcd, 0x50, 0x0, 0x0, 0x0,
    0xcf, 0xa0, 0x0, 0x0, 0x0, 0x6f, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x13, 0x33, 0x33, 0x7f, 0xf9, 0x0, 0x0,
    0x0, 0xd, 0xfd, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xef, 0xd0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x0, 0x0, 0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0,
    0x1e, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0x53,
    0x33, 0x33, 0x14, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x60,

    /* U+17A "ź" */
    0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0, 0xd, 0xf9,
    0x0, 0x0, 0x5, 0xda, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xf5, 0x2, 0x22, 0x4f, 0xfb, 0x0,
    0x0, 0xd, 0xfe, 0x10, 0x0, 0x9, 0xff, 0x40,
    0x0, 0x4, 0xff, 0x90, 0x0, 0x1, 0xef, 0xd0,
    0x0, 0x0, 0xbf, 0xf4, 0x11, 0x10, 0x4f, 0xff,
    0xff, 0xff, 0x85, 0xff, 0xff, 0xff, 0xf8,

    /* U+17B "Ż" */
    0x0, 0x0, 0x16, 0x20, 0x0, 0x0, 0x0, 0xb,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x13, 0x33, 0x33, 0x7f, 0xf9, 0x0, 0x0,
    0x0, 0xd, 0xfd, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xef, 0xd0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x0, 0x0, 0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0,
    0x1e, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0x53,
    0x33, 0x33, 0x14, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x60,

    /* U+17C "ż" */
    0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0x0, 0x1, 0x62, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xf5, 0x2, 0x22, 0x4f, 0xfb, 0x0,
    0x0, 0xd, 0xfe, 0x10, 0x0, 0x9, 0xff, 0x40,
    0x0, 0x4, 0xff, 0x90, 0x0, 0x1, 0xef, 0xd0,
    0x0, 0x0, 0xbf, 0xf4, 0x11, 0x10, 0x4f, 0xff,
    0xff, 0xff, 0x85, 0xff, 0xff, 0xff, 0xf8,

    /* U+17D "Ž" */
    0x0, 0x7f, 0xb0, 0xaf, 0x90, 0x0, 0x0, 0x9f,
    0xef, 0xb0, 0x0, 0x0, 0x0, 0xbf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x13, 0x33, 0x33, 0x7f, 0xf9, 0x0, 0x0,
    0x0, 0xd, 0xfd, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xef, 0xd0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x0, 0x0, 0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0,
    0x1e, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0x53,
    0x33, 0x33, 0x14, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x60,

    /* U+17E "ž" */
    0x5, 0xfc, 0x9, 0xf9, 0x0, 0x5, 0xfe, 0xf8,
    0x0, 0x0, 0x4, 0x96, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x63, 0xff,
    0xff, 0xff, 0xf5, 0x2, 0x22, 0x4f, 0xfb, 0x0,
    0x0, 0xd, 0xfe, 0x10, 0x0, 0x9, 0xff, 0x40,
    0x0, 0x4, 0xff, 0x90, 0x0, 0x1, 0xef, 0xd0,
    0x0, 0x0, 0xbf, 0xf4, 0x11, 0x10, 0x4f, 0xff,
    0xff, 0xff, 0x85, 0xff, 0xff, 0xff, 0xf8,

    /* U+17F "ſ" */
    0x7, 0xdf, 0xc7, 0xff, 0xfc, 0xdf, 0xd3, 0x2f,
    0xf9, 0x0, 0xff, 0x90, 0xf, 0xf9, 0x0, 0xff,
    0x90, 0xf, 0xf9, 0x0, 0xff, 0x90, 0xf, 0xf9,
    0x0, 0xff, 0x90, 0xf, 0xf9, 0x0, 0xff, 0x90,
    0xf, 0xf9, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48,
    0xdf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1, 0x6a,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xb7, 0x3f,
    0xf2, 0x0, 0x0, 0x5f, 0xff, 0xfe, 0x95, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x5, 0xff, 0x73, 0x0,
    0x0, 0x0, 0x1f, 0xf2, 0x0, 0x0, 0x5f, 0xe0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x20, 0x0, 0x5,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2, 0x0,
    0x0, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x5, 0xfe, 0x0, 0x0, 0x0, 0x69,
    0x8f, 0xf2, 0x0, 0x0, 0x5f, 0xe0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0x20, 0x3, 0x58, 0xfe, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf2, 0x2d, 0xff, 0xff,
    0xe0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0xb, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x4, 0xbd, 0xc8, 0x10,
    0xaf, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x51, 0x6, 0x88, 0x88, 0x88, 0x88, 0x88, 0x30,
    0x15, 0xf7, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb6, 0x8f, 0xfd, 0xcf, 0xf3, 0x33, 0x33, 0x33,
    0x6f, 0xec, 0xdf, 0xf2, 0xc, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x2f, 0xf2, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x2f, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf4, 0x2d,
    0xf9, 0x99, 0x99, 0x99, 0xbf, 0x92, 0x4f, 0xf2,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2f,
    0xfb, 0xaf, 0xf1, 0x11, 0x11, 0x11, 0x5f, 0xda,
    0xbf, 0xf9, 0x8e, 0xe0, 0x0, 0x0, 0x0, 0x3f,
    0xc8, 0x9f, 0xf2, 0xc, 0xe0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x2f, 0xf6, 0x4d, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0xa4, 0x6f, 0xfe, 0xef, 0xfb, 0xbb,
    0xbb, 0xbb, 0xcf, 0xfe, 0xef, 0xc2, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x2c,

    /* U+F00B "" */
    0x58, 0x88, 0x70, 0x28, 0x88, 0x88, 0x88, 0x88,
    0x85, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xd1, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xe1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
    0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x58, 0x88, 0x60, 0x27, 0x88, 0x88,
    0x88, 0x88, 0x85, 0x47, 0x77, 0x50, 0x17, 0x77,
    0x77, 0x77, 0x77, 0x74, 0xff, 0xff, 0xf3, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xf1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x90, 0x9, 0xd2, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x9f, 0xfe,
    0x20, 0x0, 0x8, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0xff, 0xe2, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x0,
    0x2e, 0xff, 0xfe, 0x28, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd8, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x2d, 0xb0, 0x0, 0x0, 0x6, 0xe6, 0xd, 0xff,
    0xc0, 0x0, 0x6, 0xff, 0xf3, 0xcf, 0xff, 0xc0,
    0x6, 0xff, 0xff, 0x31, 0xdf, 0xff, 0xc7, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x6, 0xff, 0xff, 0xdf,
    0xff, 0xc0, 0x6, 0xff, 0xff, 0x51, 0xdf, 0xff,
    0xc0, 0xff, 0xff, 0x50, 0x1, 0xdf, 0xff, 0x58,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xd0, 0x5, 0x30,
    0x0, 0x0, 0x1, 0x61, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe3, 0x3, 0xff,
    0xa0, 0xb, 0xc1, 0x0, 0x0, 0x8, 0xff, 0xb0,
    0x3f, 0xfa, 0x4, 0xff, 0xd1, 0x0, 0x4, 0xff,
    0xf6, 0x3, 0xff, 0xa0, 0x1e, 0xff, 0xa0, 0x0,
    0xdf, 0xf7, 0x0, 0x3f, 0xfa, 0x0, 0x2e, 0xff,
    0x40, 0x3f, 0xfc, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x6f, 0xfa, 0x8, 0xff, 0x60, 0x0, 0x3f, 0xfa,
    0x0, 0x0, 0xef, 0xf0, 0xaf, 0xf2, 0x0, 0x3,
    0xff, 0xa0, 0x0, 0xb, 0xff, 0x1b, 0xff, 0x10,
    0x0, 0x1f, 0xf8, 0x0, 0x0, 0xbf, 0xf1, 0x9f,
    0xf3, 0x0, 0x0, 0x24, 0x0, 0x0, 0xd, 0xff,
    0x6, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xd0, 0x1f, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf8, 0x0, 0x9f, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x9f, 0xfe, 0x10, 0x0, 0xcf, 0xfe,
    0x71, 0x0, 0x4, 0xcf, 0xff, 0x50, 0x0, 0x1,
    0xdf, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x28, 0xce, 0xfd, 0xa5,
    0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x4, 0x66, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x78, 0x17, 0xff, 0xff,
    0xff, 0x71, 0x87, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x3f, 0xff,
    0xff, 0xfe, 0x88, 0xef, 0xff, 0xff, 0xf3, 0x8,
    0xff, 0xff, 0xd0, 0x0, 0xd, 0xff, 0xff, 0x80,
    0x0, 0xaf, 0xff, 0x50, 0x0, 0x5, 0xff, 0xfa,
    0x0, 0x0, 0xbf, 0xff, 0x30, 0x0, 0x3, 0xff,
    0xfb, 0x0, 0x1, 0xcf, 0xff, 0x80, 0x0, 0x8,
    0xff, 0xfc, 0x10, 0x3e, 0xff, 0xff, 0xf6, 0x0,
    0x6f, 0xff, 0xff, 0xe3, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0x8e, 0xff, 0xff, 0xff, 0xe8, 0xfd, 0x0, 0x0,
    0x11, 0x1, 0x9f, 0xff, 0xf9, 0x10, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xee, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0x92, 0x0, 0x6b,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0xe4, 0xa, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xff, 0xff, 0xf6, 0xaf, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfe, 0x31, 0xcf, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x9f, 0xfd, 0x25, 0x70,
    0xaf, 0xff, 0xf2, 0x0, 0x0, 0x1, 0xbf, 0xfa,
    0x8, 0xff, 0xb0, 0x7f, 0xff, 0x40, 0x0, 0x2,
    0xdf, 0xf8, 0xa, 0xff, 0xff, 0xd2, 0x5f, 0xff,
    0x50, 0x4, 0xff, 0xf5, 0x1d, 0xff, 0xff, 0xff,
    0xe4, 0x2e, 0xff, 0x70, 0xdf, 0xe3, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x1c, 0xff, 0x13, 0xb1,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x9,
    0x60, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfd,
    0x88, 0xbf, 0xff, 0xfe, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x70, 0x3, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xf7, 0x0, 0x3f, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x70,
    0x3, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf5, 0x0, 0x2f, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x9, 0xaa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xee, 0xef, 0xff, 0xfe, 0xee, 0xc0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x24, 0x44, 0x44, 0x7,
    0xff, 0x70, 0x44, 0x44, 0x42, 0xff, 0xff, 0xff,
    0xc1, 0x66, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x66, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F01C "" */
    0x0, 0x0, 0x4, 0x44, 0x44, 0x44, 0x44, 0x41,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x6, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xa0, 0x0, 0x1, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x50, 0x0, 0xbf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfe, 0x10, 0x6f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0xfa, 0xe, 0xff, 0xcc, 0xcc, 0x20, 0x0, 0x0,
    0xbc, 0xcc, 0xef, 0xf2, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0x88, 0x8e, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x15, 0x66, 0x40, 0x0, 0x5,
    0xcb, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff, 0x92,
    0x7, 0xff, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x66, 0xff, 0x0, 0x8f, 0xff, 0xa4, 0x12,
    0x5b, 0xff, 0xfd, 0xff, 0x4, 0xff, 0xe4, 0x0,
    0x0, 0x0, 0x4e, 0xff, 0xff, 0xd, 0xff, 0x30,
    0x0, 0x0, 0x45, 0x46, 0xff, 0xff, 0x4f, 0xf7,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0x2, 0x10, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22,
    0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x67, 0x77, 0x77, 0x75, 0x0, 0x0,
    0x0, 0x6, 0x73, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x3f, 0xf6, 0xff, 0xff, 0xee, 0xfd,
    0x0, 0x0, 0x0, 0xcf, 0xf1, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xa0, 0xff, 0xff,
    0xfb, 0x20, 0x0, 0x2, 0xbf, 0xfe, 0x10, 0xff,
    0x8d, 0xff, 0xfc, 0xa9, 0xcf, 0xff, 0xe2, 0x0,
    0xff, 0x61, 0x9f, 0xff, 0xff, 0xff, 0xfb, 0x10,
    0x0, 0xff, 0x70, 0x1, 0x7c, 0xee, 0xd9, 0x30,
    0x0, 0x0, 0x56, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x2,
    0xef, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0, 0x3,
    0xef, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xdf,
    0xff, 0xf0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xf0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0x10, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3f, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xd, 0xf3, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x3f, 0x70, 0x8b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x40, 0x0, 0x0, 0x2d, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0x0, 0x0, 0x40, 0x1c,
    0xf4, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0,
    0x5f, 0xb0, 0x1e, 0xe1, 0x0, 0x0, 0x3, 0xef,
    0xff, 0x0, 0x0, 0xaf, 0xa0, 0x6f, 0x70, 0xdf,
    0xff, 0xff, 0xff, 0xf0, 0x7, 0x10, 0xbf, 0x30,
    0xfd, 0xf, 0xff, 0xff, 0xff, 0xff, 0x3, 0xfd,
    0x3, 0xf9, 0xa, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0xf5, 0xe, 0xc0, 0x8f, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x4f, 0x70, 0xdd, 0x7,
    0xf3, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1d, 0xf3,
    0xf, 0xb0, 0x9f, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0x3, 0xf7, 0x7, 0xf6, 0xc, 0xf0, 0x7b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x3, 0xfe, 0x12, 0xfa,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x3, 0xff,
    0x40, 0xaf, 0x30, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x3c, 0x30, 0x6f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x6f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x90, 0x0, 0x0,

    /* U+F03E "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xa3, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xd5, 0x6e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x50, 0x7,
    0xff, 0xff, 0xf5, 0x8, 0xff, 0xff, 0xff, 0xfb,
    0xbf, 0xff, 0xff, 0x50, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xf5, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xfc, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xc0, 0x0, 0x3, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0x74, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F048 "" */
    0x6b, 0x90, 0x0, 0x0, 0x3, 0xa2, 0x9f, 0xe0,
    0x0, 0x0, 0x4f, 0xf9, 0x9f, 0xe0, 0x0, 0x5,
    0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x6f, 0xff, 0xfa,
    0x9f, 0xe0, 0x7, 0xff, 0xff, 0xfa, 0x9f, 0xe0,
    0x8f, 0xff, 0xff, 0xfa, 0x9f, 0xe9, 0xff, 0xff,
    0xff, 0xfa, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9f, 0xfe,
    0xff, 0xff, 0xff, 0xfa, 0x9f, 0xe1, 0xdf, 0xff,
    0xff, 0xfa, 0x9f, 0xe0, 0x1c, 0xff, 0xff, 0xfa,
    0x9f, 0xe0, 0x0, 0xbf, 0xff, 0xfa, 0x9f, 0xe0,
    0x0, 0xa, 0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x0,
    0x9f, 0xfa, 0x9f, 0xe0, 0x0, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x3a, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x3a, 0xbb, 0xb9, 0x10, 0x3, 0xab, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xa0, 0xe, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xfe, 0x40, 0x7, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04D "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F051 "" */
    0x4a, 0x20, 0x0, 0x0, 0xa, 0xb4, 0xbf, 0xe3,
    0x0, 0x0, 0xf, 0xf8, 0xcf, 0xff, 0x40, 0x0,
    0xf, 0xf8, 0xcf, 0xff, 0xf5, 0x0, 0xf, 0xf8,
    0xcf, 0xff, 0xff, 0x60, 0xf, 0xf8, 0xcf, 0xff,
    0xff, 0xf7, 0xf, 0xf8, 0xcf, 0xff, 0xff, 0xff,
    0x9f, 0xf8, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xcf, 0xff,
    0xff, 0xff, 0xdf, 0xf8, 0xcf, 0xff, 0xff, 0xfc,
    0x1f, 0xf8, 0xcf, 0xff, 0xff, 0xb0, 0xf, 0xf8,
    0xcf, 0xff, 0xfa, 0x0, 0xf, 0xf8, 0xcf, 0xff,
    0x80, 0x0, 0xf, 0xf8, 0xbf, 0xf7, 0x0, 0x0,
    0xf, 0xf8, 0x7f, 0x60, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2, 0xca, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x34, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42, 0x0, 0x3, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x10, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f,
    0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0x20, 0x0, 0x0, 0x0, 0x3c, 0x60,

    /* U+F054 "" */
    0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xc1,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0,
    0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff,
    0x50, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x60, 0x0, 0x0, 0xe, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x3d, 0x50, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x39, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x36, 0x77, 0x77, 0xef, 0xfc, 0x77, 0x77, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x3, 0x68, 0x87, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xff, 0xff,
    0xff, 0xf9, 0x20, 0x0, 0x0, 0x0, 0x4, 0xef,
    0xfd, 0x63, 0x25, 0xbf, 0xff, 0x70, 0x0, 0x0,
    0x7, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xa0, 0x0, 0x6, 0xff, 0xfd, 0x0, 0x8, 0xfc,
    0x20, 0x9f, 0xff, 0xa0, 0x2, 0xff, 0xff, 0x50,
    0x0, 0x8f, 0xfe, 0x12, 0xff, 0xff, 0x60, 0xcf,
    0xff, 0xf2, 0x16, 0x7f, 0xff, 0xf5, 0xe, 0xff,
    0xfe, 0x1e, 0xff, 0xff, 0x12, 0xff, 0xff, 0xff,
    0x70, 0xdf, 0xff, 0xf2, 0x6f, 0xff, 0xf3, 0xe,
    0xff, 0xff, 0xf3, 0xf, 0xff, 0xfb, 0x0, 0xbf,
    0xff, 0x90, 0x4f, 0xff, 0xf8, 0x5, 0xff, 0xfe,
    0x10, 0x1, 0xdf, 0xff, 0x40, 0x28, 0x84, 0x1,
    0xef, 0xff, 0x30, 0x0, 0x1, 0xbf, 0xff, 0x60,
    0x0, 0x4, 0xef, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x6e, 0xff, 0xfb, 0xbe, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xad, 0xff, 0xeb, 0x71,
    0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x4a, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0x60, 0x0, 0x15, 0x78, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xa6, 0xdf, 0xff,
    0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xe8, 0x32, 0x5b, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xf6, 0x0, 0x10,
    0x6, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xf8, 0x7f, 0xd3, 0x9, 0xff, 0xfb, 0x0,
    0x0, 0x1e, 0x70, 0x1, 0xbf, 0xfe, 0xff, 0xf2,
    0x1f, 0xff, 0xf7, 0x0, 0x9, 0xff, 0xa0, 0x0,
    0x8f, 0xff, 0xff, 0x70, 0xdf, 0xff, 0xf1, 0x0,
    0xcf, 0xff, 0xd1, 0x0, 0x5f, 0xff, 0xf9, 0xc,
    0xff, 0xff, 0x30, 0x5, 0xff, 0xff, 0x60, 0x0,
    0x2d, 0xff, 0xb0, 0xef, 0xff, 0xb0, 0x0, 0xa,
    0xff, 0xfc, 0x0, 0x0, 0xa, 0xff, 0xef, 0xff,
    0xe1, 0x0, 0x0, 0xc, 0xff, 0xf6, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xf8, 0x10, 0x0, 0x3, 0xef, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xef, 0xff, 0xcb, 0x80,
    0x1, 0xbf, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x5a, 0xdf, 0xfe, 0x70, 0x0, 0x8f, 0xfe, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xcd, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfb, 0x33,
    0x8f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xf9, 0x0, 0x6f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x6f, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xfb,
    0x0, 0x7f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfd, 0x0, 0x9f,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff,
    0xfc, 0x0, 0x2, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0x60, 0xa, 0xff, 0xff,
    0xff, 0xfe, 0x42, 0xcf, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x23,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf9, 0x0, 0x12, 0x22, 0x10, 0x0, 0x0, 0x1,
    0x29, 0xff, 0x90, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfe, 0x20,
    0x5, 0xff, 0xff, 0xff, 0xfd, 0x9a, 0xad, 0xff,
    0xd0, 0x5f, 0xff, 0xbd, 0xff, 0xe2, 0x0, 0x0,
    0xcf, 0x44, 0xff, 0xf9, 0x8, 0xfe, 0x20, 0x0,
    0x0, 0x4, 0x4f, 0xff, 0x90, 0x4, 0xd2, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xa1, 0x91, 0x6,
    0xf6, 0x0, 0x0, 0x2, 0xef, 0xfb, 0xc, 0xfc,
    0x8, 0xff, 0x60, 0xef, 0xff, 0xff, 0xb0, 0x1d,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xfc, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xb0,
    0x0, 0x0, 0x2d, 0xde, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xfa, 0xcf, 0xfe, 0x30, 0x0,
    0x0, 0x6f, 0xff, 0x90, 0xc, 0xff, 0xe3, 0x0,
    0x6, 0xff, 0xf9, 0x0, 0x0, 0xcf, 0xfe, 0x30,
    0x5f, 0xff, 0x90, 0x0, 0x0, 0xc, 0xff, 0xe2,
    0xaf, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf6,
    0x1b, 0x80, 0x0, 0x0, 0x0, 0x0, 0xb, 0x90,

    /* U+F078 "" */
    0x3, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3, 0x20,
    0x6f, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf2,
    0xaf, 0xfe, 0x20, 0x0, 0x0, 0x5, 0xff, 0xf6,
    0x1c, 0xff, 0xe3, 0x0, 0x0, 0x5f, 0xff, 0x90,
    0x1, 0xcf, 0xfe, 0x30, 0x5, 0xff, 0xf9, 0x0,
    0x0, 0x1c, 0xff, 0xe3, 0x5f, 0xff, 0x90, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0x90, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x26, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xa0,
    0x0, 0x44, 0x44, 0x44, 0x44, 0x42, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfa, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff,
    0xa0, 0xaf, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xe, 0xfd, 0xef, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0xb, 0xe2, 0xdf, 0x67,
    0xf5, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x4,
    0x15, 0xfe, 0x3, 0x20, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x6f, 0xd6, 0xfe, 0x4f, 0xf1,
    0x0, 0x0, 0xdf, 0x94, 0x44, 0x44, 0x41, 0x3f,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0x24, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0x30,
    0x4f, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0,

    /* U+F07B "" */
    0x17, 0x88, 0x88, 0x84, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44,
    0x44, 0x44, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x11, 0x2f, 0xff, 0xf7, 0x11, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x24, 0x44, 0x42, 0x1f,
    0xff, 0xf6, 0x24, 0x44, 0x42, 0xff, 0xff, 0xfc,
    0x8, 0xbb, 0xa2, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xa5, 0x55, 0x5a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xb8,
    0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x90,
    0x0, 0x0, 0x4, 0xa5, 0x0, 0x0, 0xaf, 0xff,
    0xd0, 0x0, 0x0, 0x7d, 0xff, 0xf4, 0x2, 0xcf,
    0xff, 0xe2, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xe9,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xfc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xfd, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x23, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x35, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xff, 0xfa, 0x0, 0x0, 0x1, 0x9c, 0xa1,
    0xaf, 0xfe, 0xff, 0x60, 0x0, 0x2e, 0xff, 0xf9,
    0xef, 0x60, 0xaf, 0xb0, 0x3, 0xef, 0xff, 0xb0,
    0xef, 0x92, 0xcf, 0x90, 0x3e, 0xff, 0xfa, 0x0,
    0x7f, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xa0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x36, 0xef, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0xaf, 0xfe, 0xff, 0xc2, 0xdf, 0xff, 0xd1, 0x0,
    0xef, 0x60, 0xaf, 0xa0, 0x1c, 0xff, 0xfd, 0x20,
    0xef, 0x92, 0xcf, 0xa0, 0x0, 0xcf, 0xff, 0xe2,
    0x7f, 0xff, 0xff, 0x40, 0x0, 0xb, 0xff, 0xf9,
    0x8, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x58, 0x50,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xf1, 0x68, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0x80,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0xf8,
    0x36, 0x62, 0xaf, 0xff, 0xff, 0xf1, 0x36, 0x66,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xf6, 0x22, 0x22,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf7, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x20, 0x0, 0x0,

    /* U+F0C7 "" */
    0x5, 0x66, 0x66, 0x66, 0x66, 0x64, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0xff, 0xed, 0xdd, 0xdd, 0xdd, 0xef, 0xf9, 0x0,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0x90,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf9,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xc5, 0x7f, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfe, 0x0, 0x5, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfa, 0x0, 0x1, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfd, 0x0, 0x4, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0x93, 0x4d, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F0E7 "" */
    0x0, 0xaf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xa5, 0x55, 0x40, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x1, 0x22, 0x23, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x8d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x8b, 0xbc, 0xfa, 0xfd, 0xbb, 0x90, 0x0, 0x0,
    0xff, 0xff, 0xd0, 0xcf, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x95, 0xff, 0xff, 0xf1, 0x79, 0x0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xb0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xfa,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf2, 0x2, 0x21,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xdd, 0xdc,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x7a, 0xaa, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x8, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xcf, 0xfa, 0x40, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
    0xf4, 0x4, 0xd0, 0x2f, 0x0, 0xf3, 0x3, 0xf0,
    0xf, 0xf4, 0xff, 0x40, 0x5d, 0x2, 0xf0, 0xf,
    0x40, 0x4f, 0x0, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0x22, 0xb7, 0x29, 0xa2, 0x4f, 0x42, 0xcf,
    0xff, 0x4f, 0xff, 0xf0, 0xa, 0x60, 0x79, 0x2,
    0xf2, 0xb, 0xff, 0xf4, 0xff, 0xff, 0xdd, 0xfe,
    0xdf, 0xfd, 0xef, 0xed, 0xff, 0xff, 0x4f, 0xf8,
    0x48, 0xe4, 0x44, 0x44, 0x44, 0x47, 0xf4, 0x5f,
    0xf4, 0xff, 0x40, 0x4d, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0xff, 0x4f, 0xf7, 0x48, 0xe4, 0x44,
    0x44, 0x44, 0x47, 0xf4, 0x4f, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x8b, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xaf, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x6, 0xdf, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x17, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x29,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x56,
    0x66, 0x66, 0x7f, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x58, 0x88, 0x88, 0x87, 0x6, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfe, 0xf, 0x90, 0x0, 0xff, 0xff,
    0xff, 0xfe, 0xf, 0xf9, 0x0, 0xff, 0xff, 0xff,
    0xfe, 0xf, 0xff, 0x90, 0xff, 0xff, 0xff, 0xfe,
    0xf, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x32,
    0x22, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x14, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x30,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36,
    0x89, 0xa9, 0x74, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x29, 0xef, 0xff, 0xff, 0xff, 0xff, 0xc6,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x60, 0x0, 0x6, 0xff,
    0xff, 0xfc, 0x75, 0x43, 0x46, 0x9e, 0xff, 0xff,
    0xb1, 0x8, 0xff, 0xfe, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xcf, 0xff, 0xe2, 0xcf, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0x40, 0xb6, 0x0, 0x0, 0x59, 0xde, 0xfe, 0xc7,
    0x20, 0x0, 0x1b, 0x50, 0x0, 0x0, 0x5, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xfe, 0xde, 0xff, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xfc, 0x40,
    0x0, 0x2, 0x8f, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1, 0xb6, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x3f, 0xf5, 0xff, 0x4a, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xef,
    0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xf5, 0xff, 0x45, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F241 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x30, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F242 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4c,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4c, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F243 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x49,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x49, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x44, 0x88, 0x87,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F244 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x26, 0x9f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xef, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x80,
    0x2e, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xe3, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xa1, 0x0, 0xcf, 0xff, 0xd4,
    0x9f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7f, 0xf7,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xaf, 0xff, 0xa0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x3f, 0xb2, 0x0,
    0x9c, 0x90, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0x1, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbb, 0x2, 0xbb, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x9f, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xbd, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x1, 0x7b, 0xdd, 0xb8, 0x20, 0x0, 0x0,
    0x5f, 0xff, 0xdf, 0xff, 0xf6, 0x0, 0x4, 0xff,
    0xff, 0x68, 0xff, 0xff, 0x40, 0xe, 0xff, 0xff,
    0x60, 0x9f, 0xff, 0xd0, 0x4f, 0xff, 0xff, 0x60,
    0x9, 0xff, 0xf3, 0x8f, 0xf6, 0xbf, 0x61, 0xc0,
    0x9f, 0xf7, 0xbf, 0xf6, 0xb, 0x60, 0xe2, 0x5f,
    0xf9, 0xdf, 0xff, 0x50, 0x20, 0x33, 0xff, 0xfb,
    0xef, 0xff, 0xf5, 0x0, 0x2e, 0xff, 0xfc, 0xef,
    0xff, 0xfc, 0x0, 0x7f, 0xff, 0xfc, 0xdf, 0xff,
    0xd1, 0x0, 0x9, 0xff, 0xfc, 0xcf, 0xfc, 0x14,
    0x50, 0x90, 0xaf, 0xfb, 0xaf, 0xf2, 0x4f, 0x60,
    0xf3, 0x2f, 0xf9, 0x6f, 0xfd, 0xff, 0x70, 0x52,
    0xef, 0xf6, 0x1f, 0xff, 0xff, 0x70, 0x2e, 0xff,
    0xf1, 0x9, 0xff, 0xff, 0x72, 0xef, 0xff, 0x90,
    0x0, 0xbf, 0xff, 0xae, 0xff, 0xfd, 0x10, 0x0,
    0x5, 0xcf, 0xff, 0xfd, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x5, 0x88, 0x88, 0x30, 0x0, 0x0,
    0x56, 0x66, 0x7f, 0xff, 0xff, 0xe6, 0x66, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xcd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd8,
    0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x24, 0x44, 0x44, 0x44, 0x44, 0x31, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8a,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x34, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x44, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0x44, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0x44, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0x41, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x57, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x72, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0xbf, 0xff, 0xff, 0xf8,
    0xaf, 0xff, 0xa8, 0xff, 0xff, 0xf8, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0xaf, 0xa0, 0xa, 0xff,
    0xff, 0x80, 0xbf, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x60, 0x3, 0xff, 0xff, 0xf8, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x9f, 0xff, 0xff, 0xf8, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xff, 0xb0, 0x3, 0xe3, 0x0,
    0xbf, 0xff, 0xf8, 0x0, 0x4f, 0xff, 0xff, 0xfe,
    0x23, 0xff, 0xf3, 0x2e, 0xff, 0xff, 0x80, 0x0,
    0x4f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90,

    /* U+F7C2 "" */
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xcf,
    0x47, 0xf4, 0xd8, 0x4f, 0xf5, 0xc, 0xff, 0x3,
    0xe0, 0xc5, 0xe, 0xf5, 0xcf, 0xff, 0x3, 0xe0,
    0xc5, 0xe, 0xf5, 0xff, 0xff, 0x24, 0xe2, 0xc6,
    0x2e, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x1, 0x34,
    0x44, 0x44, 0x44, 0x42, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x10, 0x0, 0x3e, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf1, 0x0, 0x4f,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x10,
    0x5f, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf1, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x3e, 0xff, 0xfe, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x2e, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 72, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 78, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20, .adv_w = 92, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 35, .adv_w = 172, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 107, .adv_w = 165, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 197, .adv_w = 213, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 282, .adv_w = 189, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 360, .adv_w = 47, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 368, .adv_w = 101, .box_w = 5, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 418, .adv_w = 102, .box_w = 6, .box_h = 20, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 478, .adv_w = 131, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 519, .adv_w = 157, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 569, .adv_w = 70, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 581, .adv_w = 112, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 590, .adv_w = 84, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 595, .adv_w = 108, .box_w = 8, .box_h = 15, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 655, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 720, .adv_w = 165, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 766, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 831, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 896, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 961, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1026, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1091, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1156, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1221, .adv_w = 165, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1286, .adv_w = 81, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1301, .adv_w = 76, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1329, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1370, .adv_w = 165, .box_w = 9, .box_h = 6, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1397, .adv_w = 149, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1433, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1492, .adv_w = 258, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1628, .adv_w = 194, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1713, .adv_w = 184, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1778, .adv_w = 188, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1856, .adv_w = 187, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1921, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1980, .adv_w = 158, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2039, .adv_w = 196, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2117, .adv_w = 203, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2189, .adv_w = 84, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2209, .adv_w = 161, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2268, .adv_w = 183, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2340, .adv_w = 156, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2399, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2490, .adv_w = 203, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2562, .adv_w = 199, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2640, .adv_w = 186, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2705, .adv_w = 199, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2801, .adv_w = 184, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2873, .adv_w = 177, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2945, .adv_w = 178, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3017, .adv_w = 190, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3082, .adv_w = 188, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3160, .adv_w = 252, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3264, .adv_w = 183, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3342, .adv_w = 178, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3420, .adv_w = 175, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3492, .adv_w = 80, .box_w = 4, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3530, .adv_w = 122, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3590, .adv_w = 80, .box_w = 4, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3628, .adv_w = 126, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 3656, .adv_w = 129, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3670, .adv_w = 95, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 3678, .adv_w = 154, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3728, .adv_w = 162, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3798, .adv_w = 150, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3843, .adv_w = 162, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3913, .adv_w = 156, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3963, .adv_w = 103, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4012, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4082, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4152, .adv_w = 76, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4180, .adv_w = 75, .box_w = 5, .box_h = 18, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4225, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4295, .adv_w = 76, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4316, .adv_w = 249, .box_w = 15, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4391, .adv_w = 161, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4441, .adv_w = 163, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4491, .adv_w = 162, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4561, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4631, .adv_w = 105, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4670, .adv_w = 148, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4715, .adv_w = 97, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4754, .adv_w = 161, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4804, .adv_w = 146, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4849, .adv_w = 212, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4914, .adv_w = 147, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4964, .adv_w = 145, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5034, .adv_w = 147, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5079, .adv_w = 95, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5133, .adv_w = 73, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5157, .adv_w = 95, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5211, .adv_w = 187, .box_w = 11, .box_h = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 5239, .adv_w = 72, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5239, .adv_w = 81, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5260, .adv_w = 166, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5335, .adv_w = 171, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5407, .adv_w = 199, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5491, .adv_w = 154, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5556, .adv_w = 73, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5580, .adv_w = 181, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5674, .adv_w = 134, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 5686, .adv_w = 226, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5784, .adv_w = 128, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5805, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5841, .adv_w = 159, .box_w = 8, .box_h = 5, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 5861, .adv_w = 112, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 5870, .adv_w = 226, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5968, .adv_w = 144, .box_w = 7, .box_h = 2, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 5975, .adv_w = 112, .box_w = 5, .box_h = 7, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 5993, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6047, .adv_w = 107, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 6072, .adv_w = 107, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 6097, .adv_w = 95, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 6106, .adv_w = 177, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6169, .adv_w = 141, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6221, .adv_w = 87, .box_w = 4, .box_h = 3, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 6227, .adv_w = 77, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6240, .adv_w = 107, .box_w = 4, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 6254, .adv_w = 132, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 6279, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6315, .adv_w = 207, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6406, .adv_w = 219, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6497, .adv_w = 233, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6595, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6658, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6769, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6880, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6991, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7102, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7213, .adv_w = 194, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7330, .adv_w = 271, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7441, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7543, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7620, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7697, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7774, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7851, .adv_w = 84, .box_w = 5, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7894, .adv_w = 84, .box_w = 5, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7937, .adv_w = 84, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7997, .adv_w = 84, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8057, .adv_w = 191, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8142, .adv_w = 203, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8236, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8338, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8440, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8542, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8644, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8746, .adv_w = 153, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8791, .adv_w = 198, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8881, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8966, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9051, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9136, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9221, .adv_w = 178, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9323, .adv_w = 175, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9388, .adv_w = 182, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9458, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9528, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9598, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9668, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9738, .adv_w = 154, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9803, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9878, .adv_w = 243, .box_w = 15, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9953, .adv_w = 150, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10016, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10086, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10156, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10226, .adv_w = 156, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10291, .adv_w = 79, .box_w = 5, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10326, .adv_w = 79, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10361, .adv_w = 79, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10410, .adv_w = 79, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10456, .adv_w = 166, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10531, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10601, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10671, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10741, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10811, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10881, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10946, .adv_w = 164, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 10996, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11056, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11126, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11196, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11266, .adv_w = 161, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11331, .adv_w = 145, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11421, .adv_w = 163, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11502, .adv_w = 145, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11587, .adv_w = 194, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11691, .adv_w = 154, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11756, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11867, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11937, .adv_w = 194, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12048, .adv_w = 154, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12118, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12220, .adv_w = 150, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12283, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12385, .adv_w = 150, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12448, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12550, .adv_w = 150, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12613, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12715, .adv_w = 150, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12778, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12863, .adv_w = 183, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12954, .adv_w = 191, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13039, .adv_w = 182, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13116, .adv_w = 162, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13188, .adv_w = 156, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13253, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13330, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13400, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13477, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13547, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 13624, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13694, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13771, .adv_w = 156, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13841, .adv_w = 196, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13943, .adv_w = 164, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14033, .adv_w = 196, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14135, .adv_w = 164, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14225, .adv_w = 196, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14327, .adv_w = 164, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14417, .adv_w = 196, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 14525, .adv_w = 164, .box_w = 10, .box_h = 20, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14625, .adv_w = 203, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14719, .adv_w = 161, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14809, .adv_w = 207, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14894, .adv_w = 165, .box_w = 11, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14971, .adv_w = 84, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15031, .adv_w = 79, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15080, .adv_w = 84, .box_w = 7, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15136, .adv_w = 79, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15182, .adv_w = 84, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15242, .adv_w = 79, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15291, .adv_w = 84, .box_w = 4, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15325, .adv_w = 76, .box_w = 4, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15361, .adv_w = 84, .box_w = 3, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15387, .adv_w = 79, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15402, .adv_w = 245, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15493, .adv_w = 151, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15574, .adv_w = 161, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15668, .adv_w = 81, .box_w = 7, .box_h = 18, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 15731, .adv_w = 183, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15830, .adv_w = 154, .box_w = 10, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 15925, .adv_w = 170, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15975, .adv_w = 156, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16052, .adv_w = 76, .box_w = 5, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16097, .adv_w = 156, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 16178, .adv_w = 76, .box_w = 4, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 16216, .adv_w = 156, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16275, .adv_w = 97, .box_w = 6, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16317, .adv_w = 156, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16376, .adv_w = 107, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16425, .adv_w = 161, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16490, .adv_w = 88, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16532, .adv_w = 203, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16626, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16696, .adv_w = 203, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 16795, .adv_w = 161, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 16870, .adv_w = 203, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16964, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17034, .adv_w = 161, .box_w = 11, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 17111, .adv_w = 203, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 17205, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17275, .adv_w = 199, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17371, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17436, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17538, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17608, .adv_w = 199, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17710, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17780, .adv_w = 279, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17891, .adv_w = 260, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17971, .adv_w = 184, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18065, .adv_w = 105, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18114, .adv_w = 184, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18213, .adv_w = 105, .box_w = 7, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 18269, .adv_w = 184, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18363, .adv_w = 105, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18419, .adv_w = 177, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18513, .adv_w = 148, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18576, .adv_w = 177, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18670, .adv_w = 148, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18733, .adv_w = 177, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18827, .adv_w = 148, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18890, .adv_w = 177, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18984, .adv_w = 148, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19047, .adv_w = 178, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 19141, .adv_w = 97, .box_w = 7, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 19201, .adv_w = 178, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19295, .adv_w = 103, .box_w = 8, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19359, .adv_w = 178, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19431, .adv_w = 97, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19477, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19562, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19632, .adv_w = 190, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19712, .adv_w = 161, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19777, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19862, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19932, .adv_w = 190, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20022, .adv_w = 161, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20097, .adv_w = 190, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20182, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20252, .adv_w = 190, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 20332, .adv_w = 161, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 20402, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20538, .adv_w = 212, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20629, .adv_w = 178, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20731, .adv_w = 145, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 20821, .adv_w = 178, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20923, .adv_w = 175, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21017, .adv_w = 147, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21080, .adv_w = 175, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21174, .adv_w = 147, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21237, .adv_w = 175, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21331, .adv_w = 147, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21394, .adv_w = 75, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21429, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 21610, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21736, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21889, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22015, .adv_w = 198, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22100, .adv_w = 288, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22271, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22442, .adv_w = 324, .box_w = 21, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22621, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22792, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22939, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23110, .adv_w = 144, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23178, .adv_w = 216, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23283, .adv_w = 324, .box_w = 21, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23472, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23598, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 23700, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23852, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23988, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24124, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 24226, .adv_w = 252, .box_w = 18, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 24379, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24467, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24555, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24691, .adv_w = 252, .box_w = 16, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 24723, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24870, .adv_w = 360, .box_w = 23, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25089, .adv_w = 324, .box_w = 22, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 25298, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25451, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 25531, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 25611, .adv_w = 360, .box_w = 24, .box_h = 15, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 25791, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25917, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26088, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 26269, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26405, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26557, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26693, .adv_w = 180, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 26817, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26969, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 27121, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27268, .adv_w = 288, .box_w = 20, .box_h = 20, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 27468, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 27601, .adv_w = 360, .box_w = 23, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27808, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27946, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 28084, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 28222, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 28360, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 28498, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28671, .adv_w = 252, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 28804, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 28956, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 29137, .adv_w = 360, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29298, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 29431, .adv_w = 290, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, -8, 0,
    -3, -13, 0, -13, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    5, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -40, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -35,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    -11, 0, -3, 0, 0, -17, -2, -11,
    -5, 0, -21, 0, 0, 0, 0, 0,
    -7, -2, 0, 0, -2, -2, -7, -5,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -3,
    0, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -17, 0, 0,
    0, -3, 0, 0, 0, -12, 0, -3,
    0, -3, -6, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -3,
    0, -3, 0, 0, 0, -2, -4, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -39, 0, 0,
    0, -27, 0, -29, 0, 3, 0, 0,
    0, 0, 0, 0, 0, -5, -3, 0,
    0, -3, -4, 0, 0, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, -4, 0, 0,
    0, 2, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -23, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, -4, 0, 0, 0, -3, -6, -9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -40, 0, 0, 0, 0, 0, 0,
    0, 3, -9, 0, 0, -29, -3, -29,
    -13, 0, -39, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -17, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -57, 0, 0,
    0, -25, 0, -26, 0, 0, 0, 0,
    0, -7, 0, -5, 0, -2, -2, 0,
    0, -2, 0, 0, 2, 0, 2, 0,
    0, 0, 0, 0, 0, -42, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -4,
    -3, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, -3,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, -36, -38, 0,
    0, -17, -4, -30, -2, 2, 0, 2,
    2, 0, 2, 0, 0, -24, -13, 0,
    -13, -29, -9, -11, 0, -9, -12, -7,
    -11, -8, 0, -21, -21, -27, -12, -13,
    0, 0, 0, 3, 0, -30, -22, 0,
    0, -11, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -6, -6, 0,
    0, -6, -4, 0, 0, -4, -2, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -20, -8, 0,
    0, -6, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 2, -5, -4, 0,
    0, -4, -3, 0, 0, -3, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -22, 0,
    0, 0, -4, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, -3, 0, 0, 0, -3, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 3, -7, -32, -21, 0,
    0, -21, -4, -13, -2, 2, -13, 3,
    2, 2, 3, 0, 3, -9, -9, -3,
    -6, -9, -6, -8, -3, -5, -3, 0,
    -3, -4, 3, -12, -7, -13, -9, -9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -3, -4, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -2, -2, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -3, -2, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -24, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -3, 3,
    0, -5, 0, 0, 7, 0, 3, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -23, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 2,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -6, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_bold_18 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 23,          /*The maximum line height required by the font*/
    .base_line = 5,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_BOLD_18*/


