#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_BOLD_16
#define RB_LV_FONT_ROBOTO_BOLD_16 1
#endif

#if RB_LV_FONT_ROBOTO_BOLD_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xf, 0xf6, 0xe, 0xf6, 0xe, 0xf5, 0xd, 0xf5,
    0xd, 0xf4, 0xc, 0xf4, 0xc, 0xf3, 0xb, 0xf3,
    0x2, 0x30, 0x3, 0x60, 0xf, 0xf6, 0xb, 0xe3,

    /* U+22 "\"" */
    0x8f, 0x1f, 0xa8, 0xf0, 0xf9, 0x8f, 0xf, 0x78,
    0xd0, 0xf6, 0x36, 0x7, 0x20,

    /* U+23 "#" */
    0x0, 0x6, 0xf0, 0x7f, 0x0, 0x0, 0x9, 0xd0,
    0xac, 0x0, 0x0, 0xc, 0xa0, 0xd9, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xf3, 0x6, 0x8f, 0x98, 0xf8,
    0x61, 0x0, 0x4f, 0x25, 0xf1, 0x0, 0x1, 0x7f,
    0x28, 0xf1, 0x10, 0x8f, 0xff, 0xff, 0xff, 0xa0,
    0x24, 0xdc, 0x4e, 0xb4, 0x20, 0x0, 0xe8, 0xf,
    0x70, 0x0, 0x0, 0xf5, 0x1f, 0x40, 0x0, 0x3,
    0xf3, 0x4f, 0x20, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x74, 0x0, 0x0, 0x0, 0xc, 0x70,
    0x0, 0x0, 0x3a, 0xfe, 0x70, 0x0, 0x3f, 0xff,
    0xff, 0xa0, 0xa, 0xfb, 0x5, 0xff, 0x20, 0xcf,
    0x70, 0xd, 0xf5, 0xa, 0xfc, 0x10, 0x0, 0x0,
    0x3f, 0xff, 0x91, 0x0, 0x0, 0x3c, 0xff, 0xf4,
    0x0, 0x0, 0x4, 0xcf, 0xf1, 0x18, 0x70, 0x0,
    0xef, 0x52, 0xff, 0x30, 0xe, 0xf5, 0xc, 0xfe,
    0x8b, 0xff, 0x20, 0x2d, 0xff, 0xff, 0x60, 0x0,
    0x3, 0xf8, 0x10, 0x0, 0x0, 0xe, 0x50, 0x0,

    /* U+25 "%" */
    0x5, 0xdf, 0xa0, 0x0, 0x0, 0x0, 0x1f, 0xb7,
    0xf7, 0x1, 0x80, 0x0, 0x3f, 0x40, 0xda, 0xa,
    0xc0, 0x0, 0x2f, 0x82, 0xf9, 0x3f, 0x30, 0x0,
    0x9, 0xff, 0xe2, 0xd9, 0x0, 0x0, 0x0, 0x23,
    0x7, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xac, 0x2c, 0xfe, 0x50,
    0x0, 0x4, 0xf3, 0xae, 0x5b, 0xf0, 0x0, 0xd,
    0x90, 0xcb, 0x6, 0xf1, 0x0, 0x2c, 0x10, 0xae,
    0x6c, 0xf0, 0x0, 0x0, 0x0, 0x1b, 0xfd, 0x40,

    /* U+26 "&" */
    0x0, 0x3c, 0xfd, 0x50, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0x30, 0x0, 0x5, 0xfb, 0x8, 0xf7, 0x0,
    0x0, 0x6f, 0xa0, 0x8f, 0x60, 0x0, 0x2, 0xff,
    0xaf, 0xd0, 0x0, 0x0, 0x9, 0xff, 0xb1, 0x0,
    0x0, 0x5, 0xff, 0xfc, 0x4, 0xd8, 0x2, 0xff,
    0x6e, 0xf9, 0x7f, 0x80, 0x6f, 0xe0, 0x3f, 0xff,
    0xf4, 0x5, 0xff, 0x10, 0x6f, 0xfd, 0x0, 0xd,
    0xfe, 0xcf, 0xff, 0xe2, 0x0, 0x19, 0xef, 0xd8,
    0xaf, 0xd0,

    /* U+27 "'" */
    0x8f, 0x28, 0xf2, 0x8f, 0x18, 0xf0, 0x47, 0x0,

    /* U+28 "(" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xe1, 0x0, 0x1e,
    0xd1, 0x0, 0xaf, 0x20, 0x2, 0xfa, 0x0, 0x8,
    0xf5, 0x0, 0xb, 0xf2, 0x0, 0xe, 0xf0, 0x0,
    0xf, 0xe0, 0x0, 0xf, 0xe0, 0x0, 0xf, 0xf0,
    0x0, 0xd, 0xf0, 0x0, 0xa, 0xf3, 0x0, 0x5,
    0xf7, 0x0, 0x0, 0xee, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x70,

    /* U+29 ")" */
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x4f, 0xa0, 0x0,
    0x8f, 0x50, 0x1, 0xfd, 0x0, 0xc, 0xf3, 0x0,
    0x8f, 0x70, 0x6, 0xfa, 0x0, 0x5f, 0xb0, 0x4,
    0xfc, 0x0, 0x5f, 0xa0, 0x6, 0xf8, 0x0, 0x9f,
    0x50, 0xd, 0xf0, 0x4, 0xf9, 0x0, 0xcf, 0x10,
    0x8f, 0x40, 0x4, 0x30, 0x0,

    /* U+2A "*" */
    0x0, 0xf, 0x70, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x8d, 0x6e, 0x89, 0xd0, 0x5b, 0xff, 0xfe, 0x90,
    0x0, 0xaf, 0xe1, 0x0, 0x7, 0xf4, 0xeb, 0x0,
    0x9, 0x90, 0x6d, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x7, 0xa4, 0x0, 0x0, 0x0, 0xbf, 0x60,
    0x0, 0x0, 0xb, 0xf6, 0x0, 0x1, 0x22, 0xcf,
    0x72, 0x20, 0x8f, 0xff, 0xff, 0xff, 0x48, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0xb, 0xf6, 0x0, 0x0,
    0x0, 0xbf, 0x60, 0x0, 0x0, 0xb, 0xf6, 0x0,
    0x0,

    /* U+2C "," */
    0xe, 0xf0, 0xef, 0xf, 0xd4, 0xf8, 0x5c, 0x0,

    /* U+2D "-" */
    0x2e, 0xee, 0xe3, 0x2f, 0xff, 0xf4,

    /* U+2E "." */
    0x3, 0x70, 0xf, 0xf7, 0xa, 0xf4,

    /* U+2F "/" */
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0xbe, 0x0, 0x0, 0x1f, 0xa0, 0x0, 0x5,
    0xf5, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0xaf,
    0x10, 0x0, 0xe, 0xb0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x6d, 0xfe, 0x80, 0x0, 0x6f, 0xff, 0xff,
    0x90, 0xe, 0xf8, 0x5, 0xff, 0x12, 0xff, 0x10,
    0xe, 0xf4, 0x3f, 0xf0, 0x0, 0xdf, 0x64, 0xff,
    0x0, 0xd, 0xf7, 0x4f, 0xf0, 0x0, 0xdf, 0x73,
    0xff, 0x0, 0xd, 0xf6, 0x2f, 0xf1, 0x0, 0xff,
    0x40, 0xef, 0x80, 0x5f, 0xf1, 0x6, 0xff, 0xff,
    0xf9, 0x0, 0x6, 0xdf, 0xe8, 0x0,

    /* U+31 "1" */
    0x0, 0x16, 0xc4, 0x3a, 0xff, 0xf4, 0xbf, 0xff,
    0xf4, 0x65, 0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0,
    0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4,
    0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf,
    0xf4, 0x0, 0xf, 0xf4,

    /* U+32 "2" */
    0x0, 0x7d, 0xfd, 0x80, 0x0, 0xaf, 0xff, 0xff,
    0xa0, 0x2f, 0xf4, 0x6, 0xff, 0x5, 0xec, 0x0,
    0x1f, 0xf2, 0x0, 0x0, 0x4, 0xff, 0x0, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x0, 0xbf, 0xd0, 0x0,
    0x0, 0xaf, 0xe2, 0x0, 0x0, 0x8f, 0xf3, 0x0,
    0x0, 0x6f, 0xf4, 0x0, 0x0, 0x2f, 0xff, 0xee,
    0xee, 0x83, 0xff, 0xff, 0xff, 0xf9,

    /* U+33 "3" */
    0x1, 0x9e, 0xfd, 0x70, 0x0, 0xcf, 0xfe, 0xff,
    0xa0, 0x3f, 0xf3, 0x5, 0xff, 0x11, 0x33, 0x0,
    0x1f, 0xf2, 0x0, 0x0, 0x8, 0xfe, 0x0, 0x0,
    0xef, 0xfd, 0x20, 0x0, 0xc, 0xef, 0xf7, 0x0,
    0x0, 0x0, 0x3f, 0xf2, 0x25, 0x40, 0x0, 0xef,
    0x56, 0xff, 0x20, 0x4f, 0xf4, 0xd, 0xff, 0xef,
    0xfc, 0x0, 0x19, 0xdf, 0xd8, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x2f, 0xf7, 0x0, 0x0, 0xc, 0xff,
    0x70, 0x0, 0x6, 0xff, 0xf7, 0x0, 0x1, 0xee,
    0xdf, 0x70, 0x0, 0xaf, 0x5c, 0xf7, 0x0, 0x4f,
    0xb0, 0xcf, 0x70, 0xd, 0xf1, 0xc, 0xf7, 0x7,
    0xff, 0xee, 0xff, 0xfa, 0x8f, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0xc,
    0xf7, 0x0, 0x0, 0x0, 0xcf, 0x70,

    /* U+35 "5" */
    0x4, 0xff, 0xff, 0xff, 0x20, 0x6f, 0xff, 0xff,
    0xf2, 0x8, 0xf9, 0x0, 0x0, 0x0, 0x9f, 0x70,
    0x0, 0x0, 0xb, 0xfc, 0xef, 0xb1, 0x0, 0xdf,
    0xfd, 0xff, 0xd0, 0x1, 0x51, 0x3, 0xff, 0x40,
    0x0, 0x0, 0xc, 0xf7, 0x17, 0x70, 0x0, 0xcf,
    0x70, 0xff, 0x70, 0x3f, 0xf4, 0x7, 0xff, 0xff,
    0xfc, 0x0, 0x6, 0xdf, 0xe9, 0x0,

    /* U+36 "6" */
    0x0, 0x2, 0x9d, 0xe0, 0x0, 0x5, 0xff, 0xfe,
    0x0, 0x2, 0xff, 0x92, 0x0, 0x0, 0xaf, 0xa0,
    0x0, 0x0, 0xf, 0xf8, 0xdf, 0xc3, 0x2, 0xff,
    0xff, 0xff, 0xe0, 0x3f, 0xf7, 0x2, 0xff, 0x63,
    0xff, 0x0, 0xb, 0xf8, 0x1f, 0xf2, 0x0, 0xbf,
    0x90, 0xdf, 0x90, 0x2f, 0xf5, 0x4, 0xff, 0xff,
    0xfc, 0x0, 0x4, 0xcf, 0xe9, 0x10,

    /* U+37 "7" */
    0x8f, 0xff, 0xff, 0xff, 0x87, 0xee, 0xee, 0xef,
    0xf6, 0x0, 0x0, 0x2, 0xff, 0x10, 0x0, 0x0,
    0x8f, 0x90, 0x0, 0x0, 0xf, 0xf3, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0x60, 0x0,
    0x0, 0x4f, 0xe0, 0x0, 0x0, 0xb, 0xf8, 0x0,
    0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0x9f, 0xb0,
    0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x6d, 0xfd, 0x80, 0x0, 0x7f, 0xff, 0xff,
    0xa0, 0xd, 0xf8, 0x5, 0xff, 0x0, 0xff, 0x40,
    0x1f, 0xf2, 0xc, 0xf9, 0x7, 0xfe, 0x0, 0x2d,
    0xff, 0xfe, 0x30, 0x4, 0xff, 0xff, 0xf6, 0x0,
    0xef, 0x60, 0x3f, 0xf2, 0x3f, 0xf0, 0x0, 0xdf,
    0x62, 0xff, 0x50, 0x3f, 0xf5, 0xb, 0xff, 0xef,
    0xfd, 0x0, 0x8, 0xdf, 0xe9, 0x10,

    /* U+39 "9" */
    0x0, 0x6d, 0xfd, 0x50, 0x0, 0x7f, 0xff, 0xff,
    0x50, 0xf, 0xf7, 0x7, 0xfe, 0x4, 0xff, 0x0,
    0xf, 0xf3, 0x4f, 0xf0, 0x0, 0xef, 0x51, 0xff,
    0x50, 0x3f, 0xf5, 0xa, 0xff, 0xdf, 0xff, 0x40,
    0xa, 0xfe, 0x8f, 0xf2, 0x0, 0x0, 0x5, 0xfe,
    0x0, 0x0, 0x15, 0xef, 0x70, 0x0, 0x9f, 0xff,
    0xb0, 0x0, 0x9, 0xfc, 0x60, 0x0,

    /* U+3A ":" */
    0xa, 0xe3, 0xf, 0xf7, 0x3, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x70, 0xf, 0xf7,
    0xa, 0xe3,

    /* U+3B ";" */
    0xc, 0xe2, 0x1f, 0xf5, 0x4, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf2,
    0xb, 0xf2, 0xd, 0xf0, 0x2f, 0xa0, 0x3d, 0x20,
    0x0, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xb2,
    0x0, 0x6, 0xdf, 0xf2, 0x18, 0xef, 0xfe, 0x80,
    0x9f, 0xfa, 0x40, 0x0, 0x9f, 0xfc, 0x60, 0x0,
    0x6, 0xdf, 0xff, 0xa1, 0x0, 0x4, 0xbf, 0xf2,
    0x0, 0x0, 0x2, 0x92,

    /* U+3D "=" */
    0xff, 0xff, 0xff, 0xf0, 0xde, 0xee, 0xee, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xde, 0xee, 0xee, 0xe0,
    0xff, 0xff, 0xff, 0xf0,

    /* U+3E ">" */
    0xc, 0x50, 0x0, 0x0, 0x1f, 0xfd, 0x70, 0x0,
    0x7, 0xdf, 0xff, 0x92, 0x0, 0x3, 0x9e, 0xfc,
    0x0, 0x5, 0xbf, 0xfb, 0x9, 0xff, 0xfe, 0x71,
    0x1f, 0xfc, 0x50, 0x0, 0xa, 0x30, 0x0, 0x0,

    /* U+3F "?" */
    0x3, 0xbe, 0xeb, 0x20, 0x2f, 0xff, 0xff, 0xe0,
    0x8f, 0xd0, 0x2f, 0xf4, 0x24, 0x20, 0xf, 0xf5,
    0x0, 0x0, 0x6f, 0xf1, 0x0, 0x5, 0xff, 0x50,
    0x0, 0xf, 0xf6, 0x0, 0x0, 0x3f, 0xd0, 0x0,
    0x0, 0x14, 0x30, 0x0, 0x0, 0x6, 0x30, 0x0,
    0x0, 0x7f, 0xf0, 0x0, 0x0, 0x3e, 0xb0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x3a, 0xdf, 0xeb, 0x40, 0x0, 0x0,
    0x8, 0xfc, 0x75, 0x6b, 0xf9, 0x0, 0x0, 0x8f,
    0x60, 0x1, 0x0, 0x4f, 0x70, 0x3, 0xf8, 0x1,
    0xcf, 0xfa, 0x7, 0xf1, 0xa, 0xe0, 0xc, 0xf6,
    0xbf, 0x1, 0xf5, 0xf, 0x90, 0x5f, 0x60, 0x9f,
    0x0, 0xd8, 0x2f, 0x50, 0xaf, 0x10, 0xae, 0x0,
    0xb9, 0x4f, 0x30, 0xde, 0x0, 0xbd, 0x0, 0xca,
    0x4f, 0x30, 0xed, 0x0, 0xcc, 0x0, 0xd7, 0x3f,
    0x50, 0xde, 0x0, 0xfb, 0x2, 0xf4, 0xf, 0x80,
    0x9f, 0x8b, 0xfe, 0x6d, 0xc0, 0xb, 0xe1, 0x1c,
    0xfa, 0x2d, 0xfb, 0x10, 0x2, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xfa, 0x77, 0x99,
    0x0, 0x0, 0x0, 0x2, 0x8d, 0xff, 0xc6, 0x0,
    0x0,

    /* U+41 "A" */
    0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0x0, 0x0, 0x0, 0x9, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0xef, 0xdf, 0xb0, 0x0, 0x0, 0x4f,
    0xf4, 0xff, 0x10, 0x0, 0xa, 0xfb, 0xe, 0xf6,
    0x0, 0x0, 0xff, 0x60, 0xaf, 0xc0, 0x0, 0x5f,
    0xf1, 0x5, 0xff, 0x20, 0xb, 0xff, 0xff, 0xff,
    0xf7, 0x1, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x6f,
    0xf2, 0x0, 0x5, 0xff, 0x2c, 0xfb, 0x0, 0x0,
    0xe, 0xf8,

    /* U+42 "B" */
    0xff, 0xff, 0xfd, 0x80, 0xf, 0xff, 0xff, 0xff,
    0xb0, 0xff, 0x50, 0x8, 0xff, 0x1f, 0xf5, 0x0,
    0x2f, 0xf2, 0xff, 0x50, 0x8, 0xfe, 0xf, 0xff,
    0xff, 0xfe, 0x30, 0xff, 0xdc, 0xcf, 0xfa, 0xf,
    0xf5, 0x0, 0x2f, 0xf4, 0xff, 0x50, 0x0, 0xef,
    0x7f, 0xf5, 0x0, 0x5f, 0xf5, 0xff, 0xff, 0xff,
    0xfd, 0xf, 0xff, 0xff, 0xd9, 0x10,

    /* U+43 "C" */
    0x0, 0x19, 0xef, 0xe9, 0x10, 0x1, 0xdf, 0xff,
    0xff, 0xd1, 0xa, 0xfe, 0x30, 0x3e, 0xf8, 0xf,
    0xf6, 0x0, 0x8, 0xfd, 0x3f, 0xf2, 0x0, 0x0,
    0x21, 0x4f, 0xf0, 0x0, 0x0, 0x0, 0x5f, 0xf0,
    0x0, 0x0, 0x0, 0x3f, 0xf2, 0x0, 0x0, 0x11,
    0xf, 0xf5, 0x0, 0x8, 0xfd, 0xa, 0xfd, 0x30,
    0x3e, 0xf9, 0x1, 0xef, 0xff, 0xff, 0xd1, 0x0,
    0x19, 0xef, 0xe9, 0x10,

    /* U+44 "D" */
    0xff, 0xff, 0xd9, 0x10, 0xf, 0xff, 0xff, 0xfe,
    0x30, 0xff, 0x50, 0x3c, 0xfd, 0xf, 0xf5, 0x0,
    0x2f, 0xf5, 0xff, 0x50, 0x0, 0xcf, 0x9f, 0xf5,
    0x0, 0xa, 0xfb, 0xff, 0x50, 0x0, 0xaf, 0xbf,
    0xf5, 0x0, 0xc, 0xf9, 0xff, 0x50, 0x2, 0xff,
    0x5f, 0xf5, 0x3, 0xcf, 0xd0, 0xff, 0xff, 0xff,
    0xe3, 0xf, 0xff, 0xfe, 0x92, 0x0,

    /* U+45 "E" */
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xd0,
    0xff, 0xfe, 0xee, 0xc0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xfa,

    /* U+46 "F" */
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xd0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x18, 0xdf, 0xea, 0x20, 0x0, 0x1d, 0xff,
    0xff, 0xfe, 0x10, 0x9, 0xff, 0x40, 0x2e, 0xf9,
    0x0, 0xef, 0x70, 0x0, 0x6f, 0xe0, 0x2f, 0xf3,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x4f, 0xf2, 0x7, 0xff, 0xff, 0x2, 0xff,
    0x30, 0x5d, 0xdf, 0xf0, 0xe, 0xf8, 0x0, 0x5,
    0xff, 0x0, 0x8f, 0xf5, 0x0, 0x8f, 0xf0, 0x0,
    0xdf, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x8d, 0xfe,
    0xc6, 0x0,

    /* U+48 "H" */
    0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0,
    0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff,
    0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4,
    0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0,
    0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff,
    0x50, 0x0, 0x1f, 0xf4,

    /* U+49 "I" */
    0xdf, 0x8d, 0xf8, 0xdf, 0x8d, 0xf8, 0xdf, 0x8d,
    0xf8, 0xdf, 0x8d, 0xf8, 0xdf, 0x8d, 0xf8, 0xdf,
    0x8d, 0xf8,

    /* U+4A "J" */
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x6, 0xff,
    0x6a, 0x70, 0x6, 0xfe, 0x8f, 0xe1, 0x1c, 0xfb,
    0x1f, 0xff, 0xff, 0xf3, 0x2, 0xbe, 0xfc, 0x40,

    /* U+4B "K" */
    0xff, 0x50, 0x2, 0xff, 0xc0, 0xff, 0x50, 0xc,
    0xfe, 0x10, 0xff, 0x50, 0x8f, 0xf4, 0x0, 0xff,
    0x54, 0xff, 0x80, 0x0, 0xff, 0x7e, 0xfc, 0x0,
    0x0, 0xff, 0xef, 0xf5, 0x0, 0x0, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xf8, 0xff, 0x70, 0x0,
    0xff, 0x80, 0xaf, 0xf2, 0x0, 0xff, 0x50, 0x1e,
    0xfb, 0x0, 0xff, 0x50, 0x6, 0xff, 0x50, 0xff,
    0x50, 0x0, 0xcf, 0xe1,

    /* U+4C "L" */
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5,

    /* U+4D "M" */
    0xff, 0xf3, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xdf, 0x40, 0x4, 0xfd, 0xff,
    0xff, 0x9f, 0x90, 0x9, 0xf9, 0xff, 0xff, 0x4f,
    0xe0, 0xe, 0xf4, 0xff, 0xff, 0x4b, 0xf4, 0x4f,
    0xb4, 0xff, 0xff, 0x45, 0xf9, 0x9f, 0x54, 0xff,
    0xff, 0x50, 0xfe, 0xef, 0x5, 0xff, 0xff, 0x50,
    0xaf, 0xfa, 0x5, 0xff, 0xff, 0x50, 0x5f, 0xf5,
    0x5, 0xff, 0xff, 0x50, 0xf, 0xf0, 0x5, 0xff,

    /* U+4E "N" */
    0xff, 0xa0, 0x0, 0x1f, 0xf4, 0xff, 0xf3, 0x0,
    0x1f, 0xf4, 0xff, 0xfc, 0x0, 0x1f, 0xf4, 0xff,
    0xff, 0x60, 0x1f, 0xf4, 0xff, 0xcf, 0xe0, 0x1f,
    0xf4, 0xff, 0x5d, 0xf8, 0x1f, 0xf4, 0xff, 0x54,
    0xff, 0x3f, 0xf4, 0xff, 0x50, 0xaf, 0xcf, 0xf4,
    0xff, 0x50, 0x2f, 0xff, 0xf4, 0xff, 0x50, 0x8,
    0xff, 0xf4, 0xff, 0x50, 0x0, 0xef, 0xf4, 0xff,
    0x50, 0x0, 0x5f, 0xf4,

    /* U+4F "O" */
    0x0, 0x8, 0xdf, 0xd8, 0x10, 0x0, 0xd, 0xff,
    0xff, 0xfd, 0x10, 0x9, 0xff, 0x51, 0x4e, 0xf9,
    0x0, 0xff, 0x70, 0x0, 0x7f, 0xf0, 0x3f, 0xf2,
    0x0, 0x2, 0xff, 0x34, 0xff, 0x10, 0x0, 0xf,
    0xf5, 0x4f, 0xf1, 0x0, 0x0, 0xff, 0x53, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0xf, 0xf7, 0x0, 0x6,
    0xff, 0x0, 0x9f, 0xf5, 0x4, 0xef, 0x90, 0x0,
    0xdf, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x8d, 0xfd,
    0x81, 0x0,

    /* U+50 "P" */
    0xff, 0xff, 0xfd, 0x80, 0xf, 0xff, 0xff, 0xff,
    0xd0, 0xff, 0x50, 0x5, 0xff, 0x6f, 0xf5, 0x0,
    0xb, 0xfa, 0xff, 0x50, 0x0, 0xbf, 0xbf, 0xf5,
    0x0, 0x4f, 0xf7, 0xff, 0xff, 0xff, 0xfd, 0x1f,
    0xff, 0xff, 0xe9, 0x10, 0xff, 0x50, 0x0, 0x0,
    0xf, 0xf5, 0x0, 0x0, 0x0, 0xff, 0x50, 0x0,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x8, 0xdf, 0xd8, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xfd, 0x10, 0x9, 0xff, 0x51, 0x5f, 0xf9,
    0x0, 0xff, 0x70, 0x0, 0x7f, 0xf0, 0x3f, 0xf2,
    0x0, 0x2, 0xff, 0x35, 0xff, 0x0, 0x0, 0xf,
    0xf5, 0x5f, 0xf0, 0x0, 0x0, 0xff, 0x53, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0xf, 0xf7, 0x0, 0x7,
    0xff, 0x0, 0x9f, 0xf4, 0x4, 0xef, 0x90, 0x0,
    0xdf, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x8d, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x2d, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0xa, 0x50,

    /* U+52 "R" */
    0xff, 0xff, 0xfd, 0x70, 0xf, 0xff, 0xff, 0xff,
    0xc0, 0xff, 0x50, 0x7, 0xff, 0x4f, 0xf5, 0x0,
    0xf, 0xf6, 0xff, 0x50, 0x0, 0xff, 0x6f, 0xf5,
    0x0, 0x8f, 0xf2, 0xff, 0xff, 0xff, 0xf7, 0xf,
    0xff, 0xff, 0xf9, 0x0, 0xff, 0x50, 0x7f, 0xf1,
    0xf, 0xf5, 0x0, 0xef, 0x80, 0xff, 0x50, 0x6,
    0xff, 0x1f, 0xf5, 0x0, 0xe, 0xf9,

    /* U+53 "S" */
    0x0, 0x5c, 0xff, 0xc6, 0x0, 0x7, 0xff, 0xff,
    0xff, 0x80, 0xf, 0xf9, 0x0, 0x8f, 0xf1, 0x1f,
    0xf5, 0x0, 0x1a, 0xa2, 0xc, 0xfe, 0x60, 0x0,
    0x0, 0x2, 0xdf, 0xff, 0xa2, 0x0, 0x0, 0x7,
    0xdf, 0xff, 0x40, 0x0, 0x0, 0x3, 0xcf, 0xe0,
    0x5d, 0xc0, 0x0, 0x2f, 0xf3, 0x2f, 0xf7, 0x0,
    0x6f, 0xf2, 0x9, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x5c, 0xff, 0xd7, 0x0,

    /* U+54 "T" */
    0xbf, 0xff, 0xff, 0xff, 0xf9, 0xaf, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10,
    0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0,

    /* U+55 "U" */
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9,
    0xf, 0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20,
    0x5f, 0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x3b, 0xff, 0xd8, 0x0,

    /* U+56 "V" */
    0xcf, 0xc0, 0x0, 0x5, 0xff, 0x37, 0xff, 0x10,
    0x0, 0xaf, 0xe0, 0x1f, 0xf5, 0x0, 0xe, 0xf9,
    0x0, 0xcf, 0xa0, 0x3, 0xff, 0x40, 0x7, 0xfe,
    0x0, 0x8f, 0xe0, 0x0, 0x2f, 0xf3, 0xc, 0xf9,
    0x0, 0x0, 0xcf, 0x81, 0xff, 0x40, 0x0, 0x7,
    0xfc, 0x5f, 0xe0, 0x0, 0x0, 0x2f, 0xfc, 0xf9,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0x40, 0x0, 0x0,
    0x7, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x2f, 0xf9,
    0x0, 0x0,

    /* U+57 "W" */
    0x9f, 0xb0, 0x1, 0xff, 0x20, 0xa, 0xfa, 0x6f,
    0xe0, 0x4, 0xff, 0x50, 0xd, 0xf6, 0x3f, 0xf1,
    0x8, 0xff, 0x90, 0xf, 0xf3, 0xf, 0xf3, 0xb,
    0xff, 0xc0, 0x3f, 0xf0, 0xc, 0xf6, 0xf, 0xed,
    0xf0, 0x6f, 0xc0, 0x9, 0xf9, 0x2f, 0xaa, 0xf3,
    0x9f, 0x90, 0x5, 0xfc, 0x6f, 0x66, 0xf7, 0xcf,
    0x60, 0x2, 0xff, 0xaf, 0x32, 0xfa, 0xff, 0x20,
    0x0, 0xef, 0xff, 0x0, 0xff, 0xff, 0x0, 0x0,
    0xbf, 0xfb, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x8f,
    0xf8, 0x0, 0x7f, 0xf8, 0x0, 0x0, 0x4f, 0xf4,
    0x0, 0x4f, 0xf5, 0x0,

    /* U+58 "X" */
    0x7f, 0xf3, 0x0, 0x1f, 0xfa, 0xd, 0xfb, 0x0,
    0x8f, 0xf1, 0x5, 0xff, 0x41, 0xff, 0x80, 0x0,
    0xcf, 0xc9, 0xfe, 0x0, 0x0, 0x3f, 0xff, 0xf6,
    0x0, 0x0, 0xa, 0xff, 0xd0, 0x0, 0x0, 0xb,
    0xff, 0xe0, 0x0, 0x0, 0x4f, 0xff, 0xf7, 0x0,
    0x0, 0xdf, 0xb8, 0xff, 0x10, 0x6, 0xff, 0x31,
    0xff, 0x90, 0xe, 0xfa, 0x0, 0x8f, 0xf2, 0x8f,
    0xf2, 0x0, 0xe, 0xfb,

    /* U+59 "Y" */
    0xbf, 0xc0, 0x0, 0xe, 0xfa, 0x4f, 0xf3, 0x0,
    0x5f, 0xf2, 0xc, 0xfa, 0x0, 0xcf, 0xa0, 0x4,
    0xff, 0x23, 0xff, 0x20, 0x0, 0xcf, 0x8a, 0xfa,
    0x0, 0x0, 0x4f, 0xff, 0xf3, 0x0, 0x0, 0xc,
    0xff, 0xb0, 0x0, 0x0, 0x5, 0xff, 0x30, 0x0,
    0x0, 0x4, 0xff, 0x20, 0x0, 0x0, 0x4, 0xff,
    0x20, 0x0, 0x0, 0x4, 0xff, 0x20, 0x0, 0x0,
    0x4, 0xff, 0x20, 0x0,

    /* U+5A "Z" */
    0x6f, 0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0,
    0x0, 0xc, 0xfb, 0x0, 0x0, 0x0, 0x7f, 0xf2,
    0x0, 0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0xc,
    0xfc, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0xb, 0xfd, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xf3, 0x6f,
    0xff, 0xff, 0xff, 0xf3,

    /* U+5B "[" */
    0xd, 0xdd, 0x41, 0xff, 0xf5, 0x1f, 0xf3, 0x1,
    0xff, 0x30, 0x1f, 0xf3, 0x1, 0xff, 0x30, 0x1f,
    0xf3, 0x1, 0xff, 0x30, 0x1f, 0xf3, 0x1, 0xff,
    0x30, 0x1f, 0xf3, 0x1, 0xff, 0x30, 0x1f, 0xf3,
    0x1, 0xff, 0x30, 0x1f, 0xf3, 0x1, 0xff, 0xd4,
    0x1f, 0xff, 0x50,

    /* U+5C "\\" */
    0xdf, 0x70, 0x0, 0x0, 0x7f, 0xd0, 0x0, 0x0,
    0x1f, 0xf3, 0x0, 0x0, 0xb, 0xf9, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0xff, 0x50, 0x0,
    0x0, 0xaf, 0xa0, 0x0, 0x0, 0x4f, 0xf1, 0x0,
    0x0, 0xe, 0xf6, 0x0, 0x0, 0x8, 0xfc, 0x0,
    0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x6f, 0xd0,

    /* U+5D "]" */
    0xbd, 0xd6, 0xef, 0xf7, 0xc, 0xf7, 0xc, 0xf7,
    0xc, 0xf7, 0xc, 0xf7, 0xc, 0xf7, 0xc, 0xf7,
    0xc, 0xf7, 0xc, 0xf7, 0xc, 0xf7, 0xc, 0xf7,
    0xc, 0xf7, 0xc, 0xf7, 0xc, 0xf7, 0xbf, 0xf7,
    0xef, 0xf7,

    /* U+5E "^" */
    0x0, 0x8f, 0x80, 0x0, 0xe, 0xfe, 0x0, 0x4,
    0xfc, 0xf4, 0x0, 0xaf, 0x2f, 0xa0, 0x1f, 0xa0,
    0xaf, 0x17, 0xf5, 0x4, 0xf7,

    /* U+5F "_" */
    0xdd, 0xdd, 0xdd, 0xd1, 0xff, 0xff, 0xff, 0xf2,

    /* U+60 "`" */
    0x38, 0x80, 0x0, 0xbf, 0x80, 0x0, 0xdf, 0x20,

    /* U+61 "a" */
    0x1, 0x9e, 0xfc, 0x50, 0x0, 0xcf, 0xed, 0xff,
    0x40, 0x3f, 0xf1, 0xb, 0xf9, 0x0, 0x0, 0x1,
    0x9f, 0xb0, 0x4, 0xcf, 0xff, 0xfb, 0x2, 0xff,
    0x74, 0xaf, 0xb0, 0x6f, 0xd0, 0xa, 0xfb, 0x3,
    0xff, 0xee, 0xff, 0xb0, 0x5, 0xdf, 0xb7, 0xfe,
    0x0,

    /* U+62 "b" */
    0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x20, 0x0,
    0x0, 0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x7d,
    0xfb, 0x10, 0x2f, 0xff, 0xff, 0xfc, 0x2, 0xff,
    0x60, 0x4f, 0xf3, 0x2f, 0xf2, 0x0, 0xdf, 0x52,
    0xff, 0x20, 0xc, 0xf7, 0x2f, 0xf2, 0x0, 0xdf,
    0x62, 0xff, 0x60, 0x3f, 0xf3, 0x2f, 0xff, 0xff,
    0xfc, 0x2, 0xff, 0x6e, 0xfb, 0x10,

    /* U+63 "c" */
    0x0, 0x8e, 0xfd, 0x50, 0xa, 0xff, 0xff, 0xf5,
    0x2f, 0xf4, 0x8, 0xfc, 0x6f, 0xd0, 0x1, 0x65,
    0x7f, 0xc0, 0x0, 0x0, 0x6f, 0xd0, 0x0, 0x22,
    0x2f, 0xf4, 0x7, 0xfc, 0xa, 0xff, 0xef, 0xf6,
    0x0, 0x8e, 0xfd, 0x60,

    /* U+64 "d" */
    0x0, 0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0x2f,
    0xf2, 0x0, 0x0, 0x2, 0xff, 0x20, 0x1a, 0xfd,
    0x7f, 0xf2, 0xb, 0xff, 0xff, 0xff, 0x22, 0xff,
    0x50, 0x7f, 0xf2, 0x5f, 0xe0, 0x2, 0xff, 0x27,
    0xfc, 0x0, 0x2f, 0xf2, 0x5f, 0xd0, 0x2, 0xff,
    0x22, 0xff, 0x30, 0x5f, 0xf2, 0xb, 0xff, 0xdf,
    0xff, 0x20, 0x1a, 0xfd, 0x6f, 0xf2,

    /* U+65 "e" */
    0x0, 0x6d, 0xfd, 0x70, 0x0, 0x8f, 0xff, 0xff,
    0x70, 0x1f, 0xf5, 0x4, 0xff, 0x5, 0xff, 0x99,
    0x9f, 0xf2, 0x6f, 0xff, 0xff, 0xff, 0x35, 0xff,
    0x0, 0x0, 0x0, 0x1f, 0xf9, 0x0, 0x85, 0x0,
    0x8f, 0xff, 0xff, 0xd0, 0x0, 0x6d, 0xfe, 0xa1,
    0x0,

    /* U+66 "f" */
    0x0, 0x6d, 0xfa, 0x4, 0xff, 0xfa, 0x7, 0xfd,
    0x0, 0xcf, 0xff, 0xf7, 0x8d, 0xfe, 0xb5, 0x8,
    0xfc, 0x0, 0x8, 0xfc, 0x0, 0x8, 0xfc, 0x0,
    0x8, 0xfc, 0x0, 0x8, 0xfc, 0x0, 0x8, 0xfc,
    0x0, 0x8, 0xfc, 0x0,

    /* U+67 "g" */
    0x0, 0xaf, 0xe7, 0xdf, 0x40, 0xaf, 0xff, 0xff,
    0xf4, 0x2f, 0xf6, 0x4, 0xff, 0x45, 0xfe, 0x0,
    0xf, 0xf4, 0x6f, 0xd0, 0x0, 0xff, 0x45, 0xfe,
    0x0, 0xf, 0xf4, 0x2f, 0xf6, 0x4, 0xff, 0x40,
    0xaf, 0xff, 0xff, 0xf4, 0x0, 0x9f, 0xe7, 0xff,
    0x30, 0x15, 0x0, 0x6f, 0xf1, 0xb, 0xff, 0xef,
    0xf9, 0x0, 0x1a, 0xef, 0xd7, 0x0,

    /* U+68 "h" */
    0x3f, 0xf1, 0x0, 0x0, 0x3, 0xff, 0x10, 0x0,
    0x0, 0x3f, 0xf1, 0x0, 0x0, 0x3, 0xff, 0x5d,
    0xfb, 0x20, 0x3f, 0xff, 0xff, 0xfb, 0x3, 0xff,
    0x50, 0x6f, 0xf0, 0x3f, 0xf1, 0x2, 0xff, 0x13,
    0xff, 0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff,
    0x23, 0xff, 0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2,
    0xff, 0x23, 0xff, 0x10, 0x2f, 0xf2,

    /* U+69 "i" */
    0xc, 0xe2, 0x1f, 0xf4, 0x4, 0x50, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,

    /* U+6A "j" */
    0x0, 0xde, 0x20, 0x1f, 0xf4, 0x0, 0x45, 0x0,
    0xf, 0xf4, 0x0, 0xff, 0x40, 0xf, 0xf4, 0x0,
    0xff, 0x40, 0xf, 0xf4, 0x0, 0xff, 0x40, 0xf,
    0xf4, 0x0, 0xff, 0x40, 0xf, 0xf4, 0x2, 0xff,
    0x3b, 0xff, 0xe0, 0xaf, 0xc3, 0x0,

    /* U+6B "k" */
    0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x20, 0x0,
    0x0, 0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x20,
    0xaf, 0xe1, 0x2f, 0xf2, 0x7f, 0xf3, 0x2, 0xff,
    0x6f, 0xf6, 0x0, 0x2f, 0xff, 0xfa, 0x0, 0x2,
    0xff, 0xff, 0xd0, 0x0, 0x2f, 0xfc, 0xef, 0x70,
    0x2, 0xff, 0x26, 0xff, 0x20, 0x2f, 0xf2, 0xc,
    0xfb, 0x2, 0xff, 0x20, 0x3f, 0xf6,

    /* U+6C "l" */
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,

    /* U+6D "m" */
    0x2f, 0xf4, 0xdf, 0xc2, 0x6e, 0xfb, 0x12, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xfa, 0x2f, 0xf6, 0x6,
    0xff, 0x50, 0x8f, 0xe2, 0xff, 0x20, 0x3f, 0xf0,
    0x4, 0xff, 0x2f, 0xf2, 0x3, 0xff, 0x0, 0x4f,
    0xf2, 0xff, 0x20, 0x3f, 0xf0, 0x4, 0xff, 0x2f,
    0xf2, 0x3, 0xff, 0x0, 0x4f, 0xf2, 0xff, 0x20,
    0x3f, 0xf0, 0x4, 0xff, 0x2f, 0xf2, 0x3, 0xff,
    0x0, 0x4f, 0xf0,

    /* U+6E "n" */
    0x2f, 0xf4, 0xdf, 0xc2, 0x2, 0xff, 0xff, 0xff,
    0xc0, 0x2f, 0xf6, 0x6, 0xff, 0x2, 0xff, 0x10,
    0x2f, 0xf1, 0x2f, 0xf1, 0x2, 0xff, 0x22, 0xff,
    0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff, 0x22,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x20,

    /* U+6F "o" */
    0x0, 0x7d, 0xfd, 0x70, 0x0, 0x9f, 0xff, 0xff,
    0x90, 0x2f, 0xf6, 0x5, 0xff, 0x26, 0xfe, 0x0,
    0xd, 0xf6, 0x7f, 0xc0, 0x0, 0xcf, 0x86, 0xfe,
    0x0, 0xd, 0xf7, 0x2f, 0xf5, 0x5, 0xff, 0x30,
    0x9f, 0xff, 0xff, 0xa0, 0x0, 0x7d, 0xfe, 0x80,
    0x0,

    /* U+70 "p" */
    0x2f, 0xf7, 0xdf, 0xb1, 0x2, 0xff, 0xfd, 0xff,
    0xb0, 0x2f, 0xf4, 0x3, 0xff, 0x32, 0xff, 0x20,
    0xd, 0xf5, 0x2f, 0xf2, 0x0, 0xcf, 0x72, 0xff,
    0x20, 0xe, 0xf5, 0x2f, 0xf6, 0x5, 0xff, 0x22,
    0xff, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0xdf, 0xa1,
    0x2, 0xff, 0x20, 0x0, 0x0, 0x2f, 0xf2, 0x0,
    0x0, 0x2, 0xff, 0x20, 0x0, 0x0,

    /* U+71 "q" */
    0x1, 0xaf, 0xe6, 0xef, 0x20, 0xbf, 0xff, 0xff,
    0xf2, 0x3f, 0xf5, 0x6, 0xff, 0x25, 0xfe, 0x0,
    0x2f, 0xf2, 0x7f, 0xc0, 0x2, 0xff, 0x25, 0xfe,
    0x0, 0x2f, 0xf2, 0x2f, 0xf5, 0x6, 0xff, 0x20,
    0xbf, 0xff, 0xff, 0xf2, 0x1, 0xaf, 0xd7, 0xff,
    0x20, 0x0, 0x0, 0x2f, 0xf2, 0x0, 0x0, 0x2,
    0xff, 0x20, 0x0, 0x0, 0x2f, 0xf2,

    /* U+72 "r" */
    0x0, 0x0, 0x0, 0x2f, 0xf7, 0xea, 0x2f, 0xff,
    0xfa, 0x2f, 0xfa, 0x31, 0x2f, 0xf2, 0x0, 0x2f,
    0xf2, 0x0, 0x2f, 0xf2, 0x0, 0x2f, 0xf2, 0x0,
    0x2f, 0xf2, 0x0, 0x2f, 0xf2, 0x0,

    /* U+73 "s" */
    0x2, 0xae, 0xfc, 0x40, 0xd, 0xfd, 0xcf, 0xf3,
    0x3f, 0xf0, 0xa, 0xd7, 0x1f, 0xfa, 0x51, 0x0,
    0x5, 0xef, 0xff, 0x90, 0x0, 0x4, 0x8f, 0xf7,
    0x7f, 0xb0, 0xa, 0xf9, 0x2f, 0xfc, 0xbf, 0xf4,
    0x3, 0xbf, 0xfc, 0x50,

    /* U+74 "t" */
    0xb, 0xf9, 0x0, 0xb, 0xf9, 0x0, 0xef, 0xff,
    0xf0, 0xae, 0xfe, 0xb0, 0xb, 0xf9, 0x0, 0xb,
    0xf9, 0x0, 0xb, 0xf9, 0x0, 0xb, 0xf9, 0x0,
    0xa, 0xfa, 0x0, 0x7, 0xff, 0xf1, 0x1, 0xbf,
    0xe1,

    /* U+75 "u" */
    0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff, 0x10, 0x2f,
    0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x22, 0xff,
    0x10, 0x2f, 0xf2, 0x1f, 0xf4, 0x6, 0xff, 0x20,
    0xdf, 0xff, 0xff, 0xf2, 0x2, 0xcf, 0xd6, 0xff,
    0x20,

    /* U+76 "v" */
    0xbf, 0x90, 0x8, 0xfc, 0x6f, 0xd0, 0xc, 0xf7,
    0x1f, 0xf1, 0x1f, 0xf2, 0xc, 0xf6, 0x5f, 0xd0,
    0x7, 0xfa, 0x9f, 0x80, 0x2, 0xfe, 0xdf, 0x30,
    0x0, 0xdf, 0xfe, 0x0, 0x0, 0x8f, 0xf9, 0x0,
    0x0, 0x3f, 0xf4, 0x0,

    /* U+77 "w" */
    0xaf, 0x80, 0x1f, 0xd0, 0xc, 0xf6, 0x6f, 0xb0,
    0x5f, 0xf1, 0xf, 0xf2, 0x2f, 0xe0, 0xaf, 0xf5,
    0x2f, 0xe0, 0xe, 0xf1, 0xee, 0xfa, 0x5f, 0xa0,
    0xb, 0xf6, 0xf8, 0xce, 0x8f, 0x60, 0x7, 0xfe,
    0xf3, 0x8f, 0xef, 0x30, 0x3, 0xff, 0xf0, 0x3f,
    0xff, 0x0, 0x0, 0xff, 0xa0, 0xf, 0xfb, 0x0,
    0x0, 0xbf, 0x60, 0xa, 0xf7, 0x0,

    /* U+78 "x" */
    0x7f, 0xe0, 0xc, 0xfa, 0x0, 0xef, 0x74, 0xff,
    0x20, 0x5, 0xff, 0xdf, 0x80, 0x0, 0xd, 0xff,
    0xe1, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0xe,
    0xff, 0xf2, 0x0, 0x7, 0xfe, 0xbf, 0xa0, 0x1,
    0xff, 0x63, 0xff, 0x30, 0x8f, 0xd0, 0xa, 0xfc,
    0x0,

    /* U+79 "y" */
    0xcf, 0x90, 0x8, 0xfd, 0x7, 0xfe, 0x0, 0xdf,
    0x70, 0x1f, 0xf2, 0x1f, 0xf2, 0x0, 0xcf, 0x76,
    0xfc, 0x0, 0x6, 0xfb, 0xaf, 0x70, 0x0, 0x1f,
    0xff, 0xf2, 0x0, 0x0, 0xbf, 0xfc, 0x0, 0x0,
    0x6, 0xff, 0x60, 0x0, 0x0, 0x1f, 0xf1, 0x0,
    0x0, 0x8, 0xfb, 0x0, 0x0, 0x1f, 0xff, 0x50,
    0x0, 0x1, 0xee, 0x70, 0x0, 0x0,

    /* U+7A "z" */
    0x4f, 0xff, 0xff, 0xf7, 0x4e, 0xee, 0xff, 0xf5,
    0x0, 0x0, 0xdf, 0xb0, 0x0, 0x8, 0xfe, 0x10,
    0x0, 0x4f, 0xf4, 0x0, 0x1, 0xef, 0x90, 0x0,
    0xa, 0xfd, 0x0, 0x0, 0x4f, 0xff, 0xee, 0xe8,
    0x6f, 0xff, 0xff, 0xf9,

    /* U+7B "{" */
    0x0, 0x5, 0x80, 0x0, 0x7f, 0xc0, 0x0, 0xff,
    0x10, 0x2, 0xfd, 0x0, 0x3, 0xfc, 0x0, 0x3,
    0xfc, 0x0, 0x6, 0xfa, 0x0, 0x7f, 0xf3, 0x0,
    0xaf, 0xc0, 0x0, 0x9, 0xf8, 0x0, 0x4, 0xfc,
    0x0, 0x3, 0xfc, 0x0, 0x3, 0xfc, 0x0, 0x1,
    0xff, 0x0, 0x0, 0xaf, 0x90, 0x0, 0xa, 0xc0,
    0x0, 0x0, 0x0,

    /* U+7C "|" */
    0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
    0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0x1,

    /* U+7D "}" */
    0x57, 0x0, 0x7, 0xfb, 0x0, 0xc, 0xf4, 0x0,
    0x8f, 0x70, 0x8, 0xf8, 0x0, 0x8f, 0x80, 0x5,
    0xfb, 0x0, 0xc, 0xfb, 0x0, 0x8f, 0xe0, 0x4f,
    0xd1, 0x7, 0xf8, 0x0, 0x8f, 0x80, 0x8, 0xf7,
    0x0, 0xaf, 0x50, 0x4f, 0xe0, 0x8, 0xc2, 0x0,
    0x0, 0x0, 0x0,

    /* U+7E "~" */
    0x1, 0xae, 0xa0, 0x1, 0x94, 0xa, 0xff, 0xfc,
    0x27, 0xf6, 0xf, 0xd1, 0x8f, 0xff, 0xf1, 0x1a,
    0x50, 0x7, 0xed, 0x40,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0xaf, 0x4e, 0xf7, 0x36, 0x2, 0x30, 0xbf, 0x3b,
    0xf4, 0xcf, 0x4c, 0xf5, 0xdf, 0x5d, 0xf6, 0xef,
    0x6e, 0xf7,

    /* U+A2 "¢" */
    0x0, 0x1, 0xa4, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x0, 0x3b, 0xfd, 0x60, 0x0, 0x4f, 0xff,
    0xff, 0x80, 0xd, 0xf9, 0x6, 0xff, 0x1, 0xff,
    0x20, 0x8, 0x81, 0x3f, 0xf0, 0x0, 0x0, 0x1,
    0xff, 0x10, 0x0, 0x0, 0xe, 0xf6, 0x1, 0xff,
    0x10, 0x7f, 0xfc, 0xef, 0xb0, 0x0, 0x7e, 0xff,
    0xa1, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0,

    /* U+A3 "£" */
    0x0, 0x7, 0xdf, 0xd7, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0x70, 0x0, 0xef, 0x90, 0x8f, 0xe0, 0x0,
    0xff, 0x40, 0x14, 0x40, 0x0, 0xff, 0x50, 0x0,
    0x0, 0x3e, 0xff, 0xfe, 0xb0, 0x0, 0x3f, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0xff, 0x60, 0x0, 0x0,
    0x0, 0xef, 0x60, 0x0, 0x0, 0x1, 0xff, 0x30,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xf1, 0x3f,
    0xff, 0xff, 0xff, 0xf1,

    /* U+A4 "¤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xd7, 0x6d,
    0xfd, 0x75, 0xe2, 0xc, 0xff, 0xc9, 0xbf, 0xfd,
    0x10, 0x6f, 0x60, 0x0, 0x4f, 0x80, 0xd, 0xb0,
    0x0, 0x0, 0x9f, 0x0, 0xf6, 0x0, 0x0, 0x4,
    0xf2, 0xf, 0x60, 0x0, 0x0, 0x4f, 0x20, 0xdb,
    0x0, 0x0, 0x9, 0xf0, 0x7, 0xf6, 0x0, 0x4,
    0xf9, 0x1, 0xef, 0xfc, 0x9b, 0xff, 0xf3, 0xb,
    0x47, 0xdf, 0xe8, 0x3c, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+A5 "¥" */
    0xbf, 0xb0, 0x2, 0xff, 0x44, 0xff, 0x10, 0x8f,
    0xd0, 0xd, 0xf7, 0xe, 0xf6, 0x0, 0x6f, 0xd4,
    0xff, 0x0, 0x0, 0xff, 0xdf, 0x90, 0x0, 0x2a,
    0xff, 0xf4, 0x10, 0x4f, 0xff, 0xff, 0xfb, 0x2,
    0x66, 0xff, 0xa6, 0x40, 0x4f, 0xff, 0xff, 0xfb,
    0x1, 0x44, 0xef, 0x94, 0x30, 0x0, 0xe, 0xf7,
    0x0, 0x0, 0x0, 0xef, 0x70, 0x0,

    /* U+A6 "¦" */
    0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf,
    0xf0, 0x33, 0x7, 0x70, 0xff, 0xf, 0xf0, 0xff,
    0xf, 0xf0, 0xff, 0xf, 0xf0,

    /* U+A7 "§" */
    0x0, 0x6c, 0xfe, 0xc5, 0x0, 0x9, 0xff, 0xff,
    0xff, 0x70, 0xf, 0xf7, 0x0, 0x9f, 0xe0, 0xf,
    0xf6, 0x0, 0x16, 0x60, 0xa, 0xff, 0xc7, 0x20,
    0x0, 0x6, 0xff, 0xff, 0xfc, 0x20, 0x1f, 0xf2,
    0x27, 0xef, 0xe0, 0x3f, 0xf2, 0x0, 0x2f, 0xf2,
    0xe, 0xfe, 0x93, 0x3f, 0xf1, 0x3, 0xdf, 0xff,
    0xff, 0x60, 0x0, 0x4, 0x9e, 0xff, 0x80, 0x15,
    0x40, 0x0, 0x8f, 0xf0, 0x2f, 0xf5, 0x0, 0x7f,
    0xf0, 0xb, 0xff, 0xff, 0xff, 0x90, 0x0, 0x7d,
    0xff, 0xc6, 0x0,

    /* U+A8 "¨" */
    0x0, 0x0, 0x0, 0x1, 0xfb, 0x4, 0xf7, 0x1e,
    0xa0, 0x3f, 0x70,

    /* U+A9 "©" */
    0x0, 0x2, 0x9c, 0xdb, 0x50, 0x0, 0x0, 0x5e,
    0x73, 0x25, 0xcb, 0x0, 0x3, 0xe2, 0x6d, 0xe9,
    0x9, 0xa0, 0xc, 0x43, 0xf5, 0x3d, 0x80, 0xd3,
    0x1d, 0x8, 0xb0, 0x4, 0x60, 0x78, 0x4a, 0x9,
    0x90, 0x0, 0x0, 0x4b, 0x4a, 0x8, 0xa0, 0x3,
    0x40, 0x3b, 0x2d, 0x4, 0xe2, 0xb, 0x90, 0x69,
    0xc, 0x40, 0x9f, 0xfc, 0x10, 0xc3, 0x4, 0xd1,
    0x0, 0x10, 0x8, 0xb0, 0x0, 0x7e, 0x61, 0x3,
    0xbc, 0x10, 0x0, 0x3, 0xae, 0xfc, 0x70, 0x0,

    /* U+AA "ª" */
    0x3c, 0xfd, 0x30, 0x68, 0x3a, 0xc0, 0x3c, 0xef,
    0xe0, 0xca, 0x7, 0xe0, 0xda, 0x3b, 0xe0, 0x5e,
    0xeb, 0xf0,

    /* U+AB "«" */
    0x0, 0x38, 0x3, 0x80, 0x0, 0xda, 0xd, 0xa0,
    0x9, 0xf1, 0x9f, 0x10, 0x3f, 0x83, 0xf8, 0x0,
    0xd, 0xc0, 0xdc, 0x0, 0x3, 0xf6, 0x3f, 0x60,
    0x0, 0x8e, 0x8, 0xe0,

    /* U+AC "¬" */
    0x1, 0x11, 0x11, 0x10, 0xf, 0xff, 0xff, 0xf8,
    0x4, 0x44, 0x45, 0xf8, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x42,

    /* U+AD "­" */
    0x2e, 0xee, 0xe3, 0x2f, 0xff, 0xf4,

    /* U+AE "®" */
    0x0, 0x2, 0x9c, 0xdb, 0x50, 0x0, 0x0, 0x5e,
    0x73, 0x25, 0xcb, 0x0, 0x3, 0xe3, 0xff, 0xea,
    0x19, 0xa0, 0xc, 0x41, 0xf3, 0x2c, 0x80, 0xd3,
    0x1d, 0x1, 0xf1, 0xb, 0x80, 0x78, 0x4a, 0x1,
    0xff, 0xff, 0x10, 0x4b, 0x4a, 0x1, 0xf3, 0x2c,
    0x70, 0x3b, 0x2d, 0x1, 0xf1, 0x8, 0x90, 0x69,
    0xc, 0x41, 0xf1, 0x8, 0xa0, 0xc3, 0x4, 0xd1,
    0x20, 0x0, 0x18, 0xb0, 0x0, 0x7e, 0x61, 0x3,
    0xbc, 0x10, 0x0, 0x3, 0xae, 0xfc, 0x70, 0x0,

    /* U+AF "¯" */
    0x11, 0x11, 0x11, 0xbf, 0xff, 0xfb, 0x24, 0x44,
    0x42,

    /* U+B0 "°" */
    0x3, 0xde, 0x60, 0xe, 0x85, 0xf1, 0xe, 0x52,
    0xf1, 0x6, 0xff, 0x90, 0x0, 0x11, 0x0,

    /* U+B1 "±" */
    0x0, 0x8, 0xc3, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x4f, 0xff, 0xff, 0xfd,
    0x4f, 0xff, 0xff, 0xfd, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xee, 0xee, 0xe9,
    0x1f, 0xff, 0xff, 0xfa,

    /* U+B2 "²" */
    0x9, 0xfe, 0x80, 0x6f, 0x8a, 0xf2, 0x12, 0xb,
    0xf1, 0x0, 0xaf, 0x40, 0x1c, 0xf7, 0x41, 0x6f,
    0xff, 0xf6,

    /* U+B3 "³" */
    0xa, 0xfe, 0x90, 0x5c, 0x7a, 0xf3, 0x0, 0xcf,
    0xb0, 0x0, 0x17, 0xf4, 0x7e, 0x69, 0xf5, 0x1b,
    0xfe, 0x80,

    /* U+B4 "´" */
    0x0, 0x78, 0x40, 0x4f, 0xd1, 0xd, 0xe2, 0x0,

    /* U+B5 "µ" */
    0xef, 0x50, 0xa, 0xf9, 0xef, 0x50, 0xa, 0xf9,
    0xef, 0x50, 0xa, 0xf9, 0xef, 0x50, 0xa, 0xf9,
    0xef, 0x50, 0xa, 0xf9, 0xef, 0x50, 0xa, 0xf9,
    0xef, 0x90, 0xc, 0xf9, 0xef, 0xfc, 0xef, 0xf9,
    0xef, 0xef, 0xdc, 0xf9, 0xef, 0x50, 0x0, 0x0,
    0xef, 0x50, 0x0, 0x0, 0xef, 0x50, 0x0, 0x0,

    /* U+B6 "¶" */
    0x0, 0x8e, 0xff, 0xc0, 0xbf, 0xff, 0xfc, 0x3f,
    0xff, 0xff, 0xc6, 0xff, 0xff, 0xfc, 0x5f, 0xff,
    0xff, 0xc1, 0xff, 0xff, 0xfc, 0x6, 0xff, 0xff,
    0xc0, 0x3, 0x8a, 0xfc, 0x0, 0x0, 0xe, 0xc0,
    0x0, 0x0, 0xec, 0x0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0xec,

    /* U+B7 "·" */
    0x37, 0x1d, 0xf9, 0x9f, 0x50,

    /* U+B8 "¸" */
    0x1f, 0xc1, 0x6, 0xfa, 0x6, 0xfb, 0xf, 0xe3,
    0x3, 0x0,

    /* U+B9 "¹" */
    0x0, 0x0, 0x5a, 0xf2, 0xee, 0xf2, 0x7, 0xf2,
    0x7, 0xf2, 0x7, 0xf2, 0x7, 0xf2,

    /* U+BA "º" */
    0x2, 0xbf, 0xd4, 0x0, 0xcc, 0x39, 0xf1, 0xf,
    0x50, 0x1f, 0x40, 0xf5, 0x1, 0xf4, 0xc, 0xb3,
    0x8f, 0x10, 0x2b, 0xfd, 0x40,

    /* U+BB "»" */
    0x18, 0x20, 0x83, 0x0, 0xb, 0xc0, 0xad, 0x0,
    0x2, 0xf8, 0x2f, 0x90, 0x0, 0xaf, 0x29, 0xf3,
    0x0, 0xdd, 0xd, 0xd0, 0x7, 0xf2, 0x6f, 0x30,
    0x1f, 0x70, 0xe8, 0x0,

    /* U+BC "¼" */
    0x1, 0x6a, 0x0, 0x0, 0x0, 0x2, 0xff, 0xd0,
    0x0, 0x39, 0x0, 0x14, 0xcd, 0x0, 0xd, 0xa0,
    0x0, 0xb, 0xd0, 0x7, 0xf1, 0x0, 0x0, 0xbd,
    0x2, 0xf6, 0x0, 0x0, 0xb, 0xd0, 0xbc, 0x4,
    0x71, 0x0, 0x56, 0x5f, 0x22, 0xff, 0x20, 0x0,
    0xe, 0x80, 0xdd, 0xf2, 0x0, 0x9, 0xd0, 0xab,
    0x7f, 0x30, 0x3, 0xf4, 0x2f, 0xff, 0xfd, 0x0,
    0x15, 0x0, 0x44, 0x9f, 0x50, 0x0, 0x0, 0x0,
    0x6, 0xf2,

    /* U+BD "½" */
    0x0, 0x14, 0x0, 0x0, 0x0, 0x0, 0x2b, 0xfb,
    0x0, 0x2, 0x0, 0x0, 0x4a, 0xeb, 0x0, 0xd,
    0x90, 0x0, 0x0, 0xdb, 0x0, 0x7e, 0x10, 0x0,
    0x0, 0xdb, 0x1, 0xf6, 0x0, 0x0, 0x0, 0xdb,
    0xa, 0xc0, 0x0, 0x0, 0x0, 0xdb, 0x4f, 0x39,
    0xff, 0xa0, 0x0, 0x0, 0xd9, 0x4f, 0x98, 0xf4,
    0x0, 0x8, 0xe1, 0x12, 0x8, 0xf3, 0x0, 0x2f,
    0x50, 0x0, 0x7f, 0x80, 0x0, 0x9c, 0x0, 0x9,
    0xf7, 0x10, 0x0, 0x1, 0x0, 0x4f, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x14, 0x44, 0x42,

    /* U+BE "¾" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0xc, 0x96, 0xf8,
    0x0, 0x1c, 0x20, 0x0, 0x0, 0x2f, 0x80, 0x9,
    0xd0, 0x0, 0x0, 0x7f, 0xe2, 0x3, 0xf4, 0x0,
    0x2, 0xc8, 0x4f, 0xb0, 0xda, 0x0, 0x0, 0xb,
    0xff, 0xf6, 0x7e, 0x12, 0x72, 0x0, 0x2, 0x31,
    0x2f, 0x60, 0xdf, 0x60, 0x0, 0x0, 0xb, 0xc0,
    0xac, 0xf6, 0x0, 0x0, 0x5, 0xf2, 0x6d, 0x4f,
    0x70, 0x0, 0x0, 0xe8, 0xe, 0xff, 0xff, 0x10,
    0x0, 0x6, 0x0, 0x34, 0x6f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf6, 0x0,

    /* U+BF "¿" */
    0x0, 0xb, 0xe3, 0x0, 0x0, 0xf, 0xf6, 0x0,
    0x0, 0x3, 0x60, 0x0, 0x0, 0x3, 0x40, 0x0,
    0x0, 0xe, 0xf2, 0x0, 0x0, 0x7f, 0xe0, 0x0,
    0x6, 0xff, 0x40, 0x0, 0x1f, 0xf5, 0x0, 0x0,
    0x6f, 0xe0, 0x3, 0x42, 0x5f, 0xe1, 0x1e, 0xf7,
    0x1e, 0xff, 0xff, 0xf1, 0x3, 0xbe, 0xeb, 0x30,

    /* U+C0 "À" */
    0x0, 0x2e, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x48, 0x30, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0xe, 0xfd, 0xfb, 0x0, 0x0, 0x4,
    0xff, 0x4f, 0xf1, 0x0, 0x0, 0xaf, 0xb0, 0xef,
    0x60, 0x0, 0xf, 0xf6, 0xa, 0xfc, 0x0, 0x5,
    0xff, 0x10, 0x5f, 0xf2, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x70, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x6,
    0xff, 0x20, 0x0, 0x5f, 0xf2, 0xcf, 0xb0, 0x0,
    0x0, 0xef, 0x80,

    /* U+C1 "Á" */
    0x0, 0x0, 0x7, 0xfd, 0x10, 0x0, 0x0, 0x1,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x48, 0x30, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0xe, 0xfd, 0xfb, 0x0, 0x0, 0x4,
    0xff, 0x4f, 0xf1, 0x0, 0x0, 0xaf, 0xb0, 0xef,
    0x60, 0x0, 0xf, 0xf6, 0xa, 0xfc, 0x0, 0x5,
    0xff, 0x10, 0x5f, 0xf2, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x70, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x6,
    0xff, 0x20, 0x0, 0x5f, 0xf2, 0xcf, 0xb0, 0x0,
    0x0, 0xef, 0x80,

    /* U+C2 "Â" */
    0x0, 0x0, 0xbf, 0x80, 0x0, 0x0, 0x0, 0xbf,
    0x8f, 0x70, 0x0, 0x0, 0x38, 0x30, 0x57, 0x10,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0xe, 0xfd, 0xfb, 0x0, 0x0, 0x4,
    0xff, 0x4f, 0xf1, 0x0, 0x0, 0xaf, 0xb0, 0xef,
    0x60, 0x0, 0xf, 0xf6, 0xa, 0xfc, 0x0, 0x5,
    0xff, 0x10, 0x5f, 0xf2, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x70, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x6,
    0xff, 0x20, 0x0, 0x5f, 0xf2, 0xcf, 0xb0, 0x0,
    0x0, 0xef, 0x80,

    /* U+C3 "Ã" */
    0x0, 0x0, 0x10, 0x2, 0x0, 0x0, 0x0, 0xdf,
    0x84, 0xf4, 0x0, 0x0, 0x6f, 0x6d, 0xfd, 0x0,
    0x0, 0x2, 0x40, 0x4, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xa0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xef, 0xdf, 0xb0, 0x0, 0x0, 0x4f, 0xf4, 0xff,
    0x10, 0x0, 0xa, 0xfb, 0xe, 0xf6, 0x0, 0x0,
    0xff, 0x60, 0xaf, 0xc0, 0x0, 0x5f, 0xf1, 0x5,
    0xff, 0x20, 0xb, 0xff, 0xff, 0xff, 0xf7, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x6f, 0xf2, 0x0,
    0x5, 0xff, 0x2c, 0xfb, 0x0, 0x0, 0xe, 0xf8,

    /* U+C4 "Ä" */
    0x0, 0x5f, 0x50, 0x8e, 0x30, 0x0, 0x6, 0xf6,
    0x9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0xe, 0xfd, 0xfb, 0x0, 0x0, 0x4,
    0xff, 0x4f, 0xf1, 0x0, 0x0, 0xaf, 0xb0, 0xef,
    0x60, 0x0, 0xf, 0xf6, 0xa, 0xfc, 0x0, 0x5,
    0xff, 0x10, 0x5f, 0xf2, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x70, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x6,
    0xff, 0x20, 0x0, 0x5f, 0xf2, 0xcf, 0xb0, 0x0,
    0x0, 0xef, 0x80,

    /* U+C5 "Å" */
    0x0, 0x0, 0x8c, 0x60, 0x0, 0x0, 0x0, 0x3b,
    0xd, 0x10, 0x0, 0x0, 0x3, 0xb0, 0xd1, 0x0,
    0x0, 0x0, 0x8, 0xc6, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xa0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xef, 0xdf, 0xb0, 0x0, 0x0, 0x4f, 0xf4, 0xff,
    0x10, 0x0, 0xa, 0xfb, 0xe, 0xf6, 0x0, 0x0,
    0xff, 0x60, 0xaf, 0xc0, 0x0, 0x5f, 0xf1, 0x5,
    0xff, 0x20, 0xb, 0xff, 0xff, 0xff, 0xf7, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x6f, 0xf2, 0x0,
    0x5, 0xff, 0x2c, 0xfb, 0x0, 0x0, 0xe, 0xf8,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x9f, 0xff, 0xfe, 0xee, 0xe1, 0x0,
    0x0, 0x2f, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfb, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x3b, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xb0, 0xbf, 0xff, 0xff, 0x70, 0x0, 0x2f, 0xf3,
    0xa, 0xff, 0xee, 0xe6, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0xbf, 0xc0, 0x0, 0x8f,
    0xb0, 0x0, 0x0, 0x3f, 0xf5, 0x0, 0x7, 0xff,
    0xee, 0xee, 0x8b, 0xfe, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf9,

    /* U+C7 "Ç" */
    0x0, 0x19, 0xef, 0xe9, 0x10, 0x1, 0xdf, 0xff,
    0xff, 0xd1, 0xa, 0xfe, 0x30, 0x3e, 0xf8, 0xf,
    0xf6, 0x0, 0x8, 0xfd, 0x3f, 0xf2, 0x0, 0x0,
    0x21, 0x4f, 0xf0, 0x0, 0x0, 0x0, 0x5f, 0xf0,
    0x0, 0x0, 0x0, 0x3f, 0xf2, 0x0, 0x0, 0x11,
    0xf, 0xf5, 0x0, 0x8, 0xfd, 0xa, 0xfd, 0x30,
    0x3e, 0xf9, 0x1, 0xef, 0xff, 0xff, 0xd1, 0x0,
    0x19, 0xff, 0xe9, 0x10, 0x0, 0x0, 0x9f, 0xa0,
    0x0, 0x0, 0x0, 0x2d, 0xf3, 0x0, 0x0, 0x0,
    0x6e, 0x90, 0x0,

    /* U+C8 "È" */
    0x7, 0xfd, 0x0, 0x0, 0x0, 0xaf, 0x70, 0x0,
    0x0, 0x7, 0x70, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+C9 "É" */
    0x0, 0x0, 0xdf, 0x70, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x7, 0x70, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+CA "Ê" */
    0x0, 0x5f, 0xf4, 0x0, 0x8, 0xf6, 0x7f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+CB "Ë" */
    0xc, 0xd0, 0x1e, 0xb0, 0xd, 0xe0, 0x1e, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+CC "Ì" */
    0x2f, 0xf3, 0x0, 0x4f, 0xd0, 0x0, 0x58, 0x20,
    0xd, 0xf8, 0x0, 0xdf, 0x80, 0xd, 0xf8, 0x0,
    0xdf, 0x80, 0xd, 0xf8, 0x0, 0xdf, 0x80, 0xd,
    0xf8, 0x0, 0xdf, 0x80, 0xd, 0xf8, 0x0, 0xdf,
    0x80, 0xd, 0xf8, 0x0, 0xdf, 0x80,

    /* U+CD "Í" */
    0x8, 0xfc, 0x2, 0xfd, 0x10, 0x58, 0x20, 0xd,
    0xf8, 0x0, 0xdf, 0x80, 0xd, 0xf8, 0x0, 0xdf,
    0x80, 0xd, 0xf8, 0x0, 0xdf, 0x80, 0xd, 0xf8,
    0x0, 0xdf, 0x80, 0xd, 0xf8, 0x0, 0xdf, 0x80,
    0xd, 0xf8, 0x0, 0xdf, 0x80, 0x0,

    /* U+CE "Î" */
    0x1, 0xcf, 0x90, 0x3, 0xeb, 0x4e, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80,
    0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0,
    0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0xdf, 0x80, 0x0,

    /* U+CF "Ï" */
    0x6f, 0x40, 0x9e, 0x27, 0xf5, 0xa, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80,
    0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0,
    0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0xdf, 0x80, 0x0,

    /* U+D0 "Ð" */
    0x0, 0xcf, 0xff, 0xea, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xcf, 0x90, 0x2a, 0xff,
    0x20, 0xc, 0xf9, 0x0, 0xd, 0xf8, 0x2, 0xcf,
    0xa2, 0x0, 0x8f, 0xd2, 0xff, 0xff, 0xf5, 0x7,
    0xfe, 0x5, 0xdf, 0xb5, 0x10, 0x7f, 0xe0, 0xc,
    0xf9, 0x0, 0x9, 0xfd, 0x0, 0xcf, 0x90, 0x0,
    0xef, 0x90, 0xc, 0xf9, 0x1, 0xaf, 0xf2, 0x0,
    0xcf, 0xff, 0xff, 0xf6, 0x0, 0xc, 0xff, 0xfe,
    0xb3, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0x1, 0x0, 0x11, 0x0, 0x0, 0xaf, 0xa3,
    0xe8, 0x0, 0x2, 0xf8, 0xaf, 0xf2, 0x0, 0x1,
    0x50, 0x3, 0x20, 0x0, 0xff, 0xa0, 0x0, 0x1f,
    0xf4, 0xff, 0xf3, 0x0, 0x1f, 0xf4, 0xff, 0xfc,
    0x0, 0x1f, 0xf4, 0xff, 0xff, 0x60, 0x1f, 0xf4,
    0xff, 0xcf, 0xe0, 0x1f, 0xf4, 0xff, 0x5d, 0xf8,
    0x1f, 0xf4, 0xff, 0x54, 0xff, 0x3f, 0xf4, 0xff,
    0x50, 0xaf, 0xcf, 0xf4, 0xff, 0x50, 0x2f, 0xff,
    0xf4, 0xff, 0x50, 0x8, 0xff, 0xf4, 0xff, 0x50,
    0x0, 0xef, 0xf4, 0xff, 0x50, 0x0, 0x5f, 0xf4,

    /* U+D2 "Ò" */
    0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x38, 0x40, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+D3 "Ó" */
    0x0, 0x0, 0x5, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x30, 0x0, 0x0, 0x0, 0x38, 0x40, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+D4 "Ô" */
    0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x2, 0xdc,
    0x3c, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+D5 "Õ" */
    0x0, 0x0, 0x10, 0x1, 0x0, 0x0, 0x0, 0xcf,
    0x93, 0xf5, 0x0, 0x0, 0x4f, 0x6c, 0xfe, 0x0,
    0x0, 0x2, 0x40, 0x4, 0x10, 0x0, 0x0, 0x8,
    0xdf, 0xd8, 0x10, 0x0, 0xd, 0xff, 0xff, 0xfd,
    0x10, 0x9, 0xff, 0x51, 0x4e, 0xf9, 0x0, 0xff,
    0x70, 0x0, 0x7f, 0xf0, 0x3f, 0xf2, 0x0, 0x2,
    0xff, 0x34, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x4f,
    0xf1, 0x0, 0x0, 0xff, 0x53, 0xff, 0x20, 0x0,
    0x2f, 0xf3, 0xf, 0xf7, 0x0, 0x6, 0xff, 0x0,
    0x9f, 0xf5, 0x4, 0xef, 0x90, 0x0, 0xdf, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0,

    /* U+D6 "Ö" */
    0x0, 0x4f, 0x70, 0x6f, 0x40, 0x0, 0x4, 0xf8,
    0x7, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+D7 "×" */
    0x3, 0x0, 0x0, 0x40, 0x2f, 0xc0, 0x5, 0xf9,
    0xc, 0xfb, 0x5f, 0xf5, 0x1, 0xdf, 0xff, 0x50,
    0x0, 0x5f, 0xfc, 0x0, 0x3, 0xff, 0xff, 0x90,
    0x2e, 0xf8, 0x3f, 0xf7, 0x1d, 0x90, 0x3, 0xf6,
    0x1, 0x0, 0x0, 0x10,

    /* U+D8 "Ø" */
    0x0, 0x7, 0xdf, 0xe8, 0xcb, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x30, 0x8, 0xff, 0x51, 0x5f, 0xfa,
    0x0, 0xef, 0x80, 0x9, 0xff, 0xf1, 0x2f, 0xf3,
    0x3, 0xf5, 0xff, 0x43, 0xff, 0x20, 0xcb, 0xf,
    0xf6, 0x3f, 0xf2, 0x5f, 0x20, 0xff, 0x62, 0xff,
    0x4e, 0x80, 0x1f, 0xf4, 0xe, 0xfe, 0xe0, 0x5,
    0xff, 0x10, 0x8f, 0xf9, 0x3, 0xef, 0xa0, 0x0,
    0xef, 0xff, 0xff, 0xe1, 0x0, 0x3f, 0x9d, 0xfe,
    0x91, 0x0, 0x5, 0x60, 0x0, 0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0x3f, 0xf2, 0x0, 0x0, 0x0, 0x5, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x68, 0x10, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+DA "Ú" */
    0x0, 0x0, 0x9, 0xfb, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x58, 0x10, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+DB "Û" */
    0x0, 0x2, 0xdf, 0x70, 0x0, 0x0, 0x4f, 0x94,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+DC "Ü" */
    0x0, 0x8e, 0x30, 0xae, 0x10, 0x0, 0x8f, 0x30,
    0xbe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+DD "Ý" */
    0x0, 0x0, 0xd, 0xf7, 0x0, 0x0, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x0, 0x77, 0x0, 0x0, 0xbf,
    0xc0, 0x0, 0xe, 0xfa, 0x4f, 0xf3, 0x0, 0x5f,
    0xf2, 0xc, 0xfa, 0x0, 0xcf, 0xa0, 0x4, 0xff,
    0x23, 0xff, 0x20, 0x0, 0xcf, 0x8a, 0xfa, 0x0,
    0x0, 0x4f, 0xff, 0xf3, 0x0, 0x0, 0xc, 0xff,
    0xb0, 0x0, 0x0, 0x5, 0xff, 0x30, 0x0, 0x0,
    0x4, 0xff, 0x20, 0x0, 0x0, 0x4, 0xff, 0x20,
    0x0, 0x0, 0x4, 0xff, 0x20, 0x0, 0x0, 0x4,
    0xff, 0x20, 0x0,

    /* U+DE "Þ" */
    0xff, 0x40, 0x0, 0x0, 0xf, 0xf4, 0x0, 0x0,
    0x0, 0xff, 0xee, 0xdb, 0x40, 0xf, 0xff, 0xff,
    0xff, 0x60, 0xff, 0x40, 0x1a, 0xfe, 0xf, 0xf4,
    0x0, 0x1f, 0xf2, 0xff, 0x40, 0x1, 0xff, 0x3f,
    0xf4, 0x1, 0xaf, 0xf0, 0xff, 0xff, 0xff, 0xf6,
    0xf, 0xfe, 0xed, 0xb4, 0x0, 0xff, 0x40, 0x0,
    0x0, 0xf, 0xf4, 0x0, 0x0, 0x0,

    /* U+DF "ß" */
    0x5, 0xcf, 0xe9, 0x10, 0x5, 0xff, 0xef, 0xfa,
    0x0, 0xcf, 0x90, 0x6f, 0xf0, 0xe, 0xf5, 0x4,
    0xff, 0x0, 0xff, 0x50, 0xbf, 0x80, 0xf, 0xf5,
    0xf, 0xf4, 0x0, 0xff, 0x50, 0xdf, 0xc0, 0xf,
    0xf5, 0x3, 0xef, 0xc0, 0xff, 0x50, 0x2, 0xef,
    0x6f, 0xf5, 0x0, 0xc, 0xf7, 0xff, 0x5c, 0xcd,
    0xff, 0x3f, 0xf5, 0xdf, 0xfc, 0x40,

    /* U+E0 "à" */
    0x3, 0xff, 0x30, 0x0, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x0, 0x5, 0x82, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E1 "á" */
    0x0, 0x0, 0x8f, 0xc0, 0x0, 0x0, 0x2f, 0xd1,
    0x0, 0x0, 0x5, 0x82, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E2 "â" */
    0x0, 0x2d, 0xf8, 0x0, 0x0, 0x3e, 0xa3, 0xea,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E3 "ã" */
    0x3, 0xdf, 0xff, 0xf1, 0x0, 0x47, 0x77, 0x73,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E4 "ä" */
    0x6, 0xf4, 0x9, 0xe1, 0x0, 0x7f, 0x40, 0xaf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E5 "å" */
    0x0, 0x9, 0xc5, 0x0, 0x0, 0x5, 0xa0, 0xe0,
    0x0, 0x0, 0x59, 0xe, 0x0, 0x0, 0x0, 0x9c,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19,
    0xef, 0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3,
    0xff, 0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb,
    0x0, 0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a,
    0xfb, 0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe,
    0xef, 0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+E6 "æ" */
    0x1, 0x8d, 0xfd, 0x66, 0xdf, 0xe7, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2d, 0xd3,
    0x8, 0xff, 0x50, 0x5f, 0xe0, 0x0, 0x58, 0x9b,
    0xff, 0xaa, 0xaf, 0xf0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x5f, 0xf3, 0x5, 0xff, 0x0,
    0x0, 0x0, 0x6f, 0xe0, 0x7, 0xff, 0x80, 0x3,
    0x30, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x4, 0xcf, 0xe9, 0x16, 0xdf, 0xeb, 0x40,

    /* U+E7 "ç" */
    0x0, 0x8e, 0xfd, 0x50, 0xa, 0xff, 0xff, 0xf5,
    0x2f, 0xf4, 0x8, 0xfc, 0x6f, 0xd0, 0x1, 0x65,
    0x7f, 0xc0, 0x0, 0x0, 0x6f, 0xd0, 0x0, 0x22,
    0x2f, 0xf3, 0x7, 0xfd, 0xa, 0xff, 0xef, 0xf6,
    0x0, 0x8f, 0xfd, 0x60, 0x0, 0x9, 0xfa, 0x0,
    0x0, 0x3, 0xdf, 0x30, 0x0, 0x7, 0xe8, 0x0,

    /* U+E8 "è" */
    0x3, 0xff, 0x20, 0x0, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0x0, 0x5, 0x81, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+E9 "é" */
    0x0, 0x0, 0x9f, 0xb0, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x5, 0x81, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+EA "ê" */
    0x0, 0x2d, 0xf7, 0x0, 0x0, 0x4e, 0x94, 0xea,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+EB "ë" */
    0x7, 0xf3, 0xa, 0xe1, 0x0, 0x8f, 0x40, 0xbf,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+EC "ì" */
    0x4f, 0xf2, 0x0, 0x6f, 0xb0, 0x0, 0x68, 0x10,
    0xf, 0xf5, 0x0, 0xff, 0x50, 0xf, 0xf5, 0x0,
    0xff, 0x50, 0xf, 0xf5, 0x0, 0xff, 0x50, 0xf,
    0xf5, 0x0, 0xff, 0x50, 0xf, 0xf5,

    /* U+ED "í" */
    0xa, 0xfa, 0x4, 0xfc, 0x0, 0x68, 0x10, 0xf,
    0xf5, 0x0, 0xff, 0x50, 0xf, 0xf5, 0x0, 0xff,
    0x50, 0xf, 0xf5, 0x0, 0xff, 0x50, 0xf, 0xf5,
    0x0, 0xff, 0x50, 0xf, 0xf5, 0x0,

    /* U+EE "î" */
    0x3, 0xef, 0x70, 0x5, 0xe8, 0x4e, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff,
    0x50, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0,
    0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0, 0xf,
    0xf5, 0x0,

    /* U+EF "ï" */
    0x8e, 0x20, 0xbd, 0x9, 0xf3, 0xc, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff,
    0x50, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0,
    0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0, 0xf,
    0xf5, 0x0,

    /* U+F0 "ð" */
    0x0, 0xaa, 0x40, 0x11, 0x0, 0xf, 0xff, 0xbe,
    0x70, 0x0, 0x19, 0xff, 0xd0, 0x0, 0x1, 0xeb,
    0xff, 0x80, 0x0, 0x3, 0x6, 0xff, 0x10, 0x9,
    0xef, 0xbf, 0xf5, 0x9, 0xff, 0xde, 0xff, 0x81,
    0xff, 0x60, 0xb, 0xfa, 0x4f, 0xf0, 0x0, 0xaf,
    0x94, 0xff, 0x0, 0xc, 0xf7, 0x1f, 0xf7, 0x4,
    0xff, 0x20, 0x8f, 0xff, 0xff, 0x80, 0x0, 0x6d,
    0xfd, 0x70, 0x0,

    /* U+F1 "ñ" */
    0x1, 0xcf, 0xff, 0xf4, 0x0, 0x37, 0x77, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x4d,
    0xfc, 0x20, 0x2f, 0xff, 0xff, 0xfc, 0x2, 0xff,
    0x60, 0x6f, 0xf0, 0x2f, 0xf1, 0x2, 0xff, 0x12,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x22, 0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2,
    0xff, 0x22, 0xff, 0x10, 0x2f, 0xf2,

    /* U+F2 "ò" */
    0x1, 0xdf, 0x60, 0x0, 0x0, 0x2, 0xee, 0x10,
    0x0, 0x0, 0x3, 0x83, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+F3 "ó" */
    0x0, 0x0, 0x5f, 0xe1, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x3, 0x84, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+F4 "ô" */
    0x0, 0xb, 0xfb, 0x0, 0x0, 0x2d, 0xc3, 0xcc,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+F5 "õ" */
    0x1, 0xcf, 0xff, 0xf4, 0x0, 0x27, 0x77, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+F6 "ö" */
    0x4, 0xf7, 0x6, 0xf4, 0x0, 0x4f, 0x70, 0x7f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+F7 "÷" */
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0x1, 0x62, 0x0, 0x7, 0xee, 0xee,
    0xee, 0xe7, 0x8f, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x61, 0x0, 0x0,
    0x0, 0xaf, 0xb0, 0x0, 0x0, 0x7, 0xf7, 0x0,
    0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x0, 0xb8, 0x0, 0x7, 0xdf, 0xdf,
    0x20, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff, 0x62,
    0xff, 0xf2, 0x6f, 0xe0, 0x9a, 0xdf, 0x67, 0xfc,
    0x1f, 0x3c, 0xf8, 0x6f, 0xe8, 0xb0, 0xdf, 0x72,
    0xff, 0xf3, 0x5f, 0xf3, 0x9, 0xff, 0xff, 0xfa,
    0x0, 0xf, 0xdf, 0xe8, 0x0, 0x7, 0xd0, 0x0,
    0x0, 0x0,

    /* U+F9 "ù" */
    0x1, 0xef, 0x50, 0x0, 0x0, 0x2, 0xfe, 0x0,
    0x0, 0x0, 0x4, 0x83, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+FA "ú" */
    0x0, 0x0, 0x6f, 0xd1, 0x0, 0x0, 0x1e, 0xf2,
    0x0, 0x0, 0x3, 0x83, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+FB "û" */
    0x0, 0x1b, 0xfa, 0x0, 0x0, 0x2c, 0xb2, 0xbb,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+FC "ü" */
    0x4, 0xf6, 0x7, 0xf3, 0x0, 0x5f, 0x70, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+FD "ý" */
    0x0, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0xc, 0xf9, 0x0,
    0x8f, 0xd0, 0x7f, 0xe0, 0xd, 0xf7, 0x1, 0xff,
    0x21, 0xff, 0x20, 0xc, 0xf7, 0x6f, 0xc0, 0x0,
    0x6f, 0xba, 0xf7, 0x0, 0x1, 0xff, 0xff, 0x20,
    0x0, 0xb, 0xff, 0xc0, 0x0, 0x0, 0x6f, 0xf6,
    0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0, 0x8f,
    0xb0, 0x0, 0x1, 0xff, 0xf5, 0x0, 0x0, 0x1e,
    0xe7, 0x0, 0x0, 0x0,

    /* U+FE "þ" */
    0x1f, 0xf2, 0x0, 0x0, 0x1, 0xff, 0x20, 0x0,
    0x0, 0x1f, 0xf2, 0x0, 0x0, 0x1, 0xff, 0x7d,
    0xfb, 0x10, 0x1f, 0xff, 0xff, 0xfc, 0x1, 0xff,
    0x60, 0x5f, 0xf3, 0x1f, 0xf2, 0x0, 0xef, 0x61,
    0xff, 0x20, 0xc, 0xf7, 0x1f, 0xf2, 0x0, 0xef,
    0x61, 0xff, 0x60, 0x4f, 0xf3, 0x1f, 0xff, 0xff,
    0xfb, 0x1, 0xff, 0x7d, 0xfb, 0x10, 0x1f, 0xf2,
    0x0, 0x0, 0x1, 0xff, 0x20, 0x0, 0x0, 0x1f,
    0xf2, 0x0, 0x0, 0x0,

    /* U+FF "ÿ" */
    0xa, 0xe1, 0xd, 0xc0, 0x0, 0xbf, 0x10, 0xed,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9, 0x0,
    0x8f, 0xd0, 0x7f, 0xe0, 0xd, 0xf7, 0x1, 0xff,
    0x21, 0xff, 0x20, 0xc, 0xf7, 0x6f, 0xc0, 0x0,
    0x6f, 0xba, 0xf7, 0x0, 0x1, 0xff, 0xff, 0x20,
    0x0, 0xb, 0xff, 0xc0, 0x0, 0x0, 0x6f, 0xf6,
    0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0, 0x8f,
    0xb0, 0x0, 0x1, 0xff, 0xf5, 0x0, 0x0, 0x1e,
    0xe7, 0x0, 0x0, 0x0,

    /* U+100 "Ā" */
    0x0, 0x1, 0x11, 0x11, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x14, 0x44, 0x44, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0xe, 0xfd, 0xfb, 0x0, 0x0, 0x4,
    0xff, 0x4f, 0xf1, 0x0, 0x0, 0xaf, 0xb0, 0xef,
    0x60, 0x0, 0xf, 0xf6, 0xa, 0xfc, 0x0, 0x5,
    0xff, 0x10, 0x5f, 0xf2, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x70, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x6,
    0xff, 0x20, 0x0, 0x5f, 0xf2, 0xcf, 0xb0, 0x0,
    0x0, 0xef, 0x80,

    /* U+101 "ā" */
    0x6, 0xff, 0xff, 0xf0, 0x0, 0x25, 0x55, 0x55,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+102 "Ă" */
    0x0, 0x2, 0x0, 0x12, 0x0, 0x0, 0x2, 0xf9,
    0x1b, 0xf0, 0x0, 0x0, 0x8, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xa0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xef, 0xdf, 0xb0, 0x0, 0x0, 0x4f, 0xf4, 0xff,
    0x10, 0x0, 0xa, 0xfb, 0xe, 0xf6, 0x0, 0x0,
    0xff, 0x60, 0xaf, 0xc0, 0x0, 0x5f, 0xf1, 0x5,
    0xff, 0x20, 0xb, 0xff, 0xff, 0xff, 0xf7, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x6f, 0xf2, 0x0,
    0x5, 0xff, 0x2c, 0xfb, 0x0, 0x0, 0xe, 0xf8,

    /* U+103 "ă" */
    0x4, 0xf7, 0x2c, 0xe0, 0x0, 0xa, 0xff, 0xf5,
    0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x19, 0xef,
    0xc5, 0x0, 0xc, 0xfe, 0xdf, 0xf4, 0x3, 0xff,
    0x10, 0xbf, 0x90, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x4c, 0xff, 0xff, 0xb0, 0x2f, 0xf7, 0x4a, 0xfb,
    0x6, 0xfd, 0x0, 0xaf, 0xb0, 0x3f, 0xfe, 0xef,
    0xfb, 0x0, 0x5d, 0xfb, 0x7f, 0xe0,

    /* U+104 "Ą" */
    0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0x0, 0x0, 0x0, 0x9, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0xef, 0x8f, 0xb0, 0x0, 0x0, 0x4f,
    0xd1, 0xff, 0x10, 0x0, 0xa, 0xf7, 0xb, 0xf6,
    0x0, 0x0, 0xff, 0x20, 0x5f, 0xc0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0x20, 0xb, 0xff, 0xff, 0xff,
    0xf7, 0x1, 0xff, 0x30, 0x0, 0x6f, 0xd0, 0x6f,
    0xe0, 0x0, 0x2, 0xff, 0x2c, 0xfa, 0x0, 0x0,
    0xe, 0xf8, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x0,
    0x6, 0xee, 0x10,

    /* U+105 "ą" */
    0x2, 0xae, 0xfc, 0x50, 0x1, 0xef, 0xec, 0xff,
    0x40, 0x16, 0x60, 0x1a, 0xf9, 0x0, 0x3b, 0xff,
    0xff, 0xb0, 0x1e, 0xf9, 0x4a, 0xfb, 0x5, 0xfd,
    0x0, 0x8f, 0xb0, 0x6f, 0xe0, 0xc, 0xfb, 0x2,
    0xff, 0xee, 0xff, 0xc0, 0x4, 0xdf, 0xb8, 0xfd,
    0x0, 0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x2f,
    0xc5, 0x0, 0x0, 0x0, 0xaf, 0xa0,

    /* U+106 "Ć" */
    0x0, 0x0, 0x2, 0x88, 0x0, 0x0, 0x0, 0xc,
    0xf6, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef, 0xe9,
    0x10, 0x1, 0xdf, 0xff, 0xff, 0xd1, 0xa, 0xfe,
    0x30, 0x3e, 0xf8, 0xf, 0xf6, 0x0, 0x8, 0xfd,
    0x3f, 0xf2, 0x0, 0x0, 0x21, 0x4f, 0xf0, 0x0,
    0x0, 0x0, 0x5f, 0xf0, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0x0, 0x11, 0xf, 0xf5, 0x0, 0x8,
    0xfd, 0xa, 0xfd, 0x30, 0x3e, 0xf9, 0x1, 0xef,
    0xff, 0xff, 0xd1, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+107 "ć" */
    0x0, 0x0, 0xaf, 0xa0, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x6, 0x81, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0xa, 0xff, 0xff, 0xf5, 0x2f, 0xf4, 0x8, 0xfc,
    0x6f, 0xd0, 0x1, 0x65, 0x7f, 0xc0, 0x0, 0x0,
    0x6f, 0xd0, 0x0, 0x22, 0x2f, 0xf4, 0x7, 0xfc,
    0xa, 0xff, 0xef, 0xf6, 0x0, 0x8e, 0xfd, 0x60,

    /* U+108 "Ĉ" */
    0x0, 0x0, 0x48, 0x20, 0x0, 0x0, 0x4, 0xff,
    0xd1, 0x0, 0x0, 0x4f, 0xa1, 0xdd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef, 0xe9,
    0x10, 0x1, 0xdf, 0xff, 0xff, 0xd1, 0xa, 0xfe,
    0x30, 0x3e, 0xf8, 0xf, 0xf6, 0x0, 0x8, 0xfd,
    0x3f, 0xf2, 0x0, 0x0, 0x21, 0x4f, 0xf0, 0x0,
    0x0, 0x0, 0x5f, 0xf0, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0x0, 0x11, 0xf, 0xf5, 0x0, 0x8,
    0xfd, 0xa, 0xfd, 0x30, 0x3e, 0xf9, 0x1, 0xef,
    0xff, 0xff, 0xd1, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+109 "ĉ" */
    0x0, 0x3e, 0xf6, 0x0, 0x5, 0xf8, 0x4e, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0xa, 0xff, 0xff, 0xf5, 0x2f, 0xf4, 0x8, 0xfc,
    0x6f, 0xd0, 0x1, 0x65, 0x7f, 0xc0, 0x0, 0x0,
    0x6f, 0xd0, 0x0, 0x22, 0x2f, 0xf4, 0x7, 0xfc,
    0xa, 0xff, 0xef, 0xf6, 0x0, 0x8e, 0xfd, 0x60,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x60, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xef, 0xe9,
    0x10, 0x1, 0xdf, 0xff, 0xff, 0xd1, 0xa, 0xfe,
    0x30, 0x3e, 0xf8, 0xf, 0xf6, 0x0, 0x8, 0xfd,
    0x3f, 0xf2, 0x0, 0x0, 0x21, 0x4f, 0xf0, 0x0,
    0x0, 0x0, 0x5f, 0xf0, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0x0, 0x11, 0xf, 0xf5, 0x0, 0x8,
    0xfd, 0xa, 0xfd, 0x30, 0x3e, 0xf9, 0x1, 0xef,
    0xff, 0xff, 0xd1, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+10B "ċ" */
    0x0, 0xb, 0xe2, 0x0, 0x0, 0xd, 0xf3, 0x0,
    0x0, 0x1, 0x20, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0xa, 0xff, 0xff, 0xf5, 0x2f, 0xf4, 0x8, 0xfc,
    0x6f, 0xd0, 0x1, 0x65, 0x7f, 0xc0, 0x0, 0x0,
    0x6f, 0xd0, 0x0, 0x22, 0x2f, 0xf4, 0x7, 0xfc,
    0xa, 0xff, 0xef, 0xf6, 0x0, 0x8e, 0xfd, 0x60,

    /* U+10C "Č" */
    0x0, 0x24, 0x10, 0x24, 0x10, 0x0, 0x1d, 0xe6,
    0xfb, 0x0, 0x0, 0x2, 0xef, 0xc0, 0x0, 0x0,
    0x0, 0x13, 0x0, 0x0, 0x0, 0x19, 0xef, 0xe9,
    0x10, 0x1, 0xdf, 0xff, 0xff, 0xd1, 0xa, 0xfe,
    0x30, 0x3e, 0xf9, 0xf, 0xf6, 0x0, 0x7, 0xfe,
    0x3f, 0xf2, 0x0, 0x0, 0x0, 0x4f, 0xf0, 0x0,
    0x0, 0x0, 0x5f, 0xf0, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0x0, 0x21, 0xf, 0xf5, 0x0, 0x8,
    0xfd, 0xa, 0xfd, 0x30, 0x4e, 0xf8, 0x1, 0xef,
    0xff, 0xff, 0xd1, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+10D "č" */
    0x5, 0xf8, 0x3f, 0xa0, 0x0, 0x3e, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0xa, 0xff, 0xff, 0xf5, 0x2f, 0xf4, 0x8, 0xfc,
    0x6f, 0xd0, 0x1, 0x65, 0x7f, 0xc0, 0x0, 0x0,
    0x6f, 0xd0, 0x0, 0x22, 0x2f, 0xf4, 0x7, 0xfc,
    0xa, 0xff, 0xef, 0xf6, 0x0, 0x8e, 0xfd, 0x60,

    /* U+10E "Ď" */
    0x7f, 0x74, 0xfb, 0x0, 0x0, 0x8f, 0xfc, 0x0,
    0x0, 0x0, 0x67, 0x0, 0x0, 0xf, 0xff, 0xfd,
    0x91, 0x0, 0xff, 0xff, 0xff, 0xe3, 0xf, 0xf5,
    0x3, 0xcf, 0xd0, 0xff, 0x50, 0x2, 0xff, 0x5f,
    0xf5, 0x0, 0xc, 0xf9, 0xff, 0x50, 0x0, 0xaf,
    0xbf, 0xf5, 0x0, 0xa, 0xfb, 0xff, 0x50, 0x0,
    0xcf, 0x9f, 0xf5, 0x0, 0x2f, 0xf5, 0xff, 0x50,
    0x3c, 0xfd, 0xf, 0xff, 0xff, 0xfe, 0x30, 0xff,
    0xff, 0xe9, 0x20, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x2, 0xff, 0x2a, 0xf0, 0x0, 0x0,
    0x2f, 0xf2, 0xdc, 0x0, 0x0, 0x2, 0xff, 0x3c,
    0x30, 0x1a, 0xfd, 0x7f, 0xf2, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x20, 0x2, 0xff, 0x50, 0x7f, 0xf2,
    0x0, 0x5f, 0xe0, 0x2, 0xff, 0x20, 0x7, 0xfc,
    0x0, 0x2f, 0xf2, 0x0, 0x5f, 0xd0, 0x2, 0xff,
    0x20, 0x2, 0xff, 0x30, 0x5f, 0xf2, 0x0, 0xb,
    0xff, 0xdf, 0xff, 0x20, 0x0, 0x1a, 0xfd, 0x6f,
    0xf2, 0x0,

    /* U+110 "Đ" */
    0x0, 0xcf, 0xff, 0xea, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xcf, 0x90, 0x2a, 0xff,
    0x20, 0xc, 0xf9, 0x0, 0xd, 0xf8, 0x2, 0xcf,
    0xa2, 0x0, 0x8f, 0xd2, 0xff, 0xff, 0xf5, 0x7,
    0xfe, 0x5, 0xdf, 0xb5, 0x10, 0x7f, 0xe0, 0xc,
    0xf9, 0x0, 0x9, 0xfd, 0x0, 0xcf, 0x90, 0x0,
    0xef, 0x90, 0xc, 0xf9, 0x1, 0xaf, 0xf2, 0x0,
    0xcf, 0xff, 0xff, 0xf6, 0x0, 0xc, 0xff, 0xfe,
    0xb3, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x23, 0xff, 0x40, 0x0, 0x1, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x56, 0xff, 0x61, 0x1,
    0xaf, 0xd7, 0xff, 0x20, 0xb, 0xff, 0xff, 0xff,
    0x20, 0x2f, 0xf5, 0x7, 0xff, 0x20, 0x5f, 0xe0,
    0x2, 0xff, 0x20, 0x7f, 0xc0, 0x2, 0xff, 0x20,
    0x5f, 0xd0, 0x2, 0xff, 0x20, 0x2f, 0xf3, 0x5,
    0xff, 0x20, 0xb, 0xff, 0xdf, 0xff, 0x20, 0x1,
    0xaf, 0xd6, 0xff, 0x20,

    /* U+112 "Ē" */
    0x1, 0x11, 0x11, 0x10, 0xb, 0xff, 0xff, 0xa0,
    0x3, 0x44, 0x44, 0x30, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+113 "ē" */
    0x6, 0xff, 0xff, 0xf0, 0x0, 0x25, 0x55, 0x55,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+114 "Ĕ" */
    0x1, 0x20, 0x2, 0x10, 0x9, 0xf3, 0x4f, 0x80,
    0x2, 0xdf, 0xfd, 0x10, 0x0, 0x3, 0x20, 0x0,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xd0,
    0xff, 0xfe, 0xee, 0xc0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xfa,

    /* U+115 "ĕ" */
    0x5, 0xf7, 0x2d, 0xd0, 0x0, 0xb, 0xff, 0xf4,
    0x0, 0x0, 0x2, 0x30, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+116 "Ė" */
    0x0, 0x1d, 0xd0, 0x0, 0x0, 0x1f, 0xf0, 0x0,
    0x0, 0x1, 0x10, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+117 "ė" */
    0x0, 0xa, 0xe3, 0x0, 0x0, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+118 "Ę" */
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xfe, 0xee, 0xc0, 0xff, 0xff, 0xff, 0xd0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x1, 0xea, 0x0, 0x0, 0x6, 0xfa, 0x40,
    0x0, 0x1, 0xdf, 0x70,

    /* U+119 "ę" */
    0x0, 0x6d, 0xfd, 0x70, 0x0, 0x8f, 0xff, 0xff,
    0x70, 0x1f, 0xf5, 0x4, 0xff, 0x5, 0xff, 0x99,
    0x9f, 0xf2, 0x6f, 0xff, 0xff, 0xff, 0x35, 0xff,
    0x0, 0x0, 0x0, 0x1f, 0xfa, 0x11, 0x96, 0x0,
    0x7f, 0xff, 0xff, 0xc0, 0x0, 0x4b, 0xff, 0xa1,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0x2, 0xfc,
    0x60, 0x0, 0x0, 0xa, 0xfa, 0x0,

    /* U+11A "Ě" */
    0xa, 0xf5, 0x6f, 0xa0, 0x0, 0xaf, 0xfa, 0x0,
    0x0, 0x7, 0x70, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xd0, 0xff, 0xfe, 0xee, 0xc0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xfa,

    /* U+11B "ě" */
    0x4, 0xf9, 0x2e, 0xb1, 0x0, 0x2, 0xef, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xd7, 0x0, 0x8, 0xff, 0xff, 0xf7, 0x1, 0xff,
    0x50, 0x4f, 0xf0, 0x5f, 0xf9, 0x99, 0xff, 0x26,
    0xff, 0xff, 0xff, 0xf3, 0x5f, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0x90, 0x8, 0x50, 0x8, 0xff, 0xff,
    0xfd, 0x0, 0x6, 0xdf, 0xea, 0x10,

    /* U+11C "Ĝ" */
    0x0, 0x0, 0x38, 0x20, 0x0, 0x0, 0x0, 0x3f,
    0xfe, 0x20, 0x0, 0x0, 0x3f, 0xb1, 0xcd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xdf, 0xea, 0x20, 0x0, 0x1d, 0xff, 0xff, 0xfe,
    0x10, 0x9, 0xff, 0x40, 0x2e, 0xf9, 0x0, 0xef,
    0x70, 0x0, 0x6f, 0xe0, 0x2f, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x4f,
    0xf2, 0x7, 0xff, 0xff, 0x2, 0xff, 0x30, 0x5d,
    0xdf, 0xf0, 0xe, 0xf8, 0x0, 0x5, 0xff, 0x0,
    0x8f, 0xf5, 0x0, 0x8f, 0xf0, 0x0, 0xdf, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x8d, 0xfe, 0xc6, 0x0,

    /* U+11D "ĝ" */
    0x0, 0x2d, 0xf8, 0x0, 0x0, 0x3e, 0xa3, 0xdb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfe,
    0x7d, 0xf4, 0xa, 0xff, 0xff, 0xff, 0x42, 0xff,
    0x60, 0x4f, 0xf4, 0x5f, 0xe0, 0x0, 0xff, 0x46,
    0xfd, 0x0, 0xf, 0xf4, 0x5f, 0xe0, 0x0, 0xff,
    0x42, 0xff, 0x60, 0x4f, 0xf4, 0xa, 0xff, 0xff,
    0xff, 0x40, 0x9, 0xfe, 0x7f, 0xf3, 0x1, 0x50,
    0x6, 0xff, 0x10, 0xbf, 0xfe, 0xff, 0x90, 0x1,
    0xae, 0xfd, 0x70, 0x0,

    /* U+11E "Ğ" */
    0x0, 0x2, 0x0, 0x12, 0x0, 0x0, 0x2, 0xf9,
    0x1b, 0xf0, 0x0, 0x0, 0x8, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x18,
    0xdf, 0xea, 0x20, 0x0, 0x1d, 0xff, 0xff, 0xfe,
    0x10, 0x9, 0xff, 0x40, 0x2e, 0xf9, 0x0, 0xef,
    0x70, 0x0, 0x6f, 0xe0, 0x2f, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x4f,
    0xf2, 0x7, 0xff, 0xff, 0x2, 0xff, 0x30, 0x5d,
    0xdf, 0xf0, 0xe, 0xf8, 0x0, 0x5, 0xff, 0x0,
    0x8f, 0xf5, 0x0, 0x8f, 0xf0, 0x0, 0xdf, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x8d, 0xfe, 0xc6, 0x0,

    /* U+11F "ğ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x2e, 0xff, 0xfb,
    0x0, 0x0, 0x3, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xe7, 0xdf, 0x40, 0xaf,
    0xff, 0xff, 0xf4, 0x2f, 0xf6, 0x4, 0xff, 0x45,
    0xfe, 0x0, 0xf, 0xf4, 0x6f, 0xd0, 0x0, 0xff,
    0x45, 0xfe, 0x0, 0xf, 0xf4, 0x2f, 0xf6, 0x4,
    0xff, 0x40, 0xaf, 0xff, 0xff, 0xf4, 0x0, 0x9f,
    0xe7, 0xff, 0x30, 0x15, 0x0, 0x6f, 0xf1, 0xb,
    0xff, 0xef, 0xf9, 0x0, 0x1a, 0xef, 0xd7, 0x0,

    /* U+120 "Ġ" */
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xdf, 0xea, 0x20, 0x0, 0x1d, 0xff, 0xff, 0xfe,
    0x10, 0x9, 0xff, 0x40, 0x2e, 0xf9, 0x0, 0xef,
    0x70, 0x0, 0x6f, 0xe0, 0x2f, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x4f,
    0xf2, 0x7, 0xff, 0xff, 0x2, 0xff, 0x30, 0x5d,
    0xdf, 0xf0, 0xe, 0xf8, 0x0, 0x5, 0xff, 0x0,
    0x8f, 0xf5, 0x0, 0x8f, 0xf0, 0x0, 0xdf, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x8d, 0xfe, 0xc6, 0x0,

    /* U+121 "ġ" */
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0xa, 0xfe,
    0x7d, 0xf4, 0xa, 0xff, 0xff, 0xff, 0x42, 0xff,
    0x60, 0x4f, 0xf4, 0x5f, 0xe0, 0x0, 0xff, 0x46,
    0xfd, 0x0, 0xf, 0xf4, 0x5f, 0xe0, 0x0, 0xff,
    0x42, 0xff, 0x60, 0x4f, 0xf4, 0xa, 0xff, 0xff,
    0xff, 0x40, 0x9, 0xfe, 0x7f, 0xf3, 0x1, 0x50,
    0x6, 0xff, 0x10, 0xbf, 0xfe, 0xff, 0x90, 0x1,
    0xae, 0xfd, 0x70, 0x0,

    /* U+122 "Ģ" */
    0x0, 0x18, 0xdf, 0xea, 0x20, 0x0, 0x1d, 0xff,
    0xff, 0xfe, 0x10, 0x9, 0xff, 0x40, 0x2e, 0xf9,
    0x0, 0xef, 0x70, 0x0, 0x6f, 0xe0, 0x2f, 0xf3,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x4f, 0xf2, 0x7, 0xff, 0xff, 0x2, 0xff,
    0x30, 0x5d, 0xdf, 0xf0, 0xe, 0xf8, 0x0, 0x5,
    0xff, 0x0, 0x8f, 0xf5, 0x0, 0x8f, 0xf0, 0x0,
    0xdf, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x8d, 0xfe,
    0xc6, 0x0, 0x0, 0x0, 0x18, 0x40, 0x0, 0x0,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x30, 0x0, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x83, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xe7, 0xdf, 0x40,
    0xaf, 0xff, 0xff, 0xf4, 0x2f, 0xf6, 0x4, 0xff,
    0x45, 0xfe, 0x0, 0xf, 0xf4, 0x6f, 0xd0, 0x0,
    0xff, 0x45, 0xfe, 0x0, 0xf, 0xf4, 0x2f, 0xf6,
    0x4, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xf4, 0x0,
    0x9f, 0xe7, 0xff, 0x30, 0x15, 0x0, 0x6f, 0xf1,
    0xb, 0xff, 0xef, 0xf9, 0x0, 0x1a, 0xef, 0xd7,
    0x0,

    /* U+124 "Ĥ" */
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x1, 0xcd, 0x4b,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f,
    0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50,
    0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff,
    0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50, 0x0, 0x1f,
    0xf4, 0xff, 0x50, 0x0, 0x1f, 0xf4, 0xff, 0x50,
    0x0, 0x1f, 0xf4,

    /* U+125 "ĥ" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0x1b, 0xed, 0xc1,
    0x0, 0x5, 0x71, 0x7, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf1, 0x0, 0x0, 0x3, 0xff,
    0x10, 0x0, 0x0, 0x3f, 0xf1, 0x0, 0x0, 0x3,
    0xff, 0x5d, 0xfb, 0x20, 0x3f, 0xff, 0xff, 0xfb,
    0x3, 0xff, 0x50, 0x6f, 0xf0, 0x3f, 0xf1, 0x2,
    0xff, 0x13, 0xff, 0x10, 0x2f, 0xf2, 0x3f, 0xf1,
    0x2, 0xff, 0x23, 0xff, 0x10, 0x2f, 0xf2, 0x3f,
    0xf1, 0x2, 0xff, 0x23, 0xff, 0x10, 0x2f, 0xf2,

    /* U+126 "Ħ" */
    0xd, 0xf7, 0x0, 0x0, 0xff, 0x60, 0x1d, 0xf8,
    0x11, 0x11, 0xff, 0x70, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x3e, 0xfa, 0x44, 0x44, 0xff, 0x91,
    0xd, 0xf7, 0x0, 0x0, 0xff, 0x60, 0xd, 0xff,
    0xff, 0xff, 0xff, 0x60, 0xd, 0xff, 0xff, 0xff,
    0xff, 0x60, 0xd, 0xf7, 0x0, 0x0, 0xff, 0x60,
    0xd, 0xf7, 0x0, 0x0, 0xff, 0x60, 0xd, 0xf7,
    0x0, 0x0, 0xff, 0x60, 0xd, 0xf7, 0x0, 0x0,
    0xff, 0x60, 0xd, 0xf7, 0x0, 0x0, 0xff, 0x60,

    /* U+127 "ħ" */
    0x2, 0xff, 0x62, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0x0, 0x0, 0x25, 0xff, 0x85, 0x0, 0x0, 0x0,
    0xff, 0x7c, 0xfd, 0x40, 0x0, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0xff, 0x90, 0x2f, 0xf3, 0x0, 0xff,
    0x50, 0xe, 0xf5, 0x0, 0xff, 0x50, 0xe, 0xf5,
    0x0, 0xff, 0x50, 0xe, 0xf5, 0x0, 0xff, 0x50,
    0xe, 0xf5, 0x0, 0xff, 0x50, 0xe, 0xf5, 0x0,
    0xff, 0x50, 0xe, 0xf5,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x2, 0x1, 0xdf, 0x75, 0xf3, 0x7e,
    0x6d, 0xfc, 0x3, 0x30, 0x4, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80,
    0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0,
    0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8, 0x0,

    /* U+129 "ĩ" */
    0x4e, 0xff, 0xfe, 0x5, 0x77, 0x77, 0x20, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff,
    0x50, 0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0,
    0xf, 0xf5, 0x0, 0x0, 0xff, 0x50, 0x0, 0xf,
    0xf5, 0x0,

    /* U+12A "Ī" */
    0x1, 0x11, 0x11, 0x5, 0xff, 0xff, 0xf0, 0x14,
    0x44, 0x44, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80,
    0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0,
    0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0xdf, 0x80, 0x0,

    /* U+12B "ī" */
    0x7f, 0xff, 0xfe, 0x25, 0x55, 0x55, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x50, 0x0, 0xff, 0x50, 0x0,
    0xff, 0x50, 0x0, 0xff, 0x50, 0x0, 0xff, 0x50,
    0x0, 0xff, 0x50, 0x0, 0xff, 0x50, 0x0, 0xff,
    0x50, 0x0, 0xff, 0x50,

    /* U+12C "Ĭ" */
    0x2, 0x0, 0x12, 0x3, 0xf8, 0x2c, 0xe0, 0x9,
    0xff, 0xf5, 0x0, 0x2, 0x31, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80,
    0x0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0,
    0xd, 0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0xdf, 0x80, 0x0, 0xd, 0xf8, 0x0,

    /* U+12D "ĭ" */
    0x6f, 0x62, 0xdc, 0xc, 0xff, 0xe4, 0x0, 0x23,
    0x0, 0x0, 0xff, 0x50, 0x0, 0xff, 0x50, 0x0,
    0xff, 0x50, 0x0, 0xff, 0x50, 0x0, 0xff, 0x50,
    0x0, 0xff, 0x50, 0x0, 0xff, 0x50, 0x0, 0xff,
    0x50, 0x0, 0xff, 0x50,

    /* U+12E "Į" */
    0xd, 0xf8, 0xd, 0xf8, 0xd, 0xf8, 0xd, 0xf8,
    0xd, 0xf8, 0xd, 0xf8, 0xd, 0xf8, 0xd, 0xf8,
    0xd, 0xf8, 0xd, 0xf8, 0xd, 0xf8, 0xf, 0xf8,
    0x7f, 0x40, 0xcf, 0x80, 0x5e, 0xe2,

    /* U+12F "į" */
    0xc, 0xe2, 0x1f, 0xf4, 0x4, 0x50, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0x9e, 0x20, 0xee, 0x70, 0x7f, 0xd0,

    /* U+130 "İ" */
    0x9f, 0x4b, 0xf5, 0x2, 0xd, 0xf8, 0xdf, 0x8d,
    0xf8, 0xdf, 0x8d, 0xf8, 0xdf, 0x8d, 0xf8, 0xdf,
    0x8d, 0xf8, 0xdf, 0x8d, 0xf8, 0xdf, 0x80,

    /* U+131 "ı" */
    0xff, 0x5f, 0xf5, 0xff, 0x5f, 0xf5, 0xff, 0x5f,
    0xf5, 0xff, 0x5f, 0xf5, 0xff, 0x50,

    /* U+132 "Ĳ" */
    0xdf, 0x80, 0x0, 0x0, 0xb, 0xf9, 0xdf, 0x80,
    0x0, 0x0, 0xb, 0xf9, 0xdf, 0x80, 0x0, 0x0,
    0xb, 0xf9, 0xdf, 0x80, 0x0, 0x0, 0xb, 0xf9,
    0xdf, 0x80, 0x0, 0x0, 0xb, 0xf9, 0xdf, 0x80,
    0x0, 0x0, 0xb, 0xf9, 0xdf, 0x80, 0x0, 0x0,
    0xb, 0xf9, 0xdf, 0x80, 0x0, 0x0, 0xb, 0xf9,
    0xdf, 0x80, 0x88, 0x30, 0xc, 0xf9, 0xdf, 0x80,
    0xdf, 0x90, 0x1f, 0xf6, 0xdf, 0x80, 0x6f, 0xfd,
    0xff, 0xd0, 0xdf, 0x80, 0x6, 0xcf, 0xea, 0x10,

    /* U+133 "ĳ" */
    0xc, 0xe2, 0xa, 0xf4, 0x1f, 0xf4, 0xd, 0xf8,
    0x4, 0x50, 0x2, 0x60, 0xf, 0xf4, 0xc, 0xf8,
    0xf, 0xf4, 0xc, 0xf8, 0xf, 0xf4, 0xc, 0xf8,
    0xf, 0xf4, 0xc, 0xf8, 0xf, 0xf4, 0xc, 0xf8,
    0xf, 0xf4, 0xc, 0xf8, 0xf, 0xf4, 0xc, 0xf8,
    0xf, 0xf4, 0xc, 0xf8, 0xf, 0xf4, 0xc, 0xf8,
    0x0, 0x0, 0xe, 0xf6, 0x0, 0x7, 0xff, 0xf2,
    0x0, 0x7, 0xfd, 0x50,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0x9, 0xfc, 0x10, 0x0, 0x1, 0xce,
    0x4b, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff, 0x0,
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x0, 0x0, 0x0, 0x6, 0xff, 0x0, 0x6a,
    0x70, 0x6, 0xfe, 0x0, 0x8f, 0xe1, 0x1c, 0xfb,
    0x0, 0x1f, 0xff, 0xff, 0xf3, 0x0, 0x2, 0xbe,
    0xfc, 0x40, 0x0,

    /* U+135 "ĵ" */
    0x3, 0xef, 0x60, 0x5, 0xf9, 0x5f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf7, 0x0, 0x0, 0xdf,
    0x70, 0x0, 0xd, 0xf7, 0x0, 0x0, 0xdf, 0x70,
    0x0, 0xd, 0xf7, 0x0, 0x0, 0xdf, 0x70, 0x0,
    0xd, 0xf7, 0x0, 0x0, 0xdf, 0x70, 0x0, 0xd,
    0xf6, 0x0, 0x0, 0xff, 0x50, 0x8, 0xff, 0xf1,
    0x0, 0x9f, 0xc4, 0x0, 0x0,

    /* U+136 "Ķ" */
    0xff, 0x50, 0x2, 0xff, 0xc0, 0xff, 0x50, 0xc,
    0xfe, 0x10, 0xff, 0x50, 0x8f, 0xf4, 0x0, 0xff,
    0x54, 0xff, 0x80, 0x0, 0xff, 0x7e, 0xfc, 0x0,
    0x0, 0xff, 0xef, 0xf5, 0x0, 0x0, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xf8, 0xff, 0x70, 0x0,
    0xff, 0x80, 0xaf, 0xf2, 0x0, 0xff, 0x50, 0x1e,
    0xfb, 0x0, 0xff, 0x50, 0x6, 0xff, 0x50, 0xff,
    0x50, 0x0, 0xcf, 0xe1, 0x0, 0xb, 0xe0, 0x0,
    0x0, 0x0, 0xd, 0xc0, 0x0, 0x0, 0x0, 0x2f,
    0x60, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x20, 0x0,
    0x0, 0x2f, 0xf2, 0x0, 0x0, 0x2, 0xff, 0x20,
    0xaf, 0xe1, 0x2f, 0xf2, 0x7f, 0xf3, 0x2, 0xff,
    0x6f, 0xf6, 0x0, 0x2f, 0xff, 0xfa, 0x0, 0x2,
    0xff, 0xff, 0xd0, 0x0, 0x2f, 0xfc, 0xef, 0x70,
    0x2, 0xff, 0x26, 0xff, 0x20, 0x2f, 0xf2, 0xc,
    0xfb, 0x2, 0xff, 0x20, 0x3f, 0xf6, 0x0, 0x3,
    0x82, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x97, 0x0, 0x0,

    /* U+138 "ĸ" */
    0xff, 0x40, 0x2f, 0xfb, 0xf, 0xf4, 0xb, 0xff,
    0x10, 0xff, 0x45, 0xff, 0x60, 0xf, 0xf7, 0xdf,
    0xc0, 0x0, 0xff, 0xff, 0xf3, 0x0, 0xf, 0xff,
    0xff, 0xa0, 0x0, 0xff, 0x47, 0xff, 0x50, 0xf,
    0xf4, 0xc, 0xff, 0x20, 0xff, 0x40, 0x2f, 0xfc,
    0x0,

    /* U+139 "Ĺ" */
    0x9, 0xfb, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0,
    0x58, 0x10, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xf5,

    /* U+13A "ĺ" */
    0x0, 0x48, 0x60, 0x1, 0xff, 0x30, 0xa, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf4, 0x0, 0xf,
    0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0,
    0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4,
    0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf,
    0xf4, 0x0, 0xf, 0xf4, 0x0, 0xf, 0xf4, 0x0,

    /* U+13B "Ļ" */
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x8, 0x40, 0x0, 0x0, 0x2f, 0x70, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x5a, 0x0, 0x0,

    /* U+13C "ļ" */
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4, 0xf, 0xf4,
    0x5, 0x70, 0xb, 0xe0, 0xe, 0xa0, 0x1b, 0x30,

    /* U+13D "Ľ" */
    0xff, 0x50, 0x9f, 0x10, 0xff, 0x50, 0xaf, 0x0,
    0xff, 0x50, 0xf9, 0x0, 0xff, 0x50, 0x31, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5,

    /* U+13E "ľ" */
    0xf, 0xf4, 0x8f, 0x10, 0xff, 0x4a, 0xf0, 0xf,
    0xf4, 0xe8, 0x0, 0xff, 0x41, 0x0, 0xf, 0xf4,
    0x0, 0x0, 0xff, 0x40, 0x0, 0xf, 0xf4, 0x0,
    0x0, 0xff, 0x40, 0x0, 0xf, 0xf4, 0x0, 0x0,
    0xff, 0x40, 0x0, 0xf, 0xf4, 0x0, 0x0, 0xff,
    0x40, 0x0,

    /* U+13F "Ŀ" */
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x52, 0xea, 0x0, 0xff, 0x54, 0xfd, 0x0,
    0xff, 0x50, 0x21, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xff, 0x50, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5,

    /* U+140 "ŀ" */
    0xf, 0xf4, 0x0, 0x0, 0xff, 0x40, 0x0, 0xf,
    0xf4, 0x0, 0x0, 0xff, 0x40, 0x0, 0xf, 0xf4,
    0x12, 0x0, 0xff, 0x4d, 0xf3, 0xf, 0xf4, 0xbe,
    0x20, 0xff, 0x40, 0x0, 0xf, 0xf4, 0x0, 0x0,
    0xff, 0x40, 0x0, 0xf, 0xf4, 0x0, 0x0, 0xff,
    0x40, 0x0,

    /* U+141 "Ł" */
    0xb, 0xfa, 0x0, 0x0, 0x0, 0xbf, 0xa0, 0x0,
    0x0, 0xb, 0xfa, 0x0, 0x0, 0x0, 0xbf, 0xa0,
    0x0, 0x0, 0xb, 0xfc, 0xa3, 0x0, 0x5, 0xef,
    0xfb, 0x20, 0x0, 0xbe, 0xfa, 0x0, 0x0, 0x0,
    0xbf, 0xa0, 0x0, 0x0, 0xb, 0xfa, 0x0, 0x0,
    0x0, 0xbf, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x90, 0xbf, 0xff, 0xff, 0xf9,

    /* U+142 "ł" */
    0xb, 0xf8, 0x0, 0xbf, 0x80, 0xb, 0xf8, 0x0,
    0xbf, 0x80, 0xb, 0xf9, 0x31, 0xdf, 0xf9, 0xcf,
    0xf9, 0x1, 0xbf, 0x80, 0xb, 0xf8, 0x0, 0xbf,
    0x80, 0xb, 0xf8, 0x0, 0xbf, 0x80,

    /* U+143 "Ń" */
    0x0, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x2, 0x85, 0x0, 0x0, 0xff,
    0xa0, 0x0, 0x1f, 0xf4, 0xff, 0xf3, 0x0, 0x1f,
    0xf4, 0xff, 0xfc, 0x0, 0x1f, 0xf4, 0xff, 0xff,
    0x60, 0x1f, 0xf4, 0xff, 0xcf, 0xe0, 0x1f, 0xf4,
    0xff, 0x5d, 0xf8, 0x1f, 0xf4, 0xff, 0x54, 0xff,
    0x3f, 0xf4, 0xff, 0x50, 0xaf, 0xcf, 0xf4, 0xff,
    0x50, 0x2f, 0xff, 0xf4, 0xff, 0x50, 0x8, 0xff,
    0xf4, 0xff, 0x50, 0x0, 0xef, 0xf4, 0xff, 0x50,
    0x0, 0x5f, 0xf4,

    /* U+144 "ń" */
    0x0, 0x0, 0x5f, 0xe1, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x3, 0x84, 0x0, 0x2, 0xff, 0x4d,
    0xfc, 0x20, 0x2f, 0xff, 0xff, 0xfc, 0x2, 0xff,
    0x60, 0x6f, 0xf0, 0x2f, 0xf1, 0x2, 0xff, 0x12,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x22, 0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2,
    0xff, 0x22, 0xff, 0x10, 0x2f, 0xf2,

    /* U+145 "Ņ" */
    0xff, 0xa0, 0x0, 0x1f, 0xf4, 0xff, 0xf3, 0x0,
    0x1f, 0xf4, 0xff, 0xfc, 0x0, 0x1f, 0xf4, 0xff,
    0xff, 0x60, 0x1f, 0xf4, 0xff, 0xcf, 0xe0, 0x1f,
    0xf4, 0xff, 0x5d, 0xf8, 0x1f, 0xf4, 0xff, 0x54,
    0xff, 0x3f, 0xf4, 0xff, 0x50, 0xaf, 0xcf, 0xf4,
    0xff, 0x50, 0x2f, 0xff, 0xf4, 0xff, 0x50, 0x8,
    0xff, 0xf4, 0xff, 0x50, 0x0, 0xef, 0xf4, 0xff,
    0x50, 0x0, 0x5f, 0xf4, 0x0, 0x1, 0x84, 0x0,
    0x0, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x0, 0x6, 0xa0, 0x0, 0x0,

    /* U+146 "ņ" */
    0x2f, 0xf4, 0xdf, 0xc2, 0x2, 0xff, 0xff, 0xff,
    0xc0, 0x2f, 0xf6, 0x6, 0xff, 0x2, 0xff, 0x10,
    0x2f, 0xf1, 0x2f, 0xf1, 0x2, 0xff, 0x22, 0xff,
    0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff, 0x22,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x20, 0x0, 0x28, 0x20, 0x0, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x8,
    0x70, 0x0, 0x0,

    /* U+147 "Ň" */
    0x1, 0xde, 0x2a, 0xf5, 0x0, 0x0, 0x1e, 0xff,
    0x50, 0x0, 0x0, 0x2, 0x85, 0x0, 0x0, 0xff,
    0xa0, 0x0, 0x1f, 0xf4, 0xff, 0xf3, 0x0, 0x1f,
    0xf4, 0xff, 0xfc, 0x0, 0x1f, 0xf4, 0xff, 0xff,
    0x60, 0x1f, 0xf4, 0xff, 0xcf, 0xe0, 0x1f, 0xf4,
    0xff, 0x5d, 0xf8, 0x1f, 0xf4, 0xff, 0x54, 0xff,
    0x3f, 0xf4, 0xff, 0x50, 0xaf, 0xcf, 0xf4, 0xff,
    0x50, 0x2f, 0xff, 0xf4, 0xff, 0x50, 0x8, 0xff,
    0xf4, 0xff, 0x50, 0x0, 0xef, 0xf4, 0xff, 0x50,
    0x0, 0x5f, 0xf4,

    /* U+148 "ň" */
    0x2, 0xdc, 0x1c, 0xd2, 0x0, 0x1, 0xcf, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x4d,
    0xfc, 0x20, 0x2f, 0xff, 0xff, 0xfc, 0x2, 0xff,
    0x60, 0x6f, 0xf0, 0x2f, 0xf1, 0x2, 0xff, 0x12,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x22, 0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2,
    0xff, 0x22, 0xff, 0x10, 0x2f, 0xf2,

    /* U+149 "ŉ" */
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x89, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x4d, 0xfc, 0x20, 0x2, 0xff, 0xff, 0xff,
    0xc0, 0x2, 0xff, 0x60, 0x6f, 0xf0, 0x2, 0xff,
    0x10, 0x2f, 0xf1, 0x2, 0xff, 0x10, 0x2f, 0xf2,
    0x2, 0xff, 0x10, 0x2f, 0xf2, 0x2, 0xff, 0x10,
    0x2f, 0xf2, 0x2, 0xff, 0x10, 0x2f, 0xf2, 0x2,
    0xff, 0x10, 0x2f, 0xf2,

    /* U+14A "Ŋ" */
    0xff, 0xa0, 0x0, 0x1f, 0xf4, 0xff, 0xf3, 0x0,
    0x1f, 0xf4, 0xff, 0xfc, 0x0, 0x1f, 0xf4, 0xff,
    0xff, 0x50, 0x1f, 0xf4, 0xff, 0xaf, 0xd0, 0x1f,
    0xf4, 0xff, 0x5c, 0xf7, 0x1f, 0xf4, 0xff, 0x53,
    0xff, 0x2f, 0xf4, 0xff, 0x50, 0xaf, 0xaf, 0xf4,
    0xff, 0x50, 0x1f, 0xff, 0xf4, 0xff, 0x50, 0x8,
    0xff, 0xf4, 0xff, 0x50, 0x0, 0xef, 0xf4, 0xff,
    0x50, 0x0, 0x6f, 0xf3, 0x0, 0x0, 0x0, 0x4f,
    0xf2, 0x0, 0x0, 0xd, 0xff, 0xd0, 0x0, 0x0,
    0xd, 0xfb, 0x20,

    /* U+14B "ŋ" */
    0x2f, 0xf3, 0xcf, 0xc2, 0x2, 0xff, 0xef, 0xff,
    0xc0, 0x2f, 0xf5, 0x5, 0xff, 0x12, 0xff, 0x10,
    0x1f, 0xf2, 0x2f, 0xf1, 0x1, 0xff, 0x32, 0xff,
    0x10, 0x1f, 0xf3, 0x2f, 0xf1, 0x1, 0xff, 0x32,
    0xff, 0x10, 0x1f, 0xf3, 0x2f, 0xf1, 0x1, 0xff,
    0x20, 0x0, 0x0, 0x4f, 0xf1, 0x0, 0x0, 0xcf,
    0xfc, 0x0, 0x0, 0xc, 0xfb, 0x20,

    /* U+14C "Ō" */
    0x0, 0x1, 0x11, 0x11, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x4, 0x44, 0x44, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+14D "ō" */
    0x2, 0xff, 0xff, 0xf3, 0x0, 0x5, 0x55, 0x55,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0x2, 0x10, 0x12, 0x0, 0x0, 0x0, 0xfa,
    0x1a, 0xf1, 0x0, 0x0, 0x7, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0x31, 0x0, 0x0, 0x0, 0x8,
    0xdf, 0xd8, 0x10, 0x0, 0xd, 0xff, 0xff, 0xfd,
    0x10, 0x9, 0xff, 0x51, 0x4e, 0xf9, 0x0, 0xff,
    0x70, 0x0, 0x7f, 0xf0, 0x3f, 0xf2, 0x0, 0x2,
    0xff, 0x34, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x4f,
    0xf1, 0x0, 0x0, 0xff, 0x53, 0xff, 0x20, 0x0,
    0x2f, 0xf3, 0xf, 0xf7, 0x0, 0x6, 0xff, 0x0,
    0x9f, 0xf5, 0x4, 0xef, 0x90, 0x0, 0xdf, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0,

    /* U+14F "ŏ" */
    0x1, 0xfa, 0x2a, 0xf1, 0x0, 0x8, 0xff, 0xf8,
    0x0, 0x0, 0x1, 0x31, 0x0, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+150 "Ő" */
    0x0, 0x0, 0xbf, 0x3b, 0xf4, 0x0, 0x0, 0x4f,
    0x76, 0xf6, 0x0, 0x0, 0x5, 0x60, 0x65, 0x0,
    0x0, 0x0, 0x8d, 0xfd, 0x81, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf5, 0x14, 0xef,
    0x90, 0xf, 0xf7, 0x0, 0x7, 0xff, 0x3, 0xff,
    0x20, 0x0, 0x2f, 0xf3, 0x4f, 0xf1, 0x0, 0x0,
    0xff, 0x54, 0xff, 0x10, 0x0, 0xf, 0xf5, 0x3f,
    0xf2, 0x0, 0x2, 0xff, 0x30, 0xff, 0x70, 0x0,
    0x6f, 0xf0, 0x9, 0xff, 0x50, 0x4e, 0xf9, 0x0,
    0xd, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x8, 0xdf,
    0xd8, 0x10, 0x0,

    /* U+151 "ő" */
    0x0, 0xb, 0xf3, 0xbf, 0x40, 0x5, 0xf7, 0x7f,
    0x60, 0x0, 0x56, 0x6, 0x50, 0x0, 0x7, 0xdf,
    0xd7, 0x0, 0x9, 0xff, 0xff, 0xf9, 0x2, 0xff,
    0x60, 0x5f, 0xf2, 0x6f, 0xe0, 0x0, 0xdf, 0x67,
    0xfc, 0x0, 0xc, 0xf8, 0x6f, 0xe0, 0x0, 0xdf,
    0x72, 0xff, 0x50, 0x5f, 0xf3, 0x9, 0xff, 0xff,
    0xfa, 0x0, 0x7, 0xdf, 0xe8, 0x0,

    /* U+152 "Œ" */
    0x0, 0x19, 0xef, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb,
    0xfe, 0x52, 0xf, 0xf7, 0x22, 0x22, 0x11, 0xff,
    0x40, 0x0, 0xff, 0x60, 0x0, 0x0, 0x3f, 0xf1,
    0x0, 0xf, 0xf6, 0x0, 0x0, 0x4, 0xff, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xe0, 0x4f, 0xf0, 0x0,
    0xf, 0xff, 0xee, 0xec, 0x3, 0xff, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x1f, 0xf3, 0x0, 0xf,
    0xf6, 0x0, 0x0, 0x0, 0xbf, 0xd3, 0x0, 0xff,
    0x60, 0x0, 0x0, 0x2, 0xef, 0xff, 0xef, 0xff,
    0xff, 0xff, 0xa0, 0x1, 0x9e, 0xff, 0xff, 0xff,
    0xff, 0xfa,

    /* U+153 "œ" */
    0x0, 0x5d, 0xfe, 0x81, 0x8e, 0xfc, 0x40, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf, 0xf7,
    0x3, 0xff, 0xf3, 0xa, 0xfa, 0x4f, 0xf0, 0x0,
    0xcf, 0xe9, 0x9c, 0xfc, 0x5f, 0xe0, 0x0, 0xaf,
    0xff, 0xff, 0xfd, 0x4f, 0xf0, 0x0, 0xcf, 0xd0,
    0x0, 0x0, 0xf, 0xf7, 0x3, 0xff, 0xf6, 0x0,
    0x41, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x6d, 0xfe, 0x81, 0x8e, 0xfe, 0x92,

    /* U+154 "Ŕ" */
    0x0, 0x3, 0xff, 0x30, 0x0, 0x0, 0xcf, 0x50,
    0x0, 0x0, 0x28, 0x50, 0x0, 0xf, 0xff, 0xff,
    0xd7, 0x0, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf5,
    0x0, 0x7f, 0xf4, 0xff, 0x50, 0x0, 0xff, 0x6f,
    0xf5, 0x0, 0xf, 0xf6, 0xff, 0x50, 0x8, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0x70, 0xff, 0xff, 0xff,
    0x90, 0xf, 0xf5, 0x7, 0xff, 0x10, 0xff, 0x50,
    0xe, 0xf8, 0xf, 0xf5, 0x0, 0x6f, 0xf1, 0xff,
    0x50, 0x0, 0xef, 0x90,

    /* U+155 "ŕ" */
    0x0, 0xa, 0xfa, 0x0, 0x4, 0xfc, 0x0, 0x0,
    0x68, 0x10, 0x2, 0xff, 0x7e, 0xa0, 0x2f, 0xff,
    0xfa, 0x2, 0xff, 0xa3, 0x10, 0x2f, 0xf2, 0x0,
    0x2, 0xff, 0x20, 0x0, 0x2f, 0xf2, 0x0, 0x2,
    0xff, 0x20, 0x0, 0x2f, 0xf2, 0x0, 0x2, 0xff,
    0x20, 0x0,

    /* U+156 "Ŗ" */
    0xff, 0xff, 0xfd, 0x70, 0xf, 0xff, 0xff, 0xff,
    0xc0, 0xff, 0x50, 0x7, 0xff, 0x4f, 0xf5, 0x0,
    0xf, 0xf6, 0xff, 0x50, 0x0, 0xff, 0x6f, 0xf5,
    0x0, 0x8f, 0xf2, 0xff, 0xff, 0xff, 0xf7, 0xf,
    0xff, 0xff, 0xf9, 0x0, 0xff, 0x50, 0x7f, 0xf1,
    0xf, 0xf5, 0x0, 0xef, 0x80, 0xff, 0x50, 0x6,
    0xff, 0x1f, 0xf5, 0x0, 0xe, 0xf9, 0x0, 0x8,
    0x50, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x4, 0xb0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x0, 0x2f, 0xf7, 0xea, 0x2f, 0xff,
    0xfa, 0x2f, 0xfa, 0x31, 0x2f, 0xf2, 0x0, 0x2f,
    0xf2, 0x0, 0x2f, 0xf2, 0x0, 0x2f, 0xf2, 0x0,
    0x2f, 0xf2, 0x0, 0x2f, 0xf2, 0x0, 0x6, 0x70,
    0x0, 0xd, 0xd0, 0x0, 0xf, 0x90, 0x0, 0x2c,
    0x20, 0x0,

    /* U+158 "Ř" */
    0x1d, 0xe2, 0xaf, 0x50, 0x0, 0x1e, 0xff, 0x50,
    0x0, 0x0, 0x28, 0x50, 0x0, 0xf, 0xff, 0xff,
    0xd7, 0x0, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf5,
    0x0, 0x7f, 0xf4, 0xff, 0x50, 0x0, 0xff, 0x6f,
    0xf5, 0x0, 0xf, 0xf6, 0xff, 0x50, 0x8, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0x70, 0xff, 0xff, 0xff,
    0x90, 0xf, 0xf5, 0x7, 0xff, 0x10, 0xff, 0x50,
    0xe, 0xf8, 0xf, 0xf5, 0x0, 0x6f, 0xf1, 0xff,
    0x50, 0x0, 0xef, 0x90,

    /* U+159 "ř" */
    0x4f, 0x83, 0xea, 0x0, 0x2d, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x7e, 0xa0, 0x2f, 0xff,
    0xfa, 0x2, 0xff, 0xa3, 0x10, 0x2f, 0xf2, 0x0,
    0x2, 0xff, 0x20, 0x0, 0x2f, 0xf2, 0x0, 0x2,
    0xff, 0x20, 0x0, 0x2f, 0xf2, 0x0, 0x2, 0xff,
    0x20, 0x0,

    /* U+15A "Ś" */
    0x0, 0x0, 0xc, 0xf8, 0x0, 0x0, 0x0, 0x6f,
    0xa0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xc6, 0x0, 0x7, 0xff, 0xff, 0xff,
    0x80, 0xf, 0xf9, 0x0, 0x8f, 0xf1, 0x1f, 0xf5,
    0x0, 0x1a, 0xa2, 0xc, 0xfe, 0x60, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xa2, 0x0, 0x0, 0x7, 0xdf,
    0xff, 0x40, 0x0, 0x0, 0x3, 0xcf, 0xe0, 0x5d,
    0xc0, 0x0, 0x2f, 0xf3, 0x2f, 0xf7, 0x0, 0x6f,
    0xf2, 0x9, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x5c,
    0xff, 0xd7, 0x0,

    /* U+15B "ś" */
    0x0, 0x0, 0xbf, 0x90, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0x6, 0x81, 0x0, 0x2, 0xae, 0xfc, 0x40,
    0xd, 0xfd, 0xcf, 0xf3, 0x3f, 0xf0, 0xa, 0xd7,
    0x1f, 0xfa, 0x51, 0x0, 0x5, 0xef, 0xff, 0x90,
    0x0, 0x4, 0x8f, 0xf7, 0x7f, 0xb0, 0xa, 0xf9,
    0x2f, 0xfc, 0xbf, 0xf4, 0x3, 0xbf, 0xfc, 0x50,

    /* U+15C "Ŝ" */
    0x0, 0x4, 0xef, 0x50, 0x0, 0x0, 0x7f, 0x76,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xc6, 0x0, 0x7, 0xff, 0xff, 0xff,
    0x80, 0xf, 0xf9, 0x0, 0x8f, 0xf1, 0x1f, 0xf5,
    0x0, 0x1a, 0xa2, 0xc, 0xfe, 0x60, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xa2, 0x0, 0x0, 0x7, 0xdf,
    0xff, 0x40, 0x0, 0x0, 0x3, 0xcf, 0xe0, 0x5d,
    0xc0, 0x0, 0x2f, 0xf3, 0x2f, 0xf7, 0x0, 0x6f,
    0xf2, 0x9, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x5c,
    0xff, 0xd7, 0x0,

    /* U+15D "ŝ" */
    0x0, 0x3e, 0xf6, 0x0, 0x5, 0xf8, 0x5e, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xae, 0xfc, 0x40,
    0xd, 0xfd, 0xcf, 0xf3, 0x3f, 0xf0, 0xa, 0xd7,
    0x1f, 0xfa, 0x51, 0x0, 0x5, 0xef, 0xff, 0x90,
    0x0, 0x4, 0x8f, 0xf7, 0x7f, 0xb0, 0xa, 0xf9,
    0x2f, 0xfc, 0xbf, 0xf4, 0x3, 0xbf, 0xfc, 0x50,

    /* U+15E "Ş" */
    0x0, 0x5c, 0xff, 0xc6, 0x0, 0x7, 0xff, 0xff,
    0xff, 0x80, 0xf, 0xf9, 0x0, 0x8f, 0xf1, 0x1f,
    0xf5, 0x0, 0x1a, 0xa2, 0xc, 0xfe, 0x60, 0x0,
    0x0, 0x2, 0xdf, 0xff, 0xa2, 0x0, 0x0, 0x7,
    0xdf, 0xff, 0x40, 0x0, 0x0, 0x3, 0xcf, 0xe0,
    0x5d, 0xc0, 0x0, 0x2f, 0xf3, 0x2f, 0xf7, 0x0,
    0x6f, 0xf2, 0x9, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x5c, 0xff, 0xd7, 0x0, 0x0, 0x0, 0xef, 0x70,
    0x0, 0x0, 0x0, 0x5f, 0xf0, 0x0, 0x0, 0x0,
    0xbd, 0x60, 0x0,

    /* U+15F "ş" */
    0x2, 0xae, 0xfc, 0x40, 0xd, 0xfd, 0xcf, 0xf3,
    0x3f, 0xf0, 0xa, 0xd7, 0x1f, 0xfa, 0x51, 0x0,
    0x5, 0xef, 0xff, 0x90, 0x0, 0x4, 0x9f, 0xf7,
    0x7e, 0xa0, 0x9, 0xf9, 0x2f, 0xfc, 0xbf, 0xf4,
    0x3, 0xbf, 0xfc, 0x50, 0x0, 0xc, 0xf7, 0x0,
    0x0, 0x5, 0xff, 0x0, 0x0, 0xa, 0xd6, 0x0,

    /* U+160 "Š" */
    0x0, 0x8f, 0x64, 0xfa, 0x0, 0x0, 0x8, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x45, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xc5, 0x0, 0x7, 0xff, 0xff, 0xff,
    0x70, 0xf, 0xf9, 0x0, 0x9f, 0xf1, 0x1f, 0xf5,
    0x0, 0x1b, 0xb2, 0xc, 0xfe, 0x60, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xa2, 0x0, 0x0, 0x7, 0xdf,
    0xff, 0x40, 0x0, 0x0, 0x3, 0xcf, 0xe0, 0x5d,
    0xc0, 0x0, 0x2f, 0xf3, 0x2f, 0xf7, 0x0, 0x6f,
    0xf2, 0x9, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x5c,
    0xff, 0xd7, 0x0,

    /* U+161 "š" */
    0x6, 0xf7, 0x4f, 0xa0, 0x0, 0x4e, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xae, 0xfc, 0x40,
    0xd, 0xfd, 0xcf, 0xf3, 0x3f, 0xf0, 0xa, 0xd7,
    0x1f, 0xfa, 0x51, 0x0, 0x5, 0xef, 0xff, 0x90,
    0x0, 0x4, 0x8f, 0xf7, 0x7f, 0xb0, 0xa, 0xf9,
    0x2f, 0xfc, 0xbf, 0xf4, 0x3, 0xbf, 0xfc, 0x50,

    /* U+162 "Ţ" */
    0xbf, 0xff, 0xff, 0xff, 0xf9, 0xaf, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10,
    0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x0, 0xfe, 0x40,
    0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x0, 0x0,
    0xdd, 0x40, 0x0,

    /* U+163 "ţ" */
    0xb, 0xf9, 0x0, 0xb, 0xf9, 0x0, 0xb, 0xf9,
    0x0, 0xef, 0xff, 0xf0, 0xae, 0xfe, 0xb0, 0xb,
    0xf9, 0x0, 0xb, 0xf9, 0x0, 0xb, 0xf9, 0x0,
    0xb, 0xf9, 0x0, 0xa, 0xfa, 0x0, 0x7, 0xff,
    0xf1, 0x1, 0xcf, 0xf1, 0x0, 0x9f, 0xa1, 0x0,
    0x2d, 0xf4, 0x0, 0x6e, 0x90,

    /* U+164 "Ť" */
    0x0, 0xaf, 0x47, 0xf9, 0x0, 0x0, 0xb, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf9, 0xaf, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10,
    0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0,

    /* U+165 "ť" */
    0x0, 0x0, 0xf, 0xa0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x5f, 0x40, 0xbf, 0x93, 0x90, 0xb, 0xf9,
    0x0, 0xe, 0xff, 0xff, 0x0, 0xae, 0xfe, 0xb0,
    0x0, 0xbf, 0x90, 0x0, 0xb, 0xf9, 0x0, 0x0,
    0xbf, 0x90, 0x0, 0xb, 0xf9, 0x0, 0x0, 0xaf,
    0xa0, 0x0, 0x7, 0xff, 0xf1, 0x0, 0x1b, 0xfe,
    0x10,

    /* U+166 "Ŧ" */
    0xbf, 0xff, 0xff, 0xff, 0xf9, 0xaf, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x7a, 0xff, 0x84,
    0x0, 0x0, 0xef, 0xff, 0xf8, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0,

    /* U+167 "ŧ" */
    0x0, 0xbf, 0x90, 0x0, 0xb, 0xf9, 0x0, 0xe,
    0xff, 0xff, 0x0, 0xae, 0xfe, 0xb0, 0x0, 0xbf,
    0x90, 0x3, 0xff, 0xff, 0xf3, 0x18, 0xdf, 0xc8,
    0x10, 0xb, 0xf9, 0x0, 0x0, 0xaf, 0xa0, 0x0,
    0x7, 0xff, 0xf1, 0x0, 0x1b, 0xfe, 0x10,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2e, 0xf6,
    0x6f, 0x10, 0x0, 0x9e, 0x6e, 0xfa, 0x0, 0x0,
    0x33, 0x1, 0x40, 0x0, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f,
    0xf4, 0x0, 0xb, 0xf9, 0xf, 0xf5, 0x0, 0xd,
    0xf8, 0xc, 0xfc, 0x20, 0x5f, 0xf5, 0x3, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x3b, 0xff, 0xd8, 0x0,

    /* U+169 "ũ" */
    0x1, 0xcf, 0xff, 0xf3, 0x0, 0x37, 0x77, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+16A "Ū" */
    0x0, 0x1, 0x11, 0x11, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0x0, 0x0, 0x14, 0x44, 0x44, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+16B "ū" */
    0x3, 0xff, 0xff, 0xf3, 0x0, 0x15, 0x55, 0x55,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+16C "Ŭ" */
    0x0, 0x12, 0x0, 0x12, 0x0, 0x0, 0x5f, 0x72,
    0xdd, 0x0, 0x0, 0xb, 0xff, 0xe4, 0x0, 0x0,
    0x0, 0x23, 0x0, 0x0, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f,
    0xf4, 0x0, 0xb, 0xf9, 0xf, 0xf5, 0x0, 0xd,
    0xf8, 0xc, 0xfc, 0x20, 0x5f, 0xf5, 0x3, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x3b, 0xff, 0xd8, 0x0,

    /* U+16D "ŭ" */
    0x1, 0xf9, 0x2a, 0xf1, 0x0, 0x8, 0xff, 0xf7,
    0x0, 0x0, 0x1, 0x31, 0x0, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+16E "Ů" */
    0x0, 0x1, 0xbc, 0x60, 0x0, 0x0, 0x7, 0x81,
    0xe0, 0x0, 0x0, 0x1, 0xbc, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f,
    0xf4, 0x0, 0xb, 0xf9, 0xf, 0xf5, 0x0, 0xd,
    0xf8, 0xc, 0xfc, 0x20, 0x5f, 0xf5, 0x3, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x3b, 0xff, 0xd8, 0x0,

    /* U+16F "ů" */
    0x0, 0x8, 0xc7, 0x0, 0x0, 0x2, 0xc0, 0xd1,
    0x0, 0x0, 0x2c, 0xd, 0x10, 0x0, 0x0, 0x7c,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff,
    0x23, 0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2,
    0xff, 0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff,
    0xff, 0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+170 "Ű" */
    0x0, 0x1, 0xed, 0x2e, 0xe1, 0x0, 0x9, 0xf3,
    0xbf, 0x20, 0x0, 0x7, 0x41, 0x73, 0x0, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa,
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9, 0xf,
    0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20, 0x5f,
    0xf5, 0x3, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x3b,
    0xff, 0xd8, 0x0,

    /* U+171 "ű" */
    0x0, 0xb, 0xf3, 0xcf, 0x30, 0x5, 0xf7, 0x7f,
    0x50, 0x0, 0x56, 0x6, 0x50, 0x3, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff,
    0x10, 0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23,
    0xff, 0x10, 0x2f, 0xf2, 0x2f, 0xf1, 0x2, 0xff,
    0x21, 0xff, 0x40, 0x6f, 0xf2, 0xd, 0xff, 0xff,
    0xff, 0x20, 0x2c, 0xfd, 0x6f, 0xf2,

    /* U+172 "Ų" */
    0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0,
    0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f,
    0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb,
    0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xfa, 0x1f, 0xf4,
    0x0, 0xb, 0xfa, 0x1f, 0xf4, 0x0, 0xb, 0xf9,
    0xf, 0xf5, 0x0, 0xd, 0xf8, 0xc, 0xfc, 0x20,
    0x5f, 0xf3, 0x4, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x3b, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xe, 0xd2,
    0x0, 0x0, 0x0, 0xc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x43, 0x0,

    /* U+173 "ų" */
    0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff, 0x10, 0x2f,
    0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x23, 0xff, 0x10,
    0x2f, 0xf2, 0x3f, 0xf1, 0x2, 0xff, 0x22, 0xff,
    0x10, 0x2f, 0xf2, 0x1f, 0xf4, 0x6, 0xff, 0x20,
    0xdf, 0xff, 0xff, 0xf2, 0x2, 0xcf, 0xd6, 0xff,
    0x20, 0x0, 0x0, 0xae, 0x30, 0x0, 0x0, 0xf,
    0xe7, 0x0, 0x0, 0x0, 0x8f, 0xd0,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x2, 0xef, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xcb, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x67, 0x10, 0x76, 0x0, 0x0, 0x9f, 0xb0, 0x1,
    0xff, 0x20, 0xa, 0xfa, 0x6f, 0xe0, 0x4, 0xff,
    0x50, 0xd, 0xf6, 0x3f, 0xf1, 0x8, 0xff, 0x90,
    0xf, 0xf3, 0xf, 0xf3, 0xb, 0xff, 0xc0, 0x3f,
    0xf0, 0xc, 0xf6, 0xf, 0xed, 0xf0, 0x6f, 0xc0,
    0x9, 0xf9, 0x2f, 0xaa, 0xf3, 0x9f, 0x90, 0x5,
    0xfc, 0x6f, 0x66, 0xf7, 0xcf, 0x60, 0x2, 0xff,
    0xaf, 0x32, 0xfa, 0xff, 0x20, 0x0, 0xef, 0xff,
    0x0, 0xff, 0xff, 0x0, 0x0, 0xbf, 0xfb, 0x0,
    0xbf, 0xfb, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x7f,
    0xf8, 0x0, 0x0, 0x4f, 0xf4, 0x0, 0x4f, 0xf5,
    0x0,

    /* U+175 "ŵ" */
    0x0, 0x0, 0x7f, 0xe3, 0x0, 0x0, 0x0, 0x9,
    0xd4, 0x7e, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x80, 0x1f, 0xd0, 0xc, 0xf6,
    0x6f, 0xb0, 0x5f, 0xf1, 0xf, 0xf2, 0x2f, 0xe0,
    0xaf, 0xf5, 0x2f, 0xe0, 0xe, 0xf1, 0xee, 0xfa,
    0x5f, 0xa0, 0xb, 0xf6, 0xf8, 0xce, 0x8f, 0x60,
    0x7, 0xfe, 0xf3, 0x8f, 0xef, 0x30, 0x3, 0xff,
    0xf0, 0x3f, 0xff, 0x0, 0x0, 0xff, 0xa0, 0xf,
    0xfb, 0x0, 0x0, 0xbf, 0x60, 0xa, 0xf7, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x40, 0x0, 0x0, 0x6f, 0x89, 0xf4, 0x0, 0x0,
    0x22, 0x0, 0x22, 0x0, 0xbf, 0xc0, 0x0, 0xe,
    0xfa, 0x4f, 0xf3, 0x0, 0x5f, 0xf2, 0xc, 0xfa,
    0x0, 0xcf, 0xa0, 0x4, 0xff, 0x23, 0xff, 0x20,
    0x0, 0xcf, 0x8a, 0xfa, 0x0, 0x0, 0x4f, 0xff,
    0xf3, 0x0, 0x0, 0xc, 0xff, 0xb0, 0x0, 0x0,
    0x5, 0xff, 0x30, 0x0, 0x0, 0x4, 0xff, 0x20,
    0x0, 0x0, 0x4, 0xff, 0x20, 0x0, 0x0, 0x4,
    0xff, 0x20, 0x0, 0x0, 0x4, 0xff, 0x20, 0x0,

    /* U+177 "ŷ" */
    0x0, 0x4e, 0xf5, 0x0, 0x0, 0x6e, 0x65, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9, 0x0,
    0x8f, 0xd0, 0x7f, 0xe0, 0xd, 0xf7, 0x1, 0xff,
    0x21, 0xff, 0x20, 0xc, 0xf7, 0x6f, 0xc0, 0x0,
    0x6f, 0xba, 0xf7, 0x0, 0x1, 0xff, 0xff, 0x20,
    0x0, 0xb, 0xff, 0xc0, 0x0, 0x0, 0x6f, 0xf6,
    0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0, 0x8f,
    0xb0, 0x0, 0x1, 0xff, 0xf5, 0x0, 0x0, 0x1e,
    0xe7, 0x0, 0x0, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0xcd, 0x1, 0xeb, 0x0, 0x0, 0xde, 0x1,
    0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc0, 0x0, 0xe, 0xfa, 0x4f, 0xf3, 0x0, 0x5f,
    0xf2, 0xc, 0xfa, 0x0, 0xcf, 0xa0, 0x4, 0xff,
    0x23, 0xff, 0x20, 0x0, 0xcf, 0x8a, 0xfa, 0x0,
    0x0, 0x4f, 0xff, 0xf3, 0x0, 0x0, 0xc, 0xff,
    0xb0, 0x0, 0x0, 0x5, 0xff, 0x30, 0x0, 0x0,
    0x4, 0xff, 0x20, 0x0, 0x0, 0x4, 0xff, 0x20,
    0x0, 0x0, 0x4, 0xff, 0x20, 0x0, 0x0, 0x4,
    0xff, 0x20, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0, 0x0,
    0xc, 0xfb, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0,
    0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0xc, 0xfc,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0xb, 0xfd, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xf3, 0x6f, 0xff,
    0xff, 0xff, 0xf3,

    /* U+17A "ź" */
    0x0, 0x0, 0xcf, 0x90, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x4f, 0xff, 0xff, 0xf7,
    0x4e, 0xee, 0xff, 0xf5, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0x8, 0xfe, 0x10, 0x0, 0x4f, 0xf4, 0x0,
    0x1, 0xef, 0x90, 0x0, 0xa, 0xfd, 0x0, 0x0,
    0x4f, 0xff, 0xee, 0xe8, 0x6f, 0xff, 0xff, 0xf9,

    /* U+17B "Ż" */
    0x0, 0x1, 0xec, 0x0, 0x0, 0x0, 0x2, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0, 0x0,
    0xc, 0xfb, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0,
    0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0xc, 0xfc,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0xb, 0xfd, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xf3, 0x6f, 0xff,
    0xff, 0xff, 0xf3,

    /* U+17C "ż" */
    0x0, 0xc, 0xd1, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0x1, 0x20, 0x0, 0x4f, 0xff, 0xff, 0xf7,
    0x4e, 0xee, 0xff, 0xf5, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0x8, 0xfe, 0x10, 0x0, 0x4f, 0xf4, 0x0,
    0x1, 0xef, 0x90, 0x0, 0xa, 0xfd, 0x0, 0x0,
    0x4f, 0xff, 0xee, 0xe8, 0x6f, 0xff, 0xff, 0xf9,

    /* U+17D "Ž" */
    0x0, 0xaf, 0x46, 0xf9, 0x0, 0x0, 0xb, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0, 0x0,
    0xc, 0xfb, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0,
    0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0xc, 0xfc,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0xb, 0xfd, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xf3, 0x6f, 0xff,
    0xff, 0xff, 0xf3,

    /* U+17E "ž" */
    0x6, 0xf6, 0x4f, 0x90, 0x0, 0x3d, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf7,
    0x4e, 0xee, 0xff, 0xf5, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0x8, 0xfe, 0x10, 0x0, 0x4f, 0xf4, 0x0,
    0x1, 0xef, 0x90, 0x0, 0xa, 0xfd, 0x0, 0x0,
    0x4f, 0xff, 0xee, 0xe8, 0x6f, 0xff, 0xff, 0xf9,

    /* U+17F "ſ" */
    0x1, 0xae, 0xe3, 0xb, 0xff, 0xf2, 0xf, 0xf5,
    0x0, 0x1f, 0xf2, 0x0, 0x1f, 0xf2, 0x0, 0x1f,
    0xf2, 0x0, 0x1f, 0xf2, 0x0, 0x1f, 0xf2, 0x0,
    0x1f, 0xf2, 0x0, 0x1f, 0xf2, 0x0, 0x1f, 0xf2,
    0x0, 0x1f, 0xf2, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x16, 0xbf, 0xff, 0xff,
    0x0, 0x0, 0x3, 0x8d, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xea, 0x51, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x83, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x2b, 0xff, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xfd,
    0xdf, 0xff, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xb2,
    0xdf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,

    /* U+F00B "" */
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xc0,
    0x1b, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xfc, 0x0,
    0xcf, 0xfb, 0x0, 0x0, 0xbf, 0xff, 0xc0, 0x0,
    0xbf, 0xff, 0xb0, 0xb, 0xff, 0xfc, 0x0, 0x0,
    0xc, 0xff, 0xfb, 0xbf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x3, 0x0, 0x0, 0x0, 0x3, 0x8, 0xfc, 0x10,
    0x0, 0x1c, 0xf8, 0xff, 0xfc, 0x10, 0x1c, 0xff,
    0xf5, 0xff, 0xfc, 0x2c, 0xff, 0xf5, 0x5, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x5, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x1d, 0xff, 0xfd, 0x10, 0x0, 0x1c,
    0xff, 0xff, 0xfc, 0x10, 0x1c, 0xff, 0xf9, 0xff,
    0xfc, 0x1c, 0xff, 0xf5, 0x5, 0xff, 0xfc, 0xdf,
    0xf5, 0x0, 0x5, 0xff, 0xd1, 0xa4, 0x0, 0x0,
    0x4, 0xa1,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x10, 0x6f, 0xf1, 0x3, 0x10, 0x0,
    0x0, 0x5f, 0xd0, 0x6f, 0xf1, 0x3f, 0xd1, 0x0,
    0x3, 0xff, 0xf1, 0x6f, 0xf1, 0x5f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x6f, 0xf1, 0x9, 0xff, 0x70,
    0x4f, 0xf7, 0x0, 0x6f, 0xf1, 0x0, 0xcf, 0xe0,
    0x9f, 0xf0, 0x0, 0x6f, 0xf1, 0x0, 0x5f, 0xf3,
    0xbf, 0xc0, 0x0, 0x6f, 0xf1, 0x0, 0x2f, 0xf5,
    0xbf, 0xc0, 0x0, 0x4f, 0xe0, 0x0, 0x1f, 0xf6,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf0,
    0xf, 0xfe, 0x10, 0x0, 0x0, 0x5, 0xff, 0xa0,
    0x6, 0xff, 0xd3, 0x0, 0x0, 0x7f, 0xff, 0x20,
    0x0, 0x9f, 0xff, 0xda, 0xbe, 0xff, 0xf4, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x17, 0xbd, 0xca, 0x50, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x4, 0xfd, 0xdf, 0xff, 0xff, 0xfd, 0xef, 0x40,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4, 0xfe, 0xdf, 0xff, 0xff, 0xfd, 0xdf, 0x40,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x3, 0xdd, 0x30, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5, 0x4f,
    0xf4, 0x0, 0x0, 0x0, 0x9, 0xff, 0x99, 0xff,
    0xbf, 0xf4, 0x0, 0x0, 0x1, 0xbf, 0xf6, 0x22,
    0x6f, 0xff, 0xf4, 0x0, 0x0, 0x2d, 0xfe, 0x35,
    0xff, 0x53, 0xef, 0xf4, 0x0, 0x4, 0xff, 0xc1,
    0x8f, 0xff, 0xf8, 0x2d, 0xfe, 0x40, 0x7f, 0xfa,
    0x1a, 0xff, 0xff, 0xff, 0xa1, 0xaf, 0xf7, 0xcf,
    0x82, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x28, 0xfc,
    0x14, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x41, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xf9, 0x0, 0x8f,
    0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8,
    0x0, 0x8f, 0xff, 0xf0, 0x0, 0x0, 0xe, 0xff,
    0xf6, 0x0, 0x6f, 0xff, 0xe0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x1b, 0xb1, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xc2, 0x2c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F01C "" */
    0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0xb, 0xfa, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x50, 0x1e, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe1, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F021 "" */
    0x0, 0x0, 0x6, 0xbd, 0xda, 0x50, 0x2, 0xff,
    0x0, 0x5, 0xef, 0xff, 0xff, 0xfe, 0x42, 0xff,
    0x0, 0x7f, 0xff, 0xa7, 0x7b, 0xff, 0xf9, 0xff,
    0x5, 0xff, 0xc1, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xe, 0xfc, 0x0, 0x0, 0x2, 0x22, 0xdf, 0xff,
    0x5f, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x8f, 0xb0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb, 0xf8,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x2f, 0xf4,
    0xff, 0xfd, 0x22, 0x20, 0x0, 0x0, 0xcf, 0xe0,
    0xff, 0xff, 0xc2, 0x0, 0x0, 0x2c, 0xff, 0x40,
    0xff, 0x9f, 0xff, 0xb7, 0x6a, 0xff, 0xf7, 0x0,
    0xff, 0x24, 0xdf, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xff, 0x20, 0x5, 0xac, 0xdb, 0x60, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x8f, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x1, 0x50, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x0, 0xae,
    0xff, 0xff, 0xff, 0xff, 0x5, 0xf8, 0xdf, 0xff,
    0xff, 0xff, 0x2, 0x60, 0x0, 0x0, 0x9f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x3, 0xee, 0x10, 0x0, 0x0, 0x8, 0xff, 0x0,
    0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x5, 0xfc, 0x7, 0xf4, 0xdf, 0xff, 0xff,
    0xff, 0x2, 0x50, 0x5f, 0x60, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xd, 0xc0, 0xbd, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x6, 0xf7, 0xd,
    0xc0, 0xad, 0xdf, 0xff, 0xff, 0xff, 0x2, 0x50,
    0x5f, 0x60, 0xe9, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x5, 0xfc, 0x6, 0xf4, 0x0, 0x0, 0x8, 0xff,
    0x0, 0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x2, 0xee, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0,

    /* U+F03E "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0xc, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xfe, 0x22, 0xef, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xe2, 0x0, 0x2e, 0xff,
    0xff, 0xfe, 0x4e, 0xfe, 0x20, 0x0, 0x2, 0xff,
    0xff, 0xe2, 0x2, 0xc2, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x1, 0xcc, 0xff, 0x40, 0x0, 0x2d, 0xff, 0xff,
    0x40, 0x3, 0xef, 0xff, 0xff, 0x40, 0x3f, 0xff,
    0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x4f, 0xff, 0xff, 0xff, 0x40, 0x3, 0xef,
    0xff, 0xff, 0x40, 0x0, 0x2e, 0xff, 0xff, 0x30,
    0x0, 0x1, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd,
    0x40, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0x7f, 0xff, 0xf7, 0x0, 0x7f, 0xff,
    0xf7,

    /* U+F04D "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x10, 0x0,
    0x3, 0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xff,
    0xfe, 0x30, 0x4, 0xff, 0xff, 0xff, 0xf4, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x54, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff,
    0xff, 0xf3, 0x4, 0xff, 0xff, 0xfe, 0x30, 0x4,
    0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xcc, 0x10,
    0x0, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x1a, 0x40, 0x0, 0x0, 0x1,
    0xdf, 0xf0, 0x0, 0x0, 0x1d, 0xff, 0xa0, 0x0,
    0x1, 0xdf, 0xfa, 0x0, 0x0, 0x1d, 0xff, 0xa0,
    0x0, 0x1, 0xdf, 0xfa, 0x0, 0x0, 0xc, 0xff,
    0xa0, 0x0, 0x0, 0xd, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xdf, 0xf8, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0x80, 0x0, 0x0, 0x1, 0xdf, 0xf8, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x80, 0x0, 0x0, 0x1, 0xdf,
    0xf0, 0x0, 0x0, 0x0, 0x1b, 0x50,

    /* U+F054 "" */
    0x4, 0xa1, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x10,
    0x0, 0x0, 0xa, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0x10, 0x0, 0x0, 0xa, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xaf, 0xfd, 0x10, 0x0, 0x0,
    0xa, 0xff, 0xc0, 0x0, 0x0, 0x8, 0xff, 0xd0,
    0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8, 0xff,
    0xd1, 0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8,
    0xff, 0xd1, 0x0, 0x0, 0xf, 0xfd, 0x10, 0x0,
    0x0, 0x5, 0xb1, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x48, 0x88, 0x8c, 0xff, 0xc8,
    0x88, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x48, 0x88, 0x8c, 0xff, 0xc8, 0x88, 0x84, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x40,
    0x0, 0x0,

    /* U+F068 "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7,

    /* U+F06E "" */
    0x0, 0x0, 0x5, 0xad, 0xff, 0xda, 0x50, 0x0,
    0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf, 0xfd,
    0x40, 0x0, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4,
    0xef, 0xf7, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x9e,
    0x80, 0x4f, 0xff, 0x70, 0x4f, 0xff, 0xc0, 0x0,
    0xaf, 0xf8, 0xc, 0xff, 0xf4, 0xdf, 0xff, 0x80,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0xdf, 0xff,
    0x80, 0xef, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0x4f,
    0xff, 0xc0, 0x8f, 0xff, 0xf8, 0xc, 0xff, 0xf4,
    0x7, 0xff, 0xf4, 0x8, 0xee, 0x80, 0x4f, 0xff,
    0x70, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4, 0xef,
    0xf8, 0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf,
    0xfd, 0x40, 0x0, 0x0, 0x0, 0x5, 0xad, 0xff,
    0xda, 0x50, 0x0, 0x0,

    /* U+F070 "" */
    0x8c, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0x80, 0x49,
    0xdf, 0xfd, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xd8, 0x8c, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x4, 0xef, 0xf8, 0x0, 0x0, 0x4e, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x1c, 0xff, 0x69, 0xe8,
    0x4, 0xff, 0xf7, 0x0, 0x4, 0xe3, 0x0, 0x9f,
    0xfe, 0xff, 0x80, 0xcf, 0xff, 0x40, 0xd, 0xff,
    0x70, 0x5, 0xff, 0xff, 0xe0, 0x8f, 0xff, 0xd0,
    0xd, 0xff, 0xf7, 0x0, 0x2d, 0xff, 0xe0, 0x8f,
    0xff, 0xd0, 0x4, 0xff, 0xfc, 0x0, 0x0, 0xaf,
    0xf8, 0xcf, 0xff, 0x30, 0x0, 0x7f, 0xff, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x8,
    0xff, 0xf4, 0x0, 0x0, 0x3e, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x4d, 0xff, 0xc8, 0x82, 0x1, 0xbf,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xdf, 0xfc,
    0x10, 0x8, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc8,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xd8, 0x8d,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xa0, 0xa, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xb0, 0xb, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xc0, 0xc, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xd0, 0xd,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xf9, 0x9f, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xe2, 0x2e, 0xff, 0xff, 0xf8, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x90, 0x9, 0xff, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xff, 0xe3, 0x3e,
    0xff, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0x78, 0x8e, 0xff, 0x15, 0xff, 0xe8, 0xff, 0xe2,
    0x0, 0x2, 0xe5, 0x4f, 0xfe, 0x20, 0xfe, 0x20,
    0x0, 0x0, 0x13, 0xff, 0xf3, 0x0, 0x52, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0x31, 0x0, 0x52, 0x0,
    0x0, 0x2, 0xef, 0xf4, 0x5e, 0x20, 0xfe, 0x20,
    0x78, 0x8e, 0xff, 0x51, 0xff, 0xe8, 0xff, 0xe2,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x1d, 0xff, 0x99,
    0xff, 0xd1, 0x0, 0x1, 0xdf, 0xf9, 0x0, 0x9f,
    0xfd, 0x10, 0x1d, 0xff, 0x90, 0x0, 0x9, 0xff,
    0xd1, 0xbf, 0xf9, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x5f, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F078 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0xbf, 0xf9,
    0x0, 0x0, 0x0, 0x9f, 0xfb, 0x1d, 0xff, 0x90,
    0x0, 0x9, 0xff, 0xd1, 0x1, 0xdf, 0xf9, 0x0,
    0x9f, 0xfd, 0x10, 0x0, 0x1d, 0xff, 0x99, 0xff,
    0xd1, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfd, 0x10,
    0xef, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x1d, 0xff,
    0xff, 0xd1, 0xaf, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x6b, 0x1f, 0xf1, 0xb6, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x6b, 0x1f,
    0xf1, 0xb6, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfa, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xfe, 0x1, 0xdf, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x8f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xf0, 0xdf, 0xfd, 0xf, 0xff, 0xfd,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xea,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0x30, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x8f,
    0xf3, 0x0, 0x6f, 0xff, 0xd0, 0x0, 0xa, 0xff,
    0xff, 0xe4, 0xbf, 0xff, 0xd1, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xdb, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x8, 0xee, 0x80, 0x0, 0x0, 0x6, 0x61, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x2d, 0xff, 0xd0, 0xef,
    0x33, 0xfe, 0x0, 0x2e, 0xff, 0xf3, 0xe, 0xf3,
    0x3f, 0xe0, 0x2e, 0xff, 0xf3, 0x0, 0x8f, 0xff,
    0xff, 0x6e, 0xff, 0xf3, 0x0, 0x0, 0x8e, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x8, 0xff, 0xff, 0xf6, 0xef,
    0xff, 0x30, 0x0, 0xef, 0x33, 0xfe, 0x2, 0xef,
    0xff, 0x30, 0xe, 0xf3, 0x3f, 0xe0, 0x2, 0xef,
    0xff, 0x30, 0x8f, 0xff, 0xf8, 0x0, 0x2, 0xdf,
    0xfd, 0x0, 0x8e, 0xe8, 0x0, 0x0, 0x0, 0x66,
    0x10,

    /* U+F0C5 "" */
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xd, 0x20, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf, 0xe2, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf, 0xfd, 0xdf, 0xf0, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,

    /* U+F0C7 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xe2, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x11, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x11, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F0E7 "" */
    0x0, 0xdf, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x20,
    0xd, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xe0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x2f, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x4, 0xee, 0x40, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0x99, 0xff, 0xfd, 0x0, 0x0, 0xff, 0xff,
    0x99, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xd, 0xff, 0xff,
    0xd, 0x20, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf,
    0xe2, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf, 0xfd,
    0xff, 0xff, 0xf, 0xff, 0xff, 0x20, 0x0, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfd,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0xfc, 0x20, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xee, 0x40, 0x0, 0x0,

    /* U+F11C "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x8,
    0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff, 0xf8,
    0x8, 0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xff, 0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x17,
    0xef, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x2a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0xdf, 0xff, 0xff, 0xf0, 0xd2, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0xfe, 0x20, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xe2, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x9c, 0xef, 0xfe,
    0xc9, 0x40, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x70, 0x0, 0x4, 0xdf,
    0xff, 0xfc, 0xa8, 0x8a, 0xcf, 0xff, 0xfd, 0x40,
    0x6f, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0xff, 0xf6, 0xcf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfc, 0x1a, 0x30, 0x0, 0x5a,
    0xdf, 0xfd, 0xa5, 0x0, 0x3, 0xa1, 0x0, 0x0,
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xa8, 0x8a, 0xef, 0xff,
    0x50, 0x0, 0x0, 0x1, 0xdf, 0x70, 0x0, 0x0,
    0x7, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F241 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F242 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F243 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F244 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x29, 0xfe, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x80, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0xdf,
    0xff, 0x77, 0xf7, 0x55, 0x55, 0x55, 0x55, 0x8f,
    0xd3, 0xf, 0xff, 0xfd, 0xcc, 0xdf, 0xdc, 0xcc,
    0xcc, 0xcd, 0xff, 0xb0, 0x8f, 0xfe, 0x10, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x4d, 0x40, 0x0, 0x46,
    0x10, 0x0, 0x1, 0xf2, 0x2, 0x33, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb1, 0xcf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x22,
    0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x2, 0xef,
    0xfb, 0xef, 0xff, 0x30, 0xd, 0xff, 0xfa, 0x2e,
    0xff, 0xe0, 0x4f, 0xff, 0xfa, 0x3, 0xff, 0xf5,
    0x9f, 0xfa, 0xfa, 0x35, 0x4f, 0xfa, 0xcf, 0xc0,
    0x8a, 0x3d, 0xb, 0xfd, 0xef, 0xfb, 0x3, 0x12,
    0x8f, 0xfe, 0xff, 0xff, 0xb0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xd1, 0x8, 0xff, 0xff, 0xef, 0xfd,
    0x11, 0x10, 0x9f, 0xff, 0xdf, 0xd1, 0x59, 0x3b,
    0xb, 0xfd, 0xaf, 0xd7, 0xfa, 0x38, 0x1d, 0xfb,
    0x5f, 0xff, 0xfa, 0x1, 0xdf, 0xf7, 0xd, 0xff,
    0xfa, 0x1d, 0xff, 0xf1, 0x3, 0xef, 0xfc, 0xdf,
    0xff, 0x50, 0x0, 0x18, 0xdf, 0xfe, 0xa3, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x7f, 0xff, 0xf7, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9, 0x9f,
    0xf0, 0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0,
    0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf,
    0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8,
    0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f,
    0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f, 0x88,
    0xf8, 0x8f, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9,
    0x9f, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x8a, 0x1d,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfa,
    0x1d, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xfa, 0x1d, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xde, 0xdb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfa, 0xef, 0xfe, 0xaf, 0xff, 0xff, 0x1, 0xdf,
    0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa, 0xff, 0xff,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e,
    0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x2, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x2, 0xef, 0xff, 0xff, 0x1d, 0xff,
    0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e, 0xff, 0xff,
    0x1, 0xdf, 0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xfa, 0xef,
    0xfe, 0xaf, 0xff, 0xff, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F7C2 "" */
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xfe, 0x8, 0xf8, 0xf, 0xb,
    0x40, 0xff, 0x8f, 0xf8, 0xf, 0xb, 0x40, 0xff,
    0xff, 0xf8, 0xf, 0xb, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x2,
    0xef, 0x10, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x11, 0xcf, 0xff, 0x77, 0x77, 0x77,
    0x77, 0xbf, 0xf1, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x17, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 64, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 70, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24, .adv_w = 82, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 37, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 97, .adv_w = 147, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 169, .adv_w = 189, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 241, .adv_w = 168, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 307, .adv_w = 41, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 315, .adv_w = 90, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 369, .adv_w = 90, .box_w = 5, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 414, .adv_w = 116, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 446, .adv_w = 140, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 487, .adv_w = 63, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 495, .adv_w = 99, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 501, .adv_w = 74, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 507, .adv_w = 96, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 553, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 607, .adv_w = 147, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 643, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 697, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 751, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 805, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 859, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 913, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 967, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1021, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1075, .adv_w = 72, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1093, .adv_w = 67, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1119, .adv_w = 130, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1155, .adv_w = 147, .box_w = 8, .box_h = 5, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1175, .adv_w = 132, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1207, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1255, .adv_w = 229, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1360, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1426, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1480, .adv_w = 168, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1540, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1594, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1642, .adv_w = 140, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1690, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1756, .adv_w = 181, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1816, .adv_w = 75, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1834, .adv_w = 143, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1882, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1942, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1990, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2062, .adv_w = 181, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2122, .adv_w = 177, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2188, .adv_w = 165, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2242, .adv_w = 177, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2319, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2373, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2433, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2493, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2553, .adv_w = 167, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2619, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2703, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2763, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2823, .adv_w = 155, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2883, .adv_w = 71, .box_w = 5, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2926, .adv_w = 108, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2978, .adv_w = 71, .box_w = 4, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3012, .adv_w = 112, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 3033, .adv_w = 114, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3041, .adv_w = 85, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 3049, .adv_w = 137, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3090, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3144, .adv_w = 134, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3180, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3234, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3275, .adv_w = 92, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3311, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3365, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3419, .adv_w = 68, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3443, .adv_w = 67, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3481, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3535, .adv_w = 68, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3559, .adv_w = 222, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3618, .adv_w = 143, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3659, .adv_w = 145, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3700, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3754, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3808, .adv_w = 93, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3838, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3874, .adv_w = 87, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3907, .adv_w = 143, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3948, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3984, .adv_w = 188, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4038, .adv_w = 130, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4079, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4133, .adv_w = 130, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4169, .adv_w = 85, .box_w = 6, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4220, .adv_w = 65, .box_w = 2, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4235, .adv_w = 85, .box_w = 5, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4278, .adv_w = 166, .box_w = 10, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 4298, .adv_w = 64, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4298, .adv_w = 72, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4316, .adv_w = 147, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4375, .adv_w = 152, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4435, .adv_w = 177, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4501, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4555, .adv_w = 65, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4576, .adv_w = 161, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4651, .adv_w = 120, .box_w = 7, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4662, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4734, .adv_w = 114, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 4752, .adv_w = 128, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4780, .adv_w = 141, .box_w = 8, .box_h = 5, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 4800, .adv_w = 99, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4806, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4878, .adv_w = 128, .box_w = 6, .box_h = 3, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 4887, .adv_w = 99, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4902, .adv_w = 138, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4946, .adv_w = 95, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4964, .adv_w = 95, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4982, .adv_w = 85, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4990, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5038, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5080, .adv_w = 77, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 5085, .adv_w = 69, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5095, .adv_w = 95, .box_w = 4, .box_h = 7, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 5109, .adv_w = 117, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 5130, .adv_w = 128, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5158, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5224, .adv_w = 195, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5302, .adv_w = 207, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5387, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5435, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5518, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5601, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5684, .adv_w = 172, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5772, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5855, .adv_w = 172, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5943, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6033, .adv_w = 168, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6108, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6168, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6228, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6288, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6348, .adv_w = 75, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6386, .adv_w = 75, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6424, .adv_w = 75, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6477, .adv_w = 75, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6530, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6596, .adv_w = 181, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6676, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6759, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6842, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6925, .adv_w = 177, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7013, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7096, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 7132, .adv_w = 176, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7204, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7279, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7354, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7429, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7504, .adv_w = 158, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7579, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7633, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7687, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7741, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7795, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7849, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7903, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7957, .adv_w = 137, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8020, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8083, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8131, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8185, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8239, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8293, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8347, .adv_w = 70, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8377, .adv_w = 70, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8407, .adv_w = 70, .box_w = 7, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8449, .adv_w = 70, .box_w = 7, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8491, .adv_w = 147, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8550, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8604, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8658, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8712, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8766, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8820, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8874, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8915, .adv_w = 145, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8965, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9019, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9073, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9127, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9181, .adv_w = 129, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9249, .adv_w = 145, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9317, .adv_w = 129, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9385, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9468, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9522, .adv_w = 172, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9610, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9664, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9747, .adv_w = 137, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9801, .adv_w = 168, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9881, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9929, .adv_w = 168, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10009, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10057, .adv_w = 168, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10137, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10185, .adv_w = 168, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10265, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10313, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10381, .adv_w = 163, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10447, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10513, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10573, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10633, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10687, .adv_w = 144, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10751, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10805, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10865, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10919, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 10979, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11033, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11093, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11147, .adv_w = 174, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11235, .adv_w = 146, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11303, .adv_w = 174, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11391, .adv_w = 146, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11463, .adv_w = 174, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11551, .adv_w = 146, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11619, .adv_w = 174, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11707, .adv_w = 146, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11788, .adv_w = 181, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11863, .adv_w = 143, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11935, .adv_w = 184, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12007, .adv_w = 147, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12067, .adv_w = 75, .box_w = 7, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12123, .adv_w = 70, .box_w = 7, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12165, .adv_w = 75, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12218, .adv_w = 70, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12254, .adv_w = 75, .box_w = 7, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12310, .adv_w = 70, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12346, .adv_w = 75, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12376, .adv_w = 68, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12406, .adv_w = 75, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12429, .adv_w = 70, .box_w = 3, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12443, .adv_w = 218, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12515, .adv_w = 134, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12575, .adv_w = 143, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12650, .adv_w = 72, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12703, .adv_w = 163, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12783, .adv_w = 137, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12855, .adv_w = 151, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12896, .adv_w = 139, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12956, .adv_w = 68, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13004, .adv_w = 139, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 13068, .adv_w = 68, .box_w = 4, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13100, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13148, .adv_w = 87, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13190, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13238, .adv_w = 95, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13280, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13334, .adv_w = 78, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13364, .adv_w = 181, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13439, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13493, .adv_w = 181, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 13573, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13632, .adv_w = 181, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13707, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13761, .adv_w = 143, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13821, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13896, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13950, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14033, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14087, .adv_w = 177, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14175, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14229, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14312, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14366, .adv_w = 248, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14456, .adv_w = 231, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14519, .adv_w = 163, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14587, .adv_w = 93, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14629, .adv_w = 163, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 14701, .adv_w = 93, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14743, .adv_w = 163, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14811, .adv_w = 93, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14853, .adv_w = 157, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14928, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14976, .adv_w = 157, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15051, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15099, .adv_w = 157, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15174, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15222, .adv_w = 157, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15297, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15345, .adv_w = 158, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15420, .adv_w = 87, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15465, .adv_w = 158, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15540, .adv_w = 92, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15589, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15649, .adv_w = 87, .box_w = 7, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15688, .adv_w = 169, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15768, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15822, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15897, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15951, .adv_w = 169, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16031, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16085, .adv_w = 169, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16165, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16228, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16303, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16357, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16432, .adv_w = 143, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16486, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16591, .adv_w = 188, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16663, .adv_w = 158, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16743, .adv_w = 129, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16811, .adv_w = 158, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16886, .adv_w = 155, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16961, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17009, .adv_w = 155, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17084, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17132, .adv_w = 155, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17207, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17255, .adv_w = 66, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17291, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17427, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17523, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17635, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17731, .adv_w = 176, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17797, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17925, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18053, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18179, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18307, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18415, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18543, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18599, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18683, .adv_w = 288, .box_w = 18, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18827, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18923, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 19003, .adv_w = 224, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 19129, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19234, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19332, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 19412, .adv_w = 224, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 19524, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19594, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19664, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19762, .adv_w = 224, .box_w = 14, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 19790, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19898, .adv_w = 320, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20058, .adv_w = 288, .box_w = 20, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 20218, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20346, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 20416, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 20486, .adv_w = 320, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20626, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20722, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20850, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 20995, .adv_w = 224, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21100, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21212, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21310, .adv_w = 160, .box_w = 12, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 21406, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21518, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21630, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21738, .adv_w = 256, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 21900, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21996, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 22146, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 22246, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 22346, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 22446, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 22546, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 22646, .adv_w = 320, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 22793, .adv_w = 224, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22889, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23001, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 23146, .adv_w = 320, .box_w = 20, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23266, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23362, .adv_w = 258, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, -7, 0,
    -2, -11, 0, -11, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    5, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -36, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -31,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    -10, 0, -3, 0, 0, -15, -2, -10,
    -5, 0, -19, 0, 0, 0, 0, 0,
    -6, -1, 0, 0, -2, -1, -6, -4,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -3,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, -3, 0, 0, 0, -11, 0, -3,
    0, -3, -5, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, -2, -2,
    0, -2, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -34, 0, 0,
    0, -24, 0, -26, 0, 3, 0, 0,
    0, 0, 0, 0, 0, -4, -3, 0,
    0, -3, -3, 0, 0, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -4, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -20, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -3, -5, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -36, 0, 0, 0, 0, 0, 0,
    0, 2, -8, 0, 0, -26, -3, -26,
    -12, 0, -35, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -15, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -50, 0, 0,
    0, -22, 0, -23, 0, 0, 0, 0,
    0, -6, 0, -4, 0, -1, -2, 0,
    0, -2, 0, 0, 2, 0, 2, 0,
    0, 0, 0, 0, 0, -37, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -3,
    -2, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -2,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, 0, 0, 0, 0, -32, -34, 0,
    0, -15, -3, -27, -2, 2, 0, 2,
    2, 0, 2, 0, 0, -21, -11, 0,
    -11, -26, -8, -9, 0, -8, -10, -6,
    -10, -7, 0, -18, -18, -24, -10, -12,
    0, 0, 0, 3, 0, -27, -20, 0,
    0, -9, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -6, -5, 0,
    0, -6, -4, 0, 0, -3, -1, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -18, -7, 0,
    0, -5, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 2, -4, -4, 0,
    0, -4, -3, 0, 0, -2, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -19, 0,
    0, 0, -3, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -3, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 3, -6, -29, -19, 0,
    0, -19, -4, -12, -2, 2, -12, 2,
    2, 2, 2, 0, 2, -8, -8, -3,
    -5, -8, -5, -7, -3, -5, -2, 0,
    -3, -4, 2, -10, -6, -12, -8, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -2, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -3, -2, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -22, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -2, 3,
    0, -4, 0, 0, 6, 0, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -21, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 2,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_bold_16 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 20,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_BOLD_16*/


