#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 12 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_BOLD_12
#define RB_LV_FONT_ROBOTO_BOLD_12 1
#endif

#if RB_LV_FONT_ROBOTO_BOLD_12

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x3f, 0x83, 0xf8, 0x2f, 0x72, 0xf7, 0x1f, 0x61,
    0xf6, 0x6, 0x21, 0xe6, 0x1e, 0x60,

    /* U+22 "\"" */
    0xa8, 0xb7, 0xa8, 0xb6, 0xa6, 0xb5, 0x52, 0x52,

    /* U+23 "#" */
    0x0, 0x5b, 0x1f, 0x0, 0x8, 0x85, 0xb0, 0x3f,
    0xff, 0xff, 0xe0, 0x1e, 0x4b, 0x71, 0x0, 0xf0,
    0xd3, 0x9, 0xff, 0xff, 0xf7, 0x17, 0xc4, 0xe2,
    0x10, 0x89, 0x4c, 0x0, 0xa, 0x67, 0xa0, 0x0,

    /* U+24 "$" */
    0x0, 0xd, 0x10, 0x0, 0x7, 0xe8, 0x10, 0xb,
    0xfd, 0xfc, 0x1, 0xfb, 0x8, 0xf3, 0xf, 0xc0,
    0x15, 0x10, 0x9f, 0xd5, 0x0, 0x0, 0x6d, 0xfa,
    0x1, 0x40, 0xa, 0xf3, 0x5f, 0x60, 0x7f, 0x40,
    0xef, 0xbf, 0xe0, 0x2, 0x9f, 0x92, 0x0, 0x0,
    0xe0, 0x0,

    /* U+25 "%" */
    0xb, 0xf9, 0x0, 0x0, 0x6, 0xd2, 0xf3, 0x3a,
    0x0, 0x6c, 0xf, 0x3d, 0x40, 0x1, 0xdf, 0xb7,
    0xa0, 0x0, 0x0, 0x11, 0xe1, 0x0, 0x0, 0x0,
    0xb7, 0xae, 0xa0, 0x0, 0x4c, 0x4e, 0x3e, 0x40,
    0xd, 0x34, 0xd2, 0xe4, 0x0, 0x10, 0xb, 0xfb,
    0x0,

    /* U+26 "&" */
    0x2, 0xcf, 0xb1, 0x0, 0xb, 0xf9, 0xf8, 0x0,
    0xc, 0xc0, 0xd8, 0x0, 0x6, 0xfd, 0xd1, 0x0,
    0x7, 0xff, 0x32, 0x81, 0x4f, 0x8e, 0xe7, 0xf1,
    0x8f, 0x23, 0xff, 0xd0, 0x5f, 0xb6, 0xdf, 0xa0,
    0x7, 0xef, 0xcb, 0xf5,

    /* U+27 "'" */
    0xa9, 0xa9, 0xa8, 0x53,

    /* U+28 "(" */
    0x0, 0x0, 0x0, 0x5d, 0x1, 0xf5, 0x9, 0xc0,
    0xe, 0x70, 0x1f, 0x40, 0x3f, 0x30, 0x4f, 0x20,
    0x3f, 0x30, 0xf, 0x50, 0xc, 0x90, 0x6, 0xe0,
    0x0, 0xc9, 0x0, 0x19,

    /* U+29 ")" */
    0x10, 0x0, 0xa8, 0x0, 0x2f, 0x40, 0x9, 0xc0,
    0x4, 0xf2, 0x1, 0xf6, 0x0, 0xf8, 0x0, 0xf8,
    0x0, 0xf7, 0x2, 0xf5, 0x6, 0xf1, 0xc, 0xa0,
    0x6e, 0x10, 0x73, 0x0,

    /* U+2A "*" */
    0x0, 0xc5, 0x0, 0x42, 0xb4, 0x40, 0x8f, 0xfe,
    0xe3, 0x4, 0xfc, 0x0, 0x1e, 0x4d, 0x60, 0x4,
    0x3, 0x20,

    /* U+2B "+" */
    0x0, 0x6c, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0x8f, 0x10, 0xa, 0xff, 0xff, 0xf3, 0x7a, 0xdf,
    0xba, 0x20, 0x8, 0xf1, 0x0, 0x0, 0x8f, 0x10,
    0x0,

    /* U+2C "," */
    0x2f, 0x43, 0xf3, 0x6e, 0x7, 0x50,

    /* U+2D "-" */
    0x2, 0x22, 0x5f, 0xff, 0x15, 0x54,

    /* U+2E "." */
    0x1e, 0x62, 0xe7,

    /* U+2F "/" */
    0x0, 0x1, 0xf2, 0x0, 0x6, 0xd0, 0x0, 0xb,
    0x80, 0x0, 0xf, 0x30, 0x0, 0x5e, 0x0, 0x0,
    0xa9, 0x0, 0x0, 0xf4, 0x0, 0x4, 0xf0, 0x0,
    0x9, 0xa0, 0x0, 0xe, 0x50, 0x0,

    /* U+30 "0" */
    0x3, 0xcf, 0xc2, 0x0, 0xee, 0x8e, 0xd0, 0x4f,
    0x50, 0x8f, 0x26, 0xf4, 0x6, 0xf4, 0x7f, 0x40,
    0x6f, 0x56, 0xf4, 0x6, 0xf4, 0x4f, 0x60, 0x7f,
    0x20, 0xee, 0x8e, 0xd0, 0x3, 0xcf, 0xc2, 0x0,

    /* U+31 "1" */
    0x0, 0x39, 0xa0, 0xdf, 0xfb, 0x9, 0x4f, 0xb0,
    0x0, 0xfb, 0x0, 0xf, 0xb0, 0x0, 0xfb, 0x0,
    0xf, 0xb0, 0x0, 0xfb, 0x0, 0xf, 0xb0,

    /* U+32 "2" */
    0x5, 0xdf, 0xc3, 0x3, 0xfc, 0x8f, 0xe0, 0x8f,
    0x20, 0x9f, 0x10, 0x0, 0xc, 0xe0, 0x0, 0x7,
    0xf6, 0x0, 0x5, 0xf9, 0x0, 0x4, 0xfa, 0x0,
    0x3, 0xff, 0x87, 0x73, 0x6f, 0xff, 0xff, 0x60,

    /* U+33 "3" */
    0x6, 0xef, 0xc3, 0x4, 0xfc, 0x8f, 0xe0, 0x37,
    0x10, 0x9f, 0x20, 0x1, 0x3d, 0xe0, 0x0, 0xbf,
    0xf3, 0x0, 0x3, 0x5d, 0xe1, 0x5a, 0x10, 0x7f,
    0x45, 0xfc, 0x8e, 0xf1, 0x7, 0xef, 0xc4, 0x0,

    /* U+34 "4" */
    0x0, 0x6, 0xf9, 0x0, 0x1, 0xef, 0x90, 0x0,
    0x9f, 0xf9, 0x0, 0x2f, 0x7f, 0x90, 0xb, 0xc1,
    0xf9, 0x4, 0xf5, 0x3f, 0xa1, 0xaf, 0xff, 0xff,
    0x93, 0x55, 0x6f, 0xb2, 0x0, 0x1, 0xf9, 0x0,

    /* U+35 "5" */
    0xb, 0xff, 0xff, 0x10, 0xdd, 0x88, 0x80, 0xf,
    0x90, 0x0, 0x1, 0xfe, 0xff, 0x60, 0x19, 0x85,
    0xdf, 0x10, 0x0, 0x5, 0xf5, 0x3a, 0x30, 0x6f,
    0x51, 0xfd, 0x8e, 0xf1, 0x4, 0xdf, 0xd4, 0x0,

    /* U+36 "6" */
    0x0, 0x4c, 0xf2, 0x0, 0x5f, 0xe9, 0x10, 0xe,
    0xc1, 0x0, 0x4, 0xfd, 0xff, 0x80, 0x5f, 0xc6,
    0xcf, 0x36, 0xf4, 0x4, 0xf6, 0x4f, 0x60, 0x5f,
    0x60, 0xde, 0x8e, 0xf1, 0x2, 0xbf, 0xd4, 0x0,

    /* U+37 "7" */
    0xaf, 0xff, 0xff, 0x64, 0x77, 0x7c, 0xf2, 0x0,
    0x0, 0xdc, 0x0, 0x0, 0x4f, 0x50, 0x0, 0xb,
    0xe0, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x1f, 0xb0, 0x0, 0x7, 0xf4, 0x0, 0x0,

    /* U+38 "8" */
    0x4, 0xdf, 0xc3, 0x1, 0xfe, 0x8f, 0xe0, 0x3f,
    0x70, 0x9f, 0x11, 0xfb, 0x3d, 0xe0, 0x6, 0xff,
    0xf4, 0x2, 0xfb, 0x5d, 0xe1, 0x6f, 0x40, 0x6f,
    0x43, 0xfd, 0x8e, 0xf1, 0x6, 0xdf, 0xd5, 0x0,

    /* U+39 "9" */
    0x4, 0xdf, 0xb1, 0x1, 0xfd, 0x8f, 0xc0, 0x6f,
    0x50, 0x9f, 0x17, 0xf3, 0x7, 0xf3, 0x4f, 0xa2,
    0xbf, 0x30, 0xbf, 0xfe, 0xf2, 0x0, 0x22, 0xcd,
    0x0, 0x19, 0xdf, 0x50, 0x3, 0xfc, 0x50, 0x0,

    /* U+3A ":" */
    0x2e, 0x71, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xe6, 0x2e, 0x70,

    /* U+3B ";" */
    0x3f, 0x52, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x83, 0xf, 0x52, 0xf3, 0x7c, 0x0, 0x10,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x95, 0x3, 0xbf,
    0xf4, 0x9f, 0xe7, 0x10, 0xaf, 0xb5, 0x0, 0x5,
    0xdf, 0xf4, 0x0, 0x4, 0xb5, 0x0, 0x0, 0x0,

    /* U+3D "=" */
    0x3f, 0xff, 0xff, 0x1, 0x88, 0x88, 0x80, 0x18,
    0x88, 0x88, 0x3, 0xff, 0xff, 0xf0,

    /* U+3E ">" */
    0x4a, 0x20, 0x0, 0x3f, 0xfb, 0x40, 0x1, 0x7d,
    0xfb, 0x0, 0x5b, 0xfc, 0x3e, 0xfd, 0x60, 0x4c,
    0x50, 0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x9, 0xee, 0x90, 0x7f, 0xac, 0xf5, 0x69, 0x3,
    0xf7, 0x0, 0xa, 0xf3, 0x0, 0x8f, 0x50, 0x0,
    0xea, 0x0, 0x0, 0x21, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0xe9, 0x0,

    /* U+40 "@" */
    0x0, 0x7, 0xdf, 0xea, 0x20, 0x0, 0xb, 0xc4,
    0x12, 0x7e, 0x20, 0x7, 0xc0, 0x0, 0x0, 0x7b,
    0x0, 0xe4, 0x7, 0xed, 0x40, 0xf0, 0x4e, 0x5,
    0xe4, 0xb8, 0xd, 0x36, 0xb0, 0xc8, 0xc, 0x60,
    0xc3, 0x7a, 0xe, 0x50, 0xd5, 0xe, 0x16, 0xb0,
    0xd8, 0x4f, 0x66, 0xc0, 0x3e, 0x5, 0xeb, 0x6e,
    0xc2, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf8, 0x32, 0x52, 0x0, 0x0, 0x3, 0xbe, 0xfc,
    0x30, 0x0,

    /* U+41 "A" */
    0x0, 0xe, 0xf0, 0x0, 0x0, 0x5, 0xff, 0x60,
    0x0, 0x0, 0xae, 0xdb, 0x0, 0x0, 0xf, 0x98,
    0xf1, 0x0, 0x5, 0xf4, 0x3f, 0x70, 0x0, 0xbf,
    0x98, 0xfc, 0x0, 0x1f, 0xff, 0xff, 0xf2, 0x6,
    0xf5, 0x0, 0x4f, 0x80, 0xcf, 0x10, 0x0, 0xfd,
    0x0,

    /* U+42 "B" */
    0x3f, 0xff, 0xea, 0x10, 0x3f, 0xc8, 0xbf, 0xa0,
    0x3f, 0x80, 0xe, 0xd0, 0x3f, 0x81, 0x4f, 0xa0,
    0x3f, 0xff, 0xff, 0x20, 0x3f, 0xa4, 0x5e, 0xd0,
    0x3f, 0x80, 0xb, 0xf1, 0x3f, 0xc8, 0xaf, 0xd0,
    0x3f, 0xff, 0xfb, 0x20,

    /* U+43 "C" */
    0x1, 0x9e, 0xeb, 0x20, 0xc, 0xfb, 0xaf, 0xd0,
    0x3f, 0x90, 0x7, 0xf5, 0x6f, 0x50, 0x0, 0x20,
    0x7f, 0x40, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x10,
    0x3f, 0x90, 0x7, 0xf5, 0xc, 0xfa, 0xaf, 0xd0,
    0x1, 0xaf, 0xeb, 0x20,

    /* U+44 "D" */
    0x3f, 0xff, 0xd5, 0x0, 0x3f, 0xc9, 0xdf, 0x60,
    0x3f, 0x80, 0xe, 0xe0, 0x3f, 0x80, 0x9, 0xf3,
    0x3f, 0x80, 0x8, 0xf4, 0x3f, 0x80, 0x9, 0xf3,
    0x3f, 0x80, 0xe, 0xe0, 0x3f, 0xc9, 0xdf, 0x60,
    0x3f, 0xff, 0xd5, 0x0,

    /* U+45 "E" */
    0x3f, 0xff, 0xff, 0x73, 0xfc, 0x88, 0x84, 0x3f,
    0x80, 0x0, 0x3, 0xf9, 0x22, 0x20, 0x3f, 0xff,
    0xfe, 0x3, 0xfa, 0x55, 0x40, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x84, 0x3f, 0xff, 0xff, 0x70,

    /* U+46 "F" */
    0x3f, 0xff, 0xff, 0x53, 0xfc, 0x88, 0x82, 0x3f,
    0x80, 0x0, 0x3, 0xfc, 0x88, 0x70, 0x3f, 0xff,
    0xfe, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x9e, 0xfc, 0x30, 0xb, 0xfb, 0x9e, 0xf2,
    0x3f, 0xb0, 0x4, 0xb4, 0x6f, 0x60, 0x11, 0x10,
    0x7f, 0x50, 0xdf, 0xf8, 0x6f, 0x60, 0x47, 0xf8,
    0x2f, 0xb0, 0x4, 0xf8, 0xb, 0xfc, 0x9d, 0xf7,
    0x0, 0x9e, 0xfd, 0x70,

    /* U+48 "H" */
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0xc8, 0x88, 0xfb,
    0x3f, 0xff, 0xff, 0xfb, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0x80, 0x0, 0xfb,

    /* U+49 "I" */
    0x2f, 0xa2, 0xfa, 0x2f, 0xa2, 0xfa, 0x2f, 0xa2,
    0xfa, 0x2f, 0xa2, 0xfa, 0x2f, 0xa0,

    /* U+4A "J" */
    0x0, 0x0, 0xcf, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0xcf, 0x0, 0x0, 0xcf, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0xcf, 0x8c, 0x0, 0xde, 0x7f, 0xba, 0xf9,
    0x9, 0xef, 0xa1,

    /* U+4B "K" */
    0x3f, 0x80, 0xd, 0xf4, 0x3f, 0x80, 0xaf, 0x70,
    0x3f, 0x85, 0xfb, 0x0, 0x3f, 0xaf, 0xe1, 0x0,
    0x3f, 0xff, 0xd0, 0x0, 0x3f, 0xfb, 0xf8, 0x0,
    0x3f, 0x90, 0xdf, 0x20, 0x3f, 0x80, 0x4f, 0xc0,
    0x3f, 0x80, 0xa, 0xf6,

    /* U+4C "L" */
    0x3f, 0x80, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f,
    0x80, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x82, 0x3f, 0xff, 0xff, 0x40,

    /* U+4D "M" */
    0x3f, 0xf3, 0x0, 0xb, 0xfb, 0x3f, 0xf9, 0x0,
    0x1f, 0xfb, 0x3f, 0xee, 0x0, 0x6f, 0xeb, 0x3f,
    0xaf, 0x30, 0xbb, 0xeb, 0x3f, 0x7e, 0x91, 0xf6,
    0xfb, 0x3f, 0x78, 0xe6, 0xf1, 0xfb, 0x3f, 0x83,
    0xfe, 0xb0, 0xfb, 0x3f, 0x80, 0xdf, 0x50, 0xfb,
    0x3f, 0x80, 0x8f, 0x0, 0xfb,

    /* U+4E "N" */
    0x3f, 0xc0, 0x0, 0xfb, 0x3f, 0xf6, 0x0, 0xfb,
    0x3f, 0xfe, 0x0, 0xfb, 0x3f, 0xcf, 0x80, 0xfb,
    0x3f, 0x8a, 0xf3, 0xfb, 0x3f, 0x81, 0xfb, 0xfb,
    0x3f, 0x80, 0x8f, 0xfb, 0x3f, 0x80, 0xe, 0xfb,
    0x3f, 0x80, 0x5, 0xfb,

    /* U+4F "O" */
    0x0, 0x9e, 0xfb, 0x20, 0xb, 0xfb, 0xaf, 0xe1,
    0x3f, 0xa0, 0x6, 0xf7, 0x6f, 0x50, 0x1, 0xfb,
    0x7f, 0x40, 0x0, 0xfc, 0x6f, 0x50, 0x1, 0xfb,
    0x3f, 0xb0, 0x6, 0xf7, 0xb, 0xfb, 0xaf, 0xe1,
    0x0, 0x9e, 0xfb, 0x20,

    /* U+50 "P" */
    0x3f, 0xff, 0xfb, 0x20, 0x3f, 0xc8, 0xaf, 0xe0,
    0x3f, 0x80, 0x9, 0xf4, 0x3f, 0x80, 0x1b, 0xf2,
    0x3f, 0xff, 0xff, 0xa0, 0x3f, 0xc8, 0x74, 0x0,
    0x3f, 0x80, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x0,
    0x3f, 0x80, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x9e, 0xfb, 0x20, 0xb, 0xfb, 0xaf, 0xe0,
    0x3f, 0xa0, 0x6, 0xf7, 0x6f, 0x50, 0x1, 0xfa,
    0x7f, 0x40, 0x0, 0xfc, 0x6f, 0x50, 0x1, 0xfb,
    0x3f, 0xa0, 0x6, 0xf7, 0xb, 0xfb, 0xaf, 0xe0,
    0x0, 0x9e, 0xff, 0xa0, 0x0, 0x0, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x40,

    /* U+52 "R" */
    0x3f, 0xff, 0xeb, 0x20, 0x3f, 0xc8, 0xaf, 0xc0,
    0x3f, 0x80, 0xb, 0xf0, 0x3f, 0x80, 0x1e, 0xe0,
    0x3f, 0xff, 0xff, 0x50, 0x3f, 0xc8, 0xfc, 0x0,
    0x3f, 0x80, 0xaf, 0x30, 0x3f, 0x80, 0x2f, 0xb0,
    0x3f, 0x80, 0xb, 0xf2,

    /* U+53 "S" */
    0x4, 0xcf, 0xe9, 0x1, 0xfe, 0x9b, 0xf9, 0x4f,
    0x70, 0xa, 0xa1, 0xee, 0x71, 0x0, 0x2, 0xbf,
    0xf9, 0x0, 0x0, 0x29, 0xfa, 0x7e, 0x30, 0xd,
    0xe3, 0xfe, 0x8a, 0xfb, 0x4, 0xcf, 0xea, 0x10,

    /* U+54 "T" */
    0xcf, 0xff, 0xff, 0xf3, 0x68, 0xaf, 0xc8, 0x81,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0,

    /* U+55 "U" */
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x4f, 0x70, 0x8, 0xf3,
    0x3f, 0x90, 0xa, 0xf1, 0xd, 0xf9, 0xaf, 0xc0,
    0x2, 0xbe, 0xea, 0x10,

    /* U+56 "V" */
    0xcf, 0x20, 0x4, 0xfa, 0x7f, 0x60, 0x9, 0xf5,
    0x2f, 0xb0, 0xd, 0xf0, 0xc, 0xf0, 0x2f, 0xa0,
    0x7, 0xf3, 0x6f, 0x50, 0x2, 0xf8, 0xaf, 0x0,
    0x0, 0xdc, 0xfa, 0x0, 0x0, 0x7f, 0xf5, 0x0,
    0x0, 0x2f, 0xf0, 0x0,

    /* U+57 "W" */
    0xbf, 0x0, 0x9f, 0x10, 0x8f, 0x37, 0xf3, 0xd,
    0xf5, 0xb, 0xf0, 0x4f, 0x60, 0xff, 0x80, 0xec,
    0x1, 0xf9, 0x4f, 0xcb, 0xf, 0x90, 0xd, 0xc7,
    0xe6, 0xf3, 0xf5, 0x0, 0xaf, 0xba, 0x2f, 0x9f,
    0x20, 0x6, 0xff, 0x70, 0xee, 0xf0, 0x0, 0x3f,
    0xf3, 0xb, 0xfb, 0x0, 0x0, 0xff, 0x0, 0x7f,
    0x80, 0x0,

    /* U+58 "X" */
    0x8f, 0x70, 0xd, 0xf2, 0xe, 0xe0, 0x5f, 0x90,
    0x6, 0xf7, 0xdf, 0x10, 0x0, 0xdf, 0xf7, 0x0,
    0x0, 0x7f, 0xf1, 0x0, 0x0, 0xef, 0xf8, 0x0,
    0x7, 0xf7, 0xdf, 0x10, 0x1f, 0xe0, 0x5f, 0xa0,
    0x9f, 0x60, 0xc, 0xf3,

    /* U+59 "Y" */
    0xbf, 0x20, 0xb, 0xf2, 0x4f, 0x90, 0x2f, 0xa0,
    0xc, 0xf0, 0x9f, 0x20, 0x4, 0xf7, 0xfb, 0x0,
    0x0, 0xcf, 0xf3, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0,

    /* U+5A "Z" */
    0x9f, 0xff, 0xff, 0xd4, 0x88, 0x8c, 0xf8, 0x0,
    0x1, 0xed, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x5f,
    0x90, 0x0, 0x1e, 0xd0, 0x0, 0xa, 0xf4, 0x0,
    0x5, 0xfe, 0x88, 0x87, 0x9f, 0xff, 0xff, 0xe0,

    /* U+5B "[" */
    0x1, 0x10, 0x4f, 0xf3, 0x4f, 0x91, 0x4f, 0x60,
    0x4f, 0x60, 0x4f, 0x60, 0x4f, 0x60, 0x4f, 0x60,
    0x4f, 0x60, 0x4f, 0x60, 0x4f, 0x60, 0x4f, 0x60,
    0x4f, 0x70, 0x4f, 0xf3, 0x14, 0x41,

    /* U+5C "\\" */
    0xde, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x1f, 0x90,
    0x0, 0xc, 0xf0, 0x0, 0x6, 0xf5, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x5f, 0x60,
    0x0, 0xf, 0xc0, 0x0, 0x9, 0xf1,

    /* U+5D "]" */
    0x11, 0x1e, 0xf9, 0x5f, 0x91, 0xf9, 0x1f, 0x91,
    0xf9, 0x1f, 0x91, 0xf9, 0x1f, 0x91, 0xf9, 0x1f,
    0x91, 0xf9, 0x2f, 0x9e, 0xf9, 0x44, 0x20,

    /* U+5E "^" */
    0x0, 0x72, 0x0, 0x6f, 0xa0, 0xc, 0xbf, 0x2,
    0xf2, 0xe6, 0x8c, 0x8, 0xc0,

    /* U+5F "_" */
    0x22, 0x22, 0x20, 0xff, 0xff, 0xf5, 0x55, 0x55,
    0x51,

    /* U+60 "`" */
    0x4f, 0x60, 0x7, 0xe1,

    /* U+61 "a" */
    0x7, 0xef, 0xb1, 0x4, 0xfb, 0x8f, 0x90, 0x25,
    0x10, 0xfc, 0x0, 0x8d, 0xef, 0xc0, 0x7f, 0x62,
    0xec, 0x8, 0xf9, 0x9f, 0xc0, 0x1b, 0xfb, 0xde,
    0x0,

    /* U+62 "b" */
    0x5f, 0x50, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0x5, 0xfb, 0xed, 0x40, 0x5f, 0xd8,
    0xee, 0x5, 0xf5, 0x7, 0xf4, 0x5f, 0x50, 0x5f,
    0x55, 0xf5, 0x7, 0xf4, 0x5f, 0xd8, 0xee, 0x5,
    0xf9, 0xed, 0x40,

    /* U+63 "c" */
    0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f, 0x30,
    0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x56, 0x2f,
    0xc8, 0xfb, 0x5, 0xdf, 0xb1,

    /* U+64 "d" */
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x9f, 0x10, 0x7e, 0xdc, 0xf1, 0x3f, 0xd8,
    0xff, 0x17, 0xf3, 0x9, 0xf1, 0x9f, 0x10, 0x9f,
    0x17, 0xf3, 0x9, 0xf1, 0x3f, 0xc6, 0xef, 0x10,
    0x7e, 0xdb, 0xf1,

    /* U+65 "e" */
    0x4, 0xdf, 0xb1, 0x2, 0xfd, 0x8f, 0xb0, 0x7f,
    0x40, 0x9f, 0x8, 0xff, 0xff, 0xf2, 0x7f, 0x63,
    0x33, 0x1, 0xfe, 0x8b, 0xc0, 0x3, 0xcf, 0xd4,
    0x0,

    /* U+66 "f" */
    0x2, 0xcf, 0x40, 0xbf, 0x92, 0xe, 0xd0, 0xd,
    0xff, 0xf1, 0x4e, 0xe5, 0x0, 0xed, 0x0, 0xe,
    0xd0, 0x0, 0xed, 0x0, 0xe, 0xd0, 0x0, 0xed,
    0x0,

    /* U+67 "g" */
    0x6, 0xee, 0xaf, 0x32, 0xfd, 0x8e, 0xf3, 0x7f,
    0x40, 0x8f, 0x39, 0xf1, 0x8, 0xf3, 0x7f, 0x40,
    0x8f, 0x32, 0xfd, 0x8e, 0xf3, 0x6, 0xee, 0xbf,
    0x30, 0x20, 0xa, 0xf2, 0xe, 0x98, 0xfc, 0x0,
    0x8e, 0xfb, 0x20,

    /* U+68 "h" */
    0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf9, 0xee, 0x50, 0x6f, 0xd8,
    0xfe, 0x6, 0xf4, 0xa, 0xf1, 0x6f, 0x40, 0x9f,
    0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f, 0x16,
    0xf4, 0x9, 0xf1,

    /* U+69 "i" */
    0x2f, 0x52, 0xd4, 0x0, 0x4, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7,

    /* U+6A "j" */
    0x3, 0xf5, 0x2, 0xd4, 0x0, 0x0, 0x4, 0xf7,
    0x4, 0xf7, 0x4, 0xf7, 0x4, 0xf7, 0x4, 0xf7,
    0x4, 0xf7, 0x4, 0xf7, 0x4, 0xf6, 0x4c, 0xf4,
    0x8f, 0x90,

    /* U+6B "k" */
    0x5f, 0x50, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0x5, 0xf5, 0x2f, 0xd1, 0x5f, 0x6d,
    0xf2, 0x5, 0xfe, 0xf5, 0x0, 0x5f, 0xff, 0x60,
    0x5, 0xfa, 0xde, 0x10, 0x5f, 0x54, 0xf9, 0x5,
    0xf5, 0xb, 0xf3,

    /* U+6C "l" */
    0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7,

    /* U+6D "m" */
    0x5f, 0x8d, 0xe6, 0x9f, 0xc2, 0x5f, 0xd8, 0xff,
    0xba, 0xf9, 0x5f, 0x50, 0xaf, 0x0, 0xfb, 0x5f,
    0x50, 0xaf, 0x0, 0xfb, 0x5f, 0x50, 0xaf, 0x0,
    0xfb, 0x5f, 0x50, 0xaf, 0x0, 0xfb, 0x5f, 0x50,
    0xaf, 0x0, 0xfb,

    /* U+6E "n" */
    0x6f, 0x8d, 0xe5, 0x6, 0xfd, 0x8f, 0xe0, 0x6f,
    0x50, 0xaf, 0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50,
    0x9f, 0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50, 0x9f,
    0x10,

    /* U+6F "o" */
    0x4, 0xdf, 0xb2, 0x2, 0xfd, 0x8f, 0xd0, 0x7f,
    0x30, 0x7f, 0x39, 0xf1, 0x5, 0xf5, 0x7f, 0x30,
    0x7f, 0x42, 0xfd, 0x8e, 0xd0, 0x4, 0xdf, 0xc2,
    0x0,

    /* U+70 "p" */
    0x5f, 0xae, 0xd4, 0x5, 0xfc, 0x6e, 0xe0, 0x5f,
    0x50, 0x7f, 0x35, 0xf5, 0x5, 0xf5, 0x5f, 0x50,
    0x7f, 0x35, 0xfd, 0x8e, 0xe0, 0x5f, 0xbe, 0xd4,
    0x5, 0xf5, 0x0, 0x0, 0x5f, 0x50, 0x0, 0x5,
    0xf5, 0x0, 0x0,

    /* U+71 "q" */
    0x7, 0xed, 0xaf, 0x13, 0xfd, 0x8f, 0xf1, 0x8f,
    0x30, 0x9f, 0x19, 0xf1, 0x9, 0xf1, 0x7f, 0x30,
    0x9f, 0x13, 0xfd, 0x8f, 0xf1, 0x7, 0xed, 0xcf,
    0x10, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x9, 0xf1,

    /* U+72 "r" */
    0x0, 0x0, 0x5, 0xfa, 0xe3, 0x5f, 0xfb, 0x25,
    0xf6, 0x0, 0x5f, 0x50, 0x5, 0xf5, 0x0, 0x5f,
    0x50, 0x5, 0xf5, 0x0,

    /* U+73 "s" */
    0x8, 0xee, 0xa0, 0x5f, 0x97, 0xf8, 0x5f, 0x81,
    0x32, 0x9, 0xff, 0xc2, 0x24, 0x5, 0xfa, 0x7f,
    0x86, 0xf9, 0x8, 0xef, 0xa1,

    /* U+74 "t" */
    0x8, 0x50, 0xf, 0xa0, 0xff, 0xfc, 0x5f, 0xc4,
    0xf, 0xa0, 0xf, 0xa0, 0xf, 0xa0, 0xf, 0xe7,
    0x7, 0xfb,

    /* U+75 "u" */
    0x6f, 0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f,
    0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x5f, 0x50,
    0x9f, 0x13, 0xfc, 0x8f, 0xf1, 0x9, 0xfd, 0xbf,
    0x10,

    /* U+76 "v" */
    0xcf, 0x0, 0xed, 0x7f, 0x32, 0xf8, 0x2f, 0x76,
    0xf3, 0xd, 0xba, 0xe0, 0x8, 0xfe, 0x90, 0x3,
    0xff, 0x40, 0x0, 0xef, 0x0,

    /* U+77 "w" */
    0xbe, 0x5, 0xf2, 0x1f, 0x87, 0xf1, 0x9f, 0x64,
    0xf4, 0x4f, 0x4d, 0xfa, 0x7f, 0x0, 0xf9, 0xf8,
    0xea, 0xd0, 0xc, 0xfd, 0x1f, 0xf9, 0x0, 0x9f,
    0x90, 0xdf, 0x50, 0x5, 0xf5, 0x8, 0xf2, 0x0,

    /* U+78 "x" */
    0x8f, 0x42, 0xfa, 0x1, 0xfc, 0xaf, 0x20, 0x7,
    0xff, 0x90, 0x0, 0x2f, 0xf4, 0x0, 0x9, 0xff,
    0xb0, 0x1, 0xfb, 0x9f, 0x30, 0x9f, 0x31, 0xfc,
    0x0,

    /* U+79 "y" */
    0xdf, 0x0, 0xed, 0x8f, 0x43, 0xf8, 0x3f, 0x88,
    0xf3, 0xe, 0xcc, 0xe0, 0x9, 0xff, 0x90, 0x4,
    0xff, 0x40, 0x0, 0xff, 0x0, 0x0, 0xea, 0x0,
    0x2b, 0xf5, 0x0, 0x4f, 0xa0, 0x0,

    /* U+7A "z" */
    0x7f, 0xff, 0xf9, 0x37, 0x7d, 0xf5, 0x0, 0x4f,
    0xa0, 0x0, 0xee, 0x10, 0xa, 0xf4, 0x0, 0x4f,
    0xe7, 0x75, 0x9f, 0xff, 0xfb,

    /* U+7B "{" */
    0x0, 0x24, 0x2, 0xf7, 0x9, 0xe0, 0xa, 0xd0,
    0xa, 0xd0, 0x1e, 0xa0, 0xbf, 0x20, 0x3e, 0x90,
    0xb, 0xd0, 0xa, 0xd0, 0x9, 0xe0, 0x3, 0xf6,
    0x0, 0x46,

    /* U+7C "|" */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0,

    /* U+7D "}" */
    0x52, 0x0, 0x8f, 0x20, 0xf, 0x80, 0xe, 0xa0,
    0xe, 0xa0, 0xb, 0xd1, 0x2, 0xfb, 0xa, 0xe3,
    0xd, 0xa0, 0xe, 0xa0, 0xf, 0x80, 0x6f, 0x30,
    0x64, 0x0,

    /* U+7E "~" */
    0x8, 0xfa, 0x3, 0xf1, 0x2f, 0x9e, 0xcb, 0xe0,
    0x39, 0x2, 0xce, 0x40,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0x1e, 0x71, 0xe6, 0x0, 0x0, 0x62, 0xf, 0x61,
    0xf7, 0x1f, 0x72, 0xf8, 0x2f, 0x83, 0xf9,

    /* U+A2 "¢" */
    0x0, 0x1f, 0x10, 0x0, 0x7, 0xf7, 0x0, 0xb,
    0xfe, 0xfa, 0x3, 0xf8, 0xa, 0xf0, 0x5f, 0x40,
    0x1, 0x5, 0xf5, 0x0, 0x0, 0x2f, 0x90, 0x9f,
    0x0, 0xaf, 0xff, 0x90, 0x0, 0x6f, 0x60, 0x0,
    0x1, 0xf1, 0x0,

    /* U+A3 "£" */
    0x0, 0x7e, 0xe9, 0x0, 0x4f, 0xca, 0xf8, 0x8,
    0xf3, 0xa, 0x70, 0x8f, 0x30, 0x0, 0x6f, 0xff,
    0xf1, 0x3, 0xbf, 0xa8, 0x0, 0x7, 0xf4, 0x0,
    0x3, 0xdf, 0x98, 0x86, 0x6f, 0xff, 0xff, 0xc0,

    /* U+A4 "¤" */
    0x0, 0x0, 0x0, 0x0, 0x4d, 0x7e, 0xfa, 0x99,
    0xd, 0xd5, 0x3b, 0xf4, 0x1f, 0x20, 0x0, 0xd6,
    0x4d, 0x0, 0x0, 0x79, 0x4d, 0x0, 0x0, 0x89,
    0x1f, 0x20, 0x0, 0xd5, 0x1e, 0xe5, 0x4b, 0xf5,
    0x3b, 0x7e, 0xea, 0x78, 0x0, 0x0, 0x0, 0x0,

    /* U+A5 "¥" */
    0xbf, 0x10, 0xaf, 0x23, 0xf7, 0xf, 0xa0, 0xc,
    0xd6, 0xf3, 0x0, 0x4f, 0xeb, 0x0, 0x7f, 0xff,
    0xfb, 0x1, 0x2b, 0xf3, 0x10, 0x7f, 0xff, 0xfb,
    0x1, 0x2b, 0xf3, 0x10, 0x0, 0xbf, 0x10, 0x0,

    /* U+A6 "¦" */
    0x4f, 0x44, 0xf4, 0x4f, 0x44, 0xf4, 0x3d, 0x30,
    0x10, 0x4f, 0x44, 0xf4, 0x4f, 0x44, 0xf4, 0x4f,
    0x40,

    /* U+A7 "§" */
    0x4, 0xcf, 0xe8, 0x1, 0xfe, 0x8b, 0xf7, 0x3f,
    0x70, 0xa, 0x81, 0xef, 0x94, 0x0, 0xc, 0xef,
    0xfe, 0x35, 0xf5, 0x6, 0xfc, 0x5f, 0xb2, 0xd,
    0xd0, 0xaf, 0xfe, 0xf5, 0x0, 0x38, 0xef, 0x63,
    0xa3, 0x0, 0xfb, 0x3f, 0xd8, 0xaf, 0x80, 0x5d,
    0xfe, 0x90,

    /* U+A8 "¨" */
    0x17, 0x3, 0x60, 0x4e, 0x6, 0xd0,

    /* U+A9 "©" */
    0x0, 0x2a, 0xcb, 0x50, 0x0, 0x4b, 0x20, 0x9,
    0x80, 0xc, 0x8, 0xda, 0xa, 0x34, 0x74, 0xb0,
    0x86, 0x29, 0x74, 0x77, 0x0, 0x10, 0xb7, 0x47,
    0x70, 0x0, 0xb, 0x47, 0x4b, 0x8, 0x72, 0x90,
    0xc0, 0x8d, 0xb0, 0x93, 0x4, 0xb2, 0x0, 0x88,
    0x0, 0x3, 0xac, 0xb5, 0x0,

    /* U+AA "ª" */
    0x9, 0xec, 0x10, 0x80, 0xa5, 0x8, 0xbd, 0x62,
    0xe0, 0xa6, 0xc, 0xdd, 0x80,

    /* U+AB "«" */
    0x0, 0x10, 0x0, 0x4, 0xd1, 0xe2, 0x1e, 0x5b,
    0x90, 0x6e, 0x2f, 0x20, 0xd, 0x5a, 0x90, 0x3,
    0xd1, 0xe2,

    /* U+AC "¬" */
    0x4f, 0xff, 0xf9, 0x2, 0x22, 0x9a, 0x0, 0x0,
    0x56,

    /* U+AD "­" */
    0x2, 0x22, 0x5f, 0xff, 0x15, 0x54,

    /* U+AE "®" */
    0x0, 0x2a, 0xcb, 0x50, 0x0, 0x4b, 0x20, 0x9,
    0x80, 0xc, 0x1e, 0xda, 0xa, 0x34, 0x71, 0xd0,
    0x86, 0x29, 0x74, 0x1d, 0x8, 0x60, 0xb7, 0x41,
    0xfd, 0xf1, 0xb, 0x47, 0x1d, 0x8, 0x62, 0x90,
    0xc1, 0xb0, 0x57, 0x93, 0x4, 0xb2, 0x0, 0x88,
    0x0, 0x3, 0xac, 0xb5, 0x0,

    /* U+AF "¯" */
    0xf, 0xff, 0xf0, 0x1, 0x11, 0x10,

    /* U+B0 "°" */
    0x9, 0xe4, 0x2c, 0x2d, 0x2c, 0x2d, 0x9, 0xe4,

    /* U+B1 "±" */
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x8f,
    0x0, 0x7f, 0xff, 0xfe, 0x48, 0xcf, 0x87, 0x0,
    0x8f, 0x0, 0x0, 0x8f, 0x0, 0x28, 0x88, 0x85,
    0x5f, 0xff, 0xfb,

    /* U+B2 "²" */
    0x3d, 0xf7, 0x5, 0x66, 0xd0, 0x1, 0xd9, 0x1,
    0xc9, 0x0, 0x8f, 0xff, 0x0,

    /* U+B3 "³" */
    0x4e, 0xf7, 0x3, 0x35, 0xe0, 0x5, 0xe8, 0x4,
    0x44, 0xf0, 0x4e, 0xf8, 0x0,

    /* U+B4 "´" */
    0x8, 0xf3, 0x2f, 0x60,

    /* U+B5 "µ" */
    0x3f, 0x80, 0x3f, 0x73, 0xf8, 0x3, 0xf7, 0x3f,
    0x80, 0x3f, 0x73, 0xf8, 0x3, 0xf7, 0x3f, 0x80,
    0x3f, 0x73, 0xfe, 0x6b, 0xf7, 0x3f, 0xff, 0xcf,
    0x73, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x3,
    0xf8, 0x0, 0x0,

    /* U+B6 "¶" */
    0x5, 0xdf, 0xf1, 0x3f, 0xff, 0xf1, 0x7f, 0xff,
    0xf1, 0x7f, 0xff, 0xf1, 0x2f, 0xff, 0xf1, 0x5,
    0xcf, 0xf1, 0x0, 0x3, 0xf1, 0x0, 0x3, 0xf1,
    0x0, 0x3, 0xf1,

    /* U+B7 "·" */
    0xd, 0x81, 0xe8,

    /* U+B8 "¸" */
    0x5f, 0x40, 0xbc, 0x3f, 0x60, 0x0,

    /* U+B9 "¹" */
    0x2, 0x70, 0x3e, 0xf1, 0x1, 0xf1, 0x1, 0xf1,
    0x1, 0xf1,

    /* U+BA "º" */
    0x8, 0xec, 0x12, 0xe0, 0x79, 0x4b, 0x4, 0xb2,
    0xd0, 0x79, 0x8, 0xdc, 0x20,

    /* U+BB "»" */
    0x0, 0x1, 0x0, 0x3e, 0x1d, 0x40, 0xa, 0xa5,
    0xe0, 0x3, 0xf1, 0xe6, 0xa, 0x95, 0xd0, 0x3d,
    0x1e, 0x30,

    /* U+BC "¼" */
    0x0, 0x10, 0x0, 0x0, 0x3, 0xce, 0x0, 0x3,
    0x0, 0x39, 0xe0, 0x8, 0x90, 0x0, 0x4e, 0x1,
    0xe1, 0x0, 0x4, 0xe0, 0xa7, 0x0, 0x0, 0x3b,
    0x3d, 0x1d, 0xa0, 0x0, 0xc, 0x58, 0xfa, 0x0,
    0x5, 0xb3, 0xd9, 0xa0, 0x0, 0xd3, 0xaf, 0xff,
    0x20, 0x2, 0x1, 0x2a, 0xa0,

    /* U+BD "½" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xac, 0x0, 0x10,
    0x0, 0x5b, 0xc0, 0xa, 0x60, 0x0, 0x6c, 0x4,
    0xd0, 0x0, 0x6, 0xc0, 0xd4, 0x0, 0x0, 0x5b,
    0x6a, 0x6d, 0xb1, 0x0, 0x1e, 0x2c, 0x3c, 0x70,
    0x9, 0x80, 0x5, 0xf3, 0x2, 0xe0, 0x4, 0xe5,
    0x0, 0x2, 0x0, 0xff, 0xf9, 0x0, 0x0, 0x1,
    0x11, 0x10,

    /* U+BE "¾" */
    0xb, 0xea, 0x0, 0x0, 0x0, 0x27, 0x3f, 0x20,
    0x68, 0x0, 0x1, 0xfc, 0x0, 0xe2, 0x0, 0x49,
    0xf, 0x49, 0x80, 0x0, 0x1b, 0xda, 0x3e, 0x1d,
    0x80, 0x0, 0x0, 0xc5, 0x9f, 0x90, 0x0, 0x5,
    0xc4, 0xca, 0x90, 0x0, 0xe, 0x2b, 0xff, 0xf1,
    0x0, 0x2, 0x1, 0x2a, 0x90,

    /* U+BF "¿" */
    0x0, 0x8d, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xad, 0x0, 0x2, 0xfb, 0x0, 0xd,
    0xf2, 0x0, 0x6f, 0x60, 0x0, 0x8f, 0x20, 0x96,
    0x5f, 0xbb, 0xf7, 0x8, 0xee, 0x90,

    /* U+C0 "À" */
    0x0, 0xae, 0x10, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C1 "Á" */
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x7e, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C2 "Â" */
    0x0, 0x5, 0x60, 0x0, 0x0, 0xa, 0xba, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C3 "Ã" */
    0x0, 0x9d, 0x2d, 0x30, 0x0, 0x1f, 0x4e, 0xd0,
    0x0, 0x0, 0x20, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C4 "Ä" */
    0x0, 0x81, 0x18, 0x0, 0x0, 0x1e, 0x42, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C5 "Å" */
    0x0, 0x19, 0x92, 0x0, 0x0, 0x1, 0x99, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+C6 "Æ" */
    0x0, 0x0, 0xaf, 0xff, 0xff, 0x90, 0x0, 0x2f,
    0xff, 0x88, 0x84, 0x0, 0xa, 0xfb, 0xf1, 0x0,
    0x0, 0x2, 0xf9, 0x8f, 0x98, 0x80, 0x0, 0xaf,
    0x28, 0xff, 0xff, 0x10, 0x3f, 0xe9, 0xcf, 0x30,
    0x0, 0xb, 0xff, 0xff, 0xf4, 0x0, 0x3, 0xfb,
    0x0, 0x6f, 0xa8, 0x87, 0xbf, 0x30, 0x5, 0xff,
    0xff, 0xe0,

    /* U+C7 "Ç" */
    0x1, 0x9e, 0xeb, 0x20, 0xc, 0xfb, 0xaf, 0xd0,
    0x3f, 0x90, 0x7, 0xf5, 0x6f, 0x50, 0x0, 0x20,
    0x7f, 0x40, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x10,
    0x3f, 0x90, 0x7, 0xf5, 0xc, 0xfa, 0xaf, 0xd0,
    0x1, 0xaf, 0xfb, 0x20, 0x0, 0x9, 0xe2, 0x0,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0x8, 0xc1, 0x0,

    /* U+C8 "È" */
    0x1, 0xea, 0x0, 0x0, 0x4, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+C9 "É" */
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+CA "Ê" */
    0x0, 0x4f, 0xa0, 0x0, 0x3e, 0x5c, 0x80, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+CB "Ë" */
    0x2, 0x70, 0x36, 0x0, 0x5d, 0x7, 0xc0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+CC "Ì" */
    0x1e, 0xb0, 0x3, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x2, 0xfa, 0x2, 0xfa, 0x2, 0xfa, 0x2, 0xfa,
    0x2, 0xfa, 0x2, 0xfa, 0x2, 0xfa, 0x2, 0xfa,

    /* U+CD "Í" */
    0x3, 0xf8, 0xc, 0xb0, 0x0, 0x0, 0x2f, 0xa0,
    0x2f, 0xa0, 0x2f, 0xa0, 0x2f, 0xa0, 0x2f, 0xa0,
    0x2f, 0xa0, 0x2f, 0xa0, 0x2f, 0xa0, 0x2f, 0xa0,

    /* U+CE "Î" */
    0x3, 0xfa, 0x2, 0xe5, 0xc9, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0, 0x2,
    0xfa, 0x0, 0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f,
    0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0,

    /* U+CF "Ï" */
    0x27, 0x3, 0x65, 0xe0, 0x7c, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0, 0x2,
    0xfa, 0x0, 0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f,
    0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0,

    /* U+D0 "Ð" */
    0x1, 0xff, 0xfd, 0x70, 0x0, 0x1f, 0xd9, 0xcf,
    0x90, 0x1, 0xfb, 0x0, 0xcf, 0x10, 0x1f, 0xb0,
    0x6, 0xf5, 0x1f, 0xff, 0xf0, 0x5f, 0x70, 0x3f,
    0xc2, 0x6, 0xf5, 0x1, 0xfb, 0x0, 0xcf, 0x10,
    0x1f, 0xd8, 0xcf, 0x90, 0x1, 0xff, 0xfd, 0x70,
    0x0,

    /* U+D1 "Ñ" */
    0x0, 0x6e, 0x3a, 0x60, 0x0, 0xd5, 0xce, 0x10,
    0x0, 0x20, 0x1, 0x0, 0x3f, 0xc0, 0x0, 0xfb,
    0x3f, 0xf6, 0x0, 0xfb, 0x3f, 0xfe, 0x0, 0xfb,
    0x3f, 0xcf, 0x80, 0xfb, 0x3f, 0x8a, 0xf3, 0xfb,
    0x3f, 0x81, 0xfb, 0xfb, 0x3f, 0x80, 0x8f, 0xfb,
    0x3f, 0x80, 0xe, 0xfb, 0x3f, 0x80, 0x5, 0xfb,

    /* U+D2 "Ò" */
    0x0, 0x9f, 0x20, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+D3 "Ó" */
    0x0, 0x0, 0xcd, 0x10, 0x0, 0x6, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+D4 "Ô" */
    0x0, 0xc, 0xe2, 0x0, 0x0, 0xba, 0x7d, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+D5 "Õ" */
    0x0, 0x7d, 0x2c, 0x40, 0x0, 0xf4, 0xee, 0x0,
    0x0, 0x20, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+D6 "Ö" */
    0x0, 0x72, 0x8, 0x10, 0x0, 0xd5, 0x1e, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+D7 "×" */
    0x2, 0x0, 0x10, 0x5f, 0x30, 0xda, 0xc, 0xec,
    0xf3, 0x1, 0xff, 0x60, 0x9, 0xff, 0xd1, 0x6f,
    0x73, 0xfb, 0x6, 0x0, 0x43,

    /* U+D8 "Ø" */
    0x0, 0x0, 0x0, 0xb5, 0x0, 0x8e, 0xfb, 0xe0,
    0xa, 0xfc, 0xaf, 0xe1, 0x2f, 0xb0, 0x2f, 0xf8,
    0x6f, 0x60, 0xb7, 0xfb, 0x7f, 0x54, 0xc0, 0xfc,
    0x6f, 0x6d, 0x30, 0xfb, 0x2f, 0xf9, 0x5, 0xf8,
    0xa, 0xfc, 0xaf, 0xe1, 0x9, 0xce, 0xfb, 0x20,
    0x7, 0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0xcd, 0x0, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+DA "Ú" */
    0x0, 0x1, 0xea, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+DB "Û" */
    0x0, 0x2e, 0xc0, 0x0, 0x1, 0xd7, 0xab, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+DC "Ü" */
    0x1, 0x80, 0x17, 0x0, 0x2, 0xe2, 0x4e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+DD "Ý" */
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0xb, 0xf2,
    0x4f, 0x90, 0x2f, 0xa0, 0xc, 0xf0, 0x9f, 0x20,
    0x4, 0xf7, 0xfb, 0x0, 0x0, 0xcf, 0xf3, 0x0,
    0x0, 0x5f, 0xb0, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+DE "Þ" */
    0x3f, 0x70, 0x0, 0x3, 0xf8, 0x21, 0x0, 0x3f,
    0xff, 0xfb, 0x13, 0xfa, 0x58, 0xfa, 0x3f, 0x70,
    0xd, 0xe3, 0xf8, 0x25, 0xfb, 0x3f, 0xff, 0xfe,
    0x33, 0xfa, 0x53, 0x0, 0x3f, 0x70, 0x0, 0x0,

    /* U+DF "ß" */
    0x3, 0xcf, 0xc3, 0x0, 0xe, 0xe8, 0xfd, 0x0,
    0x2f, 0x80, 0xaf, 0x0, 0x3f, 0x70, 0xec, 0x0,
    0x3f, 0x73, 0xf7, 0x0, 0x3f, 0x71, 0xfd, 0x10,
    0x3f, 0x70, 0x5f, 0xc0, 0x3f, 0x70, 0xa, 0xf1,
    0x3f, 0x77, 0x6d, 0xf0, 0x3f, 0x7d, 0xfd, 0x40,

    /* U+E0 "à" */
    0x8, 0xf3, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e, 0xfb, 0x10, 0x4f, 0xb8,
    0xf9, 0x2, 0x51, 0xf, 0xc0, 0x8, 0xde, 0xfc,
    0x7, 0xf6, 0x2e, 0xc0, 0x8f, 0x99, 0xfc, 0x1,
    0xbf, 0xbd, 0xe0,

    /* U+E1 "á" */
    0x0, 0xb, 0xe1, 0x0, 0x4, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e, 0xfb, 0x10, 0x4f, 0xb8,
    0xf9, 0x2, 0x51, 0xf, 0xc0, 0x8, 0xde, 0xfc,
    0x7, 0xf6, 0x2e, 0xc0, 0x8f, 0x99, 0xfc, 0x1,
    0xbf, 0xbd, 0xe0,

    /* U+E2 "â" */
    0x0, 0xbf, 0x30, 0x0, 0xab, 0x5e, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x7e, 0xfb, 0x10, 0x4f, 0xb8,
    0xf9, 0x2, 0x51, 0xf, 0xc0, 0x8, 0xde, 0xfc,
    0x7, 0xf6, 0x2e, 0xc0, 0x8f, 0x99, 0xfc, 0x1,
    0xbf, 0xbd, 0xe0,

    /* U+E3 "ã" */
    0x7, 0xe3, 0xa5, 0x0, 0xe5, 0xde, 0x10, 0x2,
    0x0, 0x0, 0x0, 0x7e, 0xfb, 0x10, 0x4f, 0xb8,
    0xf9, 0x2, 0x51, 0xf, 0xc0, 0x8, 0xde, 0xfc,
    0x7, 0xf6, 0x2e, 0xc0, 0x8f, 0x99, 0xfc, 0x1,
    0xbf, 0xbd, 0xe0,

    /* U+E4 "ä" */
    0xc, 0x60, 0xe4, 0x0, 0x63, 0x7, 0x20, 0x7,
    0xef, 0xb1, 0x4, 0xfb, 0x8f, 0x90, 0x25, 0x10,
    0xfc, 0x0, 0x8d, 0xef, 0xc0, 0x7f, 0x62, 0xec,
    0x8, 0xf9, 0x9f, 0xc0, 0x1b, 0xfb, 0xde, 0x0,

    /* U+E5 "å" */
    0x0, 0x7a, 0x20, 0x0, 0xb, 0x37, 0x0, 0x0,
    0x7a, 0x20, 0x0, 0x0, 0x0, 0x0, 0x7, 0xef,
    0xb1, 0x4, 0xfb, 0x8f, 0x90, 0x25, 0x10, 0xfc,
    0x0, 0x8d, 0xef, 0xc0, 0x7f, 0x62, 0xec, 0x8,
    0xf9, 0x9f, 0xc0, 0x1b, 0xfb, 0xde, 0x0,

    /* U+E6 "æ" */
    0x6, 0xdf, 0xb7, 0xee, 0x90, 0x3f, 0xc9, 0xff,
    0xc9, 0xf7, 0x13, 0x0, 0xcf, 0x10, 0xeb, 0x1a,
    0xff, 0xff, 0xff, 0xfd, 0x8f, 0x73, 0xcf, 0x43,
    0x32, 0x8f, 0xa8, 0xef, 0xc7, 0xa5, 0x1b, 0xfd,
    0x76, 0xdf, 0xc4,

    /* U+E7 "ç" */
    0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f, 0x30,
    0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x46, 0x2f,
    0xc8, 0xfb, 0x5, 0xef, 0xb1, 0x0, 0x6f, 0x40,
    0x0, 0xd, 0xa0, 0x0, 0x5d, 0x30,

    /* U+E8 "è" */
    0x8, 0xf2, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+E9 "é" */
    0x0, 0xc, 0xe1, 0x0, 0x5, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+EA "ê" */
    0x0, 0xbf, 0x20, 0x0, 0xab, 0x6d, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+EB "ë" */
    0xd, 0x61, 0xe4, 0x0, 0x72, 0x8, 0x10, 0x4,
    0xdf, 0xb1, 0x2, 0xfd, 0x8f, 0xb0, 0x7f, 0x40,
    0x9f, 0x8, 0xff, 0xff, 0xf2, 0x7f, 0x63, 0x33,
    0x1, 0xfe, 0x8b, 0xc0, 0x3, 0xcf, 0xd4, 0x0,

    /* U+EC "ì" */
    0x2f, 0x90, 0x4, 0xf3, 0x0, 0x0, 0x3, 0xf7,
    0x3, 0xf7, 0x3, 0xf7, 0x3, 0xf7, 0x3, 0xf7,
    0x3, 0xf7, 0x3, 0xf7,

    /* U+ED "í" */
    0x4, 0xf6, 0xd, 0x90, 0x0, 0x0, 0x3f, 0x70,
    0x3f, 0x70, 0x3f, 0x70, 0x3f, 0x70, 0x3f, 0x70,
    0x3f, 0x70, 0x3f, 0x70,

    /* U+EE "î" */
    0x5, 0xf9, 0x3, 0xe4, 0xc7, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f, 0x70, 0x3,
    0xf7, 0x0, 0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f,
    0x70,

    /* U+EF "ï" */
    0x6d, 0x8, 0xb3, 0x70, 0x45, 0x3, 0xf7, 0x0,
    0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f, 0x70, 0x3,
    0xf7, 0x0, 0x3f, 0x70, 0x3, 0xf7, 0x0,

    /* U+F0 "ð" */
    0x4, 0xc6, 0x13, 0x0, 0x5e, 0xff, 0x50, 0x0,
    0x9e, 0xf8, 0x0, 0x3, 0x1d, 0xf1, 0x7, 0xff,
    0xef, 0x53, 0xfc, 0x5a, 0xf7, 0x6f, 0x40, 0x3f,
    0x76, 0xf4, 0x6, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+F1 "ñ" */
    0x5, 0xe5, 0x88, 0x0, 0xc6, 0xbf, 0x20, 0x2,
    0x0, 0x10, 0x6, 0xf8, 0xde, 0x50, 0x6f, 0xd8,
    0xfe, 0x6, 0xf5, 0xa, 0xf1, 0x6f, 0x50, 0x9f,
    0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50, 0x9f, 0x16,
    0xf5, 0x9, 0xf1,

    /* U+F2 "ò" */
    0x5, 0xf5, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+F3 "ó" */
    0x0, 0x9, 0xf3, 0x0, 0x2, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+F4 "ô" */
    0x0, 0x9f, 0x50, 0x0, 0x7d, 0x4e, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+F5 "õ" */
    0x4, 0xe5, 0x88, 0x0, 0xb6, 0xbf, 0x20, 0x2,
    0x0, 0x10, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+F6 "ö" */
    0xa, 0x80, 0xc6, 0x0, 0x54, 0x6, 0x30, 0x4,
    0xdf, 0xb2, 0x2, 0xfd, 0x8f, 0xd0, 0x7f, 0x30,
    0x7f, 0x39, 0xf1, 0x5, 0xf5, 0x7f, 0x30, 0x7f,
    0x42, 0xfd, 0x8e, 0xd0, 0x4, 0xdf, 0xc2, 0x0,

    /* U+F7 "÷" */
    0x0, 0x6f, 0x20, 0x0, 0x5, 0xd2, 0x0, 0x12,
    0x22, 0x22, 0xa, 0xff, 0xff, 0xf6, 0x35, 0x55,
    0x55, 0x20, 0x5, 0xd2, 0x0, 0x0, 0x5e, 0x30,
    0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x4a, 0x0, 0x4d, 0xfe, 0x50, 0x2f,
    0xda, 0xfe, 0x7, 0xf3, 0x9c, 0xf4, 0x9f, 0x2d,
    0x5f, 0x57, 0xfb, 0x67, 0xf4, 0x2f, 0xf9, 0xed,
    0x0, 0x8e, 0xfc, 0x20, 0xc, 0x10, 0x0, 0x0,

    /* U+F9 "ù" */
    0x6, 0xf5, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+FA "ú" */
    0x0, 0x9, 0xf2, 0x0, 0x3, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+FB "û" */
    0x0, 0x9f, 0x50, 0x0, 0x7b, 0x3d, 0x30, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+FC "ü" */
    0xb, 0x80, 0xd6, 0x0, 0x54, 0x7, 0x30, 0x6f,
    0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x5f, 0x50, 0x9f,
    0x13, 0xfc, 0x8f, 0xf1, 0x9, 0xfd, 0xbf, 0x10,

    /* U+FD "ý" */
    0x0, 0xd, 0xc0, 0x0, 0x7e, 0x10, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0xed, 0x8f, 0x43, 0xf8, 0x3f,
    0x88, 0xf3, 0xe, 0xcc, 0xe0, 0x9, 0xff, 0x90,
    0x4, 0xff, 0x40, 0x0, 0xff, 0x0, 0x0, 0xea,
    0x0, 0x2b, 0xf5, 0x0, 0x4f, 0xa0, 0x0,

    /* U+FE "þ" */
    0x5f, 0x50, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0x5, 0xfb, 0xed, 0x40, 0x5f, 0xd8,
    0xee, 0x5, 0xf5, 0x7, 0xf4, 0x5f, 0x50, 0x5f,
    0x55, 0xf5, 0x7, 0xf4, 0x5f, 0xd8, 0xee, 0x5,
    0xfb, 0xed, 0x40, 0x5f, 0x50, 0x0, 0x5, 0xf5,
    0x0, 0x0, 0x5f, 0x50, 0x0, 0x0,

    /* U+FF "ÿ" */
    0x1e, 0x43, 0xe2, 0x8, 0x11, 0x80, 0xdf, 0x0,
    0xed, 0x8f, 0x43, 0xf8, 0x3f, 0x88, 0xf3, 0xe,
    0xcc, 0xe0, 0x9, 0xff, 0x90, 0x4, 0xff, 0x40,
    0x0, 0xff, 0x0, 0x0, 0xea, 0x0, 0x2b, 0xf5,
    0x0, 0x4f, 0xa0, 0x0,

    /* U+100 "Ā" */
    0x0, 0xef, 0xff, 0x10, 0x0, 0x1, 0x22, 0x20,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x5, 0xff,
    0x60, 0x0, 0x0, 0xae, 0xdb, 0x0, 0x0, 0xf,
    0x98, 0xf1, 0x0, 0x5, 0xf4, 0x3f, 0x70, 0x0,
    0xbf, 0x98, 0xfc, 0x0, 0x1f, 0xff, 0xff, 0xf2,
    0x6, 0xf5, 0x0, 0x4f, 0x80, 0xcf, 0x10, 0x0,
    0xfd, 0x0,

    /* U+101 "ā" */
    0xc, 0xff, 0xf4, 0x0, 0x1, 0x11, 0x0, 0x7,
    0xef, 0xb1, 0x4, 0xfb, 0x8f, 0x90, 0x25, 0x10,
    0xfc, 0x0, 0x8d, 0xef, 0xc0, 0x7f, 0x62, 0xec,
    0x8, 0xf9, 0x9f, 0xc0, 0x1b, 0xfb, 0xde, 0x0,

    /* U+102 "Ă" */
    0x0, 0xb4, 0x3c, 0x0, 0x0, 0x6, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0xa,
    0xed, 0xb0, 0x0, 0x0, 0xf9, 0x8f, 0x10, 0x0,
    0x5f, 0x43, 0xf7, 0x0, 0xb, 0xf9, 0x8f, 0xc0,
    0x1, 0xff, 0xff, 0xff, 0x20, 0x6f, 0x50, 0x4,
    0xf8, 0xc, 0xf1, 0x0, 0xf, 0xd0,

    /* U+103 "ă" */
    0xb, 0x91, 0xf2, 0x0, 0x3e, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e, 0xfb, 0x10, 0x4f, 0xb8,
    0xf9, 0x2, 0x51, 0xf, 0xc0, 0x8, 0xde, 0xfc,
    0x7, 0xf6, 0x2e, 0xc0, 0x8f, 0x99, 0xfc, 0x1,
    0xbf, 0xbd, 0xe0,

    /* U+104 "Ą" */
    0x0, 0xe, 0xf0, 0x0, 0x0, 0x5, 0xff, 0x60,
    0x0, 0x0, 0xaf, 0xeb, 0x0, 0x0, 0xf, 0xba,
    0xf1, 0x0, 0x5, 0xf6, 0x5f, 0x70, 0x0, 0xbf,
    0x11, 0xfc, 0x0, 0x1f, 0xff, 0xff, 0xf2, 0x6,
    0xfb, 0x88, 0xbf, 0x80, 0xcf, 0x10, 0x1, 0xfd,
    0x0, 0x0, 0x0, 0x4e, 0x20, 0x0, 0x0, 0x9,
    0xc1, 0x0, 0x0, 0x0, 0x4f, 0x80,

    /* U+105 "ą" */
    0x7, 0xef, 0xb1, 0x4, 0xfb, 0x8f, 0x90, 0x25,
    0x10, 0xfc, 0x0, 0x8d, 0xef, 0xc0, 0x7f, 0x62,
    0xec, 0x8, 0xf9, 0x9f, 0xc0, 0x1b, 0xfb, 0xde,
    0x0, 0x0, 0x2f, 0x30, 0x0, 0x6, 0xe2, 0x0,
    0x0, 0x2e, 0xb0,

    /* U+106 "Ć" */
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x7, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xeb, 0x20,
    0xc, 0xfb, 0xaf, 0xd0, 0x3f, 0x90, 0x7, 0xf5,
    0x6f, 0x50, 0x0, 0x20, 0x7f, 0x40, 0x0, 0x0,
    0x6f, 0x50, 0x0, 0x10, 0x3f, 0x90, 0x7, 0xf5,
    0xc, 0xfa, 0xaf, 0xd0, 0x1, 0xaf, 0xeb, 0x20,

    /* U+107 "ć" */
    0x0, 0xd, 0xd0, 0x0, 0x6e, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f,
    0x30, 0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x56,
    0x2f, 0xc8, 0xfb, 0x5, 0xdf, 0xb1,

    /* U+108 "Ĉ" */
    0x0, 0x1d, 0xd1, 0x0, 0x0, 0xc9, 0x8c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xeb, 0x20,
    0xc, 0xfb, 0xaf, 0xd0, 0x3f, 0x90, 0x7, 0xf5,
    0x6f, 0x50, 0x0, 0x20, 0x7f, 0x40, 0x0, 0x0,
    0x6f, 0x50, 0x0, 0x10, 0x3f, 0x90, 0x7, 0xf5,
    0xc, 0xfa, 0xaf, 0xd0, 0x1, 0xaf, 0xeb, 0x20,

    /* U+109 "ĉ" */
    0x0, 0xce, 0x20, 0xb, 0xa6, 0xd1, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f,
    0x30, 0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x56,
    0x2f, 0xc8, 0xfb, 0x5, 0xdf, 0xb1,

    /* U+10A "Ċ" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xeb, 0x20,
    0xc, 0xfb, 0xaf, 0xd0, 0x3f, 0x90, 0x7, 0xf5,
    0x6f, 0x50, 0x0, 0x20, 0x7f, 0x40, 0x0, 0x0,
    0x6f, 0x50, 0x0, 0x10, 0x3f, 0x90, 0x7, 0xf5,
    0xc, 0xfa, 0xaf, 0xd0, 0x1, 0xaf, 0xeb, 0x20,

    /* U+10B "ċ" */
    0x0, 0x8c, 0x0, 0x0, 0x58, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f,
    0x30, 0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x56,
    0x2f, 0xc8, 0xfb, 0x5, 0xdf, 0xb1,

    /* U+10C "Č" */
    0x0, 0xda, 0x9e, 0x10, 0x0, 0x2f, 0xf3, 0x0,
    0x0, 0x2, 0x30, 0x0, 0x1, 0x9e, 0xfb, 0x30,
    0xc, 0xfb, 0x9e, 0xe1, 0x3f, 0x90, 0x4, 0xb4,
    0x6f, 0x50, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0,
    0x6f, 0x50, 0x1, 0x31, 0x3f, 0x90, 0x7, 0xf4,
    0xc, 0xfa, 0xaf, 0xd0, 0x1, 0xaf, 0xea, 0x20,

    /* U+10D "č" */
    0xb, 0xb8, 0xe2, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xb1, 0x2f, 0xc9, 0xfa, 0x7f,
    0x30, 0x79, 0x9f, 0x10, 0x0, 0x7f, 0x30, 0x56,
    0x2f, 0xc8, 0xfb, 0x5, 0xdf, 0xb1,

    /* U+10E "Ď" */
    0xc, 0xa8, 0xe1, 0x0, 0x1, 0xde, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xd5, 0x0,
    0x3f, 0xc9, 0xdf, 0x60, 0x3f, 0x80, 0xe, 0xe0,
    0x3f, 0x80, 0x9, 0xf3, 0x3f, 0x80, 0x8, 0xf4,
    0x3f, 0x80, 0x9, 0xf3, 0x3f, 0x80, 0xe, 0xe0,
    0x3f, 0xc9, 0xdf, 0x60, 0x3f, 0xff, 0xd5, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x9f, 0x1f, 0x30, 0x0, 0x9, 0xf3,
    0xf0, 0x0, 0x0, 0x9f, 0x48, 0x0, 0x7e, 0xdc,
    0xf1, 0x0, 0x3f, 0xd8, 0xff, 0x10, 0x7, 0xf3,
    0x9, 0xf1, 0x0, 0x9f, 0x10, 0x9f, 0x10, 0x7,
    0xf3, 0x9, 0xf1, 0x0, 0x3f, 0xc6, 0xef, 0x10,
    0x0, 0x7e, 0xdb, 0xf1, 0x0,

    /* U+110 "Đ" */
    0x1, 0xff, 0xfd, 0x70, 0x0, 0x1f, 0xd9, 0xcf,
    0x90, 0x1, 0xfb, 0x0, 0xcf, 0x10, 0x1f, 0xb0,
    0x6, 0xf5, 0x1f, 0xff, 0xf0, 0x5f, 0x70, 0x3f,
    0xc2, 0x6, 0xf5, 0x1, 0xfb, 0x0, 0xcf, 0x10,
    0x1f, 0xd8, 0xcf, 0x90, 0x1, 0xff, 0xfd, 0x70,
    0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x1f, 0xff, 0xf0,
    0x0, 0x2, 0xaf, 0x30, 0x7, 0xed, 0xcf, 0x10,
    0x3f, 0xd8, 0xff, 0x10, 0x7f, 0x30, 0x9f, 0x10,
    0x9f, 0x10, 0x9f, 0x10, 0x7f, 0x30, 0x9f, 0x10,
    0x3f, 0xc6, 0xef, 0x10, 0x7, 0xed, 0xbf, 0x10,

    /* U+112 "Ē" */
    0x4, 0xff, 0xfb, 0x0, 0x2, 0x22, 0x10, 0x3f,
    0xff, 0xff, 0x73, 0xfc, 0x88, 0x84, 0x3f, 0x80,
    0x0, 0x3, 0xf9, 0x22, 0x20, 0x3f, 0xff, 0xfe,
    0x3, 0xfa, 0x55, 0x40, 0x3f, 0x80, 0x0, 0x3,
    0xfc, 0x88, 0x84, 0x3f, 0xff, 0xff, 0x70,

    /* U+113 "ē" */
    0xd, 0xff, 0xf3, 0x0, 0x1, 0x11, 0x0, 0x4,
    0xdf, 0xb1, 0x2, 0xfd, 0x8f, 0xb0, 0x7f, 0x40,
    0x9f, 0x8, 0xff, 0xff, 0xf2, 0x7f, 0x63, 0x33,
    0x1, 0xfe, 0x8b, 0xc0, 0x3, 0xcf, 0xd4, 0x0,

    /* U+114 "Ĕ" */
    0x2, 0xc1, 0x78, 0x0, 0xb, 0xfe, 0x30, 0x0,
    0x1, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+115 "ĕ" */
    0xb, 0x82, 0xf2, 0x0, 0x4e, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+116 "Ė" */
    0x0, 0x9, 0x30, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+117 "ė" */
    0x0, 0x7d, 0x0, 0x0, 0x5, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+118 "Ę" */
    0x3f, 0xff, 0xff, 0x73, 0xfc, 0x88, 0x84, 0x3f,
    0x80, 0x0, 0x3, 0xf9, 0x22, 0x20, 0x3f, 0xff,
    0xfe, 0x3, 0xfa, 0x55, 0x40, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x84, 0x3f, 0xff, 0xff, 0x70,
    0x0, 0x4f, 0x20, 0x0, 0x8, 0xc2, 0x0, 0x0,
    0x4e, 0x90,

    /* U+119 "ę" */
    0x4, 0xdf, 0xb1, 0x1, 0xfd, 0x8f, 0xb0, 0x6f,
    0x40, 0x9f, 0x8, 0xff, 0xff, 0xf2, 0x8f, 0x63,
    0x33, 0x4, 0xfb, 0x36, 0x80, 0xa, 0xff, 0xfb,
    0x0, 0x4, 0xf9, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x0, 0xce, 0x0,

    /* U+11A "Ě" */
    0x3, 0xf6, 0xda, 0x0, 0x4, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf7, 0x3f, 0xc8,
    0x88, 0x43, 0xf8, 0x0, 0x0, 0x3f, 0x92, 0x22,
    0x3, 0xff, 0xff, 0xe0, 0x3f, 0xa5, 0x54, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x43, 0xff,
    0xff, 0xf7,

    /* U+11B "ě" */
    0xa, 0xc7, 0xe2, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x10, 0x2f, 0xd8,
    0xfb, 0x7, 0xf4, 0x9, 0xf0, 0x8f, 0xff, 0xff,
    0x27, 0xf6, 0x33, 0x30, 0x1f, 0xe8, 0xbc, 0x0,
    0x3c, 0xfd, 0x40,

    /* U+11C "Ĝ" */
    0x0, 0x1d, 0xe1, 0x0, 0x0, 0xca, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfc, 0x30,
    0xb, 0xfb, 0x9e, 0xf2, 0x3f, 0xb0, 0x4, 0xb4,
    0x6f, 0x60, 0x11, 0x10, 0x7f, 0x50, 0xdf, 0xf8,
    0x6f, 0x60, 0x47, 0xf8, 0x2f, 0xb0, 0x4, 0xf8,
    0xb, 0xfc, 0x9d, 0xf7, 0x0, 0x9e, 0xfd, 0x70,

    /* U+11D "ĝ" */
    0x0, 0xbf, 0x30, 0x0, 0x9c, 0x5e, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0xea, 0xf3, 0x2f, 0xd8,
    0xef, 0x37, 0xf4, 0x8, 0xf3, 0x9f, 0x10, 0x8f,
    0x37, 0xf4, 0x8, 0xf3, 0x2f, 0xd8, 0xef, 0x30,
    0x6e, 0xeb, 0xf3, 0x2, 0x0, 0xaf, 0x20, 0xe9,
    0x8f, 0xc0, 0x8, 0xef, 0xb2, 0x0,

    /* U+11E "Ğ" */
    0x0, 0xa5, 0x3c, 0x0, 0x0, 0x6f, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfc, 0x30,
    0xb, 0xfb, 0x9e, 0xf2, 0x3f, 0xb0, 0x4, 0xb4,
    0x6f, 0x60, 0x11, 0x10, 0x7f, 0x50, 0xdf, 0xf8,
    0x6f, 0x60, 0x47, 0xf8, 0x2f, 0xb0, 0x4, 0xf8,
    0xb, 0xfc, 0x9d, 0xf7, 0x0, 0x9e, 0xfd, 0x70,

    /* U+11F "ğ" */
    0xb, 0x91, 0xf3, 0x0, 0x3e, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0xea, 0xf3, 0x2f, 0xd8,
    0xef, 0x37, 0xf4, 0x8, 0xf3, 0x9f, 0x10, 0x8f,
    0x37, 0xf4, 0x8, 0xf3, 0x2f, 0xd8, 0xef, 0x30,
    0x6e, 0xeb, 0xf3, 0x2, 0x0, 0xaf, 0x20, 0xe9,
    0x8f, 0xc0, 0x8, 0xef, 0xb2, 0x0,

    /* U+120 "Ġ" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfc, 0x30,
    0xb, 0xfb, 0x9e, 0xf2, 0x3f, 0xb0, 0x4, 0xb4,
    0x6f, 0x60, 0x11, 0x10, 0x7f, 0x50, 0xdf, 0xf8,
    0x6f, 0x60, 0x47, 0xf8, 0x2f, 0xb0, 0x4, 0xf8,
    0xb, 0xfc, 0x9d, 0xf7, 0x0, 0x9e, 0xfd, 0x70,

    /* U+121 "ġ" */
    0x0, 0x6d, 0x0, 0x0, 0x4, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0xea, 0xf3, 0x2f, 0xd8,
    0xef, 0x37, 0xf4, 0x8, 0xf3, 0x9f, 0x10, 0x8f,
    0x37, 0xf4, 0x8, 0xf3, 0x2f, 0xd8, 0xef, 0x30,
    0x6e, 0xeb, 0xf3, 0x2, 0x0, 0xaf, 0x20, 0xe9,
    0x8f, 0xc0, 0x8, 0xef, 0xb2, 0x0,

    /* U+122 "Ģ" */
    0x0, 0x9e, 0xfc, 0x30, 0xb, 0xfb, 0x9e, 0xf2,
    0x3f, 0xb0, 0x4, 0xb4, 0x6f, 0x60, 0x11, 0x10,
    0x7f, 0x50, 0xdf, 0xf8, 0x6f, 0x60, 0x47, 0xf8,
    0x2f, 0xb0, 0x4, 0xf8, 0xb, 0xfc, 0x9d, 0xf7,
    0x0, 0x9e, 0xfd, 0x70, 0x0, 0x2, 0x70, 0x0,
    0x0, 0x6, 0xc0, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x4, 0x0, 0x0, 0x3, 0xf1, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x3, 0x70, 0x0, 0x6, 0xee,
    0xaf, 0x32, 0xfd, 0x8e, 0xf3, 0x7f, 0x40, 0x8f,
    0x39, 0xf1, 0x8, 0xf3, 0x7f, 0x40, 0x8f, 0x32,
    0xfd, 0x8e, 0xf3, 0x6, 0xee, 0xbf, 0x30, 0x20,
    0xa, 0xf2, 0xe, 0x98, 0xfc, 0x0, 0x8e, 0xfb,
    0x20,

    /* U+124 "Ĥ" */
    0x0, 0xb, 0xf3, 0x0, 0x0, 0xac, 0x6e, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0xc8, 0x88, 0xfb, 0x3f, 0xff, 0xff, 0xfb,
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0x80, 0x0, 0xfb,
    0x3f, 0x80, 0x0, 0xfb, 0x3f, 0x80, 0x0, 0xfb,

    /* U+125 "ĥ" */
    0x2, 0xdd, 0x30, 0x0, 0x73, 0x27, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf9, 0xee, 0x50, 0x6f, 0xd8, 0xfe,
    0x6, 0xf4, 0xa, 0xf1, 0x6f, 0x40, 0x9f, 0x16,
    0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f, 0x16, 0xf4,
    0x9, 0xf1,

    /* U+126 "Ħ" */
    0x2f, 0x90, 0x0, 0xfc, 0xc, 0xff, 0xff, 0xff,
    0xf7, 0x3f, 0xa2, 0x22, 0xfd, 0x12, 0xfd, 0x88,
    0x8f, 0xc0, 0x2f, 0xff, 0xff, 0xfc, 0x2, 0xf9,
    0x0, 0xf, 0xc0, 0x2f, 0x90, 0x0, 0xfc, 0x2,
    0xf9, 0x0, 0xf, 0xc0, 0x2f, 0x90, 0x0, 0xfc,
    0x0,

    /* U+127 "ħ" */
    0x3, 0xf7, 0x0, 0x0, 0x4f, 0xff, 0xc0, 0x0,
    0x5, 0xf9, 0x20, 0x0, 0x3, 0xfa, 0xde, 0x70,
    0x3, 0xfe, 0x8d, 0xf1, 0x3, 0xf7, 0x7, 0xf3,
    0x3, 0xf7, 0x6, 0xf4, 0x3, 0xf7, 0x6, 0xf4,
    0x3, 0xf7, 0x6, 0xf4, 0x3, 0xf7, 0x6, 0xf4,

    /* U+128 "Ĩ" */
    0xd, 0xa2, 0xe5, 0xb7, 0xf8, 0x11, 0x1, 0x0,
    0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0, 0x2,
    0xfa, 0x0, 0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f,
    0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0,

    /* U+129 "ĩ" */
    0x1e, 0x84, 0xc7, 0xa7, 0xf6, 0x11, 0x1, 0x0,
    0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f, 0x70, 0x3,
    0xf7, 0x0, 0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f,
    0x70,

    /* U+12A "Ī" */
    0x3f, 0xff, 0xb0, 0x22, 0x21, 0x2, 0xfa, 0x0,
    0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0, 0x2,
    0xfa, 0x0, 0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f,
    0xa0, 0x2, 0xfa, 0x0,

    /* U+12B "ī" */
    0x5f, 0xff, 0xb0, 0x11, 0x10, 0x3, 0xf7, 0x0,
    0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f, 0x70, 0x3,
    0xf7, 0x0, 0x3f, 0x70, 0x3, 0xf7, 0x0,

    /* U+12C "Ĭ" */
    0x2c, 0x17, 0x80, 0xbf, 0xe4, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0, 0x2,
    0xfa, 0x0, 0x2f, 0xa0, 0x2, 0xfa, 0x0, 0x2f,
    0xa0, 0x2, 0xfa, 0x0, 0x2f, 0xa0,

    /* U+12D "ĭ" */
    0x4f, 0xb, 0x90, 0xbf, 0xe2, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f, 0x70, 0x3,
    0xf7, 0x0, 0x3f, 0x70, 0x3, 0xf7, 0x0, 0x3f,
    0x70,

    /* U+12E "Į" */
    0x2f, 0xa2, 0xfa, 0x2f, 0xa2, 0xfa, 0x2f, 0xa2,
    0xfa, 0x2f, 0xa2, 0xfa, 0x2f, 0xa8, 0xc0, 0xd9,
    0x17, 0xf5,

    /* U+12F "į" */
    0x2f, 0x52, 0xd4, 0x0, 0x4, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0xab,
    0xf, 0x70, 0x9f, 0x30,

    /* U+130 "İ" */
    0x9, 0x40, 0xd6, 0x0, 0x2, 0xfa, 0x2f, 0xa2,
    0xfa, 0x2f, 0xa2, 0xfa, 0x2f, 0xa2, 0xfa, 0x2f,
    0xa2, 0xfa,

    /* U+131 "ı" */
    0x3f, 0x73, 0xf7, 0x3f, 0x73, 0xf7, 0x3f, 0x73,
    0xf7, 0x3f, 0x70,

    /* U+132 "Ĳ" */
    0x2f, 0xa0, 0x0, 0x4, 0xf7, 0x2f, 0xa0, 0x0,
    0x4, 0xf7, 0x2f, 0xa0, 0x0, 0x4, 0xf7, 0x2f,
    0xa0, 0x0, 0x4, 0xf7, 0x2f, 0xa0, 0x0, 0x4,
    0xf7, 0x2f, 0xa0, 0x0, 0x4, 0xf7, 0x2f, 0xa2,
    0xb5, 0x5, 0xf6, 0x2f, 0xa0, 0xfe, 0x7d, 0xf2,
    0x2f, 0xa0, 0x4c, 0xfd, 0x50,

    /* U+133 "ĳ" */
    0x2f, 0x51, 0xe7, 0x2d, 0x40, 0xd6, 0x0, 0x0,
    0x0, 0x4f, 0x71, 0xfa, 0x4f, 0x71, 0xfa, 0x4f,
    0x71, 0xfa, 0x4f, 0x71, 0xfa, 0x4f, 0x71, 0xfa,
    0x4f, 0x71, 0xfa, 0x4f, 0x71, 0xfa, 0x0, 0x1,
    0xf9, 0x0, 0x3b, 0xf7, 0x0, 0x5f, 0xb0,

    /* U+134 "Ĵ" */
    0x0, 0x1, 0xdd, 0x10, 0x0, 0xc, 0x98, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0x8c, 0x0, 0xde, 0x0,
    0x7f, 0xba, 0xf9, 0x0, 0x9, 0xef, 0xa1, 0x0,

    /* U+135 "ĵ" */
    0x5, 0xf8, 0x4, 0xe4, 0xd6, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x2, 0xf9, 0x0, 0x2f, 0x90, 0x2,
    0xf9, 0x0, 0x2f, 0x90, 0x2, 0xf9, 0x0, 0x2f,
    0x90, 0x2, 0xf8, 0x3, 0xaf, 0x50, 0x6f, 0xa0,
    0x0,

    /* U+136 "Ķ" */
    0x3f, 0x80, 0xd, 0xf4, 0x3f, 0x80, 0xaf, 0x70,
    0x3f, 0x85, 0xfb, 0x0, 0x3f, 0xaf, 0xe1, 0x0,
    0x3f, 0xff, 0xd0, 0x0, 0x3f, 0xfb, 0xf8, 0x0,
    0x3f, 0x90, 0xdf, 0x20, 0x3f, 0x80, 0x4f, 0xc0,
    0x3f, 0x80, 0xa, 0xf6, 0x0, 0xc, 0x60, 0x0,
    0x0, 0xe, 0x30, 0x0, 0x0, 0x7, 0x0, 0x0,

    /* U+137 "ķ" */
    0x5f, 0x50, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0x5, 0xf5, 0x2f, 0xd1, 0x5f, 0x6d,
    0xf2, 0x5, 0xfe, 0xf5, 0x0, 0x5f, 0xff, 0x60,
    0x5, 0xfa, 0xde, 0x10, 0x5f, 0x54, 0xf9, 0x5,
    0xf5, 0xb, 0xf3, 0x0, 0x27, 0x0, 0x0, 0x5,
    0xd0, 0x0, 0x0, 0x97, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+138 "ĸ" */
    0x3f, 0x70, 0xaf, 0x73, 0xf7, 0x3f, 0xd0, 0x3f,
    0x7c, 0xf4, 0x3, 0xff, 0xfb, 0x0, 0x3f, 0xdf,
    0xf2, 0x3, 0xf7, 0x5f, 0xc0, 0x3f, 0x70, 0xaf,
    0x80,

    /* U+139 "Ĺ" */
    0x4, 0xf7, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0xc8, 0x88, 0x23, 0xff,
    0xff, 0xf4,

    /* U+13A "ĺ" */
    0x5, 0xf5, 0xd, 0x80, 0x4f, 0x70, 0x4f, 0x70,
    0x4f, 0x70, 0x4f, 0x70, 0x4f, 0x70, 0x4f, 0x70,
    0x4f, 0x70, 0x4f, 0x70, 0x4f, 0x70, 0x4f, 0x70,

    /* U+13B "Ļ" */
    0x3f, 0x80, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f,
    0x80, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x82, 0x3f, 0xff, 0xff, 0x40,
    0x0, 0x81, 0x0, 0x0, 0x2f, 0x0, 0x0, 0x5,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+13C "ļ" */
    0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x8,
    0x11, 0xf1, 0x4c, 0x0, 0x0,

    /* U+13D "Ľ" */
    0x3f, 0x80, 0xe4, 0x3, 0xf8, 0x1f, 0x10, 0x3f,
    0x81, 0x50, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x82, 0x3f, 0xff, 0xff, 0x40,

    /* U+13E "ľ" */
    0x4f, 0x7a, 0x94, 0xf7, 0xd5, 0x4f, 0x78, 0x4,
    0xf7, 0x0, 0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f,
    0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70, 0x4, 0xf7,
    0x0,

    /* U+13F "Ŀ" */
    0x3f, 0x80, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x3f,
    0x80, 0x0, 0x3, 0xf8, 0x5e, 0x10, 0x3f, 0x83,
    0xa0, 0x3, 0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x3, 0xfc, 0x88, 0x82, 0x3f, 0xff, 0xff, 0x40,

    /* U+140 "ŀ" */
    0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70, 0x4,
    0xf7, 0x0, 0x4f, 0x78, 0x54, 0xf7, 0xc8, 0x4f,
    0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70, 0x4, 0xf7,
    0x0,

    /* U+141 "Ł" */
    0xf, 0xb0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0xfe, 0xc0, 0x0, 0xbf, 0xd3,
    0x0, 0x2, 0xfb, 0x0, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0xfd, 0x88, 0x83, 0xf, 0xff, 0xff, 0x70,

    /* U+142 "ł" */
    0xf, 0xa0, 0xf, 0xa0, 0xf, 0xa0, 0xf, 0xa1,
    0x2f, 0xf6, 0xcf, 0xa0, 0xf, 0xa0, 0xf, 0xa0,
    0xf, 0xa0, 0xf, 0xa0,

    /* U+143 "Ń" */
    0x0, 0x0, 0xae, 0x10, 0x0, 0x4, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0xfb,
    0x3f, 0xf6, 0x0, 0xfb, 0x3f, 0xfe, 0x0, 0xfb,
    0x3f, 0xcf, 0x80, 0xfb, 0x3f, 0x8a, 0xf3, 0xfb,
    0x3f, 0x81, 0xfb, 0xfb, 0x3f, 0x80, 0x8f, 0xfb,
    0x3f, 0x80, 0xe, 0xfb, 0x3f, 0x80, 0x5, 0xfb,

    /* U+144 "ń" */
    0x0, 0x9, 0xf3, 0x0, 0x2, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0xde, 0x50, 0x6f, 0xd8,
    0xfe, 0x6, 0xf5, 0xa, 0xf1, 0x6f, 0x50, 0x9f,
    0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50, 0x9f, 0x16,
    0xf5, 0x9, 0xf1,

    /* U+145 "Ņ" */
    0x3f, 0xc0, 0x0, 0xfb, 0x3f, 0xf6, 0x0, 0xfb,
    0x3f, 0xfe, 0x0, 0xfb, 0x3f, 0xcf, 0x80, 0xfb,
    0x3f, 0x8a, 0xf3, 0xfb, 0x3f, 0x81, 0xfb, 0xfb,
    0x3f, 0x80, 0x8f, 0xfb, 0x3f, 0x80, 0xe, 0xfb,
    0x3f, 0x80, 0x5, 0xfb, 0x0, 0x2, 0x60, 0x0,
    0x0, 0x6, 0xc0, 0x0, 0x0, 0xa, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+146 "ņ" */
    0x6f, 0x8d, 0xe5, 0x6, 0xfd, 0x8f, 0xe0, 0x6f,
    0x50, 0xaf, 0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50,
    0x9f, 0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50, 0x9f,
    0x10, 0x2, 0x70, 0x0, 0x0, 0x4d, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+147 "Ň" */
    0x0, 0x65, 0x17, 0x20, 0x0, 0x1c, 0xd6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0xfb,
    0x3f, 0xf6, 0x0, 0xfb, 0x3f, 0xfe, 0x0, 0xfb,
    0x3f, 0xcf, 0x80, 0xfb, 0x3f, 0x8a, 0xf3, 0xfb,
    0x3f, 0x81, 0xfb, 0xfb, 0x3f, 0x80, 0x8f, 0xfb,
    0x3f, 0x80, 0xe, 0xfb, 0x3f, 0x80, 0x5, 0xfb,

    /* U+148 "ň" */
    0x8, 0xe6, 0xf4, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0xde, 0x50, 0x6f, 0xd8,
    0xfe, 0x6, 0xf5, 0xa, 0xf1, 0x6f, 0x50, 0x9f,
    0x16, 0xf5, 0x9, 0xf1, 0x6f, 0x50, 0x9f, 0x16,
    0xf5, 0x9, 0xf1,

    /* U+149 "ŉ" */
    0x3f, 0x0, 0x0, 0x0, 0x5d, 0x0, 0x0, 0x0,
    0x56, 0x0, 0x0, 0x0, 0x6, 0xf8, 0xde, 0x50,
    0x6, 0xfd, 0x8f, 0xe0, 0x6, 0xf5, 0xa, 0xf1,
    0x6, 0xf5, 0x9, 0xf1, 0x6, 0xf5, 0x9, 0xf1,
    0x6, 0xf5, 0x9, 0xf1, 0x6, 0xf5, 0x9, 0xf1,

    /* U+14A "Ŋ" */
    0x4f, 0xc0, 0x1, 0xfb, 0x4f, 0xf5, 0x1, 0xfb,
    0x4f, 0xfe, 0x1, 0xfb, 0x4f, 0xbf, 0x71, 0xfb,
    0x4f, 0x89, 0xf2, 0xfb, 0x4f, 0x81, 0xfb, 0xfb,
    0x4f, 0x80, 0x7f, 0xfb, 0x4f, 0x80, 0xe, 0xfb,
    0x4f, 0x80, 0x5, 0xfb, 0x0, 0x0, 0x1, 0xfa,
    0x0, 0x0, 0x3b, 0xf7, 0x0, 0x0, 0x6f, 0xb0,

    /* U+14B "ŋ" */
    0x5f, 0x7e, 0xe5, 0x5, 0xfd, 0x8f, 0xe0, 0x5f,
    0x50, 0x9f, 0x15, 0xf5, 0x9, 0xf2, 0x5f, 0x50,
    0x9f, 0x25, 0xf5, 0x9, 0xf2, 0x5f, 0x50, 0x9f,
    0x20, 0x0, 0x9, 0xf1, 0x0, 0x7, 0xee, 0x0,
    0x0, 0xde, 0x50,

    /* U+14C "Ō" */
    0x0, 0xdf, 0xff, 0x20, 0x0, 0x12, 0x22, 0x0,
    0x0, 0x9e, 0xfb, 0x20, 0xb, 0xfb, 0xaf, 0xe1,
    0x3f, 0xa0, 0x6, 0xf7, 0x6f, 0x50, 0x1, 0xfb,
    0x7f, 0x40, 0x0, 0xfc, 0x6f, 0x50, 0x1, 0xfb,
    0x3f, 0xb0, 0x6, 0xf7, 0xb, 0xfb, 0xaf, 0xe1,
    0x0, 0x9e, 0xfb, 0x20,

    /* U+14D "ō" */
    0xa, 0xff, 0xf6, 0x0, 0x1, 0x11, 0x0, 0x4,
    0xdf, 0xb2, 0x2, 0xfd, 0x8f, 0xd0, 0x7f, 0x30,
    0x7f, 0x39, 0xf1, 0x5, 0xf5, 0x7f, 0x30, 0x7f,
    0x42, 0xfd, 0x8e, 0xd0, 0x4, 0xdf, 0xc2, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0xa5, 0x2c, 0x10, 0x0, 0x5f, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+14F "ŏ" */
    0x8, 0xb0, 0xe5, 0x0, 0x2e, 0xfb, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+150 "Ő" */
    0x0, 0xc, 0x98, 0xc0, 0x0, 0x5e, 0x5e, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0xb, 0xfb, 0xaf, 0xe1, 0x3f, 0xa0, 0x6, 0xf7,
    0x6f, 0x50, 0x1, 0xfb, 0x7f, 0x40, 0x0, 0xfc,
    0x6f, 0x50, 0x1, 0xfb, 0x3f, 0xb0, 0x6, 0xf7,
    0xb, 0xfb, 0xaf, 0xe1, 0x0, 0x9e, 0xfb, 0x20,

    /* U+151 "ő" */
    0x0, 0x9c, 0x6e, 0x20, 0x2e, 0x3d, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfb, 0x20, 0x2f, 0xd8,
    0xfd, 0x7, 0xf3, 0x7, 0xf3, 0x9f, 0x10, 0x5f,
    0x57, 0xf3, 0x7, 0xf4, 0x2f, 0xd8, 0xed, 0x0,
    0x4d, 0xfc, 0x20,

    /* U+152 "Œ" */
    0x1, 0x9e, 0xff, 0xff, 0xff, 0xf0, 0xcf, 0xca,
    0xef, 0xaa, 0xaa, 0x4f, 0x90, 0xb, 0xf0, 0x0,
    0x6, 0xf4, 0x0, 0xbf, 0x22, 0x20, 0x7f, 0x40,
    0xb, 0xff, 0xff, 0x66, 0xf4, 0x0, 0xbf, 0x55,
    0x52, 0x4f, 0x80, 0xb, 0xf0, 0x0, 0x0, 0xcf,
    0xa7, 0xdf, 0x88, 0x88, 0x1, 0xae, 0xff, 0xff,
    0xff, 0xf0,

    /* U+153 "œ" */
    0x4, 0xdf, 0xc4, 0xaf, 0xd4, 0x1, 0xfe, 0x8e,
    0xff, 0x9d, 0xe1, 0x6f, 0x50, 0x6f, 0xb0, 0x5f,
    0x47, 0xf3, 0x4, 0xff, 0xff, 0xf5, 0x6f, 0x50,
    0x6f, 0xb3, 0x33, 0x11, 0xfe, 0x8e, 0xff, 0x98,
    0xb0, 0x3, 0xcf, 0xc4, 0xae, 0xe9, 0x0,

    /* U+154 "Ŕ" */
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xeb, 0x20,
    0x3f, 0xc8, 0xaf, 0xc0, 0x3f, 0x80, 0xb, 0xf0,
    0x3f, 0x80, 0x1e, 0xe0, 0x3f, 0xff, 0xff, 0x50,
    0x3f, 0xc8, 0xfc, 0x0, 0x3f, 0x80, 0xaf, 0x30,
    0x3f, 0x80, 0x2f, 0xb0, 0x3f, 0x80, 0xb, 0xf2,

    /* U+155 "ŕ" */
    0x0, 0x8f, 0x30, 0x2f, 0x50, 0x0, 0x0, 0x5,
    0xfa, 0xe3, 0x5f, 0xfb, 0x25, 0xf6, 0x0, 0x5f,
    0x50, 0x5, 0xf5, 0x0, 0x5f, 0x50, 0x5, 0xf5,
    0x0,

    /* U+156 "Ŗ" */
    0x3f, 0xff, 0xeb, 0x20, 0x3f, 0xc8, 0xaf, 0xc0,
    0x3f, 0x80, 0xb, 0xf0, 0x3f, 0x80, 0x1e, 0xe0,
    0x3f, 0xff, 0xff, 0x50, 0x3f, 0xc8, 0xfc, 0x0,
    0x3f, 0x80, 0xaf, 0x30, 0x3f, 0x80, 0x2f, 0xb0,
    0x3f, 0x80, 0xb, 0xf2, 0x0, 0x8, 0x10, 0x0,
    0x0, 0x1f, 0x10, 0x0, 0x0, 0x4c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x5, 0xfa, 0xe3, 0x5f, 0xfb, 0x25,
    0xf6, 0x0, 0x5f, 0x50, 0x5, 0xf5, 0x0, 0x5f,
    0x50, 0x5, 0xf5, 0x0, 0x8, 0x10, 0x2, 0xf0,
    0x0, 0x5b, 0x0, 0x0, 0x0, 0x0,

    /* U+158 "Ř" */
    0x4, 0x60, 0x64, 0x0, 0x0, 0x9d, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xeb, 0x20,
    0x3f, 0xc8, 0xaf, 0xc0, 0x3f, 0x80, 0xb, 0xf0,
    0x3f, 0x80, 0x1e, 0xe0, 0x3f, 0xff, 0xff, 0x50,
    0x3f, 0xc8, 0xfc, 0x0, 0x3f, 0x80, 0xaf, 0x30,
    0x3f, 0x80, 0x2f, 0xb0, 0x3f, 0x80, 0xb, 0xf2,

    /* U+159 "ř" */
    0x7e, 0x5f, 0x50, 0x8e, 0x50, 0x0, 0x0, 0x5,
    0xfa, 0xe3, 0x5f, 0xfb, 0x25, 0xf6, 0x0, 0x5f,
    0x50, 0x5, 0xf5, 0x0, 0x5f, 0x50, 0x5, 0xf5,
    0x0,

    /* U+15A "Ś" */
    0x0, 0x2, 0xf9, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0x90, 0x1f, 0xe9,
    0xbf, 0x94, 0xf7, 0x0, 0xaa, 0x1e, 0xe7, 0x10,
    0x0, 0x2b, 0xff, 0x90, 0x0, 0x2, 0x9f, 0xa7,
    0xe3, 0x0, 0xde, 0x3f, 0xe8, 0xaf, 0xb0, 0x4c,
    0xfe, 0xa1,

    /* U+15B "ś" */
    0x0, 0xd, 0xd0, 0x0, 0x6e, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xee, 0xa0, 0x5f, 0x97, 0xf8, 0x5f,
    0x81, 0x32, 0x9, 0xff, 0xc2, 0x24, 0x5, 0xfa,
    0x7f, 0x86, 0xf9, 0x8, 0xef, 0xa1,

    /* U+15C "Ŝ" */
    0x0, 0x3f, 0xb0, 0x0, 0x2e, 0x6b, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0x90, 0x1f, 0xe9,
    0xbf, 0x94, 0xf7, 0x0, 0xaa, 0x1e, 0xe7, 0x10,
    0x0, 0x2b, 0xff, 0x90, 0x0, 0x2, 0x9f, 0xa7,
    0xe3, 0x0, 0xde, 0x3f, 0xe8, 0xaf, 0xb0, 0x4c,
    0xfe, 0xa1,

    /* U+15D "ŝ" */
    0x0, 0xce, 0x20, 0xb, 0xa7, 0xd1, 0x0, 0x0,
    0x0, 0x8, 0xee, 0xa0, 0x5f, 0x97, 0xf8, 0x5f,
    0x81, 0x32, 0x9, 0xff, 0xc2, 0x24, 0x5, 0xfa,
    0x7f, 0x86, 0xf9, 0x8, 0xef, 0xa1,

    /* U+15E "Ş" */
    0x4, 0xcf, 0xe9, 0x1, 0xfe, 0x9b, 0xf9, 0x4f,
    0x70, 0xa, 0xa1, 0xee, 0x71, 0x0, 0x2, 0xbf,
    0xf9, 0x0, 0x0, 0x29, 0xfa, 0x7e, 0x30, 0xd,
    0xe3, 0xfe, 0x8a, 0xfb, 0x4, 0xcf, 0xfa, 0x10,
    0x0, 0xdc, 0x0, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0xca, 0x0,

    /* U+15F "ş" */
    0x8, 0xee, 0xa0, 0x5f, 0x97, 0xf8, 0x5f, 0x81,
    0x32, 0x9, 0xff, 0xc2, 0x24, 0x5, 0xfa, 0x7f,
    0x86, 0xf9, 0x8, 0xff, 0xa1, 0x0, 0x8e, 0x20,
    0x0, 0x1f, 0x80, 0x0, 0x7d, 0x20,

    /* U+160 "Š" */
    0x2, 0xf7, 0xcb, 0x0, 0x6, 0xfe, 0x10, 0x0,
    0x4, 0x20, 0x0, 0x4c, 0xfe, 0xa1, 0x1f, 0xe9,
    0xaf, 0xc4, 0xf7, 0x0, 0x23, 0x1e, 0xe7, 0x10,
    0x0, 0x2b, 0xff, 0x90, 0x1, 0x2, 0x9f, 0xa8,
    0xf4, 0x0, 0xde, 0x2f, 0xe8, 0xaf, 0xb0, 0x3c,
    0xfe, 0xa1,

    /* U+161 "š" */
    0xb, 0xb8, 0xe1, 0x0, 0xde, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xee, 0xa0, 0x5f, 0x97, 0xf8, 0x5f,
    0x81, 0x32, 0x9, 0xff, 0xc2, 0x24, 0x5, 0xfa,
    0x7f, 0x86, 0xf9, 0x8, 0xef, 0xa1,

    /* U+162 "Ţ" */
    0xcf, 0xff, 0xff, 0xf3, 0x68, 0xaf, 0xc8, 0x81,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0x7, 0xf1, 0x0, 0x0, 0xd, 0x90, 0x0,

    /* U+163 "ţ" */
    0x8, 0x50, 0x0, 0xfa, 0x0, 0xff, 0xfc, 0x5,
    0xfc, 0x40, 0xf, 0xa0, 0x0, 0xfa, 0x0, 0xf,
    0xa0, 0x0, 0xfe, 0x70, 0x7, 0xfc, 0x0, 0x2f,
    0x80, 0x0, 0x9f, 0x0, 0xe, 0x70,

    /* U+164 "Ť" */
    0x2, 0x70, 0x55, 0x0, 0x0, 0x7d, 0xb1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xf3,
    0x68, 0xaf, 0xc8, 0x81, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+165 "ť" */
    0x0, 0x2, 0x70, 0x0, 0x5d, 0x8, 0x58, 0x80,
    0xfa, 0x0, 0xff, 0xfc, 0x5, 0xfc, 0x40, 0xf,
    0xa0, 0x0, 0xfa, 0x0, 0xf, 0xa0, 0x0, 0xfe,
    0x70, 0x7, 0xfb, 0x0,

    /* U+166 "Ŧ" */
    0xcf, 0xff, 0xff, 0xf3, 0x68, 0xaf, 0xc8, 0x81,
    0x0, 0x3f, 0x90, 0x0, 0x7, 0xff, 0xfa, 0x0,
    0x1, 0x5f, 0xa1, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x85, 0x0, 0xf, 0xa0, 0xf, 0xff, 0xc0,
    0x5f, 0xc4, 0x2f, 0xff, 0xe0, 0x2f, 0xb2, 0x0,
    0xfa, 0x0, 0xe, 0xe7, 0x0, 0x6f, 0xb0,

    /* U+168 "Ũ" */
    0x0, 0xbc, 0x1e, 0x10, 0x2, 0xd5, 0xfb, 0x0,
    0x0, 0x10, 0x10, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+169 "ũ" */
    0x5, 0xe5, 0x97, 0x0, 0xc6, 0xbf, 0x20, 0x2,
    0x0, 0x10, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+16A "Ū" */
    0x1, 0xff, 0xfe, 0x0, 0x0, 0x22, 0x21, 0x0,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x4f, 0x70, 0x8, 0xf3,
    0x3f, 0x90, 0xa, 0xf1, 0xd, 0xf9, 0xaf, 0xc0,
    0x2, 0xbe, 0xea, 0x10,

    /* U+16B "ū" */
    0xa, 0xff, 0xf6, 0x0, 0x1, 0x11, 0x0, 0x6f,
    0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x5f, 0x50, 0x9f,
    0x13, 0xfc, 0x8f, 0xf1, 0x9, 0xfd, 0xbf, 0x10,

    /* U+16C "Ŭ" */
    0x0, 0xc3, 0x5a, 0x0, 0x0, 0x8f, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+16D "ŭ" */
    0x9, 0xb0, 0xf4, 0x0, 0x2e, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+16E "Ů" */
    0x0, 0x9, 0x90, 0x0, 0x0, 0x56, 0x82, 0x0,
    0x0, 0x19, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x4f, 0x70, 0x8, 0xf3,
    0x3f, 0x90, 0xa, 0xf1, 0xd, 0xf9, 0xaf, 0xc0,
    0x2, 0xbe, 0xea, 0x10,

    /* U+16F "ů" */
    0x0, 0x6a, 0x30, 0x0, 0xb, 0x19, 0x0, 0x0,
    0x6a, 0x30, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x16, 0xf4, 0x9, 0xf1, 0x5f, 0x50, 0x9f, 0x13,
    0xfc, 0x8f, 0xf1, 0x9, 0xfd, 0xbf, 0x10,

    /* U+170 "Ű" */
    0x0, 0x1d, 0x5b, 0x90, 0x0, 0x9b, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x4f, 0x70, 0x8, 0xf3, 0x3f, 0x90, 0xa, 0xf1,
    0xd, 0xf9, 0xaf, 0xc0, 0x2, 0xbe, 0xea, 0x10,

    /* U+171 "ű" */
    0x0, 0xac, 0x6e, 0x20, 0x2e, 0x3d, 0x40, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x9, 0xf1, 0x6f, 0x40,
    0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f, 0x40, 0x9f,
    0x15, 0xf5, 0x9, 0xf1, 0x3f, 0xc8, 0xff, 0x10,
    0x9f, 0xdb, 0xf1,

    /* U+172 "Ų" */
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x5f, 0x70, 0x8, 0xf3,
    0x5f, 0x70, 0x8, 0xf3, 0x4f, 0x70, 0x8, 0xf3,
    0x3f, 0x90, 0xa, 0xf2, 0xd, 0xf9, 0xaf, 0xd0,
    0x2, 0xbe, 0xfd, 0x20, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0x1, 0xef, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+173 "ų" */
    0x6f, 0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x6f,
    0x40, 0x9f, 0x16, 0xf4, 0x9, 0xf1, 0x5f, 0x50,
    0x9f, 0x13, 0xfc, 0x8f, 0xf1, 0x9, 0xfc, 0xbf,
    0x10, 0x0, 0xe, 0x60, 0x0, 0x3, 0xf4, 0x0,
    0x0, 0xc, 0xe0,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x47, 0x0, 0x0, 0x0, 0x0, 0x7d,
    0x8d, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf0, 0x9, 0xf1, 0x8, 0xf3, 0x7f, 0x30,
    0xdf, 0x50, 0xbf, 0x4, 0xf6, 0xf, 0xf8, 0xe,
    0xc0, 0x1f, 0x94, 0xfc, 0xb0, 0xf9, 0x0, 0xdc,
    0x7e, 0x6f, 0x3f, 0x50, 0xa, 0xfb, 0xa2, 0xf9,
    0xf2, 0x0, 0x6f, 0xf7, 0xe, 0xef, 0x0, 0x3,
    0xff, 0x30, 0xbf, 0xb0, 0x0, 0xf, 0xf0, 0x7,
    0xf8, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x9, 0xf5, 0x0, 0x0, 0x7, 0xc3, 0xd3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0, 0x5f,
    0x21, 0xf8, 0x7f, 0x19, 0xf6, 0x4f, 0x44, 0xf4,
    0xdf, 0xa7, 0xf0, 0xf, 0x9f, 0x8e, 0xad, 0x0,
    0xcf, 0xd1, 0xff, 0x90, 0x9, 0xf9, 0xd, 0xf5,
    0x0, 0x5f, 0x50, 0x8f, 0x20,

    /* U+176 "Ŷ" */
    0x0, 0x1b, 0x60, 0x0, 0x1, 0xd9, 0xe4, 0x0,
    0x1, 0x30, 0x23, 0x0, 0xbf, 0x20, 0xb, 0xf2,
    0x4f, 0x90, 0x2f, 0xa0, 0xc, 0xf0, 0x9f, 0x20,
    0x4, 0xf7, 0xfb, 0x0, 0x0, 0xcf, 0xf3, 0x0,
    0x0, 0x5f, 0xb0, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+177 "ŷ" */
    0x1, 0xde, 0x10, 0xb, 0x86, 0xb0, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0xed, 0x8f, 0x43, 0xf8, 0x3f,
    0x88, 0xf3, 0xe, 0xcc, 0xe0, 0x9, 0xff, 0x90,
    0x4, 0xff, 0x40, 0x0, 0xff, 0x0, 0x0, 0xea,
    0x0, 0x2b, 0xf5, 0x0, 0x4f, 0xa0, 0x0,

    /* U+178 "Ÿ" */
    0x2, 0x70, 0x36, 0x0, 0x5, 0xd0, 0x7c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0xb, 0xf2,
    0x4f, 0x90, 0x2f, 0xa0, 0xc, 0xf0, 0x9f, 0x20,
    0x4, 0xf7, 0xfb, 0x0, 0x0, 0xcf, 0xf3, 0x0,
    0x0, 0x5f, 0xb0, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+179 "Ź" */
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xda, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xfd, 0x48, 0x88,
    0xcf, 0x80, 0x0, 0x1e, 0xd0, 0x0, 0xa, 0xf3,
    0x0, 0x5, 0xf9, 0x0, 0x1, 0xed, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x5f, 0xe8, 0x88, 0x79, 0xff,
    0xff, 0xfe,

    /* U+17A "ź" */
    0x0, 0xd, 0xc0, 0x0, 0x7e, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xf9, 0x37, 0x7d, 0xf5, 0x0,
    0x4f, 0xa0, 0x0, 0xee, 0x10, 0xa, 0xf4, 0x0,
    0x4f, 0xe7, 0x75, 0x9f, 0xff, 0xfb,

    /* U+17B "Ż" */
    0x0, 0x9, 0x30, 0x0, 0x1, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xfd, 0x48, 0x88,
    0xcf, 0x80, 0x0, 0x1e, 0xd0, 0x0, 0xa, 0xf3,
    0x0, 0x5, 0xf9, 0x0, 0x1, 0xed, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x5f, 0xe8, 0x88, 0x79, 0xff,
    0xff, 0xfe,

    /* U+17C "ż" */
    0x0, 0x9b, 0x0, 0x0, 0x67, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xf9, 0x37, 0x7d, 0xf5, 0x0,
    0x4f, 0xa0, 0x0, 0xee, 0x10, 0xa, 0xf4, 0x0,
    0x4f, 0xe7, 0x75, 0x9f, 0xff, 0xfb,

    /* U+17D "Ž" */
    0x2, 0x70, 0x55, 0x0, 0x7, 0xdb, 0x10, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xfd, 0x48, 0x88,
    0xcf, 0x80, 0x0, 0x1e, 0xd0, 0x0, 0xa, 0xf3,
    0x0, 0x5, 0xf9, 0x0, 0x1, 0xed, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x5f, 0xe8, 0x88, 0x79, 0xff,
    0xff, 0xfe,

    /* U+17E "ž" */
    0xc, 0xa8, 0xd1, 0x1, 0xcd, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xf9, 0x37, 0x7d, 0xf5, 0x0,
    0x4f, 0xa0, 0x0, 0xee, 0x10, 0xa, 0xf4, 0x0,
    0x4f, 0xe7, 0x75, 0x9f, 0xff, 0xfb,

    /* U+17F "ſ" */
    0x7, 0xed, 0x2f, 0xd7, 0x4f, 0x60, 0x5f, 0x60,
    0x5f, 0x60, 0x5f, 0x60, 0x5f, 0x60, 0x5f, 0x60,
    0x5f, 0x60, 0x5f, 0x60,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0,
    0x0, 0x3, 0x7c, 0xff, 0x0, 0x0, 0x59, 0xef,
    0xff, 0xff, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xf, 0xff, 0xfd, 0x84, 0x8f, 0x0, 0xf,
    0xd7, 0x20, 0x0, 0x8f, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x8f, 0x0, 0xf, 0x80, 0x0, 0x0, 0x8f,
    0x0, 0xf, 0x80, 0x0, 0x7b, 0xdf, 0x2, 0x3f,
    0x80, 0x6, 0xff, 0xff, 0xaf, 0xff, 0x80, 0x2,
    0xef, 0xf9, 0xef, 0xff, 0x60, 0x0, 0x2, 0x10,
    0x29, 0xa7, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xb4, 0xdf, 0xff, 0xff, 0xfd, 0x4b, 0xe8, 0xe7,
    0x22, 0x22, 0x7e, 0x8e, 0xc0, 0xc5, 0x0, 0x0,
    0x6c, 0xc, 0xfc, 0xf6, 0x11, 0x11, 0x7f, 0xcf,
    0xc0, 0xcf, 0xff, 0xff, 0xfb, 0xc, 0xfc, 0xf6,
    0x11, 0x11, 0x7f, 0xcf, 0xc0, 0xc5, 0x0, 0x0,
    0x6c, 0xc, 0xe8, 0xe7, 0x22, 0x22, 0x7e, 0x8e,
    0xb4, 0xdf, 0xff, 0xff, 0xfd, 0x4b,

    /* U+F00B "" */
    0xdf, 0xf6, 0x9f, 0xff, 0xff, 0xfd, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xef, 0xf6, 0xaf, 0xff,
    0xff, 0xfe, 0x13, 0x20, 0x3, 0x33, 0x33, 0x31,
    0xff, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbf, 0xff,
    0xff, 0xff, 0x13, 0x20, 0x3, 0x33, 0x33, 0x31,
    0xef, 0xf6, 0xaf, 0xff, 0xff, 0xfe, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xdf, 0xf6, 0xaf, 0xff,
    0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfe, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf4, 0x4d, 0x30, 0x0, 0x3f, 0xff, 0x40,
    0xef, 0xf3, 0x3, 0xff, 0xf4, 0x0, 0x4f, 0xff,
    0x6f, 0xff, 0x40, 0x0, 0x4, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x3, 0xd3, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x14, 0x0, 0x0, 0x22, 0xd, 0xf7, 0x0, 0x4f,
    0xf1, 0x9f, 0xf7, 0x4f, 0xfd, 0x0, 0xaf, 0xff,
    0xfd, 0x10, 0x0, 0xbf, 0xfe, 0x10, 0x0, 0x4f,
    0xff, 0xf7, 0x0, 0x4f, 0xfd, 0xaf, 0xf7, 0xe,
    0xfd, 0x10, 0xaf, 0xf2, 0x5b, 0x10, 0x0, 0x99,
    0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x32,
    0xf, 0xf0, 0x24, 0x0, 0x5, 0xfc, 0xf, 0xf0,
    0xcf, 0x50, 0x1f, 0xf4, 0xf, 0xf0, 0x5f, 0xf1,
    0x7f, 0x80, 0xf, 0xf0, 0x8, 0xf7, 0xbf, 0x20,
    0xf, 0xf0, 0x2, 0xfb, 0xcf, 0x10, 0xe, 0xe0,
    0x1, 0xfc, 0xaf, 0x40, 0x1, 0x10, 0x4, 0xfa,
    0x5f, 0xb0, 0x0, 0x0, 0xb, 0xf6, 0xd, 0xfa,
    0x10, 0x1, 0xaf, 0xd0, 0x2, 0xdf, 0xfc, 0xcf,
    0xfd, 0x20, 0x0, 0x8, 0xef, 0xfe, 0x91, 0x0,
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x14, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf7, 0x0, 0x0, 0x3, 0x43, 0xdf, 0xfd,
    0x34, 0x30, 0xe, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x6f, 0xff, 0xfb, 0xbf, 0xff, 0xf6, 0x1b, 0xff,
    0x70, 0x7, 0xff, 0xb1, 0x7, 0xff, 0x20, 0x2,
    0xff, 0x70, 0x1b, 0xff, 0x70, 0x7, 0xff, 0xb1,
    0x6f, 0xff, 0xfb, 0xbf, 0xff, 0xf6, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x3, 0x42, 0xcf, 0xfc,
    0x23, 0x30, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x41, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x73, 0x3, 0x83, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x67, 0xf7, 0x0, 0x0, 0x3,
    0xee, 0x5a, 0xfe, 0xf7, 0x0, 0x0, 0x6f, 0xd3,
    0xb5, 0x7f, 0xf7, 0x0, 0x9, 0xfb, 0x3d, 0xff,
    0x85, 0xfe, 0x30, 0xbf, 0x95, 0xff, 0xff, 0xfb,
    0x3e, 0xf4, 0x76, 0x6f, 0xff, 0xff, 0xff, 0xd2,
    0xa1, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xcf, 0xfa, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0xcf, 0xfa, 0x2, 0xff, 0xf4, 0x0, 0x0, 0xaf,
    0xf8, 0x1, 0xff, 0xf3, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x27, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x4, 0xff, 0xff, 0x40, 0x0,
    0x23, 0x33, 0x5f, 0xf5, 0x33, 0x32, 0xff, 0xff,
    0xa4, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x8f,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8,

    /* U+F01C "" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x1,
    0xed, 0x88, 0x88, 0x89, 0xf8, 0x0, 0xa, 0xf2,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x1e, 0xc0, 0xef, 0x88, 0x60, 0x0,
    0x28, 0x8b, 0xf6, 0xff, 0xff, 0xf3, 0x0, 0xbf,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+F021 "" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x59, 0x0, 0x19,
    0xef, 0xfd, 0x70, 0x9f, 0x3, 0xef, 0xda, 0x9d,
    0xfe, 0xbf, 0xe, 0xf6, 0x0, 0x0, 0x5f, 0xff,
    0x7f, 0x70, 0x0, 0x3f, 0xff, 0xff, 0x69, 0x0,
    0x0, 0x2a, 0xaa, 0xa9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaa, 0xaa, 0xa2, 0x0, 0x0, 0xa6,
    0xff, 0xfe, 0xf3, 0x0, 0x7, 0xf7, 0xff, 0xf5,
    0x0, 0x0, 0x7f, 0xe0, 0xfb, 0xef, 0xd9, 0xad,
    0xfe, 0x30, 0xfa, 0x8, 0xef, 0xfe, 0x91, 0x0,
    0x95, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x2a, 0x0, 0x2, 0xef, 0x78, 0x8e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0x0, 0x7, 0xff,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x1,

    /* U+F027 "" */
    0x0, 0x0, 0x2a, 0x0, 0x0, 0x0, 0x2e, 0xf0,
    0x0, 0x78, 0x8e, 0xff, 0x3, 0xf, 0xff, 0xff,
    0xf0, 0xba, 0xff, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xff, 0xf0, 0xaa, 0xdf, 0xff, 0xff, 0x4, 0x0,
    0x0, 0x8f, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xd2, 0x0, 0x0, 0x0,
    0x2a, 0x0, 0x11, 0x8e, 0x10, 0x0, 0x2, 0xef,
    0x0, 0x7d, 0x2b, 0x90, 0x78, 0x8e, 0xff, 0x3,
    0xa, 0xb3, 0xf0, 0xff, 0xff, 0xff, 0xb, 0xa1,
    0xf1, 0xe3, 0xff, 0xff, 0xff, 0x3, 0xf0, 0xe3,
    0xc5, 0xff, 0xff, 0xff, 0xb, 0xa1, 0xf1, 0xe3,
    0xdf, 0xff, 0xff, 0x3, 0xa, 0xb3, 0xf0, 0x0,
    0x7, 0xff, 0x0, 0x7d, 0x2b, 0x90, 0x0, 0x0,
    0x7f, 0x0, 0x11, 0x9e, 0x10, 0x0, 0x0, 0x1,
    0x0, 0x6, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F03E "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfd, 0x5b,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x1, 0xff, 0xff,
    0xef, 0xff, 0xfb, 0x18, 0xff, 0xf6, 0x1c, 0xff,
    0xff, 0xfc, 0xff, 0x60, 0x1, 0xdf, 0xff, 0x60,
    0x96, 0x0, 0x0, 0x8f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xfc, 0x88, 0x88, 0x88, 0x88, 0xcf,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F048 "" */
    0x58, 0x0, 0x0, 0x35, 0x9f, 0x10, 0x5, 0xfe,
    0x9f, 0x10, 0x6f, 0xfe, 0x9f, 0x17, 0xff, 0xfe,
    0x9f, 0x9f, 0xff, 0xfe, 0x9f, 0xff, 0xff, 0xfe,
    0x9f, 0xef, 0xff, 0xfe, 0x9f, 0x2d, 0xff, 0xfe,
    0x9f, 0x10, 0xcf, 0xfe, 0x9f, 0x10, 0xb, 0xfe,
    0x8f, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x46, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xa1, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfd, 0x50, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xb1, 0xff, 0xff, 0xff, 0xfd,
    0x40, 0xf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xff,
    0xff, 0xa1, 0x0, 0x0, 0xf, 0xfd, 0x40, 0x0,
    0x0, 0x0, 0x36, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0xaf, 0xfe, 0x30, 0xaf, 0xfe, 0x3f, 0xff, 0xf7,
    0xf, 0xff, 0xf7, 0xff, 0xff, 0x80, 0xff, 0xff,
    0x8f, 0xff, 0xf8, 0xf, 0xff, 0xf8, 0xff, 0xff,
    0x80, 0xff, 0xff, 0x8f, 0xff, 0xf8, 0xf, 0xff,
    0xf8, 0xff, 0xff, 0x80, 0xff, 0xff, 0x8f, 0xff,
    0xf8, 0xf, 0xff, 0xf8, 0xff, 0xff, 0x80, 0xff,
    0xff, 0x8f, 0xff, 0xf7, 0xf, 0xff, 0xf7, 0x48,
    0x98, 0x10, 0x48, 0x98, 0x10,

    /* U+F04D "" */
    0x48, 0x88, 0x88, 0x88, 0x88, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xaf,
    0xff, 0xff, 0xff, 0xfe, 0x30,

    /* U+F051 "" */
    0x26, 0x0, 0x0, 0x58, 0x7f, 0xa0, 0x0, 0xbf,
    0x8f, 0xfb, 0x0, 0xbf, 0x8f, 0xff, 0xc1, 0xbf,
    0x8f, 0xff, 0xfd, 0xcf, 0x8f, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xef, 0x8f, 0xff, 0xf4, 0xbf,
    0x8f, 0xff, 0x40, 0xbf, 0x8f, 0xe3, 0x0, 0xbf,
    0x5d, 0x20, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x3, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xfa, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0x90, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xf8, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0xff, 0x70, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x1, 0x34, 0x44, 0x44, 0x44, 0x30,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xf5,

    /* U+F053 "" */
    0x0, 0x0, 0x3, 0x10, 0x0, 0x5, 0xfb, 0x0,
    0x5, 0xff, 0x40, 0x5, 0xff, 0x40, 0x5, 0xff,
    0x50, 0x3, 0xff, 0x50, 0x0, 0xb, 0xfc, 0x10,
    0x0, 0xb, 0xfc, 0x10, 0x0, 0xc, 0xfc, 0x10,
    0x0, 0xc, 0xfb, 0x0, 0x0, 0xa, 0x50,

    /* U+F054 "" */
    0x3, 0x10, 0x0, 0x3, 0xfc, 0x10, 0x0, 0xb,
    0xfc, 0x10, 0x0, 0xb, 0xfc, 0x10, 0x0, 0xb,
    0xfc, 0x10, 0x0, 0xd, 0xfb, 0x0, 0x5, 0xff,
    0x50, 0x5, 0xff, 0x50, 0x5, 0xff, 0x50, 0x3,
    0xff, 0x50, 0x0, 0xa, 0x50, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x69, 0x10, 0x0, 0x0, 0x0, 0xd,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xef, 0x60, 0x0,
    0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x58, 0x88,
    0xff, 0xb8, 0x88, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x9b, 0xbb, 0xff, 0xdb, 0xbb, 0x30, 0x0,
    0xe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xef, 0x60,
    0x0, 0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x20, 0x0, 0x0,

    /* U+F068 "" */
    0x46, 0x66, 0x66, 0x66, 0x66, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xad, 0xdd, 0xdd, 0xdd, 0xdd,
    0x40,

    /* U+F06E "" */
    0x0, 0x3, 0xad, 0xff, 0xc7, 0x0, 0x0, 0x0,
    0x9f, 0xe6, 0x24, 0xaf, 0xe3, 0x0, 0xb, 0xff,
    0x20, 0x77, 0x9, 0xff, 0x40, 0x7f, 0xf9, 0x0,
    0xcf, 0xa1, 0xff, 0xe1, 0xef, 0xf6, 0x7f, 0xff,
    0xf0, 0xef, 0xf7, 0x8f, 0xf9, 0x3f, 0xff, 0xc1,
    0xff, 0xe1, 0xb, 0xff, 0x26, 0xca, 0x19, 0xff,
    0x40, 0x0, 0x9f, 0xe6, 0x24, 0xaf, 0xe3, 0x0,
    0x0, 0x3, 0x9d, 0xff, 0xc7, 0x0, 0x0,

    /* U+F070 "" */
    0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xf8, 0x4a, 0xef, 0xeb, 0x50, 0x0, 0x0,
    0x0, 0x9f, 0xfd, 0x52, 0x5d, 0xfc, 0x10, 0x0,
    0x0, 0x5, 0xfe, 0x4a, 0x70, 0xcf, 0xe1, 0x0,
    0xb, 0x80, 0x2d, 0xff, 0xf7, 0x4f, 0xfb, 0x0,
    0x2f, 0xfb, 0x0, 0xaf, 0xfb, 0x2f, 0xff, 0x30,
    0xb, 0xff, 0x50, 0x7, 0xfe, 0x7f, 0xfb, 0x0,
    0x1, 0xdf, 0xc0, 0x0, 0x3e, 0xff, 0xe1, 0x0,
    0x0, 0x1b, 0xfc, 0x42, 0x1, 0xbf, 0xa0, 0x0,
    0x0, 0x0, 0x5b, 0xef, 0xb0, 0x8, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x40,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x3, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xfd, 0xef, 0xa0, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x3, 0xff, 0x30, 0x0, 0x0, 0x4, 0xff,
    0xc0, 0x4f, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xfd,
    0x5, 0xff, 0xf6, 0x0, 0x0, 0x7f, 0xff, 0xf8,
    0xcf, 0xff, 0xe1, 0x0, 0x1f, 0xff, 0xfc, 0x4,
    0xff, 0xff, 0x90, 0xa, 0xff, 0xff, 0xd2, 0x7f,
    0xff, 0xff, 0x20, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x4, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc1, 0xff, 0xf8, 0x0, 0x2e,
    0xff, 0xfc, 0xcd, 0xff, 0x62, 0xef, 0xdf, 0xf9,
    0x0, 0x2c, 0x4e, 0xf9, 0xf, 0x90, 0x0, 0x2,
    0xef, 0x90, 0x7, 0x0, 0x0, 0x2e, 0xf8, 0x88,
    0xf, 0xa0, 0xcd, 0xff, 0x80, 0xdf, 0xdf, 0xf9,
    0xff, 0xf8, 0x0, 0x1e, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0x10,

    /* U+F077 "" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xf9, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0,
    0x0, 0x2e, 0xf9, 0x2e, 0xf9, 0x0, 0x2e, 0xf9,
    0x0, 0x2e, 0xf9, 0xb, 0xf9, 0x0, 0x0, 0x2e,
    0xf4, 0x27, 0x0, 0x0, 0x0, 0x27, 0x0,

    /* U+F078 "" */
    0x27, 0x0, 0x0, 0x0, 0x27, 0xb, 0xf9, 0x0,
    0x0, 0x2e, 0xf4, 0x2e, 0xf9, 0x0, 0x2e, 0xf9,
    0x0, 0x2e, 0xf9, 0x2e, 0xf9, 0x0, 0x0, 0x2e,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x2e, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x26, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xc0, 0x7, 0x77, 0x77, 0x72, 0x0,
    0x3, 0xff, 0xfc, 0x2e, 0xff, 0xff, 0xf9, 0x0,
    0xf, 0xcf, 0xcf, 0xa0, 0x0, 0x0, 0xe9, 0x0,
    0x4, 0x1e, 0x93, 0x20, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0xb5, 0xe9, 0x97,
    0x0, 0xe, 0xc7, 0x77, 0x73, 0xbf, 0xff, 0xf6,
    0x0, 0xd, 0xff, 0xff, 0xfd, 0xb, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa6, 0x0,

    /* U+F07B "" */
    0xbf, 0xff, 0xf6, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x98, 0x88, 0x74, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F093 "" */
    0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xe3, 0x0, 0x0, 0x0, 0x3, 0xef, 0xfe,
    0x30, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xe3, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x8f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0,
    0x23, 0x32, 0x8f, 0xf8, 0x23, 0x32, 0xff, 0xfe,
    0x39, 0x93, 0xef, 0xff, 0xff, 0xff, 0xc9, 0x9c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x8f,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x62, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x1,
    0x0, 0x9, 0xff, 0x40, 0x1, 0x8e, 0xe1, 0x1a,
    0xff, 0x70, 0x0, 0xef, 0xff, 0xde, 0xff, 0x90,
    0x0, 0xc, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x8f, 0xff, 0xe9, 0x10, 0x0, 0x0, 0x2, 0x76,
    0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x7, 0x93, 0x0, 0x0, 0x22, 0xa, 0xff, 0xf2,
    0x0, 0x8f, 0xf5, 0xf9, 0x1f, 0x70, 0x8f, 0xf9,
    0xc, 0xfc, 0xf8, 0x8f, 0xf9, 0x0, 0x1a, 0xef,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0xef, 0xfc, 0x0,
    0x0, 0x7, 0xbf, 0xff, 0xf6, 0x0, 0xa, 0xff,
    0xfa, 0xbf, 0xf6, 0x0, 0xf9, 0x1f, 0x70, 0xbf,
    0xf6, 0xc, 0xfc, 0xf4, 0x0, 0xbf, 0xf4, 0x1a,
    0xc6, 0x0, 0x0, 0x56, 0x0,

    /* U+F0C5 "" */
    0x0, 0x3, 0x44, 0x41, 0x20, 0x0, 0x0, 0xff,
    0xff, 0x5e, 0x40, 0x24, 0x1f, 0xff, 0xf5, 0xee,
    0x2f, 0xf4, 0xff, 0xff, 0xc8, 0x82, 0xff, 0x4f,
    0xff, 0xff, 0xff, 0x5f, 0xf4, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0x4f, 0xff, 0xff, 0xff, 0x5f, 0xf4,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0x4f, 0xff, 0xff,
    0xff, 0x5f, 0xf4, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0x93, 0x44, 0x44, 0x43, 0xf, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x68, 0x88, 0x88, 0x71, 0x0, 0x0,

    /* U+F0C7 "" */
    0x48, 0x88, 0x88, 0x87, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0xf8, 0x0, 0x0, 0xb, 0xfb,
    0xf, 0x80, 0x0, 0x0, 0xbf, 0xf3, 0xfb, 0x77,
    0x77, 0x7d, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0x42, 0xdf, 0xff, 0x4f, 0xff,
    0xc0, 0x8, 0xff, 0xf4, 0xff, 0xfe, 0x0, 0xaf,
    0xff, 0x4f, 0xff, 0xfc, 0xaf, 0xff, 0xf4, 0xaf,
    0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F0E7 "" */
    0x1, 0xbb, 0xba, 0x10, 0x0, 0x5f, 0xff, 0xf1,
    0x0, 0x7, 0xff, 0xfb, 0x0, 0x0, 0x9f, 0xff,
    0x60, 0x0, 0xb, 0xff, 0xff, 0xff, 0x60, 0xef,
    0xff, 0xff, 0xf1, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xc, 0xfe, 0x0, 0x0, 0x0, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0xa9, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x2a, 0x50, 0x0, 0x0, 0xe, 0xff, 0x8f,
    0xff, 0x20, 0x0, 0xff, 0xf8, 0xff, 0xf4, 0x0,
    0xf, 0xff, 0xeb, 0xbb, 0x30, 0x0, 0xff, 0xf4,
    0x99, 0x92, 0x60, 0xf, 0xff, 0x5f, 0xff, 0x4f,
    0xa0, 0xff, 0xf5, 0xff, 0xf5, 0x56, 0x1f, 0xff,
    0x5f, 0xff, 0xff, 0xf4, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0x4e, 0xff, 0x5f, 0xff, 0xff, 0xf4, 0x0,
    0x5, 0xff, 0xff, 0xff, 0x40, 0x0, 0x5f, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x44, 0x44, 0x44, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x15, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xf9, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xf7, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0x50, 0x6f, 0xff, 0xff, 0xff,
    0xfd, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x24,
    0x44, 0x44, 0x44, 0x43, 0x0, 0x0, 0x2f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x46, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xfc,
    0x8e, 0x8e, 0x8e, 0x88, 0xe8, 0xf7, 0xf8, 0xc,
    0xc, 0xb, 0x0, 0xb0, 0xf8, 0xff, 0xec, 0xfc,
    0xec, 0xee, 0xcf, 0xf8, 0xff, 0xa0, 0xc0, 0xa0,
    0x77, 0x2f, 0xf8, 0xff, 0xec, 0xfc, 0xec, 0xee,
    0xcf, 0xf8, 0xf8, 0xc, 0x0, 0x0, 0x0, 0xb0,
    0xf8, 0xfc, 0x8e, 0x88, 0x88, 0x88, 0xe8, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x18, 0xef, 0xe0, 0x0, 0x0,
    0x0, 0x29, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x3a,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x4c, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x1, 0x34, 0x44, 0xdf, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26,
    0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x9b, 0xbb, 0xb2, 0x70, 0xf, 0xff, 0xff, 0x4f,
    0x90, 0xff, 0xff, 0xf4, 0xff, 0x9f, 0xff, 0xff,
    0x54, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x44,
    0x44, 0x44, 0x30,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x9b, 0xcb, 0x95, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3, 0xef,
    0xfa, 0x53, 0x23, 0x5a, 0xff, 0xe3, 0xdf, 0xa1,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xd2, 0x60, 0x5,
    0xbe, 0xfe, 0xb5, 0x0, 0x52, 0x0, 0x1c, 0xff,
    0xfe, 0xff, 0xfc, 0x10, 0x0, 0x2, 0xec, 0x40,
    0x0, 0x4c, 0xe2, 0x0, 0x0, 0x1, 0x0, 0x1,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd6, 0x0,
    0x0, 0x0,

    /* U+F240 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xf8, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0xcc, 0xcc, 0xc3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F241 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x44, 0x43, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0xff, 0xc0, 0x2, 0xcf, 0xf8, 0xcf,
    0xff, 0xff, 0xfc, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0xcc, 0x90, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F242 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x42, 0x0, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0x80, 0x0, 0x2, 0xcf, 0xf8, 0xcf,
    0xff, 0xf8, 0x0, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0x60, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F243 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x41, 0x0, 0x0, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0x40, 0x0, 0x0, 0x2, 0xcf, 0xf8, 0xcf,
    0xf4, 0x0, 0x0, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0x30, 0x0, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F244 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xdf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xcf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x25, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xcb, 0xfe, 0x0, 0x0, 0x0,
    0x1, 0x0, 0xd, 0x10, 0x42, 0x0, 0x0, 0x0,
    0x9f, 0xd1, 0x68, 0x0, 0x0, 0x0, 0x68, 0x0,
    0xff, 0xfe, 0xee, 0xed, 0xdd, 0xdd, 0xef, 0xc0,
    0x9f, 0xd1, 0x0, 0xb3, 0x0, 0x0, 0x68, 0x0,
    0x1, 0x0, 0x0, 0x3b, 0x5, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xbe, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x34, 0x20, 0x0, 0x0, 0x6e, 0xfe,
    0xfd, 0x20, 0x4, 0xff, 0xf3, 0xff, 0xd0, 0xc,
    0xff, 0xf0, 0x4f, 0xf5, 0xf, 0xd5, 0xf2, 0x95,
    0xf8, 0x2f, 0xf7, 0x41, 0x3c, 0xfa, 0x3f, 0xff,
    0x60, 0xaf, 0xfb, 0x3f, 0xfe, 0x20, 0x4f, 0xfb,
    0x2f, 0xe2, 0x92, 0x75, 0xfa, 0xf, 0xeb, 0xf1,
    0x49, 0xf8, 0x9, 0xff, 0xf0, 0x9f, 0xf2, 0x1,
    0xdf, 0xf9, 0xff, 0x90, 0x0, 0x6, 0xab, 0x95,
    0x0,

    /* U+F2ED "" */
    0x0, 0x4, 0x88, 0x70, 0x0, 0xb, 0xcc, 0xff,
    0xff, 0xdc, 0xc5, 0xbc, 0xcc, 0xcc, 0xcc, 0xcc,
    0x52, 0x88, 0x88, 0x88, 0x88, 0x60, 0x4f, 0xff,
    0xff, 0xff, 0xfc, 0x4, 0xfa, 0xae, 0x6f, 0x5f,
    0xc0, 0x4f, 0xaa, 0xe6, 0xf4, 0xfc, 0x4, 0xfa,
    0xae, 0x6f, 0x4f, 0xc0, 0x4f, 0xaa, 0xe6, 0xf4,
    0xfc, 0x4, 0xfa, 0xae, 0x6f, 0x4f, 0xc0, 0x4f,
    0xaa, 0xe6, 0xf5, 0xfc, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x6, 0x88, 0x88, 0x88, 0x72, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x71, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xd1, 0x0, 0x0, 0x0,
    0x1, 0x5f, 0xff, 0xc0, 0x0, 0x0, 0x2, 0xea,
    0x5f, 0xfd, 0x0, 0x0, 0x2, 0xef, 0xfa, 0x5d,
    0x20, 0x0, 0x2, 0xef, 0xff, 0xf8, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xfe, 0x20, 0x0, 0x2, 0xef,
    0xff, 0xfe, 0x20, 0x0, 0x2, 0xef, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0xbf, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0xd, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x6, 0x64,
    0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x5, 0xef, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5,
    0xff, 0xff, 0x91, 0xdd, 0x19, 0xff, 0xf5, 0xff,
    0xff, 0xfd, 0x11, 0x11, 0xdf, 0xff, 0xef, 0xff,
    0xff, 0xfb, 0x0, 0xbf, 0xff, 0xf5, 0xff, 0xff,
    0xfd, 0x11, 0x11, 0xdf, 0xff, 0x5, 0xff, 0xff,
    0x91, 0xdd, 0x19, 0xff, 0xf0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F7C2 "" */
    0x0, 0x17, 0x88, 0x87, 0x20, 0x2d, 0xff, 0xff,
    0xfd, 0x2e, 0xa0, 0xb3, 0x78, 0xfe, 0xfa, 0xb,
    0x37, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0x4, 0x44,
    0x44, 0x44, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x69, 0x0,
    0x0, 0x0, 0xdf, 0x0, 0x7f, 0xc0, 0x0, 0x0,
    0xd, 0xf0, 0x8f, 0xff, 0xdd, 0xdd, 0xdd, 0xff,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xb,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 48, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 52, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14, .adv_w = 62, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 22, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 54, .adv_w = 110, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 96, .adv_w = 142, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 137, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 173, .adv_w = 31, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 177, .adv_w = 67, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 205, .adv_w = 68, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 233, .adv_w = 87, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 251, .adv_w = 105, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 276, .adv_w = 47, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 282, .adv_w = 74, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 288, .adv_w = 56, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 291, .adv_w = 72, .box_w = 6, .box_h = 10, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 321, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 353, .adv_w = 110, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 376, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 408, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 440, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 472, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 504, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 536, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 568, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 600, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 632, .adv_w = 54, .box_w = 3, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 643, .adv_w = 50, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 658, .adv_w = 98, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 682, .adv_w = 110, .box_w = 7, .box_h = 4, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 696, .adv_w = 99, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 717, .adv_w = 96, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 744, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 810, .adv_w = 129, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 851, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 887, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 923, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 959, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 991, .adv_w = 105, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1023, .adv_w = 131, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1059, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1095, .adv_w = 56, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1109, .adv_w = 107, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1136, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1172, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1204, .adv_w = 168, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1249, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1285, .adv_w = 133, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1321, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1357, .adv_w = 133, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1401, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1437, .adv_w = 118, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1469, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1505, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1541, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1577, .adv_w = 168, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1627, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1663, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1699, .adv_w = 116, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1731, .adv_w = 53, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1761, .adv_w = 81, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1791, .adv_w = 53, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1814, .adv_w = 84, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 1827, .adv_w = 86, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1836, .adv_w = 63, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 1840, .adv_w = 103, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1865, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1900, .adv_w = 100, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1921, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1956, .adv_w = 104, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1981, .adv_w = 69, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2006, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2041, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2076, .adv_w = 51, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2091, .adv_w = 50, .box_w = 4, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2117, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2152, .adv_w = 51, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2167, .adv_w = 166, .box_w = 10, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2202, .adv_w = 108, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2227, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2252, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2287, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2322, .adv_w = 70, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2342, .adv_w = 99, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2363, .adv_w = 65, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2381, .adv_w = 107, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2406, .adv_w = 97, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2427, .adv_w = 141, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2459, .adv_w = 98, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2484, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2514, .adv_w = 98, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2535, .adv_w = 63, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2561, .adv_w = 49, .box_w = 2, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2572, .adv_w = 63, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2598, .adv_w = 125, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2610, .adv_w = 48, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2610, .adv_w = 54, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2625, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2660, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2692, .adv_w = 133, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2732, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2764, .adv_w = 48, .box_w = 3, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2781, .adv_w = 121, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2823, .adv_w = 90, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 2829, .adv_w = 151, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2874, .adv_w = 85, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2887, .adv_w = 96, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2905, .adv_w = 106, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2914, .adv_w = 74, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2920, .adv_w = 151, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2965, .adv_w = 96, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 2971, .adv_w = 75, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 2979, .adv_w = 103, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3006, .adv_w = 72, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3019, .adv_w = 72, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3032, .adv_w = 64, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 3036, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3071, .adv_w = 94, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3098, .adv_w = 58, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 3101, .adv_w = 51, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3107, .adv_w = 72, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3117, .adv_w = 88, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3130, .adv_w = 96, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 3148, .adv_w = 138, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3193, .adv_w = 146, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3243, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3288, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3318, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3372, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3426, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3480, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3534, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3588, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3642, .adv_w = 180, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3692, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3740, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3782, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3824, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3866, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3908, .adv_w = 56, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3932, .adv_w = 56, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3956, .adv_w = 56, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3986, .adv_w = 56, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4016, .adv_w = 128, .box_w = 9, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4057, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4105, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4153, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4201, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4249, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4297, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4345, .adv_w = 102, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4366, .adv_w = 132, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4410, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4458, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4506, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4554, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4602, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4650, .adv_w = 117, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4682, .adv_w = 121, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4722, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4757, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4792, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4827, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4862, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4894, .adv_w = 103, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4933, .adv_w = 162, .box_w = 10, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4968, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4998, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5033, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5068, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5103, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5135, .adv_w = 53, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5155, .adv_w = 53, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5175, .adv_w = 53, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5200, .adv_w = 53, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5223, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5258, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5293, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5328, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5363, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5398, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5433, .adv_w = 109, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5465, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5490, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5522, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5557, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5592, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5627, .adv_w = 107, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5659, .adv_w = 96, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5698, .adv_w = 109, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5744, .adv_w = 96, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5780, .adv_w = 129, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5830, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5862, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5916, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5951, .adv_w = 129, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6005, .adv_w = 103, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6040, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6088, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6118, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6166, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6196, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6244, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6274, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6322, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6352, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6400, .adv_w = 122, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6445, .adv_w = 128, .box_w = 9, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6486, .adv_w = 121, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6526, .adv_w = 108, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6565, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6597, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6639, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6674, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6716, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6751, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6793, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6828, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6870, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6905, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6953, .adv_w = 110, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6999, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7047, .adv_w = 110, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7093, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7141, .adv_w = 110, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7187, .adv_w = 131, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7239, .adv_w = 110, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7288, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7336, .adv_w = 107, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7378, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7419, .adv_w = 110, .box_w = 8, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7459, .adv_w = 56, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7489, .adv_w = 53, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7514, .adv_w = 56, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7542, .adv_w = 53, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7565, .adv_w = 56, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7595, .adv_w = 53, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7620, .adv_w = 56, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7638, .adv_w = 51, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7658, .adv_w = 56, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7676, .adv_w = 53, .box_w = 3, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7687, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7732, .adv_w = 101, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7771, .adv_w = 107, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7819, .adv_w = 54, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7852, .adv_w = 122, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7900, .adv_w = 103, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7949, .adv_w = 113, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7974, .adv_w = 104, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8016, .adv_w = 51, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8040, .adv_w = 104, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8086, .adv_w = 51, .box_w = 3, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8107, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8139, .adv_w = 65, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8164, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8196, .adv_w = 72, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8221, .adv_w = 107, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8253, .adv_w = 59, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8273, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8321, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8356, .adv_w = 136, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8408, .adv_w = 108, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8447, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8495, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8530, .adv_w = 108, .box_w = 8, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8570, .adv_w = 135, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8618, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8653, .adv_w = 133, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8697, .adv_w = 109, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8729, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8777, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8812, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8860, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8895, .adv_w = 186, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8945, .adv_w = 173, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8984, .adv_w = 123, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9032, .adv_w = 70, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9057, .adv_w = 123, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9109, .adv_w = 70, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9139, .adv_w = 123, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9187, .adv_w = 70, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9212, .adv_w = 118, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9254, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9284, .adv_w = 118, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9326, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9356, .adv_w = 118, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9398, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9428, .adv_w = 118, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9470, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9500, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9548, .adv_w = 65, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9578, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9626, .adv_w = 69, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9654, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9690, .adv_w = 65, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9713, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9761, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9796, .adv_w = 126, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9840, .adv_w = 107, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9872, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9920, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9955, .adv_w = 126, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10007, .adv_w = 107, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10046, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10094, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10129, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10177, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10212, .adv_w = 168, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10278, .adv_w = 141, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10323, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10371, .adv_w = 96, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10410, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10458, .adv_w = 116, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10500, .adv_w = 98, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10530, .adv_w = 116, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10572, .adv_w = 98, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10602, .adv_w = 116, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10644, .adv_w = 98, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10674, .adv_w = 50, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10694, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10772, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10826, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10892, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10946, .adv_w = 132, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10987, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11065, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11143, .adv_w = 216, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11220, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11298, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11361, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11439, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11469, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11514, .adv_w = 216, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11605, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11659, .adv_w = 168, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11707, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11779, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11840, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11901, .adv_w = 168, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11949, .adv_w = 168, .box_w = 12, .box_h = 11, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 12015, .adv_w = 120, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12054, .adv_w = 120, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12093, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12154, .adv_w = 168, .box_w = 11, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 12171, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12234, .adv_w = 240, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12338, .adv_w = 216, .box_w = 15, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 12436, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12502, .adv_w = 168, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12541, .adv_w = 168, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12580, .adv_w = 240, .box_w = 16, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12660, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12714, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12792, .adv_w = 192, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 12877, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12938, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13010, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13071, .adv_w = 120, .box_w = 9, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 13130, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13202, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13274, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13337, .adv_w = 192, .box_w = 14, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 13428, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13487, .adv_w = 240, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13577, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13645, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13713, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13781, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13849, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13917, .adv_w = 240, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 14005, .adv_w = 168, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14070, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14142, .adv_w = 192, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 14227, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14295, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14354, .adv_w = 193, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -6, 0,
    -2, -9, 0, -9, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    4, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    -8, 0, -2, 0, 0, -11, -2, -7,
    -4, 0, -14, 0, 0, 0, 0, 0,
    -4, -1, 0, 0, -2, -1, -5, -3,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -2,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -11, 0, 0,
    0, -2, 0, 0, 0, -8, 0, -2,
    0, -2, -4, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, -2, -2,
    0, -2, 0, 0, 0, -2, -2, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -26, 0, 0,
    0, -18, 0, -19, 0, 2, 0, 0,
    0, 0, 0, 0, 0, -3, -2, 0,
    0, -2, -2, 0, 0, -2, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -3, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -3, 0, 0, 0, -2, -4, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, 0, 0, 0, 0, 0, 0,
    0, 2, -6, 0, 0, -19, -2, -19,
    -9, 0, -26, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -12, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -38, 0, 0,
    0, -17, 0, -17, 0, 0, 0, 0,
    0, -5, 0, -3, 0, -1, -1, 0,
    0, -1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, -28, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -3,
    -2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -2,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, -24, -25, 0,
    0, -11, -3, -20, -1, 2, 0, 2,
    1, 0, 2, 0, 0, -16, -8, 0,
    -8, -19, -6, -7, 0, -6, -8, -4,
    -7, -6, 0, -14, -14, -18, -8, -9,
    0, 0, 0, 2, 0, -20, -15, 0,
    0, -7, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -4, -4, 0,
    0, -4, -3, 0, 0, -3, -1, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, -13, -6, 0,
    0, -4, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, -3, -3, 0,
    0, -3, -2, 0, 0, -2, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, 0,
    0, 0, -2, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -2, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 2, -5, -22, -14, 0,
    0, -14, -3, -9, -1, 2, -9, 2,
    2, 1, 2, 0, 2, -6, -6, -2,
    -4, -6, -4, -5, -2, -4, -2, 0,
    -2, -3, 2, -8, -5, -9, -6, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -1, -1, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -1, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -2, 2,
    0, -3, 0, 0, 5, 0, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, 1,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_bold_12 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_BOLD_12*/


