#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 18 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_18
#define RB_LV_FONT_ROBOTO_18 1
#endif

#if RB_LV_FONT_ROBOTO_18

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x8f, 0x28, 0xf2, 0x8f, 0x27, 0xf1, 0x7f, 0x17,
    0xf1, 0x7f, 0x17, 0xf1, 0x6f, 0x3, 0x70, 0x0,
    0x5, 0xd1, 0x6f, 0x20,

    /* U+22 "\"" */
    0xc7, 0x6d, 0xc6, 0x6c, 0xc5, 0x6b, 0xc4, 0x6a,
    0x61, 0x34,

    /* U+23 "#" */
    0x0, 0x2, 0xf1, 0x9, 0xa0, 0x0, 0x6, 0xd0,
    0xd, 0x60, 0x0, 0xa, 0x90, 0x1f, 0x20, 0x4f,
    0xff, 0xff, 0xff, 0xfd, 0x14, 0x5f, 0x64, 0xad,
    0x43, 0x0, 0x3f, 0x0, 0xa9, 0x0, 0x0, 0x6d,
    0x0, 0xc7, 0x0, 0x0, 0x8b, 0x0, 0xf5, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x33, 0xf7, 0x37,
    0xe3, 0x30, 0x1, 0xf2, 0x8, 0xb0, 0x0, 0x4,
    0xf0, 0xb, 0x80, 0x0, 0x7, 0xc0, 0xe, 0x50,
    0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x25, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x1, 0x9f, 0x30, 0x0, 0x0,
    0x6f, 0xff, 0xfb, 0x0, 0x2, 0xfb, 0x21, 0x8f,
    0x70, 0x7, 0xf3, 0x0, 0xd, 0xd0, 0x7, 0xf2,
    0x0, 0x8, 0xd0, 0x4, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xc5, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xe6, 0x0, 0x0, 0x0, 0x6, 0xdf, 0x70, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0xc, 0x80, 0x0, 0x8,
    0xf1, 0xd, 0xd0, 0x0, 0xa, 0xf0, 0x6, 0xfa,
    0x33, 0x8f, 0xa0, 0x0, 0x8f, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0xac, 0x10, 0x0, 0x0, 0x0, 0x8c,
    0x0, 0x0,

    /* U+25 "%" */
    0x3, 0xcf, 0xd3, 0x0, 0x0, 0x0, 0x0, 0xe9,
    0x27, 0xe0, 0x0, 0x60, 0x0, 0x1f, 0x20, 0xf,
    0x20, 0x7c, 0x0, 0x0, 0xe6, 0x5, 0xf0, 0x2e,
    0x20, 0x0, 0x4, 0xef, 0xe5, 0xb, 0x80, 0x0,
    0x0, 0x0, 0x10, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaa, 0x9, 0xed, 0x40, 0x0, 0x0, 0x4e, 0x18,
    0xd3, 0x6f, 0x20, 0x0, 0xd, 0x60, 0xc6, 0x0,
    0xd5, 0x0, 0x8, 0xc0, 0xc, 0x60, 0xd, 0x50,
    0x0, 0x82, 0x0, 0x8c, 0x25, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xd5, 0x0,

    /* U+26 "&" */
    0x0, 0x9, 0xef, 0xb1, 0x0, 0x0, 0x0, 0xaf,
    0x87, 0xed, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x6f,
    0x10, 0x0, 0x0, 0xfa, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0xaf, 0x38, 0xf6, 0x0, 0x0, 0x0, 0x1e,
    0xfe, 0x50, 0x0, 0x0, 0x0, 0x6f, 0xfc, 0x0,
    0x1, 0x0, 0x6, 0xf9, 0x4f, 0xa0, 0x2f, 0x50,
    0xe, 0xc0, 0x7, 0xf7, 0x5f, 0x30, 0x1f, 0x80,
    0x0, 0xaf, 0xde, 0x0, 0xe, 0xc0, 0x0, 0xd,
    0xf8, 0x0, 0x6, 0xfa, 0x43, 0x9f, 0xfd, 0x10,
    0x0, 0x4b, 0xef, 0xc6, 0x4f, 0xb0,

    /* U+27 "'" */
    0x1f, 0x31, 0xf3, 0x1f, 0x21, 0xf1, 0x5, 0x0,

    /* U+28 "(" */
    0x0, 0x2, 0x70, 0x2, 0xe7, 0x0, 0xda, 0x0,
    0x6f, 0x10, 0xd, 0xa0, 0x3, 0xf5, 0x0, 0x7f,
    0x10, 0xa, 0xf0, 0x0, 0xcd, 0x0, 0xc, 0xc0,
    0x0, 0xcd, 0x0, 0xb, 0xe0, 0x0, 0x8f, 0x0,
    0x5, 0xf3, 0x0, 0xf, 0x80, 0x0, 0x9e, 0x0,
    0x1, 0xf6, 0x0, 0x5, 0xf3, 0x0, 0x7, 0xa0,
    0x0, 0x0,

    /* U+29 ")" */
    0x64, 0x0, 0x5, 0xf3, 0x0, 0x8, 0xe1, 0x0,
    0xe, 0x80, 0x0, 0x8f, 0x0, 0x3, 0xf5, 0x0,
    0xf, 0x90, 0x0, 0xcc, 0x0, 0xb, 0xe0, 0x0,
    0xaf, 0x0, 0xb, 0xe0, 0x0, 0xcd, 0x0, 0xe,
    0xb0, 0x2, 0xf7, 0x0, 0x6f, 0x20, 0xb, 0xb0,
    0x3, 0xf3, 0x1, 0xd8, 0x0, 0x89, 0x0, 0x0,
    0x0, 0x0,

    /* U+2A "*" */
    0x0, 0xc, 0x90, 0x0, 0x0, 0xb, 0x80, 0x0,
    0x69, 0x3b, 0x83, 0x92, 0x6d, 0xff, 0xff, 0xd4,
    0x0, 0x6f, 0xf3, 0x0, 0x1, 0xe9, 0xd9, 0x0,
    0x9, 0xe0, 0x4f, 0x40, 0x1, 0x30, 0x6, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x0,
    0x0, 0xce, 0x0, 0x0, 0x29, 0x99, 0xef, 0x99,
    0x94, 0x5f, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0xce, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x0, 0x0, 0xce, 0x0, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0,

    /* U+2C "," */
    0xe, 0xb0, 0xea, 0x1f, 0x78, 0xf1, 0x24, 0x0,

    /* U+2D "-" */
    0x11, 0x11, 0xa, 0xff, 0xf9, 0x34, 0x44, 0x20,

    /* U+2E "." */
    0x7e, 0x28, 0xe2,

    /* U+2F "/" */
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0xc, 0x90, 0x0, 0x2,
    0xf3, 0x0, 0x0, 0x8d, 0x0, 0x0, 0xe, 0x80,
    0x0, 0x4, 0xf2, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x5, 0xf1, 0x0, 0x0, 0xba,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x65, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x3, 0xbf, 0xfc, 0x40, 0x2, 0xfe, 0x77, 0xdf,
    0x30, 0x8f, 0x20, 0x1, 0xfa, 0xd, 0xd0, 0x0,
    0xb, 0xe0, 0xfb, 0x0, 0x0, 0x9f, 0xf, 0xa0,
    0x0, 0x8, 0xf1, 0xfa, 0x0, 0x0, 0x8f, 0x1f,
    0xa0, 0x0, 0x8, 0xf1, 0xea, 0x0, 0x0, 0x9f,
    0xc, 0xd0, 0x0, 0xb, 0xe0, 0x8f, 0x30, 0x1,
    0xfa, 0x1, 0xee, 0x87, 0xdf, 0x20, 0x2, 0xbf,
    0xfc, 0x30, 0x0,

    /* U+31 "1" */
    0x0, 0x5, 0xb6, 0x29, 0xff, 0xf6, 0x8e, 0x86,
    0xf6, 0x10, 0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0,
    0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6,
    0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3,
    0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6,

    /* U+32 "2" */
    0x0, 0x4c, 0xfe, 0xb3, 0x0, 0x5, 0xfc, 0x77,
    0xef, 0x40, 0xe, 0xd0, 0x0, 0x2f, 0xb0, 0x2f,
    0x80, 0x0, 0xd, 0xd0, 0x0, 0x0, 0x0, 0xe,
    0xa0, 0x0, 0x0, 0x0, 0x6f, 0x30, 0x0, 0x0,
    0x3, 0xf9, 0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0,
    0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0xc, 0xe1,
    0x0, 0x0, 0x0, 0xbe, 0x20, 0x0, 0x0, 0xa,
    0xf9, 0x66, 0x66, 0x62, 0xf, 0xff, 0xff, 0xff,
    0xf7,

    /* U+33 "3" */
    0x0, 0x5c, 0xfe, 0xb4, 0x0, 0x8f, 0xb6, 0x7d,
    0xf4, 0xf, 0xc0, 0x0, 0x1f, 0xa0, 0x21, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x13, 0xaf, 0x30, 0x0,
    0x9f, 0xff, 0x40, 0x0, 0x2, 0x46, 0xde, 0x20,
    0x0, 0x0, 0x1, 0xfa, 0x0, 0x0, 0x0, 0xc,
    0xe1, 0xe7, 0x0, 0x0, 0xce, 0xe, 0xd0, 0x0,
    0x1f, 0xa0, 0x6f, 0xc7, 0x7e, 0xf2, 0x0, 0x5c,
    0xff, 0xb2, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0x0, 0x5f, 0xee, 0x0, 0x0,
    0x0, 0xe9, 0xbe, 0x0, 0x0, 0x9, 0xe1, 0xbe,
    0x0, 0x0, 0x3f, 0x60, 0xbe, 0x0, 0x0, 0xcc,
    0x0, 0xbe, 0x0, 0x6, 0xf2, 0x0, 0xbe, 0x0,
    0x1f, 0xa1, 0x11, 0xbe, 0x11, 0x8f, 0xff, 0xff,
    0xff, 0xfb, 0x24, 0x44, 0x44, 0xcf, 0x43, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0,

    /* U+35 "5" */
    0x9, 0xff, 0xff, 0xff, 0x0, 0xbe, 0x88, 0x88,
    0x80, 0xc, 0xb0, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0xf, 0xcd, 0xfe, 0x70, 0x2, 0xff,
    0x99, 0xdf, 0x80, 0x3, 0x10, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0x4f,
    0x56, 0xb0, 0x0, 0x5, 0xf4, 0x5f, 0x50, 0x0,
    0xbf, 0x10, 0xcf, 0x86, 0xbf, 0x80, 0x0, 0x8d,
    0xfd, 0x70, 0x0,

    /* U+36 "6" */
    0x0, 0x7, 0xcf, 0x60, 0x0, 0x1d, 0xfa, 0x82,
    0x0, 0xb, 0xe2, 0x0, 0x0, 0x3, 0xf5, 0x1,
    0x0, 0x0, 0x8f, 0x8e, 0xff, 0x80, 0xb, 0xfe,
    0x75, 0xbf, 0x60, 0xcf, 0x30, 0x0, 0xde, 0xd,
    0xc0, 0x0, 0x7, 0xf2, 0xcd, 0x0, 0x0, 0x6f,
    0x3a, 0xf1, 0x0, 0x8, 0xf2, 0x5f, 0x80, 0x0,
    0xdd, 0x0, 0xbf, 0x97, 0xcf, 0x50, 0x0, 0x8e,
    0xfc, 0x50, 0x0,

    /* U+37 "7" */
    0x5f, 0xff, 0xff, 0xff, 0xf5, 0x16, 0x66, 0x66,
    0x6b, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0,
    0x0,

    /* U+38 "8" */
    0x0, 0x4b, 0xee, 0xc4, 0x0, 0x4, 0xfd, 0x77,
    0xdf, 0x50, 0xa, 0xf1, 0x0, 0xf, 0xc0, 0xa,
    0xf0, 0x0, 0xe, 0xc0, 0x3, 0xfa, 0x22, 0x9f,
    0x50, 0x0, 0x4f, 0xff, 0xf6, 0x0, 0x2, 0xed,
    0x65, 0xce, 0x20, 0xa, 0xe1, 0x0, 0xe, 0xc0,
    0xf, 0xa0, 0x0, 0x9, 0xf0, 0xf, 0xa0, 0x0,
    0x9, 0xf1, 0xc, 0xe1, 0x0, 0xd, 0xd0, 0x4,
    0xfd, 0x77, 0xdf, 0x50, 0x0, 0x3b, 0xff, 0xc4,
    0x0,

    /* U+39 "9" */
    0x0, 0x4c, 0xfe, 0x91, 0x0, 0x4f, 0xd7, 0x8f,
    0xc0, 0xc, 0xe0, 0x0, 0x5f, 0x60, 0xf9, 0x0,
    0x0, 0xeb, 0x1f, 0x80, 0x0, 0xb, 0xe0, 0xec,
    0x0, 0x0, 0xde, 0x8, 0xf9, 0x23, 0xbf, 0xe0,
    0xa, 0xff, 0xf8, 0xcd, 0x0, 0x1, 0x41, 0xe,
    0xa0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x1,
    0xde, 0x0, 0x2, 0x79, 0xff, 0x30, 0x0, 0x5f,
    0xd9, 0x10, 0x0,

    /* U+3A ":" */
    0x9e, 0x19, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x19, 0xe1,

    /* U+3B ";" */
    0xc, 0xc0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0xcc, 0xf,
    0x96, 0xf2, 0x15, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x6d, 0xfc,
    0x0, 0x6e, 0xfc, 0x60, 0x3e, 0xfa, 0x30, 0x0,
    0x5f, 0xd5, 0x0, 0x0, 0x3, 0xbf, 0xe8, 0x10,
    0x0, 0x2, 0xaf, 0xf9, 0x0, 0x0, 0x2, 0x9c,
    0x0, 0x0, 0x0, 0x0,

    /* U+3D "=" */
    0x12, 0x22, 0x22, 0x21, 0xaf, 0xff, 0xff, 0xfa,
    0x35, 0x55, 0x55, 0x53, 0x0, 0x0, 0x0, 0x0,
    0x12, 0x22, 0x22, 0x21, 0xaf, 0xff, 0xff, 0xfa,
    0x35, 0x55, 0x55, 0x53,

    /* U+3E ">" */
    0xa5, 0x0, 0x0, 0x0, 0xcf, 0xe7, 0x0, 0x0,
    0x4, 0xbf, 0xf8, 0x10, 0x0, 0x1, 0x8e, 0xf7,
    0x0, 0x0, 0x4b, 0xfa, 0x1, 0x7d, 0xfc, 0x50,
    0x9f, 0xfb, 0x30, 0x0, 0xc9, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x1, 0x9e, 0xfc, 0x50, 0xc, 0xf9, 0x8d, 0xf4,
    0x3f, 0x70, 0x1, 0xfa, 0x3, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x1d, 0xe1,
    0x0, 0x0, 0xdf, 0x30, 0x0, 0x8, 0xf4, 0x0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x3, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xb, 0xc0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x4, 0xbe, 0xfe, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x95, 0x34, 0x8e, 0xc1, 0x0,
    0x0, 0xc, 0xc1, 0x0, 0x0, 0x0, 0xac, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xd, 0x60,
    0x0, 0xf5, 0x0, 0x1a, 0xed, 0x70, 0x5, 0xc0,
    0x6, 0xe0, 0x0, 0xdb, 0x36, 0xf2, 0x1, 0xf0,
    0xa, 0x90, 0x7, 0xf0, 0x3, 0xf0, 0x0, 0xe2,
    0xd, 0x70, 0xd, 0x90, 0x5, 0xf0, 0x0, 0xd3,
    0xf, 0x50, 0xf, 0x60, 0x6, 0xd0, 0x0, 0xe3,
    0xe, 0x50, 0x2f, 0x40, 0x8, 0xc0, 0x0, 0xf1,
    0xd, 0x60, 0x1f, 0x40, 0xb, 0xb0, 0x5, 0xd0,
    0xb, 0x90, 0xd, 0xb2, 0x8d, 0xf3, 0x4e, 0x50,
    0x6, 0xd0, 0x3, 0xdf, 0x90, 0xaf, 0xe6, 0x0,
    0x1, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfa, 0x53, 0x35, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0xef, 0xec, 0x70, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+42 "B" */
    0x8f, 0xff, 0xff, 0xb4, 0x0, 0x8f, 0x86, 0x68,
    0xef, 0x40, 0x8f, 0x20, 0x0, 0x2f, 0xb0, 0x8f,
    0x20, 0x0, 0xe, 0xd0, 0x8f, 0x20, 0x0, 0x1f,
    0xb0, 0x8f, 0x41, 0x13, 0xcf, 0x30, 0x8f, 0xff,
    0xff, 0xf6, 0x0, 0x8f, 0x64, 0x45, 0xaf, 0x70,
    0x8f, 0x20, 0x0, 0xb, 0xf0, 0x8f, 0x20, 0x0,
    0x8, 0xf2, 0x8f, 0x20, 0x0, 0xc, 0xf0, 0x8f,
    0x86, 0x67, 0xdf, 0x80, 0x8f, 0xff, 0xfe, 0xc5,
    0x0,

    /* U+43 "C" */
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x6, 0xfd, 0x87,
    0xbf, 0xc0, 0x2f, 0xc0, 0x0, 0x7, 0xf6, 0x8f,
    0x30, 0x0, 0x0, 0xfc, 0xde, 0x0, 0x0, 0x0,
    0x33, 0xec, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x0, 0x23, 0x9f, 0x30, 0x0,
    0x0, 0xfc, 0x2f, 0xb0, 0x0, 0x7, 0xf6, 0x7,
    0xfd, 0x87, 0xbf, 0xb0, 0x0, 0x4c, 0xff, 0xd7,
    0x0,

    /* U+44 "D" */
    0x8f, 0xff, 0xfd, 0x70, 0x0, 0x8f, 0x87, 0x7a,
    0xfd, 0x10, 0x8f, 0x20, 0x0, 0x3f, 0xc0, 0x8f,
    0x20, 0x0, 0x7, 0xf3, 0x8f, 0x20, 0x0, 0x1,
    0xf8, 0x8f, 0x20, 0x0, 0x0, 0xfa, 0x8f, 0x20,
    0x0, 0x0, 0xeb, 0x8f, 0x20, 0x0, 0x0, 0xfa,
    0x8f, 0x20, 0x0, 0x1, 0xf8, 0x8f, 0x20, 0x0,
    0x7, 0xf4, 0x8f, 0x20, 0x0, 0x3f, 0xc0, 0x8f,
    0x86, 0x7a, 0xfd, 0x10, 0x8f, 0xff, 0xfd, 0x70,
    0x0,

    /* U+45 "E" */
    0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8, 0x66, 0x66,
    0x63, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf4,
    0x11, 0x11, 0x10, 0x8f, 0xff, 0xff, 0xfb, 0x8,
    0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x64, 0x8f, 0xff,
    0xff, 0xff, 0x90,

    /* U+46 "F" */
    0x8f, 0xff, 0xff, 0xff, 0x68, 0xf8, 0x66, 0x66,
    0x62, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf4,
    0x22, 0x22, 0x10, 0x8f, 0xff, 0xff, 0xf8, 0x8,
    0xf6, 0x55, 0x55, 0x20, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x4b, 0xef, 0xd8, 0x10, 0x7, 0xfd, 0x87,
    0xaf, 0xd1, 0x2f, 0xc0, 0x0, 0x4, 0xf8, 0x9f,
    0x30, 0x0, 0x0, 0x88, 0xce, 0x0, 0x0, 0x0,
    0x0, 0xec, 0x0, 0x1, 0x11, 0x11, 0xec, 0x0,
    0xb, 0xff, 0xff, 0xed, 0x0, 0x3, 0x44, 0xdf,
    0xcf, 0x0, 0x0, 0x0, 0xcf, 0x7f, 0x50, 0x0,
    0x0, 0xcf, 0x1f, 0xd1, 0x0, 0x0, 0xdf, 0x5,
    0xfe, 0x97, 0x9d, 0xf8, 0x0, 0x2a, 0xef, 0xeb,
    0x40,

    /* U+48 "H" */
    0x8f, 0x20, 0x0, 0x0, 0x6f, 0x58, 0xf2, 0x0,
    0x0, 0x6, 0xf5, 0x8f, 0x20, 0x0, 0x0, 0x6f,
    0x58, 0xf2, 0x0, 0x0, 0x6, 0xf5, 0x8f, 0x20,
    0x0, 0x0, 0x6f, 0x58, 0xf4, 0x11, 0x11, 0x17,
    0xf5, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x58, 0xf6,
    0x44, 0x44, 0x48, 0xf5, 0x8f, 0x20, 0x0, 0x0,
    0x6f, 0x58, 0xf2, 0x0, 0x0, 0x6, 0xf5, 0x8f,
    0x20, 0x0, 0x0, 0x6f, 0x58, 0xf2, 0x0, 0x0,
    0x6, 0xf5, 0x8f, 0x20, 0x0, 0x0, 0x6f, 0x50,

    /* U+49 "I" */
    0x6f, 0x46, 0xf4, 0x6f, 0x46, 0xf4, 0x6f, 0x46,
    0xf4, 0x6f, 0x46, 0xf4, 0x6f, 0x46, 0xf4, 0x6f,
    0x46, 0xf4, 0x6f, 0x40,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x2,
    0xf8, 0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0,
    0x2, 0xf8, 0x0, 0x0, 0x0, 0x2f, 0x80, 0x0,
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x2f,
    0x86, 0xc2, 0x0, 0x3, 0xf8, 0x5f, 0x70, 0x0,
    0x9f, 0x50, 0xdf, 0xa7, 0xaf, 0xc0, 0x1, 0x9d,
    0xfe, 0x90, 0x0,

    /* U+4B "K" */
    0x8f, 0x20, 0x0, 0x9, 0xf7, 0x8, 0xf2, 0x0,
    0x7, 0xf9, 0x0, 0x8f, 0x20, 0x5, 0xfb, 0x0,
    0x8, 0xf2, 0x4, 0xfc, 0x0, 0x0, 0x8f, 0x22,
    0xfd, 0x10, 0x0, 0x8, 0xf4, 0xef, 0x20, 0x0,
    0x0, 0x8f, 0xef, 0xf6, 0x0, 0x0, 0x8, 0xff,
    0x4d, 0xf3, 0x0, 0x0, 0x8f, 0x50, 0x2f, 0xd0,
    0x0, 0x8, 0xf2, 0x0, 0x5f, 0xa0, 0x0, 0x8f,
    0x20, 0x0, 0x9f, 0x60, 0x8, 0xf2, 0x0, 0x0,
    0xdf, 0x30, 0x8f, 0x20, 0x0, 0x2, 0xfd, 0x0,

    /* U+4C "L" */
    0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x61, 0x8f, 0xff,
    0xff, 0xff, 0x40,

    /* U+4D "M" */
    0x8f, 0xd0, 0x0, 0x0, 0x0, 0x2f, 0xf3, 0x8f,
    0xf4, 0x0, 0x0, 0x0, 0x9f, 0xf3, 0x8f, 0xfa,
    0x0, 0x0, 0x0, 0xef, 0xf3, 0x8f, 0xaf, 0x10,
    0x0, 0x5, 0xf9, 0xf3, 0x8f, 0x4f, 0x70, 0x0,
    0xb, 0xd6, 0xf3, 0x8f, 0x1c, 0xd0, 0x0, 0x2f,
    0x76, 0xf3, 0x8f, 0x26, 0xf3, 0x0, 0x8f, 0x16,
    0xf3, 0x8f, 0x20, 0xf9, 0x0, 0xea, 0x7, 0xf3,
    0x8f, 0x20, 0x9f, 0x5, 0xf4, 0x7, 0xf3, 0x8f,
    0x20, 0x3f, 0x6b, 0xd0, 0x7, 0xf3, 0x8f, 0x20,
    0xc, 0xdf, 0x70, 0x7, 0xf3, 0x8f, 0x20, 0x6,
    0xff, 0x10, 0x7, 0xf3, 0x8f, 0x20, 0x0, 0xfa,
    0x0, 0x7, 0xf3,

    /* U+4E "N" */
    0x8f, 0x80, 0x0, 0x0, 0x5f, 0x58, 0xff, 0x20,
    0x0, 0x5, 0xf5, 0x8f, 0xfc, 0x0, 0x0, 0x5f,
    0x58, 0xfa, 0xf6, 0x0, 0x5, 0xf5, 0x8f, 0x3d,
    0xf1, 0x0, 0x5f, 0x58, 0xf3, 0x3f, 0xb0, 0x5,
    0xf5, 0x8f, 0x30, 0x8f, 0x50, 0x5f, 0x58, 0xf3,
    0x0, 0xde, 0x15, 0xf5, 0x8f, 0x30, 0x4, 0xfa,
    0x5f, 0x58, 0xf3, 0x0, 0xa, 0xfa, 0xf5, 0x8f,
    0x30, 0x0, 0x1e, 0xff, 0x58, 0xf3, 0x0, 0x0,
    0x5f, 0xf5, 0x8f, 0x30, 0x0, 0x0, 0xbf, 0x50,

    /* U+4F "O" */
    0x0, 0x3b, 0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9,
    0x8c, 0xfb, 0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7,
    0x8, 0xf4, 0x0, 0x0, 0xd, 0xe0, 0xce, 0x0,
    0x0, 0x0, 0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6,
    0xf4, 0xfb, 0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0,
    0x0, 0x0, 0x6, 0xf4, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x28, 0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f,
    0xc1, 0x0, 0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b,
    0xfb, 0x0, 0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+50 "P" */
    0x8f, 0xff, 0xff, 0xd8, 0x0, 0x8f, 0x87, 0x77,
    0xbf, 0xc0, 0x8f, 0x20, 0x0, 0x8, 0xf5, 0x8f,
    0x20, 0x0, 0x1, 0xf9, 0x8f, 0x20, 0x0, 0x0,
    0xfa, 0x8f, 0x20, 0x0, 0x4, 0xf8, 0x8f, 0x41,
    0x12, 0x5e, 0xf1, 0x8f, 0xff, 0xff, 0xfd, 0x30,
    0x8f, 0x64, 0x44, 0x20, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x0,

    /* U+51 "Q" */
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x6f,
    0xe9, 0x8c, 0xfa, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x8f, 0x60, 0x9, 0xf3, 0x0, 0x0, 0xe, 0xd0,
    0xe, 0xd0, 0x0, 0x0, 0x9, 0xf1, 0xf, 0xb0,
    0x0, 0x0, 0x7, 0xf3, 0xf, 0xa0, 0x0, 0x0,
    0x6, 0xf4, 0xf, 0xb0, 0x0, 0x0, 0x7, 0xf3,
    0xe, 0xd0, 0x0, 0x0, 0x9, 0xf1, 0x9, 0xf3,
    0x0, 0x0, 0xd, 0xd0, 0x3, 0xfc, 0x0, 0x0,
    0x8f, 0x60, 0x0, 0x6f, 0xe8, 0x8c, 0xfa, 0x0,
    0x0, 0x4, 0xbe, 0xfe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52 "R" */
    0x8f, 0xff, 0xfe, 0xc5, 0x0, 0x8f, 0x87, 0x78,
    0xdf, 0x80, 0x8f, 0x20, 0x0, 0xd, 0xf0, 0x8f,
    0x20, 0x0, 0x8, 0xf2, 0x8f, 0x20, 0x0, 0xb,
    0xf1, 0x8f, 0x41, 0x13, 0x9f, 0x90, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x8f, 0x64, 0x4c, 0xf1, 0x0,
    0x8f, 0x20, 0x3, 0xf8, 0x0, 0x8f, 0x20, 0x0,
    0xcf, 0x10, 0x8f, 0x20, 0x0, 0x4f, 0x80, 0x8f,
    0x20, 0x0, 0xc, 0xf1, 0x8f, 0x20, 0x0, 0x4,
    0xf8,

    /* U+53 "S" */
    0x0, 0x2a, 0xdf, 0xe9, 0x10, 0x3, 0xfe, 0x97,
    0x9f, 0xe2, 0xb, 0xf2, 0x0, 0x3, 0xfa, 0xd,
    0xd0, 0x0, 0x0, 0xac, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xa5, 0x0, 0x0, 0x0, 0x8,
    0xef, 0xf9, 0x20, 0x0, 0x0, 0x3, 0x9f, 0xf3,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x3e, 0x60, 0x0,
    0x0, 0xbf, 0xe, 0xd1, 0x0, 0x1, 0xed, 0x5,
    0xfe, 0x97, 0x8e, 0xf5, 0x0, 0x2a, 0xef, 0xea,
    0x30,

    /* U+54 "T" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x53, 0x66, 0x6b,
    0xf8, 0x66, 0x62, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+55 "U" */
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf7, 0xbf, 0x0, 0x0,
    0x5, 0xf6, 0x6f, 0x70, 0x0, 0xc, 0xf2, 0xc,
    0xfb, 0x78, 0xdf, 0x80, 0x0, 0x8d, 0xff, 0xc5,
    0x0,

    /* U+56 "V" */
    0x9f, 0x30, 0x0, 0x0, 0xc, 0xf1, 0x3f, 0x90,
    0x0, 0x0, 0x2f, 0xa0, 0xd, 0xe0, 0x0, 0x0,
    0x7f, 0x40, 0x7, 0xf3, 0x0, 0x0, 0xce, 0x0,
    0x1, 0xf9, 0x0, 0x2, 0xf9, 0x0, 0x0, 0xbe,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x6f, 0x40, 0xc,
    0xd0, 0x0, 0x0, 0xf, 0x90, 0x2f, 0x70, 0x0,
    0x0, 0xa, 0xe0, 0x7f, 0x20, 0x0, 0x0, 0x4,
    0xf4, 0xdc, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0,

    /* U+57 "W" */
    0x5f, 0x50, 0x0, 0xc, 0xe0, 0x0, 0x3, 0xf7,
    0x1f, 0x80, 0x0, 0xf, 0xf3, 0x0, 0x7, 0xf3,
    0xe, 0xc0, 0x0, 0x4f, 0xf7, 0x0, 0xa, 0xf0,
    0xa, 0xf0, 0x0, 0x9e, 0xac, 0x0, 0xe, 0xb0,
    0x6, 0xf3, 0x0, 0xda, 0x6f, 0x0, 0x1f, 0x80,
    0x2, 0xf7, 0x2, 0xf5, 0x2f, 0x40, 0x5f, 0x40,
    0x0, 0xeb, 0x6, 0xf1, 0xd, 0x90, 0x8f, 0x0,
    0x0, 0xae, 0xb, 0xc0, 0x9, 0xd0, 0xcc, 0x0,
    0x0, 0x7f, 0x2f, 0x70, 0x4, 0xf2, 0xf8, 0x0,
    0x0, 0x3f, 0x9f, 0x20, 0x0, 0xf9, 0xf5, 0x0,
    0x0, 0xf, 0xee, 0x0, 0x0, 0xce, 0xf1, 0x0,
    0x0, 0xb, 0xf9, 0x0, 0x0, 0x7f, 0xd0, 0x0,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+58 "X" */
    0x2f, 0xd0, 0x0, 0x0, 0x9f, 0x60, 0x7f, 0x70,
    0x0, 0x3f, 0xc0, 0x0, 0xdf, 0x20, 0xc, 0xf2,
    0x0, 0x3, 0xfb, 0x6, 0xf8, 0x0, 0x0, 0x9,
    0xf6, 0xed, 0x0, 0x0, 0x0, 0xe, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0x50, 0x0, 0x0, 0xa, 0xf5, 0xee,
    0x0, 0x0, 0x4, 0xfa, 0x5, 0xf9, 0x0, 0x0,
    0xdf, 0x10, 0xb, 0xf3, 0x0, 0x8f, 0x60, 0x0,
    0x2f, 0xd0, 0x3f, 0xc0, 0x0, 0x0, 0x8f, 0x70,

    /* U+59 "Y" */
    0x9f, 0x50, 0x0, 0x0, 0x8f, 0x51, 0xfc, 0x0,
    0x0, 0x1f, 0xd0, 0x8, 0xf5, 0x0, 0x8, 0xf4,
    0x0, 0xe, 0xd0, 0x1, 0xfb, 0x0, 0x0, 0x7f,
    0x50, 0x8f, 0x30, 0x0, 0x0, 0xdd, 0x1f, 0xa0,
    0x0, 0x0, 0x5, 0xfc, 0xf2, 0x0, 0x0, 0x0,
    0xc, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+5A "Z" */
    0x2f, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x66, 0x66,
    0x66, 0xaf, 0x90, 0x0, 0x0, 0x0, 0x1e, 0xe1,
    0x0, 0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x0,
    0x5, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xed, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x0, 0x1f, 0xd0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x6,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0xff, 0x66, 0x66,
    0x66, 0x60, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x10,

    /* U+5B "[" */
    0x11, 0x10, 0xbf, 0xf9, 0xbf, 0x42, 0xbe, 0x0,
    0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0,
    0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0,
    0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0, 0xbe, 0x0,
    0xbe, 0x0, 0xbe, 0x10, 0xbf, 0xf9, 0x34, 0x42,

    /* U+5C "\\" */
    0x7f, 0x10, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x3f, 0x40, 0x0, 0x0, 0xd, 0xa0, 0x0,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0x2, 0xf6, 0x0,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x3, 0x81,

    /* U+5D "]" */
    0x11, 0x10, 0xef, 0xf6, 0x47, 0xf6, 0x3, 0xf6,
    0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6,
    0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6,
    0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6, 0x3, 0xf6,
    0x3, 0xf6, 0x14, 0xf6, 0xef, 0xf6, 0x44, 0x41,

    /* U+5E "^" */
    0x0, 0x7, 0x30, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x9f, 0xf1, 0x0, 0x1f, 0x6e, 0x80, 0x6, 0xf1,
    0x8e, 0x0, 0xda, 0x2, 0xf5, 0x3f, 0x40, 0xc,
    0xb0,

    /* U+5F "_" */
    0x11, 0x11, 0x11, 0x11, 0xf, 0xff, 0xff, 0xff,
    0xf1, 0x44, 0x44, 0x44, 0x44, 0x0,

    /* U+60 "`" */
    0x28, 0x50, 0x0, 0x9f, 0x20, 0x0, 0xac, 0x0,

    /* U+61 "a" */
    0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x5f, 0xc6, 0x7e,
    0xe1, 0xa, 0xc0, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff, 0x70, 0x8f,
    0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0, 0x2f, 0x70,
    0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb, 0x8b, 0xff,
    0x80, 0x9, 0xef, 0xb3, 0xc9,

    /* U+62 "b" */
    0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0xcd, 0x5d, 0xfd, 0x60, 0xc, 0xfe,
    0x87, 0xdf, 0x50, 0xcf, 0x20, 0x0, 0xed, 0xc,
    0xd0, 0x0, 0x8, 0xf1, 0xcd, 0x0, 0x0, 0x6f,
    0x3c, 0xd0, 0x0, 0x6, 0xf3, 0xcd, 0x0, 0x0,
    0x8f, 0x1c, 0xf2, 0x0, 0x1e, 0xd0, 0xcf, 0xe8,
    0x8d, 0xf5, 0xc, 0xb5, 0xdf, 0xd6, 0x0,

    /* U+63 "c" */
    0x0, 0x2b, 0xee, 0xb2, 0x0, 0x2f, 0xe7, 0x7e,
    0xe2, 0xb, 0xf1, 0x0, 0x1f, 0x90, 0xf9, 0x0,
    0x0, 0x66, 0x2f, 0x70, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x2, 0x30,
    0xbf, 0x10, 0x1, 0xea, 0x3, 0xfd, 0x77, 0xdf,
    0x20, 0x3, 0xbf, 0xfb, 0x20,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x4c, 0xfd, 0x7c, 0xd0, 0x3f,
    0xe8, 0x7e, 0xfd, 0xc, 0xf2, 0x0, 0x1e, 0xd0,
    0xfa, 0x0, 0x0, 0xcd, 0x2f, 0x80, 0x0, 0xc,
    0xd2, 0xf8, 0x0, 0x0, 0xcd, 0xf, 0xa0, 0x0,
    0xc, 0xd0, 0xbf, 0x0, 0x0, 0xed, 0x3, 0xfc,
    0x55, 0xcf, 0xd0, 0x4, 0xcf, 0xe8, 0xbd,

    /* U+65 "e" */
    0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e, 0xd7, 0x7e,
    0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80, 0xfa, 0x11,
    0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff, 0xe2, 0xfa,
    0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0, 0x0, 0x0,
    0xbf, 0x30, 0x0, 0x72, 0x2, 0xff, 0x86, 0xaf,
    0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+66 "f" */
    0x0, 0x0, 0x1, 0x0, 0x1, 0xbf, 0xf3, 0x0,
    0xaf, 0x85, 0x10, 0xe, 0xc0, 0x0, 0x0, 0xfa,
    0x0, 0x7, 0xff, 0xff, 0xb0, 0x24, 0xfc, 0x43,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0xfa, 0x0, 0x0,

    /* U+67 "g" */
    0x0, 0x4c, 0xfd, 0x7a, 0xe0, 0x3f, 0xe8, 0x7d,
    0xfe, 0xb, 0xf2, 0x0, 0x1e, 0xe0, 0xfb, 0x0,
    0x0, 0xce, 0x2f, 0x80, 0x0, 0xc, 0xe2, 0xf8,
    0x0, 0x0, 0xce, 0xf, 0xa0, 0x0, 0xc, 0xe0,
    0xbf, 0x20, 0x1, 0xee, 0x3, 0xfe, 0x88, 0xef,
    0xe0, 0x4, 0xcf, 0xe7, 0xcd, 0x0, 0x0, 0x0,
    0xd, 0xd0, 0x27, 0x0, 0x3, 0xf9, 0x6, 0xfa,
    0x68, 0xef, 0x20, 0x5, 0xcf, 0xfb, 0x20,

    /* U+68 "h" */
    0xcd, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0xcd, 0x4c, 0xfd, 0x60, 0xcf, 0xe8, 0x7d, 0xf4,
    0xcf, 0x30, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfa,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,

    /* U+69 "i" */
    0x8e, 0x8, 0xd0, 0x0, 0xa, 0xf0, 0xaf, 0xa,
    0xf0, 0xaf, 0xa, 0xf0, 0xaf, 0xa, 0xf0, 0xaf,
    0xa, 0xf0, 0xaf, 0x0,

    /* U+6A "j" */
    0x0, 0xac, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0xbe, 0x0, 0xb, 0xe0, 0x0,
    0xbe, 0x0, 0xb, 0xe0, 0x0, 0xbe, 0x0, 0xb,
    0xe0, 0x0, 0xbe, 0x0, 0xb, 0xe0, 0x0, 0xbe,
    0x0, 0xb, 0xe0, 0x0, 0xcd, 0x4, 0x8f, 0xa0,
    0x8f, 0xc2, 0x0,

    /* U+6B "k" */
    0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0xb, 0xf4, 0xc, 0xd0,
    0xa, 0xf5, 0x0, 0xcd, 0x8, 0xf7, 0x0, 0xc,
    0xd6, 0xf9, 0x0, 0x0, 0xcf, 0xff, 0x30, 0x0,
    0xc, 0xfc, 0xed, 0x0, 0x0, 0xce, 0x5, 0xf9,
    0x0, 0xc, 0xd0, 0x9, 0xf5, 0x0, 0xcd, 0x0,
    0xd, 0xe1, 0xc, 0xd0, 0x0, 0x2f, 0xb0,

    /* U+6C "l" */
    0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf,
    0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf,

    /* U+6D "m" */
    0xcc, 0x5d, 0xfd, 0x60, 0x7e, 0xfc, 0x40, 0xcf,
    0xe8, 0x7e, 0xfb, 0xe7, 0x8e, 0xf2, 0xcf, 0x10,
    0x2, 0xff, 0x10, 0x4, 0xf6, 0xcd, 0x0, 0x0,
    0xfb, 0x0, 0x1, 0xf8, 0xcd, 0x0, 0x0, 0xfb,
    0x0, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfb, 0x0,
    0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfb, 0x0, 0x1,
    0xf9, 0xcd, 0x0, 0x0, 0xfb, 0x0, 0x1, 0xf9,
    0xcd, 0x0, 0x0, 0xfb, 0x0, 0x1, 0xf9, 0xcd,
    0x0, 0x0, 0xfb, 0x0, 0x1, 0xf9,

    /* U+6E "n" */
    0xcc, 0x4c, 0xfd, 0x60, 0xcf, 0xe8, 0x7d, 0xf4,
    0xcf, 0x30, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfa,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,

    /* U+6F "o" */
    0x0, 0x2a, 0xef, 0xc4, 0x0, 0x2, 0xee, 0x87,
    0xdf, 0x50, 0xa, 0xf2, 0x0, 0xd, 0xe0, 0xf,
    0xa0, 0x0, 0x6, 0xf4, 0x2f, 0x80, 0x0, 0x3,
    0xf6, 0x2f, 0x70, 0x0, 0x3, 0xf6, 0xf, 0xa0,
    0x0, 0x6, 0xf4, 0xb, 0xf2, 0x0, 0xd, 0xe0,
    0x2, 0xee, 0x87, 0xdf, 0x50, 0x0, 0x2a, 0xff,
    0xc4, 0x0,

    /* U+70 "p" */
    0xcc, 0x7d, 0xfd, 0x60, 0xc, 0xfc, 0x55, 0xcf,
    0x50, 0xce, 0x0, 0x0, 0xed, 0xc, 0xd0, 0x0,
    0x8, 0xf2, 0xcd, 0x0, 0x0, 0x6f, 0x3c, 0xd0,
    0x0, 0x6, 0xf3, 0xcd, 0x0, 0x0, 0x9f, 0x1c,
    0xf1, 0x0, 0x1e, 0xd0, 0xcf, 0xe7, 0x7d, 0xf5,
    0xc, 0xd6, 0xdf, 0xd6, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x4c, 0xfe, 0x7a, 0xd0, 0x3f, 0xe7, 0x7d,
    0xfd, 0xc, 0xf2, 0x0, 0xe, 0xd0, 0xfa, 0x0,
    0x0, 0xcd, 0x2f, 0x80, 0x0, 0xc, 0xd2, 0xf8,
    0x0, 0x0, 0xcd, 0xf, 0xa0, 0x0, 0xc, 0xd0,
    0xbf, 0x20, 0x0, 0xed, 0x3, 0xfe, 0x77, 0xdf,
    0xd0, 0x4, 0xcf, 0xe7, 0xcd, 0x0, 0x0, 0x0,
    0xc, 0xd0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0xcd,

    /* U+72 "r" */
    0x0, 0x0, 0xc, 0xd7, 0xed, 0xcf, 0xe8, 0x6c,
    0xf1, 0x0, 0xcd, 0x0, 0xc, 0xd0, 0x0, 0xcd,
    0x0, 0xc, 0xd0, 0x0, 0xcd, 0x0, 0xc, 0xd0,
    0x0, 0xcd, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x5c, 0xfe, 0x91, 0x0, 0x6f, 0xa6, 0x9f,
    0xd0, 0xc, 0xd0, 0x0, 0x7f, 0x30, 0xbf, 0x30,
    0x0, 0x0, 0x2, 0xdf, 0xd9, 0x30, 0x0, 0x0,
    0x49, 0xdf, 0xa0, 0x2, 0x10, 0x0, 0x8f, 0x41,
    0xfa, 0x0, 0x5, 0xf5, 0x9, 0xfa, 0x67, 0xee,
    0x10, 0x7, 0xdf, 0xea, 0x20,

    /* U+74 "t" */
    0x1, 0x83, 0x0, 0x3, 0xf7, 0x0, 0x3, 0xf7,
    0x0, 0xef, 0xff, 0xf3, 0x46, 0xf9, 0x41, 0x3,
    0xf7, 0x0, 0x3, 0xf7, 0x0, 0x3, 0xf7, 0x0,
    0x3, 0xf7, 0x0, 0x3, 0xf7, 0x0, 0x2, 0xf7,
    0x0, 0x0, 0xfd, 0x72, 0x0, 0x6e, 0xe3,

    /* U+75 "u" */
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xdb,

    /* U+76 "v" */
    0x8f, 0x10, 0x0, 0x7f, 0x33, 0xf6, 0x0, 0xc,
    0xd0, 0xd, 0xc0, 0x1, 0xf8, 0x0, 0x8f, 0x10,
    0x5f, 0x30, 0x2, 0xf6, 0xa, 0xd0, 0x0, 0xd,
    0xb0, 0xf8, 0x0, 0x0, 0x7f, 0x5f, 0x20, 0x0,
    0x2, 0xfe, 0xd0, 0x0, 0x0, 0xc, 0xf7, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0,

    /* U+77 "w" */
    0x7f, 0x20, 0x1, 0xf8, 0x0, 0xa, 0xf0, 0x3f,
    0x60, 0x5, 0xfd, 0x0, 0xe, 0xb0, 0xe, 0xa0,
    0xa, 0xef, 0x20, 0x2f, 0x60, 0xa, 0xe0, 0xe,
    0x6f, 0x70, 0x5f, 0x20, 0x6, 0xf2, 0x3f, 0x1a,
    0xb0, 0x9d, 0x0, 0x1, 0xf6, 0x8c, 0x5, 0xf1,
    0xd9, 0x0, 0x0, 0xda, 0xd7, 0x1, 0xf7, 0xf4,
    0x0, 0x0, 0x8e, 0xf3, 0x0, 0xce, 0xf0, 0x0,
    0x0, 0x4f, 0xe0, 0x0, 0x7f, 0xc0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x2f, 0x70, 0x0,

    /* U+78 "x" */
    0x3f, 0xa0, 0x0, 0xcf, 0x20, 0x9f, 0x30, 0x5f,
    0x70, 0x1, 0xec, 0xe, 0xd0, 0x0, 0x5, 0xfc,
    0xf3, 0x0, 0x0, 0xb, 0xf9, 0x0, 0x0, 0x0,
    0xcf, 0xa0, 0x0, 0x0, 0x6f, 0xaf, 0x40, 0x0,
    0x1f, 0xb0, 0xce, 0x0, 0xb, 0xf2, 0x3, 0xf9,
    0x5, 0xf8, 0x0, 0xa, 0xf3,

    /* U+79 "y" */
    0xaf, 0x20, 0x0, 0x9f, 0x24, 0xf7, 0x0, 0xe,
    0xc0, 0xe, 0xc0, 0x3, 0xf7, 0x0, 0x9f, 0x10,
    0x7f, 0x20, 0x4, 0xf6, 0xc, 0xc0, 0x0, 0xe,
    0xb1, 0xf7, 0x0, 0x0, 0x9f, 0x7f, 0x20, 0x0,
    0x3, 0xff, 0xc0, 0x0, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0xa, 0xc0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x28, 0xde,
    0x10, 0x0, 0x3, 0xfd, 0x30, 0x0, 0x0,

    /* U+7A "z" */
    0x2f, 0xff, 0xff, 0xff, 0x10, 0x66, 0x66, 0x8f,
    0xc0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x7,
    0xf6, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x0,
    0xde, 0x10, 0x0, 0x0, 0x9f, 0x40, 0x0, 0x0,
    0x5f, 0x90, 0x0, 0x0, 0x1e, 0xf6, 0x66, 0x66,
    0x13, 0xff, 0xff, 0xff, 0xf5,

    /* U+7B "{" */
    0x0, 0x0, 0x1, 0x0, 0x2, 0xdb, 0x0, 0xe,
    0xc0, 0x0, 0x6f, 0x40, 0x0, 0x8f, 0x10, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0xbf, 0x0,
    0x5, 0xf9, 0x0, 0x7f, 0xd0, 0x0, 0x28, 0xf8,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x8f, 0x10, 0x0, 0x6f, 0x30,
    0x0, 0x1f, 0xa0, 0x0, 0x4, 0xfa, 0x0, 0x0,
    0x14,

    /* U+7C "|" */
    0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d,
    0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x36,

    /* U+7D "}" */
    0x10, 0x0, 0x0, 0xad, 0x30, 0x0, 0xb, 0xe1,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0xfa, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x8f, 0x50, 0x0, 0xc, 0xf8, 0x0, 0x6f,
    0x82, 0x0, 0xdc, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0xf9, 0x0, 0x2, 0xf7, 0x0,
    0x9, 0xf1, 0x0, 0x9f, 0x50, 0x0, 0x31, 0x0,
    0x0,

    /* U+7E "~" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0xbf, 0xfc,
    0x30, 0x6, 0xf0, 0x8f, 0x67, 0xef, 0xa8, 0xfa,
    0x8, 0x60, 0x0, 0x8e, 0xfa, 0x0,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0x8e, 0x7, 0xc0, 0x0, 0x0, 0x0, 0x8f, 0x8,
    0xf0, 0x8f, 0x8, 0xf0, 0x8f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0, 0x9f, 0x14, 0x70,

    /* U+A2 "¢" */
    0x0, 0x0, 0x34, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x1, 0xce, 0x10, 0x0, 0x6, 0xff,
    0xff, 0x80, 0x3, 0xfb, 0x21, 0x8f, 0x60, 0xbe,
    0x0, 0x0, 0xcc, 0xf, 0xa0, 0x0, 0x2, 0x30,
    0xf9, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0xeb, 0x0, 0x0, 0x35, 0x8, 0xf3, 0x0,
    0xe, 0xb0, 0x1e, 0xe8, 0x7d, 0xf3, 0x0, 0x1a,
    0xff, 0xa2, 0x0, 0x0, 0xc, 0xe0, 0x0, 0x0,
    0x0, 0xce, 0x0, 0x0,

    /* U+A3 "£" */
    0x0, 0x3, 0xbe, 0xeb, 0x30, 0x0, 0x3f, 0xe8,
    0x8e, 0xf2, 0x0, 0xbf, 0x20, 0x3, 0xf8, 0x0,
    0xdd, 0x0, 0x0, 0x53, 0x0, 0xdd, 0x0, 0x0,
    0x0, 0x1, 0xde, 0x11, 0x10, 0x0, 0x3f, 0xff,
    0xff, 0xb0, 0x0, 0x4, 0xdf, 0x44, 0x30, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x18,
    0xfc, 0x66, 0x66, 0x66, 0x2f, 0xff, 0xff, 0xff,
    0xfe,

    /* U+A4 "¤" */
    0x4, 0x60, 0x27, 0x86, 0x10, 0x63, 0x0, 0xdf,
    0xaf, 0xff, 0xff, 0xaf, 0xc0, 0x2, 0xff, 0xa2,
    0x3, 0xbf, 0xe1, 0x0, 0x2f, 0xa0, 0x0, 0x0,
    0xbf, 0x10, 0x8, 0xf1, 0x0, 0x0, 0x2, 0xf6,
    0x0, 0xad, 0x0, 0x0, 0x0, 0xe, 0x90, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0xda, 0x0, 0x9e, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x4, 0xf5, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0xf, 0xf4, 0x0, 0x4, 0xfe,
    0x0, 0xb, 0xff, 0xfb, 0x9c, 0xff, 0xfb, 0x0,
    0x79, 0x19, 0xef, 0xd8, 0x1a, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+A5 "¥" */
    0x9f, 0x40, 0x0, 0xc, 0xf1, 0x1f, 0xb0, 0x0,
    0x3f, 0x80, 0x8, 0xf2, 0x0, 0xbe, 0x0, 0x1,
    0xe9, 0x2, 0xf7, 0x0, 0x0, 0x7f, 0x19, 0xe0,
    0x0, 0x0, 0xe, 0x9f, 0x60, 0x0, 0xe, 0xff,
    0xff, 0xff, 0x60, 0x2, 0x24, 0xf9, 0x22, 0x0,
    0x0, 0x2, 0xf8, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0x60, 0x2, 0x24, 0xf9, 0x22, 0x0, 0x0,
    0x2, 0xf8, 0x0, 0x0, 0x0, 0x2, 0xf8, 0x0,
    0x0,

    /* U+A6 "¦" */
    0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0x9c, 0x0,
    0x22, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe,

    /* U+A7 "§" */
    0x0, 0x29, 0xdf, 0xea, 0x20, 0x0, 0x2f, 0xe8,
    0x69, 0xff, 0x20, 0xa, 0xf2, 0x0, 0x3, 0xf9,
    0x0, 0xbe, 0x0, 0x0, 0xd, 0xc0, 0x9, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xfb, 0x51, 0x0,
    0x0, 0x4, 0xee, 0xff, 0xfa, 0x30, 0x0, 0xec,
    0x0, 0x5b, 0xff, 0x40, 0x2f, 0x80, 0x0, 0x3,
    0xfd, 0x0, 0xfb, 0x0, 0x0, 0xa, 0xf0, 0x9,
    0xfc, 0x50, 0x0, 0xce, 0x0, 0x8, 0xff, 0xfa,
    0xbf, 0x60, 0x0, 0x1, 0x6b, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x2, 0xbf, 0x60, 0x1b, 0x50, 0x0,
    0x1, 0xfa, 0x0, 0xfb, 0x0, 0x0, 0x2f, 0x90,
    0x9, 0xfa, 0x32, 0x4d, 0xf3, 0x0, 0x9, 0xff,
    0xff, 0xd5, 0x0, 0x0, 0x0, 0x23, 0x20, 0x0,
    0x0,

    /* U+A8 "¨" */
    0xc, 0x80, 0x2d, 0x50, 0xe9, 0x2, 0xf6,

    /* U+A9 "©" */
    0x0, 0x0, 0x4b, 0xde, 0xb5, 0x0, 0x0, 0x0,
    0xa, 0xd7, 0x33, 0x6d, 0xb0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0xab, 0x0, 0x5, 0xd0, 0x9,
    0xee, 0x90, 0xd, 0x50, 0xb, 0x50, 0x9d, 0x44,
    0xe8, 0x4, 0xc0, 0xf, 0x0, 0xf5, 0x0, 0x6a,
    0x0, 0xe1, 0x2e, 0x1, 0xf2, 0x0, 0x0, 0x0,
    0xc3, 0x2d, 0x1, 0xf2, 0x0, 0x0, 0x0, 0xc3,
    0xf, 0x0, 0xf4, 0x0, 0x58, 0x0, 0xe1, 0xc,
    0x40, 0xac, 0x11, 0xc9, 0x3, 0xd0, 0x6, 0xc0,
    0x1c, 0xff, 0xc1, 0xb, 0x70, 0x0, 0xc8, 0x0,
    0x11, 0x0, 0x7d, 0x0, 0x0, 0x1c, 0xb3, 0x0,
    0x3a, 0xd2, 0x0, 0x0, 0x0, 0x7e, 0xff, 0xe8,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+AA "ª" */
    0x9, 0xee, 0xa0, 0x6f, 0x55, 0xf7, 0x12, 0x0,
    0xca, 0x1a, 0xef, 0xfa, 0x9e, 0x20, 0xca, 0x9e,
    0x46, 0xea, 0x2c, 0xfc, 0xcc,

    /* U+AB "«" */
    0x0, 0x2, 0x20, 0x21, 0x0, 0x1e, 0x42, 0xf3,
    0x0, 0xca, 0xd, 0x80, 0x8, 0xf1, 0x9e, 0x0,
    0xf, 0xa1, 0xf8, 0x0, 0x5, 0xf2, 0x7f, 0x10,
    0x0, 0x9c, 0xb, 0xa0, 0x0, 0xd, 0x61, 0xe4,

    /* U+AC "¬" */
    0x22, 0x22, 0x22, 0x20, 0xef, 0xff, 0xff, 0xf6,
    0x45, 0x55, 0x57, 0xf6, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x2, 0xd5,

    /* U+AD "­" */
    0x11, 0x11, 0xa, 0xff, 0xf9, 0x34, 0x44, 0x20,

    /* U+AE "®" */
    0x0, 0x0, 0x4b, 0xee, 0xb5, 0x0, 0x0, 0x0,
    0xa, 0xd6, 0x33, 0x6d, 0xb0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0xab, 0x0, 0x5, 0xd0, 0x7f,
    0xfe, 0x90, 0xd, 0x50, 0xb, 0x50, 0x8c, 0x23,
    0xd7, 0x4, 0xc0, 0xf, 0x0, 0x8b, 0x0, 0x8b,
    0x0, 0xf1, 0x2d, 0x0, 0x8b, 0x1, 0xc8, 0x0,
    0xd3, 0x2d, 0x0, 0x8f, 0xff, 0xe1, 0x0, 0xc3,
    0xf, 0x0, 0x8c, 0x34, 0xd8, 0x0, 0xe1, 0xc,
    0x40, 0x8b, 0x0, 0x8b, 0x3, 0xd0, 0x6, 0xc0,
    0x8b, 0x0, 0x8c, 0xb, 0x70, 0x0, 0xc8, 0x11,
    0x0, 0x1, 0x8d, 0x0, 0x0, 0x1c, 0xb3, 0x0,
    0x3b, 0xd1, 0x0, 0x0, 0x0, 0x7e, 0xff, 0xe8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+AF "¯" */
    0x1, 0x11, 0x11, 0xc, 0xff, 0xff, 0xf2, 0x23,
    0x33, 0x33, 0x0,

    /* U+B0 "°" */
    0x1b, 0xe8, 0x9, 0xb3, 0xd5, 0xd4, 0x8, 0x8a,
    0x91, 0xc6, 0x2e, 0xfc, 0x0, 0x1, 0x0,

    /* U+B1 "±" */
    0x0, 0x0, 0xa9, 0x0, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x0, 0x0, 0xcb, 0x0, 0x0, 0x11, 0x1c,
    0xb1, 0x11, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0x44,
    0x4d, 0xc4, 0x44, 0x0, 0x0, 0xcb, 0x0, 0x0,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0xcb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x66, 0x66,
    0x66, 0x30, 0xdf, 0xff, 0xff, 0xf8,

    /* U+B2 "²" */
    0x6, 0xef, 0xb1, 0x3f, 0x63, 0xd9, 0x14, 0x0,
    0xd9, 0x0, 0x9, 0xf2, 0x0, 0x9e, 0x30, 0xa,
    0xe4, 0x22, 0x4f, 0xff, 0xff,

    /* U+B3 "³" */
    0x7, 0xef, 0xb1, 0x3f, 0x63, 0xd9, 0x0, 0x0,
    0xc9, 0x0, 0x9f, 0xe1, 0x0, 0x12, 0xcb, 0x5f,
    0x52, 0xcc, 0x8, 0xef, 0xb2,

    /* U+B4 "´" */
    0x3, 0x84, 0xd, 0xc0, 0x9c, 0x0,

    /* U+B5 "µ" */
    0xaf, 0x0, 0x0, 0xcd, 0xaf, 0x0, 0x0, 0xcd,
    0xaf, 0x0, 0x0, 0xcd, 0xaf, 0x0, 0x0, 0xcd,
    0xaf, 0x0, 0x0, 0xcd, 0xaf, 0x0, 0x0, 0xcd,
    0xaf, 0x0, 0x0, 0xcd, 0xaf, 0x30, 0x0, 0xed,
    0xaf, 0xc4, 0x3a, 0xfd, 0xaf, 0xbf, 0xf9, 0xbd,
    0xaf, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,

    /* U+B6 "¶" */
    0x0, 0x6c, 0xff, 0xf5, 0x8, 0xff, 0xff, 0xf5,
    0x1f, 0xff, 0xff, 0xf5, 0x5f, 0xff, 0xff, 0xf5,
    0x6f, 0xff, 0xff, 0xf5, 0x3f, 0xff, 0xff, 0xf5,
    0xd, 0xff, 0xff, 0xf5, 0x2, 0xdf, 0xff, 0xf5,
    0x0, 0x4, 0x7a, 0xf5, 0x0, 0x0, 0x5, 0xf5,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x5, 0xf5,
    0x0, 0x0, 0x5, 0xf5,

    /* U+B7 "·" */
    0x0, 0x7, 0xf2, 0x7e, 0x20,

    /* U+B8 "¸" */
    0x0, 0xc, 0xa1, 0x4c, 0xa1, 0xba, 0xeb, 0x10,

    /* U+B9 "¹" */
    0x16, 0xb5, 0xed, 0xf5, 0x10, 0xf5, 0x0, 0xf5,
    0x0, 0xf5, 0x0, 0xf5, 0x0, 0xf5,

    /* U+BA "º" */
    0x8, 0xee, 0xa1, 0x7, 0xf6, 0x5e, 0xa0, 0xd9,
    0x0, 0x7f, 0xe, 0x80, 0x5, 0xf1, 0xd9, 0x0,
    0x7f, 0x7, 0xf6, 0x5e, 0xa0, 0x8, 0xee, 0xa1,
    0x0,

    /* U+BB "»" */
    0x3, 0x0, 0x31, 0x0, 0xa, 0xa0, 0x9b, 0x0,
    0x1, 0xe6, 0xe, 0x70, 0x0, 0x6f, 0x25, 0xf3,
    0x0, 0xf, 0x90, 0xea, 0x0, 0x8e, 0x17, 0xe1,
    0x2, 0xf4, 0x2f, 0x50, 0xc, 0x80, 0xb9, 0x0,

    /* U+BC "¼" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xbf, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x5, 0xf0, 0x0, 0xb,
    0x90, 0x0, 0x0, 0x5f, 0x0, 0x5, 0xe0, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0xe5, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x9b, 0x0, 0x21, 0x0, 0x5, 0xe0,
    0x3f, 0x20, 0x5f, 0x90, 0x0, 0x0, 0xc, 0x70,
    0x2e, 0xf9, 0x0, 0x0, 0x6, 0xd0, 0xc, 0x7c,
    0x90, 0x0, 0x1, 0xf3, 0x9, 0xa0, 0xc9, 0x0,
    0x0, 0xa9, 0x1, 0xff, 0xff, 0xf8, 0x0, 0x5,
    0x10, 0x3, 0x33, 0xda, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90,

    /* U+BD "½" */
    0x2, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xef, 0x0, 0x0, 0x44, 0x0, 0x0, 0x11, 0x6f,
    0x0, 0x0, 0xe5, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x8, 0xb0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x2f,
    0x20, 0x0, 0x0, 0x0, 0x6f, 0x0, 0xb8, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x5, 0xe0, 0x6e, 0xfb,
    0x10, 0x0, 0x13, 0xe, 0x43, 0xf7, 0x4e, 0x90,
    0x0, 0x0, 0x9b, 0x2, 0x50, 0xc, 0xa0, 0x0,
    0x3, 0xf2, 0x0, 0x0, 0x7f, 0x30, 0x0, 0xc,
    0x70, 0x0, 0x7, 0xf4, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x8e, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x22,
    0x22, 0x20,

    /* U+BE "¾" */
    0x2, 0xcf, 0xd5, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xb3, 0x8f, 0x10, 0x0, 0x70, 0x0, 0x0, 0x0,
    0x6f, 0x10, 0x6, 0xd0, 0x0, 0x0, 0x3f, 0xf7,
    0x0, 0x1f, 0x30, 0x0, 0x0, 0x2, 0x7f, 0x20,
    0xb9, 0x0, 0x0, 0xc, 0x80, 0x5f, 0x35, 0xe0,
    0x0, 0x0, 0x6, 0xff, 0xf9, 0x1e, 0x50, 0x6f,
    0x60, 0x0, 0x2, 0x10, 0xaa, 0x3, 0xff, 0x60,
    0x0, 0x0, 0x4, 0xe1, 0x1e, 0x5f, 0x60, 0x0,
    0x0, 0xd, 0x60, 0xb7, 0xf, 0x60, 0x0, 0x0,
    0x8b, 0x4, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x42,
    0x0, 0x33, 0x3f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x60,

    /* U+BF "¿" */
    0x0, 0x7, 0xe1, 0x0, 0x0, 0x6, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0x7f, 0x70, 0x0, 0x4, 0xfb, 0x0, 0x0,
    0xe, 0xd0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x0,
    0x5f, 0x30, 0x0, 0x55, 0x3f, 0x70, 0x1, 0xfa,
    0xc, 0xf9, 0x8e, 0xf3, 0x1, 0xae, 0xfc, 0x30,

    /* U+C0 "À" */
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+C1 "Á" */
    0x0, 0x0, 0x0, 0x9f, 0x40, 0x0, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xb, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+C2 "Â" */
    0x0, 0x0, 0x1e, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0xbb, 0xd7, 0x0, 0x0, 0x0, 0x7, 0xe1, 0x2f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+C3 "Ã" */
    0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x3, 0x33, 0x33,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+C4 "Ä" */
    0x0, 0xb, 0xc0, 0xe, 0x80, 0x0, 0x0, 0xa,
    0xb0, 0xd, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xcb, 0xe8, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e,
    0x0, 0x0, 0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0,
    0x0, 0xe, 0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f,
    0x30, 0x7, 0xf1, 0x0, 0x0, 0xae, 0x11, 0x13,
    0xf6, 0x0, 0x1, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x6, 0xf5, 0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0,
    0x0, 0x0, 0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0,
    0xb, 0xe0, 0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+C5 "Å" */
    0x0, 0x0, 0x4c, 0xb2, 0x0, 0x0, 0x0, 0x0,
    0xd1, 0x4a, 0x0, 0x0, 0x0, 0x0, 0xd1, 0x4b,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8, 0x0, 0x0,
    0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0, 0x0, 0x8,
    0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe, 0x90, 0xd,
    0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7, 0xf1, 0x0,
    0x0, 0xae, 0x11, 0x13, 0xf6, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5, 0x44, 0x44,
    0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0, 0x1f, 0x80,
    0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0, 0x9f, 0x20,
    0x0, 0x0, 0x6, 0xf4,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xf6, 0x66,
    0x66, 0x50, 0x0, 0x0, 0x0, 0xd, 0xdb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x5a,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf3, 0x9, 0xf2, 0x11, 0x11, 0x0, 0x0, 0x0,
    0x4f, 0xa0, 0x8, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0xdf, 0x10, 0x7, 0xf6, 0x44, 0x44, 0x10,
    0x0, 0x7, 0xfd, 0x99, 0x9c, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x5, 0xf4,
    0x0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x5,
    0xf8, 0x66, 0x66, 0x63, 0xd, 0xf2, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xf8,

    /* U+C7 "Ç" */
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x6, 0xfd, 0x87,
    0xbf, 0xc0, 0x2f, 0xc0, 0x0, 0x7, 0xf6, 0x8f,
    0x30, 0x0, 0x0, 0xfc, 0xde, 0x0, 0x0, 0x0,
    0x33, 0xec, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x0, 0x23, 0x9f, 0x30, 0x0,
    0x0, 0xfc, 0x2f, 0xb0, 0x0, 0x7, 0xf6, 0x7,
    0xfd, 0x87, 0xbf, 0xb0, 0x0, 0x4c, 0xff, 0xd7,
    0x0, 0x0, 0x0, 0xbc, 0x20, 0x0, 0x0, 0x0,
    0x3b, 0xb0, 0x0, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x0, 0x0, 0xdc, 0x20, 0x0,

    /* U+C8 "È" */
    0x0, 0xde, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+C9 "É" */
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x9, 0xe1,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+CA "Ê" */
    0x0, 0x8, 0xf5, 0x0, 0x0, 0x6, 0xe4, 0xe4,
    0x0, 0x0, 0x72, 0x3, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+CB "Ë" */
    0x3, 0xf5, 0x6, 0xf2, 0x0, 0x2e, 0x40, 0x5d,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xf8, 0x8f, 0x86, 0x66, 0x66, 0x38, 0xf2,
    0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x41, 0x11, 0x11,
    0x8, 0xff, 0xff, 0xff, 0xb0, 0x8f, 0x64, 0x44,
    0x43, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x86, 0x66, 0x66, 0x48, 0xff, 0xff, 0xff, 0xf9,

    /* U+CC "Ì" */
    0xd, 0xe0, 0x0, 0x2f, 0x80, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0x6f, 0x40, 0x6, 0xf4, 0x0,
    0x6f, 0x40, 0x6, 0xf4, 0x0, 0x6f, 0x40, 0x6,
    0xf4, 0x0, 0x6f, 0x40, 0x6, 0xf4, 0x0, 0x6f,
    0x40, 0x6, 0xf4, 0x0, 0x6f, 0x40, 0x6, 0xf4,
    0x0, 0x6f, 0x40,

    /* U+CD "Í" */
    0x1, 0xfc, 0x0, 0x9e, 0x10, 0x2f, 0x40, 0x0,
    0x0, 0x0, 0x6f, 0x40, 0x6, 0xf4, 0x0, 0x6f,
    0x40, 0x6, 0xf4, 0x0, 0x6f, 0x40, 0x6, 0xf4,
    0x0, 0x6f, 0x40, 0x6, 0xf4, 0x0, 0x6f, 0x40,
    0x6, 0xf4, 0x0, 0x6f, 0x40, 0x6, 0xf4, 0x0,
    0x6f, 0x40, 0x0,

    /* U+CE "Î" */
    0x0, 0x7f, 0x50, 0x0, 0x6e, 0x4e, 0x40, 0x7,
    0x20, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x6f, 0x40, 0x0,

    /* U+CF "Ï" */
    0x3f, 0x50, 0x6f, 0x22, 0xd4, 0x5, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0,

    /* U+D0 "Ð" */
    0x4, 0xff, 0xff, 0xd9, 0x20, 0x0, 0x4f, 0xa7,
    0x79, 0xef, 0x40, 0x4, 0xf7, 0x0, 0x1, 0xde,
    0x10, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4, 0xf7,
    0x0, 0x0, 0xd, 0xd1, 0x4f, 0x71, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xfa, 0x0, 0xa, 0xf3, 0x7f,
    0x94, 0x20, 0x0, 0xbf, 0x4, 0xf7, 0x0, 0x0,
    0xd, 0xd0, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4,
    0xf7, 0x0, 0x1, 0xde, 0x10, 0x4f, 0xa6, 0x69,
    0xff, 0x40, 0x4, 0xff, 0xff, 0xd9, 0x20, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x5, 0xef,
    0xff, 0xf4, 0x0, 0x0, 0x23, 0x33, 0x31, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x0, 0x5f, 0x58, 0xff, 0x20, 0x0, 0x5,
    0xf5, 0x8f, 0xfc, 0x0, 0x0, 0x5f, 0x58, 0xfa,
    0xf6, 0x0, 0x5, 0xf5, 0x8f, 0x3d, 0xf1, 0x0,
    0x5f, 0x58, 0xf3, 0x3f, 0xb0, 0x5, 0xf5, 0x8f,
    0x30, 0x8f, 0x50, 0x5f, 0x58, 0xf3, 0x0, 0xde,
    0x15, 0xf5, 0x8f, 0x30, 0x4, 0xfa, 0x5f, 0x58,
    0xf3, 0x0, 0xa, 0xfa, 0xf5, 0x8f, 0x30, 0x0,
    0x1e, 0xff, 0x58, 0xf3, 0x0, 0x0, 0x5f, 0xf5,
    0x8f, 0x30, 0x0, 0x0, 0xbf, 0x50,

    /* U+D2 "Ò" */
    0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x37, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+D3 "Ó" */
    0x0, 0x0, 0x5, 0xf8, 0x0, 0x0, 0x0, 0x1,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x46, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+D4 "Ô" */
    0x0, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x0, 0xab,
    0x6e, 0x10, 0x0, 0x0, 0x27, 0x10, 0x55, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+D5 "Õ" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0xee,
    0x52, 0xf3, 0x0, 0x0, 0xc9, 0x5e, 0xfc, 0x0,
    0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xbe, 0xfc, 0x60,
    0x0, 0x5, 0xfe, 0x98, 0xcf, 0xb0, 0x1, 0xfc,
    0x0, 0x0, 0x7f, 0x70, 0x8f, 0x40, 0x0, 0x0,
    0xde, 0xc, 0xe0, 0x0, 0x0, 0x8, 0xf2, 0xec,
    0x0, 0x0, 0x0, 0x6f, 0x4f, 0xb0, 0x0, 0x0,
    0x5, 0xf5, 0xec, 0x0, 0x0, 0x0, 0x6f, 0x4c,
    0xe0, 0x0, 0x0, 0x8, 0xf2, 0x8f, 0x40, 0x0,
    0x0, 0xce, 0x1, 0xfc, 0x10, 0x0, 0x7f, 0x70,
    0x5, 0xfe, 0x98, 0xbf, 0xb0, 0x0, 0x3, 0xbe,
    0xfd, 0x70, 0x0,

    /* U+D6 "Ö" */
    0x0, 0x6e, 0x20, 0xad, 0x0, 0x0, 0x6, 0xd1,
    0x9, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xbe, 0xfc, 0x60, 0x0, 0x5, 0xfe,
    0x98, 0xcf, 0xb0, 0x1, 0xfc, 0x0, 0x0, 0x7f,
    0x70, 0x8f, 0x40, 0x0, 0x0, 0xde, 0xc, 0xe0,
    0x0, 0x0, 0x8, 0xf2, 0xec, 0x0, 0x0, 0x0,
    0x6f, 0x4f, 0xb0, 0x0, 0x0, 0x5, 0xf5, 0xec,
    0x0, 0x0, 0x0, 0x6f, 0x4c, 0xe0, 0x0, 0x0,
    0x8, 0xf2, 0x8f, 0x40, 0x0, 0x0, 0xce, 0x1,
    0xfc, 0x10, 0x0, 0x7f, 0x70, 0x5, 0xfe, 0x98,
    0xbf, 0xb0, 0x0, 0x3, 0xbe, 0xfd, 0x70, 0x0,

    /* U+D7 "×" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc7, 0x0, 0x2,
    0xd4, 0xa, 0xf7, 0x1, 0xde, 0x30, 0xb, 0xf7,
    0xdf, 0x30, 0x0, 0xb, 0xff, 0x40, 0x0, 0x0,
    0xcf, 0xf5, 0x0, 0x0, 0xbf, 0x6c, 0xf4, 0x0,
    0xbf, 0x60, 0x1d, 0xf3, 0xb, 0x60, 0x0, 0x1d,
    0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0xe, 0x40, 0x3, 0xbe,
    0xfd, 0x66, 0xc0, 0x5, 0xfe, 0x99, 0xcf, 0xf5,
    0x2, 0xfc, 0x0, 0x0, 0xbf, 0x70, 0x8f, 0x40,
    0x0, 0x2e, 0xde, 0xc, 0xe0, 0x0, 0xc, 0x78,
    0xf2, 0xec, 0x0, 0x6, 0xc0, 0x6f, 0x4f, 0xb0,
    0x1, 0xe3, 0x5, 0xf5, 0xec, 0x0, 0xb8, 0x0,
    0x6f, 0x4c, 0xe0, 0x5d, 0x0, 0x8, 0xf2, 0x8f,
    0x5e, 0x40, 0x0, 0xce, 0x1, 0xff, 0xa0, 0x0,
    0x7f, 0x70, 0x7, 0xfe, 0x98, 0xbf, 0xb0, 0x0,
    0xd8, 0xae, 0xfd, 0x70, 0x0, 0x36, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x8, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x65, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+DA "Ú" */
    0x0, 0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0, 0x64, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+DB "Û" */
    0x0, 0x2, 0xec, 0x0, 0x0, 0x0, 0x1e, 0x7b,
    0xa0, 0x0, 0x0, 0x56, 0x0, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+DC "Ü" */
    0x0, 0xcb, 0x0, 0xe8, 0x0, 0x0, 0xaa, 0x0,
    0xd7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf7, 0xbf, 0x0, 0x0, 0x5,
    0xf6, 0x6f, 0x70, 0x0, 0xc, 0xf2, 0xc, 0xfb,
    0x78, 0xdf, 0x80, 0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+DD "Ý" */
    0x0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xae, 0x10, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x8f, 0x51, 0xfc, 0x0, 0x0, 0x1f,
    0xd0, 0x8, 0xf5, 0x0, 0x8, 0xf4, 0x0, 0xe,
    0xd0, 0x1, 0xfb, 0x0, 0x0, 0x7f, 0x50, 0x8f,
    0x30, 0x0, 0x0, 0xdd, 0x1f, 0xa0, 0x0, 0x0,
    0x5, 0xfc, 0xf2, 0x0, 0x0, 0x0, 0xc, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+DE "Þ" */
    0x8f, 0x10, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0x0, 0x8f, 0x21, 0x10, 0x0, 0x8, 0xff, 0xff,
    0xfb, 0x30, 0x8f, 0x54, 0x47, 0xef, 0x28, 0xf1,
    0x0, 0x2, 0xf9, 0x8f, 0x10, 0x0, 0xd, 0xc8,
    0xf1, 0x0, 0x1, 0xfb, 0x8f, 0x21, 0x14, 0xcf,
    0x48, 0xff, 0xff, 0xfe, 0x50, 0x8f, 0x54, 0x42,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0x0, 0x8f, 0x10,
    0x0, 0x0, 0x0,

    /* U+DF "ß" */
    0x4, 0xcf, 0xe8, 0x0, 0x2, 0xfd, 0x79, 0xf9,
    0x0, 0x8f, 0x20, 0xb, 0xe0, 0xb, 0xe0, 0x0,
    0x9e, 0x0, 0xcd, 0x0, 0xe, 0xa0, 0xc, 0xd0,
    0x7, 0xf2, 0x0, 0xcd, 0x0, 0xbe, 0x0, 0xc,
    0xd0, 0x9, 0xf5, 0x0, 0xcd, 0x0, 0x1d, 0xf6,
    0xc, 0xd0, 0x0, 0x1c, 0xf5, 0xcd, 0x0, 0x0,
    0xe, 0xdc, 0xd0, 0x0, 0x0, 0xcd, 0xcd, 0x9,
    0x53, 0x7f, 0x8c, 0xd0, 0xbe, 0xfd, 0x80,

    /* U+E0 "à" */
    0x0, 0x3f, 0xa0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x5f,
    0xc6, 0x7e, 0xe1, 0xa, 0xc0, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff,
    0x70, 0x8f, 0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0,
    0x2f, 0x70, 0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb,
    0x8b, 0xff, 0x80, 0x9, 0xef, 0xb3, 0xc9,

    /* U+E1 "á" */
    0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x69, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x5f,
    0xc6, 0x7e, 0xe1, 0xa, 0xc0, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff,
    0x70, 0x8f, 0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0,
    0x2f, 0x70, 0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb,
    0x8b, 0xff, 0x80, 0x9, 0xef, 0xb3, 0xc9,

    /* U+E2 "â" */
    0x0, 0x0, 0xce, 0x10, 0x0, 0x0, 0xbb, 0x8c,
    0x0, 0x0, 0x38, 0x0, 0x74, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x5f,
    0xc6, 0x7e, 0xe1, 0xa, 0xc0, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff,
    0x70, 0x8f, 0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0,
    0x2f, 0x70, 0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb,
    0x8b, 0xff, 0x80, 0x9, 0xef, 0xb3, 0xc9,

    /* U+E3 "ã" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xed, 0x42,
    0xf2, 0x0, 0xd9, 0x7e, 0xfb, 0x0, 0x3, 0x0,
    0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xeb, 0x20, 0x5, 0xfc, 0x67, 0xee, 0x10,
    0xac, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x2f,
    0x70, 0x5, 0xce, 0xff, 0xf7, 0x8, 0xf9, 0x43,
    0x5f, 0x70, 0xfb, 0x0, 0x2, 0xf7, 0xf, 0xb0,
    0x0, 0x7f, 0x70, 0xaf, 0xb8, 0xbf, 0xf8, 0x0,
    0x9e, 0xfb, 0x3c, 0x90,

    /* U+E4 "ä" */
    0x0, 0x8e, 0x10, 0xbc, 0x0, 0x7, 0xd0, 0xa,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xcf,
    0xeb, 0x20, 0x5, 0xfc, 0x67, 0xee, 0x10, 0xac,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0x5, 0xce, 0xff, 0xf7, 0x8, 0xf9, 0x43, 0x5f,
    0x70, 0xfb, 0x0, 0x2, 0xf7, 0xf, 0xb0, 0x0,
    0x7f, 0x70, 0xaf, 0xb8, 0xbf, 0xf8, 0x0, 0x9e,
    0xfb, 0x3c, 0x90,

    /* U+E5 "å" */
    0x0, 0x2, 0xbc, 0x40, 0x0, 0x0, 0xa4, 0x1d,
    0x0, 0x0, 0xa, 0x41, 0xd0, 0x0, 0x0, 0x2b,
    0xc4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xeb, 0x20, 0x5, 0xfc, 0x67, 0xee, 0x10,
    0xac, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x2f,
    0x70, 0x5, 0xce, 0xff, 0xf7, 0x8, 0xf9, 0x43,
    0x5f, 0x70, 0xfb, 0x0, 0x2, 0xf7, 0xf, 0xb0,
    0x0, 0x7f, 0x70, 0xaf, 0xb8, 0xbf, 0xf8, 0x0,
    0x9e, 0xfb, 0x3c, 0x90,

    /* U+E6 "æ" */
    0x0, 0x7d, 0xfe, 0x90, 0x4c, 0xfe, 0x91, 0x0,
    0xaf, 0xa6, 0x9f, 0xcf, 0xc6, 0x8f, 0xd0, 0xd,
    0xa0, 0x0, 0x9f, 0xc0, 0x0, 0x5f, 0x50, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x1, 0xf8, 0x1, 0xae,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xdf, 0x73,
    0x38, 0xf6, 0x33, 0x33, 0x32, 0x3f, 0x70, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x9,
    0xfd, 0x0, 0x0, 0x20, 0xe, 0xe7, 0x6c, 0xfa,
    0xfd, 0x76, 0xaf, 0x30, 0x2b, 0xff, 0xb4, 0x3,
    0xbf, 0xfd, 0x70,

    /* U+E7 "ç" */
    0x0, 0x2b, 0xee, 0xb2, 0x0, 0x2f, 0xe7, 0x7e,
    0xe2, 0xb, 0xf1, 0x0, 0x1f, 0x90, 0xf9, 0x0,
    0x0, 0x66, 0x2f, 0x70, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x2, 0x30,
    0xbf, 0x10, 0x1, 0xea, 0x3, 0xfd, 0x77, 0xdf,
    0x20, 0x3, 0xbf, 0xfb, 0x20, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x4, 0xe7, 0x0, 0x0, 0x0,
    0x1d, 0x70, 0x0, 0x0, 0x2e, 0x90, 0x0,

    /* U+E8 "è" */
    0x0, 0x5f, 0x80, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x0, 0x97, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e,
    0xd7, 0x7e, 0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80,
    0xfa, 0x11, 0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff,
    0xe2, 0xfa, 0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x72, 0x2, 0xff,
    0x86, 0xaf, 0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+E9 "é" */
    0x0, 0x0, 0x8, 0xf4, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e,
    0xd7, 0x7e, 0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80,
    0xfa, 0x11, 0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff,
    0xe2, 0xfa, 0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x72, 0x2, 0xff,
    0x86, 0xaf, 0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+EA "ê" */
    0x0, 0x1, 0xdd, 0x0, 0x0, 0x0, 0xc9, 0xab,
    0x0, 0x0, 0x48, 0x0, 0x83, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e,
    0xd7, 0x7e, 0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80,
    0xfa, 0x11, 0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff,
    0xe2, 0xfa, 0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x72, 0x2, 0xff,
    0x86, 0xaf, 0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+EB "ë" */
    0x0, 0xad, 0x0, 0xd9, 0x0, 0x9, 0xc0, 0xc,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xae,
    0xfb, 0x20, 0x1, 0xed, 0x77, 0xee, 0x10, 0xae,
    0x10, 0x2, 0xf8, 0xf, 0xa1, 0x11, 0x1d, 0xc2,
    0xff, 0xff, 0xff, 0xfe, 0x2f, 0xa4, 0x44, 0x44,
    0x41, 0xfa, 0x0, 0x0, 0x0, 0xb, 0xf3, 0x0,
    0x7, 0x20, 0x2f, 0xf8, 0x6a, 0xf6, 0x0, 0x2a,
    0xef, 0xc5, 0x0,

    /* U+EC "ì" */
    0x2e, 0xc0, 0x0, 0x3f, 0x70, 0x0, 0x48, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0,
    0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf, 0x0, 0xa,
    0xf0, 0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf,
    0x0, 0xa, 0xf0,

    /* U+ED "í" */
    0x5, 0xf8, 0x1e, 0x90, 0x48, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0,
    0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0,
    0xaf, 0x0, 0xaf, 0x0,

    /* U+EE "î" */
    0x0, 0xbf, 0x30, 0xa, 0xc6, 0xe2, 0x27, 0x10,
    0x55, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0,

    /* U+EF "ï" */
    0x6f, 0x20, 0x9d, 0x5, 0xd1, 0x8, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0,

    /* U+F0 "ð" */
    0x2, 0x40, 0x0, 0x0, 0x0, 0x9f, 0xe5, 0x9,
    0x60, 0x0, 0x5d, 0xff, 0xc1, 0x0, 0x0, 0x8f,
    0xf9, 0x0, 0x0, 0x6d, 0x2a, 0xf4, 0x0, 0x0,
    0x0, 0x1f, 0xb0, 0x2, 0xbf, 0xfc, 0xcf, 0x1,
    0xef, 0x75, 0x7f, 0xf4, 0x8f, 0x40, 0x0, 0x5f,
    0x5c, 0xe0, 0x0, 0x3, 0xf6, 0xdc, 0x0, 0x0,
    0x4f, 0x5c, 0xe0, 0x0, 0x7, 0xf3, 0x7f, 0x50,
    0x0, 0xdd, 0x0, 0xdf, 0x96, 0xcf, 0x40, 0x0,
    0x9e, 0xfc, 0x40, 0x0,

    /* U+F1 "ñ" */
    0x0, 0x0, 0x0, 0x10, 0x5, 0xec, 0x43, 0xf0,
    0xe, 0x87, 0xff, 0x90, 0x3, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcc, 0x4c, 0xfd, 0x60,
    0xcf, 0xe8, 0x7d, 0xf4, 0xcf, 0x30, 0x1, 0xf9,
    0xcd, 0x0, 0x0, 0xfa, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb,

    /* U+F2 "ò" */
    0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x88, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xc4,
    0x0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0xa, 0xf2,
    0x0, 0xd, 0xe0, 0xf, 0xa0, 0x0, 0x6, 0xf4,
    0x2f, 0x80, 0x0, 0x3, 0xf6, 0x2f, 0x70, 0x0,
    0x3, 0xf6, 0xf, 0xa0, 0x0, 0x6, 0xf4, 0xb,
    0xf2, 0x0, 0xd, 0xe0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0x0, 0x2a, 0xff, 0xc4, 0x0,

    /* U+F3 "ó" */
    0x0, 0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xc4,
    0x0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0xa, 0xf2,
    0x0, 0xd, 0xe0, 0xf, 0xa0, 0x0, 0x6, 0xf4,
    0x2f, 0x80, 0x0, 0x3, 0xf6, 0x2f, 0x70, 0x0,
    0x3, 0xf6, 0xf, 0xa0, 0x0, 0x6, 0xf4, 0xb,
    0xf2, 0x0, 0xd, 0xe0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0x0, 0x2a, 0xff, 0xc4, 0x0,

    /* U+F4 "ô" */
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0xb, 0xa9,
    0xc0, 0x0, 0x0, 0x38, 0x0, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xc4,
    0x0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0xa, 0xf2,
    0x0, 0xd, 0xe0, 0xf, 0xa0, 0x0, 0x6, 0xf4,
    0x2f, 0x80, 0x0, 0x3, 0xf6, 0x2f, 0x70, 0x0,
    0x3, 0xf6, 0xf, 0xa0, 0x0, 0x6, 0xf4, 0xb,
    0xf2, 0x0, 0xd, 0xe0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0x0, 0x2a, 0xff, 0xc4, 0x0,

    /* U+F5 "õ" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x5e, 0xc4,
    0x3f, 0x10, 0x0, 0xe8, 0x7f, 0xfa, 0x0, 0x0,
    0x30, 0x1, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2a, 0xef, 0xc4, 0x0, 0x2, 0xee,
    0x87, 0xdf, 0x50, 0xa, 0xf2, 0x0, 0xd, 0xe0,
    0xf, 0xa0, 0x0, 0x6, 0xf4, 0x2f, 0x80, 0x0,
    0x3, 0xf6, 0x2f, 0x70, 0x0, 0x3, 0xf6, 0xf,
    0xa0, 0x0, 0x6, 0xf4, 0xb, 0xf2, 0x0, 0xd,
    0xe0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0x0, 0x2a,
    0xff, 0xc4, 0x0,

    /* U+F6 "ö" */
    0x0, 0x9e, 0x0, 0xcb, 0x0, 0x0, 0x8d, 0x0,
    0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2a, 0xef, 0xc4, 0x0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0xa, 0xf2, 0x0, 0xd, 0xe0, 0xf, 0xa0,
    0x0, 0x6, 0xf4, 0x2f, 0x80, 0x0, 0x3, 0xf6,
    0x2f, 0x70, 0x0, 0x3, 0xf6, 0xf, 0xa0, 0x0,
    0x6, 0xf4, 0xb, 0xf2, 0x0, 0xd, 0xe0, 0x2,
    0xee, 0x87, 0xdf, 0x50, 0x0, 0x2a, 0xff, 0xc4,
    0x0,

    /* U+F7 "÷" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4a, 0xaa, 0xaa, 0xaa,
    0xa4, 0x6f, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x0, 0xb, 0x60, 0x0, 0x2a, 0xef,
    0xce, 0x0, 0x2, 0xee, 0x86, 0xef, 0x50, 0xb,
    0xf2, 0x2, 0xed, 0xe0, 0xf, 0xa0, 0x9, 0x76,
    0xf4, 0x2f, 0x70, 0x1e, 0x3, 0xf6, 0x2f, 0x70,
    0x97, 0x3, 0xf6, 0xf, 0xa1, 0xe0, 0x6, 0xf4,
    0xb, 0xfb, 0x80, 0xd, 0xe0, 0x2, 0xef, 0x97,
    0xdf, 0x50, 0x0, 0x9d, 0xef, 0xc4, 0x0, 0x1,
    0xe1, 0x0, 0x0, 0x0,

    /* U+F9 "ù" */
    0x5, 0xf8, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x0, 0x7, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xdb,

    /* U+FA "ú" */
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xdb,

    /* U+FB "û" */
    0x0, 0x1d, 0xd1, 0x0, 0x1, 0xd8, 0x9c, 0x0,
    0x4, 0x60, 0x6, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xdb,

    /* U+FC "ü" */
    0xa, 0xd0, 0xd, 0xa0, 0x9, 0xc0, 0xc, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xaf, 0x10, 0x3, 0xfb, 0x5f, 0xc7, 0x9f, 0xfb,
    0x7, 0xdf, 0xd5, 0xdb,

    /* U+FD "ý" */
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x2, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x20, 0x0, 0x9f, 0x24, 0xf7,
    0x0, 0xe, 0xc0, 0xe, 0xc0, 0x3, 0xf7, 0x0,
    0x9f, 0x10, 0x7f, 0x20, 0x4, 0xf6, 0xc, 0xc0,
    0x0, 0xe, 0xb1, 0xf7, 0x0, 0x0, 0x9f, 0x7f,
    0x20, 0x0, 0x3, 0xff, 0xc0, 0x0, 0x0, 0xe,
    0xf7, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x28, 0xde, 0x10, 0x0, 0x3, 0xfd, 0x30, 0x0,
    0x0,

    /* U+FE "þ" */
    0xbf, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0xbf, 0x4d, 0xfd, 0x70, 0xb, 0xfe,
    0x88, 0xdf, 0x70, 0xbf, 0x20, 0x1, 0xee, 0xb,
    0xf0, 0x0, 0x7, 0xf3, 0xbf, 0x0, 0x0, 0x5f,
    0x5b, 0xf0, 0x0, 0x5, 0xf4, 0xbf, 0x0, 0x0,
    0x7f, 0x2b, 0xf2, 0x0, 0xd, 0xe0, 0xbf, 0xe7,
    0x7d, 0xf6, 0xb, 0xf5, 0xdf, 0xe6, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0xbf, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0,
    0x0,

    /* U+FF "ÿ" */
    0x2, 0xf5, 0x6, 0xf2, 0x0, 0x2d, 0x50, 0x5d,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x0,
    0x9, 0xf2, 0x4f, 0x70, 0x0, 0xec, 0x0, 0xec,
    0x0, 0x3f, 0x70, 0x9, 0xf1, 0x7, 0xf2, 0x0,
    0x4f, 0x60, 0xcc, 0x0, 0x0, 0xeb, 0x1f, 0x70,
    0x0, 0x9, 0xf7, 0xf2, 0x0, 0x0, 0x3f, 0xfc,
    0x0, 0x0, 0x0, 0xef, 0x70, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0x1f, 0x70, 0x0, 0x2, 0x8d, 0xe1, 0x0, 0x0,
    0x3f, 0xd3, 0x0, 0x0, 0x0,

    /* U+100 "Ā" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x3, 0x33, 0x33,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+101 "ā" */
    0x0, 0xcf, 0xff, 0xff, 0x10, 0x3, 0x44, 0x44,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xcf,
    0xeb, 0x20, 0x5, 0xfc, 0x67, 0xee, 0x10, 0xac,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x2f, 0x70,
    0x5, 0xce, 0xff, 0xf7, 0x8, 0xf9, 0x43, 0x5f,
    0x70, 0xfb, 0x0, 0x2, 0xf7, 0xf, 0xb0, 0x0,
    0x7f, 0x70, 0xaf, 0xb8, 0xbf, 0xf8, 0x0, 0x9e,
    0xfb, 0x3c, 0x90,

    /* U+102 "Ă" */
    0x0, 0x5, 0x50, 0x6, 0x40, 0x0, 0x0, 0x8,
    0xd1, 0x2f, 0x50, 0x0, 0x0, 0x0, 0xbf, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4,

    /* U+103 "ă" */
    0x0, 0x7d, 0x0, 0xaa, 0x0, 0x3, 0xf3, 0x1e,
    0x60, 0x0, 0x7, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xb2, 0x0, 0x7f,
    0xa6, 0x7e, 0xe1, 0x6, 0x60, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff,
    0x70, 0x8f, 0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0,
    0x2f, 0x70, 0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb,
    0x8b, 0xff, 0x80, 0x9, 0xef, 0xb3, 0xc9,

    /* U+104 "Ą" */
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xcb, 0xe8,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x9e, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x3f, 0x40, 0x0, 0x0, 0xe,
    0x90, 0xd, 0xa0, 0x0, 0x0, 0x4f, 0x30, 0x7,
    0xf1, 0x0, 0x0, 0xae, 0x11, 0x13, 0xf6, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6, 0xf5,
    0x44, 0x44, 0x8f, 0x20, 0xd, 0xc0, 0x0, 0x0,
    0x1f, 0x80, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xe0,
    0x9f, 0x20, 0x0, 0x0, 0x6, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x9d, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x51,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xe3,

    /* U+105 "ą" */
    0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x5f, 0xc6, 0x7e,
    0xe1, 0xa, 0xc0, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x5c, 0xef, 0xff, 0x70, 0x8f,
    0x94, 0x35, 0xf7, 0xf, 0xb0, 0x0, 0x2f, 0x70,
    0xfb, 0x0, 0x7, 0xf7, 0xa, 0xfb, 0x8b, 0xff,
    0x80, 0x9, 0xef, 0xb3, 0xfa, 0x0, 0x0, 0x0,
    0xbc, 0x0, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x0,
    0x5, 0xf6, 0x30, 0x0, 0x0, 0xc, 0xf8,

    /* U+106 "Ć" */
    0x0, 0x0, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x64, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xd7,
    0x0, 0x6, 0xfd, 0x87, 0xbf, 0xc0, 0x2f, 0xc0,
    0x0, 0x7, 0xf6, 0x8f, 0x30, 0x0, 0x0, 0xfc,
    0xde, 0x0, 0x0, 0x0, 0x33, 0xec, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0,
    0x23, 0x9f, 0x30, 0x0, 0x0, 0xfc, 0x2f, 0xb0,
    0x0, 0x7, 0xf6, 0x7, 0xfd, 0x87, 0xbf, 0xb0,
    0x0, 0x4c, 0xff, 0xd7, 0x0,

    /* U+107 "ć" */
    0x0, 0x0, 0xd, 0xe1, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xee, 0xb2, 0x0, 0x2f,
    0xe7, 0x7e, 0xe2, 0xb, 0xf1, 0x0, 0x1f, 0x90,
    0xf9, 0x0, 0x0, 0x66, 0x2f, 0x70, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x2, 0x30, 0xbf, 0x10, 0x1, 0xea, 0x3, 0xfd,
    0x77, 0xdf, 0x20, 0x3, 0xbf, 0xfb, 0x20,

    /* U+108 "Ĉ" */
    0x0, 0x1, 0xed, 0x0, 0x0, 0x0, 0xd, 0x89,
    0xb0, 0x0, 0x0, 0x46, 0x0, 0x73, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xd7,
    0x0, 0x6, 0xfd, 0x87, 0xbf, 0xc0, 0x2f, 0xc0,
    0x0, 0x7, 0xf6, 0x8f, 0x30, 0x0, 0x0, 0xfc,
    0xde, 0x0, 0x0, 0x0, 0x33, 0xec, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0,
    0x23, 0x9f, 0x30, 0x0, 0x0, 0xfc, 0x2f, 0xb0,
    0x0, 0x7, 0xf6, 0x7, 0xfd, 0x87, 0xbf, 0xb0,
    0x0, 0x4c, 0xff, 0xd7, 0x0,

    /* U+109 "ĉ" */
    0x0, 0x4, 0xf9, 0x0, 0x0, 0x2, 0xe5, 0xd6,
    0x0, 0x0, 0x75, 0x2, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xee, 0xb2, 0x0, 0x2f,
    0xe7, 0x7e, 0xe2, 0xb, 0xf1, 0x0, 0x1f, 0x90,
    0xf9, 0x0, 0x0, 0x66, 0x2f, 0x70, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x2, 0x30, 0xbf, 0x10, 0x1, 0xea, 0x3, 0xfd,
    0x77, 0xdf, 0x20, 0x3, 0xbf, 0xfb, 0x20,

    /* U+10A "Ċ" */
    0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xd7,
    0x0, 0x6, 0xfd, 0x87, 0xbf, 0xc0, 0x2f, 0xc0,
    0x0, 0x7, 0xf6, 0x8f, 0x30, 0x0, 0x0, 0xfc,
    0xde, 0x0, 0x0, 0x0, 0x33, 0xec, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0,
    0x23, 0x9f, 0x30, 0x0, 0x0, 0xfc, 0x2f, 0xb0,
    0x0, 0x7, 0xf6, 0x7, 0xfd, 0x87, 0xbf, 0xb0,
    0x0, 0x4c, 0xff, 0xd7, 0x0,

    /* U+10B "ċ" */
    0x0, 0x1, 0xe6, 0x0, 0x0, 0x0, 0x1d, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xbe,
    0xeb, 0x20, 0x2, 0xfe, 0x77, 0xee, 0x20, 0xbf,
    0x10, 0x1, 0xf9, 0xf, 0x90, 0x0, 0x6, 0x62,
    0xf7, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x23, 0xb, 0xf1, 0x0,
    0x1e, 0xa0, 0x3f, 0xd7, 0x7d, 0xf2, 0x0, 0x3b,
    0xff, 0xb2, 0x0,

    /* U+10C "Č" */
    0x0, 0x5e, 0x23, 0xf5, 0x0, 0x0, 0x6, 0xde,
    0x60, 0x0, 0x0, 0x0, 0x65, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xd7,
    0x0, 0x6, 0xfd, 0x87, 0xbf, 0xc0, 0x2f, 0xc0,
    0x0, 0x7, 0xf6, 0x8f, 0x30, 0x0, 0x0, 0xfc,
    0xde, 0x0, 0x0, 0x0, 0x33, 0xec, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0,
    0x23, 0x9f, 0x30, 0x0, 0x0, 0xfc, 0x2f, 0xb0,
    0x0, 0x7, 0xf6, 0x7, 0xfd, 0x87, 0xbf, 0xb0,
    0x0, 0x4c, 0xff, 0xd7, 0x0,

    /* U+10D "č" */
    0x0, 0x9b, 0x7, 0xe1, 0x0, 0x0, 0xcc, 0xf3,
    0x0, 0x0, 0x1, 0x94, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xee, 0xb2, 0x0, 0x2f,
    0xe7, 0x7e, 0xe2, 0xb, 0xf1, 0x0, 0x1f, 0x90,
    0xf9, 0x0, 0x0, 0x66, 0x2f, 0x70, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x2, 0x30, 0xbf, 0x10, 0x1, 0xea, 0x3, 0xfd,
    0x77, 0xdf, 0x20, 0x3, 0xbf, 0xfb, 0x20,

    /* U+10E "Ď" */
    0x1, 0xd7, 0xb, 0xa0, 0x0, 0x0, 0x2e, 0xcb,
    0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfd, 0x70,
    0x0, 0x8f, 0x87, 0x7a, 0xfd, 0x10, 0x8f, 0x20,
    0x0, 0x3f, 0xc0, 0x8f, 0x20, 0x0, 0x7, 0xf3,
    0x8f, 0x20, 0x0, 0x1, 0xf8, 0x8f, 0x20, 0x0,
    0x0, 0xfa, 0x8f, 0x20, 0x0, 0x0, 0xeb, 0x8f,
    0x20, 0x0, 0x0, 0xfa, 0x8f, 0x20, 0x0, 0x1,
    0xf8, 0x8f, 0x20, 0x0, 0x7, 0xf4, 0x8f, 0x20,
    0x0, 0x3f, 0xc0, 0x8f, 0x86, 0x7a, 0xfd, 0x10,
    0x8f, 0xff, 0xfd, 0x70, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x0, 0xc, 0xd0, 0xe9, 0x0, 0x0,
    0x0, 0xc, 0xd0, 0xf8, 0x0, 0x0, 0x0, 0xc,
    0xd5, 0xf3, 0x0, 0x0, 0x0, 0xc, 0xd1, 0x60,
    0x0, 0x4c, 0xfd, 0x7c, 0xd0, 0x0, 0x3, 0xfe,
    0x87, 0xef, 0xd0, 0x0, 0xc, 0xf2, 0x0, 0x1e,
    0xd0, 0x0, 0xf, 0xa0, 0x0, 0xc, 0xd0, 0x0,
    0x2f, 0x80, 0x0, 0xc, 0xd0, 0x0, 0x2f, 0x80,
    0x0, 0xc, 0xd0, 0x0, 0xf, 0xa0, 0x0, 0xc,
    0xd0, 0x0, 0xb, 0xf0, 0x0, 0xe, 0xd0, 0x0,
    0x3, 0xfc, 0x55, 0xcf, 0xd0, 0x0, 0x0, 0x4c,
    0xfe, 0x8b, 0xd0, 0x0,

    /* U+110 "Đ" */
    0x4, 0xff, 0xff, 0xd9, 0x20, 0x0, 0x4f, 0xa7,
    0x79, 0xef, 0x40, 0x4, 0xf7, 0x0, 0x1, 0xde,
    0x10, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4, 0xf7,
    0x0, 0x0, 0xd, 0xd1, 0x4f, 0x71, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xfa, 0x0, 0xa, 0xf3, 0x7f,
    0x94, 0x20, 0x0, 0xbf, 0x4, 0xf7, 0x0, 0x0,
    0xd, 0xd0, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4,
    0xf7, 0x0, 0x1, 0xde, 0x10, 0x4f, 0xa6, 0x69,
    0xff, 0x40, 0x4, 0xff, 0xff, 0xd9, 0x20, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0,
    0x11, 0xcd, 0x10, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x44, 0xde, 0x42, 0x0, 0x4c,
    0xfd, 0x7c, 0xd0, 0x0, 0x3f, 0xe8, 0x7e, 0xfd,
    0x0, 0xc, 0xf2, 0x0, 0x1e, 0xd0, 0x0, 0xfa,
    0x0, 0x0, 0xcd, 0x0, 0x2f, 0x80, 0x0, 0xc,
    0xd0, 0x2, 0xf8, 0x0, 0x0, 0xcd, 0x0, 0xf,
    0xa0, 0x0, 0xc, 0xd0, 0x0, 0xbf, 0x0, 0x0,
    0xed, 0x0, 0x3, 0xfc, 0x55, 0xcf, 0xd0, 0x0,
    0x4, 0xcf, 0xe8, 0xbd, 0x0,

    /* U+112 "Ē" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0x70, 0x1, 0x33, 0x33, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+113 "ē" */
    0x0, 0xff, 0xff, 0xff, 0x0, 0x4, 0x44, 0x44,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xae,
    0xfb, 0x20, 0x1, 0xed, 0x77, 0xee, 0x10, 0xae,
    0x10, 0x2, 0xf8, 0xf, 0xa1, 0x11, 0x1d, 0xc2,
    0xff, 0xff, 0xff, 0xfe, 0x2f, 0xa4, 0x44, 0x44,
    0x41, 0xfa, 0x0, 0x0, 0x0, 0xb, 0xf3, 0x0,
    0x7, 0x20, 0x2f, 0xf8, 0x6a, 0xf6, 0x0, 0x2a,
    0xef, 0xc5, 0x0,

    /* U+114 "Ĕ" */
    0x1, 0x81, 0x2, 0x70, 0x0, 0xf, 0x70, 0x8d,
    0x0, 0x0, 0x5e, 0xfe, 0x30, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+115 "ĕ" */
    0x0, 0x9b, 0x0, 0xc8, 0x0, 0x5, 0xf1, 0x2f,
    0x40, 0x0, 0x9, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e,
    0xd7, 0x7e, 0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80,
    0xfa, 0x11, 0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff,
    0xe2, 0xfa, 0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x72, 0x2, 0xff,
    0x86, 0xaf, 0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+116 "Ė" */
    0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x4e, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xf8, 0x8f, 0x86, 0x66, 0x66, 0x38, 0xf2,
    0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x41, 0x11, 0x11,
    0x8, 0xff, 0xff, 0xff, 0xb0, 0x8f, 0x64, 0x44,
    0x43, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x86, 0x66, 0x66, 0x48, 0xff, 0xff, 0xff, 0xf9,

    /* U+117 "ė" */
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0xb, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xae,
    0xfb, 0x20, 0x1, 0xed, 0x77, 0xee, 0x10, 0xae,
    0x10, 0x2, 0xf8, 0xf, 0xa1, 0x11, 0x1d, 0xc2,
    0xff, 0xff, 0xff, 0xfe, 0x2f, 0xa4, 0x44, 0x44,
    0x41, 0xfa, 0x0, 0x0, 0x0, 0xb, 0xf3, 0x0,
    0x7, 0x20, 0x2f, 0xf8, 0x6a, 0xf6, 0x0, 0x2a,
    0xef, 0xc5, 0x0,

    /* U+118 "Ę" */
    0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8, 0x66, 0x66,
    0x63, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xf4,
    0x11, 0x11, 0x10, 0x8f, 0xff, 0xff, 0xfb, 0x8,
    0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x64, 0x8f, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x3e, 0x60, 0x0,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0xeb, 0x50,
    0x0, 0x0, 0x6, 0xfd, 0x10,

    /* U+119 "ę" */
    0x0, 0x1a, 0xef, 0xa1, 0x0, 0x1e, 0xf7, 0x8f,
    0xd0, 0xa, 0xf4, 0x0, 0x5f, 0x60, 0xfc, 0x0,
    0x0, 0xeb, 0x2f, 0x91, 0x11, 0x1c, 0xd2, 0xff,
    0xff, 0xff, 0xfe, 0x1f, 0xa4, 0x44, 0x44, 0x40,
    0xcd, 0x0, 0x0, 0x10, 0x3, 0xfd, 0x75, 0x8f,
    0x80, 0x2, 0xbf, 0xff, 0xc1, 0x0, 0x0, 0x4f,
    0x90, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x0,
    0xbd, 0x51, 0x0, 0x0, 0x4, 0xee, 0x30,

    /* U+11A "Ě" */
    0x0, 0xc8, 0xa, 0xb0, 0x0, 0x1, 0xdb, 0xc0,
    0x0, 0x0, 0x2, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x88, 0xf8,
    0x66, 0x66, 0x63, 0x8f, 0x20, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x8, 0xf4, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff,
    0xfb, 0x8, 0xf6, 0x44, 0x44, 0x30, 0x8f, 0x20,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x64,
    0x8f, 0xff, 0xff, 0xff, 0x90,

    /* U+11B "ě" */
    0x0, 0x5e, 0x23, 0xf5, 0x0, 0x0, 0x7d, 0xe7,
    0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xb2, 0x0, 0x1e,
    0xd7, 0x7e, 0xe1, 0xa, 0xe1, 0x0, 0x2f, 0x80,
    0xfa, 0x11, 0x11, 0xdc, 0x2f, 0xff, 0xff, 0xff,
    0xe2, 0xfa, 0x44, 0x44, 0x44, 0x1f, 0xa0, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x72, 0x2, 0xff,
    0x86, 0xaf, 0x60, 0x2, 0xae, 0xfc, 0x50,

    /* U+11C "Ĝ" */
    0x0, 0x2, 0xec, 0x0, 0x0, 0x0, 0x1d, 0x7a,
    0xa0, 0x0, 0x0, 0x46, 0x0, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4b, 0xef, 0xd8,
    0x10, 0x7, 0xfd, 0x87, 0xaf, 0xd1, 0x2f, 0xc0,
    0x0, 0x4, 0xf8, 0x9f, 0x30, 0x0, 0x0, 0x88,
    0xce, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x1,
    0x11, 0x11, 0xec, 0x0, 0xb, 0xff, 0xff, 0xed,
    0x0, 0x3, 0x44, 0xdf, 0xcf, 0x0, 0x0, 0x0,
    0xcf, 0x7f, 0x50, 0x0, 0x0, 0xcf, 0x1f, 0xd1,
    0x0, 0x0, 0xdf, 0x5, 0xfe, 0x97, 0x9d, 0xf8,
    0x0, 0x2a, 0xef, 0xeb, 0x40,

    /* U+11D "ĝ" */
    0x0, 0x2, 0xec, 0x0, 0x0, 0x1, 0xd8, 0xba,
    0x0, 0x0, 0x57, 0x0, 0x82, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x7a, 0xe0, 0x3f,
    0xe8, 0x7d, 0xfe, 0xb, 0xf2, 0x0, 0x1e, 0xe0,
    0xfb, 0x0, 0x0, 0xce, 0x2f, 0x80, 0x0, 0xc,
    0xe2, 0xf8, 0x0, 0x0, 0xce, 0xf, 0xa0, 0x0,
    0xc, 0xe0, 0xbf, 0x20, 0x1, 0xee, 0x3, 0xfe,
    0x88, 0xef, 0xe0, 0x4, 0xcf, 0xe7, 0xcd, 0x0,
    0x0, 0x0, 0xd, 0xd0, 0x27, 0x0, 0x3, 0xf9,
    0x6, 0xfa, 0x68, 0xef, 0x20, 0x5, 0xcf, 0xfb,
    0x20,

    /* U+11E "Ğ" */
    0x0, 0x9c, 0x1, 0xe6, 0x0, 0x0, 0x1c, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4b, 0xef, 0xd8,
    0x10, 0x7, 0xfd, 0x87, 0xaf, 0xd1, 0x2f, 0xc0,
    0x0, 0x4, 0xf8, 0x9f, 0x30, 0x0, 0x0, 0x88,
    0xce, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x1,
    0x11, 0x11, 0xec, 0x0, 0xb, 0xff, 0xff, 0xed,
    0x0, 0x3, 0x44, 0xdf, 0xcf, 0x0, 0x0, 0x0,
    0xcf, 0x7f, 0x50, 0x0, 0x0, 0xcf, 0x1f, 0xd1,
    0x0, 0x0, 0xdf, 0x5, 0xfe, 0x97, 0x9d, 0xf8,
    0x0, 0x2a, 0xef, 0xeb, 0x40,

    /* U+11F "ğ" */
    0x0, 0xaa, 0x0, 0xd7, 0x0, 0x6, 0xe1, 0x3f,
    0x30, 0x0, 0xa, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x7a, 0xe0, 0x3f,
    0xe8, 0x7d, 0xfe, 0xb, 0xf2, 0x0, 0x1e, 0xe0,
    0xfb, 0x0, 0x0, 0xce, 0x2f, 0x80, 0x0, 0xc,
    0xe2, 0xf8, 0x0, 0x0, 0xce, 0xf, 0xa0, 0x0,
    0xc, 0xe0, 0xbf, 0x20, 0x1, 0xee, 0x3, 0xfe,
    0x88, 0xef, 0xe0, 0x4, 0xcf, 0xe7, 0xcd, 0x0,
    0x0, 0x0, 0xd, 0xd0, 0x27, 0x0, 0x3, 0xf9,
    0x6, 0xfa, 0x68, 0xef, 0x20, 0x5, 0xcf, 0xfb,
    0x20,

    /* U+120 "Ġ" */
    0x0, 0x0, 0xc9, 0x0, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4b, 0xef, 0xd8,
    0x10, 0x7, 0xfd, 0x87, 0xaf, 0xd1, 0x2f, 0xc0,
    0x0, 0x4, 0xf8, 0x9f, 0x30, 0x0, 0x0, 0x88,
    0xce, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x1,
    0x11, 0x11, 0xec, 0x0, 0xb, 0xff, 0xff, 0xed,
    0x0, 0x3, 0x44, 0xdf, 0xcf, 0x0, 0x0, 0x0,
    0xcf, 0x7f, 0x50, 0x0, 0x0, 0xcf, 0x1f, 0xd1,
    0x0, 0x0, 0xdf, 0x5, 0xfe, 0x97, 0x9d, 0xf8,
    0x0, 0x2a, 0xef, 0xeb, 0x40,

    /* U+121 "ġ" */
    0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0xc, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xcf,
    0xd7, 0xae, 0x3, 0xfe, 0x87, 0xdf, 0xe0, 0xbf,
    0x20, 0x1, 0xee, 0xf, 0xb0, 0x0, 0xc, 0xe2,
    0xf8, 0x0, 0x0, 0xce, 0x2f, 0x80, 0x0, 0xc,
    0xe0, 0xfa, 0x0, 0x0, 0xce, 0xb, 0xf2, 0x0,
    0x1e, 0xe0, 0x3f, 0xe8, 0x8e, 0xfe, 0x0, 0x4c,
    0xfe, 0x7c, 0xd0, 0x0, 0x0, 0x0, 0xdd, 0x2,
    0x70, 0x0, 0x3f, 0x90, 0x6f, 0xa6, 0x8e, 0xf2,
    0x0, 0x5c, 0xff, 0xb2, 0x0,

    /* U+122 "Ģ" */
    0x0, 0x4b, 0xef, 0xd8, 0x10, 0x7, 0xfd, 0x87,
    0xaf, 0xd1, 0x2f, 0xc0, 0x0, 0x4, 0xf8, 0x9f,
    0x30, 0x0, 0x0, 0x88, 0xce, 0x0, 0x0, 0x0,
    0x0, 0xec, 0x0, 0x1, 0x11, 0x11, 0xec, 0x0,
    0xb, 0xff, 0xff, 0xed, 0x0, 0x3, 0x44, 0xdf,
    0xcf, 0x0, 0x0, 0x0, 0xcf, 0x7f, 0x50, 0x0,
    0x0, 0xcf, 0x1f, 0xd1, 0x0, 0x0, 0xdf, 0x5,
    0xfe, 0x97, 0x9d, 0xf8, 0x0, 0x2a, 0xef, 0xeb,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x20, 0x0, 0x0, 0x0, 0x7f, 0x10, 0x0,
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0x0, 0x51,
    0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x2a, 0x0, 0x0, 0x0, 0xa, 0xe0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xd7, 0xae, 0x3, 0xfe, 0x87, 0xdf, 0xe0,
    0xbf, 0x20, 0x1, 0xee, 0xf, 0xb0, 0x0, 0xc,
    0xe2, 0xf8, 0x0, 0x0, 0xce, 0x2f, 0x80, 0x0,
    0xc, 0xe0, 0xfa, 0x0, 0x0, 0xce, 0xb, 0xf2,
    0x0, 0x1e, 0xe0, 0x3f, 0xe8, 0x8e, 0xfe, 0x0,
    0x4c, 0xfe, 0x7c, 0xd0, 0x0, 0x0, 0x0, 0xdd,
    0x2, 0x70, 0x0, 0x3f, 0x90, 0x6f, 0xa6, 0x8e,
    0xf2, 0x0, 0x5c, 0xff, 0xb2, 0x0,

    /* U+124 "Ĥ" */
    0x0, 0x0, 0xaf, 0x30, 0x0, 0x0, 0x0, 0x9c,
    0x5e, 0x20, 0x0, 0x0, 0x27, 0x10, 0x55, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x6f, 0x58, 0xf2, 0x0, 0x0, 0x6,
    0xf5, 0x8f, 0x20, 0x0, 0x0, 0x6f, 0x58, 0xf2,
    0x0, 0x0, 0x6, 0xf5, 0x8f, 0x20, 0x0, 0x0,
    0x6f, 0x58, 0xf4, 0x11, 0x11, 0x17, 0xf5, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0x58, 0xf6, 0x44, 0x44,
    0x48, 0xf5, 0x8f, 0x20, 0x0, 0x0, 0x6f, 0x58,
    0xf2, 0x0, 0x0, 0x6, 0xf5, 0x8f, 0x20, 0x0,
    0x0, 0x6f, 0x58, 0xf2, 0x0, 0x0, 0x6, 0xf5,
    0x8f, 0x20, 0x0, 0x0, 0x6f, 0x50,

    /* U+125 "ĥ" */
    0x0, 0x8f, 0x50, 0x0, 0x7, 0xd4, 0xe3, 0x0,
    0x17, 0x20, 0x46, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0xcd, 0x4c, 0xfd, 0x60,
    0xcf, 0xe8, 0x7d, 0xf4, 0xcf, 0x30, 0x1, 0xf9,
    0xcd, 0x0, 0x0, 0xfa, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb,

    /* U+126 "Ħ" */
    0x9, 0xf2, 0x0, 0x0, 0x6, 0xf4, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0x7f, 0x40, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x72, 0xaf, 0x53, 0x33, 0x33,
    0x8f, 0x71, 0x9, 0xf2, 0x0, 0x0, 0x6, 0xf4,
    0x0, 0x9f, 0x31, 0x11, 0x11, 0x7f, 0x40, 0x9,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x9f, 0x64,
    0x44, 0x44, 0x9f, 0x40, 0x9, 0xf2, 0x0, 0x0,
    0x6, 0xf4, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x6f,
    0x40, 0x9, 0xf2, 0x0, 0x0, 0x6, 0xf4, 0x0,
    0x9f, 0x20, 0x0, 0x0, 0x6f, 0x40, 0x9, 0xf2,
    0x0, 0x0, 0x6, 0xf4, 0x0,

    /* U+127 "ħ" */
    0x0, 0x8f, 0x20, 0x0, 0x0, 0x1, 0x8f, 0x31,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0x50, 0x0, 0x14,
    0xaf, 0x54, 0x10, 0x0, 0x0, 0x8f, 0x3a, 0xfe,
    0x90, 0x0, 0x8f, 0xea, 0x7b, 0xf8, 0x0, 0x8f,
    0x70, 0x0, 0xdd, 0x0, 0x8f, 0x20, 0x0, 0xaf,
    0x0, 0x8f, 0x20, 0x0, 0xaf, 0x0, 0x8f, 0x20,
    0x0, 0xaf, 0x0, 0x8f, 0x20, 0x0, 0xaf, 0x0,
    0x8f, 0x20, 0x0, 0xaf, 0x0, 0x8f, 0x20, 0x0,
    0xaf, 0x0, 0x8f, 0x20, 0x0, 0xaf,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x2, 0x14, 0xef, 0xff, 0xf5, 0x23,
    0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x6f, 0x40, 0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x1, 0x3, 0xde, 0x51, 0xf4, 0xba,
    0x6e, 0xfc, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0xaf, 0x0, 0x0,

    /* U+12A "Ī" */
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xf7, 0x13,
    0x33, 0x33, 0x10, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x6f, 0x40, 0x0,

    /* U+12B "ī" */
    0xbf, 0xff, 0xff, 0x33, 0x55, 0x55, 0x51, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0xaf, 0x0, 0x0,

    /* U+12C "Ĭ" */
    0x18, 0x10, 0x28, 0x0, 0xe7, 0x8, 0xe0, 0x4,
    0xef, 0xe3, 0x0, 0x0, 0x10, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x6f, 0x40, 0x0,

    /* U+12D "ĭ" */
    0x5f, 0x0, 0x8c, 0x1f, 0x50, 0xd8, 0x6, 0xff,
    0xb1, 0x0, 0x1, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0,

    /* U+12E "Į" */
    0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4,
    0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4,
    0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4, 0x6, 0xf4,
    0x7, 0xf4, 0x1e, 0x80, 0x9c, 0x0, 0xbd, 0x51,
    0x4e, 0xe2,

    /* U+12F "į" */
    0x0, 0x8e, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0,
    0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf, 0x0, 0xa,
    0xf0, 0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0, 0xbf,
    0x0, 0x3f, 0x50, 0xd, 0x90, 0x0, 0xfa, 0x50,
    0x8, 0xfd, 0x0,

    /* U+130 "İ" */
    0x5f, 0x34, 0xe3, 0x0, 0x6, 0xf4, 0x6f, 0x46,
    0xf4, 0x6f, 0x46, 0xf4, 0x6f, 0x46, 0xf4, 0x6f,
    0x46, 0xf4, 0x6f, 0x46, 0xf4, 0x6f, 0x46, 0xf4,

    /* U+131 "ı" */
    0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf,
    0xaf, 0xaf,

    /* U+132 "Ĳ" */
    0x6f, 0x40, 0x0, 0x0, 0x0, 0x4f, 0x76, 0xf4,
    0x0, 0x0, 0x0, 0x4, 0xf7, 0x6f, 0x40, 0x0,
    0x0, 0x0, 0x4f, 0x76, 0xf4, 0x0, 0x0, 0x0,
    0x4, 0xf7, 0x6f, 0x40, 0x0, 0x0, 0x0, 0x4f,
    0x76, 0xf4, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x6f,
    0x40, 0x0, 0x0, 0x0, 0x4f, 0x76, 0xf4, 0x0,
    0x0, 0x0, 0x4, 0xf7, 0x6f, 0x40, 0x0, 0x0,
    0x0, 0x4f, 0x76, 0xf4, 0x5, 0x90, 0x0, 0x4,
    0xf6, 0x6f, 0x40, 0x7f, 0x40, 0x0, 0x9f, 0x36,
    0xf4, 0x1, 0xee, 0x64, 0x8f, 0xb0, 0x6f, 0x40,
    0x2, 0xae, 0xfd, 0x80, 0x0,

    /* U+133 "ĳ" */
    0x8e, 0x0, 0x4f, 0x38, 0xd0, 0x4, 0xe3, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x5, 0xf4, 0xaf, 0x0,
    0x5f, 0x4a, 0xf0, 0x5, 0xf4, 0xaf, 0x0, 0x5f,
    0x4a, 0xf0, 0x5, 0xf4, 0xaf, 0x0, 0x5f, 0x4a,
    0xf0, 0x5, 0xf4, 0xaf, 0x0, 0x5f, 0x4a, 0xf0,
    0x5, 0xf4, 0xaf, 0x0, 0x5f, 0x40, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x6f, 0x30, 0x1, 0x7d, 0xf1,
    0x0, 0x2f, 0xe5, 0x0,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0x0, 0x7f, 0x60, 0x0, 0x0, 0x0,
    0x5e, 0x4e, 0x40, 0x0, 0x0, 0x7, 0x30, 0x37,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x2, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0,
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x80, 0x0, 0x0, 0x0, 0x2, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x2,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x80, 0x6,
    0xc2, 0x0, 0x3, 0xf8, 0x0, 0x5f, 0x70, 0x0,
    0x9f, 0x50, 0x0, 0xdf, 0xa7, 0xaf, 0xc0, 0x0,
    0x1, 0x9d, 0xfe, 0x90, 0x0, 0x0,

    /* U+135 "ĵ" */
    0x0, 0x9f, 0x30, 0x6, 0xe6, 0xe1, 0x1a, 0x30,
    0x67, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x7f, 0x20, 0x0, 0x7f, 0x20, 0x0, 0x7f, 0x20,
    0x0, 0x7f, 0x20, 0x0, 0x7f, 0x20, 0x0, 0x7f,
    0x20, 0x0, 0x7f, 0x20, 0x0, 0x7f, 0x20, 0x0,
    0x7f, 0x20, 0x0, 0x7f, 0x20, 0x0, 0x9f, 0x0,
    0x47, 0xfc, 0x0, 0x9f, 0xb2, 0x0,

    /* U+136 "Ķ" */
    0x8f, 0x20, 0x0, 0x9, 0xf7, 0x8, 0xf2, 0x0,
    0x7, 0xf9, 0x0, 0x8f, 0x20, 0x5, 0xfb, 0x0,
    0x8, 0xf2, 0x4, 0xfc, 0x0, 0x0, 0x8f, 0x22,
    0xfd, 0x10, 0x0, 0x8, 0xf4, 0xef, 0x20, 0x0,
    0x0, 0x8f, 0xef, 0xf6, 0x0, 0x0, 0x8, 0xff,
    0x4d, 0xf3, 0x0, 0x0, 0x8f, 0x50, 0x2f, 0xd0,
    0x0, 0x8, 0xf2, 0x0, 0x5f, 0xa0, 0x0, 0x8f,
    0x20, 0x0, 0x9f, 0x60, 0x8, 0xf2, 0x0, 0x0,
    0xdf, 0x30, 0x8f, 0x20, 0x0, 0x2, 0xfd, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x0,
    0x0, 0x2, 0x50, 0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0xb, 0xf4, 0xc, 0xd0,
    0xa, 0xf5, 0x0, 0xcd, 0x8, 0xf7, 0x0, 0xc,
    0xd6, 0xf9, 0x0, 0x0, 0xcf, 0xff, 0x30, 0x0,
    0xc, 0xfc, 0xed, 0x0, 0x0, 0xce, 0x5, 0xf9,
    0x0, 0xc, 0xd0, 0x9, 0xf5, 0x0, 0xcd, 0x0,
    0xd, 0xe1, 0xc, 0xd0, 0x0, 0x2f, 0xb0, 0x0,
    0x18, 0x30, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x0, 0x5f, 0x20, 0x0, 0x0, 0x8, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+138 "ĸ" */
    0xaf, 0x0, 0x3, 0xfc, 0xa, 0xf0, 0x2, 0xed,
    0x10, 0xaf, 0x1, 0xee, 0x10, 0xa, 0xf2, 0xdf,
    0x20, 0x0, 0xaf, 0xff, 0x70, 0x0, 0xa, 0xf5,
    0xee, 0x20, 0x0, 0xaf, 0x3, 0xfc, 0x0, 0xa,
    0xf0, 0x6, 0xf9, 0x0, 0xaf, 0x0, 0xa, 0xf6,
    0xa, 0xf0, 0x0, 0xd, 0xf3,

    /* U+139 "Ĺ" */
    0x0, 0x76, 0x0, 0x0, 0x0, 0x9f, 0x30, 0x0,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30,
    0x0, 0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f,
    0x30, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x66, 0x61,
    0x8f, 0xff, 0xff, 0xff, 0x40,

    /* U+13A "ĺ" */
    0x1, 0x85, 0xb, 0xe2, 0x5e, 0x20, 0x0, 0x0,
    0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0,
    0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0,
    0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0, 0xaf, 0x0,
    0xaf, 0x0, 0xaf, 0x0,

    /* U+13B "Ļ" */
    0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x61, 0x8f, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x0, 0x7f, 0x10, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0x0, 0x42, 0x0,
    0x0,

    /* U+13C "ļ" */
    0xa, 0xf0, 0xaf, 0xa, 0xf0, 0xaf, 0xa, 0xf0,
    0xaf, 0xa, 0xf0, 0xaf, 0xa, 0xf0, 0xaf, 0xa,
    0xf0, 0xaf, 0xa, 0xf0, 0xaf, 0x0, 0x0, 0x9f,
    0xb, 0xd1, 0xf8, 0x6, 0x0,

    /* U+13D "Ľ" */
    0x8f, 0x30, 0x6f, 0x20, 0x8, 0xf3, 0x8, 0xf0,
    0x0, 0x8f, 0x30, 0xda, 0x0, 0x8, 0xf3, 0x4,
    0x10, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x61, 0x8f, 0xff,
    0xff, 0xff, 0x40,

    /* U+13E "ľ" */
    0xaf, 0x8, 0xf0, 0xaf, 0xa, 0xe0, 0xaf, 0xe,
    0x90, 0xaf, 0x6, 0x0, 0xaf, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+13F "Ŀ" */
    0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0xa, 0xd0, 0x0, 0x8f, 0x30, 0x9c, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x8, 0xf8, 0x66, 0x66, 0x61, 0x8f, 0xff,
    0xff, 0xff, 0x40,

    /* U+140 "ŀ" */
    0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf, 0x0, 0xa,
    0xf0, 0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf,
    0xc, 0xaa, 0xf0, 0xb9, 0xaf, 0x0, 0xa, 0xf0,
    0x0, 0xaf, 0x0, 0xa, 0xf0, 0x0, 0xaf, 0x0,
    0xa, 0xf0, 0x0,

    /* U+141 "Ł" */
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x0, 0x8, 0xf2, 0x1, 0x0,
    0x0, 0x8, 0xfb, 0xe7, 0x0, 0x0, 0x8f, 0xf8,
    0x20, 0x0, 0x0, 0x49, 0xf2, 0x0, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x8,
    0xf8, 0x66, 0x66, 0x61, 0x8, 0xff, 0xff, 0xff,
    0xf3,

    /* U+142 "ł" */
    0x7, 0xf3, 0x0, 0x7f, 0x30, 0x7, 0xf3, 0x0,
    0x7f, 0x30, 0x7, 0xf3, 0x0, 0x7f, 0x43, 0x8,
    0xff, 0x7a, 0xff, 0x40, 0x27, 0xf3, 0x0, 0x7f,
    0x30, 0x7, 0xf3, 0x0, 0x7f, 0x30, 0x7, 0xf3,
    0x0, 0x7f, 0x30,

    /* U+143 "Ń" */
    0x0, 0x0, 0x2, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xae, 0x10, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x0, 0x5f, 0x58, 0xff, 0x20, 0x0, 0x5,
    0xf5, 0x8f, 0xfc, 0x0, 0x0, 0x5f, 0x58, 0xfa,
    0xf6, 0x0, 0x5, 0xf5, 0x8f, 0x3d, 0xf1, 0x0,
    0x5f, 0x58, 0xf3, 0x3f, 0xb0, 0x5, 0xf5, 0x8f,
    0x30, 0x8f, 0x50, 0x5f, 0x58, 0xf3, 0x0, 0xde,
    0x15, 0xf5, 0x8f, 0x30, 0x4, 0xfa, 0x5f, 0x58,
    0xf3, 0x0, 0xa, 0xfa, 0xf5, 0x8f, 0x30, 0x0,
    0x1e, 0xff, 0x58, 0xf3, 0x0, 0x0, 0x5f, 0xf5,
    0x8f, 0x30, 0x0, 0x0, 0xbf, 0x50,

    /* U+144 "ń" */
    0x0, 0x0, 0x7f, 0x50, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0x4c, 0xfd, 0x60, 0xcf, 0xe8, 0x7d, 0xf4,
    0xcf, 0x30, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfa,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,

    /* U+145 "Ņ" */
    0x8f, 0x80, 0x0, 0x0, 0x5f, 0x58, 0xff, 0x20,
    0x0, 0x5, 0xf5, 0x8f, 0xfc, 0x0, 0x0, 0x5f,
    0x58, 0xfa, 0xf6, 0x0, 0x5, 0xf5, 0x8f, 0x3d,
    0xf1, 0x0, 0x5f, 0x58, 0xf3, 0x3f, 0xb0, 0x5,
    0xf5, 0x8f, 0x30, 0x8f, 0x50, 0x5f, 0x58, 0xf3,
    0x0, 0xde, 0x15, 0xf5, 0x8f, 0x30, 0x4, 0xfa,
    0x5f, 0x58, 0xf3, 0x0, 0xa, 0xfa, 0xf5, 0x8f,
    0x30, 0x0, 0x1e, 0xff, 0x58, 0xf3, 0x0, 0x0,
    0x5f, 0xf5, 0x8f, 0x30, 0x0, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x10, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x10, 0x0, 0x0,

    /* U+146 "ņ" */
    0xcc, 0x4c, 0xfd, 0x60, 0xcf, 0xe8, 0x7d, 0xf4,
    0xcf, 0x30, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfa,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x16, 0x0, 0x0,

    /* U+147 "Ň" */
    0x0, 0x1e, 0x70, 0xbc, 0x0, 0x0, 0x0, 0x3f,
    0xce, 0x10, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x0, 0x5f, 0x58, 0xff, 0x20, 0x0, 0x5,
    0xf5, 0x8f, 0xfc, 0x0, 0x0, 0x5f, 0x58, 0xfa,
    0xf6, 0x0, 0x5, 0xf5, 0x8f, 0x3d, 0xf1, 0x0,
    0x5f, 0x58, 0xf3, 0x3f, 0xb0, 0x5, 0xf5, 0x8f,
    0x30, 0x8f, 0x50, 0x5f, 0x58, 0xf3, 0x0, 0xde,
    0x15, 0xf5, 0x8f, 0x30, 0x4, 0xfa, 0x5f, 0x58,
    0xf3, 0x0, 0xa, 0xfa, 0xf5, 0x8f, 0x30, 0x0,
    0x1e, 0xff, 0x58, 0xf3, 0x0, 0x0, 0x5f, 0xf5,
    0x8f, 0x30, 0x0, 0x0, 0xbf, 0x50,

    /* U+148 "ň" */
    0x4, 0xe2, 0x2e, 0x60, 0x0, 0x6e, 0xd8, 0x0,
    0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0x4c, 0xfd, 0x60, 0xcf, 0xe8, 0x7d, 0xf4,
    0xcf, 0x30, 0x1, 0xf9, 0xcd, 0x0, 0x0, 0xfa,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,
    0xcd, 0x0, 0x0, 0xeb, 0xcd, 0x0, 0x0, 0xeb,

    /* U+149 "ŉ" */
    0xf, 0x90, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0, 0x26,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x4c, 0xfd,
    0x60, 0x0, 0xcf, 0xe8, 0x7d, 0xf4, 0x0, 0xcf,
    0x30, 0x1, 0xf9, 0x0, 0xcd, 0x0, 0x0, 0xfa,
    0x0, 0xcd, 0x0, 0x0, 0xeb, 0x0, 0xcd, 0x0,
    0x0, 0xeb, 0x0, 0xcd, 0x0, 0x0, 0xeb, 0x0,
    0xcd, 0x0, 0x0, 0xeb, 0x0, 0xcd, 0x0, 0x0,
    0xeb, 0x0, 0xcd, 0x0, 0x0, 0xeb,

    /* U+14A "Ŋ" */
    0x9f, 0x60, 0x0, 0x0, 0x9f, 0x29, 0xff, 0x10,
    0x0, 0x9, 0xf2, 0x9f, 0xfa, 0x0, 0x0, 0x9f,
    0x29, 0xfa, 0xf4, 0x0, 0x9, 0xf2, 0x9f, 0x2d,
    0xe0, 0x0, 0x9f, 0x29, 0xf1, 0x4f, 0x80, 0x9,
    0xf2, 0x9f, 0x10, 0xaf, 0x20, 0x9f, 0x29, 0xf1,
    0x1, 0xec, 0x9, 0xf2, 0x9f, 0x10, 0x6, 0xf6,
    0x9f, 0x29, 0xf1, 0x0, 0xc, 0xfb, 0xf2, 0x9f,
    0x10, 0x0, 0x2f, 0xff, 0x29, 0xf1, 0x0, 0x0,
    0x8f, 0xf2, 0x9f, 0x10, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x5, 0x8f, 0xb0,
    0x0, 0x0, 0x0, 0xaf, 0xb1, 0x0,

    /* U+14B "ŋ" */
    0xbc, 0x3c, 0xfd, 0x60, 0xbe, 0xd8, 0x7d, 0xf5,
    0xbf, 0x10, 0x1, 0xfb, 0xbe, 0x0, 0x0, 0xcd,
    0xbe, 0x0, 0x0, 0xcd, 0xbe, 0x0, 0x0, 0xcd,
    0xbe, 0x0, 0x0, 0xcd, 0xbe, 0x0, 0x0, 0xcd,
    0xbe, 0x0, 0x0, 0xcd, 0xbe, 0x0, 0x0, 0xcd,
    0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0xdc,
    0x0, 0x0, 0x7a, 0xf7, 0x0, 0x0, 0xee, 0x90,

    /* U+14C "Ō" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x23, 0x33, 0x33, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+14D "ō" */
    0x0, 0xdf, 0xff, 0xff, 0x0, 0x0, 0x44, 0x44,
    0x44, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2a, 0xef, 0xc4, 0x0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0xa, 0xf2, 0x0, 0xd, 0xe0, 0xf, 0xa0,
    0x0, 0x6, 0xf4, 0x2f, 0x80, 0x0, 0x3, 0xf6,
    0x2f, 0x70, 0x0, 0x3, 0xf6, 0xf, 0xa0, 0x0,
    0x6, 0xf4, 0xb, 0xf2, 0x0, 0xd, 0xe0, 0x2,
    0xee, 0x87, 0xdf, 0x50, 0x0, 0x2a, 0xff, 0xc4,
    0x0,

    /* U+14E "Ŏ" */
    0x0, 0x37, 0x0, 0x46, 0x0, 0x0, 0x3, 0xf3,
    0xc, 0x90, 0x0, 0x0, 0x7, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+14F "ŏ" */
    0x0, 0x8c, 0x0, 0xa9, 0x0, 0x0, 0x4f, 0x21,
    0xe5, 0x0, 0x0, 0x8, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xc4,
    0x0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0xa, 0xf2,
    0x0, 0xd, 0xe0, 0xf, 0xa0, 0x0, 0x6, 0xf4,
    0x2f, 0x80, 0x0, 0x3, 0xf6, 0x2f, 0x70, 0x0,
    0x3, 0xf6, 0xf, 0xa0, 0x0, 0x6, 0xf4, 0xb,
    0xf2, 0x0, 0xd, 0xe0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0x0, 0x2a, 0xff, 0xc4, 0x0,

    /* U+150 "Ő" */
    0x0, 0x0, 0xcd, 0x1d, 0xd1, 0x0, 0x0, 0x4f,
    0x39, 0xe2, 0x0, 0x0, 0x9, 0x62, 0xb3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xc6, 0x0, 0x0, 0x5f, 0xe9, 0x8c, 0xfb,
    0x0, 0x1f, 0xc0, 0x0, 0x7, 0xf7, 0x8, 0xf4,
    0x0, 0x0, 0xd, 0xe0, 0xce, 0x0, 0x0, 0x0,
    0x8f, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf4, 0xfb,
    0x0, 0x0, 0x0, 0x5f, 0x5e, 0xc0, 0x0, 0x0,
    0x6, 0xf4, 0xce, 0x0, 0x0, 0x0, 0x8f, 0x28,
    0xf4, 0x0, 0x0, 0xc, 0xe0, 0x1f, 0xc1, 0x0,
    0x7, 0xf7, 0x0, 0x5f, 0xe9, 0x8b, 0xfb, 0x0,
    0x0, 0x3b, 0xef, 0xd7, 0x0, 0x0,

    /* U+151 "ő" */
    0x0, 0x0, 0xdb, 0x1e, 0xb0, 0x0, 0x7, 0xf1,
    0xbd, 0x0, 0x0, 0xa, 0x54, 0xb1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xc4,
    0x0, 0x2, 0xee, 0x87, 0xdf, 0x50, 0xa, 0xf2,
    0x0, 0xd, 0xe0, 0xf, 0xa0, 0x0, 0x6, 0xf4,
    0x2f, 0x80, 0x0, 0x3, 0xf6, 0x2f, 0x70, 0x0,
    0x3, 0xf6, 0xf, 0xa0, 0x0, 0x6, 0xf4, 0xb,
    0xf2, 0x0, 0xd, 0xe0, 0x2, 0xee, 0x87, 0xdf,
    0x50, 0x0, 0x2a, 0xff, 0xc4, 0x0,

    /* U+152 "Œ" */
    0x0, 0x6, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0xbf, 0xda, 0x9a, 0xfc, 0x99, 0x99, 0x97,
    0x6, 0xf9, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x4, 0xf7, 0x11, 0x11, 0x10,
    0x1f, 0x80, 0x0, 0x4, 0xff, 0xff, 0xff, 0xf0,
    0x1f, 0x80, 0x0, 0x4, 0xf9, 0x44, 0x44, 0x40,
    0xf, 0xa0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x7, 0xf6, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xb7, 0x58, 0xfa, 0x66, 0x66, 0x65,
    0x0, 0x7, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+153 "œ" */
    0x0, 0x2a, 0xef, 0xb3, 0x2, 0xaf, 0xfa, 0x20,
    0x1, 0xee, 0x87, 0xdf, 0x6e, 0xe7, 0x7e, 0xe1,
    0xa, 0xf2, 0x0, 0x1e, 0xff, 0x10, 0x3, 0xf7,
    0xf, 0xb0, 0x0, 0x7, 0xfa, 0x11, 0x11, 0xfb,
    0x1f, 0x80, 0x0, 0x5, 0xff, 0xff, 0xff, 0xfb,
    0x1f, 0x80, 0x0, 0x5, 0xfa, 0x44, 0x44, 0x43,
    0xf, 0xa0, 0x0, 0x7, 0xfa, 0x0, 0x0, 0x0,
    0xa, 0xf2, 0x0, 0xe, 0xff, 0x20, 0x0, 0x20,
    0x2, 0xee, 0x77, 0xdf, 0x6f, 0xe7, 0x69, 0xf4,
    0x0, 0x2a, 0xff, 0xb3, 0x2, 0xae, 0xfd, 0x70,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0x2f, 0xb0, 0x0, 0x0, 0x0, 0xbd,
    0x10, 0x0, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfe, 0xc5,
    0x0, 0x8f, 0x87, 0x78, 0xdf, 0x80, 0x8f, 0x20,
    0x0, 0xd, 0xf0, 0x8f, 0x20, 0x0, 0x8, 0xf2,
    0x8f, 0x20, 0x0, 0xb, 0xf1, 0x8f, 0x41, 0x13,
    0x9f, 0x90, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x8f,
    0x64, 0x4c, 0xf1, 0x0, 0x8f, 0x20, 0x3, 0xf8,
    0x0, 0x8f, 0x20, 0x0, 0xcf, 0x10, 0x8f, 0x20,
    0x0, 0x4f, 0x80, 0x8f, 0x20, 0x0, 0xc, 0xf1,
    0x8f, 0x20, 0x0, 0x4, 0xf8,

    /* U+155 "ŕ" */
    0x0, 0xe, 0xd1, 0x0, 0x9e, 0x10, 0x1, 0x92,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x7e, 0xd0, 0xcf,
    0xe8, 0x60, 0xcf, 0x10, 0x0, 0xcd, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xcd,
    0x0, 0x0,

    /* U+156 "Ŗ" */
    0x8f, 0xff, 0xfe, 0xc5, 0x0, 0x8f, 0x87, 0x78,
    0xdf, 0x80, 0x8f, 0x20, 0x0, 0xd, 0xf0, 0x8f,
    0x20, 0x0, 0x8, 0xf2, 0x8f, 0x20, 0x0, 0xb,
    0xf1, 0x8f, 0x41, 0x13, 0x9f, 0x90, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x8f, 0x64, 0x4c, 0xf1, 0x0,
    0x8f, 0x20, 0x3, 0xf8, 0x0, 0x8f, 0x20, 0x0,
    0xcf, 0x10, 0x8f, 0x20, 0x0, 0x4f, 0x80, 0x8f,
    0x20, 0x0, 0xc, 0xf1, 0x8f, 0x20, 0x0, 0x4,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf2, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x5, 0x10,
    0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x0, 0xc, 0xd7, 0xed, 0xc, 0xfe,
    0x86, 0xc, 0xf1, 0x0, 0xc, 0xd0, 0x0, 0xc,
    0xd0, 0x0, 0xc, 0xd0, 0x0, 0xc, 0xd0, 0x0,
    0xc, 0xd0, 0x0, 0xc, 0xd0, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0xb,
    0xd0, 0x0, 0x1f, 0x70, 0x0, 0x6, 0x0, 0x0,

    /* U+158 "Ř" */
    0x1, 0xe7, 0xb, 0xb0, 0x0, 0x0, 0x4f, 0xce,
    0x10, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfe, 0xc5,
    0x0, 0x8f, 0x87, 0x78, 0xdf, 0x80, 0x8f, 0x20,
    0x0, 0xd, 0xf0, 0x8f, 0x20, 0x0, 0x8, 0xf2,
    0x8f, 0x20, 0x0, 0xb, 0xf1, 0x8f, 0x41, 0x13,
    0x9f, 0x90, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x8f,
    0x64, 0x4c, 0xf1, 0x0, 0x8f, 0x20, 0x3, 0xf8,
    0x0, 0x8f, 0x20, 0x0, 0xcf, 0x10, 0x8f, 0x20,
    0x0, 0x4f, 0x80, 0x8f, 0x20, 0x0, 0xc, 0xf1,
    0x8f, 0x20, 0x0, 0x4, 0xf8,

    /* U+159 "ř" */
    0xa, 0xa0, 0x8d, 0x10, 0xc, 0xbe, 0x10, 0x0,
    0x17, 0x20, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd7,
    0xed, 0x0, 0xcf, 0xe8, 0x60, 0xc, 0xf1, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0xcd,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0xcd, 0x0,
    0x0,

    /* U+15A "Ś" */
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x27, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xdf, 0xe9,
    0x10, 0x3, 0xfe, 0x97, 0x9f, 0xe2, 0xb, 0xf2,
    0x0, 0x3, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0xac,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xef, 0xa5,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xf9, 0x20, 0x0,
    0x0, 0x3, 0x9f, 0xf3, 0x0, 0x0, 0x0, 0x2,
    0xfc, 0x3e, 0x60, 0x0, 0x0, 0xbf, 0xe, 0xd1,
    0x0, 0x1, 0xed, 0x5, 0xfe, 0x97, 0x8e, 0xf5,
    0x0, 0x2a, 0xef, 0xea, 0x30,

    /* U+15B "ś" */
    0x0, 0x0, 0x9, 0xf4, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0x91, 0x0, 0x6f,
    0xa6, 0x9f, 0xd0, 0xc, 0xd0, 0x0, 0x7f, 0x30,
    0xbf, 0x30, 0x0, 0x0, 0x2, 0xdf, 0xd9, 0x30,
    0x0, 0x0, 0x49, 0xdf, 0xa0, 0x2, 0x10, 0x0,
    0x8f, 0x41, 0xfa, 0x0, 0x5, 0xf5, 0x9, 0xfa,
    0x67, 0xee, 0x10, 0x7, 0xdf, 0xea, 0x20,

    /* U+15C "Ŝ" */
    0x0, 0x0, 0x7f, 0x60, 0x0, 0x0, 0x6, 0xe4,
    0xe4, 0x0, 0x0, 0x7, 0x30, 0x37, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xdf, 0xe9,
    0x10, 0x3, 0xfe, 0x97, 0x9f, 0xe2, 0xb, 0xf2,
    0x0, 0x3, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0xac,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xef, 0xa5,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xf9, 0x20, 0x0,
    0x0, 0x3, 0x9f, 0xf3, 0x0, 0x0, 0x0, 0x2,
    0xfc, 0x3e, 0x60, 0x0, 0x0, 0xbf, 0xe, 0xd1,
    0x0, 0x1, 0xed, 0x5, 0xfe, 0x97, 0x8e, 0xf5,
    0x0, 0x2a, 0xef, 0xea, 0x30,

    /* U+15D "ŝ" */
    0x0, 0x1, 0xec, 0x0, 0x0, 0x0, 0xd8, 0xab,
    0x0, 0x0, 0x57, 0x0, 0x83, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0x91, 0x0, 0x6f,
    0xa6, 0x9f, 0xd0, 0xc, 0xd0, 0x0, 0x7f, 0x30,
    0xbf, 0x30, 0x0, 0x0, 0x2, 0xdf, 0xd9, 0x30,
    0x0, 0x0, 0x49, 0xdf, 0xa0, 0x2, 0x10, 0x0,
    0x8f, 0x41, 0xfa, 0x0, 0x5, 0xf5, 0x9, 0xfa,
    0x67, 0xee, 0x10, 0x7, 0xdf, 0xea, 0x20,

    /* U+15E "Ş" */
    0x0, 0x2a, 0xdf, 0xe9, 0x10, 0x3, 0xfe, 0x97,
    0x9f, 0xe2, 0xb, 0xf2, 0x0, 0x3, 0xfa, 0xd,
    0xd0, 0x0, 0x0, 0xac, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xa5, 0x0, 0x0, 0x0, 0x8,
    0xef, 0xf9, 0x20, 0x0, 0x0, 0x3, 0x9f, 0xf3,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x3e, 0x60, 0x0,
    0x0, 0xbf, 0xe, 0xd1, 0x0, 0x1, 0xed, 0x5,
    0xfe, 0x97, 0x8e, 0xf5, 0x0, 0x2a, 0xef, 0xea,
    0x30, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0,
    0x4, 0xf4, 0x0, 0x0, 0x0, 0x2, 0xf4, 0x0,
    0x0, 0x0, 0x4e, 0x80, 0x0,

    /* U+15F "ş" */
    0x0, 0x5c, 0xfe, 0x91, 0x0, 0x6f, 0xa6, 0x9f,
    0xd0, 0xc, 0xd0, 0x0, 0x7f, 0x30, 0xbf, 0x30,
    0x0, 0x0, 0x2, 0xdf, 0xd9, 0x30, 0x0, 0x0,
    0x49, 0xdf, 0xa0, 0x2, 0x10, 0x0, 0x8f, 0x41,
    0xfa, 0x0, 0x5, 0xf5, 0x9, 0xfa, 0x67, 0xee,
    0x10, 0x7, 0xdf, 0xfa, 0x20, 0x0, 0x0, 0xbc,
    0x10, 0x0, 0x0, 0x3, 0xcb, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0xd, 0xb2, 0x0,

    /* U+160 "Š" */
    0x0, 0xc, 0x80, 0xac, 0x0, 0x0, 0x1, 0xdb,
    0xd1, 0x0, 0x0, 0x0, 0x27, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xdf, 0xe9,
    0x10, 0x3, 0xfe, 0x97, 0x9f, 0xe2, 0xb, 0xf2,
    0x0, 0x3, 0xfa, 0xd, 0xd0, 0x0, 0x0, 0xac,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xef, 0xa5,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xf9, 0x20, 0x0,
    0x0, 0x3, 0x9f, 0xf3, 0x0, 0x0, 0x0, 0x2,
    0xfc, 0x3e, 0x60, 0x0, 0x0, 0xbf, 0xe, 0xd1,
    0x0, 0x1, 0xed, 0x5, 0xfe, 0x97, 0x8e, 0xf5,
    0x0, 0x2a, 0xef, 0xea, 0x30,

    /* U+161 "š" */
    0x0, 0x5e, 0x23, 0xf4, 0x0, 0x0, 0x8d, 0xe6,
    0x0, 0x0, 0x0, 0x86, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0x91, 0x0, 0x6f,
    0xa6, 0x9f, 0xd0, 0xc, 0xd0, 0x0, 0x7f, 0x30,
    0xbf, 0x30, 0x0, 0x0, 0x2, 0xdf, 0xd9, 0x30,
    0x0, 0x0, 0x49, 0xdf, 0xa0, 0x2, 0x10, 0x0,
    0x8f, 0x41, 0xfa, 0x0, 0x5, 0xf5, 0x9, 0xfa,
    0x67, 0xee, 0x10, 0x7, 0xdf, 0xea, 0x20,

    /* U+162 "Ţ" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x53, 0x66, 0x6b,
    0xf8, 0x66, 0x62, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x17,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x20, 0x0,
    0x0, 0x0, 0x6e, 0x70, 0x0, 0x0,

    /* U+163 "ţ" */
    0x3, 0xf7, 0x0, 0x3, 0xf7, 0x0, 0xef, 0xff,
    0xf3, 0x46, 0xf9, 0x41, 0x3, 0xf7, 0x0, 0x3,
    0xf7, 0x0, 0x3, 0xf7, 0x0, 0x3, 0xf7, 0x0,
    0x3, 0xf7, 0x0, 0x2, 0xf7, 0x0, 0x0, 0xfd,
    0x72, 0x0, 0x6f, 0xf3, 0x0, 0xb, 0xc2, 0x0,
    0x2, 0xbc, 0x0, 0x0, 0xab, 0x0, 0xc, 0xc2,

    /* U+164 "Ť" */
    0x0, 0x1e, 0x70, 0xbc, 0x0, 0x0, 0x0, 0x4f,
    0xbe, 0x10, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0x53, 0x66, 0x6b, 0xf8, 0x66,
    0x62, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+165 "ť" */
    0x0, 0x0, 0xf, 0x90, 0x0, 0x2, 0xf6, 0x1,
    0x83, 0x6d, 0x0, 0x3f, 0x70, 0x10, 0x3, 0xf7,
    0x0, 0xe, 0xff, 0xff, 0x30, 0x46, 0xf9, 0x41,
    0x0, 0x3f, 0x70, 0x0, 0x3, 0xf7, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x2, 0xf7, 0x0, 0x0, 0xf, 0xd7,
    0x20, 0x0, 0x6e, 0xe3, 0x0,

    /* U+166 "Ŧ" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x53, 0x66, 0x6b,
    0xf8, 0x66, 0x62, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x0, 0x0, 0x18, 0xf4, 0x10, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0x40, 0x0, 0x1, 0x49, 0xf7, 0x41,
    0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x18, 0x30, 0x0, 0x3, 0xf7, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0xef, 0xff, 0xf3, 0x4, 0x6f,
    0x94, 0x10, 0x14, 0xf7, 0x10, 0x1f, 0xff, 0xff,
    0x70, 0x46, 0xf9, 0x42, 0x0, 0x3f, 0x70, 0x0,
    0x3, 0xf7, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0xfd, 0x72, 0x0, 0x6, 0xee, 0x30,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x8f, 0xb3,
    0x6e, 0x0, 0x1, 0xf5, 0x8f, 0xf6, 0x0, 0x0,
    0x30, 0x1, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf7, 0xbf, 0x0,
    0x0, 0x5, 0xf6, 0x6f, 0x70, 0x0, 0xc, 0xf2,
    0xc, 0xfb, 0x78, 0xdf, 0x80, 0x0, 0x8d, 0xff,
    0xc5, 0x0,

    /* U+169 "ũ" */
    0x0, 0x0, 0x0, 0x10, 0x6, 0xec, 0x34, 0xf0,
    0xf, 0x78, 0xff, 0x90, 0x3, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xaf, 0x10, 0x3, 0xfb, 0x5f, 0xc7, 0x9f, 0xfb,
    0x7, 0xdf, 0xd5, 0xdb,

    /* U+16A "Ū" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x33, 0x33, 0x33, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+16B "ū" */
    0xe, 0xff, 0xff, 0xf0, 0x4, 0x44, 0x44, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xaf, 0x10, 0x3, 0xfb, 0x5f, 0xc7, 0x9f, 0xfb,
    0x7, 0xdf, 0xd5, 0xdb,

    /* U+16C "Ŭ" */
    0x0, 0x54, 0x0, 0x63, 0x0, 0x0, 0x8d, 0x2,
    0xf4, 0x0, 0x0, 0x1b, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+16D "ŭ" */
    0x9, 0xb0, 0xc, 0x80, 0x5, 0xf2, 0x2f, 0x40,
    0x0, 0x9f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xdb,

    /* U+16E "Ů" */
    0x0, 0x4, 0xcb, 0x10, 0x0, 0x0, 0xd, 0x14,
    0xa0, 0x0, 0x0, 0xd, 0x14, 0xa0, 0x0, 0x0,
    0x4, 0xcb, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf7, 0xbf, 0x0,
    0x0, 0x5, 0xf6, 0x6f, 0x70, 0x0, 0xc, 0xf2,
    0xc, 0xfb, 0x78, 0xdf, 0x80, 0x0, 0x8d, 0xff,
    0xc5, 0x0,

    /* U+16F "ů" */
    0x0, 0x3c, 0xc3, 0x0, 0x0, 0xc2, 0x2c, 0x0,
    0x0, 0xc2, 0x2c, 0x0, 0x0, 0x3c, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xaf, 0x10, 0x3, 0xfb, 0x5f, 0xc7, 0x9f, 0xfb,
    0x7, 0xdf, 0xd5, 0xdb,

    /* U+170 "Ű" */
    0x0, 0x2, 0xf8, 0x3f, 0x80, 0x0, 0xa, 0xd1,
    0xda, 0x0, 0x0, 0x1b, 0x37, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf7, 0xbf, 0x0, 0x0, 0x5, 0xf6, 0x6f, 0x70,
    0x0, 0xc, 0xf2, 0xc, 0xfb, 0x78, 0xdf, 0x80,
    0x0, 0x8d, 0xff, 0xc5, 0x0,

    /* U+171 "ű" */
    0x0, 0xe, 0xa2, 0xfa, 0x0, 0x8, 0xe1, 0xcc,
    0x0, 0x0, 0xb4, 0x5b, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0xfb, 0xc, 0xd0,
    0x0, 0xf, 0xb0, 0xcd, 0x0, 0x0, 0xfb, 0xc,
    0xd0, 0x0, 0xf, 0xb0, 0xcd, 0x0, 0x0, 0xfb,
    0xc, 0xd0, 0x0, 0xf, 0xb0, 0xcd, 0x0, 0x0,
    0xfb, 0xa, 0xf1, 0x0, 0x3f, 0xb0, 0x5f, 0xc7,
    0x9f, 0xfb, 0x0, 0x7d, 0xfd, 0x5d, 0xb0,

    /* U+172 "Ų" */
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0,
    0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce,
    0x0, 0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3,
    0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0xce, 0x0, 0x0, 0x3, 0xf8,
    0xce, 0x0, 0x0, 0x3, 0xf8, 0xbf, 0x0, 0x0,
    0x5, 0xf7, 0x6f, 0x80, 0x0, 0xc, 0xf4, 0xc,
    0xfb, 0x78, 0xdf, 0xd0, 0x0, 0x8d, 0xff, 0xfd,
    0x20, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0, 0x0,
    0x9e, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x52, 0x0,
    0x0, 0x0, 0x2d, 0xe4, 0x0,

    /* U+173 "ų" */
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xcd, 0x0, 0x0, 0xfb,
    0xcd, 0x0, 0x0, 0xfb, 0xaf, 0x10, 0x3, 0xfb,
    0x5f, 0xc7, 0x9f, 0xfb, 0x7, 0xdf, 0xd5, 0xea,
    0x0, 0x0, 0xa, 0xd1, 0x0, 0x0, 0x3f, 0x40,
    0x0, 0x0, 0x4f, 0x74, 0x0, 0x0, 0xb, 0xf9,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x0, 0xb, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8d, 0xbb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf3, 0xd, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0xc, 0xe0, 0x0, 0x3, 0xf7,
    0x1f, 0x80, 0x0, 0xf, 0xf3, 0x0, 0x7, 0xf3,
    0xe, 0xc0, 0x0, 0x4f, 0xf7, 0x0, 0xa, 0xf0,
    0xa, 0xf0, 0x0, 0x9e, 0xac, 0x0, 0xe, 0xb0,
    0x6, 0xf3, 0x0, 0xda, 0x6f, 0x0, 0x1f, 0x80,
    0x2, 0xf7, 0x2, 0xf5, 0x2f, 0x40, 0x5f, 0x40,
    0x0, 0xeb, 0x6, 0xf1, 0xd, 0x90, 0x8f, 0x0,
    0x0, 0xae, 0xb, 0xc0, 0x9, 0xd0, 0xcc, 0x0,
    0x0, 0x7f, 0x2f, 0x70, 0x4, 0xf2, 0xf8, 0x0,
    0x0, 0x3f, 0x9f, 0x20, 0x0, 0xf9, 0xf5, 0x0,
    0x0, 0xf, 0xee, 0x0, 0x0, 0xce, 0xf1, 0x0,
    0x0, 0xb, 0xf9, 0x0, 0x0, 0x7f, 0xd0, 0x0,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x3f, 0x90, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x0, 0x4, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x5c, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x64, 0x1, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x1, 0xf8,
    0x0, 0xa, 0xf0, 0x3f, 0x60, 0x5, 0xfd, 0x0,
    0xe, 0xb0, 0xe, 0xa0, 0xa, 0xef, 0x20, 0x2f,
    0x60, 0xa, 0xe0, 0xe, 0x6f, 0x70, 0x5f, 0x20,
    0x6, 0xf2, 0x3f, 0x1a, 0xb0, 0x9d, 0x0, 0x1,
    0xf6, 0x8c, 0x5, 0xf1, 0xd9, 0x0, 0x0, 0xda,
    0xd7, 0x1, 0xf7, 0xf4, 0x0, 0x0, 0x8e, 0xf3,
    0x0, 0xce, 0xf0, 0x0, 0x0, 0x4f, 0xe0, 0x0,
    0x7f, 0xc0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x2f,
    0x70, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x0, 0x7f, 0x40, 0x0, 0x0, 0x0, 0x3f,
    0x9e, 0x10, 0x0, 0x0, 0x1e, 0x70, 0xab, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x8f, 0x51, 0xfc, 0x0, 0x0, 0x1f,
    0xd0, 0x8, 0xf5, 0x0, 0x8, 0xf4, 0x0, 0xe,
    0xd0, 0x1, 0xfb, 0x0, 0x0, 0x7f, 0x50, 0x8f,
    0x30, 0x0, 0x0, 0xdd, 0x1f, 0xa0, 0x0, 0x0,
    0x5, 0xfc, 0xf2, 0x0, 0x0, 0x0, 0xc, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,

    /* U+177 "ŷ" */
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x6, 0xe4, 0xe4,
    0x0, 0x0, 0x72, 0x3, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x20, 0x0, 0x9f, 0x24, 0xf7,
    0x0, 0xe, 0xc0, 0xe, 0xc0, 0x3, 0xf7, 0x0,
    0x9f, 0x10, 0x7f, 0x20, 0x4, 0xf6, 0xc, 0xc0,
    0x0, 0xe, 0xb1, 0xf7, 0x0, 0x0, 0x9f, 0x7f,
    0x20, 0x0, 0x3, 0xff, 0xc0, 0x0, 0x0, 0xe,
    0xf7, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x28, 0xde, 0x10, 0x0, 0x3, 0xfd, 0x30, 0x0,
    0x0,

    /* U+178 "Ÿ" */
    0x0, 0x3f, 0x40, 0x6e, 0x20, 0x0, 0x3, 0xe4,
    0x6, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf5, 0x0, 0x0, 0x8, 0xf5, 0x1f, 0xc0,
    0x0, 0x1, 0xfd, 0x0, 0x8f, 0x50, 0x0, 0x8f,
    0x40, 0x0, 0xed, 0x0, 0x1f, 0xb0, 0x0, 0x7,
    0xf5, 0x8, 0xf3, 0x0, 0x0, 0xd, 0xd1, 0xfa,
    0x0, 0x0, 0x0, 0x5f, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0xcf, 0x90, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xae, 0x10, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x66, 0x66, 0x66, 0xaf,
    0x90, 0x0, 0x0, 0x0, 0x1e, 0xe1, 0x0, 0x0,
    0x0, 0xa, 0xf4, 0x0, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x0, 0x1, 0xed, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0x0, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x66, 0x66, 0x66, 0x60,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x10,

    /* U+17A "ź" */
    0x0, 0x0, 0x1e, 0xc0, 0x0, 0x0, 0xa, 0xd1,
    0x0, 0x0, 0x1, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0x10, 0x66,
    0x66, 0x8f, 0xc0, 0x0, 0x0, 0xc, 0xf2, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0x5f, 0x90, 0x0, 0x0, 0x1e, 0xf6,
    0x66, 0x66, 0x13, 0xff, 0xff, 0xff, 0xf5,

    /* U+17B "Ż" */
    0x0, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x0, 0x4,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x6, 0x66,
    0x66, 0x6a, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xee,
    0x10, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0x90, 0x0, 0x0, 0x0, 0x1e, 0xd0,
    0x0, 0x0, 0x0, 0xb, 0xf3, 0x0, 0x0, 0x0,
    0x6, 0xf8, 0x0, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x66,
    0x66, 0x66, 0x4, 0xff, 0xff, 0xff, 0xff, 0xf1,

    /* U+17C "ż" */
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x3e, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xf1, 0x6, 0x66, 0x68, 0xfc, 0x0, 0x0,
    0x0, 0xcf, 0x20, 0x0, 0x0, 0x7f, 0x60, 0x0,
    0x0, 0x3f, 0xb0, 0x0, 0x0, 0xd, 0xe1, 0x0,
    0x0, 0x9, 0xf4, 0x0, 0x0, 0x5, 0xf9, 0x0,
    0x0, 0x1, 0xef, 0x66, 0x66, 0x61, 0x3f, 0xff,
    0xff, 0xff, 0x50,

    /* U+17D "Ž" */
    0x0, 0xd, 0x80, 0xbc, 0x0, 0x0, 0x0, 0x3f,
    0xbe, 0x10, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x66, 0x66, 0x66, 0xaf,
    0x90, 0x0, 0x0, 0x0, 0x1e, 0xe1, 0x0, 0x0,
    0x0, 0xa, 0xf4, 0x0, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x0, 0x1, 0xed, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0x0, 0x0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x66, 0x66, 0x66, 0x60,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x10,

    /* U+17E "ž" */
    0x0, 0xb9, 0x9, 0xc0, 0x0, 0x0, 0xdb, 0xd1,
    0x0, 0x0, 0x1, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0x10, 0x66,
    0x66, 0x8f, 0xc0, 0x0, 0x0, 0xc, 0xf2, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0x5f, 0x90, 0x0, 0x0, 0x1e, 0xf6,
    0x66, 0x66, 0x13, 0xff, 0xff, 0xff, 0xf5,

    /* U+17F "ſ" */
    0x0, 0x0, 0x0, 0x6e, 0xf8, 0x3f, 0xb5, 0x27,
    0xf2, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0,
    0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,
    0x9, 0xf0, 0x0, 0x9f, 0x0, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48,
    0xdf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1, 0x6a,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xb7, 0x3f,
    0xf2, 0x0, 0x0, 0x5f, 0xff, 0xfe, 0x95, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x5, 0xff, 0x73, 0x0,
    0x0, 0x0, 0x1f, 0xf2, 0x0, 0x0, 0x5f, 0xe0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x20, 0x0, 0x5,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2, 0x0,
    0x0, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x5, 0xfe, 0x0, 0x0, 0x0, 0x69,
    0x8f, 0xf2, 0x0, 0x0, 0x5f, 0xe0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0x20, 0x3, 0x58, 0xfe, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf2, 0x2d, 0xff, 0xff,
    0xe0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0xb, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x4, 0xbd, 0xc8, 0x10,
    0xaf, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x51, 0x6, 0x88, 0x88, 0x88, 0x88, 0x88, 0x30,
    0x15, 0xf7, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb6, 0x8f, 0xfd, 0xcf, 0xf3, 0x33, 0x33, 0x33,
    0x6f, 0xec, 0xdf, 0xf2, 0xc, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x2f, 0xf2, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x2f, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf4, 0x2d,
    0xf9, 0x99, 0x99, 0x99, 0xbf, 0x92, 0x4f, 0xf2,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2f,
    0xfb, 0xaf, 0xf1, 0x11, 0x11, 0x11, 0x5f, 0xda,
    0xbf, 0xf9, 0x8e, 0xe0, 0x0, 0x0, 0x0, 0x3f,
    0xc8, 0x9f, 0xf2, 0xc, 0xe0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x2f, 0xf6, 0x4d, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0xa4, 0x6f, 0xfe, 0xef, 0xfb, 0xbb,
    0xbb, 0xbb, 0xcf, 0xfe, 0xef, 0xc2, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x2c,

    /* U+F00B "" */
    0x58, 0x88, 0x70, 0x28, 0x88, 0x88, 0x88, 0x88,
    0x85, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xd1, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xe1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
    0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x58, 0x88, 0x60, 0x27, 0x88, 0x88,
    0x88, 0x88, 0x85, 0x47, 0x77, 0x50, 0x17, 0x77,
    0x77, 0x77, 0x77, 0x74, 0xff, 0xff, 0xf3, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xf1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x90, 0x9, 0xd2, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x9f, 0xfe,
    0x20, 0x0, 0x8, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0xff, 0xe2, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x0,
    0x2e, 0xff, 0xfe, 0x28, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd8, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x2d, 0xb0, 0x0, 0x0, 0x6, 0xe6, 0xd, 0xff,
    0xc0, 0x0, 0x6, 0xff, 0xf3, 0xcf, 0xff, 0xc0,
    0x6, 0xff, 0xff, 0x31, 0xdf, 0xff, 0xc7, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x6, 0xff, 0xff, 0xdf,
    0xff, 0xc0, 0x6, 0xff, 0xff, 0x51, 0xdf, 0xff,
    0xc0, 0xff, 0xff, 0x50, 0x1, 0xdf, 0xff, 0x58,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xd0, 0x5, 0x30,
    0x0, 0x0, 0x1, 0x61, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe3, 0x3, 0xff,
    0xa0, 0xb, 0xc1, 0x0, 0x0, 0x8, 0xff, 0xb0,
    0x3f, 0xfa, 0x4, 0xff, 0xd1, 0x0, 0x4, 0xff,
    0xf6, 0x3, 0xff, 0xa0, 0x1e, 0xff, 0xa0, 0x0,
    0xdf, 0xf7, 0x0, 0x3f, 0xfa, 0x0, 0x2e, 0xff,
    0x40, 0x3f, 0xfc, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x6f, 0xfa, 0x8, 0xff, 0x60, 0x0, 0x3f, 0xfa,
    0x0, 0x0, 0xef, 0xf0, 0xaf, 0xf2, 0x0, 0x3,
    0xff, 0xa0, 0x0, 0xb, 0xff, 0x1b, 0xff, 0x10,
    0x0, 0x1f, 0xf8, 0x0, 0x0, 0xbf, 0xf1, 0x9f,
    0xf3, 0x0, 0x0, 0x24, 0x0, 0x0, 0xd, 0xff,
    0x6, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xd0, 0x1f, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf8, 0x0, 0x9f, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x9f, 0xfe, 0x10, 0x0, 0xcf, 0xfe,
    0x71, 0x0, 0x4, 0xcf, 0xff, 0x50, 0x0, 0x1,
    0xdf, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x28, 0xce, 0xfd, 0xa5,
    0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x4, 0x66, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x78, 0x17, 0xff, 0xff,
    0xff, 0x71, 0x87, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x3f, 0xff,
    0xff, 0xfe, 0x88, 0xef, 0xff, 0xff, 0xf3, 0x8,
    0xff, 0xff, 0xd0, 0x0, 0xd, 0xff, 0xff, 0x80,
    0x0, 0xaf, 0xff, 0x50, 0x0, 0x5, 0xff, 0xfa,
    0x0, 0x0, 0xbf, 0xff, 0x30, 0x0, 0x3, 0xff,
    0xfb, 0x0, 0x1, 0xcf, 0xff, 0x80, 0x0, 0x8,
    0xff, 0xfc, 0x10, 0x3e, 0xff, 0xff, 0xf6, 0x0,
    0x6f, 0xff, 0xff, 0xe3, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0x8e, 0xff, 0xff, 0xff, 0xe8, 0xfd, 0x0, 0x0,
    0x11, 0x1, 0x9f, 0xff, 0xf9, 0x10, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xee, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0x92, 0x0, 0x6b,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0xe4, 0xa, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xff, 0xff, 0xf6, 0xaf, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfe, 0x31, 0xcf, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x9f, 0xfd, 0x25, 0x70,
    0xaf, 0xff, 0xf2, 0x0, 0x0, 0x1, 0xbf, 0xfa,
    0x8, 0xff, 0xb0, 0x7f, 0xff, 0x40, 0x0, 0x2,
    0xdf, 0xf8, 0xa, 0xff, 0xff, 0xd2, 0x5f, 0xff,
    0x50, 0x4, 0xff, 0xf5, 0x1d, 0xff, 0xff, 0xff,
    0xe4, 0x2e, 0xff, 0x70, 0xdf, 0xe3, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x1c, 0xff, 0x13, 0xb1,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x9,
    0x60, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfd,
    0x88, 0xbf, 0xff, 0xfe, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x70, 0x3, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xf7, 0x0, 0x3f, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x70,
    0x3, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf5, 0x0, 0x2f, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x9, 0xaa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xee, 0xef, 0xff, 0xfe, 0xee, 0xc0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x24, 0x44, 0x44, 0x7,
    0xff, 0x70, 0x44, 0x44, 0x42, 0xff, 0xff, 0xff,
    0xc1, 0x66, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x66, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F01C "" */
    0x0, 0x0, 0x4, 0x44, 0x44, 0x44, 0x44, 0x41,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x6, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xa0, 0x0, 0x1, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x50, 0x0, 0xbf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfe, 0x10, 0x6f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0xfa, 0xe, 0xff, 0xcc, 0xcc, 0x20, 0x0, 0x0,
    0xbc, 0xcc, 0xef, 0xf2, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0x88, 0x8e, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x15, 0x66, 0x40, 0x0, 0x5,
    0xcb, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff, 0x92,
    0x7, 0xff, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x66, 0xff, 0x0, 0x8f, 0xff, 0xa4, 0x12,
    0x5b, 0xff, 0xfd, 0xff, 0x4, 0xff, 0xe4, 0x0,
    0x0, 0x0, 0x4e, 0xff, 0xff, 0xd, 0xff, 0x30,
    0x0, 0x0, 0x45, 0x46, 0xff, 0xff, 0x4f, 0xf7,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0x2, 0x10, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22,
    0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x67, 0x77, 0x77, 0x75, 0x0, 0x0,
    0x0, 0x6, 0x73, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x3f, 0xf6, 0xff, 0xff, 0xee, 0xfd,
    0x0, 0x0, 0x0, 0xcf, 0xf1, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xa0, 0xff, 0xff,
    0xfb, 0x20, 0x0, 0x2, 0xbf, 0xfe, 0x10, 0xff,
    0x8d, 0xff, 0xfc, 0xa9, 0xcf, 0xff, 0xe2, 0x0,
    0xff, 0x61, 0x9f, 0xff, 0xff, 0xff, 0xfb, 0x10,
    0x0, 0xff, 0x70, 0x1, 0x7c, 0xee, 0xd9, 0x30,
    0x0, 0x0, 0x56, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x2,
    0xef, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0, 0x3,
    0xef, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xdf,
    0xff, 0xf0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xf0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0x10, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3f, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xd, 0xf3, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x3f, 0x70, 0x8b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x40, 0x0, 0x0, 0x2d, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0x0, 0x0, 0x40, 0x1c,
    0xf4, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0,
    0x5f, 0xb0, 0x1e, 0xe1, 0x0, 0x0, 0x3, 0xef,
    0xff, 0x0, 0x0, 0xaf, 0xa0, 0x6f, 0x70, 0xdf,
    0xff, 0xff, 0xff, 0xf0, 0x7, 0x10, 0xbf, 0x30,
    0xfd, 0xf, 0xff, 0xff, 0xff, 0xff, 0x3, 0xfd,
    0x3, 0xf9, 0xa, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0xf5, 0xe, 0xc0, 0x8f, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x4f, 0x70, 0xdd, 0x7,
    0xf3, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1d, 0xf3,
    0xf, 0xb0, 0x9f, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0x3, 0xf7, 0x7, 0xf6, 0xc, 0xf0, 0x7b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x3, 0xfe, 0x12, 0xfa,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x3, 0xff,
    0x40, 0xaf, 0x30, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x3c, 0x30, 0x6f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x6f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x90, 0x0, 0x0,

    /* U+F03E "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xa3, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xd5, 0x6e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x50, 0x7,
    0xff, 0xff, 0xf5, 0x8, 0xff, 0xff, 0xff, 0xfb,
    0xbf, 0xff, 0xff, 0x50, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xf5, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xfc, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xc0, 0x0, 0x3, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0x74, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F048 "" */
    0x6b, 0x90, 0x0, 0x0, 0x3, 0xa2, 0x9f, 0xe0,
    0x0, 0x0, 0x4f, 0xf9, 0x9f, 0xe0, 0x0, 0x5,
    0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x6f, 0xff, 0xfa,
    0x9f, 0xe0, 0x7, 0xff, 0xff, 0xfa, 0x9f, 0xe0,
    0x8f, 0xff, 0xff, 0xfa, 0x9f, 0xe9, 0xff, 0xff,
    0xff, 0xfa, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9f, 0xfe,
    0xff, 0xff, 0xff, 0xfa, 0x9f, 0xe1, 0xdf, 0xff,
    0xff, 0xfa, 0x9f, 0xe0, 0x1c, 0xff, 0xff, 0xfa,
    0x9f, 0xe0, 0x0, 0xbf, 0xff, 0xfa, 0x9f, 0xe0,
    0x0, 0xa, 0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x0,
    0x9f, 0xfa, 0x9f, 0xe0, 0x0, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x3a, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x3a, 0xbb, 0xb9, 0x10, 0x3, 0xab, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xa0, 0xe, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xfe, 0x40, 0x7, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04D "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F051 "" */
    0x4a, 0x20, 0x0, 0x0, 0xa, 0xb4, 0xbf, 0xe3,
    0x0, 0x0, 0xf, 0xf8, 0xcf, 0xff, 0x40, 0x0,
    0xf, 0xf8, 0xcf, 0xff, 0xf5, 0x0, 0xf, 0xf8,
    0xcf, 0xff, 0xff, 0x60, 0xf, 0xf8, 0xcf, 0xff,
    0xff, 0xf7, 0xf, 0xf8, 0xcf, 0xff, 0xff, 0xff,
    0x9f, 0xf8, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xcf, 0xff,
    0xff, 0xff, 0xdf, 0xf8, 0xcf, 0xff, 0xff, 0xfc,
    0x1f, 0xf8, 0xcf, 0xff, 0xff, 0xb0, 0xf, 0xf8,
    0xcf, 0xff, 0xfa, 0x0, 0xf, 0xf8, 0xcf, 0xff,
    0x80, 0x0, 0xf, 0xf8, 0xbf, 0xf7, 0x0, 0x0,
    0xf, 0xf8, 0x7f, 0x60, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2, 0xca, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x34, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42, 0x0, 0x3, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x10, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f,
    0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0x20, 0x0, 0x0, 0x0, 0x3c, 0x60,

    /* U+F054 "" */
    0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xc1,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0,
    0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff,
    0x50, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x60, 0x0, 0x0, 0xe, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x3d, 0x50, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x39, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x36, 0x77, 0x77, 0xef, 0xfc, 0x77, 0x77, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x3, 0x68, 0x87, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xff, 0xff,
    0xff, 0xf9, 0x20, 0x0, 0x0, 0x0, 0x4, 0xef,
    0xfd, 0x63, 0x25, 0xbf, 0xff, 0x70, 0x0, 0x0,
    0x7, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xa0, 0x0, 0x6, 0xff, 0xfd, 0x0, 0x8, 0xfc,
    0x20, 0x9f, 0xff, 0xa0, 0x2, 0xff, 0xff, 0x50,
    0x0, 0x8f, 0xfe, 0x12, 0xff, 0xff, 0x60, 0xcf,
    0xff, 0xf2, 0x16, 0x7f, 0xff, 0xf5, 0xe, 0xff,
    0xfe, 0x1e, 0xff, 0xff, 0x12, 0xff, 0xff, 0xff,
    0x70, 0xdf, 0xff, 0xf2, 0x6f, 0xff, 0xf3, 0xe,
    0xff, 0xff, 0xf3, 0xf, 0xff, 0xfb, 0x0, 0xbf,
    0xff, 0x90, 0x4f, 0xff, 0xf8, 0x5, 0xff, 0xfe,
    0x10, 0x1, 0xdf, 0xff, 0x40, 0x28, 0x84, 0x1,
    0xef, 0xff, 0x30, 0x0, 0x1, 0xbf, 0xff, 0x60,
    0x0, 0x4, 0xef, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x6e, 0xff, 0xfb, 0xbe, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xad, 0xff, 0xeb, 0x71,
    0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x4a, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0x60, 0x0, 0x15, 0x78, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xa6, 0xdf, 0xff,
    0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xe8, 0x32, 0x5b, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xf6, 0x0, 0x10,
    0x6, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xf8, 0x7f, 0xd3, 0x9, 0xff, 0xfb, 0x0,
    0x0, 0x1e, 0x70, 0x1, 0xbf, 0xfe, 0xff, 0xf2,
    0x1f, 0xff, 0xf7, 0x0, 0x9, 0xff, 0xa0, 0x0,
    0x8f, 0xff, 0xff, 0x70, 0xdf, 0xff, 0xf1, 0x0,
    0xcf, 0xff, 0xd1, 0x0, 0x5f, 0xff, 0xf9, 0xc,
    0xff, 0xff, 0x30, 0x5, 0xff, 0xff, 0x60, 0x0,
    0x2d, 0xff, 0xb0, 0xef, 0xff, 0xb0, 0x0, 0xa,
    0xff, 0xfc, 0x0, 0x0, 0xa, 0xff, 0xef, 0xff,
    0xe1, 0x0, 0x0, 0xc, 0xff, 0xf6, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xf8, 0x10, 0x0, 0x3, 0xef, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xef, 0xff, 0xcb, 0x80,
    0x1, 0xbf, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x5a, 0xdf, 0xfe, 0x70, 0x0, 0x8f, 0xfe, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xcd, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfb, 0x33,
    0x8f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xf9, 0x0, 0x6f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x6f, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xfb,
    0x0, 0x7f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfd, 0x0, 0x9f,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff,
    0xfc, 0x0, 0x2, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0x60, 0xa, 0xff, 0xff,
    0xff, 0xfe, 0x42, 0xcf, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x23,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf9, 0x0, 0x12, 0x22, 0x10, 0x0, 0x0, 0x1,
    0x29, 0xff, 0x90, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfe, 0x20,
    0x5, 0xff, 0xff, 0xff, 0xfd, 0x9a, 0xad, 0xff,
    0xd0, 0x5f, 0xff, 0xbd, 0xff, 0xe2, 0x0, 0x0,
    0xcf, 0x44, 0xff, 0xf9, 0x8, 0xfe, 0x20, 0x0,
    0x0, 0x4, 0x4f, 0xff, 0x90, 0x4, 0xd2, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xa1, 0x91, 0x6,
    0xf6, 0x0, 0x0, 0x2, 0xef, 0xfb, 0xc, 0xfc,
    0x8, 0xff, 0x60, 0xef, 0xff, 0xff, 0xb0, 0x1d,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xfc, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xb0,
    0x0, 0x0, 0x2d, 0xde, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xfa, 0xcf, 0xfe, 0x30, 0x0,
    0x0, 0x6f, 0xff, 0x90, 0xc, 0xff, 0xe3, 0x0,
    0x6, 0xff, 0xf9, 0x0, 0x0, 0xcf, 0xfe, 0x30,
    0x5f, 0xff, 0x90, 0x0, 0x0, 0xc, 0xff, 0xe2,
    0xaf, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf6,
    0x1b, 0x80, 0x0, 0x0, 0x0, 0x0, 0xb, 0x90,

    /* U+F078 "" */
    0x3, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3, 0x20,
    0x6f, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf2,
    0xaf, 0xfe, 0x20, 0x0, 0x0, 0x5, 0xff, 0xf6,
    0x1c, 0xff, 0xe3, 0x0, 0x0, 0x5f, 0xff, 0x90,
    0x1, 0xcf, 0xfe, 0x30, 0x5, 0xff, 0xf9, 0x0,
    0x0, 0x1c, 0xff, 0xe3, 0x5f, 0xff, 0x90, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0x90, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x26, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xa0,
    0x0, 0x44, 0x44, 0x44, 0x44, 0x42, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfa, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff,
    0xa0, 0xaf, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xe, 0xfd, 0xef, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0xb, 0xe2, 0xdf, 0x67,
    0xf5, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x4,
    0x15, 0xfe, 0x3, 0x20, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x6f, 0xd6, 0xfe, 0x4f, 0xf1,
    0x0, 0x0, 0xdf, 0x94, 0x44, 0x44, 0x41, 0x3f,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0x24, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0x30,
    0x4f, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0,

    /* U+F07B "" */
    0x17, 0x88, 0x88, 0x84, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44,
    0x44, 0x44, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x11, 0x2f, 0xff, 0xf7, 0x11, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x24, 0x44, 0x42, 0x1f,
    0xff, 0xf6, 0x24, 0x44, 0x42, 0xff, 0xff, 0xfc,
    0x8, 0xbb, 0xa2, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xa5, 0x55, 0x5a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xb8,
    0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x90,
    0x0, 0x0, 0x4, 0xa5, 0x0, 0x0, 0xaf, 0xff,
    0xd0, 0x0, 0x0, 0x7d, 0xff, 0xf4, 0x2, 0xcf,
    0xff, 0xe2, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xe9,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xfc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xfd, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x23, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x35, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xff, 0xfa, 0x0, 0x0, 0x1, 0x9c, 0xa1,
    0xaf, 0xfe, 0xff, 0x60, 0x0, 0x2e, 0xff, 0xf9,
    0xef, 0x60, 0xaf, 0xb0, 0x3, 0xef, 0xff, 0xb0,
    0xef, 0x92, 0xcf, 0x90, 0x3e, 0xff, 0xfa, 0x0,
    0x7f, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xa0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x36, 0xef, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0xaf, 0xfe, 0xff, 0xc2, 0xdf, 0xff, 0xd1, 0x0,
    0xef, 0x60, 0xaf, 0xa0, 0x1c, 0xff, 0xfd, 0x20,
    0xef, 0x92, 0xcf, 0xa0, 0x0, 0xcf, 0xff, 0xe2,
    0x7f, 0xff, 0xff, 0x40, 0x0, 0xb, 0xff, 0xf9,
    0x8, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x58, 0x50,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xf1, 0x68, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0x80,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0xf8,
    0x36, 0x62, 0xaf, 0xff, 0xff, 0xf1, 0x36, 0x66,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xf6, 0x22, 0x22,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf7, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x20, 0x0, 0x0,

    /* U+F0C7 "" */
    0x5, 0x66, 0x66, 0x66, 0x66, 0x64, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0xff, 0xed, 0xdd, 0xdd, 0xdd, 0xef, 0xf9, 0x0,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0x90,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf9,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xc5, 0x7f, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfe, 0x0, 0x5, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfa, 0x0, 0x1, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfd, 0x0, 0x4, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0x93, 0x4d, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F0E7 "" */
    0x0, 0xaf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xa5, 0x55, 0x40, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x1, 0x22, 0x23, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x8d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x8b, 0xbc, 0xfa, 0xfd, 0xbb, 0x90, 0x0, 0x0,
    0xff, 0xff, 0xd0, 0xcf, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x95, 0xff, 0xff, 0xf1, 0x79, 0x0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xb0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xfa,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf2, 0x2, 0x21,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xdd, 0xdc,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x7a, 0xaa, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x8, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xcf, 0xfa, 0x40, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
    0xf4, 0x4, 0xd0, 0x2f, 0x0, 0xf3, 0x3, 0xf0,
    0xf, 0xf4, 0xff, 0x40, 0x5d, 0x2, 0xf0, 0xf,
    0x40, 0x4f, 0x0, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0x22, 0xb7, 0x29, 0xa2, 0x4f, 0x42, 0xcf,
    0xff, 0x4f, 0xff, 0xf0, 0xa, 0x60, 0x79, 0x2,
    0xf2, 0xb, 0xff, 0xf4, 0xff, 0xff, 0xdd, 0xfe,
    0xdf, 0xfd, 0xef, 0xed, 0xff, 0xff, 0x4f, 0xf8,
    0x48, 0xe4, 0x44, 0x44, 0x44, 0x47, 0xf4, 0x5f,
    0xf4, 0xff, 0x40, 0x4d, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0xff, 0x4f, 0xf7, 0x48, 0xe4, 0x44,
    0x44, 0x44, 0x47, 0xf4, 0x4f, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x8b, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xaf, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x6, 0xdf, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x17, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x29,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x56,
    0x66, 0x66, 0x7f, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x58, 0x88, 0x88, 0x87, 0x6, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfe, 0xf, 0x90, 0x0, 0xff, 0xff,
    0xff, 0xfe, 0xf, 0xf9, 0x0, 0xff, 0xff, 0xff,
    0xfe, 0xf, 0xff, 0x90, 0xff, 0xff, 0xff, 0xfe,
    0xf, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x32,
    0x22, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x14, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x30,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36,
    0x89, 0xa9, 0x74, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x29, 0xef, 0xff, 0xff, 0xff, 0xff, 0xc6,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x60, 0x0, 0x6, 0xff,
    0xff, 0xfc, 0x75, 0x43, 0x46, 0x9e, 0xff, 0xff,
    0xb1, 0x8, 0xff, 0xfe, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xcf, 0xff, 0xe2, 0xcf, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0x40, 0xb6, 0x0, 0x0, 0x59, 0xde, 0xfe, 0xc7,
    0x20, 0x0, 0x1b, 0x50, 0x0, 0x0, 0x5, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xfe, 0xde, 0xff, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xfc, 0x40,
    0x0, 0x2, 0x8f, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1, 0xb6, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x3f, 0xf5, 0xff, 0x4a, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xef,
    0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xf5, 0xff, 0x45, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F241 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x30, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F242 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4c,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4c, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F243 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x49,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x49, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x44, 0x88, 0x87,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F244 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x26, 0x9f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xef, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x80,
    0x2e, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xe3, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xa1, 0x0, 0xcf, 0xff, 0xd4,
    0x9f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7f, 0xf7,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xaf, 0xff, 0xa0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x3f, 0xb2, 0x0,
    0x9c, 0x90, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0x1, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbb, 0x2, 0xbb, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x9f, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xbd, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x1, 0x7b, 0xdd, 0xb8, 0x20, 0x0, 0x0,
    0x5f, 0xff, 0xdf, 0xff, 0xf6, 0x0, 0x4, 0xff,
    0xff, 0x68, 0xff, 0xff, 0x40, 0xe, 0xff, 0xff,
    0x60, 0x9f, 0xff, 0xd0, 0x4f, 0xff, 0xff, 0x60,
    0x9, 0xff, 0xf3, 0x8f, 0xf6, 0xbf, 0x61, 0xc0,
    0x9f, 0xf7, 0xbf, 0xf6, 0xb, 0x60, 0xe2, 0x5f,
    0xf9, 0xdf, 0xff, 0x50, 0x20, 0x33, 0xff, 0xfb,
    0xef, 0xff, 0xf5, 0x0, 0x2e, 0xff, 0xfc, 0xef,
    0xff, 0xfc, 0x0, 0x7f, 0xff, 0xfc, 0xdf, 0xff,
    0xd1, 0x0, 0x9, 0xff, 0xfc, 0xcf, 0xfc, 0x14,
    0x50, 0x90, 0xaf, 0xfb, 0xaf, 0xf2, 0x4f, 0x60,
    0xf3, 0x2f, 0xf9, 0x6f, 0xfd, 0xff, 0x70, 0x52,
    0xef, 0xf6, 0x1f, 0xff, 0xff, 0x70, 0x2e, 0xff,
    0xf1, 0x9, 0xff, 0xff, 0x72, 0xef, 0xff, 0x90,
    0x0, 0xbf, 0xff, 0xae, 0xff, 0xfd, 0x10, 0x0,
    0x5, 0xcf, 0xff, 0xfd, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x5, 0x88, 0x88, 0x30, 0x0, 0x0,
    0x56, 0x66, 0x7f, 0xff, 0xff, 0xe6, 0x66, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xcd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd8,
    0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x24, 0x44, 0x44, 0x44, 0x44, 0x31, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8a,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x34, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x44, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0x44, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0x44, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0x41, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x57, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x72, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0xbf, 0xff, 0xff, 0xf8,
    0xaf, 0xff, 0xa8, 0xff, 0xff, 0xf8, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0xaf, 0xa0, 0xa, 0xff,
    0xff, 0x80, 0xbf, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x60, 0x3, 0xff, 0xff, 0xf8, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x9f, 0xff, 0xff, 0xf8, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xff, 0xb0, 0x3, 0xe3, 0x0,
    0xbf, 0xff, 0xf8, 0x0, 0x4f, 0xff, 0xff, 0xfe,
    0x23, 0xff, 0xf3, 0x2e, 0xff, 0xff, 0x80, 0x0,
    0x4f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90,

    /* U+F7C2 "" */
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xcf,
    0x47, 0xf4, 0xd8, 0x4f, 0xf5, 0xc, 0xff, 0x3,
    0xe0, 0xc5, 0xe, 0xf5, 0xcf, 0xff, 0x3, 0xe0,
    0xc5, 0xe, 0xf5, 0xff, 0xff, 0x24, 0xe2, 0xc6,
    0x2e, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x1, 0x34,
    0x44, 0x44, 0x44, 0x42, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x10, 0x0, 0x3e, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf1, 0x0, 0x4f,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x10,
    0x5f, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf1, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x3e, 0xff, 0xfe, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x2e, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 71, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20, .adv_w = 92, .box_w = 4, .box_h = 5, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 30, .adv_w = 177, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 95, .adv_w = 162, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 185, .adv_w = 211, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 270, .adv_w = 179, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 348, .adv_w = 50, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 356, .adv_w = 98, .box_w = 5, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 406, .adv_w = 100, .box_w = 5, .box_h = 20, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 456, .adv_w = 124, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 488, .adv_w = 163, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 538, .adv_w = 57, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 546, .adv_w = 79, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 554, .adv_w = 76, .box_w = 3, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 557, .adv_w = 119, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 610, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 669, .adv_w = 162, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 708, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 773, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 832, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 897, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 956, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1015, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1080, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1145, .adv_w = 162, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1204, .adv_w = 70, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1219, .adv_w = 61, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1239, .adv_w = 146, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1275, .adv_w = 158, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1303, .adv_w = 150, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1339, .adv_w = 136, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1391, .adv_w = 259, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1527, .adv_w = 188, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1605, .adv_w = 179, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1670, .adv_w = 187, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1735, .adv_w = 189, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1800, .adv_w = 164, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1859, .adv_w = 159, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1918, .adv_w = 196, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1983, .adv_w = 205, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2055, .adv_w = 78, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2075, .adv_w = 159, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2134, .adv_w = 181, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2206, .adv_w = 155, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2265, .adv_w = 251, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2356, .adv_w = 205, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2428, .adv_w = 198, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2500, .adv_w = 182, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2565, .adv_w = 198, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2661, .adv_w = 177, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2726, .adv_w = 171, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2791, .adv_w = 172, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2863, .adv_w = 187, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2928, .adv_w = 183, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3006, .adv_w = 256, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3110, .adv_w = 181, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3182, .adv_w = 173, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3254, .adv_w = 172, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3326, .adv_w = 76, .box_w = 4, .box_h = 20, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3366, .adv_w = 118, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3426, .adv_w = 76, .box_w = 4, .box_h = 20, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3466, .adv_w = 120, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 3491, .adv_w = 130, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3505, .adv_w = 89, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 3513, .adv_w = 157, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3558, .adv_w = 162, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3621, .adv_w = 151, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3666, .adv_w = 162, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3729, .adv_w = 153, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3774, .adv_w = 100, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3827, .adv_w = 162, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3890, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3946, .adv_w = 70, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3966, .adv_w = 69, .box_w = 5, .box_h = 17, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4009, .adv_w = 146, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4072, .adv_w = 70, .box_w = 2, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4086, .adv_w = 252, .box_w = 14, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4156, .adv_w = 159, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4196, .adv_w = 164, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4246, .adv_w = 162, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4309, .adv_w = 164, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4372, .adv_w = 97, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4400, .adv_w = 149, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4445, .adv_w = 94, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4484, .adv_w = 159, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4524, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4569, .adv_w = 216, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4639, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4684, .adv_w = 136, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4747, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4792, .adv_w = 97, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4849, .adv_w = 70, .box_w = 2, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4865, .adv_w = 97, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4922, .adv_w = 196, .box_w = 11, .box_h = 4, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 4944, .adv_w = 71, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4944, .adv_w = 70, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4965, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5033, .adv_w = 167, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5098, .adv_w = 205, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5183, .adv_w = 151, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5248, .adv_w = 69, .box_w = 2, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5264, .adv_w = 177, .box_w = 11, .box_h = 19, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 5369, .adv_w = 120, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 5376, .adv_w = 226, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5481, .adv_w = 129, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5502, .adv_w = 135, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5534, .adv_w = 159, .box_w = 8, .box_h = 5, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 5554, .adv_w = 79, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 5562, .adv_w = 226, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5667, .adv_w = 132, .box_w = 7, .box_h = 3, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 5678, .adv_w = 108, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 5693, .adv_w = 154, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5747, .adv_w = 106, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 5768, .adv_w = 106, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 5789, .adv_w = 90, .box_w = 4, .box_h = 3, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 5795, .adv_w = 163, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5851, .adv_w = 141, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5903, .adv_w = 75, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5908, .adv_w = 71, .box_w = 3, .box_h = 5, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5916, .adv_w = 106, .box_w = 4, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5930, .adv_w = 131, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5955, .adv_w = 135, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5987, .adv_w = 211, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6078, .adv_w = 223, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6176, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6267, .adv_w = 136, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6323, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6425, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6527, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6629, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6731, .adv_w = 188, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6827, .adv_w = 188, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6935, .adv_w = 269, .box_w = 18, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7052, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 7137, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7214, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7291, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7368, .adv_w = 164, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7440, .adv_w = 78, .box_w = 5, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7483, .adv_w = 78, .box_w = 5, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7526, .adv_w = 78, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7586, .adv_w = 78, .box_w = 7, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7642, .adv_w = 193, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7714, .adv_w = 205, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7808, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7902, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7996, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8090, .adv_w = 198, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8189, .adv_w = 198, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8277, .adv_w = 154, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8322, .adv_w = 198, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8405, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8490, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8575, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8660, .adv_w = 187, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8740, .adv_w = 173, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8834, .adv_w = 170, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8893, .adv_w = 171, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8956, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9019, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9082, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9145, .adv_w = 157, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9213, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9272, .adv_w = 157, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9340, .adv_w = 243, .box_w = 15, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9415, .adv_w = 151, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9478, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9541, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9604, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9667, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9726, .adv_w = 71, .box_w = 5, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9761, .adv_w = 71, .box_w = 4, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9789, .adv_w = 71, .box_w = 6, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9831, .adv_w = 71, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9877, .adv_w = 169, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9945, .adv_w = 159, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10005, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10075, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10145, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10215, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10290, .adv_w = 164, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10355, .adv_w = 164, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 10405, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10465, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10521, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10577, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10633, .adv_w = 159, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10685, .adv_w = 136, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10766, .adv_w = 166, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 10847, .adv_w = 136, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10924, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11026, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11085, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11187, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11250, .adv_w = 188, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11352, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11415, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11500, .adv_w = 151, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11563, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11648, .adv_w = 151, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11711, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11796, .adv_w = 151, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11855, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11940, .adv_w = 151, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12003, .adv_w = 189, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12088, .adv_w = 184, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12172, .adv_w = 193, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12244, .adv_w = 172, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12321, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12398, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12457, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12534, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12597, .adv_w = 164, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12669, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12728, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12805, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12868, .adv_w = 164, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12945, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13008, .adv_w = 196, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13093, .adv_w = 162, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13174, .adv_w = 196, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13259, .adv_w = 162, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13340, .adv_w = 196, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13425, .adv_w = 162, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13502, .adv_w = 196, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 13592, .adv_w = 162, .box_w = 9, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13678, .adv_w = 205, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13772, .adv_w = 159, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13840, .adv_w = 202, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13925, .adv_w = 163, .box_w = 10, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13995, .adv_w = 78, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14055, .adv_w = 71, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14108, .adv_w = 78, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14168, .adv_w = 71, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14214, .adv_w = 78, .box_w = 7, .box_h = 17, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14274, .adv_w = 71, .box_w = 6, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14316, .adv_w = 78, .box_w = 4, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14350, .adv_w = 70, .box_w = 5, .box_h = 17, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 14393, .adv_w = 78, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14417, .adv_w = 71, .box_w = 2, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14427, .adv_w = 237, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14512, .adv_w = 139, .box_w = 7, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 14572, .adv_w = 159, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14666, .adv_w = 72, .box_w = 6, .box_h = 18, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 14720, .adv_w = 181, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 14814, .adv_w = 146, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14900, .adv_w = 160, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14945, .adv_w = 155, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15022, .adv_w = 70, .box_w = 4, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15058, .adv_w = 155, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15139, .adv_w = 70, .box_w = 3, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 15168, .adv_w = 155, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15227, .adv_w = 91, .box_w = 6, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15269, .adv_w = 155, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15328, .adv_w = 101, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15363, .adv_w = 155, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15428, .adv_w = 78, .box_w = 5, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15463, .adv_w = 205, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15557, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15613, .adv_w = 205, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15712, .adv_w = 159, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15772, .adv_w = 205, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15866, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15922, .adv_w = 159, .box_w = 10, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15992, .adv_w = 200, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 16086, .adv_w = 163, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 16142, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16236, .adv_w = 164, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16301, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16395, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16465, .adv_w = 198, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16559, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16629, .adv_w = 275, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16733, .adv_w = 262, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16813, .adv_w = 177, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16898, .adv_w = 97, .box_w = 6, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16940, .adv_w = 177, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 17030, .adv_w = 97, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 17078, .adv_w = 177, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17163, .adv_w = 97, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17212, .adv_w = 171, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17297, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17360, .adv_w = 171, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17445, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17508, .adv_w = 171, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17593, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17656, .adv_w = 171, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17741, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17804, .adv_w = 172, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17898, .adv_w = 94, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17946, .adv_w = 172, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18040, .adv_w = 100, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18093, .adv_w = 172, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18165, .adv_w = 94, .box_w = 7, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 18211, .adv_w = 187, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18301, .adv_w = 159, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18361, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18446, .adv_w = 159, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18498, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18583, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18639, .adv_w = 187, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18729, .adv_w = 159, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18789, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18874, .adv_w = 159, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18937, .adv_w = 187, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 19022, .adv_w = 159, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 19078, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19214, .adv_w = 216, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19312, .adv_w = 173, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19406, .adv_w = 136, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 19487, .adv_w = 173, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19575, .adv_w = 172, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19669, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19732, .adv_w = 172, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19820, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19879, .adv_w = 172, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19973, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20036, .adv_w = 71, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20074, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 20255, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20381, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20534, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20660, .adv_w = 198, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20745, .adv_w = 288, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20916, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 21087, .adv_w = 324, .box_w = 21, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21266, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 21437, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21584, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 21755, .adv_w = 144, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21823, .adv_w = 216, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21928, .adv_w = 324, .box_w = 21, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22117, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22243, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 22345, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22497, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22633, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22769, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 22871, .adv_w = 252, .box_w = 18, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 23024, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23112, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23200, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23336, .adv_w = 252, .box_w = 16, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 23368, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23515, .adv_w = 360, .box_w = 23, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23734, .adv_w = 324, .box_w = 22, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 23943, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24096, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 24176, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 24256, .adv_w = 360, .box_w = 24, .box_h = 15, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 24436, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24562, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 24733, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 24914, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25050, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25202, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25338, .adv_w = 180, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 25462, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25614, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25766, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25913, .adv_w = 288, .box_w = 20, .box_h = 20, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 26113, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26246, .adv_w = 360, .box_w = 23, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26453, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26591, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26729, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26867, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27005, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27143, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 27316, .adv_w = 252, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 27449, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 27601, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 27782, .adv_w = 360, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27943, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 28076, .adv_w = 290, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, -8, 0,
    -3, -9, 0, -11, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    3, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -24, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -31,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    -9, 0, -2, 0, 0, -18, -2, -12,
    -10, 0, -13, 0, 0, 0, 0, 0,
    0, -2, 0, 0, -2, -2, -7, -5,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -3,
    0, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -14, 0, 0,
    0, -3, 0, 0, 0, -4, 0, -3,
    0, -3, -6, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -3,
    0, -3, 0, 0, 0, -2, -4, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -33, 0, 0,
    0, -24, 0, -37, 0, 3, 0, 0,
    0, 0, 0, 0, 0, -5, -3, 0,
    0, -3, -4, 0, 0, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, -4, 0, 0,
    0, 2, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    -3, -4, 0, 0, 0, -3, -6, -9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -47, 0, 0, 0, 0, 0, 0,
    0, 3, -9, 0, 0, -39, -8, -25,
    -20, 0, -34, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, -19, -13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -46, 0, 0,
    0, -19, 0, -28, 0, 0, 0, 0,
    0, -4, 0, -4, 0, -2, -2, 0,
    0, -2, 0, 0, 2, 0, 2, 0,
    0, 0, 0, 0, 0, -14, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -4,
    -3, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -11, 0, -3,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, -31, -33, 0,
    0, -11, -4, -34, -2, 2, 0, 2,
    2, 0, 2, 0, 0, -16, -14, 0,
    -15, -14, -11, -16, 0, -13, -10, -8,
    -11, -8, 0, -46, -30, -25, -16, -13,
    0, 0, 0, 3, 0, -32, -5, 0,
    0, -11, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -6, -6, 0,
    0, -6, -4, 0, 0, -4, -2, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -17, -8, 0,
    0, -6, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 2, -5, -4, 0,
    0, -4, -3, 0, 0, -3, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -6, 0,
    0, 0, -4, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, -3, 0, 0, 0, -3, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 3, -7, -30, -7, 0,
    0, -13, -4, -13, -2, 2, -13, 3,
    2, 2, 3, 0, 3, -10, -9, -3,
    -6, -9, -6, -8, -3, -5, -3, 0,
    -3, -4, 3, -12, -7, -13, -9, -9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -3, -4, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -2, -2, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -3, -2, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, -3, 2,
    0, -3, 0, 0, 7, 0, 3, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 2,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_18 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 24,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_18*/


