#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_16
#define RB_LV_FONT_ROBOTO_16 1
#endif

#if RB_LV_FONT_ROBOTO_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xad, 0xac, 0xac, 0xac, 0xac, 0xac, 0x9b, 0x9b,
    0x56, 0x0, 0x57, 0x8c,

    /* U+22 "\"" */
    0xe2, 0xd4, 0xe2, 0xd3, 0xe0, 0xd2, 0xe0, 0xd1,
    0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x0, 0xb6, 0x8, 0x90, 0x0, 0x0, 0xe3,
    0xb, 0x60, 0x0, 0x2, 0xf0, 0xf, 0x20, 0x7,
    0xff, 0xff, 0xff, 0xfa, 0x1, 0x29, 0xa2, 0x7c,
    0x21, 0x0, 0xb, 0x60, 0x89, 0x0, 0x0, 0xe,
    0x30, 0xb6, 0x0, 0xf, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0x6d, 0x23, 0xf3, 0x20, 0x0, 0x6b, 0x3,
    0xe0, 0x0, 0x0, 0x98, 0x6, 0xb0, 0x0, 0x0,
    0xb6, 0x8, 0x90, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x0, 0x2, 0xe6, 0x0, 0x0, 0xa, 0xff,
    0xfc, 0x10, 0x6, 0xf5, 0x4, 0xfa, 0x0, 0xac,
    0x0, 0x8, 0xe0, 0x9, 0xe0, 0x0, 0x26, 0x0,
    0x2f, 0xc3, 0x0, 0x0, 0x0, 0x3c, 0xfd, 0x50,
    0x0, 0x0, 0x3, 0xaf, 0x80, 0x1, 0x0, 0x0,
    0x9f, 0x0, 0xf6, 0x0, 0x5, 0xf1, 0xc, 0xd1,
    0x1, 0xce, 0x0, 0x3e, 0xfe, 0xff, 0x40, 0x0,
    0x5, 0xf6, 0x10, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+25 "%" */
    0x5, 0xee, 0x90, 0x0, 0x0, 0x0, 0xf, 0x31,
    0xd5, 0x0, 0x70, 0x0, 0x2e, 0x0, 0x97, 0x8,
    0x90, 0x0, 0xf, 0x31, 0xd5, 0x2e, 0x10, 0x0,
    0x5, 0xde, 0x90, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x29,
    0xec, 0x20, 0x0, 0x0, 0x98, 0x6c, 0x17, 0xc0,
    0x0, 0x3, 0xe0, 0x97, 0x1, 0xf0, 0x0, 0xd,
    0x50, 0x97, 0x1, 0xf0, 0x0, 0x19, 0x0, 0x6c,
    0x7, 0xc0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x20,

    /* U+26 "&" */
    0x0, 0x3c, 0xfd, 0x40, 0x0, 0x0, 0xec, 0x4a,
    0xf1, 0x0, 0x3, 0xf3, 0x1, 0xf3, 0x0, 0x2,
    0xf5, 0x6, 0xf1, 0x0, 0x0, 0xbd, 0x8f, 0x50,
    0x0, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x2, 0xec,
    0xf8, 0x0, 0x71, 0xd, 0xc0, 0x7f, 0x42, 0xf1,
    0x2f, 0x40, 0xa, 0xf9, 0xe0, 0x1f, 0x60, 0x0,
    0xcf, 0x70, 0xa, 0xe4, 0x15, 0xef, 0xb0, 0x0,
    0x8d, 0xfd, 0x85, 0xf8,

    /* U+27 "'" */
    0x3f, 0x3f, 0x3e, 0x2c,

    /* U+28 "(" */
    0x0, 0x2, 0x0, 0x3, 0xe1, 0x1, 0xe5, 0x0,
    0x9b, 0x0, 0x1f, 0x40, 0x6, 0xf0, 0x0, 0xab,
    0x0, 0xd, 0x90, 0x0, 0xe8, 0x0, 0xe, 0x70,
    0x0, 0xe8, 0x0, 0xb, 0xa0, 0x0, 0x8d, 0x0,
    0x3, 0xf1, 0x0, 0xd, 0x70, 0x0, 0x4f, 0x10,
    0x0, 0x9c, 0x0, 0x0, 0x80,

    /* U+29 ")" */
    0x20, 0x0, 0x8, 0xa0, 0x0, 0xd, 0x70, 0x0,
    0x4f, 0x10, 0x0, 0xd8, 0x0, 0x7, 0xe0, 0x0,
    0x4f, 0x20, 0x1, 0xf5, 0x0, 0xf, 0x60, 0x0,
    0xf6, 0x0, 0x1f, 0x50, 0x3, 0xf3, 0x0, 0x6f,
    0x0, 0xa, 0xb0, 0x0, 0xf4, 0x0, 0x8c, 0x0,
    0x4e, 0x20, 0x6, 0x20, 0x0,

    /* U+2A "*" */
    0x0, 0x1f, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x9b,
    0x6f, 0x5b, 0x73, 0x8d, 0xfd, 0x83, 0x0, 0xde,
    0xa0, 0x0, 0x9c, 0x1f, 0x50, 0x7, 0x30, 0x66,
    0x0,

    /* U+2B "+" */
    0x0, 0x2, 0xa2, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x11, 0x4f,
    0x51, 0x10, 0x6f, 0xff, 0xff, 0xff, 0x61, 0x44,
    0x7f, 0x74, 0x41, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0,

    /* U+2C "," */
    0xf, 0x60, 0xf5, 0x4f, 0x28, 0x90, 0x0, 0x0,

    /* U+2D "-" */
    0x0, 0x0, 0xb, 0xff, 0xf1, 0x23, 0x33, 0x0,

    /* U+2E "." */
    0x88, 0xab,

    /* U+2F "/" */
    0x0, 0x0, 0x4e, 0x0, 0x0, 0xa, 0x90, 0x0,
    0x0, 0xf3, 0x0, 0x0, 0x6d, 0x0, 0x0, 0xc,
    0x70, 0x0, 0x2, 0xf1, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0xd, 0x60, 0x0, 0x3, 0xf0, 0x0, 0x0,
    0x9a, 0x0, 0x0, 0xe, 0x40, 0x0, 0x5, 0xe0,
    0x0, 0x0, 0xa9, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x6d, 0xfd, 0x60, 0x0, 0x5f, 0x84, 0x9f,
    0x50, 0xc, 0xb0, 0x0, 0xbc, 0x0, 0xf7, 0x0,
    0x7, 0xf0, 0x1f, 0x50, 0x0, 0x5f, 0x1, 0xf5,
    0x0, 0x5, 0xf1, 0x1f, 0x50, 0x0, 0x5f, 0x11,
    0xf6, 0x0, 0x6, 0xf0, 0xf, 0x70, 0x0, 0x7f,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x5, 0xf9, 0x48,
    0xf5, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+31 "1" */
    0x0, 0x39, 0xa5, 0xdf, 0xfb, 0x99, 0x2c, 0xb0,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0,
    0xc, 0xb0, 0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0,
    0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb,

    /* U+32 "2" */
    0x0, 0x7d, 0xfd, 0x60, 0x0, 0x9f, 0x74, 0x9f,
    0x60, 0x1f, 0x60, 0x0, 0xcc, 0x2, 0xa2, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0x2e, 0x90, 0x0, 0x0, 0x1d, 0xa0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xa, 0xf4, 0x33,
    0x33, 0x10, 0xff, 0xff, 0xff, 0xf6,

    /* U+33 "3" */
    0x0, 0x8d, 0xfd, 0x50, 0xa, 0xe6, 0x48, 0xf5,
    0xf, 0x60, 0x0, 0xca, 0x1, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0x16, 0xf4, 0x0, 0xf, 0xff, 0x70,
    0x0, 0x3, 0x49, 0xf4, 0x0, 0x0, 0x0, 0xbc,
    0x16, 0x10, 0x0, 0x8e, 0x1f, 0x60, 0x0, 0xbc,
    0xa, 0xe6, 0x48, 0xf4, 0x0, 0x8d, 0xfc, 0x50,

    /* U+34 "4" */
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x1, 0xec, 0xf0, 0x0, 0x0, 0xac,
    0x6f, 0x0, 0x0, 0x3f, 0x26, 0xf0, 0x0, 0xd,
    0x80, 0x6f, 0x0, 0x7, 0xe0, 0x6, 0xf0, 0x1,
    0xf5, 0x0, 0x6f, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xa1, 0x33, 0x33, 0x8f, 0x32, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x6f, 0x0,

    /* U+35 "5" */
    0xd, 0xff, 0xff, 0xf0, 0xf, 0xa6, 0x66, 0x60,
    0x1f, 0x40, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x4f, 0xcf, 0xfb, 0x10, 0x4f, 0x84, 0x7f, 0xb0,
    0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x2, 0xf4,
    0x43, 0x0, 0x2, 0xf4, 0x9d, 0x0, 0x6, 0xf1,
    0x2f, 0xa4, 0x6f, 0xa0, 0x3, 0xcf, 0xe9, 0x0,

    /* U+36 "6" */
    0x0, 0x3b, 0xe9, 0x0, 0x6, 0xfb, 0x62, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0xcb, 0xbf, 0xf9, 0x0, 0xef, 0xa4, 0x7f, 0x80,
    0xfb, 0x0, 0x8, 0xf0, 0xf8, 0x0, 0x4, 0xf2,
    0xd9, 0x0, 0x4, 0xf2, 0x9e, 0x0, 0x8, 0xf0,
    0x2f, 0xc5, 0x7f, 0x70, 0x3, 0xcf, 0xe8, 0x0,

    /* U+37 "7" */
    0x6f, 0xff, 0xff, 0xff, 0x41, 0x33, 0x33, 0x38,
    0xf1, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x0,
    0x3f, 0x20, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x6, 0xf1, 0x0,
    0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x6d, 0xfd, 0x60, 0x0, 0x6f, 0x84, 0x8f,
    0x60, 0xc, 0xb0, 0x0, 0xbb, 0x0, 0xca, 0x0,
    0xa, 0xc0, 0x6, 0xf4, 0x5, 0xf6, 0x0, 0x9,
    0xff, 0xf9, 0x0, 0x5, 0xf7, 0x47, 0xf5, 0x0,
    0xe9, 0x0, 0x9, 0xe0, 0x1f, 0x50, 0x0, 0x5f,
    0x10, 0xf8, 0x0, 0x8, 0xf0, 0x8, 0xf7, 0x47,
    0xf7, 0x0, 0x7, 0xdf, 0xd7, 0x0,

    /* U+39 "9" */
    0x0, 0x7e, 0xfc, 0x30, 0x7, 0xf8, 0x5c, 0xf1,
    0xe, 0x90, 0x1, 0xf8, 0x2f, 0x40, 0x0, 0xac,
    0x3f, 0x40, 0x0, 0x8e, 0xf, 0x70, 0x0, 0xae,
    0xa, 0xe4, 0x17, 0xfe, 0x1, 0xcf, 0xfc, 0xac,
    0x0, 0x2, 0x20, 0xc8, 0x0, 0x0, 0x5, 0xf2,
    0x0, 0x26, 0xaf, 0x70, 0x0, 0x9e, 0xb5, 0x0,

    /* U+3A ":" */
    0xba, 0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x97,
    0xba,

    /* U+3B ";" */
    0xe, 0x70, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa5, 0xe, 0x71, 0xf5, 0x7d,
    0x1, 0x20,

    /* U+3C "<" */
    0x0, 0x0, 0x4, 0xb0, 0x0, 0x4c, 0xfc, 0x5,
    0xcf, 0xb4, 0x6, 0xfa, 0x20, 0x0, 0x2c, 0xfa,
    0x30, 0x0, 0x4, 0xbf, 0xc5, 0x0, 0x0, 0x3b,
    0xf0, 0x0, 0x0, 0x2,

    /* U+3D "=" */
    0x1, 0x11, 0x11, 0xd, 0xff, 0xff, 0xfb, 0x34,
    0x44, 0x44, 0x20, 0x11, 0x11, 0x10, 0xdf, 0xff,
    0xff, 0xb3, 0x33, 0x33, 0x32,

    /* U+3E ">" */
    0xb4, 0x0, 0x0, 0xb, 0xfd, 0x50, 0x0, 0x2,
    0x9f, 0xe7, 0x0, 0x0, 0x7, 0xfb, 0x0, 0x39,
    0xfd, 0x55, 0xcf, 0xc5, 0x0, 0xfb, 0x40, 0x0,
    0x2, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x3, 0xbf, 0xe8, 0x1, 0xec, 0x57, 0xf8, 0x4e,
    0x10, 0xa, 0xd0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x1e, 0x80, 0x0, 0x1c, 0xd1, 0x0, 0xa, 0xe2,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0x19, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x19, 0x20, 0x0, 0x2,
    0xe4, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x29, 0xdf, 0xeb, 0x40, 0x0, 0x0,
    0x6, 0xe8, 0x31, 0x26, 0xd8, 0x0, 0x0, 0x5e,
    0x20, 0x0, 0x0, 0xc, 0x50, 0x1, 0xe4, 0x0,
    0x7d, 0xc5, 0x2, 0xe0, 0x6, 0xb0, 0x8, 0xd3,
    0x6e, 0x0, 0xc3, 0xc, 0x60, 0x1f, 0x30, 0x5d,
    0x0, 0x87, 0xe, 0x30, 0x6d, 0x0, 0x6b, 0x0,
    0x78, 0xf, 0x10, 0x9a, 0x0, 0x7a, 0x0, 0x68,
    0xf, 0x10, 0xa9, 0x0, 0x89, 0x0, 0x87, 0xf,
    0x20, 0xa9, 0x0, 0xb8, 0x0, 0xc3, 0xc, 0x60,
    0x6d, 0x15, 0xec, 0x6, 0xc0, 0x7, 0xc0, 0xb,
    0xfa, 0x1c, 0xfb, 0x20, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xa4, 0x11, 0x35,
    0x0, 0x0, 0x0, 0x1, 0x7c, 0xff, 0xc6, 0x0,
    0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0xf,
    0xf6, 0x0, 0x0, 0x0, 0x5, 0xfb, 0xc0, 0x0,
    0x0, 0x0, 0xbb, 0x4f, 0x20, 0x0, 0x0, 0x1f,
    0x60, 0xf8, 0x0, 0x0, 0x6, 0xf1, 0xa, 0xd0,
    0x0, 0x0, 0xcc, 0x0, 0x5f, 0x30, 0x0, 0x2f,
    0x70, 0x1, 0xf9, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0xdc, 0x33, 0x33, 0x6f, 0x50, 0x3f,
    0x50, 0x0, 0x0, 0xeb, 0x9, 0xe0, 0x0, 0x0,
    0x8, 0xf1,

    /* U+42 "B" */
    0xaf, 0xff, 0xfc, 0x50, 0xa, 0xe4, 0x45, 0xaf,
    0x50, 0xad, 0x0, 0x0, 0xda, 0xa, 0xd0, 0x0,
    0xd, 0xb0, 0xad, 0x0, 0x17, 0xf4, 0xa, 0xff,
    0xff, 0xf8, 0x0, 0xad, 0x33, 0x48, 0xf6, 0xa,
    0xd0, 0x0, 0xa, 0xe0, 0xad, 0x0, 0x0, 0x7f,
    0xa, 0xd0, 0x0, 0xb, 0xe0, 0xae, 0x44, 0x59,
    0xf6, 0xa, 0xff, 0xff, 0xd6, 0x0,

    /* U+43 "C" */
    0x0, 0x8, 0xdf, 0xe8, 0x0, 0x0, 0xce, 0x75,
    0x7f, 0xb0, 0x6, 0xf3, 0x0, 0x4, 0xf5, 0xc,
    0xb0, 0x0, 0x0, 0xd8, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0,
    0xd, 0xb0, 0x0, 0x0, 0xc7, 0x7, 0xf3, 0x0,
    0x4, 0xf5, 0x0, 0xce, 0x74, 0x7e, 0xb0, 0x0,
    0x9, 0xef, 0xd7, 0x0,

    /* U+44 "D" */
    0xaf, 0xff, 0xe9, 0x10, 0xa, 0xe4, 0x46, 0xde,
    0x20, 0xad, 0x0, 0x0, 0xdc, 0xa, 0xd0, 0x0,
    0x5, 0xf3, 0xad, 0x0, 0x0, 0x1f, 0x6a, 0xd0,
    0x0, 0x0, 0xf8, 0xad, 0x0, 0x0, 0xf, 0x8a,
    0xd0, 0x0, 0x1, 0xf6, 0xad, 0x0, 0x0, 0x5f,
    0x3a, 0xd0, 0x0, 0xd, 0xc0, 0xad, 0x44, 0x6d,
    0xe2, 0xa, 0xff, 0xfe, 0x91, 0x0,

    /* U+45 "E" */
    0xaf, 0xff, 0xff, 0xf7, 0xae, 0x44, 0x44, 0x42,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xc0,
    0xad, 0x33, 0x33, 0x20, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x42, 0xaf, 0xff, 0xff, 0xf8,

    /* U+46 "F" */
    0xaf, 0xff, 0xff, 0xf6, 0xae, 0x44, 0x44, 0x41,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0x90, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74,
    0x7e, 0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc,
    0xc0, 0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x6, 0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb,
    0xb, 0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0,
    0x0, 0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0,
    0x6, 0xdf, 0xec, 0x50,

    /* U+48 "H" */
    0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0,
    0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xaf, 0xff, 0xff, 0xff, 0xf1, 0xad, 0x33,
    0x33, 0x39, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1,
    0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0,
    0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1,

    /* U+49 "I" */
    0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f,
    0x9f, 0x9f, 0x9f, 0x9f,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x36, 0x0, 0x0, 0xe9, 0x6f, 0x10, 0x2, 0xf6,
    0x1e, 0xc5, 0x6d, 0xe0, 0x3, 0xbe, 0xeb, 0x20,

    /* U+4B "K" */
    0xad, 0x0, 0x0, 0x8f, 0x40, 0xad, 0x0, 0x6,
    0xf6, 0x0, 0xad, 0x0, 0x4f, 0x90, 0x0, 0xad,
    0x2, 0xfb, 0x0, 0x0, 0xad, 0x1d, 0xd0, 0x0,
    0x0, 0xad, 0xcf, 0x60, 0x0, 0x0, 0xaf, 0xfc,
    0xf2, 0x0, 0x0, 0xaf, 0x41, 0xec, 0x0, 0x0,
    0xad, 0x0, 0x4f, 0x80, 0x0, 0xad, 0x0, 0x8,
    0xf4, 0x0, 0xad, 0x0, 0x0, 0xce, 0x10, 0xad,
    0x0, 0x0, 0x2f, 0xa0,

    /* U+4C "L" */
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,

    /* U+4D "M" */
    0xaf, 0x70, 0x0, 0x0, 0x7, 0xfa, 0xaf, 0xd0,
    0x0, 0x0, 0xd, 0xfa, 0xae, 0xf3, 0x0, 0x0,
    0x3f, 0xea, 0xab, 0xd9, 0x0, 0x0, 0xac, 0xca,
    0xab, 0x7e, 0x0, 0x0, 0xf6, 0xca, 0xac, 0x1f,
    0x50, 0x6, 0xf1, 0xca, 0xac, 0xb, 0xb0, 0xc,
    0xa0, 0xda, 0xad, 0x5, 0xf1, 0x2f, 0x40, 0xda,
    0xad, 0x0, 0xe7, 0x8e, 0x0, 0xda, 0xad, 0x0,
    0x8d, 0xe8, 0x0, 0xda, 0xad, 0x0, 0x2f, 0xf2,
    0x0, 0xda, 0xad, 0x0, 0xc, 0xb0, 0x0, 0xda,

    /* U+4E "N" */
    0xaf, 0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0,
    0x6, 0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad,
    0xbe, 0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6,
    0xf1, 0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0,
    0xdd, 0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1,
    0xad, 0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1,
    0xef, 0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad,
    0x0, 0x0, 0xb, 0xf1,

    /* U+4F "O" */
    0x0, 0x7, 0xdf, 0xd7, 0x0, 0x0, 0xb, 0xf8,
    0x58, 0xfb, 0x0, 0x6, 0xf4, 0x0, 0x4, 0xf6,
    0x0, 0xcc, 0x0, 0x0, 0xc, 0xc0, 0xf, 0x80,
    0x0, 0x0, 0x8f, 0x0, 0xf7, 0x0, 0x0, 0x7,
    0xf0, 0x1f, 0x70, 0x0, 0x0, 0x7f, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xc, 0xc0, 0x0, 0x0,
    0xbc, 0x0, 0x6f, 0x40, 0x0, 0x3f, 0x60, 0x0,
    0xbf, 0x85, 0x8f, 0xc0, 0x0, 0x0, 0x7d, 0xfd,
    0x80, 0x0,

    /* U+50 "P" */
    0xaf, 0xff, 0xfd, 0x80, 0xa, 0xe5, 0x55, 0x7f,
    0xd0, 0xad, 0x0, 0x0, 0x4f, 0x5a, 0xd0, 0x0,
    0x0, 0xf7, 0xad, 0x0, 0x0, 0x2f, 0x6a, 0xd0,
    0x1, 0x3c, 0xf1, 0xaf, 0xff, 0xff, 0xd3, 0xa,
    0xd3, 0x33, 0x10, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xa, 0xd0, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x8, 0xdf, 0xd7, 0x0, 0x0, 0xc, 0xf8,
    0x58, 0xfb, 0x0, 0x7, 0xf3, 0x0, 0x5, 0xf5,
    0x0, 0xdb, 0x0, 0x0, 0xd, 0xb0, 0xf, 0x70,
    0x0, 0x0, 0x9e, 0x1, 0xf6, 0x0, 0x0, 0x8,
    0xf0, 0x2f, 0x60, 0x0, 0x0, 0x8f, 0x0, 0xf7,
    0x0, 0x0, 0x9, 0xe0, 0xd, 0xb0, 0x0, 0x0,
    0xdb, 0x0, 0x7f, 0x30, 0x0, 0x4f, 0x50, 0x0,
    0xce, 0x75, 0x8f, 0xb0, 0x0, 0x0, 0x8d, 0xfe,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x6, 0x60,

    /* U+52 "R" */
    0xbf, 0xff, 0xfc, 0x50, 0xb, 0xe4, 0x45, 0xaf,
    0x70, 0xbd, 0x0, 0x0, 0xbe, 0xb, 0xd0, 0x0,
    0x7, 0xf0, 0xbd, 0x0, 0x0, 0xaf, 0xb, 0xd0,
    0x1, 0x6f, 0x80, 0xbf, 0xff, 0xff, 0x80, 0xb,
    0xd3, 0x37, 0xf3, 0x0, 0xbd, 0x0, 0xd, 0xb0,
    0xb, 0xd0, 0x0, 0x5f, 0x40, 0xbd, 0x0, 0x0,
    0xcc, 0xb, 0xd0, 0x0, 0x4, 0xf5,

    /* U+53 "S" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f, 0x95, 0x6c,
    0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0, 0xf9, 0x0,
    0x0, 0x67, 0xa, 0xf5, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e, 0xfa, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0x39, 0x10, 0x0, 0xb,
    0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9, 0xf9, 0x55,
    0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+54 "T" */
    0x9f, 0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+55 "U" */
    0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0, 0x2,
    0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xda, 0x0, 0x0, 0x3f,
    0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f, 0xc6, 0x59,
    0xf8, 0x0, 0x3b, 0xff, 0xc6, 0x0,

    /* U+56 "V" */
    0x9f, 0x0, 0x0, 0x0, 0xdc, 0x4f, 0x50, 0x0,
    0x2, 0xf7, 0xe, 0xa0, 0x0, 0x7, 0xf1, 0x8,
    0xf0, 0x0, 0xd, 0xc0, 0x3, 0xf5, 0x0, 0x2f,
    0x60, 0x0, 0xda, 0x0, 0x7f, 0x10, 0x0, 0x7f,
    0x0, 0xcb, 0x0, 0x0, 0x2f, 0x52, 0xf5, 0x0,
    0x0, 0xc, 0xa7, 0xf0, 0x0, 0x0, 0x7, 0xfd,
    0xa0, 0x0, 0x0, 0x1, 0xff, 0x40, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x0,

    /* U+57 "W" */
    0x6f, 0x10, 0x0, 0x9f, 0x0, 0x0, 0xcb, 0x2f,
    0x40, 0x0, 0xdf, 0x30, 0x0, 0xf8, 0xe, 0x80,
    0x1, 0xfe, 0x70, 0x3, 0xf4, 0xb, 0xb0, 0x6,
    0xf8, 0xb0, 0x6, 0xf0, 0x7, 0xf0, 0xa, 0xa4,
    0xf0, 0x9, 0xd0, 0x4, 0xf2, 0xe, 0x60, 0xf4,
    0xd, 0x90, 0x0, 0xf6, 0x2f, 0x10, 0xb8, 0xf,
    0x50, 0x0, 0xc9, 0x7d, 0x0, 0x7c, 0x4f, 0x20,
    0x0, 0x9d, 0xb9, 0x0, 0x3f, 0x8e, 0x0, 0x0,
    0x5f, 0xe4, 0x0, 0xe, 0xea, 0x0, 0x0, 0x1f,
    0xf0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x6, 0xf3, 0x0,

    /* U+58 "X" */
    0x2f, 0x90, 0x0, 0x8, 0xf3, 0x8, 0xf3, 0x0,
    0x2f, 0x90, 0x0, 0xec, 0x0, 0xbe, 0x10, 0x0,
    0x5f, 0x65, 0xf6, 0x0, 0x0, 0xb, 0xee, 0xc0,
    0x0, 0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x3,
    0xff, 0x40, 0x0, 0x0, 0xc, 0xed, 0xd0, 0x0,
    0x0, 0x6f, 0x54, 0xf7, 0x0, 0x1, 0xeb, 0x0,
    0xaf, 0x20, 0xa, 0xf2, 0x0, 0x1f, 0xb0, 0x3f,
    0x80, 0x0, 0x7, 0xf4,

    /* U+59 "Y" */
    0x9f, 0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0,
    0xe, 0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1,
    0xf9, 0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2,
    0x0, 0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7,
    0xff, 0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+5A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0xb1, 0x44, 0x44, 0x48,
    0xf7, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0x2, 0xf8, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x0, 0x2f, 0xc4, 0x44,
    0x44, 0x45, 0xff, 0xff, 0xff, 0xff,

    /* U+5B "[" */
    0x0, 0x0, 0xdf, 0xf1, 0xda, 0x30, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0,
    0xdf, 0xf1, 0x23, 0x30,

    /* U+5C "\\" */
    0x8d, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0xc,
    0x90, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x9, 0xc0, 0x0,
    0x0, 0x3f, 0x20, 0x0, 0x0, 0xd8, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0x2f, 0x40,

    /* U+5D "]" */
    0x0, 0x0, 0xef, 0xf0, 0x38, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0x7, 0xf0,
    0xef, 0xf0, 0x23, 0x30,

    /* U+5E "^" */
    0x0, 0x5f, 0x0, 0x0, 0xb, 0xf6, 0x0, 0x2,
    0xfa, 0xc0, 0x0, 0x8c, 0x2f, 0x20, 0xe, 0x60,
    0xb9, 0x4, 0xf1, 0x5, 0xe0,

    /* U+5F "_" */
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf3,
    0x33, 0x33, 0x33, 0x30,

    /* U+60 "`" */
    0x28, 0x20, 0xb, 0xc0, 0x1, 0xd6,

    /* U+61 "a" */
    0x0, 0x9e, 0xfd, 0x50, 0xb, 0xe5, 0x48, 0xf2,
    0x4, 0x20, 0x0, 0xe7, 0x0, 0x7c, 0xef, 0xf8,
    0x9, 0xe5, 0x22, 0xe8, 0xf, 0x60, 0x0, 0xe8,
    0x1f, 0x60, 0x2, 0xf8, 0xc, 0xe6, 0x6e, 0xf9,
    0x2, 0xbf, 0xe6, 0xa9,

    /* U+62 "b" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe9, 0xaf, 0xe9, 0x0,
    0xef, 0x95, 0x8f, 0x80, 0xea, 0x0, 0x9, 0xe0,
    0xe8, 0x0, 0x4, 0xf2, 0xe8, 0x0, 0x3, 0xf3,
    0xe8, 0x0, 0x4, 0xf2, 0xea, 0x0, 0x9, 0xe0,
    0xef, 0x95, 0x8f, 0x70, 0xe8, 0xaf, 0xe8, 0x0,

    /* U+63 "c" */
    0x0, 0x6d, 0xfd, 0x50, 0x7, 0xf8, 0x49, 0xf4,
    0xe, 0x90, 0x0, 0xbb, 0x3f, 0x40, 0x0, 0x12,
    0x4f, 0x20, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x9a, 0x7, 0xf7, 0x48, 0xf5,
    0x0, 0x7d, 0xfd, 0x50,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x8e, 0xfa, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x40, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x2f, 0x40, 0x0, 0x9e, 0xe, 0x80, 0x0, 0x9e,
    0x7, 0xf6, 0x26, 0xfe, 0x0, 0x8e, 0xea, 0x9e,

    /* U+65 "e" */
    0x0, 0x5d, 0xfd, 0x40, 0x5, 0xf8, 0x4a, 0xf2,
    0xe, 0xa0, 0x0, 0xd9, 0x2f, 0x50, 0x0, 0x9d,
    0x4f, 0xff, 0xff, 0xfe, 0x3f, 0x63, 0x33, 0x33,
    0xf, 0x80, 0x0, 0x10, 0x6, 0xf8, 0x45, 0xd8,
    0x0, 0x6d, 0xfe, 0x80,

    /* U+66 "f" */
    0x0, 0x0, 0x0, 0x0, 0x3d, 0xf8, 0x0, 0xdd,
    0x42, 0x1, 0xf5, 0x0, 0x2, 0xf4, 0x0, 0x8f,
    0xff, 0xf1, 0x15, 0xf6, 0x20, 0x3, 0xf4, 0x0,
    0x3, 0xf4, 0x0, 0x3, 0xf4, 0x0, 0x3, 0xf4,
    0x0, 0x3, 0xf4, 0x0, 0x3, 0xf4, 0x0, 0x3,
    0xf4, 0x0,

    /* U+67 "g" */
    0x0, 0x8e, 0xfa, 0x8e, 0x7, 0xf9, 0x59, 0xfe,
    0xe, 0xa0, 0x0, 0xae, 0x2f, 0x50, 0x0, 0x9e,
    0x3f, 0x30, 0x0, 0x9e, 0x1f, 0x40, 0x0, 0x9e,
    0xe, 0x90, 0x0, 0xae, 0x7, 0xf9, 0x59, 0xfe,
    0x0, 0x8e, 0xfa, 0xad, 0x0, 0x0, 0x0, 0xcb,
    0x9, 0xc5, 0x49, 0xf4, 0x0, 0x9e, 0xfc, 0x40,

    /* U+68 "h" */
    0xe8, 0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0xe8,
    0x0, 0x0, 0xe, 0x99, 0xee, 0x90, 0xef, 0xa5,
    0x8f, 0x6e, 0xb0, 0x0, 0xca, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc,

    /* U+69 "i" */
    0xb9, 0x76, 0x0, 0xca, 0xca, 0xca, 0xca, 0xca,
    0xca, 0xca, 0xca, 0xca,

    /* U+6A "j" */
    0x0, 0xc8, 0x0, 0x85, 0x0, 0x0, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x26, 0xf6, 0x7f, 0xb0,

    /* U+6B "k" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x7f, 0x40,
    0xe8, 0x6, 0xf6, 0x0, 0xe8, 0x4f, 0x80, 0x0,
    0xeb, 0xfb, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0xed, 0x3f, 0xa0, 0x0, 0xe8, 0x6, 0xf5, 0x0,
    0xe8, 0x0, 0xae, 0x10, 0xe8, 0x0, 0x1e, 0xb0,

    /* U+6C "l" */
    0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca,
    0xca, 0xca, 0xca, 0xca,

    /* U+6D "m" */
    0xe8, 0xaf, 0xf9, 0x8, 0xee, 0xa1, 0xef, 0x85,
    0x9f, 0xdb, 0x57, 0xf9, 0xe9, 0x0, 0xd, 0xe0,
    0x0, 0x9d, 0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8e,
    0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8f, 0xe8, 0x0,
    0xb, 0xb0, 0x0, 0x8f, 0xe8, 0x0, 0xb, 0xb0,
    0x0, 0x8f, 0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8f,
    0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8f,

    /* U+6E "n" */
    0xe8, 0x9e, 0xe9, 0xe, 0xfa, 0x58, 0xf6, 0xeb,
    0x0, 0xc, 0xae, 0x80, 0x0, 0xbb, 0xe8, 0x0,
    0xb, 0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb,
    0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xc0,

    /* U+6F "o" */
    0x0, 0x5d, 0xfd, 0x70, 0x0, 0x6f, 0x94, 0x8f,
    0x80, 0xe, 0xa0, 0x0, 0x8f, 0x12, 0xf4, 0x0,
    0x2, 0xf5, 0x4f, 0x30, 0x0, 0x1f, 0x63, 0xf4,
    0x0, 0x2, 0xf4, 0xe, 0x90, 0x0, 0x8f, 0x10,
    0x6f, 0x84, 0x7f, 0x80, 0x0, 0x6d, 0xfd, 0x60,
    0x0,

    /* U+70 "p" */
    0xe8, 0xae, 0xe8, 0x0, 0xef, 0x62, 0x7f, 0x70,
    0xe9, 0x0, 0x9, 0xe0, 0xe8, 0x0, 0x4, 0xf1,
    0xe8, 0x0, 0x3, 0xf3, 0xe8, 0x0, 0x5, 0xf1,
    0xe9, 0x0, 0xa, 0xe0, 0xef, 0x74, 0x8f, 0x70,
    0xea, 0xaf, 0xe8, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x8e, 0xfa, 0x9e, 0x7, 0xf8, 0x48, 0xfe,
    0xe, 0x90, 0x0, 0xae, 0x2f, 0x40, 0x0, 0x9e,
    0x3f, 0x30, 0x0, 0x9e, 0x2f, 0x40, 0x0, 0x9e,
    0xe, 0x90, 0x0, 0xae, 0x7, 0xf8, 0x48, 0xfe,
    0x0, 0x8e, 0xea, 0xae, 0x0, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x9e,

    /* U+72 "r" */
    0x0, 0x0, 0xe, 0xac, 0xf3, 0xef, 0x85, 0x1e,
    0xa0, 0x0, 0xe8, 0x0, 0xe, 0x80, 0x0, 0xe8,
    0x0, 0xe, 0x80, 0x0, 0xe8, 0x0, 0xe, 0x80,
    0x0,

    /* U+73 "s" */
    0x0, 0x9e, 0xfb, 0x30, 0xa, 0xe5, 0x4c, 0xe1,
    0xe, 0x80, 0x1, 0xb3, 0xb, 0xe6, 0x10, 0x0,
    0x0, 0x8e, 0xfd, 0x50, 0x0, 0x0, 0x29, 0xf3,
    0x2d, 0x40, 0x0, 0xf6, 0xd, 0xd5, 0x49, 0xf2,
    0x1, 0xae, 0xfc, 0x40,

    /* U+74 "t" */
    0x6, 0xf1, 0x0, 0x6f, 0x10, 0xef, 0xff, 0xa2,
    0x7f, 0x31, 0x6, 0xf1, 0x0, 0x6f, 0x10, 0x6,
    0xf1, 0x0, 0x6f, 0x10, 0x6, 0xf1, 0x0, 0x4f,
    0x73, 0x0, 0xaf, 0x90,

    /* U+75 "u" */
    0xf8, 0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8,
    0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbe, 0x80, 0x0, 0xbb, 0xda, 0x0, 0xd,
    0xb9, 0xf6, 0x5a, 0xfb, 0x1a, 0xfe, 0x9b, 0xb0,

    /* U+76 "v" */
    0x9e, 0x0, 0x2, 0xf4, 0x3f, 0x30, 0x7, 0xe0,
    0xe, 0x80, 0xc, 0x90, 0x8, 0xd0, 0x1f, 0x40,
    0x3, 0xf2, 0x6e, 0x0, 0x0, 0xd7, 0xb9, 0x0,
    0x0, 0x8d, 0xf4, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0xd, 0x90, 0x0,

    /* U+77 "w" */
    0x8e, 0x0, 0xb, 0xb0, 0x0, 0xe8, 0x4f, 0x20,
    0xf, 0xf0, 0x2, 0xf3, 0xf, 0x60, 0x5d, 0xe5,
    0x6, 0xf0, 0xb, 0xa0, 0x99, 0xa9, 0xa, 0xb0,
    0x6, 0xe0, 0xe4, 0x5e, 0xe, 0x60, 0x2, 0xf5,
    0xf0, 0xf, 0x5f, 0x20, 0x0, 0xed, 0xb0, 0xb,
    0xdd, 0x0, 0x0, 0x9f, 0x60, 0x6, 0xf9, 0x0,
    0x0, 0x5f, 0x10, 0x2, 0xf5, 0x0,

    /* U+78 "x" */
    0x4f, 0x50, 0x7, 0xf3, 0xa, 0xe0, 0x1f, 0x90,
    0x1, 0xf8, 0xae, 0x0, 0x0, 0x6f, 0xf5, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x7f, 0xf6, 0x0,
    0x2, 0xf7, 0x8e, 0x10, 0xb, 0xd0, 0xe, 0xa0,
    0x5f, 0x40, 0x6, 0xf4,

    /* U+79 "y" */
    0xae, 0x0, 0x5, 0xf3, 0x4f, 0x30, 0x9, 0xd0,
    0xe, 0x80, 0xe, 0x80, 0x9, 0xd0, 0x3f, 0x20,
    0x3, 0xf2, 0x8d, 0x0, 0x0, 0xd8, 0xc7, 0x0,
    0x0, 0x8e, 0xf2, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x3f, 0x10, 0x0,
    0x16, 0xda, 0x0, 0x0, 0x5f, 0xb1, 0x0, 0x0,

    /* U+7A "z" */
    0x3f, 0xff, 0xff, 0xf2, 0x4, 0x44, 0x4e, 0xd0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x3, 0xf7, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0xae, 0x10, 0x0,
    0x5, 0xf5, 0x0, 0x0, 0x1e, 0xc3, 0x33, 0x31,
    0x5f, 0xff, 0xff, 0xf6,

    /* U+7B "{" */
    0x0, 0x0, 0x30, 0x0, 0xa, 0xe1, 0x0, 0x6f,
    0x10, 0x0, 0xbb, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0xe8, 0x0, 0x6, 0xf4, 0x0,
    0x8f, 0xa0, 0x0, 0x18, 0xf3, 0x0, 0x0, 0xe8,
    0x0, 0x0, 0xd9, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0xca, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x1c, 0xc1,
    0x0, 0x0, 0x60,

    /* U+7C "|" */
    0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8,
    0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8,

    /* U+7D "}" */
    0x30, 0x0, 0x9, 0xe2, 0x0, 0xa, 0xd0, 0x0,
    0x4f, 0x10, 0x3, 0xf3, 0x0, 0x3f, 0x30, 0x2,
    0xf4, 0x0, 0xd, 0xb1, 0x0, 0x3f, 0xe0, 0xc,
    0xd3, 0x2, 0xf5, 0x0, 0x3f, 0x30, 0x3, 0xf3,
    0x0, 0x4f, 0x20, 0x9, 0xe0, 0x7, 0xf4, 0x0,
    0x52, 0x0, 0x0,

    /* U+7E "~" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xd3, 0x0,
    0x6c, 0xac, 0x4a, 0xf6, 0x2d, 0x8e, 0x50, 0x8,
    0xff, 0xc1, 0x0, 0x0, 0x1, 0x30, 0x0,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0xb9, 0x76, 0x0, 0x55, 0xaa, 0xba, 0xba, 0xbb,
    0xbb, 0xbb, 0xcb, 0xcb,

    /* U+A2 "¢" */
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x0, 0x8f, 0xff, 0xa0, 0x7, 0xf5, 0x4, 0xf8,
    0xe, 0x90, 0x0, 0x8d, 0x1f, 0x50, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xd, 0x90, 0x0, 0x7b, 0x6, 0xf6, 0x15, 0xf7,
    0x0, 0x7f, 0xff, 0x80, 0x0, 0x3, 0xf4, 0x0,
    0x0, 0x3, 0xf3, 0x0,

    /* U+A3 "£" */
    0x0, 0x7, 0xef, 0xc4, 0x0, 0x7, 0xf8, 0x5c,
    0xf2, 0x0, 0xea, 0x0, 0x1f, 0x70, 0x1f, 0x70,
    0x0, 0x42, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x0, 0x1,
    0x3f, 0xa3, 0x30, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x17, 0xf7, 0x44,
    0x44, 0x34, 0xff, 0xff, 0xff, 0xfd,

    /* U+A4 "¤" */
    0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0xda, 0x6e,
    0xff, 0xb5, 0xf6, 0x7, 0xff, 0x95, 0x6d, 0xfe,
    0x10, 0x4f, 0x50, 0x0, 0xc, 0xc0, 0xa, 0xb0,
    0x0, 0x0, 0x4f, 0x20, 0xd7, 0x0, 0x0, 0x0,
    0xf5, 0xd, 0x80, 0x0, 0x0, 0xf, 0x50, 0xac,
    0x0, 0x0, 0x4, 0xf2, 0x4, 0xf6, 0x0, 0x1,
    0xdc, 0x0, 0xbf, 0xfb, 0x68, 0xef, 0xf4, 0xa,
    0x55, 0xcf, 0xe9, 0x2c, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+A5 "¥" */
    0xaf, 0x10, 0x0, 0x9f, 0x12, 0xf7, 0x0, 0x1f,
    0x90, 0xb, 0xe0, 0x7, 0xf1, 0x0, 0x3f, 0x50,
    0xea, 0x0, 0x0, 0xcc, 0x6f, 0x20, 0x0, 0x4,
    0xfe, 0xb0, 0x0, 0xe, 0xef, 0xff, 0xe6, 0x0,
    0x11, 0x9e, 0x11, 0x0, 0xe, 0xef, 0xfe, 0xe6,
    0x0, 0x11, 0x9e, 0x11, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,

    /* U+A6 "¦" */
    0xd9, 0xd9, 0xd9, 0xd9, 0xd9, 0xd9, 0x21, 0x64,
    0xd9, 0xd9, 0xd9, 0xd9, 0xd9, 0xd9,

    /* U+A7 "§" */
    0x0, 0x5c, 0xfe, 0xb3, 0x0, 0x6f, 0x94, 0x5c,
    0xf3, 0xd, 0xb0, 0x0, 0xe, 0xa0, 0xdb, 0x0,
    0x0, 0x66, 0x7, 0xf8, 0x20, 0x0, 0x0, 0x3f,
    0xff, 0xd7, 0x0, 0xe, 0xa1, 0x6b, 0xfe, 0x23,
    0xf3, 0x0, 0x2, 0xeb, 0x1f, 0x80, 0x0, 0x8,
    0xe0, 0x9f, 0xc6, 0x10, 0xcc, 0x0, 0x5c, 0xff,
    0xed, 0x20, 0x0, 0x2, 0x8e, 0xe1, 0x15, 0x0,
    0x0, 0x2f, 0x83, 0xf5, 0x0, 0x0, 0xe8, 0xd,
    0xe4, 0x12, 0x9f, 0x40, 0x1a, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x22, 0x0, 0x0,

    /* U+A8 "¨" */
    0x9, 0x20, 0x66, 0x1e, 0x50, 0xaa,

    /* U+A9 "©" */
    0x0, 0x2, 0xae, 0xfc, 0x60, 0x0, 0x0, 0x6d,
    0x61, 0x3, 0xac, 0x10, 0x3, 0xd1, 0x4c, 0xd9,
    0x7, 0xb0, 0xc, 0x42, 0xf5, 0x2c, 0x80, 0xb4,
    0x1d, 0x7, 0xa0, 0x3, 0x60, 0x59, 0x3a, 0x8,
    0x90, 0x0, 0x0, 0x2b, 0x3a, 0x7, 0xa0, 0x2,
    0x40, 0x2b, 0x1d, 0x3, 0xe2, 0xa, 0x90, 0x59,
    0xb, 0x40, 0x7f, 0xfc, 0x10, 0xb4, 0x3, 0xd1,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x5e, 0x61, 0x3,
    0xac, 0x10, 0x0, 0x2, 0xae, 0xfc, 0x60, 0x0,

    /* U+AA "ª" */
    0x2c, 0xfd, 0x30, 0x67, 0x29, 0xc0, 0x2b, 0xde,
    0xe0, 0xba, 0x5, 0xe0, 0xca, 0x2a, 0xe0, 0x4e,
    0xea, 0xf0,

    /* U+AB "«" */
    0x0, 0x7, 0x3, 0x50, 0x9, 0x91, 0xe2, 0x5,
    0xe1, 0xc8, 0x1, 0xf6, 0x7e, 0x0, 0xb, 0xa2,
    0xf3, 0x0, 0x1e, 0x46, 0xd0, 0x0, 0x4d, 0xa,
    0x70,

    /* U+AC "¬" */
    0x11, 0x11, 0x11, 0xf, 0xff, 0xff, 0xf7, 0x44,
    0x44, 0x4f, 0x70, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x3, 0x10,

    /* U+AD "­" */
    0x0, 0x0, 0xb, 0xff, 0xf1, 0x23, 0x33, 0x0,

    /* U+AE "®" */
    0x0, 0x3, 0xae, 0xfc, 0x60, 0x0, 0x0, 0x6d,
    0x61, 0x3, 0xac, 0x10, 0x3, 0xd1, 0xee, 0xea,
    0x17, 0xb0, 0xc, 0x30, 0xf3, 0x2a, 0x80, 0xb4,
    0x1d, 0x0, 0xf1, 0x9, 0x80, 0x59, 0x3a, 0x0,
    0xff, 0xfe, 0x0, 0x2b, 0x3a, 0x0, 0xf3, 0x2c,
    0x60, 0x2b, 0x1d, 0x0, 0xf1, 0x7, 0xa0, 0x59,
    0xc, 0x40, 0xf1, 0x7, 0xb0, 0xb4, 0x3, 0xd1,
    0x10, 0x0, 0x17, 0xb0, 0x0, 0x6d, 0x61, 0x3,
    0xac, 0x10, 0x0, 0x2, 0xae, 0xfc, 0x60, 0x0,

    /* U+AF "¯" */
    0xef, 0xff, 0xf5, 0x22, 0x22, 0x20,

    /* U+B0 "°" */
    0x3c, 0xc3, 0xd5, 0x5d, 0xe2, 0x2e, 0x5f, 0xf5,
    0x0, 0x0,

    /* U+B1 "±" */
    0x0, 0x3, 0xf1, 0x0, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0x3, 0xf1, 0x0, 0x3f, 0xff, 0xff, 0xfe,
    0x3, 0x36, 0xf4, 0x32, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0x3, 0xf1, 0x0, 0x0, 0x3, 0xf1, 0x0,
    0x3, 0x33, 0x33, 0x32, 0xf, 0xff, 0xff, 0xf9,

    /* U+B2 "²" */
    0x9, 0xfe, 0x60, 0x5e, 0x15, 0xf0, 0x0, 0x8,
    0xd0, 0x0, 0x7e, 0x20, 0x9, 0xc1, 0x0, 0x5f,
    0xff, 0xf5,

    /* U+B3 "³" */
    0x1b, 0xfe, 0x80, 0x26, 0x15, 0xf0, 0x0, 0xdf,
    0x70, 0x0, 0x3, 0xf1, 0x6d, 0x13, 0xf1, 0xa,
    0xfe, 0x60,

    /* U+B4 "´" */
    0x0, 0x57, 0x0, 0x2f, 0x60, 0xb, 0x80, 0x0,

    /* U+B5 "µ" */
    0xca, 0x0, 0x9, 0xdc, 0xa0, 0x0, 0x9d, 0xca,
    0x0, 0x9, 0xdc, 0xa0, 0x0, 0x9d, 0xca, 0x0,
    0x9, 0xdc, 0xa0, 0x0, 0x9d, 0xcc, 0x0, 0x9,
    0xdc, 0xf5, 0x15, 0xfd, 0xce, 0xdf, 0xb9, 0xdc,
    0xa0, 0x0, 0x0, 0xca, 0x0, 0x0, 0xc, 0xa0,
    0x0, 0x0,

    /* U+B6 "¶" */
    0x0, 0x9e, 0xff, 0x80, 0xcf, 0xff, 0xf8, 0x4f,
    0xff, 0xff, 0x87, 0xff, 0xff, 0xf8, 0x6f, 0xff,
    0xff, 0x82, 0xff, 0xff, 0xf8, 0x7, 0xff, 0xff,
    0x80, 0x3, 0x8a, 0xf8, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0xf8,

    /* U+B7 "·" */
    0x79, 0xab,

    /* U+B8 "¸" */
    0x7, 0x20, 0x9, 0xf2, 0x0, 0xe4, 0xd, 0x80,

    /* U+B9 "¹" */
    0x0, 0x0, 0x6, 0xcd, 0x9, 0x9e, 0x0, 0x5e,
    0x0, 0x5e, 0x0, 0x5e, 0x0, 0x5e,

    /* U+BA "º" */
    0x2, 0xbf, 0xd4, 0x0, 0xcb, 0x27, 0xf1, 0xf,
    0x40, 0xf, 0x40, 0xf4, 0x0, 0xf4, 0xc, 0xb2,
    0x7f, 0x10, 0x2b, 0xfd, 0x40,

    /* U+BB "»" */
    0x7, 0x2, 0x60, 0x0, 0x9a, 0xd, 0x50, 0x0,
    0xe5, 0x3f, 0x20, 0x6, 0xf1, 0xac, 0x0, 0xab,
    0xe, 0x70, 0x4e, 0x18, 0xb0, 0xd, 0x42, 0xe1,
    0x0,

    /* U+BC "¼" */
    0x3, 0x87, 0x0, 0x0, 0x0, 0x0, 0x5e, 0xe9,
    0x0, 0x1, 0x80, 0x0, 0x0, 0xa9, 0x0, 0x9,
    0x80, 0x0, 0x0, 0xa9, 0x0, 0x4d, 0x0, 0x0,
    0x0, 0xa9, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xa9,
    0x8, 0xa0, 0x6, 0x20, 0x0, 0x44, 0x2e, 0x10,
    0xbf, 0x40, 0x0, 0x0, 0xc6, 0x7, 0xae, 0x40,
    0x0, 0x6, 0xb0, 0x4c, 0xe, 0x40, 0x0, 0x1e,
    0x20, 0xdf, 0xff, 0xf2, 0x0, 0x4, 0x0, 0x12,
    0x2e, 0x60, 0x0, 0x0, 0x0, 0x0, 0xe, 0x40,

    /* U+BD "½" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2a, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x47, 0xc8, 0x0, 0x9,
    0x70, 0x0, 0x0, 0xb8, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0xb8, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xb8,
    0x7, 0xa0, 0x0, 0x0, 0x0, 0xb8, 0x2e, 0x16,
    0xde, 0x90, 0x0, 0x11, 0xb6, 0x1f, 0x54, 0xf4,
    0x0, 0x5, 0xc0, 0x0, 0x3, 0xf2, 0x0, 0xe,
    0x30, 0x0, 0x3e, 0x50, 0x0, 0x78, 0x0, 0x5,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x1, 0x11, 0x11,

    /* U+BE "¾" */
    0x4, 0xce, 0x90, 0x0, 0x0, 0x0, 0xe, 0x73,
    0xe6, 0x0, 0x7, 0x0, 0x0, 0x1, 0xe5, 0x0,
    0x99, 0x0, 0x0, 0x8f, 0xc0, 0x3, 0xe0, 0x0,
    0x0, 0x0, 0xc7, 0xd, 0x50, 0x0, 0xe, 0x40,
    0xc8, 0x7a, 0x0, 0x0, 0x7, 0xff, 0xc3, 0xe1,
    0x9, 0xf0, 0x0, 0x1, 0xc, 0x60, 0x8d, 0xf0,
    0x0, 0x0, 0x6b, 0x7, 0xa3, 0xf0, 0x0, 0x1,
    0xe2, 0x2f, 0xff, 0xfc, 0x0, 0x0, 0x40, 0x2,
    0x24, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf0,

    /* U+BF "¿" */
    0x0, 0xd, 0x70, 0x0, 0x0, 0x84, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x85, 0x0, 0x0, 0x1f,
    0x70, 0x0, 0xa, 0xe1, 0x0, 0x8, 0xf4, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x6,
    0xf1, 0x0, 0x9d, 0x1f, 0xc5, 0x8f, 0x80, 0x4c,
    0xfe, 0x80,

    /* U+C0 "À" */
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x27, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+C1 "Á" */
    0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x36, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+C2 "Â" */
    0x0, 0x0, 0xae, 0x30, 0x0, 0x0, 0x0, 0xa9,
    0x2d, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+C3 "Ã" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x42, 0xf0, 0x0, 0x0, 0x6b, 0x4d, 0xf8, 0x0,
    0x0, 0x1, 0x10, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x10, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0,
    0x0, 0x0, 0x5, 0xfb, 0xc0, 0x0, 0x0, 0x0,
    0xbb, 0x4f, 0x20, 0x0, 0x0, 0x1f, 0x60, 0xf8,
    0x0, 0x0, 0x6, 0xf1, 0xa, 0xd0, 0x0, 0x0,
    0xcc, 0x0, 0x5f, 0x30, 0x0, 0x2f, 0x70, 0x1,
    0xf9, 0x0, 0x8, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0xdc, 0x33, 0x33, 0x6f, 0x50, 0x3f, 0x50, 0x0,
    0x0, 0xeb, 0x9, 0xe0, 0x0, 0x0, 0x8, 0xf1,

    /* U+C4 "Ä" */
    0x0, 0x19, 0x20, 0x76, 0x0, 0x0, 0x2, 0xe4,
    0xb, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+C5 "Å" */
    0x0, 0x0, 0x9b, 0x30, 0x0, 0x0, 0x0, 0x58,
    0xc, 0x0, 0x0, 0x0, 0x5, 0x70, 0xc0, 0x0,
    0x0, 0x0, 0x9, 0xb4, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x10, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0,
    0x0, 0x0, 0x5, 0xfb, 0xc0, 0x0, 0x0, 0x0,
    0xbb, 0x4f, 0x20, 0x0, 0x0, 0x1f, 0x60, 0xf8,
    0x0, 0x0, 0x6, 0xf1, 0xa, 0xd0, 0x0, 0x0,
    0xcc, 0x0, 0x5f, 0x30, 0x0, 0x2f, 0x70, 0x1,
    0xf9, 0x0, 0x8, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0xdc, 0x33, 0x33, 0x6f, 0x50, 0x3f, 0x50, 0x0,
    0x0, 0xeb, 0x9, 0xe0, 0x0, 0x0, 0x8, 0xf1,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x2f, 0xfd, 0x33, 0x33, 0x30,
    0x0, 0x0, 0x0, 0xad, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf5, 0x8e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x8e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x40, 0x7f, 0xff, 0xff, 0x90,
    0x0, 0x0, 0xec, 0x0, 0x7f, 0x33, 0x33, 0x10,
    0x0, 0x8, 0xf5, 0x11, 0x7f, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0xaf, 0x54, 0x44, 0x8f, 0x10, 0x0, 0x0,
    0x4, 0xf8, 0x0, 0x0, 0x4f, 0x53, 0x33, 0x32,
    0xd, 0xe0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xfb,

    /* U+C7 "Ç" */
    0x0, 0x8, 0xdf, 0xe8, 0x0, 0x0, 0xce, 0x75,
    0x7f, 0xb0, 0x6, 0xf3, 0x0, 0x4, 0xf5, 0xc,
    0xb0, 0x0, 0x0, 0xd8, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0,
    0xd, 0xb0, 0x0, 0x0, 0xc7, 0x7, 0xf3, 0x0,
    0x4, 0xf5, 0x0, 0xce, 0x74, 0x7e, 0xb0, 0x0,
    0x9, 0xef, 0xd7, 0x0, 0x0, 0x0, 0x4e, 0x60,
    0x0, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x5d, 0x60, 0x0,

    /* U+C8 "È" */
    0x2, 0xe8, 0x0, 0x0, 0x0, 0x2e, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+C9 "É" */
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+CA "Ê" */
    0x0, 0x2e, 0xb0, 0x0, 0x2, 0xd3, 0x7b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+CB "Ë" */
    0x4, 0x80, 0x1a, 0x10, 0x7, 0xd0, 0x2e, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+CC "Ì" */
    0xb, 0xd0, 0x0, 0xb, 0xa0, 0x0, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0,
    0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0, 0x9,
    0xf0, 0x0, 0x9f, 0x0, 0x9, 0xf0, 0x0, 0x9f,
    0x0, 0x9, 0xf0, 0x0, 0x9f, 0x0,

    /* U+CD "Í" */
    0x7, 0xe3, 0x4e, 0x20, 0x0, 0x0, 0x9f, 0x0,
    0x9f, 0x0, 0x9f, 0x0, 0x9f, 0x0, 0x9f, 0x0,
    0x9f, 0x0, 0x9f, 0x0, 0x9f, 0x0, 0x9f, 0x0,
    0x9f, 0x0, 0x9f, 0x0, 0x9f, 0x0,

    /* U+CE "Î" */
    0x0, 0xbe, 0x20, 0xb, 0x83, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+CF "Ï" */
    0x19, 0x10, 0x85, 0x3e, 0x30, 0xc8, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+D0 "Ð" */
    0x7, 0xff, 0xfe, 0xa3, 0x0, 0x7, 0xf5, 0x46,
    0xbf, 0x50, 0x7, 0xf1, 0x0, 0xa, 0xe1, 0x7,
    0xf1, 0x0, 0x1, 0xf6, 0x7, 0xf1, 0x0, 0x0,
    0xda, 0xff, 0xff, 0xf0, 0x0, 0xbc, 0x38, 0xf4,
    0x30, 0x0, 0xbc, 0x7, 0xf1, 0x0, 0x0, 0xda,
    0x7, 0xf1, 0x0, 0x1, 0xf7, 0x7, 0xf1, 0x0,
    0xa, 0xf1, 0x7, 0xf4, 0x45, 0xbf, 0x50, 0x7,
    0xff, 0xfe, 0xa3, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x90,
    0xb6, 0x0, 0x0, 0xf4, 0x8f, 0xd1, 0x0, 0x0,
    0x20, 0x1, 0x0, 0x0, 0xaf, 0x20, 0x0, 0x6,
    0xf1, 0xaf, 0xc0, 0x0, 0x6, 0xf1, 0xaf, 0xf6,
    0x0, 0x6, 0xf1, 0xad, 0xbe, 0x10, 0x6, 0xf1,
    0xad, 0x2f, 0x90, 0x6, 0xf1, 0xad, 0x7, 0xf3,
    0x6, 0xf1, 0xad, 0x0, 0xdd, 0x6, 0xf1, 0xad,
    0x0, 0x3f, 0x76, 0xf1, 0xad, 0x0, 0x9, 0xf8,
    0xf1, 0xad, 0x0, 0x1, 0xef, 0xf1, 0xad, 0x0,
    0x0, 0x5f, 0xf1, 0xad, 0x0, 0x0, 0xb, 0xf1,

    /* U+D2 "Ò" */
    0x0, 0x5, 0x70, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xd7, 0x0, 0x0, 0xb, 0xf8, 0x58, 0xfb,
    0x0, 0x6, 0xf4, 0x0, 0x4, 0xf6, 0x0, 0xcc,
    0x0, 0x0, 0xc, 0xc0, 0xf, 0x80, 0x0, 0x0,
    0x8f, 0x0, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0x1f,
    0x70, 0x0, 0x0, 0x7f, 0x0, 0xf8, 0x0, 0x0,
    0x8, 0xf0, 0xc, 0xc0, 0x0, 0x0, 0xbc, 0x0,
    0x6f, 0x40, 0x0, 0x3f, 0x60, 0x0, 0xbf, 0x85,
    0x8f, 0xc0, 0x0, 0x0, 0x7d, 0xfd, 0x80, 0x0,

    /* U+D3 "Ó" */
    0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x30, 0x0, 0x0, 0x0, 0x1e, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xd7, 0x0, 0x0, 0xb, 0xf8, 0x58, 0xfb,
    0x0, 0x6, 0xf4, 0x0, 0x4, 0xf6, 0x0, 0xcc,
    0x0, 0x0, 0xc, 0xc0, 0xf, 0x80, 0x0, 0x0,
    0x8f, 0x0, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0x1f,
    0x70, 0x0, 0x0, 0x7f, 0x0, 0xf8, 0x0, 0x0,
    0x8, 0xf0, 0xc, 0xc0, 0x0, 0x0, 0xbc, 0x0,
    0x6f, 0x40, 0x0, 0x3f, 0x60, 0x0, 0xbf, 0x85,
    0x8f, 0xc0, 0x0, 0x0, 0x7d, 0xfd, 0x80, 0x0,

    /* U+D4 "Ô" */
    0x0, 0x0, 0x17, 0x10, 0x0, 0x0, 0x0, 0xb,
    0xdb, 0x0, 0x0, 0x0, 0x8, 0xb0, 0xb8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xd7, 0x0, 0x0, 0xb, 0xf8, 0x58, 0xfb,
    0x0, 0x6, 0xf4, 0x0, 0x4, 0xf6, 0x0, 0xcc,
    0x0, 0x0, 0xc, 0xc0, 0xf, 0x80, 0x0, 0x0,
    0x8f, 0x0, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0x1f,
    0x70, 0x0, 0x0, 0x7f, 0x0, 0xf8, 0x0, 0x0,
    0x8, 0xf0, 0xc, 0xc0, 0x0, 0x0, 0xbc, 0x0,
    0x6f, 0x40, 0x0, 0x3f, 0x60, 0x0, 0xbf, 0x85,
    0x8f, 0xc0, 0x0, 0x0, 0x7d, 0xfd, 0x80, 0x0,

    /* U+D5 "Õ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e,
    0x70, 0xd3, 0x0, 0x0, 0x2e, 0x3a, 0xfc, 0x0,
    0x0, 0x0, 0x10, 0x1, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xd7, 0x0, 0x0, 0xb, 0xf8, 0x58, 0xfb,
    0x0, 0x6, 0xf4, 0x0, 0x4, 0xf6, 0x0, 0xcc,
    0x0, 0x0, 0xc, 0xc0, 0xf, 0x80, 0x0, 0x0,
    0x8f, 0x0, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0x1f,
    0x70, 0x0, 0x0, 0x7f, 0x0, 0xf8, 0x0, 0x0,
    0x8, 0xf0, 0xc, 0xc0, 0x0, 0x0, 0xbc, 0x0,
    0x6f, 0x40, 0x0, 0x3f, 0x60, 0x0, 0xbf, 0x85,
    0x8f, 0xc0, 0x0, 0x0, 0x7d, 0xfd, 0x80, 0x0,

    /* U+D6 "Ö" */
    0x0, 0x8, 0x50, 0x49, 0x0, 0x0, 0x0, 0xc8,
    0x7, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+D7 "×" */
    0x0, 0x0, 0x0, 0x0, 0x1d, 0x40, 0x0, 0xc6,
    0xa, 0xf3, 0xc, 0xe2, 0x0, 0xbf, 0xcf, 0x30,
    0x0, 0xe, 0xf6, 0x0, 0x0, 0x9f, 0xde, 0x20,
    0x8, 0xf5, 0x1d, 0xd1, 0x1e, 0x60, 0x1, 0xd7,
    0x1, 0x0, 0x0, 0x10,

    /* U+D8 "Ø" */
    0x0, 0x7, 0xdf, 0xd8, 0x4d, 0x0, 0xb, 0xf8,
    0x69, 0xff, 0x30, 0x6, 0xf4, 0x0, 0x9, 0xf6,
    0x0, 0xcc, 0x0, 0x3, 0xdc, 0xc0, 0xf, 0x80,
    0x0, 0xc4, 0x8f, 0x0, 0xf7, 0x0, 0x6b, 0x7,
    0xf1, 0xf, 0x70, 0x1e, 0x10, 0x7f, 0x0, 0xf8,
    0x9, 0x70, 0x8, 0xf0, 0xc, 0xc3, 0xd0, 0x0,
    0xbc, 0x0, 0x6f, 0xe4, 0x0, 0x3f, 0x60, 0x0,
    0xcf, 0x85, 0x8f, 0xc0, 0x0, 0x2e, 0x8d, 0xfd,
    0x80, 0x0, 0x4, 0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+DA "Ú" */
    0x0, 0x0, 0x7e, 0x30, 0x0, 0x0, 0x3e, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+DB "Û" */
    0x0, 0xb, 0xe3, 0x0, 0x0, 0xb, 0x82, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+DC "Ü" */
    0x1, 0x92, 0x8, 0x50, 0x0, 0x2e, 0x30, 0xb9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+DD "Ý" */
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x5e,
    0x10, 0x0, 0x0, 0x0, 0x63, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0, 0xe,
    0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1, 0xf9,
    0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0,
    0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+DE "Þ" */
    0xbc, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0,
    0xbc, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xfc, 0x40,
    0xbc, 0x33, 0x4b, 0xf4, 0xbc, 0x0, 0x0, 0xda,
    0xbc, 0x0, 0x0, 0xca, 0xbc, 0x0, 0x17, 0xf5,
    0xbf, 0xff, 0xfe, 0x70, 0xbc, 0x33, 0x20, 0x0,
    0xbc, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0,

    /* U+DF "ß" */
    0x8, 0xef, 0xb2, 0x0, 0x7f, 0x74, 0xcd, 0x0,
    0xca, 0x0, 0x5f, 0x10, 0xe8, 0x0, 0x7e, 0x0,
    0xe8, 0x0, 0xe8, 0x0, 0xe8, 0x4, 0xf2, 0x0,
    0xe8, 0x2, 0xf8, 0x0, 0xe8, 0x0, 0x6f, 0xa0,
    0xe8, 0x0, 0x4, 0xf8, 0xe8, 0x0, 0x0, 0xac,
    0xe8, 0x25, 0x13, 0xe9, 0xe8, 0x4d, 0xfe, 0x90,

    /* U+E0 "à" */
    0x0, 0x6f, 0x30, 0x0, 0x0, 0x6, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+E1 "á" */
    0x0, 0x0, 0x2f, 0x70, 0x0, 0x0, 0xd7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+E2 "â" */
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x6b, 0x1a, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+E3 "ã" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0xcf, 0xff, 0xe2,
    0x0, 0x22, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0xfd, 0x50, 0xb, 0xe5, 0x48, 0xf2,
    0x4, 0x20, 0x0, 0xe7, 0x0, 0x7c, 0xef, 0xf8,
    0x9, 0xe5, 0x22, 0xe8, 0xf, 0x60, 0x0, 0xe8,
    0x1f, 0x60, 0x2, 0xf8, 0xc, 0xe6, 0x6e, 0xf9,
    0x2, 0xbf, 0xe6, 0xa9,

    /* U+E4 "ä" */
    0x0, 0xc8, 0x6, 0xd0, 0x0, 0x85, 0x4, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+E5 "å" */
    0x0, 0x6, 0xb7, 0x0, 0x0, 0xc, 0xb, 0x10,
    0x0, 0xc, 0xa, 0x10, 0x0, 0x6, 0xb7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+E6 "æ" */
    0x1, 0x9e, 0xfb, 0x24, 0xdf, 0xd6, 0x0, 0xce,
    0x64, 0xde, 0xfa, 0x48, 0xf4, 0x1d, 0x50, 0x4,
    0xfc, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x2f, 0x70,
    0x0, 0x8e, 0x3, 0xbe, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0xfb, 0x32, 0x4f, 0x72, 0x22, 0x22, 0x5f,
    0x10, 0x2, 0xfa, 0x0, 0x0, 0x2, 0xf9, 0x46,
    0xdd, 0xf9, 0x44, 0x98, 0x6, 0xdf, 0xd8, 0x4,
    0xcf, 0xeb, 0x30,

    /* U+E7 "ç" */
    0x0, 0x6d, 0xfd, 0x50, 0x7, 0xf8, 0x49, 0xf4,
    0xe, 0x90, 0x0, 0xbb, 0x3f, 0x40, 0x0, 0x12,
    0x4f, 0x20, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x9a, 0x7, 0xf7, 0x48, 0xf5,
    0x0, 0x7e, 0xfd, 0x50, 0x0, 0x6, 0xd4, 0x0,
    0x0, 0x0, 0x6c, 0x0, 0x0, 0x7, 0xd4, 0x0,

    /* U+E8 "è" */
    0x0, 0x8f, 0x20, 0x0, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+E9 "é" */
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x1, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+EA "ê" */
    0x0, 0x8, 0xf5, 0x0, 0x0, 0x8a, 0x1b, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+EB "ë" */
    0x0, 0xd6, 0x8, 0xc0, 0x0, 0x94, 0x5, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+EC "ì" */
    0x1d, 0xa0, 0x1, 0xc6, 0x0, 0x0, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca,

    /* U+ED "í" */
    0xb, 0xc1, 0x6b, 0x0, 0x0, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,

    /* U+EE "î" */
    0x2, 0xdc, 0x10, 0x1b, 0x44, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+EF "ï" */
    0x5e, 0x1, 0xe5, 0x39, 0x0, 0x93, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+F0 "ð" */
    0x0, 0xa9, 0x20, 0x11, 0x0, 0x8, 0xef, 0x8e,
    0x60, 0x0, 0x1, 0xdf, 0xa0, 0x0, 0x0, 0xca,
    0x9f, 0x40, 0x0, 0x2, 0x0, 0xdb, 0x0, 0x5,
    0xdf, 0xca, 0xf1, 0x4, 0xfa, 0x45, 0xcf, 0x40,
    0xcc, 0x0, 0x2, 0xf5, 0xf, 0x80, 0x0, 0x1f,
    0x50, 0xf8, 0x0, 0x3, 0xf4, 0xc, 0xc0, 0x0,
    0x8f, 0x0, 0x3f, 0xa4, 0x7f, 0x70, 0x0, 0x4c,
    0xfd, 0x60, 0x0,

    /* U+F1 "ñ" */
    0x0, 0x0, 0x1, 0x0, 0x9f, 0x70, 0xe2, 0x2e,
    0x3b, 0xfb, 0x0, 0x10, 0x1, 0x0, 0xe8, 0x9e,
    0xe9, 0xe, 0xfa, 0x58, 0xf6, 0xeb, 0x0, 0xc,
    0xae, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc, 0xe8, 0x0, 0xb, 0xc0,

    /* U+F2 "ò" */
    0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+F3 "ó" */
    0x0, 0x0, 0x3f, 0x70, 0x0, 0x0, 0xd, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+F4 "ô" */
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x6, 0xb1, 0xb5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+F5 "õ" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0xc, 0xff, 0xfe,
    0x10, 0x0, 0x22, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5d, 0xfd, 0x70, 0x0, 0x6f,
    0x94, 0x8f, 0x80, 0xe, 0xa0, 0x0, 0x8f, 0x12,
    0xf4, 0x0, 0x2, 0xf5, 0x4f, 0x30, 0x0, 0x1f,
    0x63, 0xf4, 0x0, 0x2, 0xf4, 0xe, 0x90, 0x0,
    0x8f, 0x10, 0x6f, 0x84, 0x7f, 0x80, 0x0, 0x6d,
    0xfd, 0x60, 0x0,

    /* U+F6 "ö" */
    0x0, 0xd7, 0x7, 0xd0, 0x0, 0x8, 0x40, 0x48,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+F7 "÷" */
    0x0, 0x2, 0xb2, 0x0, 0x0, 0x0, 0x3e, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0x53, 0x88,
    0x88, 0x88, 0x82, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2b, 0x20, 0x0, 0x0, 0x3, 0xe3, 0x0,
    0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x0, 0x77, 0x0, 0x5, 0xdf, 0xde,
    0x10, 0x6, 0xf9, 0x4b, 0xf8, 0x0, 0xea, 0x0,
    0xd9, 0xf1, 0x3f, 0x40, 0x69, 0x2f, 0x44, 0xf2,
    0xd, 0x21, 0xf6, 0x2f, 0x45, 0xa0, 0x2f, 0x40,
    0xea, 0xc2, 0x8, 0xf1, 0x6, 0xfd, 0x47, 0xf8,
    0x0, 0xd, 0xdf, 0xd7, 0x0, 0x3, 0xb0, 0x0,
    0x0, 0x0,

    /* U+F9 "ù" */
    0x7, 0xf2, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+FA "ú" */
    0x0, 0x4, 0xf5, 0x0, 0x1, 0xd5, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+FB "û" */
    0x0, 0x8e, 0x60, 0x0, 0x79, 0xa, 0x40, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+FC "ü" */
    0xd, 0x60, 0x8c, 0x0, 0x94, 0x5, 0x80, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+FD "ý" */
    0x0, 0x0, 0xbc, 0x10, 0x0, 0x6, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x5, 0xf3,
    0x4f, 0x30, 0x9, 0xd0, 0xe, 0x80, 0xe, 0x80,
    0x9, 0xd0, 0x3f, 0x20, 0x3, 0xf2, 0x8d, 0x0,
    0x0, 0xd8, 0xc7, 0x0, 0x0, 0x8e, 0xf2, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0x16, 0xda, 0x0, 0x0,
    0x5f, 0xb1, 0x0, 0x0,

    /* U+FE "þ" */
    0xd9, 0x0, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0x0, 0xda, 0x9f, 0xf9, 0x0,
    0xdf, 0x95, 0x8f, 0x80, 0xda, 0x0, 0x9, 0xf0,
    0xd9, 0x0, 0x4, 0xf3, 0xd9, 0x0, 0x2, 0xf4,
    0xd9, 0x0, 0x4, 0xf3, 0xda, 0x0, 0x8, 0xf0,
    0xdf, 0x84, 0x7f, 0x80, 0xda, 0xaf, 0xf9, 0x0,
    0xd9, 0x0, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0x0,

    /* U+FF "ÿ" */
    0x5, 0xe0, 0x1e, 0x50, 0x3, 0x90, 0x9, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x5, 0xf3,
    0x4f, 0x30, 0x9, 0xd0, 0xe, 0x80, 0xe, 0x80,
    0x9, 0xd0, 0x3f, 0x20, 0x3, 0xf2, 0x8d, 0x0,
    0x0, 0xd8, 0xc7, 0x0, 0x0, 0x8e, 0xf2, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0x16, 0xda, 0x0, 0x0,
    0x5f, 0xb1, 0x0, 0x0,

    /* U+100 "Ā" */
    0x0, 0x5f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x22,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xf6, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0xc0, 0x0, 0x0, 0x0, 0xbb, 0x4f, 0x20,
    0x0, 0x0, 0x1f, 0x60, 0xf8, 0x0, 0x0, 0x6,
    0xf1, 0xa, 0xd0, 0x0, 0x0, 0xcc, 0x0, 0x5f,
    0x30, 0x0, 0x2f, 0x70, 0x1, 0xf9, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0xdc, 0x33, 0x33,
    0x6f, 0x50, 0x3f, 0x50, 0x0, 0x0, 0xeb, 0x9,
    0xe0, 0x0, 0x0, 0x8, 0xf1,

    /* U+101 "ā" */
    0x0, 0xff, 0xff, 0xf3, 0x0, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+102 "Ă" */
    0x0, 0xf, 0x40, 0xc7, 0x0, 0x0, 0x0, 0x5d,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+103 "ă" */
    0x0, 0xa9, 0x7, 0xc0, 0x0, 0x2c, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xfd, 0x50,
    0x8, 0xf6, 0x48, 0xf2, 0xb, 0x70, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+104 "Ą" */
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0xf,
    0xf6, 0x0, 0x0, 0x0, 0x5, 0xe8, 0xc0, 0x0,
    0x0, 0x0, 0xb9, 0x2f, 0x20, 0x0, 0x0, 0x1f,
    0x30, 0xc8, 0x0, 0x0, 0x6, 0xd0, 0x6, 0xd0,
    0x0, 0x0, 0xc7, 0x0, 0x1f, 0x30, 0x0, 0x2f,
    0xff, 0xff, 0xf9, 0x0, 0x8, 0xc3, 0x33, 0x37,
    0xe0, 0x0, 0xd7, 0x0, 0x0, 0xf, 0x50, 0x3f,
    0x30, 0x0, 0x0, 0xbb, 0x9, 0xe0, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x0, 0x2, 0xd4, 0x0,
    0x0, 0x0, 0x0, 0x9b, 0x30, 0x0, 0x0, 0x0,
    0x5, 0xfd, 0x0,

    /* U+105 "ą" */
    0x0, 0x9e, 0xfd, 0x50, 0xb, 0xe5, 0x48, 0xf2,
    0x4, 0x20, 0x0, 0xe7, 0x0, 0x7c, 0xef, 0xf8,
    0x9, 0xe5, 0x22, 0xe8, 0xf, 0x60, 0x0, 0xe8,
    0x1f, 0x60, 0x2, 0xf8, 0xc, 0xe6, 0x6e, 0xf9,
    0x2, 0xbf, 0xe6, 0xdb, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0xf, 0x62, 0x0, 0x0, 0x9, 0xf9,

    /* U+106 "Ć" */
    0x0, 0x0, 0x1, 0x74, 0x0, 0x0, 0x0, 0x9,
    0xd1, 0x0, 0x0, 0x0, 0x3e, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+107 "ć" */
    0x0, 0x0, 0x8e, 0x30, 0x0, 0x4, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+108 "Ĉ" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x1, 0xdd,
    0x80, 0x0, 0x0, 0xb, 0x80, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+109 "ĉ" */
    0x0, 0xc, 0xd2, 0x0, 0x0, 0xb6, 0x3c, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xdf, 0xe8, 0x0, 0x0, 0xce, 0x75, 0x7f,
    0xb0, 0x6, 0xf3, 0x0, 0x4, 0xf5, 0xc, 0xb0,
    0x0, 0x0, 0xd8, 0xf, 0x80, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0xc7, 0x7, 0xf3, 0x0, 0x4,
    0xf5, 0x0, 0xce, 0x74, 0x7e, 0xb0, 0x0, 0x9,
    0xef, 0xd7, 0x0,

    /* U+10B "ċ" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x5, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10C "Č" */
    0x0, 0x7, 0x20, 0x54, 0x0, 0x0, 0x5, 0xd7,
    0xe1, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+10D "č" */
    0x0, 0xb6, 0x2d, 0x30, 0x0, 0xb, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x40,
    0x7, 0xf8, 0x4a, 0xf2, 0xe, 0x90, 0x0, 0xd9,
    0x3f, 0x40, 0x0, 0x79, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x68,
    0x7, 0xf7, 0x47, 0xf6, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10E "Ď" */
    0x3, 0xd1, 0x8b, 0x0, 0x0, 0x3, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfe,
    0x91, 0x0, 0xae, 0x44, 0x6d, 0xe2, 0xa, 0xd0,
    0x0, 0xd, 0xc0, 0xad, 0x0, 0x0, 0x5f, 0x3a,
    0xd0, 0x0, 0x1, 0xf6, 0xad, 0x0, 0x0, 0xf,
    0x8a, 0xd0, 0x0, 0x0, 0xf8, 0xad, 0x0, 0x0,
    0x1f, 0x6a, 0xd0, 0x0, 0x5, 0xf3, 0xad, 0x0,
    0x0, 0xdc, 0xa, 0xd4, 0x46, 0xde, 0x20, 0xaf,
    0xff, 0xe9, 0x10, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x0, 0x9e, 0xf, 0x50, 0x0, 0x0,
    0x9, 0xe4, 0xf2, 0x0, 0x0, 0x0, 0x9e, 0x46,
    0x0, 0x8, 0xef, 0xaa, 0xe0, 0x0, 0x7, 0xf9,
    0x59, 0xfe, 0x0, 0x0, 0xea, 0x0, 0xa, 0xe0,
    0x0, 0x2f, 0x40, 0x0, 0x9e, 0x0, 0x3, 0xf3,
    0x0, 0x9, 0xe0, 0x0, 0x2f, 0x40, 0x0, 0x9e,
    0x0, 0x0, 0xe8, 0x0, 0x9, 0xe0, 0x0, 0x7,
    0xf6, 0x26, 0xfe, 0x0, 0x0, 0x8, 0xee, 0xa9,
    0xe0, 0x0,

    /* U+110 "Đ" */
    0x7, 0xff, 0xfe, 0xa3, 0x0, 0x7, 0xf5, 0x46,
    0xbf, 0x50, 0x7, 0xf1, 0x0, 0xa, 0xe1, 0x7,
    0xf1, 0x0, 0x1, 0xf6, 0x7, 0xf1, 0x0, 0x0,
    0xda, 0xff, 0xff, 0xf0, 0x0, 0xbc, 0x38, 0xf4,
    0x30, 0x0, 0xbc, 0x7, 0xf1, 0x0, 0x0, 0xda,
    0x7, 0xf1, 0x0, 0x1, 0xf7, 0x7, 0xf1, 0x0,
    0xa, 0xf1, 0x7, 0xf4, 0x45, 0xbf, 0x50, 0x7,
    0xff, 0xfe, 0xa3, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf5, 0x0, 0x0, 0x23, 0xae, 0x31, 0x0,
    0x8e, 0xfa, 0xae, 0x0, 0x7, 0xf9, 0x59, 0xfe,
    0x0, 0xe, 0xa0, 0x0, 0xae, 0x0, 0x2f, 0x40,
    0x0, 0x9e, 0x0, 0x3f, 0x30, 0x0, 0x9e, 0x0,
    0x2f, 0x40, 0x0, 0x9e, 0x0, 0xe, 0x80, 0x0,
    0x9e, 0x0, 0x7, 0xf6, 0x26, 0xfe, 0x0, 0x0,
    0x8e, 0xea, 0x9e, 0x0,

    /* U+112 "Ē" */
    0xb, 0xff, 0xff, 0x70, 0x2, 0x22, 0x22, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+113 "ē" */
    0x2, 0xff, 0xff, 0xf1, 0x0, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+114 "Ĕ" */
    0x6, 0xd0, 0x3f, 0x10, 0x0, 0x9e, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+115 "ĕ" */
    0x0, 0xc7, 0x9, 0xa0, 0x0, 0x3c, 0xfb, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+116 "Ė" */
    0x0, 0x9, 0x50, 0x0, 0x0, 0xd, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+117 "ė" */
    0x0, 0x4, 0xe2, 0x0, 0x0, 0x2, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+118 "Ę" */
    0xaf, 0xff, 0xff, 0xf7, 0xae, 0x44, 0x44, 0x42,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xc0,
    0xad, 0x33, 0x33, 0x20, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x42, 0xaf, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x2d, 0x50, 0x0, 0x0, 0x8c, 0x30,
    0x0, 0x0, 0x4e, 0xe1,

    /* U+119 "ę" */
    0x0, 0x5d, 0xfd, 0x50, 0x5, 0xf7, 0x48, 0xf4,
    0xe, 0x60, 0x0, 0xab, 0x2f, 0xff, 0xff, 0xfd,
    0x4f, 0x63, 0x33, 0x33, 0x3f, 0x50, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x33, 0x7, 0xfa, 0x46, 0xe6,
    0x0, 0x6d, 0xff, 0x50, 0x0, 0x0, 0xd5, 0x0,
    0x0, 0x3, 0xf4, 0x10, 0x0, 0x0, 0xcf, 0x50,

    /* U+11A "Ě" */
    0x2, 0xd2, 0x6c, 0x0, 0x0, 0x2c, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+11B "ě" */
    0x0, 0x8a, 0xc, 0x60, 0x0, 0x7, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+11C "Ĝ" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x0, 0x1, 0xed,
    0x70, 0x0, 0x0, 0xc, 0x71, 0xd3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xef, 0xd9,
    0x10, 0x0, 0xce, 0x74, 0x7e, 0xc0, 0x7, 0xf3,
    0x0, 0x3, 0xf6, 0xc, 0xc0, 0x0, 0x0, 0x75,
    0xf, 0x90, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x6, 0xff, 0xfb, 0xf,
    0x90, 0x1, 0x33, 0xdb, 0xb, 0xd0, 0x0, 0x0,
    0xcb, 0x5, 0xf5, 0x0, 0x0, 0xcb, 0x0, 0xaf,
    0x84, 0x6a, 0xf7, 0x0, 0x6, 0xdf, 0xec, 0x50,

    /* U+11D "ĝ" */
    0x0, 0x9, 0xe4, 0x0, 0x0, 0x99, 0x1c, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+11E "Ğ" */
    0x0, 0xf, 0x40, 0xc7, 0x0, 0x0, 0x5, 0xdf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74, 0x7e,
    0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc, 0xc0,
    0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x6,
    0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb, 0xb,
    0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0, 0x0,
    0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0, 0x6,
    0xdf, 0xec, 0x50,

    /* U+11F "ğ" */
    0x0, 0x9e, 0xfd, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+120 "Ġ" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x49,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74, 0x7e,
    0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc, 0xc0,
    0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x6,
    0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb, 0xb,
    0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0, 0x0,
    0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0, 0x6,
    0xdf, 0xec, 0x50,

    /* U+121 "ġ" */
    0x0, 0x5, 0xe1, 0x0, 0x0, 0x3, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+122 "Ģ" */
    0x0, 0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74,
    0x7e, 0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc,
    0xc0, 0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x6, 0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb,
    0xb, 0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0,
    0x0, 0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0,
    0x6, 0xdf, 0xec, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x1f, 0x40, 0x0, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa4, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x6, 0xf0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfa, 0x8e, 0x7, 0xf9, 0x59, 0xfe,
    0xe, 0xa0, 0x0, 0xae, 0x2f, 0x50, 0x0, 0x9e,
    0x3f, 0x30, 0x0, 0x9e, 0x1f, 0x40, 0x0, 0x9e,
    0xe, 0x90, 0x0, 0xae, 0x7, 0xf9, 0x59, 0xfe,
    0x0, 0x8e, 0xfa, 0xad, 0x0, 0x0, 0x0, 0xcb,
    0x9, 0xc5, 0x49, 0xf4, 0x0, 0x9e, 0xfc, 0x40,

    /* U+124 "Ĥ" */
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x6c, 0x1b,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0,
    0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1,
    0xaf, 0xff, 0xff, 0xff, 0xf1, 0xad, 0x33, 0x33,
    0x39, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0,
    0x0, 0x7, 0xf1,

    /* U+125 "ĥ" */
    0x2, 0xdc, 0x0, 0x2, 0xd4, 0x6c, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0xe8, 0x0,
    0x0, 0xe, 0x80, 0x0, 0x0, 0xe9, 0x9e, 0xe9,
    0xe, 0xfa, 0x58, 0xf6, 0xeb, 0x0, 0xc, 0xae,
    0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80, 0x0,
    0xbc, 0xe8, 0x0, 0xb, 0xc0,

    /* U+126 "Ħ" */
    0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x7f, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x2c, 0xd2, 0x22, 0x22, 0x9f, 0x20,
    0xb, 0xc0, 0x0, 0x0, 0x8f, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xb, 0xd3, 0x33, 0x33,
    0x9f, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0, 0x0, 0x0,
    0x7f, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0,

    /* U+127 "ħ" */
    0x0, 0xac, 0x0, 0x0, 0x3, 0xff, 0xff, 0xb0,
    0x0, 0x3, 0xbd, 0x32, 0x0, 0x0, 0xa, 0xc6,
    0xef, 0xb1, 0x0, 0xaf, 0xc5, 0x6f, 0xa0, 0xa,
    0xe1, 0x0, 0x9e, 0x0, 0xac, 0x0, 0x7, 0xf0,
    0xa, 0xc0, 0x0, 0x7f, 0x0, 0xac, 0x0, 0x7,
    0xf0, 0xa, 0xc0, 0x0, 0x7f, 0x0, 0xac, 0x0,
    0x7, 0xf0, 0xa, 0xc0, 0x0, 0x7f,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x1, 0x1c, 0xd4, 0x3e, 0x7b, 0x4d,
    0xf7, 0x11, 0x0, 0x10, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x0, 0x3e, 0xc2, 0x6a, 0xa8, 0x5e,
    0xf4, 0x10, 0x0, 0x10, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,

    /* U+12A "Ī" */
    0x6f, 0xff, 0xfd, 0x12, 0x22, 0x22, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+12B "ī" */
    0x9f, 0xff, 0xfa, 0x12, 0x22, 0x21, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+12C "Ĭ" */
    0xf, 0x30, 0xc6, 0x5, 0xee, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+12D "ĭ" */
    0x3e, 0x11, 0xf3, 0x8, 0xee, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+12E "Į" */
    0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0,
    0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0xbf, 0x4d, 0x1c, 0xa3, 0x6f, 0xc0,

    /* U+12F "į" */
    0x0, 0xb9, 0x0, 0x76, 0x0, 0x0, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xfd,
    0x7, 0xb0, 0xf, 0x62, 0xa, 0xf8,

    /* U+130 "İ" */
    0x59, 0x7, 0xd0, 0x0, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x0,

    /* U+131 "ı" */
    0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca,
    0xca,

    /* U+132 "Ĳ" */
    0x9f, 0x0, 0x0, 0x0, 0x9, 0xf9, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x9f, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0x9f, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0xf0, 0x0, 0x0, 0x0,
    0x9f, 0x9f, 0x0, 0x0, 0x0, 0x9, 0xf9, 0xf0,
    0x0, 0x0, 0x0, 0x9f, 0x9f, 0x1, 0x41, 0x0,
    0x9, 0xe9, 0xf0, 0x1f, 0x60, 0x0, 0xcc, 0x9f,
    0x0, 0xbe, 0x52, 0x8f, 0x59, 0xf0, 0x1, 0x9e,
    0xfc, 0x50,

    /* U+133 "ĳ" */
    0xb9, 0x0, 0xd6, 0x76, 0x0, 0x93, 0x0, 0x0,
    0x0, 0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca,
    0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7,
    0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca, 0x0,
    0xf7, 0xca, 0x0, 0xf7, 0x0, 0x0, 0xf7, 0x0,
    0x37, 0xf4, 0x0, 0x9f, 0xa0,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0x4, 0xf9, 0x0, 0x0, 0x0, 0x4d,
    0x1a, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x36,
    0x0, 0x0, 0xe9, 0x0, 0x6f, 0x10, 0x2, 0xf6,
    0x0, 0x1e, 0xc5, 0x6d, 0xe0, 0x0, 0x3, 0xbe,
    0xeb, 0x20, 0x0,

    /* U+135 "ĵ" */
    0x0, 0xcd, 0x10, 0xc, 0x64, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xbc, 0x0, 0x25,
    0xf8, 0x0, 0x8f, 0xb1, 0x0,

    /* U+136 "Ķ" */
    0xad, 0x0, 0x0, 0x8f, 0x40, 0xad, 0x0, 0x6,
    0xf6, 0x0, 0xad, 0x0, 0x4f, 0x90, 0x0, 0xad,
    0x2, 0xfb, 0x0, 0x0, 0xad, 0x1d, 0xd0, 0x0,
    0x0, 0xad, 0xcf, 0x60, 0x0, 0x0, 0xaf, 0xfc,
    0xf2, 0x0, 0x0, 0xaf, 0x41, 0xec, 0x0, 0x0,
    0xad, 0x0, 0x4f, 0x80, 0x0, 0xad, 0x0, 0x8,
    0xf4, 0x0, 0xad, 0x0, 0x0, 0xce, 0x10, 0xad,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0, 0xe,
    0x40, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x7f, 0x40,
    0xe8, 0x6, 0xf6, 0x0, 0xe8, 0x4f, 0x80, 0x0,
    0xeb, 0xfb, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0xed, 0x3f, 0xa0, 0x0, 0xe8, 0x6, 0xf5, 0x0,
    0xe8, 0x0, 0xae, 0x10, 0xe8, 0x0, 0x1e, 0xb0,
    0x0, 0x46, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0x0, 0xd8, 0x0, 0x0, 0x0, 0x81, 0x0, 0x0,

    /* U+138 "ĸ" */
    0xca, 0x0, 0x1d, 0xc0, 0xca, 0x0, 0xbe, 0x10,
    0xca, 0x7, 0xf4, 0x0, 0xca, 0x4f, 0x70, 0x0,
    0xcf, 0xfe, 0x0, 0x0, 0xcb, 0x6f, 0x80, 0x0,
    0xca, 0x7, 0xf6, 0x0, 0xca, 0x0, 0x9f, 0x40,
    0xca, 0x0, 0xb, 0xe2,

    /* U+139 "Ĺ" */
    0x8, 0xf2, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x45, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x40,
    0xaf, 0xff, 0xff, 0xf3,

    /* U+13A "ĺ" */
    0xa, 0xe1, 0x3f, 0x30, 0x54, 0x0, 0x0, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,

    /* U+13B "Ļ" */
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x80, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x4e, 0x10, 0x0,
    0x0, 0x1, 0x0, 0x0,

    /* U+13C "ļ" */
    0xc, 0xa0, 0xca, 0xc, 0xa0, 0xca, 0xc, 0xa0,
    0xca, 0xc, 0xa0, 0xca, 0xc, 0xa0, 0xca, 0xc,
    0xa0, 0xca, 0x0, 0x0, 0xba, 0xd, 0x82, 0xf2,
    0x1, 0x0,

    /* U+13D "Ľ" */
    0xad, 0x0, 0xf5, 0x0, 0xad, 0x2, 0xf3, 0x0,
    0xad, 0x6, 0xc0, 0x0, 0xad, 0x0, 0x10, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,

    /* U+13E "ľ" */
    0xca, 0xf, 0x5c, 0xa2, 0xf3, 0xca, 0x6b, 0xc,
    0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0, 0x0, 0xca,
    0x0, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0,
    0x0, 0xca, 0x0, 0xc, 0xa0, 0x0,

    /* U+13F "Ŀ" */
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x2, 0xa1, 0x0, 0xad, 0x4, 0xe2, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,

    /* U+140 "ŀ" */
    0xca, 0x0, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc,
    0xa0, 0x0, 0xca, 0x0, 0xc, 0xa4, 0xe1, 0xca,
    0x2a, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0,
    0x0, 0xca, 0x0, 0xc, 0xa0, 0x0,

    /* U+141 "Ł" */
    0xb, 0xd0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0xb, 0xd2, 0x60, 0x0, 0x2, 0xcf,
    0xd7, 0x0, 0x0, 0x9e, 0xd0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x0, 0xb, 0xe4, 0x44,
    0x44, 0x0, 0xbf, 0xff, 0xff, 0xf3,

    /* U+142 "ł" */
    0x9, 0xd0, 0x0, 0x9d, 0x0, 0x9, 0xd0, 0x0,
    0x9d, 0x0, 0x9, 0xd1, 0x0, 0xaf, 0xd0, 0xae,
    0xd0, 0x0, 0x9d, 0x0, 0x9, 0xd0, 0x0, 0x9d,
    0x0, 0x9, 0xd0, 0x0, 0x9d, 0x0,

    /* U+143 "Ń" */
    0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x0, 0x0, 0x72, 0x0, 0x0, 0xaf,
    0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0, 0x6,
    0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad, 0xbe,
    0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6, 0xf1,
    0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0, 0xdd,
    0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1, 0xad,
    0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1, 0xef,
    0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad, 0x0,
    0x0, 0xb, 0xf1,

    /* U+144 "ń" */
    0x0, 0x3, 0xf6, 0x0, 0x1, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x89, 0xee, 0x90, 0xef, 0xa5,
    0x8f, 0x6e, 0xb0, 0x0, 0xca, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc,

    /* U+145 "Ņ" */
    0xaf, 0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0,
    0x6, 0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad,
    0xbe, 0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6,
    0xf1, 0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0,
    0xdd, 0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1,
    0xad, 0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1,
    0xef, 0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad,
    0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+146 "ņ" */
    0xe8, 0x9e, 0xe9, 0xe, 0xfa, 0x58, 0xf6, 0xeb,
    0x0, 0xc, 0xae, 0x80, 0x0, 0xbb, 0xe8, 0x0,
    0xb, 0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb,
    0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x1, 0x0,
    0x0,

    /* U+147 "Ň" */
    0x0, 0x4d, 0x19, 0xa0, 0x0, 0x0, 0x4, 0xd9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0, 0x6,
    0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad, 0xbe,
    0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6, 0xf1,
    0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0, 0xdd,
    0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1, 0xad,
    0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1, 0xef,
    0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad, 0x0,
    0x0, 0xb, 0xf1,

    /* U+148 "ň" */
    0x7, 0xb0, 0xc6, 0x0, 0x7, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x89, 0xee, 0x90, 0xef, 0xa5,
    0x8f, 0x6e, 0xb0, 0x0, 0xca, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc,

    /* U+149 "ŉ" */
    0xf, 0x60, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0,
    0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0xe, 0x89,
    0xee, 0x90, 0x0, 0xef, 0xa5, 0x8f, 0x60, 0xe,
    0xb0, 0x0, 0xca, 0x0, 0xe8, 0x0, 0xb, 0xb0,
    0xe, 0x80, 0x0, 0xbc, 0x0, 0xe8, 0x0, 0xb,
    0xc0, 0xe, 0x80, 0x0, 0xbc, 0x0, 0xe8, 0x0,
    0xb, 0xc0, 0xe, 0x80, 0x0, 0xbc,

    /* U+14A "Ŋ" */
    0xbf, 0x10, 0x0, 0xa, 0xeb, 0xfa, 0x0, 0x0,
    0xae, 0xbf, 0xf4, 0x0, 0xa, 0xeb, 0xcb, 0xd0,
    0x0, 0xae, 0xbc, 0x2f, 0x70, 0xa, 0xeb, 0xc0,
    0x8f, 0x10, 0xae, 0xbc, 0x0, 0xea, 0xa, 0xeb,
    0xc0, 0x5, 0xf4, 0xae, 0xbc, 0x0, 0xb, 0xda,
    0xeb, 0xc0, 0x0, 0x2f, 0xfe, 0xbc, 0x0, 0x0,
    0x8f, 0xeb, 0xc0, 0x0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x25, 0xe9, 0x0,
    0x0, 0x7, 0xfb, 0x10,

    /* U+14B "ŋ" */
    0xd7, 0x8e, 0xe9, 0xd, 0xe8, 0x57, 0xf8, 0xda,
    0x0, 0xb, 0xcd, 0x90, 0x0, 0x9d, 0xd9, 0x0,
    0x9, 0xed, 0x90, 0x0, 0x9e, 0xd9, 0x0, 0x9,
    0xed, 0x90, 0x0, 0x9e, 0xd9, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x9d, 0x0, 0x2, 0x5e, 0xa0, 0x0,
    0x7f, 0xb1,

    /* U+14C "Ō" */
    0x0, 0xf, 0xff, 0xff, 0x20, 0x0, 0x0, 0x22,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+14D "ō" */
    0x1, 0xff, 0xff, 0xf2, 0x0, 0x2, 0x22, 0x22,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0xb, 0x90, 0x8b, 0x0, 0x0, 0x0, 0x2c,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+14F "ŏ" */
    0x0, 0xb8, 0x8, 0xb0, 0x0, 0x2, 0xcf, 0xc2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+150 "Ő" */
    0x0, 0x0, 0x5f, 0x2c, 0xb0, 0x0, 0x0, 0xd,
    0x68, 0xd1, 0x0, 0x0, 0x2, 0x60, 0x72, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+151 "ő" */
    0x0, 0x6, 0xf2, 0xcb, 0x0, 0x0, 0xe6, 0x8d,
    0x0, 0x0, 0x26, 0x7, 0x10, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+152 "Œ" */
    0x0, 0x2a, 0xef, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x2e, 0xe9, 0x67, 0xfa, 0x77, 0x77, 0x70, 0xb,
    0xe1, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x40, 0x3f, 0x40, 0x0,
    0x2f, 0x73, 0x33, 0x31, 0x2, 0xf4, 0x0, 0x2,
    0xf5, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x2, 0xf5,
    0x0, 0x0, 0x0, 0x2, 0xec, 0x64, 0x5f, 0x84,
    0x44, 0x44, 0x0, 0x2, 0xae, 0xff, 0xff, 0xff,
    0xff, 0xf1,

    /* U+153 "œ" */
    0x0, 0x5d, 0xfd, 0x50, 0x3c, 0xfd, 0x60, 0x5,
    0xf9, 0x48, 0xf8, 0xfb, 0x48, 0xf4, 0xe, 0xa0,
    0x0, 0x9f, 0xe0, 0x0, 0xbb, 0x2f, 0x50, 0x0,
    0x4f, 0x90, 0x0, 0x7e, 0x3f, 0x30, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0x2f, 0x40, 0x0, 0x4f, 0x93,
    0x33, 0x33, 0xe, 0xa0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x6, 0xf8, 0x48, 0xfa, 0xfa, 0x45, 0x97,
    0x0, 0x6d, 0xfd, 0x60, 0x4c, 0xff, 0xb2,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x6e, 0x10,
    0x0, 0x0, 0x7, 0x20, 0x0, 0xb, 0xff, 0xff,
    0xc5, 0x0, 0xbe, 0x44, 0x5a, 0xf7, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0xbd, 0x0, 0x0, 0x7f, 0xb,
    0xd0, 0x0, 0xa, 0xf0, 0xbd, 0x0, 0x16, 0xf8,
    0xb, 0xff, 0xff, 0xf8, 0x0, 0xbd, 0x33, 0x7f,
    0x30, 0xb, 0xd0, 0x0, 0xdb, 0x0, 0xbd, 0x0,
    0x5, 0xf4, 0xb, 0xd0, 0x0, 0xc, 0xc0, 0xbd,
    0x0, 0x0, 0x4f, 0x50,

    /* U+155 "ŕ" */
    0x0, 0x7e, 0x30, 0x3d, 0x20, 0x0, 0x0, 0xe,
    0xac, 0xf3, 0xef, 0x85, 0x1e, 0xa0, 0x0, 0xe8,
    0x0, 0xe, 0x80, 0x0, 0xe8, 0x0, 0xe, 0x80,
    0x0, 0xe8, 0x0, 0xe, 0x80, 0x0,

    /* U+156 "Ŗ" */
    0xbf, 0xff, 0xfc, 0x50, 0xb, 0xe4, 0x45, 0xaf,
    0x70, 0xbd, 0x0, 0x0, 0xbe, 0xb, 0xd0, 0x0,
    0x7, 0xf0, 0xbd, 0x0, 0x0, 0xaf, 0xb, 0xd0,
    0x1, 0x6f, 0x80, 0xbf, 0xff, 0xff, 0x80, 0xb,
    0xd3, 0x37, 0xf3, 0x0, 0xbd, 0x0, 0xd, 0xb0,
    0xb, 0xd0, 0x0, 0x5f, 0x40, 0xbd, 0x0, 0x0,
    0xcc, 0xb, 0xd0, 0x0, 0x4, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x5, 0xe0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x0, 0xe, 0xac, 0xf3, 0xe, 0xf8,
    0x51, 0xe, 0xa0, 0x0, 0xe, 0x80, 0x0, 0xe,
    0x80, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80, 0x0,
    0xe, 0x80, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0xe, 0x70, 0x0, 0x2f,
    0x10, 0x0, 0x1, 0x0, 0x0,

    /* U+158 "Ř" */
    0x3, 0xd1, 0x8b, 0x0, 0x0, 0x3, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xc5, 0x0, 0xbe, 0x44, 0x5a, 0xf7, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0xbd, 0x0, 0x0, 0x7f, 0xb,
    0xd0, 0x0, 0xa, 0xf0, 0xbd, 0x0, 0x16, 0xf8,
    0xb, 0xff, 0xff, 0xf8, 0x0, 0xbd, 0x33, 0x7f,
    0x30, 0xb, 0xd0, 0x0, 0xdb, 0x0, 0xbd, 0x0,
    0x5, 0xf4, 0xb, 0xd0, 0x0, 0xc, 0xc0, 0xbd,
    0x0, 0x0, 0x4f, 0x50,

    /* U+159 "ř" */
    0xa, 0x62, 0xd3, 0x0, 0x9b, 0x20, 0x0, 0x0,
    0x0, 0xe, 0xac, 0xf3, 0xe, 0xf8, 0x51, 0xe,
    0xa0, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80, 0x0,
    0xe, 0x80, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80,
    0x0, 0xe, 0x80, 0x0,

    /* U+15A "Ś" */
    0x0, 0x0, 0x4, 0x71, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+15B "ś" */
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x1, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xea, 0x10,
    0xa, 0xe5, 0x5d, 0xd0, 0xe, 0x80, 0x4, 0xf4,
    0xb, 0xe6, 0x10, 0x51, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2a, 0x20, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+15C "Ŝ" */
    0x0, 0x0, 0x63, 0x0, 0x0, 0x0, 0x6d, 0xe2,
    0x0, 0x0, 0x3e, 0x25, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+15D "ŝ" */
    0x0, 0x9, 0xe5, 0x0, 0x0, 0x8a, 0x1c, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x30,
    0xa, 0xe5, 0x4c, 0xe1, 0xe, 0x80, 0x1, 0xb3,
    0xb, 0xe6, 0x10, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2d, 0x40, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+15E "Ş" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f, 0x95, 0x6c,
    0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0, 0xf9, 0x0,
    0x0, 0x67, 0xa, 0xf5, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e, 0xfa, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0x39, 0x10, 0x0, 0xb,
    0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9, 0xf9, 0x55,
    0xaf, 0x60, 0x6, 0xcf, 0xfc, 0x40, 0x0, 0x0,
    0x9c, 0x20, 0x0, 0x0, 0x0, 0xa8, 0x0, 0x0,
    0x0, 0xbc, 0x20, 0x0,

    /* U+15F "ş" */
    0x0, 0x9e, 0xfb, 0x30, 0xa, 0xe5, 0x4c, 0xe1,
    0xe, 0x80, 0x1, 0xb3, 0xb, 0xe6, 0x10, 0x0,
    0x0, 0x8e, 0xfd, 0x50, 0x0, 0x0, 0x29, 0xf3,
    0x2d, 0x40, 0x0, 0xf6, 0xd, 0xd5, 0x49, 0xf2,
    0x1, 0xae, 0xfc, 0x40, 0x0, 0x2, 0xe7, 0x0,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x4, 0xe7, 0x0,

    /* U+160 "Š" */
    0x0, 0x26, 0x1, 0x71, 0x0, 0x0, 0xc8, 0xc8,
    0x0, 0x0, 0x1, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+161 "š" */
    0x0, 0x8a, 0xc, 0x50, 0x0, 0x8, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xea, 0x10,
    0xa, 0xe5, 0x5d, 0xd0, 0xe, 0x80, 0x4, 0xf4,
    0xb, 0xe6, 0x10, 0x51, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2a, 0x20, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+162 "Ţ" */
    0x9f, 0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xca, 0x10,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0xdb, 0x10, 0x0,

    /* U+163 "ţ" */
    0x3, 0x80, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1,
    0x0, 0xef, 0xff, 0xa0, 0x27, 0xf3, 0x10, 0x6,
    0xf1, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0,
    0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0, 0x4, 0xf7,
    0x30, 0x0, 0xaf, 0x90, 0x0, 0x1e, 0x90, 0x0,
    0x1, 0xf2, 0x0, 0x2e, 0x90,

    /* U+164 "Ť" */
    0x0, 0x3d, 0x17, 0xb0, 0x0, 0x0, 0x3, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa, 0x44,
    0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+165 "ť" */
    0x0, 0x0, 0x46, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0xd8, 0x6, 0xf1, 0x70, 0x6, 0xf1, 0x0, 0xef,
    0xff, 0xa0, 0x27, 0xf3, 0x10, 0x6, 0xf1, 0x0,
    0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1,
    0x0, 0x6, 0xf1, 0x0, 0x4, 0xf7, 0x30, 0x0,
    0xaf, 0x90,

    /* U+166 "Ŧ" */
    0x9f, 0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xf5,
    0x0, 0x0, 0x23, 0xfa, 0x31, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x6f, 0x10, 0x0, 0x6f, 0x10, 0xe, 0xff,
    0xfa, 0x2, 0x7f, 0x31, 0x0, 0x6f, 0x10, 0x1f,
    0xff, 0xfe, 0x3, 0x8f, 0x42, 0x0, 0x6f, 0x10,
    0x0, 0x6f, 0x10, 0x0, 0x4f, 0x73, 0x0, 0xa,
    0xf9,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd4, 0x3e,
    0x0, 0x6, 0xb4, 0xdf, 0x70, 0x0, 0x11, 0x0,
    0x10, 0x0, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5e, 0x90, 0x0, 0x2, 0xf5, 0xda, 0x0,
    0x0, 0x3f, 0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f,
    0xc6, 0x59, 0xf8, 0x0, 0x3b, 0xff, 0xc6, 0x0,

    /* U+169 "ũ" */
    0x0, 0x0, 0x1, 0x1, 0xcf, 0xff, 0xe1, 0x2,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb, 0xbe,
    0x80, 0x0, 0xbb, 0xda, 0x0, 0xd, 0xb9, 0xf6,
    0x5a, 0xfb, 0x1a, 0xfe, 0x9b, 0xb0,

    /* U+16A "Ū" */
    0x5, 0xff, 0xff, 0xd0, 0x0, 0x12, 0x22, 0x22,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+16B "ū" */
    0x2f, 0xff, 0xff, 0x10, 0x22, 0x22, 0x20, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+16C "Ŭ" */
    0x0, 0xf4, 0xc, 0x70, 0x0, 0x5, 0xde, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+16D "ŭ" */
    0xc, 0x70, 0x9a, 0x0, 0x3c, 0xfc, 0x20, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+16E "Ů" */
    0x0, 0x9, 0xb3, 0x0, 0x0, 0x5, 0x71, 0xb0,
    0x0, 0x0, 0x57, 0xb, 0x0, 0x0, 0x0, 0x9b,
    0x30, 0x0, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5e, 0x90, 0x0, 0x2, 0xf5, 0xda, 0x0,
    0x0, 0x3f, 0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f,
    0xc6, 0x59, 0xf8, 0x0, 0x3b, 0xff, 0xc6, 0x0,

    /* U+16F "ů" */
    0x0, 0x7b, 0x50, 0x0, 0x2b, 0xc, 0x0, 0x2,
    0xb0, 0xc0, 0x0, 0x7, 0xb6, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb, 0xbf,
    0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd, 0xa0,
    0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf, 0xe9,
    0xbb,

    /* U+170 "Ű" */
    0x0, 0xa, 0xc2, 0xf7, 0x0, 0x3, 0xf2, 0xc9,
    0x0, 0x0, 0x44, 0x27, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+171 "ű" */
    0x0, 0x7e, 0x2d, 0xa0, 0x1, 0xe5, 0x9c, 0x0,
    0x2, 0x61, 0x71, 0x0, 0xf8, 0x0, 0xb, 0xb0,
    0xf8, 0x0, 0xb, 0xb0, 0xf8, 0x0, 0xb, 0xb0,
    0xf8, 0x0, 0xb, 0xb0, 0xf8, 0x0, 0xb, 0xb0,
    0xe8, 0x0, 0xb, 0xb0, 0xda, 0x0, 0xd, 0xb0,
    0x9f, 0x65, 0xaf, 0xb0, 0x1a, 0xfe, 0x9b, 0xb0,

    /* U+172 "Ų" */
    0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0, 0x2,
    0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xda, 0x0, 0x0, 0x3f,
    0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f, 0xc6, 0x59,
    0xf8, 0x0, 0x3b, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0x3f, 0x41, 0x0, 0x0,
    0x0, 0xcf, 0x50, 0x0,

    /* U+173 "ų" */
    0xf8, 0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8,
    0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbe, 0x80, 0x0, 0xbb, 0xda, 0x0, 0xd,
    0xb9, 0xf6, 0x5a, 0xfb, 0x1a, 0xfe, 0x9b, 0xb0,
    0x0, 0x7, 0xc1, 0x0, 0x0, 0xe8, 0x20, 0x0,
    0x8, 0xfa,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x0, 0xbe, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x82, 0xd2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x9f, 0x0, 0x0, 0xcb, 0x2f, 0x40, 0x0, 0xdf,
    0x30, 0x0, 0xf8, 0xe, 0x80, 0x1, 0xfe, 0x70,
    0x3, 0xf4, 0xb, 0xb0, 0x6, 0xf8, 0xb0, 0x6,
    0xf0, 0x7, 0xf0, 0xa, 0xa4, 0xf0, 0x9, 0xd0,
    0x4, 0xf2, 0xe, 0x60, 0xf4, 0xd, 0x90, 0x0,
    0xf6, 0x2f, 0x10, 0xb8, 0xf, 0x50, 0x0, 0xc9,
    0x7d, 0x0, 0x7c, 0x4f, 0x20, 0x0, 0x9d, 0xb9,
    0x0, 0x3f, 0x8e, 0x0, 0x0, 0x5f, 0xe4, 0x0,
    0xe, 0xea, 0x0, 0x0, 0x1f, 0xf0, 0x0, 0xa,
    0xf7, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x6, 0xf3,
    0x0,

    /* U+175 "ŵ" */
    0x0, 0x0, 0x2d, 0xc1, 0x0, 0x0, 0x0, 0x1,
    0xb3, 0x4a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0xb, 0xb0, 0x0, 0xe8,
    0x4f, 0x20, 0xf, 0xf0, 0x2, 0xf3, 0xf, 0x60,
    0x5d, 0xe5, 0x6, 0xf0, 0xb, 0xa0, 0x99, 0xa9,
    0xa, 0xb0, 0x6, 0xe0, 0xe4, 0x5e, 0xe, 0x60,
    0x2, 0xf5, 0xf0, 0xf, 0x5f, 0x20, 0x0, 0xed,
    0xb0, 0xb, 0xdd, 0x0, 0x0, 0x9f, 0x60, 0x6,
    0xf9, 0x0, 0x0, 0x5f, 0x10, 0x2, 0xf5, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x3, 0xeb, 0x0, 0x0, 0x0, 0x3d, 0x37,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0, 0xe,
    0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1, 0xf9,
    0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0,
    0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+177 "ŷ" */
    0x0, 0x2d, 0xc1, 0x0, 0x1, 0xb3, 0x4b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x5, 0xf3,
    0x4f, 0x30, 0x9, 0xd0, 0xe, 0x80, 0xe, 0x80,
    0x9, 0xd0, 0x3f, 0x20, 0x3, 0xf2, 0x8d, 0x0,
    0x0, 0xd8, 0xc7, 0x0, 0x0, 0x8e, 0xf2, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0x16, 0xda, 0x0, 0x0,
    0x5f, 0xb1, 0x0, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0x48, 0x1, 0xa1, 0x0, 0x0, 0x8d, 0x2,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0, 0xe,
    0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1, 0xf9,
    0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0,
    0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x6, 0xe1,
    0x0, 0x0, 0x0, 0x63, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17A "ź" */
    0x0, 0x0, 0xad, 0x10, 0x0, 0x6, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17B "Ż" */
    0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0xd, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17C "ż" */
    0x0, 0xa, 0xa0, 0x0, 0x0, 0x6, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17D "Ž" */
    0x0, 0x2d, 0x27, 0xb0, 0x0, 0x0, 0x3d, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17E "ž" */
    0x1, 0xc4, 0x4d, 0x10, 0x0, 0xa, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17F "ſ" */
    0x0, 0x0, 0x0, 0x9f, 0xe0, 0x6f, 0x63, 0xa,
    0xc0, 0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb,
    0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0, 0xc, 0xb0,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0,
    0xc, 0xb0, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x16, 0xbf, 0xff, 0xff,
    0x0, 0x0, 0x3, 0x8d, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xea, 0x51, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x83, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x2b, 0xff, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xfd,
    0xdf, 0xff, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xb2,
    0xdf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,

    /* U+F00B "" */
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xc0,
    0x1b, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xfc, 0x0,
    0xcf, 0xfb, 0x0, 0x0, 0xbf, 0xff, 0xc0, 0x0,
    0xbf, 0xff, 0xb0, 0xb, 0xff, 0xfc, 0x0, 0x0,
    0xc, 0xff, 0xfb, 0xbf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x3, 0x0, 0x0, 0x0, 0x3, 0x8, 0xfc, 0x10,
    0x0, 0x1c, 0xf8, 0xff, 0xfc, 0x10, 0x1c, 0xff,
    0xf5, 0xff, 0xfc, 0x2c, 0xff, 0xf5, 0x5, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x5, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x1d, 0xff, 0xfd, 0x10, 0x0, 0x1c,
    0xff, 0xff, 0xfc, 0x10, 0x1c, 0xff, 0xf9, 0xff,
    0xfc, 0x1c, 0xff, 0xf5, 0x5, 0xff, 0xfc, 0xdf,
    0xf5, 0x0, 0x5, 0xff, 0xd1, 0xa4, 0x0, 0x0,
    0x4, 0xa1,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x10, 0x6f, 0xf1, 0x3, 0x10, 0x0,
    0x0, 0x5f, 0xd0, 0x6f, 0xf1, 0x3f, 0xd1, 0x0,
    0x3, 0xff, 0xf1, 0x6f, 0xf1, 0x5f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x6f, 0xf1, 0x9, 0xff, 0x70,
    0x4f, 0xf7, 0x0, 0x6f, 0xf1, 0x0, 0xcf, 0xe0,
    0x9f, 0xf0, 0x0, 0x6f, 0xf1, 0x0, 0x5f, 0xf3,
    0xbf, 0xc0, 0x0, 0x6f, 0xf1, 0x0, 0x2f, 0xf5,
    0xbf, 0xc0, 0x0, 0x4f, 0xe0, 0x0, 0x1f, 0xf6,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf0,
    0xf, 0xfe, 0x10, 0x0, 0x0, 0x5, 0xff, 0xa0,
    0x6, 0xff, 0xd3, 0x0, 0x0, 0x7f, 0xff, 0x20,
    0x0, 0x9f, 0xff, 0xda, 0xbe, 0xff, 0xf4, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x17, 0xbd, 0xca, 0x50, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x4, 0xfd, 0xdf, 0xff, 0xff, 0xfd, 0xef, 0x40,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4, 0xfe, 0xdf, 0xff, 0xff, 0xfd, 0xdf, 0x40,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x3, 0xdd, 0x30, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5, 0x4f,
    0xf4, 0x0, 0x0, 0x0, 0x9, 0xff, 0x99, 0xff,
    0xbf, 0xf4, 0x0, 0x0, 0x1, 0xbf, 0xf6, 0x22,
    0x6f, 0xff, 0xf4, 0x0, 0x0, 0x2d, 0xfe, 0x35,
    0xff, 0x53, 0xef, 0xf4, 0x0, 0x4, 0xff, 0xc1,
    0x8f, 0xff, 0xf8, 0x2d, 0xfe, 0x40, 0x7f, 0xfa,
    0x1a, 0xff, 0xff, 0xff, 0xa1, 0xaf, 0xf7, 0xcf,
    0x82, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x28, 0xfc,
    0x14, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x41, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xf9, 0x0, 0x8f,
    0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8,
    0x0, 0x8f, 0xff, 0xf0, 0x0, 0x0, 0xe, 0xff,
    0xf6, 0x0, 0x6f, 0xff, 0xe0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x1b, 0xb1, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xc2, 0x2c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F01C "" */
    0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0xb, 0xfa, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x50, 0x1e, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe1, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F021 "" */
    0x0, 0x0, 0x6, 0xbd, 0xda, 0x50, 0x2, 0xff,
    0x0, 0x5, 0xef, 0xff, 0xff, 0xfe, 0x42, 0xff,
    0x0, 0x7f, 0xff, 0xa7, 0x7b, 0xff, 0xf9, 0xff,
    0x5, 0xff, 0xc1, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xe, 0xfc, 0x0, 0x0, 0x2, 0x22, 0xdf, 0xff,
    0x5f, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x8f, 0xb0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb, 0xf8,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x2f, 0xf4,
    0xff, 0xfd, 0x22, 0x20, 0x0, 0x0, 0xcf, 0xe0,
    0xff, 0xff, 0xc2, 0x0, 0x0, 0x2c, 0xff, 0x40,
    0xff, 0x9f, 0xff, 0xb7, 0x6a, 0xff, 0xf7, 0x0,
    0xff, 0x24, 0xdf, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xff, 0x20, 0x5, 0xac, 0xdb, 0x60, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x8f, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x1, 0x50, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x0, 0xae,
    0xff, 0xff, 0xff, 0xff, 0x5, 0xf8, 0xdf, 0xff,
    0xff, 0xff, 0x2, 0x60, 0x0, 0x0, 0x9f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x3, 0xee, 0x10, 0x0, 0x0, 0x8, 0xff, 0x0,
    0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x5, 0xfc, 0x7, 0xf4, 0xdf, 0xff, 0xff,
    0xff, 0x2, 0x50, 0x5f, 0x60, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xd, 0xc0, 0xbd, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x6, 0xf7, 0xd,
    0xc0, 0xad, 0xdf, 0xff, 0xff, 0xff, 0x2, 0x50,
    0x5f, 0x60, 0xe9, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x5, 0xfc, 0x6, 0xf4, 0x0, 0x0, 0x8, 0xff,
    0x0, 0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x2, 0xee, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0,

    /* U+F03E "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0xc, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xfe, 0x22, 0xef, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xe2, 0x0, 0x2e, 0xff,
    0xff, 0xfe, 0x4e, 0xfe, 0x20, 0x0, 0x2, 0xff,
    0xff, 0xe2, 0x2, 0xc2, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x1, 0xcc, 0xff, 0x40, 0x0, 0x2d, 0xff, 0xff,
    0x40, 0x3, 0xef, 0xff, 0xff, 0x40, 0x3f, 0xff,
    0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x4f, 0xff, 0xff, 0xff, 0x40, 0x3, 0xef,
    0xff, 0xff, 0x40, 0x0, 0x2e, 0xff, 0xff, 0x30,
    0x0, 0x1, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd,
    0x40, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0x7f, 0xff, 0xf7, 0x0, 0x7f, 0xff,
    0xf7,

    /* U+F04D "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x10, 0x0,
    0x3, 0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xff,
    0xfe, 0x30, 0x4, 0xff, 0xff, 0xff, 0xf4, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x54, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff,
    0xff, 0xf3, 0x4, 0xff, 0xff, 0xfe, 0x30, 0x4,
    0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xcc, 0x10,
    0x0, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x1a, 0x40, 0x0, 0x0, 0x1,
    0xdf, 0xf0, 0x0, 0x0, 0x1d, 0xff, 0xa0, 0x0,
    0x1, 0xdf, 0xfa, 0x0, 0x0, 0x1d, 0xff, 0xa0,
    0x0, 0x1, 0xdf, 0xfa, 0x0, 0x0, 0xc, 0xff,
    0xa0, 0x0, 0x0, 0xd, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xdf, 0xf8, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0x80, 0x0, 0x0, 0x1, 0xdf, 0xf8, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x80, 0x0, 0x0, 0x1, 0xdf,
    0xf0, 0x0, 0x0, 0x0, 0x1b, 0x50,

    /* U+F054 "" */
    0x4, 0xa1, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x10,
    0x0, 0x0, 0xa, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0x10, 0x0, 0x0, 0xa, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xaf, 0xfd, 0x10, 0x0, 0x0,
    0xa, 0xff, 0xc0, 0x0, 0x0, 0x8, 0xff, 0xd0,
    0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8, 0xff,
    0xd1, 0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8,
    0xff, 0xd1, 0x0, 0x0, 0xf, 0xfd, 0x10, 0x0,
    0x0, 0x5, 0xb1, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x48, 0x88, 0x8c, 0xff, 0xc8,
    0x88, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x48, 0x88, 0x8c, 0xff, 0xc8, 0x88, 0x84, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x40,
    0x0, 0x0,

    /* U+F068 "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7,

    /* U+F06E "" */
    0x0, 0x0, 0x5, 0xad, 0xff, 0xda, 0x50, 0x0,
    0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf, 0xfd,
    0x40, 0x0, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4,
    0xef, 0xf7, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x9e,
    0x80, 0x4f, 0xff, 0x70, 0x4f, 0xff, 0xc0, 0x0,
    0xaf, 0xf8, 0xc, 0xff, 0xf4, 0xdf, 0xff, 0x80,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0xdf, 0xff,
    0x80, 0xef, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0x4f,
    0xff, 0xc0, 0x8f, 0xff, 0xf8, 0xc, 0xff, 0xf4,
    0x7, 0xff, 0xf4, 0x8, 0xee, 0x80, 0x4f, 0xff,
    0x70, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4, 0xef,
    0xf8, 0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf,
    0xfd, 0x40, 0x0, 0x0, 0x0, 0x5, 0xad, 0xff,
    0xda, 0x50, 0x0, 0x0,

    /* U+F070 "" */
    0x8c, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0x80, 0x49,
    0xdf, 0xfd, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xd8, 0x8c, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x4, 0xef, 0xf8, 0x0, 0x0, 0x4e, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x1c, 0xff, 0x69, 0xe8,
    0x4, 0xff, 0xf7, 0x0, 0x4, 0xe3, 0x0, 0x9f,
    0xfe, 0xff, 0x80, 0xcf, 0xff, 0x40, 0xd, 0xff,
    0x70, 0x5, 0xff, 0xff, 0xe0, 0x8f, 0xff, 0xd0,
    0xd, 0xff, 0xf7, 0x0, 0x2d, 0xff, 0xe0, 0x8f,
    0xff, 0xd0, 0x4, 0xff, 0xfc, 0x0, 0x0, 0xaf,
    0xf8, 0xcf, 0xff, 0x30, 0x0, 0x7f, 0xff, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x8,
    0xff, 0xf4, 0x0, 0x0, 0x3e, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x4d, 0xff, 0xc8, 0x82, 0x1, 0xbf,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xdf, 0xfc,
    0x10, 0x8, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc8,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xd8, 0x8d,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xa0, 0xa, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xb0, 0xb, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xc0, 0xc, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xd0, 0xd,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xf9, 0x9f, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xe2, 0x2e, 0xff, 0xff, 0xf8, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x90, 0x9, 0xff, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xff, 0xe3, 0x3e,
    0xff, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0x78, 0x8e, 0xff, 0x15, 0xff, 0xe8, 0xff, 0xe2,
    0x0, 0x2, 0xe5, 0x4f, 0xfe, 0x20, 0xfe, 0x20,
    0x0, 0x0, 0x13, 0xff, 0xf3, 0x0, 0x52, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0x31, 0x0, 0x52, 0x0,
    0x0, 0x2, 0xef, 0xf4, 0x5e, 0x20, 0xfe, 0x20,
    0x78, 0x8e, 0xff, 0x51, 0xff, 0xe8, 0xff, 0xe2,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x1d, 0xff, 0x99,
    0xff, 0xd1, 0x0, 0x1, 0xdf, 0xf9, 0x0, 0x9f,
    0xfd, 0x10, 0x1d, 0xff, 0x90, 0x0, 0x9, 0xff,
    0xd1, 0xbf, 0xf9, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x5f, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F078 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0xbf, 0xf9,
    0x0, 0x0, 0x0, 0x9f, 0xfb, 0x1d, 0xff, 0x90,
    0x0, 0x9, 0xff, 0xd1, 0x1, 0xdf, 0xf9, 0x0,
    0x9f, 0xfd, 0x10, 0x0, 0x1d, 0xff, 0x99, 0xff,
    0xd1, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfd, 0x10,
    0xef, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x1d, 0xff,
    0xff, 0xd1, 0xaf, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x6b, 0x1f, 0xf1, 0xb6, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x6b, 0x1f,
    0xf1, 0xb6, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfa, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xfe, 0x1, 0xdf, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x8f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xf0, 0xdf, 0xfd, 0xf, 0xff, 0xfd,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xea,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0x30, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x8f,
    0xf3, 0x0, 0x6f, 0xff, 0xd0, 0x0, 0xa, 0xff,
    0xff, 0xe4, 0xbf, 0xff, 0xd1, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xdb, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x8, 0xee, 0x80, 0x0, 0x0, 0x6, 0x61, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x2d, 0xff, 0xd0, 0xef,
    0x33, 0xfe, 0x0, 0x2e, 0xff, 0xf3, 0xe, 0xf3,
    0x3f, 0xe0, 0x2e, 0xff, 0xf3, 0x0, 0x8f, 0xff,
    0xff, 0x6e, 0xff, 0xf3, 0x0, 0x0, 0x8e, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x8, 0xff, 0xff, 0xf6, 0xef,
    0xff, 0x30, 0x0, 0xef, 0x33, 0xfe, 0x2, 0xef,
    0xff, 0x30, 0xe, 0xf3, 0x3f, 0xe0, 0x2, 0xef,
    0xff, 0x30, 0x8f, 0xff, 0xf8, 0x0, 0x2, 0xdf,
    0xfd, 0x0, 0x8e, 0xe8, 0x0, 0x0, 0x0, 0x66,
    0x10,

    /* U+F0C5 "" */
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xd, 0x20, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf, 0xe2, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf, 0xfd, 0xdf, 0xf0, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,

    /* U+F0C7 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xe2, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x11, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x11, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F0E7 "" */
    0x0, 0xdf, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x20,
    0xd, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xe0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x2f, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x4, 0xee, 0x40, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0x99, 0xff, 0xfd, 0x0, 0x0, 0xff, 0xff,
    0x99, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xd, 0xff, 0xff,
    0xd, 0x20, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf,
    0xe2, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf, 0xfd,
    0xff, 0xff, 0xf, 0xff, 0xff, 0x20, 0x0, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfd,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0xfc, 0x20, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xee, 0x40, 0x0, 0x0,

    /* U+F11C "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x8,
    0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff, 0xf8,
    0x8, 0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xff, 0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x17,
    0xef, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x2a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0xdf, 0xff, 0xff, 0xf0, 0xd2, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0xfe, 0x20, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xe2, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x9c, 0xef, 0xfe,
    0xc9, 0x40, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x70, 0x0, 0x4, 0xdf,
    0xff, 0xfc, 0xa8, 0x8a, 0xcf, 0xff, 0xfd, 0x40,
    0x6f, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0xff, 0xf6, 0xcf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfc, 0x1a, 0x30, 0x0, 0x5a,
    0xdf, 0xfd, 0xa5, 0x0, 0x3, 0xa1, 0x0, 0x0,
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xa8, 0x8a, 0xef, 0xff,
    0x50, 0x0, 0x0, 0x1, 0xdf, 0x70, 0x0, 0x0,
    0x7, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F241 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F242 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F243 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F244 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x29, 0xfe, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x80, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0xdf,
    0xff, 0x77, 0xf7, 0x55, 0x55, 0x55, 0x55, 0x8f,
    0xd3, 0xf, 0xff, 0xfd, 0xcc, 0xdf, 0xdc, 0xcc,
    0xcc, 0xcd, 0xff, 0xb0, 0x8f, 0xfe, 0x10, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x4d, 0x40, 0x0, 0x46,
    0x10, 0x0, 0x1, 0xf2, 0x2, 0x33, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb1, 0xcf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x22,
    0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x2, 0xef,
    0xfb, 0xef, 0xff, 0x30, 0xd, 0xff, 0xfa, 0x2e,
    0xff, 0xe0, 0x4f, 0xff, 0xfa, 0x3, 0xff, 0xf5,
    0x9f, 0xfa, 0xfa, 0x35, 0x4f, 0xfa, 0xcf, 0xc0,
    0x8a, 0x3d, 0xb, 0xfd, 0xef, 0xfb, 0x3, 0x12,
    0x8f, 0xfe, 0xff, 0xff, 0xb0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xd1, 0x8, 0xff, 0xff, 0xef, 0xfd,
    0x11, 0x10, 0x9f, 0xff, 0xdf, 0xd1, 0x59, 0x3b,
    0xb, 0xfd, 0xaf, 0xd7, 0xfa, 0x38, 0x1d, 0xfb,
    0x5f, 0xff, 0xfa, 0x1, 0xdf, 0xf7, 0xd, 0xff,
    0xfa, 0x1d, 0xff, 0xf1, 0x3, 0xef, 0xfc, 0xdf,
    0xff, 0x50, 0x0, 0x18, 0xdf, 0xfe, 0xa3, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x7f, 0xff, 0xf7, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9, 0x9f,
    0xf0, 0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0,
    0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf,
    0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8,
    0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f,
    0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f, 0x88,
    0xf8, 0x8f, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9,
    0x9f, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x8a, 0x1d,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfa,
    0x1d, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xfa, 0x1d, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xde, 0xdb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfa, 0xef, 0xfe, 0xaf, 0xff, 0xff, 0x1, 0xdf,
    0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa, 0xff, 0xff,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e,
    0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x2, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x2, 0xef, 0xff, 0xff, 0x1d, 0xff,
    0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e, 0xff, 0xff,
    0x1, 0xdf, 0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xfa, 0xef,
    0xfe, 0xaf, 0xff, 0xff, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F7C2 "" */
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xfe, 0x8, 0xf8, 0xf, 0xb,
    0x40, 0xff, 0x8f, 0xf8, 0xf, 0xb, 0x40, 0xff,
    0xff, 0xf8, 0xf, 0xb, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x2,
    0xef, 0x10, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x11, 0xcf, 0xff, 0x77, 0x77, 0x77,
    0x77, 0xbf, 0xf1, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x17, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 63, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 66, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12, .adv_w = 82, .box_w = 4, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 22, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 82, .adv_w = 144, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 154, .adv_w = 188, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 226, .adv_w = 159, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 286, .adv_w = 45, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 290, .adv_w = 88, .box_w = 5, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 335, .adv_w = 89, .box_w = 5, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 380, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 405, .adv_w = 145, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 446, .adv_w = 50, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 454, .adv_w = 71, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 462, .adv_w = 67, .box_w = 2, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 464, .adv_w = 106, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 510, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 564, .adv_w = 144, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 594, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 648, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 696, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 750, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 798, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 846, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 900, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 954, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1002, .adv_w = 62, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1011, .adv_w = 54, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1029, .adv_w = 130, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1057, .adv_w = 141, .box_w = 7, .box_h = 6, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1078, .adv_w = 134, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1106, .adv_w = 121, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1148, .adv_w = 230, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1253, .adv_w = 167, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1319, .adv_w = 159, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1373, .adv_w = 167, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1433, .adv_w = 168, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1487, .adv_w = 146, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1535, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1583, .adv_w = 174, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1643, .adv_w = 183, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1703, .adv_w = 70, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1715, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1763, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1823, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1871, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1943, .adv_w = 183, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2003, .adv_w = 176, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2069, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2123, .adv_w = 176, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2200, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2254, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2308, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2368, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2422, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2482, .adv_w = 227, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2566, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2626, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2686, .adv_w = 153, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2740, .adv_w = 68, .box_w = 4, .box_h = 18, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2776, .adv_w = 105, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2822, .adv_w = 68, .box_w = 4, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2858, .adv_w = 107, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 2879, .adv_w = 116, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2891, .adv_w = 79, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 2897, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2933, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2981, .adv_w = 134, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3017, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3065, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3101, .adv_w = 89, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3143, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3191, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3233, .adv_w = 62, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3245, .adv_w = 61, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3275, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3323, .adv_w = 62, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3335, .adv_w = 224, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3389, .adv_w = 141, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3421, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3462, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3510, .adv_w = 146, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3558, .adv_w = 87, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3583, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3619, .adv_w = 84, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3647, .adv_w = 141, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3679, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3715, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3769, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3805, .adv_w = 121, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3853, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3889, .adv_w = 87, .box_w = 6, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3940, .adv_w = 62, .box_w = 2, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3954, .adv_w = 87, .box_w = 5, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3997, .adv_w = 174, .box_w = 9, .box_h = 5, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 4020, .adv_w = 63, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4020, .adv_w = 62, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4032, .adv_w = 140, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4084, .adv_w = 149, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4138, .adv_w = 183, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4204, .adv_w = 134, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4258, .adv_w = 61, .box_w = 2, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4272, .adv_w = 157, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 4349, .adv_w = 107, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4355, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4427, .adv_w = 114, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 4445, .adv_w = 120, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4470, .adv_w = 142, .box_w = 7, .box_h = 5, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 4488, .adv_w = 71, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4496, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4568, .adv_w = 117, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 4574, .adv_w = 96, .box_w = 4, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 4584, .adv_w = 137, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4624, .adv_w = 94, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4642, .adv_w = 94, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4660, .adv_w = 80, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4668, .adv_w = 145, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4710, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4752, .adv_w = 67, .box_w = 2, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 4754, .adv_w = 63, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4762, .adv_w = 94, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4776, .adv_w = 116, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4797, .adv_w = 120, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4822, .adv_w = 188, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4894, .adv_w = 199, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4972, .adv_w = 199, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5044, .adv_w = 121, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5086, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5169, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5252, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5335, .adv_w = 167, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5423, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5506, .adv_w = 167, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5594, .adv_w = 239, .box_w = 16, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5690, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5765, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5825, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5885, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5945, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6005, .adv_w = 70, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6043, .adv_w = 70, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6073, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6118, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6163, .adv_w = 172, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6223, .adv_w = 183, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6303, .adv_w = 176, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6391, .adv_w = 176, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6479, .adv_w = 176, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6567, .adv_w = 176, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6655, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6738, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6774, .adv_w = 176, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6846, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6914, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6982, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7050, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7118, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7193, .adv_w = 151, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7241, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7289, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7337, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7385, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7433, .adv_w = 139, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7485, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7533, .adv_w = 139, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7589, .adv_w = 216, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7648, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7696, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7744, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7792, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7840, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7888, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7912, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7936, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7972, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8008, .adv_w = 150, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8067, .adv_w = 141, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8113, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8167, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8221, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8275, .adv_w = 146, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8334, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8388, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8429, .adv_w = 145, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8479, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8521, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8563, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8605, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8647, .adv_w = 121, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8707, .adv_w = 148, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 8767, .adv_w = 121, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8827, .adv_w = 167, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8904, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8952, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9035, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9083, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9166, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9214, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9294, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9342, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9422, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9470, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9545, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9593, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9673, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9721, .adv_w = 168, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9789, .adv_w = 163, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9855, .adv_w = 172, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9915, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9975, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10035, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10083, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10143, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10191, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10251, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10299, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 10359, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10407, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10467, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10515, .adv_w = 174, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10595, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10655, .adv_w = 174, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10730, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10790, .adv_w = 174, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10865, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10925, .adv_w = 174, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 11010, .adv_w = 144, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11082, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11157, .adv_w = 141, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11210, .adv_w = 179, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11282, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11336, .adv_w = 70, .box_w = 6, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11384, .adv_w = 63, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11423, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11468, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11504, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11549, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11585, .adv_w = 70, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11608, .adv_w = 62, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 11638, .adv_w = 70, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11661, .adv_w = 63, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11670, .adv_w = 211, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11736, .adv_w = 123, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11781, .adv_w = 141, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11856, .adv_w = 64, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 11901, .adv_w = 161, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11981, .adv_w = 130, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12045, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12081, .adv_w = 138, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12141, .adv_w = 62, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12173, .adv_w = 138, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 12241, .adv_w = 62, .box_w = 3, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 12267, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12315, .adv_w = 81, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12345, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12393, .adv_w = 90, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12423, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12477, .adv_w = 69, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12507, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12582, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12624, .adv_w = 183, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 12709, .adv_w = 141, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 12758, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12833, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12875, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12929, .adv_w = 177, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12997, .adv_w = 145, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13039, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13122, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13176, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13259, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13313, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13396, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13450, .adv_w = 244, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13540, .adv_w = 233, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13603, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13671, .adv_w = 87, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13701, .adv_w = 158, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 13778, .adv_w = 87, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13823, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13891, .adv_w = 87, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13927, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13999, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14047, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14119, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14167, .adv_w = 152, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14235, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14283, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14355, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14403, .adv_w = 153, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14478, .adv_w = 84, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14523, .adv_w = 153, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14598, .adv_w = 89, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14640, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14700, .adv_w = 84, .box_w = 6, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14733, .adv_w = 166, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14805, .adv_w = 141, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14851, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14919, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14961, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15029, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15071, .adv_w = 166, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15143, .adv_w = 141, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15192, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15260, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15308, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 15376, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 15418, .adv_w = 227, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15523, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15595, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15670, .adv_w = 121, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15730, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15805, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15873, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15921, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15989, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16037, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16105, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16153, .adv_w = 64, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16188, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16324, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16420, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 16532, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16628, .adv_w = 176, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16694, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16822, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16950, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17076, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17204, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17312, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17440, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17496, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 17580, .adv_w = 288, .box_w = 18, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17724, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17820, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 17900, .adv_w = 224, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 18026, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18131, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18229, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 18309, .adv_w = 224, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 18421, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18491, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18561, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18659, .adv_w = 224, .box_w = 14, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 18687, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18795, .adv_w = 320, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18955, .adv_w = 288, .box_w = 20, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 19115, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19243, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 19313, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 19383, .adv_w = 320, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19523, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19619, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19747, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 19892, .adv_w = 224, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19997, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20109, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20207, .adv_w = 160, .box_w = 12, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 20303, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20415, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20527, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20635, .adv_w = 256, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 20797, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20893, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21043, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 21143, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 21243, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 21343, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 21443, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 21543, .adv_w = 320, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 21690, .adv_w = 224, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21786, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21898, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 22043, .adv_w = 320, .box_w = 20, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22163, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22259, .adv_w = 258, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, -7, 0,
    -2, -8, 0, -10, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    2, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -28,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    -8, 0, -1, 0, 0, -16, -2, -11,
    -9, 0, -12, 0, 0, 0, 0, 0,
    0, -1, 0, 0, -2, -1, -6, -4,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -3,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, -3, 0, 0, 0, -3, 0, -3,
    0, -3, -5, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, -2, -2,
    0, -2, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -29, 0, 0,
    0, -21, 0, -33, 0, 3, 0, 0,
    0, 0, 0, 0, 0, -4, -3, 0,
    0, -3, -3, 0, 0, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -4, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -3, -3, 0, 0, 0, -3, -5, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -42, 0, 0, 0, 0, 0, 0,
    0, 2, -8, 0, 0, -34, -7, -22,
    -18, 0, -30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -17, -11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -40, 0, 0,
    0, -17, 0, -25, 0, 0, 0, 0,
    0, -4, 0, -3, 0, -1, -2, 0,
    0, -2, 0, 0, 2, 0, 2, 0,
    0, 0, 0, 0, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -3,
    -2, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, -2,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, -27, -29, 0,
    0, -10, -3, -30, -2, 2, 0, 2,
    2, 0, 2, 0, 0, -14, -12, 0,
    -14, -12, -9, -14, 0, -12, -9, -7,
    -10, -7, 0, -41, -27, -22, -14, -12,
    0, 0, 0, 3, 0, -28, -5, 0,
    0, -9, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -6, -5, 0,
    0, -6, -4, 0, 0, -3, -1, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -15, -7, 0,
    0, -5, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 2, -4, -4, 0,
    0, -4, -3, 0, 0, -2, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -6, 0,
    0, 0, -3, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -3, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 3, -6, -26, -6, 0,
    0, -12, -4, -12, -2, 2, -12, 2,
    2, 2, 2, 0, 2, -9, -8, -3,
    -5, -8, -5, -7, -3, -5, -2, 0,
    -3, -4, 2, -10, -6, -12, -8, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, -3, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -2, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -3, -2, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -2, 2,
    0, -2, 0, 0, 6, 0, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 2,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_16 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 21,          /*The maximum line height required by the font*/
    .base_line = 5,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_16*/


