#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 12 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_12
#define RB_LV_FONT_ROBOTO_12 1
#endif

#if RB_LV_FONT_ROBOTO_12

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xf, 0x10, 0xf1, 0xf, 0x10, 0xf1, 0xf, 0x0,
    0xf0, 0x9, 0x0, 0x30, 0xe, 0x10,

    /* U+22 "\"" */
    0x39, 0x93, 0x39, 0x92, 0x38, 0x91, 0x1, 0x10,

    /* U+23 "#" */
    0x0, 0xc, 0x7, 0x60, 0x0, 0x1c, 0xa, 0x20,
    0xc, 0xee, 0xef, 0xe3, 0x0, 0x76, 0x1c, 0x0,
    0x0, 0xa3, 0x49, 0x0, 0x4e, 0xfe, 0xee, 0xb0,
    0x0, 0xd0, 0x93, 0x0, 0x2, 0xb0, 0xc1, 0x0,
    0x4, 0x80, 0xd0, 0x0,

    /* U+24 "$" */
    0x0, 0xd, 0x0, 0x0, 0x6, 0xf6, 0x0, 0xa,
    0xc7, 0xd8, 0x0, 0xf2, 0x3, 0xe0, 0xe, 0x40,
    0x5, 0x0, 0x6f, 0x81, 0x0, 0x0, 0x3a, 0xf5,
    0x0, 0x0, 0x4, 0xe0, 0x4d, 0x0, 0xf, 0x0,
    0xe7, 0x4a, 0xc0, 0x2, 0xaf, 0x91, 0x0, 0x0,
    0xd0, 0x0,

    /* U+25 "%" */
    0xb, 0xc8, 0x0, 0x0, 0x5, 0x80, 0xc0, 0x28,
    0x0, 0x58, 0xd, 0xb, 0x10, 0x0, 0x9c, 0x65,
    0x70, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0,
    0x94, 0x8c, 0x80, 0x0, 0x3a, 0x2b, 0xa, 0x30,
    0xb, 0x12, 0xa0, 0xa3, 0x0, 0x0, 0xa, 0xca,
    0x0,

    /* U+26 "&" */
    0x2, 0xcf, 0xb0, 0x0, 0x9, 0x90, 0xb6, 0x0,
    0x9, 0x80, 0xc4, 0x0, 0x3, 0xec, 0x80, 0x0,
    0x4, 0xee, 0x0, 0x30, 0x2e, 0x29, 0xb2, 0xd0,
    0x5b, 0x0, 0xcc, 0x90, 0x2e, 0x10, 0x5f, 0x50,
    0x5, 0xdd, 0xc7, 0xe1,

    /* U+27 "'" */
    0x67, 0x67, 0x66, 0x0,

    /* U+28 "(" */
    0x0, 0x2, 0x0, 0x5a, 0x1, 0xd0, 0x8, 0x80,
    0xd, 0x30, 0x1f, 0x0, 0x2e, 0x0, 0x3e, 0x0,
    0x2f, 0x0, 0xf, 0x10, 0xb, 0x50, 0x5, 0xa0,
    0x0, 0xb3, 0x0, 0x19,

    /* U+29 ")" */
    0x20, 0x0, 0x87, 0x0, 0xd, 0x20, 0x7, 0x90,
    0x2, 0xf0, 0x0, 0xe2, 0x0, 0xc4, 0x0, 0xc4,
    0x0, 0xd3, 0x0, 0xf1, 0x3, 0xd0, 0x9, 0x60,
    0x2c, 0x0, 0x82, 0x0,

    /* U+2A "*" */
    0x0, 0xd0, 0x4, 0x1c, 0x4, 0x7d, 0xfe, 0x90,
    0x6e, 0x80, 0x1d, 0x1d, 0x20, 0x10, 0x10,

    /* U+2B "+" */
    0x0, 0x1b, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0,
    0x2e, 0x0, 0x8, 0xff, 0xff, 0xf4, 0x12, 0x4e,
    0x22, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e, 0x0,
    0x0,

    /* U+2C "," */
    0x4c, 0x5b, 0xa4, 0x0,

    /* U+2D "-" */
    0xbf, 0xf1,

    /* U+2E "." */
    0x4, 0x1, 0xe1,

    /* U+2F "/" */
    0x0, 0x8, 0x60, 0x0, 0xd1, 0x0, 0x3b, 0x0,
    0x9, 0x50, 0x0, 0xd0, 0x0, 0x4a, 0x0, 0xa,
    0x40, 0x0, 0xd0, 0x0, 0x59, 0x0, 0xb, 0x30,
    0x0,

    /* U+30 "0" */
    0x3, 0xde, 0xb1, 0x0, 0xe5, 0x9, 0xa0, 0x3d,
    0x0, 0x2e, 0x4, 0xc0, 0x0, 0xf0, 0x5c, 0x0,
    0xf, 0x14, 0xc0, 0x0, 0xf0, 0x3e, 0x0, 0x2f,
    0x0, 0xe5, 0x9, 0xa0, 0x3, 0xdf, 0xb1, 0x0,

    /* U+31 "1" */
    0x5, 0xc4, 0xea, 0xe4, 0x10, 0xd4, 0x0, 0xd4,
    0x0, 0xd4, 0x0, 0xd4, 0x0, 0xd4, 0x0, 0xd4,
    0x0, 0xd4,

    /* U+32 "2" */
    0x5, 0xdf, 0xb2, 0x2, 0xe3, 0x9, 0xb0, 0x48,
    0x0, 0x3d, 0x0, 0x0, 0x7, 0x90, 0x0, 0x2,
    0xe1, 0x0, 0x1, 0xd4, 0x0, 0x0, 0xc6, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x40,

    /* U+33 "3" */
    0x5, 0xde, 0xb1, 0x2e, 0x20, 0x99, 0x25, 0x0,
    0x4c, 0x0, 0x0, 0xa8, 0x0, 0xbf, 0xd1, 0x0,
    0x0, 0x8a, 0x24, 0x0, 0x2e, 0x3e, 0x20, 0x8b,
    0x6, 0xef, 0xb1,

    /* U+34 "4" */
    0x0, 0x3, 0xf4, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x6a, 0xc4, 0x0, 0x1d, 0x1c, 0x40, 0x9, 0x70,
    0xc4, 0x3, 0xd0, 0xc, 0x40, 0xaf, 0xff, 0xff,
    0x70, 0x0, 0xc, 0x40, 0x0, 0x0, 0xc4, 0x0,

    /* U+35 "5" */
    0x6, 0xff, 0xff, 0x0, 0x88, 0x11, 0x10, 0x9,
    0x60, 0x0, 0x0, 0xbc, 0xec, 0x30, 0x6, 0x62,
    0x8e, 0x0, 0x0, 0x0, 0xe3, 0x7, 0x0, 0xd,
    0x30, 0xd6, 0x5, 0xe0, 0x2, 0xcf, 0xd3, 0x0,

    /* U+36 "6" */
    0x0, 0x5d, 0xf0, 0x0, 0x5e, 0x40, 0x0, 0xd,
    0x40, 0x0, 0x1, 0xf9, 0xec, 0x20, 0x3f, 0x60,
    0x7d, 0x3, 0xe0, 0x0, 0xf1, 0x1f, 0x0, 0xf,
    0x10, 0xb8, 0x7, 0xd0, 0x1, 0xbf, 0xc2, 0x0,

    /* U+37 "7" */
    0x8f, 0xff, 0xff, 0x30, 0x0, 0x2, 0xd0, 0x0,
    0x0, 0x97, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7,
    0x90, 0x0, 0x0, 0xe2, 0x0, 0x0, 0x5b, 0x0,
    0x0, 0xc, 0x50, 0x0, 0x3, 0xe0, 0x0, 0x0,

    /* U+38 "8" */
    0x3, 0xdf, 0xb1, 0x0, 0xe5, 0x9, 0xa0, 0x1f,
    0x0, 0x3d, 0x0, 0xd5, 0x9, 0x90, 0x4, 0xff,
    0xe1, 0x1, 0xe4, 0x7, 0xb0, 0x4c, 0x0, 0xf,
    0x2, 0xe3, 0x6, 0xd0, 0x5, 0xdf, 0xc2, 0x0,

    /* U+39 "9" */
    0x5, 0xde, 0x90, 0x1f, 0x30, 0xc7, 0x5b, 0x0,
    0x4c, 0x5b, 0x0, 0x2e, 0x1f, 0x30, 0xae, 0x5,
    0xee, 0x8d, 0x0, 0x0, 0x79, 0x0, 0x15, 0xe2,
    0x3, 0xfc, 0x30,

    /* U+3A ":" */
    0x1e, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x40, 0x1e, 0x0,

    /* U+3B ";" */
    0x3d, 0x4, 0x0, 0x0, 0x0, 0x18, 0x3d, 0x79,
    0x50,

    /* U+3C "<" */
    0x0, 0x2, 0x93, 0x2, 0x9f, 0x91, 0x6e, 0x71,
    0x0, 0x4d, 0xa3, 0x0, 0x0, 0x6e, 0xc1, 0x0,
    0x0, 0x62,

    /* U+3D "=" */
    0x1e, 0xee, 0xeb, 0x1, 0x11, 0x11, 0x0, 0x0,
    0x0, 0x1e, 0xee, 0xeb, 0x1, 0x11, 0x11,

    /* U+3E ">" */
    0x3a, 0x20, 0x0, 0x8, 0xea, 0x30, 0x0, 0x6,
    0xd9, 0x0, 0x3a, 0xe6, 0x1c, 0xe7, 0x0, 0x26,
    0x0, 0x0,

    /* U+3F "?" */
    0x9, 0xfe, 0x50, 0x6c, 0x13, 0xf0, 0x11, 0x0,
    0xf1, 0x0, 0x5, 0xc0, 0x0, 0x4e, 0x20, 0x0,
    0xc5, 0x0, 0x0, 0x51, 0x0, 0x0, 0x30, 0x0,
    0x0, 0xc3, 0x0,

    /* U+40 "@" */
    0x0, 0x6, 0xcd, 0xd9, 0x10, 0x0, 0x9, 0x91,
    0x0, 0x4c, 0x10, 0x5, 0x90, 0x0, 0x0, 0x39,
    0x0, 0xc1, 0x5, 0xdc, 0x30, 0xb0, 0x1c, 0x3,
    0xd0, 0x76, 0x9, 0x13, 0x90, 0x86, 0x9, 0x40,
    0x92, 0x48, 0xb, 0x30, 0xa3, 0xa, 0x13, 0x90,
    0xb4, 0xe, 0x31, 0xb0, 0xc, 0x4, 0xda, 0x5d,
    0xb2, 0x0, 0xb3, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd4, 0x0, 0x11, 0x0, 0x0, 0x2, 0xac, 0xcc,
    0x30, 0x0,

    /* U+41 "A" */
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xb7,

    /* U+42 "B" */
    0xf, 0xff, 0xe8, 0x0, 0xf1, 0x2, 0xd5, 0xf,
    0x10, 0x9, 0x80, 0xf1, 0x2, 0xe4, 0xf, 0xff,
    0xfb, 0x0, 0xf1, 0x1, 0xb8, 0xf, 0x10, 0x5,
    0xc0, 0xf1, 0x1, 0xb9, 0xf, 0xff, 0xea, 0x0,

    /* U+43 "C" */
    0x0, 0x8e, 0xea, 0x10, 0x9, 0xc2, 0x9, 0xc0,
    0x1f, 0x20, 0x0, 0xe2, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0xe2, 0x9, 0xb1, 0x18, 0xc0,
    0x0, 0x9f, 0xea, 0x10,

    /* U+44 "D" */
    0xf, 0xff, 0xd5, 0x0, 0xf, 0x10, 0x4e, 0x50,
    0xf, 0x10, 0x4, 0xd0, 0xf, 0x10, 0x0, 0xf1,
    0xf, 0x10, 0x0, 0xf2, 0xf, 0x10, 0x0, 0xf1,
    0xf, 0x10, 0x5, 0xd0, 0xf, 0x10, 0x4e, 0x50,
    0xf, 0xff, 0xd5, 0x0,

    /* U+45 "E" */
    0xf, 0xff, 0xff, 0x50, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff,
    0xfd, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x60,

    /* U+46 "F" */
    0xf, 0xff, 0xff, 0x40, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff,
    0xfa, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x9e, 0xfb, 0x20, 0x9, 0xc2, 0x7, 0xe0,
    0xf, 0x20, 0x0, 0x61, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0xcf, 0xf4, 0x3e, 0x0, 0x0, 0xd4,
    0xf, 0x20, 0x0, 0xd4, 0x8, 0xd2, 0x4, 0xf3,
    0x0, 0x7e, 0xfd, 0x60,

    /* U+48 "H" */
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0xff, 0xff, 0xf8, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98,

    /* U+49 "I" */
    0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3,
    0xe3,

    /* U+4A "J" */
    0x0, 0x0, 0x7b, 0x0, 0x0, 0x7b, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x7b, 0x0,
    0x0, 0x7b, 0x64, 0x0, 0x7a, 0x7c, 0x11, 0xd6,
    0x9, 0xee, 0x90,

    /* U+4B "K" */
    0xf, 0x10, 0x8, 0xc0, 0xf, 0x10, 0x6e, 0x10,
    0xf, 0x13, 0xe3, 0x0, 0xf, 0x4e, 0x40, 0x0,
    0xf, 0xef, 0x40, 0x0, 0xf, 0x85, 0xe1, 0x0,
    0xf, 0x10, 0x9b, 0x0, 0xf, 0x10, 0xd, 0x70,
    0xf, 0x10, 0x3, 0xf3,

    /* U+4C "L" */
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+4D "M" */
    0xf, 0xa0, 0x0, 0x2, 0xf7, 0xf, 0xf0, 0x0,
    0x8, 0xf7, 0xf, 0xb6, 0x0, 0xe, 0xb7, 0xf,
    0x5c, 0x0, 0x4c, 0x97, 0xf, 0x1e, 0x20, 0xb6,
    0x97, 0xf, 0x18, 0x81, 0xe0, 0xa7, 0xf, 0x12,
    0xe7, 0x90, 0xa7, 0xf, 0x10, 0xcf, 0x30, 0xa7,
    0xf, 0x10, 0x6d, 0x0, 0xa7,

    /* U+4E "N" */
    0xf, 0x60, 0x0, 0x98, 0xf, 0xf1, 0x0, 0x98,
    0xf, 0xba, 0x0, 0x98, 0xf, 0x3e, 0x40, 0x98,
    0xf, 0x25, 0xd0, 0x98, 0xf, 0x20, 0xb8, 0x98,
    0xf, 0x20, 0x2f, 0xb8, 0xf, 0x20, 0x8, 0xf8,
    0xf, 0x20, 0x0, 0xd8,

    /* U+4F "O" */
    0x0, 0x8e, 0xfa, 0x10, 0x9, 0xc3, 0x29, 0xd0,
    0x1f, 0x20, 0x0, 0xd4, 0x3e, 0x0, 0x0, 0xa7,
    0x4d, 0x0, 0x0, 0x98, 0x4e, 0x0, 0x0, 0xa7,
    0x1f, 0x20, 0x0, 0xd4, 0x9, 0xc2, 0x19, 0xd0,
    0x0, 0x8e, 0xfb, 0x10,

    /* U+50 "P" */
    0xf, 0xff, 0xfb, 0x20, 0xf, 0x10, 0x8, 0xd0,
    0xf, 0x10, 0x0, 0xf1, 0xf, 0x10, 0x7, 0xe0,
    0xf, 0xff, 0xfc, 0x30, 0xf, 0x10, 0x0, 0x0,
    0xf, 0x10, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,
    0xf, 0x10, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x9e, 0xfa, 0x10, 0xa, 0xc2, 0x2a, 0xc0,
    0x1f, 0x10, 0x0, 0xe3, 0x4d, 0x0, 0x0, 0xb6,
    0x5c, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0xb7,
    0x1f, 0x10, 0x0, 0xe3, 0xa, 0xb2, 0x19, 0xc0,
    0x0, 0x9e, 0xff, 0x50, 0x0, 0x0, 0x5, 0xf3,
    0x0, 0x0, 0x0, 0x20,

    /* U+52 "R" */
    0xf, 0xff, 0xe9, 0x0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0x10, 0x6, 0xc0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0xff, 0xf9, 0x0, 0xf, 0x10, 0xa8, 0x0,
    0xf, 0x10, 0x2e, 0x0, 0xf, 0x10, 0xb, 0x70,
    0xf, 0x10, 0x4, 0xe0,

    /* U+53 "S" */
    0x4, 0xcf, 0xd6, 0x1, 0xf5, 0x3, 0xe5, 0x3e,
    0x0, 0x5, 0x60, 0xd9, 0x20, 0x0, 0x1, 0x8e,
    0xc4, 0x0, 0x0, 0x5, 0xe5, 0x57, 0x0, 0x8,
    0xa3, 0xf4, 0x2, 0xc7, 0x4, 0xcf, 0xe8, 0x0,

    /* U+54 "T" */
    0xbf, 0xff, 0xff, 0xe0, 0x0, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+55 "U" */
    0x2f, 0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f,
    0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3,
    0xe0, 0xc9, 0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+56 "V" */
    0xa8, 0x0, 0x0, 0xe4, 0x4d, 0x0, 0x3, 0xe0,
    0xe, 0x20, 0x8, 0x90, 0x9, 0x80, 0xd, 0x40,
    0x4, 0xd0, 0x3e, 0x0, 0x0, 0xe2, 0x88, 0x0,
    0x0, 0x87, 0xd3, 0x0, 0x0, 0x3e, 0xd0, 0x0,
    0x0, 0xd, 0x70, 0x0,

    /* U+57 "W" */
    0x89, 0x0, 0x3f, 0x0, 0xd, 0x44, 0xc0, 0x7,
    0xf4, 0x1, 0xf0, 0x1f, 0x0, 0xca, 0x80, 0x4d,
    0x0, 0xd3, 0xe, 0x3c, 0x7, 0x90, 0x9, 0x74,
    0xb0, 0xe0, 0xb5, 0x0, 0x6a, 0x86, 0xa, 0x5e,
    0x20, 0x2, 0xed, 0x20, 0x6a, 0xe0, 0x0, 0xe,
    0xd0, 0x1, 0xfa, 0x0, 0x0, 0xb9, 0x0, 0xd,
    0x70, 0x0,

    /* U+58 "X" */
    0x4e, 0x10, 0x7, 0xd0, 0xb, 0x90, 0x1f, 0x30,
    0x2, 0xf2, 0x9a, 0x0, 0x0, 0x7d, 0xe1, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0x0, 0x8d, 0xf1, 0x0,
    0x2, 0xf2, 0x9a, 0x0, 0xc, 0x90, 0x1e, 0x40,
    0x5e, 0x0, 0x6, 0xd0,

    /* U+59 "Y" */
    0xa9, 0x0, 0x6, 0xd0, 0x2f, 0x10, 0xe, 0x40,
    0x9, 0x90, 0x6c, 0x0, 0x1, 0xe1, 0xd4, 0x0,
    0x0, 0x9c, 0xb0, 0x0, 0x0, 0x1f, 0x40, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0,

    /* U+5A "Z" */
    0x6f, 0xff, 0xff, 0x80, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0xc7, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x2f,
    0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0, 0x0,
    0x2, 0xf2, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xb0,

    /* U+5B "[" */
    0x2f, 0xf0, 0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0,
    0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0,
    0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0,
    0x2f, 0xf0,

    /* U+5C "\\" */
    0x97, 0x0, 0x3, 0xc0, 0x0, 0xd, 0x20, 0x0,
    0x88, 0x0, 0x2, 0xd0, 0x0, 0xc, 0x30, 0x0,
    0x79, 0x0, 0x1, 0xe0, 0x0, 0xb, 0x40, 0x0,
    0x6a,

    /* U+5D "]" */
    0xef, 0x40, 0xd4, 0xd, 0x40, 0xd4, 0xd, 0x40,
    0xd4, 0xd, 0x40, 0xd4, 0xd, 0x40, 0xd4, 0xd,
    0x40, 0xd4, 0xef, 0x40,

    /* U+5E "^" */
    0x0, 0x70, 0x0, 0x4f, 0x40, 0xa, 0x9a, 0x1,
    0xe0, 0xe1, 0x69, 0x9, 0x60,

    /* U+5F "_" */
    0xef, 0xff, 0xf5,

    /* U+60 "`" */
    0x4e, 0x0, 0x87,

    /* U+61 "a" */
    0x4, 0xde, 0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0,
    0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e,
    0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+62 "b" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x2, 0xe9, 0xec, 0x20, 0x2f, 0x50,
    0x8c, 0x2, 0xe0, 0x0, 0xf1, 0x2e, 0x0, 0xe,
    0x22, 0xe0, 0x0, 0xf1, 0x2f, 0x50, 0x8c, 0x2,
    0xd9, 0xec, 0x20,

    /* U+63 "c" */
    0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b, 0x0,
    0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3, 0x1e,
    0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+64 "d" */
    0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e, 0x0, 0x0,
    0x2e, 0x4, 0xde, 0x9e, 0x1f, 0x51, 0x9e, 0x5c,
    0x0, 0x2e, 0x6a, 0x0, 0x2e, 0x5b, 0x0, 0x2e,
    0xe, 0x30, 0x8e, 0x4, 0xdd, 0x9e,

    /* U+65 "e" */
    0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0,
    0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e,
    0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+66 "f" */
    0x1, 0xcf, 0x20, 0x8a, 0x0, 0xa, 0x70, 0x9,
    0xff, 0xb0, 0xa, 0x70, 0x0, 0xa7, 0x0, 0xa,
    0x70, 0x0, 0xa7, 0x0, 0xa, 0x70, 0x0, 0xa7,
    0x0,

    /* U+67 "g" */
    0x4, 0xde, 0x8e, 0x1f, 0x51, 0x9e, 0x5c, 0x0,
    0x2e, 0x6a, 0x0, 0x2e, 0x5c, 0x0, 0x2e, 0xf,
    0x51, 0x9e, 0x4, 0xde, 0x9e, 0x0, 0x0, 0x4d,
    0xc, 0x20, 0xb9, 0x6, 0xde, 0xa0,

    /* U+68 "h" */
    0x2e, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e, 0x0,
    0x0, 0x2e, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+69 "i" */
    0x1e, 0x0, 0x30, 0x1f, 0x1, 0xf0, 0x1f, 0x1,
    0xf0, 0x1f, 0x1, 0xf0, 0x1f, 0x0,

    /* U+6A "j" */
    0x2, 0xd0, 0x0, 0x30, 0x2, 0xf0, 0x2, 0xf0,
    0x2, 0xf0, 0x2, 0xf0, 0x2, 0xf0, 0x2, 0xf0,
    0x2, 0xf0, 0x2, 0xe0, 0x4, 0xd0, 0x5f, 0x60,

    /* U+6B "k" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x2, 0xe0, 0x1d, 0x50, 0x2e, 0xc,
    0x80, 0x2, 0xea, 0xa0, 0x0, 0x2f, 0xfb, 0x0,
    0x2, 0xf2, 0xd6, 0x0, 0x2e, 0x3, 0xe1, 0x2,
    0xe0, 0x8, 0xb0,

    /* U+6C "l" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f,

    /* U+6D "m" */
    0x3e, 0x9e, 0xd3, 0xbf, 0xc1, 0x3f, 0x50, 0x9f,
    0x40, 0xa8, 0x3e, 0x0, 0x4d, 0x0, 0x6b, 0x3e,
    0x0, 0x4c, 0x0, 0x6b, 0x3e, 0x0, 0x4c, 0x0,
    0x6b, 0x3e, 0x0, 0x4c, 0x0, 0x6b, 0x3e, 0x0,
    0x4c, 0x0, 0x6b,

    /* U+6E "n" */
    0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e, 0x0,
    0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e,
    0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+6F "o" */
    0x3, 0xcf, 0xb1, 0x1, 0xe5, 0x7, 0xc0, 0x5c,
    0x0, 0xe, 0x27, 0xa0, 0x0, 0xc4, 0x5c, 0x0,
    0xe, 0x30, 0xe5, 0x7, 0xd0, 0x3, 0xcf, 0xc2,
    0x0,

    /* U+70 "p" */
    0x2e, 0xae, 0xc2, 0x2, 0xf3, 0x7, 0xc0, 0x2e,
    0x0, 0xf, 0x2, 0xe0, 0x0, 0xe2, 0x2e, 0x0,
    0xf, 0x2, 0xf4, 0x8, 0xc0, 0x2e, 0xae, 0xc2,
    0x2, 0xe0, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x2,
    0xe0, 0x0, 0x0,

    /* U+71 "q" */
    0x4, 0xde, 0x9e, 0x1f, 0x40, 0x8e, 0x5c, 0x0,
    0x3e, 0x6a, 0x0, 0x3e, 0x5c, 0x0, 0x3e, 0x1f,
    0x40, 0x8e, 0x4, 0xde, 0xae, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e,

    /* U+72 "r" */
    0x0, 0x0, 0x2e, 0xbd, 0x2f, 0x50, 0x2e, 0x0,
    0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0,

    /* U+73 "s" */
    0x6, 0xee, 0x90, 0x1f, 0x21, 0xc6, 0x1f, 0x40,
    0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7, 0x4e,
    0x10, 0xa7, 0x7, 0xee, 0xa0,

    /* U+74 "t" */
    0x6, 0x20, 0xc, 0x40, 0xdf, 0xe6, 0xc, 0x40,
    0xc, 0x40, 0xc, 0x40, 0xc, 0x40, 0xc, 0x60,
    0x5, 0xf7,

    /* U+75 "u" */
    0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f,
    0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+76 "v" */
    0xa7, 0x0, 0xa6, 0x5c, 0x0, 0xf1, 0xf, 0x14,
    0xc0, 0xa, 0x59, 0x70, 0x5, 0xad, 0x20, 0x0,
    0xfc, 0x0, 0x0, 0xa7, 0x0,

    /* U+77 "w" */
    0x97, 0x1, 0xf1, 0x7, 0x95, 0xa0, 0x5f, 0x50,
    0xb5, 0x1e, 0xa, 0x8a, 0xe, 0x10, 0xd2, 0xd0,
    0xe2, 0xc0, 0x9, 0x9a, 0xb, 0x98, 0x0, 0x4f,
    0x60, 0x6f, 0x40, 0x0, 0xf1, 0x2, 0xf0, 0x0,

    /* U+78 "x" */
    0x6d, 0x0, 0xe5, 0xc, 0x67, 0xb0, 0x3, 0xee,
    0x20, 0x0, 0xcb, 0x0, 0x4, 0xde, 0x20, 0xd,
    0x56, 0xc0, 0x7c, 0x0, 0xd6,

    /* U+79 "y" */
    0xb7, 0x0, 0xc6, 0x6c, 0x1, 0xf1, 0x1f, 0x15,
    0xc0, 0xc, 0x6a, 0x70, 0x7, 0xbe, 0x20, 0x1,
    0xfd, 0x0, 0x0, 0xc8, 0x0, 0x0, 0xb3, 0x0,
    0x4, 0xd0, 0x0, 0x7e, 0x40, 0x0,

    /* U+7A "z" */
    0x6f, 0xff, 0xf5, 0x0, 0x5, 0xd0, 0x0, 0x1e,
    0x40, 0x0, 0xb9, 0x0, 0x6, 0xd0, 0x0, 0x1e,
    0x30, 0x0, 0x7f, 0xff, 0xf8,

    /* U+7B "{" */
    0x0, 0x27, 0x0, 0xe4, 0x4, 0xc0, 0x5, 0xb0,
    0x6, 0xa0, 0xa, 0x70, 0x9e, 0x0, 0xa, 0x70,
    0x6, 0xa0, 0x5, 0xb0, 0x4, 0xc0, 0x0, 0xe4,
    0x0, 0x27,

    /* U+7C "|" */
    0xee, 0xee, 0xee, 0xee, 0xee, 0xe0,

    /* U+7D "}" */
    0x72, 0x0, 0x3e, 0x0, 0xb, 0x50, 0xa, 0x60,
    0xa, 0x60, 0x7, 0xb0, 0x0, 0xea, 0x7, 0xb0,
    0xa, 0x60, 0xa, 0x60, 0xb, 0x50, 0x4e, 0x0,
    0x72, 0x0,

    /* U+7E "~" */
    0x5, 0xd9, 0x0, 0x75, 0xe, 0x3a, 0x90, 0xc2,
    0x2a, 0x0, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0x1e, 0x0, 0x30, 0x9, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0x1f, 0x0,

    /* U+A2 "¢" */
    0x0, 0x2e, 0x0, 0x0, 0x7f, 0x50, 0xb, 0xb6,
    0xc7, 0x2e, 0x0, 0x2c, 0x5b, 0x0, 0x0, 0x5b,
    0x0, 0x0, 0x2e, 0x0, 0x2a, 0xa, 0xb7, 0xd7,
    0x0, 0x7f, 0x40, 0x0, 0x2e, 0x0,

    /* U+A3 "£" */
    0x0, 0x8e, 0xe8, 0x0, 0x5d, 0x12, 0xe4, 0x8,
    0x90, 0x3, 0x10, 0x89, 0x0, 0x0, 0x7f, 0xff,
    0x70, 0x0, 0x7a, 0x0, 0x0, 0x7, 0xa0, 0x0,
    0x0, 0xa7, 0x0, 0x0, 0x7f, 0xff, 0xff, 0x90,

    /* U+A4 "¤" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xd6, 0xce, 0xa7,
    0xc0, 0xb, 0xe5, 0x28, 0xf6, 0x0, 0xd3, 0x0,
    0xa, 0x70, 0x1e, 0x0, 0x0, 0x4b, 0x1, 0xe0,
    0x0, 0x4, 0xb0, 0xe, 0x30, 0x0, 0x98, 0x0,
    0xce, 0x41, 0x7f, 0x70, 0x2c, 0x6d, 0xfb, 0x6b,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+A5 "¥" */
    0xa9, 0x0, 0x3e, 0x2, 0xe0, 0xa, 0x60, 0x9,
    0x61, 0xd0, 0x0, 0x1d, 0x86, 0x0, 0x3c, 0xef,
    0xc7, 0x0, 0x7, 0xb0, 0x0, 0x3c, 0xee, 0xc7,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x7b, 0x0, 0x0,

    /* U+A6 "¦" */
    0x2f, 0x2f, 0x2f, 0x2f, 0x1c, 0x0, 0x2f, 0x2f,
    0x2f, 0x2f, 0x2f,

    /* U+A7 "§" */
    0x3, 0xcf, 0xd6, 0x0, 0xe5, 0x2, 0xe4, 0x1f,
    0x0, 0x7, 0x60, 0xe9, 0x10, 0x0, 0xb, 0xef,
    0xb3, 0x5, 0xd0, 0x29, 0xf4, 0x6c, 0x0, 0x7,
    0xa1, 0xea, 0x30, 0x99, 0x2, 0xaf, 0xee, 0x10,
    0x0, 0x6, 0xf2, 0x59, 0x0, 0xb, 0x62, 0xf4,
    0x3, 0xe3, 0x4, 0xce, 0xd6, 0x0,

    /* U+A8 "¨" */
    0x0, 0x0, 0x4, 0xc0, 0xc4, 0x2, 0x2, 0x0,

    /* U+A9 "©" */
    0x0, 0x2a, 0xcb, 0x50, 0x0, 0x3b, 0x20, 0x8,
    0x80, 0xb, 0x7, 0xca, 0x9, 0x34, 0x73, 0xb0,
    0x77, 0x19, 0x64, 0x67, 0x0, 0x10, 0xa6, 0x46,
    0x70, 0x1, 0xa, 0x37, 0x3b, 0x7, 0x71, 0x90,
    0xb0, 0x7c, 0xb1, 0x93, 0x3, 0xb2, 0x0, 0x88,
    0x0, 0x2, 0xac, 0xb5, 0x0,

    /* U+AA "ª" */
    0x8, 0xec, 0x10, 0x80, 0x96, 0x7, 0xbd, 0x71,
    0xe0, 0x87, 0xb, 0xdd, 0x80,

    /* U+AB "«" */
    0x0, 0x0, 0x0, 0x2, 0xc2, 0xb0, 0xc, 0x3c,
    0x20, 0x4c, 0x5b, 0x0, 0xb, 0x4c, 0x30, 0x1,
    0xc2, 0xb0,

    /* U+AC "¬" */
    0x3e, 0xee, 0xe8, 0x1, 0x11, 0x89, 0x0, 0x0,
    0x45,

    /* U+AD "­" */
    0xbf, 0xf1,

    /* U+AE "®" */
    0x0, 0x2a, 0xcb, 0x50, 0x0, 0x3b, 0x20, 0x8,
    0x80, 0xb, 0xe, 0xca, 0x9, 0x34, 0x70, 0xd0,
    0x76, 0x19, 0x64, 0xd, 0x7, 0x60, 0xa6, 0x40,
    0xfd, 0xe1, 0xa, 0x37, 0xd, 0x7, 0x61, 0x90,
    0xb0, 0xb0, 0x47, 0x93, 0x3, 0xb2, 0x0, 0x88,
    0x0, 0x2, 0xac, 0xb5, 0x0,

    /* U+AF "¯" */
    0x2e, 0xee, 0xb0,

    /* U+B0 "°" */
    0x9, 0xc3, 0x2a, 0x2a, 0xa, 0xd4,

    /* U+B1 "±" */
    0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x6f, 0xff, 0xfe, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2, 0x0, 0x3f, 0xff, 0xfa,

    /* U+B2 "²" */
    0x2c, 0xd5, 0x54, 0x3c, 0x0, 0xb6, 0xa, 0x80,
    0x7f, 0xcc,

    /* U+B3 "³" */
    0x3c, 0xd6, 0x32, 0x3c, 0x4, 0xe6, 0x32, 0x2d,
    0x4d, 0xc7,

    /* U+B4 "´" */
    0x6, 0xc0, 0x1d, 0x10,

    /* U+B5 "µ" */
    0x1f, 0x0, 0x3e, 0x1f, 0x0, 0x3e, 0x1f, 0x0,
    0x3e, 0x1f, 0x0, 0x3e, 0x1f, 0x0, 0x3e, 0x1f,
    0x40, 0x7e, 0x1f, 0xdd, 0xae, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,

    /* U+B6 "¶" */
    0x6, 0xdf, 0xe3, 0xff, 0xfe, 0x8f, 0xff, 0xe8,
    0xff, 0xfe, 0x3f, 0xff, 0xe0, 0x5c, 0xfe, 0x0,
    0x3, 0xe0, 0x0, 0x3e, 0x0, 0x3, 0xe0,

    /* U+B7 "·" */
    0x0, 0x0, 0xf1, 0x3, 0x0,

    /* U+B8 "¸" */
    0x1, 0x2, 0xd2, 0x7, 0x73, 0xa1,

    /* U+B9 "¹" */
    0x3, 0x73, 0x9e, 0x0, 0xe0, 0xe, 0x0, 0xe0,

    /* U+BA "º" */
    0x8, 0xdc, 0x12, 0xd0, 0x69, 0x4a, 0x3, 0xb2,
    0xd0, 0x69, 0x8, 0xdc, 0x20,

    /* U+BB "»" */
    0x0, 0x0, 0x0, 0x1c, 0x1c, 0x0, 0x7, 0x86,
    0x90, 0x0, 0xf1, 0xf1, 0x8, 0x77, 0x80, 0x2b,
    0x1c, 0x0,

    /* U+BC "¼" */
    0x0, 0x10, 0x0, 0x0, 0x4, 0xdb, 0x0, 0x2,
    0x0, 0x24, 0xb0, 0x5, 0x70, 0x0, 0x3b, 0x0,
    0xc0, 0x0, 0x3, 0xb0, 0x85, 0x0, 0x0, 0x28,
    0x2b, 0x9, 0xb0, 0x0, 0xa, 0x23, 0xdb, 0x0,
    0x4, 0x90, 0xb4, 0xb0, 0x0, 0xb1, 0x5d, 0xdf,
    0x40, 0x0, 0x0, 0x3, 0xb0,

    /* U+BD "½" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xba, 0x0, 0x0,
    0x0, 0x36, 0xa0, 0x8, 0x40, 0x0, 0x4a, 0x2,
    0xb0, 0x0, 0x4, 0xa0, 0xb2, 0x0, 0x0, 0x39,
    0x58, 0x5d, 0xc2, 0x0, 0xc, 0x9, 0x18, 0x60,
    0x8, 0x50, 0x2, 0xd1, 0x1, 0xb0, 0x2, 0xc2,
    0x0, 0x0, 0x0, 0xbd, 0xd8,

    /* U+BE "¾" */
    0xa, 0xd9, 0x0, 0x0, 0x1, 0x50, 0xe0, 0x6,
    0x40, 0x1, 0xda, 0x1, 0xb0, 0x2, 0x50, 0xd1,
    0xa3, 0x0, 0xb, 0xd9, 0x49, 0x1d, 0x30, 0x0,
    0xc, 0x1a, 0xd4, 0x0, 0x7, 0x65, 0x7a, 0x40,
    0x1, 0xb0, 0xcd, 0xec, 0x0, 0x0, 0x0, 0xa,
    0x40,

    /* U+BF "¿" */
    0x0, 0xa5, 0x0, 0x0, 0x21, 0x0, 0x0, 0x21,
    0x0, 0x0, 0xb6, 0x0, 0x3, 0xf1, 0x0, 0xe,
    0x60, 0x0, 0x6b, 0x0, 0x0, 0x88, 0x0, 0x61,
    0x6c, 0x14, 0xf0, 0xa, 0xfd, 0x40,

    /* U+C0 "À" */
    0x0, 0x54, 0x0, 0x0, 0x0, 0x1c, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+C1 "Á" */
    0x0, 0x0, 0x54, 0x0, 0x0, 0x4, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+C2 "Â" */
    0x0, 0x5, 0x40, 0x0, 0x0, 0x68, 0xa4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+C3 "Ã" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x1c, 0x0,
    0x1, 0xb2, 0xd8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xb7,

    /* U+C4 "Ä" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd3, 0x5b, 0x0,
    0x0, 0x20, 0x2, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+C5 "Å" */
    0x0, 0x8, 0x70, 0x0, 0x0, 0x36, 0x81, 0x0,
    0x0, 0x45, 0x71, 0x0, 0x0, 0x8, 0x70, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xb7,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0xcd, 0x90, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0x7a, 0x0, 0x0, 0x0, 0x0, 0xe, 0x56, 0xb0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x5f, 0xff, 0xf2,
    0x0, 0x1, 0xf5, 0x5, 0xc0, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x3f, 0x42,
    0x25, 0xd0, 0x0, 0x0, 0xc, 0x90, 0x0, 0x2f,
    0xff, 0xff, 0x0,

    /* U+C7 "Ç" */
    0x0, 0x8e, 0xea, 0x10, 0x9, 0xc2, 0x9, 0xc0,
    0x1f, 0x20, 0x0, 0xe2, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0xe2, 0x9, 0xb1, 0x18, 0xc0,
    0x0, 0x9f, 0xfa, 0x10, 0x0, 0x7, 0xa0, 0x0,
    0x0, 0x0, 0xb2, 0x0, 0x0, 0x6, 0xb0, 0x0,

    /* U+C8 "È" */
    0x0, 0xc6, 0x0, 0x0, 0x2, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+C9 "É" */
    0x0, 0x2, 0xe2, 0x0, 0x0, 0xa4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+CA "Ê" */
    0x0, 0x2e, 0x50, 0x0, 0xc, 0x3c, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+CB "Ë" */
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xa, 0x60, 0x0,
    0x20, 0x10, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+CC "Ì" */
    0xc, 0x60, 0x1, 0xd0, 0x0, 0x0, 0x0, 0xe3,
    0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3,
    0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3,

    /* U+CD "Í" */
    0x2e, 0x2a, 0x40, 0x0, 0xe, 0x30, 0xe3, 0xe,
    0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3,
    0xe, 0x30,

    /* U+CE "Î" */
    0x2, 0xe5, 0x0, 0xc3, 0xc1, 0x0, 0x0, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30,

    /* U+CF "Ï" */
    0x0, 0x0, 0x2, 0xe0, 0xa7, 0x2, 0x1, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30,

    /* U+D0 "Ð" */
    0xd, 0xff, 0xd7, 0x0, 0xd, 0x40, 0x3c, 0x80,
    0xd, 0x40, 0x2, 0xf0, 0xd, 0x40, 0x0, 0xe4,
    0xef, 0xfb, 0x0, 0xc5, 0xd, 0x40, 0x0, 0xe4,
    0xd, 0x40, 0x2, 0xf1, 0xd, 0x40, 0x3d, 0x80,
    0xd, 0xff, 0xd7, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0x38, 0x40,
    0x0, 0xb1, 0xac, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x98, 0xf, 0xf1, 0x0, 0x98,
    0xf, 0xba, 0x0, 0x98, 0xf, 0x3e, 0x40, 0x98,
    0xf, 0x25, 0xd0, 0x98, 0xf, 0x20, 0xb8, 0x98,
    0xf, 0x20, 0x2f, 0xb8, 0xf, 0x20, 0x8, 0xf8,
    0xf, 0x20, 0x0, 0xd8,

    /* U+D2 "Ò" */
    0x0, 0x5d, 0x0, 0x0, 0x0, 0x8, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+D3 "Ó" */
    0x0, 0x0, 0x99, 0x0, 0x0, 0x2, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+D4 "Ô" */
    0x0, 0x9, 0xc0, 0x0, 0x0, 0x5a, 0x58, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+D5 "Õ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0x2a, 0x20,
    0x0, 0xb1, 0xba, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfa, 0x10, 0x9, 0xc3, 0x29, 0xd0,
    0x1f, 0x20, 0x0, 0xd4, 0x3e, 0x0, 0x0, 0xa7,
    0x4d, 0x0, 0x0, 0x98, 0x4e, 0x0, 0x0, 0xa7,
    0x1f, 0x20, 0x0, 0xd4, 0x9, 0xc2, 0x19, 0xd0,
    0x0, 0x8e, 0xfb, 0x10,

    /* U+D6 "Ö" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa6, 0x2e, 0x0,
    0x0, 0x10, 0x2, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+D7 "×" */
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x78, 0xa, 0xb6,
    0xe1, 0x0, 0xcf, 0x20, 0x3, 0xed, 0x80, 0x2e,
    0x41, 0xe6, 0x15, 0x0, 0x24,

    /* U+D8 "Ø" */
    0x0, 0x0, 0x0, 0x57, 0x0, 0x8e, 0xea, 0xb1,
    0x9, 0xc3, 0x1a, 0xd0, 0x1f, 0x20, 0xb, 0xe4,
    0x4e, 0x0, 0x66, 0xa7, 0x4d, 0x1, 0xb0, 0x98,
    0x4e, 0xa, 0x30, 0xa7, 0x1f, 0x68, 0x0, 0xd4,
    0x8, 0xf3, 0x19, 0xd0, 0x7, 0xbe, 0xfb, 0x10,
    0x6, 0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0x8a, 0x0, 0x0, 0x0, 0xc3, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+DA "Ú" */
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x69, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+DB "Û" */
    0x0, 0xc, 0x90, 0x0, 0x8, 0x69, 0x50, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+DC "Ü" */
    0x0, 0x0, 0x0, 0x0, 0xe, 0x35, 0xb0, 0x0,
    0x20, 0x1, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+DD "Ý" */
    0x0, 0x0, 0x71, 0x0, 0x0, 0x9, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x6, 0xd0,
    0x2f, 0x10, 0xe, 0x40, 0x9, 0x90, 0x6c, 0x0,
    0x1, 0xe1, 0xd4, 0x0, 0x0, 0x9c, 0xb0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+DE "Þ" */
    0xf, 0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf,
    0xff, 0xe7, 0x0, 0xf1, 0x2, 0xe4, 0xf, 0x10,
    0x9, 0x80, 0xf1, 0x2, 0xe4, 0xf, 0xff, 0xd7,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,

    /* U+DF "ß" */
    0x4, 0xde, 0x80, 0x0, 0xe4, 0x1e, 0x30, 0x2f,
    0x0, 0xc4, 0x3, 0xe0, 0x2e, 0x0, 0x3e, 0x7,
    0xa0, 0x3, 0xe0, 0x4e, 0x10, 0x3e, 0x0, 0x8e,
    0x13, 0xe0, 0x0, 0xb8, 0x3e, 0x0, 0x9, 0x83,
    0xe3, 0xdd, 0xb1,

    /* U+E0 "à" */
    0x1, 0xe2, 0x0, 0x0, 0x4b, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xde, 0xb0, 0x1f, 0x20, 0xb7, 0x0,
    0x0, 0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a,
    0x4e, 0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+E1 "á" */
    0x0, 0x5, 0xd0, 0x0, 0xd, 0x20, 0x0, 0x0,
    0x0, 0x4, 0xde, 0xb0, 0x1f, 0x30, 0xb7, 0x2,
    0x0, 0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a,
    0x4e, 0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+E2 "â" */
    0x0, 0x4e, 0x20, 0x1, 0xb2, 0xb0, 0x0, 0x0,
    0x0, 0x4, 0xde, 0xb0, 0x1f, 0x30, 0xb7, 0x2,
    0x0, 0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a,
    0x4e, 0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+E3 "ã" */
    0x0, 0x0, 0x0, 0x3, 0xe5, 0x66, 0x9, 0x28,
    0xd1, 0x0, 0x0, 0x0, 0x4, 0xde, 0xb0, 0x1f,
    0x30, 0xb7, 0x2, 0x0, 0x7a, 0x5, 0xcd, 0xea,
    0x3e, 0x10, 0x7a, 0x4e, 0x12, 0xca, 0x9, 0xfd,
    0x8b,

    /* U+E4 "ä" */
    0x5, 0xa0, 0xc3, 0x1, 0x20, 0x30, 0x4, 0xde,
    0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0, 0x7a, 0x5,
    0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e, 0x12, 0xca,
    0x9, 0xfd, 0x8b,

    /* U+E5 "å" */
    0x0, 0x59, 0x30, 0x0, 0xa0, 0x90, 0x0, 0x59,
    0x30, 0x0, 0x0, 0x0, 0x4, 0xde, 0xb0, 0x1f,
    0x30, 0xb7, 0x2, 0x0, 0x7a, 0x5, 0xcd, 0xea,
    0x3e, 0x10, 0x7a, 0x4e, 0x12, 0xca, 0x9, 0xfd,
    0x8b,

    /* U+E6 "æ" */
    0x7, 0xef, 0x94, 0xee, 0x90, 0x3e, 0x21, 0xdf,
    0x31, 0xc6, 0x2, 0x0, 0xa9, 0x0, 0x6a, 0x9,
    0xdd, 0xfe, 0xee, 0xea, 0x6c, 0x0, 0x99, 0x0,
    0x0, 0x7b, 0x2, 0xde, 0x30, 0x33, 0x1c, 0xfd,
    0x65, 0xdf, 0xc3,

    /* U+E7 "ç" */
    0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b, 0x0,
    0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3, 0x1e,
    0x40, 0x8a, 0x3, 0xdf, 0xa0, 0x0, 0x5c, 0x0,
    0x0, 0x9, 0x40, 0x0, 0x4b, 0x10,

    /* U+E8 "è" */
    0x2, 0xe1, 0x0, 0x0, 0x6a, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+E9 "é" */
    0x0, 0x6, 0xc0, 0x0, 0x1d, 0x10, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+EA "ê" */
    0x0, 0x6e, 0x10, 0x2, 0xb3, 0xa0, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+EB "ë" */
    0x7, 0x80, 0xe2, 0x1, 0x20, 0x30, 0x3, 0xdf,
    0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0, 0x3c, 0x6f,
    0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e, 0x40, 0x47,
    0x3, 0xcf, 0xc3,

    /* U+EC "ì" */
    0x1e, 0x40, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xf0,
    0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0,
    0x1, 0xf0, 0x1, 0xf0,

    /* U+ED "í" */
    0x4, 0xd1, 0xb, 0x20, 0x0, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0,

    /* U+EE "î" */
    0x4, 0xe3, 0x1, 0xa1, 0xa0, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0,

    /* U+EF "ï" */
    0x4b, 0xb, 0x40, 0x20, 0x20, 0x1, 0xf0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0,

    /* U+F0 "ð" */
    0x3, 0x92, 0x2, 0x0, 0x29, 0xfc, 0x60, 0x0,
    0x4c, 0xf3, 0x0, 0x4, 0x7, 0xc0, 0x3, 0xce,
    0xaf, 0x10, 0xe6, 0x3, 0xf3, 0x3e, 0x0, 0xd,
    0x43, 0xe0, 0x0, 0xe2, 0xe, 0x60, 0x7d, 0x0,
    0x2c, 0xfc, 0x20,

    /* U+F1 "ñ" */
    0x0, 0x0, 0x0, 0x4, 0xe5, 0x75, 0x9, 0x29,
    0xc1, 0x0, 0x0, 0x0, 0x2d, 0x8e, 0xd2, 0x2f,
    0x60, 0x9a, 0x2e, 0x0, 0x4c, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e, 0x0,
    0x4d,

    /* U+F2 "ò" */
    0x2, 0xe2, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+F3 "ó" */
    0x0, 0x6, 0xc0, 0x0, 0x0, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+F4 "ô" */
    0x0, 0x5e, 0x20, 0x0, 0x2b, 0x2b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+F5 "õ" */
    0x0, 0x0, 0x0, 0x0, 0x4e, 0x56, 0x60, 0x9,
    0x28, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x3, 0xcf,
    0xb1, 0x1, 0xe5, 0x7, 0xc0, 0x5c, 0x0, 0xe,
    0x27, 0xa0, 0x0, 0xc4, 0x5c, 0x0, 0xe, 0x30,
    0xe5, 0x7, 0xd0, 0x3, 0xcf, 0xc2, 0x0,

    /* U+F6 "ö" */
    0x6, 0x90, 0xd2, 0x0, 0x12, 0x3, 0x0, 0x3,
    0xcf, 0xb1, 0x1, 0xe5, 0x7, 0xc0, 0x5c, 0x0,
    0xe, 0x27, 0xa0, 0x0, 0xc4, 0x5c, 0x0, 0xe,
    0x30, 0xe5, 0x7, 0xd0, 0x3, 0xcf, 0xc2, 0x0,

    /* U+F7 "÷" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x0,
    0x2, 0x0, 0x9, 0xff, 0xff, 0xf4, 0x12, 0x22,
    0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x0, 0x20, 0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x29, 0x0, 0x3c, 0xfe, 0x40, 0x1e,
    0x51, 0xed, 0x5, 0xc0, 0x64, 0xe2, 0x7a, 0xb,
    0xc, 0x45, 0xc5, 0x50, 0xe3, 0x1e, 0xc0, 0x7d,
    0x0, 0x7e, 0xfc, 0x20, 0x5, 0x0, 0x0, 0x0,

    /* U+F9 "ù" */
    0x2, 0xe2, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x1f, 0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+FA "ú" */
    0x0, 0x6, 0xc0, 0x0, 0x1c, 0x10, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x1f, 0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+FB "û" */
    0x0, 0x6d, 0x10, 0x2, 0xa2, 0x90, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x1f, 0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+FC "ü" */
    0x6, 0x90, 0xd2, 0x1, 0x20, 0x30, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc,
    0x7, 0xee, 0x9c,

    /* U+FD "ý" */
    0x0, 0xc, 0x60, 0x0, 0x59, 0x0, 0x0, 0x0,
    0x0, 0xb7, 0x0, 0xc6, 0x6c, 0x1, 0xf1, 0x1f,
    0x15, 0xc0, 0xc, 0x6a, 0x70, 0x7, 0xbe, 0x20,
    0x1, 0xfd, 0x0, 0x0, 0xc8, 0x0, 0x0, 0xb3,
    0x0, 0x4, 0xd0, 0x0, 0x7e, 0x40, 0x0,

    /* U+FE "þ" */
    0x2f, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0, 0x2f,
    0x0, 0x0, 0x2, 0xf9, 0xed, 0x20, 0x2f, 0x61,
    0x8d, 0x2, 0xf0, 0x0, 0xf1, 0x2f, 0x0, 0xe,
    0x32, 0xf0, 0x0, 0xf1, 0x2f, 0x50, 0x8d, 0x2,
    0xf9, 0xed, 0x20, 0x2f, 0x0, 0x0, 0x2, 0xf0,
    0x0, 0x0, 0x2f, 0x0, 0x0, 0x0,

    /* U+FF "ÿ" */
    0xc, 0x34, 0xb0, 0x3, 0x0, 0x30, 0xb7, 0x0,
    0xc6, 0x6c, 0x1, 0xf1, 0x1f, 0x15, 0xc0, 0xc,
    0x6a, 0x70, 0x7, 0xbe, 0x20, 0x1, 0xfd, 0x0,
    0x0, 0xc8, 0x0, 0x0, 0xb3, 0x0, 0x4, 0xd0,
    0x0, 0x7e, 0x40, 0x0,

    /* U+100 "Ā" */
    0x0, 0xee, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xb7,

    /* U+101 "ā" */
    0x7, 0xee, 0xe5, 0x0, 0x0, 0x0, 0x4, 0xde,
    0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0, 0x7a, 0x5,
    0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e, 0x12, 0xca,
    0x9, 0xfd, 0x8b,

    /* U+102 "Ă" */
    0x0, 0x61, 0x25, 0x0, 0x0, 0x4c, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+103 "ă" */
    0x4, 0xa0, 0xd1, 0x0, 0x9c, 0x70, 0x0, 0x0,
    0x0, 0x7, 0xde, 0xb0, 0x18, 0x10, 0xb7, 0x0,
    0x0, 0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a,
    0x4e, 0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+104 "Ą" */
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xa7, 0x0, 0x0, 0x1, 0xc1,
    0x0, 0x0, 0x6, 0x80, 0x0, 0x0, 0x4, 0xe6,

    /* U+105 "ą" */
    0x4, 0xde, 0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0,
    0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e,
    0x12, 0xca, 0x9, 0xfd, 0x9c, 0x0, 0x0, 0xb2,
    0x0, 0x3, 0xb0, 0x0, 0x1, 0xea,

    /* U+106 "Ć" */
    0x0, 0x0, 0xc6, 0x0, 0x0, 0x5, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+107 "ć" */
    0x0, 0xa, 0x90, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b,
    0x0, 0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+108 "Ĉ" */
    0x0, 0xb, 0xa0, 0x0, 0x0, 0x42, 0x34, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+109 "ĉ" */
    0x0, 0x9c, 0x0, 0x5, 0x95, 0x80, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b,
    0x0, 0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xea, 0x10, 0x9, 0xc2, 0x9, 0xc0,
    0x1f, 0x20, 0x0, 0xe2, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0xe2, 0x9, 0xb1, 0x18, 0xc0,
    0x0, 0x9f, 0xea, 0x10,

    /* U+10B "ċ" */
    0x0, 0x69, 0x0, 0x0, 0x12, 0x0, 0x4, 0xdf,
    0xb1, 0x1f, 0x40, 0x9a, 0x5b, 0x0, 0x16, 0x6a,
    0x0, 0x0, 0x5b, 0x0, 0x3, 0x1e, 0x40, 0x8a,
    0x3, 0xdf, 0xa0,

    /* U+10C "Č" */
    0x0, 0x57, 0x85, 0x0, 0x0, 0x4, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+10D "č" */
    0x5, 0xa6, 0x90, 0x0, 0x9c, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x8a, 0x5b,
    0x0, 0x3, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x14,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+10E "Ď" */
    0x0, 0xc3, 0xc1, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xd5, 0x0,
    0xf, 0x10, 0x4e, 0x50, 0xf, 0x10, 0x4, 0xd0,
    0xf, 0x10, 0x0, 0xf1, 0xf, 0x10, 0x0, 0xf2,
    0xf, 0x10, 0x0, 0xf1, 0xf, 0x10, 0x5, 0xd0,
    0xf, 0x10, 0x4e, 0x50, 0xf, 0xff, 0xd5, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x2e, 0x4b, 0x0, 0x0, 0x2e, 0x78,
    0x0, 0x0, 0x2e, 0x52, 0x4, 0xde, 0x9e, 0x0,
    0x1f, 0x51, 0x9e, 0x0, 0x5c, 0x0, 0x2e, 0x0,
    0x6a, 0x0, 0x2e, 0x0, 0x5b, 0x0, 0x2e, 0x0,
    0xe, 0x30, 0x8e, 0x0, 0x4, 0xdd, 0x9e, 0x0,

    /* U+110 "Đ" */
    0xd, 0xff, 0xd7, 0x0, 0xd, 0x40, 0x3c, 0x80,
    0xd, 0x40, 0x2, 0xf0, 0xd, 0x40, 0x0, 0xe4,
    0xef, 0xfb, 0x0, 0xc5, 0xd, 0x40, 0x0, 0xe4,
    0xd, 0x40, 0x2, 0xf1, 0xd, 0x40, 0x3d, 0x80,
    0xd, 0xff, 0xd7, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x2e, 0x0, 0x0, 0xa, 0xff, 0xf0,
    0x0, 0x0, 0x2e, 0x0, 0x4, 0xde, 0x9e, 0x0,
    0x1f, 0x51, 0x9e, 0x0, 0x5c, 0x0, 0x2e, 0x0,
    0x6a, 0x0, 0x2e, 0x0, 0x5b, 0x0, 0x2e, 0x0,
    0xe, 0x30, 0x8e, 0x0, 0x4, 0xdd, 0x9e, 0x0,

    /* U+112 "Ē" */
    0x4, 0xee, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0x50, 0xf1, 0x0, 0x0, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xfd,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x60,

    /* U+113 "ē" */
    0x9, 0xee, 0xe4, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0, 0x3c, 0x6f,
    0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e, 0x40, 0x47,
    0x3, 0xcf, 0xc3,

    /* U+114 "Ĕ" */
    0x0, 0x70, 0x52, 0x0, 0x8, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+115 "ĕ" */
    0x5, 0x90, 0xe0, 0x0, 0xac, 0x50, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+116 "Ė" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe2, 0x0, 0x0,
    0x2, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+117 "ė" */
    0x0, 0x3c, 0x0, 0x0, 0x3, 0x0, 0x3, 0xdf,
    0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0, 0x3c, 0x6f,
    0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e, 0x40, 0x47,
    0x3, 0xcf, 0xc3,

    /* U+118 "Ę" */
    0xf, 0xff, 0xff, 0x50, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff,
    0xfd, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x60,
    0x0, 0x7, 0x80, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0xa, 0xe0,

    /* U+119 "ę" */
    0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0,
    0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e,
    0x40, 0x47, 0x3, 0xcf, 0xf5, 0x0, 0xd, 0x40,
    0x0, 0x2d, 0x0, 0x0, 0xd, 0xb0,

    /* U+11A "Ě" */
    0x0, 0xc3, 0xc2, 0x0, 0x2, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+11B "ě" */
    0x2, 0xc4, 0xb0, 0x0, 0x6e, 0x10, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+11C "Ĝ" */
    0x0, 0x1b, 0xa0, 0x0, 0x0, 0x52, 0x33, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0x9, 0xc2, 0x7, 0xe0, 0xf, 0x20, 0x0, 0x61,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0xcf, 0xf4,
    0x3e, 0x0, 0x0, 0xd4, 0xf, 0x20, 0x0, 0xd4,
    0x8, 0xd2, 0x4, 0xf3, 0x0, 0x7e, 0xfd, 0x60,

    /* U+11D "ĝ" */
    0x0, 0x7d, 0x10, 0x3, 0xa3, 0x90, 0x0, 0x0,
    0x0, 0x4, 0xde, 0x8e, 0x1f, 0x51, 0x9e, 0x5c,
    0x0, 0x2e, 0x6a, 0x0, 0x2e, 0x5c, 0x0, 0x2e,
    0xf, 0x51, 0x9e, 0x4, 0xde, 0x9e, 0x0, 0x0,
    0x4d, 0xc, 0x20, 0xb9, 0x6, 0xde, 0xa0,

    /* U+11E "Ğ" */
    0x0, 0xb3, 0x59, 0x0, 0x0, 0x3b, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0x9, 0xc2, 0x7, 0xe0, 0xf, 0x20, 0x0, 0x61,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0xcf, 0xf4,
    0x3e, 0x0, 0x0, 0xd4, 0xf, 0x20, 0x0, 0xd4,
    0x8, 0xd2, 0x4, 0xf3, 0x0, 0x7e, 0xfd, 0x60,

    /* U+11F "ğ" */
    0x7, 0x60, 0xd0, 0x3, 0xa1, 0xc0, 0x0, 0x8b,
    0x30, 0x4, 0xde, 0x8e, 0x1f, 0x51, 0x9e, 0x5c,
    0x0, 0x2e, 0x6a, 0x0, 0x2e, 0x5c, 0x0, 0x2e,
    0xf, 0x51, 0x9e, 0x4, 0xde, 0x9e, 0x0, 0x0,
    0x4d, 0xc, 0x20, 0xb9, 0x6, 0xde, 0xa0,

    /* U+120 "Ġ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0xfb, 0x20, 0x9, 0xc2, 0x7, 0xe0,
    0xf, 0x20, 0x0, 0x61, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0xcf, 0xf4, 0x3e, 0x0, 0x0, 0xd4,
    0xf, 0x20, 0x0, 0xd4, 0x8, 0xd2, 0x4, 0xf3,
    0x0, 0x7e, 0xfd, 0x60,

    /* U+121 "ġ" */
    0x0, 0x4b, 0x0, 0x0, 0x3, 0x0, 0x4, 0xde,
    0x8e, 0x1f, 0x51, 0x9e, 0x5c, 0x0, 0x2e, 0x6a,
    0x0, 0x2e, 0x5c, 0x0, 0x2e, 0xf, 0x51, 0x9e,
    0x4, 0xde, 0x9e, 0x0, 0x0, 0x4d, 0xc, 0x20,
    0xb9, 0x6, 0xde, 0xa0,

    /* U+122 "Ģ" */
    0x0, 0x9e, 0xfb, 0x20, 0x9, 0xc2, 0x7, 0xe0,
    0xf, 0x20, 0x0, 0x61, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0xcf, 0xf4, 0x3e, 0x0, 0x0, 0xd4,
    0xf, 0x20, 0x0, 0xd4, 0x8, 0xd2, 0x4, 0xf3,
    0x0, 0x7e, 0xfd, 0x60, 0x0, 0x2, 0x60, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x7, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x0, 0x0, 0xd, 0x0, 0x0, 0x4c,
    0x0, 0x0, 0x26, 0x0, 0x4, 0xde, 0x8e, 0x1f,
    0x51, 0x9e, 0x5c, 0x0, 0x2e, 0x6a, 0x0, 0x2e,
    0x5c, 0x0, 0x2e, 0xf, 0x51, 0x9e, 0x4, 0xde,
    0x9e, 0x0, 0x0, 0x4d, 0xc, 0x20, 0xb9, 0x6,
    0xde, 0xa0,

    /* U+124 "Ĥ" */
    0x0, 0x8, 0xc0, 0x0, 0x0, 0x4a, 0x59, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0xff, 0xff, 0xf8,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,

    /* U+125 "ĥ" */
    0x0, 0xb9, 0x0, 0x8, 0x68, 0x50, 0x2e, 0x0,
    0x0, 0x2e, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e,
    0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e, 0x0, 0x4c,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e, 0x0,
    0x4d, 0x2e, 0x0, 0x4d,

    /* U+126 "Ħ" */
    0xf, 0x10, 0x0, 0xa8, 0x0, 0xf1, 0x0, 0xa,
    0x80, 0xbf, 0xee, 0xee, 0xff, 0x40, 0xf1, 0x0,
    0xa, 0x80, 0xf, 0xff, 0xff, 0xf8, 0x0, 0xf1,
    0x0, 0xa, 0x80, 0xf, 0x10, 0x0, 0xa8, 0x0,
    0xf1, 0x0, 0xa, 0x80, 0xf, 0x10, 0x0, 0xa8,
    0x0,

    /* U+127 "ħ" */
    0x0, 0xf1, 0x0, 0x2, 0xff, 0xf8, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x7e, 0xe4, 0x0, 0xf9,
    0x6, 0xd0, 0xf, 0x10, 0x1f, 0x0, 0xf1, 0x1,
    0xf0, 0xf, 0x10, 0x1f, 0x0, 0xf1, 0x1, 0xf0,
    0xf, 0x10, 0x1f,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x1, 0xc8, 0x2a, 0x56, 0x5e, 0x40,
    0x0, 0x0, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3,
    0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x2, 0xe6, 0x47, 0x73, 0x7d, 0x20,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0, 0x1, 0xf0, 0x0,

    /* U+12A "Ī" */
    0x4e, 0xee, 0x90, 0x0, 0x0, 0x0, 0xe3, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0,

    /* U+12B "ī" */
    0x6e, 0xee, 0x70, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0,

    /* U+12C "Ĭ" */
    0x7, 0x4, 0x20, 0x8c, 0xa0, 0x0, 0x0, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30,

    /* U+12D "ĭ" */
    0x2c, 0xc, 0x20, 0x8c, 0x70, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0,

    /* U+12E "Į" */
    0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xf, 0x36, 0xa0, 0xd2,
    0x9, 0xe2,

    /* U+12F "į" */
    0x1, 0xe0, 0x0, 0x30, 0x1, 0xf0, 0x1, 0xf0,
    0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0,
    0x1, 0xf0, 0x8, 0x70, 0xf, 0x0, 0xb, 0xd0,

    /* U+130 "İ" */
    0x0, 0x0, 0xe2, 0x2, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe,
    0x30, 0xe3,

    /* U+131 "ı" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,

    /* U+132 "Ĳ" */
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x36, 0x0, 0x3e, 0xe3, 0x3e, 0x10, 0x8a,
    0xe3, 0x6, 0xde, 0xb1,

    /* U+133 "ĳ" */
    0x1e, 0x3, 0xc0, 0x30, 0x3, 0x1f, 0x3, 0xd1,
    0xf0, 0x3d, 0x1f, 0x3, 0xd1, 0xf0, 0x3d, 0x1f,
    0x3, 0xd1, 0xf0, 0x3d, 0x1f, 0x3, 0xd0, 0x0,
    0x3d, 0x0, 0x6, 0xc0, 0x6, 0xe5,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0xba, 0x0, 0x0, 0x77, 0x86, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x7b,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x7b, 0x6,
    0x40, 0x7, 0xa0, 0x7c, 0x11, 0xd6, 0x0, 0x9e,
    0xe9, 0x0,

    /* U+135 "ĵ" */
    0x2, 0xe4, 0x0, 0xc3, 0xc1, 0x0, 0x0, 0x0,
    0xf, 0x10, 0x0, 0xf1, 0x0, 0xf, 0x10, 0x0,
    0xf1, 0x0, 0xf, 0x10, 0x0, 0xf1, 0x0, 0xf,
    0x10, 0x0, 0xf1, 0x0, 0x2f, 0x0, 0x6e, 0x60,
    0x0,

    /* U+136 "Ķ" */
    0xf, 0x10, 0x8, 0xc0, 0xf, 0x10, 0x6e, 0x10,
    0xf, 0x13, 0xe3, 0x0, 0xf, 0x4e, 0x40, 0x0,
    0xf, 0xef, 0x40, 0x0, 0xf, 0x85, 0xe1, 0x0,
    0xf, 0x10, 0x9b, 0x0, 0xf, 0x10, 0xd, 0x70,
    0xf, 0x10, 0x3, 0xf3, 0x0, 0xa, 0x50, 0x0,
    0x0, 0xd, 0x20, 0x0, 0x0, 0x4, 0x0, 0x0,

    /* U+137 "ķ" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x2, 0xe0, 0x1d, 0x50, 0x2e, 0xc,
    0x80, 0x2, 0xea, 0xa0, 0x0, 0x2f, 0xfb, 0x0,
    0x2, 0xf2, 0xd6, 0x0, 0x2e, 0x3, 0xe1, 0x2,
    0xe0, 0x8, 0xb0, 0x0, 0x34, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+138 "ĸ" */
    0x1f, 0x0, 0x8c, 0x1, 0xf0, 0x4e, 0x10, 0x1f,
    0x1e, 0x40, 0x1, 0xff, 0xb0, 0x0, 0x1f, 0x3e,
    0x50, 0x1, 0xf0, 0x4f, 0x20, 0x1f, 0x0, 0x6e,
    0x10,

    /* U+139 "Ĺ" */
    0x0, 0x71, 0x0, 0x0, 0xa5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0,
    0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0, 0xff,
    0xff, 0xf2,

    /* U+13A "ĺ" */
    0x1, 0x70, 0x9, 0x80, 0x6, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0,

    /* U+13B "Ļ" */
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,
    0x0, 0x71, 0x0, 0x0, 0xf, 0x0, 0x0, 0x2,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+13C "ļ" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f, 0x7, 0x1e, 0x47, 0x0,

    /* U+13D "Ľ" */
    0xf, 0x24, 0xb0, 0x0, 0xf2, 0x78, 0x0, 0xf,
    0x23, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+13E "ľ" */
    0x1f, 0xf, 0x1, 0xf3, 0xc0, 0x1f, 0x23, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0,
    0x0,

    /* U+13F "Ŀ" */
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x79, 0x0, 0xf, 0x21,
    0x10, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+140 "ŀ" */
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x3d, 0x1f, 0x2, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0,

    /* U+141 "Ł" */
    0xf, 0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf6, 0x60, 0x0, 0x9f, 0x71,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+142 "ł" */
    0xf, 0x20, 0xf, 0x20, 0xf, 0x20, 0xf, 0x20,
    0xf, 0xc0, 0x9f, 0x20, 0xf, 0x20, 0xf, 0x20,
    0xf, 0x20, 0xf, 0x20,

    /* U+143 "Ń" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x1, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x98,
    0xf, 0xf1, 0x0, 0x98, 0xf, 0xba, 0x0, 0x98,
    0xf, 0x3e, 0x40, 0x98, 0xf, 0x25, 0xd0, 0x98,
    0xf, 0x20, 0xb8, 0x98, 0xf, 0x20, 0x2f, 0xb8,
    0xf, 0x20, 0x8, 0xf8, 0xf, 0x20, 0x0, 0xd8,

    /* U+144 "ń" */
    0x0, 0x6, 0xc0, 0x0, 0xd, 0x10, 0x0, 0x0,
    0x0, 0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+145 "Ņ" */
    0xf, 0x60, 0x0, 0x98, 0xf, 0xf1, 0x0, 0x98,
    0xf, 0xba, 0x0, 0x98, 0xf, 0x3e, 0x40, 0x98,
    0xf, 0x25, 0xd0, 0x98, 0xf, 0x20, 0xb8, 0x98,
    0xf, 0x20, 0x2f, 0xb8, 0xf, 0x20, 0x8, 0xf8,
    0xf, 0x20, 0x0, 0xd8, 0x0, 0x2, 0x50, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x8, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+146 "ņ" */
    0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e, 0x0,
    0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e,
    0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x0, 0x16, 0x0,
    0x0, 0x4b, 0x0, 0x0, 0x75, 0x0, 0x0, 0x0,
    0x0,

    /* U+147 "Ň" */
    0x0, 0x24, 0x6, 0x0, 0x0, 0x8, 0xa2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x98,
    0xf, 0xf1, 0x0, 0x98, 0xf, 0xba, 0x0, 0x98,
    0xf, 0x3e, 0x40, 0x98, 0xf, 0x25, 0xd0, 0x98,
    0xf, 0x20, 0xb8, 0x98, 0xf, 0x20, 0x2f, 0xb8,
    0xf, 0x20, 0x8, 0xf8, 0xf, 0x20, 0x0, 0xd8,

    /* U+148 "ň" */
    0x2, 0xc4, 0xc0, 0x0, 0x5e, 0x10, 0x0, 0x0,
    0x0, 0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+149 "ŉ" */
    0xf, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x25,
    0x0, 0x0, 0x0, 0x2d, 0x8e, 0xd2, 0x2, 0xf6,
    0x9, 0xa0, 0x2e, 0x0, 0x4c, 0x2, 0xe0, 0x4,
    0xd0, 0x2e, 0x0, 0x4d, 0x2, 0xe0, 0x4, 0xd0,
    0x2e, 0x0, 0x4d,

    /* U+14A "Ŋ" */
    0xf, 0x60, 0x0, 0xb6, 0xf, 0xe1, 0x0, 0xb6,
    0xf, 0xb9, 0x0, 0xb6, 0xf, 0x2e, 0x30, 0xb6,
    0xf, 0x16, 0xc0, 0xb6, 0xf, 0x10, 0xd6, 0xb6,
    0xf, 0x10, 0x3e, 0xc6, 0xf, 0x10, 0xa, 0xf6,
    0xf, 0x10, 0x1, 0xe6, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0, 0x1, 0xe4, 0x0, 0x0, 0x2f, 0xa0,

    /* U+14B "ŋ" */
    0x2d, 0x8f, 0xd2, 0x2f, 0x50, 0x8b, 0x2f, 0x0,
    0x3e, 0x2f, 0x0, 0x2e, 0x2f, 0x0, 0x2e, 0x2f,
    0x0, 0x2e, 0x2f, 0x0, 0x2e, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x6c, 0x0, 0x9, 0xe4,

    /* U+14C "Ō" */
    0x0, 0xbe, 0xee, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfa, 0x10, 0x9, 0xc3, 0x29, 0xd0,
    0x1f, 0x20, 0x0, 0xd4, 0x3e, 0x0, 0x0, 0xa7,
    0x4d, 0x0, 0x0, 0x98, 0x4e, 0x0, 0x0, 0xa7,
    0x1f, 0x20, 0x0, 0xd4, 0x9, 0xc2, 0x19, 0xd0,
    0x0, 0x8e, 0xfb, 0x10,

    /* U+14D "ō" */
    0x8, 0xee, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xcf, 0xb1, 0x1, 0xe5, 0x7, 0xc0, 0x5c, 0x0,
    0xe, 0x27, 0xa0, 0x0, 0xc4, 0x5c, 0x0, 0xe,
    0x30, 0xe5, 0x7, 0xd0, 0x3, 0xcf, 0xc2, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0x43, 0x6, 0x0, 0x0, 0x2b, 0xc5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+14F "ŏ" */
    0x4, 0xa0, 0xd0, 0x0, 0x9, 0xc6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+150 "Ő" */
    0x0, 0x8, 0x79, 0x70, 0x0, 0x1d, 0x5b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+151 "ő" */
    0x0, 0x5b, 0x7b, 0x0, 0xb, 0x4c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+152 "Œ" */
    0x1, 0xaf, 0xff, 0xff, 0xff, 0x80, 0xca, 0x31,
    0xd5, 0x22, 0x21, 0x3e, 0x0, 0xd, 0x40, 0x0,
    0x5, 0xb0, 0x0, 0xd4, 0x0, 0x0, 0x6b, 0x0,
    0xd, 0xff, 0xff, 0x5, 0xb0, 0x0, 0xd4, 0x0,
    0x0, 0x3e, 0x0, 0xd, 0x40, 0x0, 0x0, 0xc8,
    0x10, 0xd4, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff,
    0xff, 0x80,

    /* U+153 "œ" */
    0x3, 0xdf, 0xb1, 0x7e, 0xe6, 0x0, 0xe5, 0x8,
    0xee, 0x22, 0xe2, 0x5c, 0x0, 0xf, 0x70, 0xa,
    0x66, 0xa0, 0x0, 0xef, 0xff, 0xf7, 0x4c, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xe5, 0x8, 0xed, 0x10,
    0x50, 0x3, 0xcf, 0xc2, 0x8e, 0xea, 0x10,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0x71, 0x0, 0x0, 0xa, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xe9, 0x0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0x10, 0x6, 0xc0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0xff, 0xf9, 0x0,
    0xf, 0x10, 0xa8, 0x0, 0xf, 0x10, 0x2e, 0x0,
    0xf, 0x10, 0xb, 0x70, 0xf, 0x10, 0x4, 0xe0,

    /* U+155 "ŕ" */
    0x0, 0x5c, 0x0, 0xc, 0x10, 0x0, 0x0, 0x2,
    0xeb, 0xd0, 0x2f, 0x50, 0x2, 0xe0, 0x0, 0x2e,
    0x0, 0x2, 0xe0, 0x0, 0x2e, 0x0, 0x2, 0xe0,
    0x0,

    /* U+156 "Ŗ" */
    0xf, 0xff, 0xe9, 0x0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0x10, 0x6, 0xc0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0xff, 0xf9, 0x0, 0xf, 0x10, 0xa8, 0x0,
    0xf, 0x10, 0x2e, 0x0, 0xf, 0x10, 0xb, 0x70,
    0xf, 0x10, 0x4, 0xe0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x39, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x2e, 0xbd, 0x2f, 0x50, 0x2e, 0x0,
    0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0,
    0x7, 0x0, 0x2d, 0x0, 0x57, 0x0, 0x0, 0x0,

    /* U+158 "Ř" */
    0x0, 0x60, 0x61, 0x0, 0x0, 0x4b, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xe9, 0x0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0x10, 0x6, 0xc0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0xff, 0xf9, 0x0,
    0xf, 0x10, 0xa8, 0x0, 0xf, 0x10, 0x2e, 0x0,
    0xf, 0x10, 0xb, 0x70, 0xf, 0x10, 0x4, 0xe0,

    /* U+159 "ř" */
    0x1c, 0x3c, 0x0, 0x4d, 0x10, 0x0, 0x0, 0x2,
    0xeb, 0xd0, 0x2f, 0x50, 0x2, 0xe0, 0x0, 0x2e,
    0x0, 0x2, 0xe0, 0x0, 0x2e, 0x0, 0x2, 0xe0,
    0x0,

    /* U+15A "Ś" */
    0x0, 0x2, 0xe2, 0x0, 0x0, 0xa5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+15B "ś" */
    0x0, 0x7, 0xb0, 0x0, 0x1d, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xef, 0xa0, 0x1f, 0x20, 0xb6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x6, 0xee, 0xa0,

    /* U+15C "Ŝ" */
    0x0, 0x2e, 0x50, 0x0, 0xc, 0x3b, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+15D "ŝ" */
    0x0, 0x6d, 0x10, 0x2, 0xb3, 0xa0, 0x0, 0x0,
    0x0, 0x6, 0xee, 0x90, 0x1f, 0x21, 0xc6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x7, 0xee, 0xa0,

    /* U+15E "Ş" */
    0x4, 0xcf, 0xd6, 0x1, 0xf5, 0x3, 0xe5, 0x3e,
    0x0, 0x5, 0x60, 0xd9, 0x20, 0x0, 0x1, 0x8e,
    0xc4, 0x0, 0x0, 0x5, 0xe5, 0x57, 0x0, 0x8,
    0xa3, 0xf4, 0x2, 0xc7, 0x4, 0xcf, 0xe8, 0x0,
    0x0, 0xb6, 0x0, 0x0, 0x0, 0xd0, 0x0, 0x0,
    0xa7, 0x0,

    /* U+15F "ş" */
    0x6, 0xee, 0x90, 0x1f, 0x21, 0xc6, 0x1f, 0x40,
    0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7, 0x4e,
    0x10, 0xa7, 0x7, 0xef, 0xa0, 0x0, 0x2d, 0x20,
    0x0, 0x6, 0x70, 0x0, 0x2c, 0x20,

    /* U+160 "Š" */
    0x0, 0xb4, 0xc2, 0x0, 0x2, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+161 "š" */
    0x2, 0xb4, 0xb0, 0x0, 0x6d, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xef, 0xa0, 0x1f, 0x20, 0xb6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x6, 0xee, 0xa0,

    /* U+162 "Ţ" */
    0xbf, 0xff, 0xff, 0xe0, 0x0, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0xb6, 0x0,

    /* U+163 "ţ" */
    0x6, 0x20, 0xc, 0x40, 0xdf, 0xe6, 0xc, 0x40,
    0xc, 0x40, 0xc, 0x40, 0xc, 0x40, 0xc, 0x60,
    0x5, 0xf7, 0x0, 0xc6, 0x0, 0x1d, 0x0, 0xb6,

    /* U+164 "Ť" */
    0x0, 0x60, 0x51, 0x0, 0x4, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xfe, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0,
    0xf2, 0x0,

    /* U+165 "ť" */
    0x0, 0x5, 0x30, 0x0, 0xb4, 0x6, 0x2b, 0x0,
    0xc4, 0x0, 0xdf, 0xe6, 0x0, 0xc4, 0x0, 0xc,
    0x40, 0x0, 0xc4, 0x0, 0xc, 0x40, 0x0, 0xc6,
    0x0, 0x5, 0xf7, 0x0,

    /* U+166 "Ŧ" */
    0xbf, 0xff, 0xff, 0xe0, 0x0, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x3f, 0xff, 0x70, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x62, 0x0, 0xc, 0x40, 0xd, 0xfe, 0x60,
    0xc, 0x40, 0x1f, 0xff, 0x90, 0xc, 0x40, 0x0,
    0xc4, 0x0, 0xc, 0x70, 0x0, 0x5f, 0x70,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0xb1, 0xc0, 0x1,
    0xa2, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf2,
    0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0, 0xc9,
    0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+169 "ũ" */
    0x0, 0x0, 0x0, 0x4, 0xe4, 0x75, 0xa, 0x19,
    0xc0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c,
    0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc, 0x7, 0xee,
    0x9c,

    /* U+16A "Ū" */
    0x0, 0xee, 0xed, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0,
    0xc9, 0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+16B "ū" */
    0x8, 0xee, 0xe4, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc,
    0x7, 0xee, 0x9c,

    /* U+16C "Ŭ" */
    0x0, 0x61, 0x24, 0x0, 0x5, 0xcb, 0x30, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+16D "ŭ" */
    0x5, 0x90, 0xe0, 0x0, 0x9c, 0x60, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x1f, 0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+16E "Ů" */
    0x0, 0x9, 0x80, 0x0, 0x4, 0x58, 0x10, 0x0,
    0x9, 0x80, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf2,
    0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0, 0xc9,
    0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+16F "ů" */
    0x0, 0x69, 0x20, 0x0, 0x91, 0x80, 0x0, 0x69,
    0x20, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c,
    0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc, 0x7, 0xee,
    0x9c,

    /* U+170 "Ű" */
    0x0, 0xb, 0x5c, 0x40, 0x4, 0xa8, 0x70, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+171 "ű" */
    0x0, 0x6a, 0x7a, 0x0, 0xc, 0x4c, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xe0, 0x4, 0xc0, 0x3e, 0x0,
    0x4c, 0x3, 0xe0, 0x4, 0xc0, 0x3e, 0x0, 0x4c,
    0x2, 0xe0, 0x4, 0xc0, 0x1f, 0x31, 0xbc, 0x0,
    0x7e, 0xe9, 0xc0,

    /* U+172 "Ų" */
    0x2f, 0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f,
    0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3,
    0xf0, 0xc9, 0x11, 0xbd, 0x2, 0xbf, 0xff, 0x50,
    0x0, 0x3f, 0x40, 0x0, 0x6, 0x90, 0x0, 0x0,
    0x2e, 0x70,

    /* U+173 "ų" */
    0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f,
    0x31, 0xbc, 0x7, 0xee, 0x9c, 0x0, 0x0, 0xc3,
    0x0, 0x2, 0xc0, 0x0, 0x0, 0xda,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x17, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x90, 0x3, 0xf0, 0x0, 0xd4, 0x4c, 0x0,
    0x7f, 0x40, 0x1f, 0x1, 0xf0, 0xc, 0xa8, 0x4,
    0xd0, 0xd, 0x30, 0xe3, 0xc0, 0x79, 0x0, 0x97,
    0x4b, 0xe, 0xb, 0x50, 0x6, 0xa8, 0x60, 0xa5,
    0xe2, 0x0, 0x2e, 0xd2, 0x6, 0xae, 0x0, 0x0,
    0xed, 0x0, 0x1f, 0xa0, 0x0, 0xb, 0x90, 0x0,
    0xd7, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x4, 0xe3, 0x0, 0x0, 0x1, 0xa1, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x70, 0x1f,
    0x10, 0x79, 0x5a, 0x5, 0xf5, 0xb, 0x51, 0xe0,
    0xa8, 0xa0, 0xe1, 0xd, 0x2d, 0xe, 0x2c, 0x0,
    0x99, 0xa0, 0xb9, 0x80, 0x4, 0xf6, 0x6, 0xf4,
    0x0, 0xf, 0x10, 0x2f, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x7, 0x10, 0x0, 0x0, 0xa6, 0xb1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x6, 0xd0,
    0x2f, 0x10, 0xe, 0x40, 0x9, 0x90, 0x6c, 0x0,
    0x1, 0xe1, 0xd4, 0x0, 0x0, 0x9c, 0xb0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+177 "ŷ" */
    0x0, 0xba, 0x0, 0x6, 0x66, 0x50, 0x0, 0x0,
    0x0, 0xb7, 0x0, 0xc6, 0x6c, 0x1, 0xf1, 0x1f,
    0x15, 0xc0, 0xc, 0x6a, 0x70, 0x7, 0xbe, 0x20,
    0x1, 0xfd, 0x0, 0x0, 0xc8, 0x0, 0x0, 0xb3,
    0x0, 0x4, 0xd0, 0x0, 0x7e, 0x40, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xe0, 0xa6, 0x0,
    0x0, 0x20, 0x10, 0x0, 0xa9, 0x0, 0x6, 0xd0,
    0x2f, 0x10, 0xe, 0x40, 0x9, 0x90, 0x6c, 0x0,
    0x1, 0xe1, 0xd4, 0x0, 0x0, 0x9c, 0xb0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0x71, 0x0, 0x0, 0x96, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17A "ź" */
    0x0, 0xb, 0x70, 0x0, 0x4a, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf5, 0x0, 0x5, 0xd0, 0x0,
    0x1e, 0x40, 0x0, 0xb9, 0x0, 0x6, 0xd0, 0x0,
    0x1e, 0x30, 0x0, 0x7f, 0xff, 0xf8,

    /* U+17B "Ż" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe2, 0x0, 0x0,
    0x2, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17C "ż" */
    0x0, 0x78, 0x0, 0x0, 0x22, 0x0, 0x6f, 0xff,
    0xf5, 0x0, 0x5, 0xd0, 0x0, 0x1e, 0x40, 0x0,
    0xb9, 0x0, 0x6, 0xd0, 0x0, 0x1e, 0x30, 0x0,
    0x7f, 0xff, 0xf8,

    /* U+17D "Ž" */
    0x0, 0x60, 0x51, 0x0, 0x4, 0xb7, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17E "ž" */
    0x6, 0x88, 0x70, 0x0, 0x99, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf5, 0x0, 0x5, 0xd0, 0x0,
    0x1e, 0x40, 0x0, 0xb9, 0x0, 0x6, 0xd0, 0x0,
    0x1e, 0x30, 0x0, 0x7f, 0xff, 0xf8,

    /* U+17F "ſ" */
    0x5, 0xea, 0xe, 0x40, 0xf, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0,
    0x0, 0x3, 0x7c, 0xff, 0x0, 0x0, 0x59, 0xef,
    0xff, 0xff, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xf, 0xff, 0xfd, 0x84, 0x8f, 0x0, 0xf,
    0xd7, 0x20, 0x0, 0x8f, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x8f, 0x0, 0xf, 0x80, 0x0, 0x0, 0x8f,
    0x0, 0xf, 0x80, 0x0, 0x7b, 0xdf, 0x2, 0x3f,
    0x80, 0x6, 0xff, 0xff, 0xaf, 0xff, 0x80, 0x2,
    0xef, 0xf9, 0xef, 0xff, 0x60, 0x0, 0x2, 0x10,
    0x29, 0xa7, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xb4, 0xdf, 0xff, 0xff, 0xfd, 0x4b, 0xe8, 0xe7,
    0x22, 0x22, 0x7e, 0x8e, 0xc0, 0xc5, 0x0, 0x0,
    0x6c, 0xc, 0xfc, 0xf6, 0x11, 0x11, 0x7f, 0xcf,
    0xc0, 0xcf, 0xff, 0xff, 0xfb, 0xc, 0xfc, 0xf6,
    0x11, 0x11, 0x7f, 0xcf, 0xc0, 0xc5, 0x0, 0x0,
    0x6c, 0xc, 0xe8, 0xe7, 0x22, 0x22, 0x7e, 0x8e,
    0xb4, 0xdf, 0xff, 0xff, 0xfd, 0x4b,

    /* U+F00B "" */
    0xdf, 0xf6, 0x9f, 0xff, 0xff, 0xfd, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xef, 0xf6, 0xaf, 0xff,
    0xff, 0xfe, 0x13, 0x20, 0x3, 0x33, 0x33, 0x31,
    0xff, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbf, 0xff,
    0xff, 0xff, 0x13, 0x20, 0x3, 0x33, 0x33, 0x31,
    0xef, 0xf6, 0xaf, 0xff, 0xff, 0xfe, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xdf, 0xf6, 0xaf, 0xff,
    0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfe, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf4, 0x4d, 0x30, 0x0, 0x3f, 0xff, 0x40,
    0xef, 0xf3, 0x3, 0xff, 0xf4, 0x0, 0x4f, 0xff,
    0x6f, 0xff, 0x40, 0x0, 0x4, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x3, 0xd3, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x14, 0x0, 0x0, 0x22, 0xd, 0xf7, 0x0, 0x4f,
    0xf1, 0x9f, 0xf7, 0x4f, 0xfd, 0x0, 0xaf, 0xff,
    0xfd, 0x10, 0x0, 0xbf, 0xfe, 0x10, 0x0, 0x4f,
    0xff, 0xf7, 0x0, 0x4f, 0xfd, 0xaf, 0xf7, 0xe,
    0xfd, 0x10, 0xaf, 0xf2, 0x5b, 0x10, 0x0, 0x99,
    0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x32,
    0xf, 0xf0, 0x24, 0x0, 0x5, 0xfc, 0xf, 0xf0,
    0xcf, 0x50, 0x1f, 0xf4, 0xf, 0xf0, 0x5f, 0xf1,
    0x7f, 0x80, 0xf, 0xf0, 0x8, 0xf7, 0xbf, 0x20,
    0xf, 0xf0, 0x2, 0xfb, 0xcf, 0x10, 0xe, 0xe0,
    0x1, 0xfc, 0xaf, 0x40, 0x1, 0x10, 0x4, 0xfa,
    0x5f, 0xb0, 0x0, 0x0, 0xb, 0xf6, 0xd, 0xfa,
    0x10, 0x1, 0xaf, 0xd0, 0x2, 0xdf, 0xfc, 0xcf,
    0xfd, 0x20, 0x0, 0x8, 0xef, 0xfe, 0x91, 0x0,
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x14, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf7, 0x0, 0x0, 0x3, 0x43, 0xdf, 0xfd,
    0x34, 0x30, 0xe, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x6f, 0xff, 0xfb, 0xbf, 0xff, 0xf6, 0x1b, 0xff,
    0x70, 0x7, 0xff, 0xb1, 0x7, 0xff, 0x20, 0x2,
    0xff, 0x70, 0x1b, 0xff, 0x70, 0x7, 0xff, 0xb1,
    0x6f, 0xff, 0xfb, 0xbf, 0xff, 0xf6, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x3, 0x42, 0xcf, 0xfc,
    0x23, 0x30, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x41, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x73, 0x3, 0x83, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x67, 0xf7, 0x0, 0x0, 0x3,
    0xee, 0x5a, 0xfe, 0xf7, 0x0, 0x0, 0x6f, 0xd3,
    0xb5, 0x7f, 0xf7, 0x0, 0x9, 0xfb, 0x3d, 0xff,
    0x85, 0xfe, 0x30, 0xbf, 0x95, 0xff, 0xff, 0xfb,
    0x3e, 0xf4, 0x76, 0x6f, 0xff, 0xff, 0xff, 0xd2,
    0xa1, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xcf, 0xfa, 0x2, 0xff, 0xf4, 0x0, 0x0,
    0xcf, 0xfa, 0x2, 0xff, 0xf4, 0x0, 0x0, 0xaf,
    0xf8, 0x1, 0xff, 0xf3, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x27, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x4, 0xff, 0xff, 0x40, 0x0,
    0x23, 0x33, 0x5f, 0xf5, 0x33, 0x32, 0xff, 0xff,
    0xa4, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x8f,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8,

    /* U+F01C "" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x1,
    0xed, 0x88, 0x88, 0x89, 0xf8, 0x0, 0xa, 0xf2,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x1e, 0xc0, 0xef, 0x88, 0x60, 0x0,
    0x28, 0x8b, 0xf6, 0xff, 0xff, 0xf3, 0x0, 0xbf,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+F021 "" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x59, 0x0, 0x19,
    0xef, 0xfd, 0x70, 0x9f, 0x3, 0xef, 0xda, 0x9d,
    0xfe, 0xbf, 0xe, 0xf6, 0x0, 0x0, 0x5f, 0xff,
    0x7f, 0x70, 0x0, 0x3f, 0xff, 0xff, 0x69, 0x0,
    0x0, 0x2a, 0xaa, 0xa9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaa, 0xaa, 0xa2, 0x0, 0x0, 0xa6,
    0xff, 0xfe, 0xf3, 0x0, 0x7, 0xf7, 0xff, 0xf5,
    0x0, 0x0, 0x7f, 0xe0, 0xfb, 0xef, 0xd9, 0xad,
    0xfe, 0x30, 0xfa, 0x8, 0xef, 0xfe, 0x91, 0x0,
    0x95, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x2a, 0x0, 0x2, 0xef, 0x78, 0x8e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0x0, 0x7, 0xff,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x1,

    /* U+F027 "" */
    0x0, 0x0, 0x2a, 0x0, 0x0, 0x0, 0x2e, 0xf0,
    0x0, 0x78, 0x8e, 0xff, 0x3, 0xf, 0xff, 0xff,
    0xf0, 0xba, 0xff, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xff, 0xf0, 0xaa, 0xdf, 0xff, 0xff, 0x4, 0x0,
    0x0, 0x8f, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xd2, 0x0, 0x0, 0x0,
    0x2a, 0x0, 0x11, 0x8e, 0x10, 0x0, 0x2, 0xef,
    0x0, 0x7d, 0x2b, 0x90, 0x78, 0x8e, 0xff, 0x3,
    0xa, 0xb3, 0xf0, 0xff, 0xff, 0xff, 0xb, 0xa1,
    0xf1, 0xe3, 0xff, 0xff, 0xff, 0x3, 0xf0, 0xe3,
    0xc5, 0xff, 0xff, 0xff, 0xb, 0xa1, 0xf1, 0xe3,
    0xdf, 0xff, 0xff, 0x3, 0xa, 0xb3, 0xf0, 0x0,
    0x7, 0xff, 0x0, 0x7d, 0x2b, 0x90, 0x0, 0x0,
    0x7f, 0x0, 0x11, 0x9e, 0x10, 0x0, 0x0, 0x1,
    0x0, 0x6, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F03E "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfd, 0x5b,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x1, 0xff, 0xff,
    0xef, 0xff, 0xfb, 0x18, 0xff, 0xf6, 0x1c, 0xff,
    0xff, 0xfc, 0xff, 0x60, 0x1, 0xdf, 0xff, 0x60,
    0x96, 0x0, 0x0, 0x8f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xfc, 0x88, 0x88, 0x88, 0x88, 0xcf,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F048 "" */
    0x58, 0x0, 0x0, 0x35, 0x9f, 0x10, 0x5, 0xfe,
    0x9f, 0x10, 0x6f, 0xfe, 0x9f, 0x17, 0xff, 0xfe,
    0x9f, 0x9f, 0xff, 0xfe, 0x9f, 0xff, 0xff, 0xfe,
    0x9f, 0xef, 0xff, 0xfe, 0x9f, 0x2d, 0xff, 0xfe,
    0x9f, 0x10, 0xcf, 0xfe, 0x9f, 0x10, 0xb, 0xfe,
    0x8f, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x46, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xa1, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfd, 0x50, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xb1, 0xff, 0xff, 0xff, 0xfd,
    0x40, 0xf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xff,
    0xff, 0xa1, 0x0, 0x0, 0xf, 0xfd, 0x40, 0x0,
    0x0, 0x0, 0x36, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0xaf, 0xfe, 0x30, 0xaf, 0xfe, 0x3f, 0xff, 0xf7,
    0xf, 0xff, 0xf7, 0xff, 0xff, 0x80, 0xff, 0xff,
    0x8f, 0xff, 0xf8, 0xf, 0xff, 0xf8, 0xff, 0xff,
    0x80, 0xff, 0xff, 0x8f, 0xff, 0xf8, 0xf, 0xff,
    0xf8, 0xff, 0xff, 0x80, 0xff, 0xff, 0x8f, 0xff,
    0xf8, 0xf, 0xff, 0xf8, 0xff, 0xff, 0x80, 0xff,
    0xff, 0x8f, 0xff, 0xf7, 0xf, 0xff, 0xf7, 0x48,
    0x98, 0x10, 0x48, 0x98, 0x10,

    /* U+F04D "" */
    0x48, 0x88, 0x88, 0x88, 0x88, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xaf,
    0xff, 0xff, 0xff, 0xfe, 0x30,

    /* U+F051 "" */
    0x26, 0x0, 0x0, 0x58, 0x7f, 0xa0, 0x0, 0xbf,
    0x8f, 0xfb, 0x0, 0xbf, 0x8f, 0xff, 0xc1, 0xbf,
    0x8f, 0xff, 0xfd, 0xcf, 0x8f, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xef, 0x8f, 0xff, 0xf4, 0xbf,
    0x8f, 0xff, 0x40, 0xbf, 0x8f, 0xe3, 0x0, 0xbf,
    0x5d, 0x20, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x3, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xfa, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0x90, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xf8, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0xff, 0x70, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x1, 0x34, 0x44, 0x44, 0x44, 0x30,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xf5,

    /* U+F053 "" */
    0x0, 0x0, 0x3, 0x10, 0x0, 0x5, 0xfb, 0x0,
    0x5, 0xff, 0x40, 0x5, 0xff, 0x40, 0x5, 0xff,
    0x50, 0x3, 0xff, 0x50, 0x0, 0xb, 0xfc, 0x10,
    0x0, 0xb, 0xfc, 0x10, 0x0, 0xc, 0xfc, 0x10,
    0x0, 0xc, 0xfb, 0x0, 0x0, 0xa, 0x50,

    /* U+F054 "" */
    0x3, 0x10, 0x0, 0x3, 0xfc, 0x10, 0x0, 0xb,
    0xfc, 0x10, 0x0, 0xb, 0xfc, 0x10, 0x0, 0xb,
    0xfc, 0x10, 0x0, 0xd, 0xfb, 0x0, 0x5, 0xff,
    0x50, 0x5, 0xff, 0x50, 0x5, 0xff, 0x50, 0x3,
    0xff, 0x50, 0x0, 0xa, 0x50, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x69, 0x10, 0x0, 0x0, 0x0, 0xd,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xef, 0x60, 0x0,
    0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x58, 0x88,
    0xff, 0xb8, 0x88, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x9b, 0xbb, 0xff, 0xdb, 0xbb, 0x30, 0x0,
    0xe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xef, 0x60,
    0x0, 0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x20, 0x0, 0x0,

    /* U+F068 "" */
    0x46, 0x66, 0x66, 0x66, 0x66, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xad, 0xdd, 0xdd, 0xdd, 0xdd,
    0x40,

    /* U+F06E "" */
    0x0, 0x3, 0xad, 0xff, 0xc7, 0x0, 0x0, 0x0,
    0x9f, 0xe6, 0x24, 0xaf, 0xe3, 0x0, 0xb, 0xff,
    0x20, 0x77, 0x9, 0xff, 0x40, 0x7f, 0xf9, 0x0,
    0xcf, 0xa1, 0xff, 0xe1, 0xef, 0xf6, 0x7f, 0xff,
    0xf0, 0xef, 0xf7, 0x8f, 0xf9, 0x3f, 0xff, 0xc1,
    0xff, 0xe1, 0xb, 0xff, 0x26, 0xca, 0x19, 0xff,
    0x40, 0x0, 0x9f, 0xe6, 0x24, 0xaf, 0xe3, 0x0,
    0x0, 0x3, 0x9d, 0xff, 0xc7, 0x0, 0x0,

    /* U+F070 "" */
    0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xf8, 0x4a, 0xef, 0xeb, 0x50, 0x0, 0x0,
    0x0, 0x9f, 0xfd, 0x52, 0x5d, 0xfc, 0x10, 0x0,
    0x0, 0x5, 0xfe, 0x4a, 0x70, 0xcf, 0xe1, 0x0,
    0xb, 0x80, 0x2d, 0xff, 0xf7, 0x4f, 0xfb, 0x0,
    0x2f, 0xfb, 0x0, 0xaf, 0xfb, 0x2f, 0xff, 0x30,
    0xb, 0xff, 0x50, 0x7, 0xfe, 0x7f, 0xfb, 0x0,
    0x1, 0xdf, 0xc0, 0x0, 0x3e, 0xff, 0xe1, 0x0,
    0x0, 0x1b, 0xfc, 0x42, 0x1, 0xbf, 0xa0, 0x0,
    0x0, 0x0, 0x5b, 0xef, 0xb0, 0x8, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x40,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x3, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xfd, 0xef, 0xa0, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x3, 0xff, 0x30, 0x0, 0x0, 0x4, 0xff,
    0xc0, 0x4f, 0xfc, 0x0, 0x0, 0x0, 0xdf, 0xfd,
    0x5, 0xff, 0xf6, 0x0, 0x0, 0x7f, 0xff, 0xf8,
    0xcf, 0xff, 0xe1, 0x0, 0x1f, 0xff, 0xfc, 0x4,
    0xff, 0xff, 0x90, 0xa, 0xff, 0xff, 0xd2, 0x7f,
    0xff, 0xff, 0x20, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x4, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc1, 0xff, 0xf8, 0x0, 0x2e,
    0xff, 0xfc, 0xcd, 0xff, 0x62, 0xef, 0xdf, 0xf9,
    0x0, 0x2c, 0x4e, 0xf9, 0xf, 0x90, 0x0, 0x2,
    0xef, 0x90, 0x7, 0x0, 0x0, 0x2e, 0xf8, 0x88,
    0xf, 0xa0, 0xcd, 0xff, 0x80, 0xdf, 0xdf, 0xf9,
    0xff, 0xf8, 0x0, 0x1e, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0x10,

    /* U+F077 "" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xf9, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0,
    0x0, 0x2e, 0xf9, 0x2e, 0xf9, 0x0, 0x2e, 0xf9,
    0x0, 0x2e, 0xf9, 0xb, 0xf9, 0x0, 0x0, 0x2e,
    0xf4, 0x27, 0x0, 0x0, 0x0, 0x27, 0x0,

    /* U+F078 "" */
    0x27, 0x0, 0x0, 0x0, 0x27, 0xb, 0xf9, 0x0,
    0x0, 0x2e, 0xf4, 0x2e, 0xf9, 0x0, 0x2e, 0xf9,
    0x0, 0x2e, 0xf9, 0x2e, 0xf9, 0x0, 0x0, 0x2e,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x2e, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x26, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xc0, 0x7, 0x77, 0x77, 0x72, 0x0,
    0x3, 0xff, 0xfc, 0x2e, 0xff, 0xff, 0xf9, 0x0,
    0xf, 0xcf, 0xcf, 0xa0, 0x0, 0x0, 0xe9, 0x0,
    0x4, 0x1e, 0x93, 0x20, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0xb5, 0xe9, 0x97,
    0x0, 0xe, 0xc7, 0x77, 0x73, 0xbf, 0xff, 0xf6,
    0x0, 0xd, 0xff, 0xff, 0xfd, 0xb, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa6, 0x0,

    /* U+F07B "" */
    0xbf, 0xff, 0xf6, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x98, 0x88, 0x74, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F093 "" */
    0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xe3, 0x0, 0x0, 0x0, 0x3, 0xef, 0xfe,
    0x30, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xe3, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x8f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0,
    0x23, 0x32, 0x8f, 0xf8, 0x23, 0x32, 0xff, 0xfe,
    0x39, 0x93, 0xef, 0xff, 0xff, 0xff, 0xc9, 0x9c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x8f,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x62, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x1,
    0x0, 0x9, 0xff, 0x40, 0x1, 0x8e, 0xe1, 0x1a,
    0xff, 0x70, 0x0, 0xef, 0xff, 0xde, 0xff, 0x90,
    0x0, 0xc, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x8f, 0xff, 0xe9, 0x10, 0x0, 0x0, 0x2, 0x76,
    0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x7, 0x93, 0x0, 0x0, 0x22, 0xa, 0xff, 0xf2,
    0x0, 0x8f, 0xf5, 0xf9, 0x1f, 0x70, 0x8f, 0xf9,
    0xc, 0xfc, 0xf8, 0x8f, 0xf9, 0x0, 0x1a, 0xef,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0xef, 0xfc, 0x0,
    0x0, 0x7, 0xbf, 0xff, 0xf6, 0x0, 0xa, 0xff,
    0xfa, 0xbf, 0xf6, 0x0, 0xf9, 0x1f, 0x70, 0xbf,
    0xf6, 0xc, 0xfc, 0xf4, 0x0, 0xbf, 0xf4, 0x1a,
    0xc6, 0x0, 0x0, 0x56, 0x0,

    /* U+F0C5 "" */
    0x0, 0x3, 0x44, 0x41, 0x20, 0x0, 0x0, 0xff,
    0xff, 0x5e, 0x40, 0x24, 0x1f, 0xff, 0xf5, 0xee,
    0x2f, 0xf4, 0xff, 0xff, 0xc8, 0x82, 0xff, 0x4f,
    0xff, 0xff, 0xff, 0x5f, 0xf4, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0x4f, 0xff, 0xff, 0xff, 0x5f, 0xf4,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0x4f, 0xff, 0xff,
    0xff, 0x5f, 0xf4, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0x93, 0x44, 0x44, 0x43, 0xf, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x68, 0x88, 0x88, 0x71, 0x0, 0x0,

    /* U+F0C7 "" */
    0x48, 0x88, 0x88, 0x87, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0xf8, 0x0, 0x0, 0xb, 0xfb,
    0xf, 0x80, 0x0, 0x0, 0xbf, 0xf3, 0xfb, 0x77,
    0x77, 0x7d, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0x42, 0xdf, 0xff, 0x4f, 0xff,
    0xc0, 0x8, 0xff, 0xf4, 0xff, 0xfe, 0x0, 0xaf,
    0xff, 0x4f, 0xff, 0xfc, 0xaf, 0xff, 0xf4, 0xaf,
    0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F0E7 "" */
    0x1, 0xbb, 0xba, 0x10, 0x0, 0x5f, 0xff, 0xf1,
    0x0, 0x7, 0xff, 0xfb, 0x0, 0x0, 0x9f, 0xff,
    0x60, 0x0, 0xb, 0xff, 0xff, 0xff, 0x60, 0xef,
    0xff, 0xff, 0xf1, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xc, 0xfe, 0x0, 0x0, 0x0, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0xa9, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x2a, 0x50, 0x0, 0x0, 0xe, 0xff, 0x8f,
    0xff, 0x20, 0x0, 0xff, 0xf8, 0xff, 0xf4, 0x0,
    0xf, 0xff, 0xeb, 0xbb, 0x30, 0x0, 0xff, 0xf4,
    0x99, 0x92, 0x60, 0xf, 0xff, 0x5f, 0xff, 0x4f,
    0xa0, 0xff, 0xf5, 0xff, 0xf5, 0x56, 0x1f, 0xff,
    0x5f, 0xff, 0xff, 0xf4, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0x4e, 0xff, 0x5f, 0xff, 0xff, 0xf4, 0x0,
    0x5, 0xff, 0xff, 0xff, 0x40, 0x0, 0x5f, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x44, 0x44, 0x44, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x15, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xf9, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xf7, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0x50, 0x6f, 0xff, 0xff, 0xff,
    0xfd, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x24,
    0x44, 0x44, 0x44, 0x43, 0x0, 0x0, 0x2f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x46, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xfc,
    0x8e, 0x8e, 0x8e, 0x88, 0xe8, 0xf7, 0xf8, 0xc,
    0xc, 0xb, 0x0, 0xb0, 0xf8, 0xff, 0xec, 0xfc,
    0xec, 0xee, 0xcf, 0xf8, 0xff, 0xa0, 0xc0, 0xa0,
    0x77, 0x2f, 0xf8, 0xff, 0xec, 0xfc, 0xec, 0xee,
    0xcf, 0xf8, 0xf8, 0xc, 0x0, 0x0, 0x0, 0xb0,
    0xf8, 0xfc, 0x8e, 0x88, 0x88, 0x88, 0xe8, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x18, 0xef, 0xe0, 0x0, 0x0,
    0x0, 0x29, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x3a,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x4c, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x1, 0x34, 0x44, 0xdf, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26,
    0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x9b, 0xbb, 0xb2, 0x70, 0xf, 0xff, 0xff, 0x4f,
    0x90, 0xff, 0xff, 0xf4, 0xff, 0x9f, 0xff, 0xff,
    0x54, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x44,
    0x44, 0x44, 0x30,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x9b, 0xcb, 0x95, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3, 0xef,
    0xfa, 0x53, 0x23, 0x5a, 0xff, 0xe3, 0xdf, 0xa1,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xd2, 0x60, 0x5,
    0xbe, 0xfe, 0xb5, 0x0, 0x52, 0x0, 0x1c, 0xff,
    0xfe, 0xff, 0xfc, 0x10, 0x0, 0x2, 0xec, 0x40,
    0x0, 0x4c, 0xe2, 0x0, 0x0, 0x1, 0x0, 0x1,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd6, 0x0,
    0x0, 0x0,

    /* U+F240 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x44, 0x44, 0x44, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xf8, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0xcc, 0xcc, 0xc3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F241 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x44, 0x43, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0xff, 0xc0, 0x2, 0xcf, 0xf8, 0xcf,
    0xff, 0xff, 0xfc, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0xcc, 0x90, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F242 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x44, 0x42, 0x0, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0xff, 0x80, 0x0, 0x2, 0xcf, 0xf8, 0xcf,
    0xff, 0xf8, 0x0, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0xcc, 0x60, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F243 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x34, 0x41, 0x0, 0x0, 0x0, 0x4f, 0xdf, 0x8c,
    0xff, 0x40, 0x0, 0x0, 0x2, 0xcf, 0xf8, 0xcf,
    0xf4, 0x0, 0x0, 0x0, 0x8, 0xff, 0x89, 0xcc,
    0x30, 0x0, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F244 "" */
    0x37, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xdf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xcf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x9f, 0x9c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x25, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xcb, 0xfe, 0x0, 0x0, 0x0,
    0x1, 0x0, 0xd, 0x10, 0x42, 0x0, 0x0, 0x0,
    0x9f, 0xd1, 0x68, 0x0, 0x0, 0x0, 0x68, 0x0,
    0xff, 0xfe, 0xee, 0xed, 0xdd, 0xdd, 0xef, 0xc0,
    0x9f, 0xd1, 0x0, 0xb3, 0x0, 0x0, 0x68, 0x0,
    0x1, 0x0, 0x0, 0x3b, 0x5, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xbe, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x34, 0x20, 0x0, 0x0, 0x6e, 0xfe,
    0xfd, 0x20, 0x4, 0xff, 0xf3, 0xff, 0xd0, 0xc,
    0xff, 0xf0, 0x4f, 0xf5, 0xf, 0xd5, 0xf2, 0x95,
    0xf8, 0x2f, 0xf7, 0x41, 0x3c, 0xfa, 0x3f, 0xff,
    0x60, 0xaf, 0xfb, 0x3f, 0xfe, 0x20, 0x4f, 0xfb,
    0x2f, 0xe2, 0x92, 0x75, 0xfa, 0xf, 0xeb, 0xf1,
    0x49, 0xf8, 0x9, 0xff, 0xf0, 0x9f, 0xf2, 0x1,
    0xdf, 0xf9, 0xff, 0x90, 0x0, 0x6, 0xab, 0x95,
    0x0,

    /* U+F2ED "" */
    0x0, 0x4, 0x88, 0x70, 0x0, 0xb, 0xcc, 0xff,
    0xff, 0xdc, 0xc5, 0xbc, 0xcc, 0xcc, 0xcc, 0xcc,
    0x52, 0x88, 0x88, 0x88, 0x88, 0x60, 0x4f, 0xff,
    0xff, 0xff, 0xfc, 0x4, 0xfa, 0xae, 0x6f, 0x5f,
    0xc0, 0x4f, 0xaa, 0xe6, 0xf4, 0xfc, 0x4, 0xfa,
    0xae, 0x6f, 0x4f, 0xc0, 0x4f, 0xaa, 0xe6, 0xf4,
    0xfc, 0x4, 0xfa, 0xae, 0x6f, 0x4f, 0xc0, 0x4f,
    0xaa, 0xe6, 0xf5, 0xfc, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x6, 0x88, 0x88, 0x88, 0x72, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x71, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xd1, 0x0, 0x0, 0x0,
    0x1, 0x5f, 0xff, 0xc0, 0x0, 0x0, 0x2, 0xea,
    0x5f, 0xfd, 0x0, 0x0, 0x2, 0xef, 0xfa, 0x5d,
    0x20, 0x0, 0x2, 0xef, 0xff, 0xf8, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xfe, 0x20, 0x0, 0x2, 0xef,
    0xff, 0xfe, 0x20, 0x0, 0x2, 0xef, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0xbf, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0xd, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x6, 0x64,
    0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x5, 0xef, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5,
    0xff, 0xff, 0x91, 0xdd, 0x19, 0xff, 0xf5, 0xff,
    0xff, 0xfd, 0x11, 0x11, 0xdf, 0xff, 0xef, 0xff,
    0xff, 0xfb, 0x0, 0xbf, 0xff, 0xf5, 0xff, 0xff,
    0xfd, 0x11, 0x11, 0xdf, 0xff, 0x5, 0xff, 0xff,
    0x91, 0xdd, 0x19, 0xff, 0xf0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F7C2 "" */
    0x0, 0x17, 0x88, 0x87, 0x20, 0x2d, 0xff, 0xff,
    0xfd, 0x2e, 0xa0, 0xb3, 0x78, 0xfe, 0xfa, 0xb,
    0x37, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0x4, 0x44,
    0x44, 0x44, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x69, 0x0,
    0x0, 0x0, 0xdf, 0x0, 0x7f, 0xc0, 0x0, 0x0,
    0xd, 0xf0, 0x8f, 0xff, 0xdd, 0xdd, 0xdd, 0xff,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xb,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 48, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 49, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14, .adv_w = 61, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 22, .adv_w = 118, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 100, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 141, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 177, .adv_w = 33, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 181, .adv_w = 66, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 209, .adv_w = 67, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 237, .adv_w = 83, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 252, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 277, .adv_w = 38, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 281, .adv_w = 53, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 283, .adv_w = 51, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 286, .adv_w = 79, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 311, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 343, .adv_w = 108, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 361, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 393, .adv_w = 108, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 420, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 452, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 484, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 516, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 548, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 580, .adv_w = 108, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 607, .adv_w = 47, .box_w = 3, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 618, .adv_w = 41, .box_w = 2, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 627, .adv_w = 98, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 645, .adv_w = 105, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 660, .adv_w = 100, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 678, .adv_w = 91, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 705, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 771, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 807, .adv_w = 120, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 839, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 875, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 911, .adv_w = 109, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 943, .adv_w = 106, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 975, .adv_w = 131, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1011, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1047, .adv_w = 52, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1056, .adv_w = 106, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1083, .adv_w = 120, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1119, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1151, .adv_w = 168, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1196, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1232, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1268, .adv_w = 121, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1304, .adv_w = 132, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1348, .adv_w = 118, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1384, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1416, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1448, .adv_w = 125, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1480, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1516, .adv_w = 170, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1566, .adv_w = 120, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1602, .adv_w = 115, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1638, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1670, .adv_w = 51, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1696, .adv_w = 79, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1721, .adv_w = 51, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1741, .adv_w = 80, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 1754, .adv_w = 87, .box_w = 6, .box_h = 1, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1757, .adv_w = 59, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 1760, .adv_w = 104, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1781, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1816, .adv_w = 101, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1837, .adv_w = 108, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1867, .adv_w = 102, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1888, .adv_w = 67, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1913, .adv_w = 108, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1943, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1973, .adv_w = 47, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1987, .adv_w = 46, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2011, .adv_w = 97, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2046, .adv_w = 47, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2056, .adv_w = 168, .box_w = 10, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2091, .adv_w = 106, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2112, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2137, .adv_w = 108, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2172, .adv_w = 109, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2202, .adv_w = 65, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2218, .adv_w = 99, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2239, .adv_w = 63, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2257, .adv_w = 106, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2278, .adv_w = 93, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2299, .adv_w = 144, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2331, .adv_w = 95, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2352, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2382, .adv_w = 95, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2403, .adv_w = 65, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2429, .adv_w = 47, .box_w = 1, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2435, .adv_w = 65, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2461, .adv_w = 131, .box_w = 8, .box_h = 4, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2477, .adv_w = 48, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2477, .adv_w = 47, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2491, .adv_w = 105, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2521, .adv_w = 112, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2553, .adv_w = 137, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2598, .adv_w = 101, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2630, .adv_w = 46, .box_w = 2, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2641, .adv_w = 118, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2687, .adv_w = 80, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 2695, .adv_w = 151, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2740, .adv_w = 86, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2753, .adv_w = 90, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2771, .adv_w = 106, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2780, .adv_w = 53, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2782, .adv_w = 151, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2827, .adv_w = 88, .box_w = 5, .box_h = 1, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 2830, .adv_w = 72, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 2836, .adv_w = 103, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2860, .adv_w = 70, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2870, .adv_w = 70, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2880, .adv_w = 60, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 2884, .adv_w = 109, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2914, .adv_w = 94, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2937, .adv_w = 50, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2942, .adv_w = 48, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2948, .adv_w = 70, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2956, .adv_w = 87, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2969, .adv_w = 90, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2987, .adv_w = 141, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3032, .adv_w = 149, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3077, .adv_w = 149, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3118, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3148, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3196, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3244, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3292, .adv_w = 125, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3344, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3392, .adv_w = 125, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3444, .adv_w = 179, .box_w = 13, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3503, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3551, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3593, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3635, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3677, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3719, .adv_w = 52, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3743, .adv_w = 52, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3761, .adv_w = 52, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3791, .adv_w = 52, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3821, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3857, .adv_w = 137, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3909, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3957, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4005, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4053, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4105, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4153, .adv_w = 102, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4174, .adv_w = 132, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4218, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4260, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4302, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4344, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4386, .adv_w = 115, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4434, .adv_w = 113, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4466, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4501, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4531, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4561, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4591, .adv_w = 104, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4624, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4651, .adv_w = 104, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4684, .adv_w = 162, .box_w = 10, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4719, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4749, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4779, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4809, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4839, .adv_w = 102, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4866, .adv_w = 47, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4886, .adv_w = 47, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4906, .adv_w = 47, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4931, .adv_w = 47, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4954, .adv_w = 113, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4989, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5022, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5057, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5092, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5127, .adv_w = 110, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5166, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5198, .adv_w = 110, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5226, .adv_w = 109, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5258, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5288, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5318, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5348, .adv_w = 106, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5375, .adv_w = 91, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5414, .adv_w = 111, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5460, .adv_w = 91, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5496, .adv_w = 125, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5540, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5567, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5615, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5645, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5693, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5723, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5771, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5801, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5849, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5879, .adv_w = 125, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5931, .adv_w = 101, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5958, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6006, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6036, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6084, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6124, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6160, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6200, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6239, .adv_w = 102, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6266, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6308, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6338, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6380, .adv_w = 102, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6407, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6449, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6479, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6521, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6551, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6599, .adv_w = 108, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6638, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6686, .adv_w = 108, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6725, .adv_w = 131, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6777, .adv_w = 108, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6813, .adv_w = 131, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6865, .adv_w = 108, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6907, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6955, .adv_w = 106, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6991, .adv_w = 134, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7032, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7067, .adv_w = 52, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7100, .adv_w = 47, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7128, .adv_w = 52, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7156, .adv_w = 47, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7179, .adv_w = 52, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7209, .adv_w = 47, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7234, .adv_w = 52, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7252, .adv_w = 47, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7276, .adv_w = 52, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7294, .adv_w = 47, .box_w = 2, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7301, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7337, .adv_w = 92, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7367, .adv_w = 106, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7409, .adv_w = 48, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7442, .adv_w = 120, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7490, .adv_w = 97, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7539, .adv_w = 107, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7564, .adv_w = 103, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7606, .adv_w = 47, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7632, .adv_w = 103, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7678, .adv_w = 47, .box_w = 2, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7692, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7724, .adv_w = 61, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7749, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7781, .adv_w = 67, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7801, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7833, .adv_w = 52, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7853, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7901, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7931, .adv_w = 137, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7983, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8016, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8064, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8094, .adv_w = 106, .box_w = 7, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8129, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8177, .adv_w = 109, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8207, .adv_w = 132, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8251, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8283, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8331, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8366, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8414, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8449, .adv_w = 183, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8499, .adv_w = 174, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8538, .adv_w = 118, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8586, .adv_w = 65, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8611, .adv_w = 118, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8663, .adv_w = 65, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8687, .adv_w = 118, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8735, .adv_w = 65, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8760, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8802, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8832, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8874, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8904, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8946, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8976, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9018, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9048, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9090, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9114, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9156, .adv_w = 66, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9184, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9216, .adv_w = 63, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9239, .adv_w = 125, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9285, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9318, .adv_w = 125, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9357, .adv_w = 106, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9384, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9426, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9456, .adv_w = 125, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9502, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9535, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9577, .adv_w = 106, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9612, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9654, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9684, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9750, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9795, .adv_w = 115, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9843, .adv_w = 91, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9882, .adv_w = 115, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9930, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9972, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10002, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10044, .adv_w = 95, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10071, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10113, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10143, .adv_w = 48, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10163, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10241, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10295, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10361, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10415, .adv_w = 132, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10456, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10534, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10612, .adv_w = 216, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10689, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10767, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10830, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10908, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10938, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10983, .adv_w = 216, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11074, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11128, .adv_w = 168, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11176, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11248, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11309, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11370, .adv_w = 168, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11418, .adv_w = 168, .box_w = 12, .box_h = 11, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 11484, .adv_w = 120, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11523, .adv_w = 120, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11562, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11623, .adv_w = 168, .box_w = 11, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 11640, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11703, .adv_w = 240, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11807, .adv_w = 216, .box_w = 15, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 11905, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11971, .adv_w = 168, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12010, .adv_w = 168, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12049, .adv_w = 240, .box_w = 16, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12129, .adv_w = 192, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12183, .adv_w = 192, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12261, .adv_w = 192, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 12346, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12407, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12479, .adv_w = 168, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12540, .adv_w = 120, .box_w = 9, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 12599, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12671, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12743, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12806, .adv_w = 192, .box_w = 14, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 12897, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12956, .adv_w = 240, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13046, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13114, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13182, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13250, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13318, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13386, .adv_w = 240, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13474, .adv_w = 168, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13539, .adv_w = 168, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13611, .adv_w = 192, .box_w = 13, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 13696, .adv_w = 240, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13764, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13823, .adv_w = 193, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -6, 0,
    -2, -6, 0, -7, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    2, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -21,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    -6, 0, -1, 0, 0, -12, -2, -8,
    -6, 0, -9, 0, 0, 0, 0, 0,
    0, -1, 0, 0, -2, -1, -5, -3,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -2,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, -2, 0, 0, 0, -3, 0, -2,
    0, -2, -4, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, -2, -2,
    0, -2, 0, 0, 0, -2, -2, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -22, 0, 0,
    0, -16, 0, -25, 0, 2, 0, 0,
    0, 0, 0, 0, 0, -3, -2, 0,
    0, -2, -2, 0, 0, -2, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -3, 0, 0,
    0, 2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -6, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -2, -3, 0, 0, 0, -2, -4, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -31, 0, 0, 0, 0, 0, 0,
    0, 2, -6, 0, 0, -26, -5, -16,
    -13, 0, -22, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -12, -9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -30, 0, 0,
    0, -13, 0, -19, 0, 0, 0, 0,
    0, -3, 0, -2, 0, -1, -1, 0,
    0, -1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -3,
    -2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, -2,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, -20, -22, 0,
    0, -7, -3, -22, -1, 2, 0, 2,
    1, 0, 2, 0, 0, -11, -9, 0,
    -10, -9, -7, -11, 0, -9, -7, -5,
    -7, -6, 0, -31, -20, -17, -11, -9,
    0, 0, 0, 2, 0, -21, -3, 0,
    0, -7, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -4, -4, 0,
    0, -4, -3, 0, 0, -3, -1, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, -12, -6, 0,
    0, -4, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, -3, -3, 0,
    0, -3, -2, 0, 0, -2, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, -2, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -2, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 2, -5, -20, -5, 0,
    0, -9, -3, -9, -1, 2, -9, 2,
    2, 1, 2, 0, 2, -7, -6, -2,
    -4, -6, -4, -5, -2, -4, -2, 0,
    -2, -3, 2, -8, -5, -9, -6, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -2, -3, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -1, -1, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -1, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -2, 1,
    0, -2, 0, 0, 5, 0, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, 1,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_12 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_12*/


