#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 10 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_10
#define RB_LV_FONT_ROBOTO_10 1
#endif

#if RB_LV_FONT_ROBOTO_10

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x2c, 0x2b, 0x2b, 0x2b, 0x2b, 0x17, 0x0, 0x2b,

    /* U+22 "\"" */
    0x55, 0xa5, 0x59, 0x32, 0x60,

    /* U+23 "#" */
    0x0, 0x55, 0x55, 0x0, 0x8, 0x29, 0x20, 0xc,
    0xec, 0xec, 0x0, 0xb, 0xb, 0x0, 0x0, 0xa0,
    0xa0, 0x5, 0xce, 0xcd, 0x80, 0x5, 0x56, 0x50,
    0x0, 0x82, 0x92, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x0, 0x0, 0x74, 0x0, 0x5, 0xdc,
    0x30, 0x1d, 0x14, 0xd0, 0x2c, 0x0, 0x80, 0xb,
    0xa3, 0x0, 0x0, 0x5c, 0x70, 0x23, 0x0, 0xd0,
    0x4b, 0x1, 0xe0, 0x9, 0xed, 0x50, 0x0, 0x83,
    0x0,

    /* U+25 "%" */
    0x1b, 0xb1, 0x0, 0x7, 0x45, 0x63, 0x70, 0x64,
    0x55, 0xa0, 0x1, 0xa9, 0x65, 0x0, 0x0, 0xa,
    0x6a, 0x40, 0x8, 0x3b, 0xb, 0x1, 0x90, 0xb0,
    0xb0, 0x0, 0x8, 0xa6,

    /* U+26 "&" */
    0x5, 0xdc, 0x10, 0x0, 0xd1, 0x67, 0x0, 0xc,
    0x3a, 0x40, 0x0, 0x5f, 0x70, 0x0, 0x1d, 0xa9,
    0x7, 0x7, 0x80, 0xc8, 0x90, 0x59, 0x2, 0xf4,
    0x0, 0x9b, 0xc9, 0xc0,

    /* U+27 "'" */
    0x73, 0x73, 0x41,

    /* U+28 "(" */
    0x0, 0x71, 0x4, 0x90, 0xb, 0x10, 0x1c, 0x0,
    0x4a, 0x0, 0x59, 0x0, 0x49, 0x0, 0x2b, 0x0,
    0xd, 0x0, 0x9, 0x40, 0x1, 0xb0, 0x0, 0x21,

    /* U+29 ")" */
    0x81, 0x3, 0xa0, 0xb, 0x20, 0x67, 0x4, 0xa0,
    0x2b, 0x3, 0xb0, 0x49, 0x8, 0x50, 0xc0, 0x76,
    0x3, 0x0,

    /* U+2A "*" */
    0x3, 0x80, 0x7, 0x69, 0x80, 0x3b, 0xe5, 0x1,
    0xca, 0x30, 0x13, 0x13, 0x0,

    /* U+2B "+" */
    0x0, 0x83, 0x0, 0x0, 0xa4, 0x0, 0x0, 0xa4,
    0x0, 0x9f, 0xff, 0xf3, 0x0, 0xa4, 0x0, 0x0,
    0xa4, 0x0,

    /* U+2C "," */
    0x67, 0x85, 0x70,

    /* U+2D "-" */
    0xad, 0x70,

    /* U+2E "." */
    0x1, 0x3b,

    /* U+2F "/" */
    0x0, 0x1a, 0x0, 0x74, 0x0, 0xb0, 0x2, 0x90,
    0x8, 0x40, 0xc, 0x0, 0x38, 0x0, 0x83, 0x0,
    0x60, 0x0,

    /* U+30 "0" */
    0x8, 0xdc, 0x30, 0x2c, 0x3, 0xc0, 0x58, 0x0,
    0xe0, 0x67, 0x0, 0xd0, 0x67, 0x0, 0xd0, 0x58,
    0x0, 0xe0, 0x2c, 0x3, 0xb0, 0x7, 0xdc, 0x30,

    /* U+31 "1" */
    0x3, 0x98, 0x2b, 0x99, 0x0, 0x59, 0x0, 0x59,
    0x0, 0x59, 0x0, 0x59, 0x0, 0x59, 0x0, 0x59,

    /* U+32 "2" */
    0x9, 0xdd, 0x30, 0x5a, 0x3, 0xc0, 0x32, 0x1,
    0xd0, 0x0, 0x7, 0x80, 0x0, 0x3c, 0x0, 0x1,
    0xd2, 0x0, 0xb, 0x40, 0x0, 0x6f, 0xdd, 0xd3,

    /* U+33 "3" */
    0xa, 0xdd, 0x35, 0x80, 0x2c, 0x0, 0x4, 0xb0,
    0x1d, 0xf2, 0x0, 0x4, 0xb2, 0x20, 0xe, 0x5a,
    0x3, 0xc0, 0xad, 0xc2,

    /* U+34 "4" */
    0x0, 0xd, 0x60, 0x0, 0x7e, 0x60, 0x1, 0xc8,
    0x60, 0xa, 0x38, 0x60, 0x4a, 0x8, 0x60, 0xad,
    0xde, 0xe5, 0x0, 0x8, 0x60, 0x0, 0x8, 0x60,

    /* U+35 "5" */
    0xa, 0xff, 0xf0, 0xc, 0x10, 0x0, 0xd, 0x0,
    0x0, 0xe, 0xdd, 0x50, 0x4, 0x2, 0xe0, 0x0,
    0x0, 0xb2, 0x1c, 0x0, 0xd1, 0x6, 0xdd, 0x60,

    /* U+36 "6" */
    0x1, 0xae, 0x10, 0xb, 0x80, 0x0, 0x1d, 0x0,
    0x0, 0x4c, 0xcd, 0x40, 0x5d, 0x12, 0xe0, 0x49,
    0x0, 0xc1, 0x1d, 0x1, 0xd0, 0x5, 0xdd, 0x40,

    /* U+37 "7" */
    0x8d, 0xdd, 0xf2, 0x0, 0x1, 0xc0, 0x0, 0x7,
    0x60, 0x0, 0xd, 0x0, 0x0, 0x49, 0x0, 0x0,
    0xb3, 0x0, 0x1, 0xd0, 0x0, 0x8, 0x60, 0x0,

    /* U+38 "8" */
    0x9, 0xdd, 0x40, 0x3c, 0x2, 0xd0, 0x2c, 0x3,
    0xc0, 0x9, 0xef, 0x30, 0x3c, 0x3, 0xc0, 0x67,
    0x0, 0xd0, 0x4b, 0x2, 0xd0, 0x8, 0xdd, 0x40,

    /* U+39 "9" */
    0x9, 0xdc, 0x15, 0xa0, 0x5a, 0x76, 0x0, 0xd4,
    0xb0, 0x4f, 0x8, 0xd8, 0xe0, 0x0, 0x3c, 0x0,
    0xb, 0x60, 0x7e, 0x70,

    /* U+3A ":" */
    0x3a, 0x1, 0x0, 0x0, 0x1, 0x3a,

    /* U+3B ";" */
    0x58, 0x1, 0x0, 0x0, 0x12, 0x58, 0x84, 0x30,

    /* U+3C "<" */
    0x0, 0x18, 0x40, 0x8d, 0x70, 0x9c, 0x10, 0x0,
    0x7d, 0x81, 0x0, 0x8, 0x40,

    /* U+3D "=" */
    0x3e, 0xee, 0xb0, 0x0, 0x0, 0x3e, 0xee, 0xb0,

    /* U+3E ">" */
    0x49, 0x10, 0x0, 0x6d, 0x91, 0x0, 0xa, 0xc1,
    0x7d, 0x81, 0x48, 0x10, 0x0,

    /* U+3F "?" */
    0x1c, 0xea, 0x8, 0x60, 0xb3, 0x0, 0xa, 0x30,
    0x4, 0xc0, 0x0, 0xd1, 0x0, 0x27, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0x0,

    /* U+40 "@" */
    0x0, 0x3b, 0xbb, 0x80, 0x0, 0x3a, 0x0, 0x4,
    0x90, 0xb, 0x2, 0xba, 0x18, 0x22, 0x80, 0xb1,
    0x92, 0x35, 0x55, 0x1a, 0xa, 0x12, 0x76, 0x44,
    0x80, 0xb0, 0x36, 0x56, 0x38, 0xd, 0x7, 0x31,
    0xa0, 0xb9, 0x7a, 0x80, 0x9, 0x50, 0x0, 0x0,
    0x0, 0x7, 0xba, 0xa0, 0x0,

    /* U+41 "A" */
    0x0, 0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0,
    0xd5, 0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30,
    0xb3, 0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d,
    0xb, 0x40, 0x0, 0xb3,

    /* U+42 "B" */
    0x2f, 0xdd, 0xb0, 0x2c, 0x0, 0x96, 0x2c, 0x0,
    0xa5, 0x2f, 0xde, 0xc0, 0x2c, 0x0, 0x97, 0x2c,
    0x0, 0x5a, 0x2c, 0x0, 0x97, 0x2f, 0xdd, 0xa0,

    /* U+43 "C" */
    0x3, 0xcd, 0xb2, 0x0, 0xd3, 0x5, 0xb0, 0x4a,
    0x0, 0x9, 0x6, 0x80, 0x0, 0x0, 0x68, 0x0,
    0x0, 0x4, 0xa0, 0x0, 0x80, 0xd, 0x30, 0x5b,
    0x0, 0x3c, 0xdb, 0x10,

    /* U+44 "D" */
    0x2f, 0xed, 0x70, 0x2c, 0x0, 0xb6, 0x2c, 0x0,
    0x2c, 0x2c, 0x0, 0xe, 0x2c, 0x0, 0xe, 0x2c,
    0x0, 0x2c, 0x2c, 0x0, 0xb6, 0x2f, 0xde, 0x70,

    /* U+45 "E" */
    0x2f, 0xdd, 0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2f, 0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+46 "F" */
    0x2f, 0xdd, 0xd3, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xa0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,

    /* U+47 "G" */
    0x3, 0xcd, 0xc2, 0x0, 0xd3, 0x4, 0xc0, 0x4b,
    0x0, 0x6, 0x6, 0x80, 0x0, 0x0, 0x68, 0x6,
    0xde, 0x14, 0xb0, 0x0, 0xd1, 0xd, 0x40, 0x1e,
    0x10, 0x2c, 0xed, 0x60,

    /* U+48 "H" */
    0x2c, 0x0, 0xa, 0x42, 0xc0, 0x0, 0xa4, 0x2c,
    0x0, 0xa, 0x42, 0xfd, 0xdd, 0xf4, 0x2c, 0x0,
    0xa, 0x42, 0xc0, 0x0, 0xa4, 0x2c, 0x0, 0xa,
    0x42, 0xc0, 0x0, 0xa4,

    /* U+49 "I" */
    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,

    /* U+4A "J" */
    0x0, 0x3, 0xc0, 0x0, 0x3c, 0x0, 0x3, 0xc0,
    0x0, 0x3c, 0x0, 0x3, 0xc3, 0x0, 0x3b, 0x96,
    0x7, 0x91, 0xcd, 0xb1,

    /* U+4B "K" */
    0x2c, 0x0, 0x7a, 0x2, 0xc0, 0x4d, 0x0, 0x2c,
    0x2d, 0x20, 0x2, 0xcd, 0x60, 0x0, 0x2f, 0xad,
    0x0, 0x2, 0xc0, 0x89, 0x0, 0x2c, 0x0, 0xd4,
    0x2, 0xc0, 0x3, 0xd0,

    /* U+4C "L" */
    0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,

    /* U+4D "M" */
    0x2f, 0x30, 0x0, 0x7e, 0x2f, 0x90, 0x0, 0xde,
    0x2b, 0xd0, 0x3, 0xbe, 0x2b, 0x94, 0x9, 0x5e,
    0x2c, 0x4a, 0xd, 0xe, 0x2c, 0xd, 0x59, 0xe,
    0x2c, 0x8, 0xe4, 0xe, 0x2c, 0x2, 0xe0, 0xe,

    /* U+4E "N" */
    0x2f, 0x10, 0xa, 0x42, 0xfa, 0x0, 0xa4, 0x2c,
    0xd3, 0xa, 0x42, 0xc4, 0xc0, 0xa4, 0x2c, 0xb,
    0x6a, 0x42, 0xc0, 0x2e, 0xb4, 0x2c, 0x0, 0x8f,
    0x42, 0xc0, 0x0, 0xe4,

    /* U+4F "O" */
    0x2, 0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b,
    0x0, 0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0,
    0xa, 0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c,
    0x0, 0x2c, 0xeb, 0x10,

    /* U+50 "P" */
    0x2f, 0xed, 0xc2, 0x2c, 0x0, 0x5b, 0x2c, 0x0,
    0xe, 0x2c, 0x0, 0x5b, 0x2f, 0xdd, 0xb2, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,

    /* U+51 "Q" */
    0x3, 0xce, 0xb1, 0x0, 0xd3, 0x6, 0xb0, 0x4a,
    0x0, 0xd, 0x17, 0x70, 0x0, 0xb3, 0x77, 0x0,
    0xb, 0x35, 0xa0, 0x0, 0xd1, 0xd, 0x30, 0x6b,
    0x0, 0x3c, 0xef, 0x40, 0x0, 0x0, 0x4d, 0x10,
    0x0, 0x0, 0x0,

    /* U+52 "R" */
    0x2f, 0xee, 0xa0, 0x2c, 0x0, 0x97, 0x2c, 0x0,
    0x4a, 0x2c, 0x0, 0xa7, 0x2f, 0xde, 0xa0, 0x2c,
    0x4, 0xb0, 0x2c, 0x0, 0xc3, 0x2c, 0x0, 0x4b,

    /* U+53 "S" */
    0x7, 0xdd, 0x80, 0x3c, 0x0, 0xb5, 0x5b, 0x0,
    0x22, 0xb, 0xb5, 0x0, 0x0, 0x4a, 0xd1, 0x32,
    0x0, 0x87, 0x6a, 0x0, 0x96, 0x8, 0xdd, 0xa0,

    /* U+54 "T" */
    0xad, 0xee, 0xda, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+55 "U" */
    0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a,
    0x0, 0x2c, 0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+56 "V" */
    0xb4, 0x0, 0xe, 0x15, 0x90, 0x4, 0xb0, 0x1e,
    0x0, 0x96, 0x0, 0xb3, 0xd, 0x10, 0x6, 0x83,
    0xb0, 0x0, 0x1d, 0x86, 0x0, 0x0, 0xbe, 0x10,
    0x0, 0x6, 0xc0, 0x0,

    /* U+57 "W" */
    0x95, 0x0, 0xf0, 0x6, 0x86, 0x80, 0x4f, 0x40,
    0x95, 0x2b, 0x8, 0x98, 0xc, 0x10, 0xe0, 0xc1,
    0xb0, 0xd0, 0xb, 0x3c, 0xc, 0x3b, 0x0, 0x89,
    0x80, 0x89, 0x70, 0x4, 0xf4, 0x4, 0xf4, 0x0,
    0x1f, 0x0, 0xf, 0x0,

    /* U+58 "X" */
    0x6b, 0x0, 0x7a, 0xd, 0x41, 0xe2, 0x4, 0xd9,
    0x80, 0x0, 0xbe, 0x0, 0x0, 0xbe, 0x10, 0x4,
    0xc8, 0x90, 0xd, 0x30, 0xe2, 0x6a, 0x0, 0x6b,

    /* U+59 "Y" */
    0xa5, 0x0, 0x6a, 0x3d, 0x0, 0xd2, 0xb, 0x45,
    0xb0, 0x3, 0xcc, 0x30, 0x0, 0xbb, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+5A "Z" */
    0x7d, 0xdd, 0xf6, 0x0, 0x1, 0xe1, 0x0, 0xb,
    0x50, 0x0, 0x4c, 0x0, 0x0, 0xd2, 0x0, 0x8,
    0x80, 0x0, 0x2d, 0x0, 0x0, 0x9f, 0xdd, 0xd8,

    /* U+5B "[" */
    0x4d, 0x74, 0xa0, 0x4a, 0x4, 0xa0, 0x4a, 0x4,
    0xa0, 0x4a, 0x4, 0xa0, 0x4a, 0x4, 0xa0, 0x4e,
    0x70,

    /* U+5C "\\" */
    0x93, 0x0, 0x4, 0x90, 0x0, 0xd, 0x0, 0x0,
    0x94, 0x0, 0x3, 0xa0, 0x0, 0xd, 0x0, 0x0,
    0x85, 0x0, 0x2, 0xa0, 0x0, 0x6, 0x0,

    /* U+5D "]" */
    0xcc, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe,
    0xe, 0xe, 0xcc,

    /* U+5E "^" */
    0x6, 0x90, 0xc, 0xc0, 0x2a, 0x84, 0x85, 0x2a,

    /* U+5F "_" */
    0xdd, 0xdd, 0x60,

    /* U+60 "`" */
    0x44, 0x0, 0xc1,

    /* U+61 "a" */
    0x9, 0xdc, 0x22, 0x60, 0x4a, 0x7, 0xbc, 0xb5,
    0xa0, 0x3b, 0x69, 0x7, 0xb0, 0xcd, 0x9b,

    /* U+62 "b" */
    0x59, 0x0, 0x0, 0x59, 0x0, 0x0, 0x5c, 0xcd,
    0x40, 0x5c, 0x2, 0xd0, 0x59, 0x0, 0xc1, 0x59,
    0x0, 0xc1, 0x5c, 0x2, 0xd0, 0x5b, 0xce, 0x40,

    /* U+63 "c" */
    0x8, 0xdc, 0x34, 0xb0, 0x2c, 0x86, 0x0, 0x17,
    0x60, 0x0, 0x4b, 0x2, 0xb0, 0x8d, 0xc2,

    /* U+64 "d" */
    0x0, 0x0, 0xe0, 0x0, 0xe, 0x9, 0xda, 0xe4,
    0xb0, 0x2e, 0x76, 0x0, 0xe7, 0x60, 0xe, 0x4b,
    0x2, 0xe0, 0x9c, 0xae,

    /* U+65 "e" */
    0x7, 0xdc, 0x33, 0xa0, 0x2c, 0x7e, 0xdd, 0xd7,
    0x70, 0x0, 0x4c, 0x1, 0x60, 0x8d, 0xd4,

    /* U+66 "f" */
    0x3, 0xd6, 0xc, 0x30, 0xd, 0x0, 0x8f, 0xc1,
    0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0,
    0xe, 0x0,

    /* U+67 "g" */
    0x9, 0xda, 0xd4, 0xb0, 0x2e, 0x76, 0x0, 0xe7,
    0x60, 0xe, 0x4b, 0x3, 0xe0, 0x9e, 0xae, 0x3,
    0x3, 0xc0, 0x9d, 0xc3,

    /* U+68 "h" */
    0x59, 0x0, 0x5, 0x90, 0x0, 0x5b, 0xbe, 0x45,
    0xc0, 0x3c, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59,
    0x1, 0xd5, 0x90, 0x1d,

    /* U+69 "i" */
    0x3a, 0x0, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a,

    /* U+6A "j" */
    0x4, 0x90, 0x0, 0x4, 0x90, 0x49, 0x4, 0x90,
    0x49, 0x4, 0x90, 0x49, 0x5, 0x94, 0xe4,

    /* U+6B "k" */
    0x59, 0x0, 0x0, 0x59, 0x0, 0x0, 0x59, 0xa,
    0x60, 0x59, 0x89, 0x0, 0x5d, 0xe0, 0x0, 0x5d,
    0xb6, 0x0, 0x59, 0x1d, 0x20, 0x59, 0x5, 0xb0,

    /* U+6C "l" */
    0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a,

    /* U+6D "m" */
    0x5b, 0xcd, 0x5b, 0xe8, 0x5, 0xb0, 0x3f, 0x10,
    0xe0, 0x59, 0x1, 0xd0, 0xd, 0x15, 0x90, 0x1d,
    0x0, 0xd1, 0x59, 0x1, 0xd0, 0xd, 0x15, 0x90,
    0x1d, 0x0, 0xd1,

    /* U+6E "n" */
    0x5b, 0xbe, 0x45, 0xc0, 0x3c, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d,

    /* U+6F "o" */
    0x7, 0xdd, 0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0,
    0xb2, 0x76, 0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7,
    0xdd, 0x40,

    /* U+70 "p" */
    0x5c, 0xbd, 0x40, 0x5b, 0x1, 0xd0, 0x59, 0x0,
    0xc1, 0x59, 0x0, 0xc1, 0x5c, 0x2, 0xd0, 0x5c,
    0xcd, 0x40, 0x59, 0x0, 0x0, 0x59, 0x0, 0x0,

    /* U+71 "q" */
    0x9, 0xda, 0xd4, 0xb0, 0x2e, 0x76, 0x0, 0xe7,
    0x60, 0xe, 0x4b, 0x2, 0xe0, 0x9d, 0xae, 0x0,
    0x0, 0xe0, 0x0, 0xe,

    /* U+72 "r" */
    0x0, 0x0, 0x5c, 0xd3, 0x5c, 0x0, 0x59, 0x0,
    0x59, 0x0, 0x59, 0x0, 0x59, 0x0,

    /* U+73 "s" */
    0xa, 0xdc, 0x14, 0xa0, 0x56, 0x1d, 0x82, 0x0,
    0x5, 0xc5, 0x67, 0x5, 0x90, 0xad, 0xc2,

    /* U+74 "t" */
    0x7, 0x0, 0xe0, 0xbf, 0xa0, 0xe0, 0xe, 0x0,
    0xe0, 0xe, 0x0, 0xac,

    /* U+75 "u" */
    0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x3b, 0x4, 0xd0, 0xbd, 0xad,

    /* U+76 "v" */
    0xa3, 0x6, 0x75, 0x80, 0xb2, 0x1c, 0xd, 0x0,
    0xb6, 0x80, 0x6, 0xe3, 0x0, 0x1e, 0x0,

    /* U+77 "w" */
    0xa3, 0xc, 0x30, 0xb2, 0x67, 0xe, 0x80, 0xd0,
    0x2b, 0x47, 0xc3, 0xa0, 0xd, 0x92, 0xb8, 0x60,
    0xa, 0xd0, 0x6f, 0x20, 0x6, 0x90, 0x2e, 0x0,

    /* U+78 "x" */
    0x79, 0xa, 0x60, 0xd5, 0xc0, 0x4, 0xf3, 0x0,
    0x5f, 0x40, 0xd, 0x3d, 0x8, 0x80, 0x97,

    /* U+79 "y" */
    0xb3, 0x8, 0x76, 0x80, 0xc2, 0x1d, 0x1c, 0x0,
    0xb7, 0x70, 0x6, 0xf2, 0x0, 0x1d, 0x0, 0x6,
    0x70, 0x8, 0xd1, 0x0,

    /* U+7A "z" */
    0x7d, 0xdf, 0x70, 0x2, 0xd0, 0x0, 0xc4, 0x0,
    0x6a, 0x0, 0x1d, 0x10, 0x8, 0xed, 0xd8,

    /* U+7B "{" */
    0x0, 0x82, 0x6, 0x80, 0xa, 0x40, 0xa, 0x30,
    0xc, 0x10, 0xaa, 0x0, 0xc, 0x10, 0xa, 0x30,
    0xa, 0x40, 0x6, 0x80, 0x0, 0x82,

    /* U+7C "|" */
    0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
    0x29, 0x14,

    /* U+7D "}" */
    0x82, 0x0, 0x2c, 0x0, 0xe, 0x0, 0xd, 0x0,
    0xb, 0x30, 0x4, 0xf0, 0xb, 0x20, 0xd, 0x0,
    0xe, 0x0, 0x2c, 0x0, 0x82, 0x0,

    /* U+7E "~" */
    0xb, 0xd6, 0xb, 0x13, 0x70, 0x9e, 0x80,

    /* U+A0 " " */

    /* U+A1 "¡" */
    0x39, 0x0, 0x17, 0x2a, 0x3a, 0x3b, 0x3b, 0x3b,

    /* U+A2 "¢" */
    0x0, 0xa4, 0x0, 0x4e, 0xb1, 0x1d, 0x25, 0xb6,
    0x80, 0x6, 0x76, 0x0, 0x6, 0x80, 0x4, 0x1d,
    0x25, 0xb0, 0x3d, 0xb1, 0x0, 0xa4, 0x0,

    /* U+A3 "£" */
    0x1, 0xcd, 0x90, 0x9, 0x60, 0xc3, 0xc, 0x20,
    0x21, 0xc, 0x20, 0x0, 0x7f, 0xd9, 0x0, 0xb,
    0x30, 0x0, 0xc, 0x20, 0x0, 0x7f, 0xdd, 0xd6,

    /* U+A4 "¤" */
    0x0, 0x0, 0x0, 0x4, 0xba, 0xec, 0x97, 0xe,
    0x60, 0x4f, 0x12, 0xb0, 0x0, 0x85, 0x48, 0x0,
    0x5, 0x72, 0xb0, 0x0, 0x85, 0xe, 0x60, 0x4f,
    0x23, 0xab, 0xec, 0x86, 0x0, 0x0, 0x0, 0x0,

    /* U+A5 "¥" */
    0xb5, 0x1, 0xe0, 0x4b, 0x7, 0x80, 0xd, 0x2e,
    0x10, 0x6, 0xda, 0x0, 0x4b, 0xfc, 0x70, 0x4b,
    0xfb, 0x70, 0x0, 0xd1, 0x0, 0x0, 0xd1, 0x0,

    /* U+A6 "¦" */
    0x4a, 0x4a, 0x4a, 0x4a, 0x1, 0x4a, 0x4a, 0x4a,
    0x4a, 0x13,

    /* U+A7 "§" */
    0x7, 0xdd, 0x90, 0x3c, 0x0, 0xb4, 0x3c, 0x0,
    0x22, 0xd, 0xd7, 0x10, 0x5a, 0x39, 0xe2, 0x77,
    0x0, 0x68, 0x1d, 0xa4, 0xa6, 0x0, 0x6c, 0xe0,
    0x32, 0x0, 0xa4, 0x5b, 0x0, 0xc3, 0x7, 0xcc,
    0x70,

    /* U+A8 "¨" */
    0x67, 0x48, 0x0, 0x0,

    /* U+A9 "©" */
    0x0, 0x6a, 0xa4, 0x0, 0x8, 0x50, 0x7, 0x50,
    0x27, 0x2b, 0xa1, 0x90, 0x72, 0xa1, 0x45, 0x54,
    0x80, 0xb0, 0x0, 0x35, 0x72, 0xa1, 0x45, 0x54,
    0x27, 0x3b, 0xa1, 0x90, 0x8, 0x50, 0x7, 0x50,
    0x0, 0x6a, 0xa4, 0x0,

    /* U+AA "ª" */
    0xb, 0xc5, 0x15, 0x2b, 0x19, 0x9b, 0x2c, 0x9c,

    /* U+AB "«" */
    0x0, 0x22, 0x0, 0x94, 0xa0, 0x49, 0xa3, 0x2,
    0xb7, 0x50, 0x6, 0x5a, 0x0,

    /* U+AC "¬" */
    0x5e, 0xee, 0xa0, 0x0, 0x3a, 0x0, 0x1, 0x40,

    /* U+AD "­" */
    0xad, 0x70,

    /* U+AE "®" */
    0x0, 0x6a, 0xa4, 0x0, 0x8, 0x50, 0x7, 0x50,
    0x27, 0x6b, 0xa1, 0x90, 0x72, 0x83, 0x65, 0x54,
    0x80, 0x8c, 0xe1, 0x35, 0x72, 0x83, 0x55, 0x54,
    0x27, 0x72, 0x35, 0x90, 0x8, 0x50, 0x7, 0x50,
    0x0, 0x6a, 0xa4, 0x0,

    /* U+AF "¯" */
    0x3c, 0xcc,

    /* U+B0 "°" */
    0xa, 0x80, 0x55, 0x91, 0x1a, 0x90,

    /* U+B1 "±" */
    0x0, 0xa2, 0x0, 0xa, 0x20, 0x6d, 0xed, 0xc0,
    0xa, 0x20, 0x0, 0xa2, 0x0, 0x3, 0x0, 0x4d,
    0xdd, 0x90,

    /* U+B2 "²" */
    0x5b, 0xb0, 0x20, 0xb1, 0x9, 0x60, 0x7d, 0xa3,

    /* U+B3 "³" */
    0x5a, 0xb1, 0x6, 0xc0, 0x40, 0x93, 0x5b, 0xb0,

    /* U+B4 "´" */
    0x4, 0x32, 0xb0,

    /* U+B5 "µ" */
    0x4a, 0x0, 0xe4, 0xa0, 0xe, 0x4a, 0x0, 0xe4,
    0xa0, 0xe, 0x4c, 0x1, 0xe4, 0xec, 0xad, 0x4a,
    0x0, 0x4, 0xa0, 0x0,

    /* U+B6 "¶" */
    0xa, 0xff, 0x17, 0xff, 0xf1, 0xaf, 0xff, 0x17,
    0xff, 0xf1, 0x1c, 0xff, 0x10, 0x1, 0xd1, 0x0,
    0xd, 0x10, 0x0, 0xd1,

    /* U+B7 "·" */
    0x0, 0x2b, 0x1,

    /* U+B8 "¸" */
    0x36, 0x0, 0xc0, 0x48, 0x0,

    /* U+B9 "¹" */
    0x29, 0x51, 0x76, 0x5, 0x60, 0x56,

    /* U+BA "º" */
    0xb, 0xb6, 0x57, 0xd, 0x57, 0xd, 0xb, 0xb6,

    /* U+BB "»" */
    0x21, 0x30, 0x1, 0xa5, 0x70, 0x7, 0x6b, 0x20,
    0x94, 0xc0, 0x38, 0x73, 0x0,

    /* U+BC "¼" */
    0x3a, 0x30, 0x0, 0x3, 0x93, 0x4, 0x60, 0x8,
    0x30, 0xa0, 0x0, 0x83, 0x74, 0x22, 0x2, 0x2a,
    0xd, 0x70, 0x9, 0x28, 0x77, 0x2, 0x81, 0xcc,
    0xc0, 0x0, 0x0, 0x57,

    /* U+BD "½" */
    0x3, 0x10, 0x0, 0x0, 0x7d, 0x30, 0x32, 0x0,
    0x8, 0x30, 0xa0, 0x0, 0x8, 0x34, 0x60, 0x0,
    0x7, 0x3a, 0x4c, 0x80, 0x0, 0x55, 0x70, 0xc0,
    0x0, 0xa0, 0x3, 0xb0, 0x5, 0x40, 0x2b, 0x10,
    0x0, 0x0, 0x8c, 0xb2,

    /* U+BE "¾" */
    0x1b, 0xb1, 0x0, 0x0, 0x23, 0x65, 0x8, 0x10,
    0x4, 0xd1, 0x38, 0x0, 0x33, 0x56, 0xa0, 0x0,
    0x1b, 0xb8, 0x53, 0xc0, 0x0, 0xa, 0x29, 0xc0,
    0x0, 0x72, 0x9b, 0xe4, 0x0, 0x0, 0x0, 0xc0,

    /* U+BF "¿" */
    0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x90, 0x0,
    0x69, 0x0, 0x2d, 0x0, 0x9, 0x50, 0x0, 0x96,
    0xb, 0x32, 0xce, 0x90,

    /* U+C0 "À" */
    0x0, 0xc2, 0x0, 0x0, 0x1, 0x50, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+C1 "Á" */
    0x0, 0x9, 0x60, 0x0, 0x0, 0x50, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+C2 "Â" */
    0x0, 0x6c, 0x10, 0x0, 0x5, 0x14, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+C3 "Ã" */
    0x1, 0xb3, 0x90, 0x0, 0x53, 0x98, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+C4 "Ä" */
    0x2, 0xa1, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+C5 "Å" */
    0x0, 0x48, 0x0, 0x0, 0x8, 0x34, 0x0, 0x0,
    0x48, 0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0xad,
    0x20, 0x0, 0xd, 0x58, 0x0, 0x5, 0x90, 0xd0,
    0x0, 0xa3, 0xb, 0x30, 0xf, 0xdd, 0xe8, 0x5,
    0x90, 0x1, 0xd0, 0xb4, 0x0, 0xb, 0x30,

    /* U+C6 "Æ" */
    0x0, 0x0, 0x1f, 0xed, 0xdb, 0x0, 0x0, 0x9,
    0xb8, 0x0, 0x0, 0x0, 0x2, 0xd5, 0x90, 0x0,
    0x0, 0x0, 0xa5, 0x4e, 0xdd, 0x60, 0x0, 0x3c,
    0x4, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xfa, 0x0,
    0x0, 0x4, 0xc0, 0x3, 0xb0, 0x0, 0x0, 0xc4,
    0x0, 0x2f, 0xdd, 0xd2,

    /* U+C7 "Ç" */
    0x3, 0xcd, 0xb2, 0x0, 0xd3, 0x5, 0xb0, 0x4a,
    0x0, 0x9, 0x6, 0x80, 0x0, 0x0, 0x68, 0x0,
    0x0, 0x4, 0xa0, 0x0, 0x80, 0xd, 0x30, 0x5b,
    0x0, 0x3c, 0xeb, 0x10, 0x0, 0xa, 0x20, 0x0,
    0x1, 0xb2, 0x0,

    /* U+C8 "È" */
    0x2, 0xc0, 0x0, 0x0, 0x33, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+C9 "É" */
    0x0, 0xc, 0x20, 0x0, 0x23, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+CA "Ê" */
    0x0, 0x99, 0x0, 0x2, 0x33, 0x20, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+CB "Ë" */
    0x6, 0x65, 0x70, 0x0, 0x0, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+CC "Ì" */
    0xb, 0x40, 0x5, 0x1, 0xd0, 0x1d, 0x1, 0xd0,
    0x1d, 0x1, 0xd0, 0x1d, 0x1, 0xd0, 0x1d,

    /* U+CD "Í" */
    0x8, 0x70, 0x60, 0x1d, 0x1, 0xd0, 0x1d, 0x1,
    0xd0, 0x1d, 0x1, 0xd0, 0x1d, 0x1, 0xd0,

    /* U+CE "Î" */
    0x5, 0xc1, 0x6, 0x15, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0,

    /* U+CF "Ï" */
    0x1b, 0xc, 0x1, 0x1, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0,

    /* U+D0 "Ð" */
    0xf, 0xde, 0x80, 0x0, 0xe0, 0x9, 0x80, 0xe,
    0x0, 0xe, 0xc, 0xfd, 0x10, 0xd1, 0xe, 0x0,
    0xd, 0x10, 0xe0, 0x0, 0xe0, 0xe, 0x0, 0x98,
    0x0, 0xfd, 0xe9, 0x0,

    /* U+D1 "Ñ" */
    0x0, 0xa6, 0x63, 0x0, 0x17, 0x5b, 0x0, 0x2f,
    0x10, 0xa, 0x42, 0xfa, 0x0, 0xa4, 0x2c, 0xd3,
    0xa, 0x42, 0xc4, 0xc0, 0xa4, 0x2c, 0xb, 0x6a,
    0x42, 0xc0, 0x2e, 0xb4, 0x2c, 0x0, 0x8f, 0x42,
    0xc0, 0x0, 0xe4,

    /* U+D2 "Ò" */
    0x0, 0xa5, 0x0, 0x0, 0x0, 0x60, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+D3 "Ó" */
    0x0, 0x6, 0x80, 0x0, 0x0, 0x60, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+D4 "Ô" */
    0x0, 0x4c, 0x20, 0x0, 0x6, 0x5, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+D5 "Õ" */
    0x1, 0xac, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+D6 "Ö" */
    0x0, 0xc0, 0xd0, 0x0, 0x1, 0x1, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+D7 "×" */
    0x0, 0x0, 0x5, 0x90, 0x59, 0xb, 0x9d, 0x10,
    0x3f, 0x70, 0x1d, 0x5d, 0x34, 0x50, 0x27,

    /* U+D8 "Ø" */
    0x2, 0xce, 0xba, 0x10, 0xd4, 0x8, 0xc0, 0x4b,
    0x0, 0xad, 0x26, 0x80, 0x64, 0xa4, 0x68, 0x1a,
    0xa, 0x43, 0xb8, 0x20, 0xc2, 0xd, 0x90, 0x5c,
    0x0, 0xac, 0xeb, 0x10, 0x4, 0x0, 0x0, 0x0,

    /* U+D9 "Ù" */
    0x0, 0xc2, 0x0, 0x0, 0x14, 0x0, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+DA "Ú" */
    0x0, 0x9, 0x50, 0x0, 0x5, 0x0, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+DB "Û" */
    0x0, 0x6b, 0x10, 0x0, 0x51, 0x40, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+DC "Ü" */
    0x3, 0x92, 0xb0, 0x0, 0x0, 0x0, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+DD "Ý" */
    0x0, 0xc, 0x20, 0x0, 0x23, 0x0, 0xa5, 0x0,
    0x6a, 0x3d, 0x0, 0xd2, 0xb, 0x45, 0xb0, 0x3,
    0xcc, 0x30, 0x0, 0xbb, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+DE "Þ" */
    0x3b, 0x0, 0x0, 0x3b, 0x0, 0x0, 0x3f, 0xdc,
    0x80, 0x3b, 0x0, 0xa5, 0x3b, 0x0, 0xa5, 0x3f,
    0xdc, 0x80, 0x3b, 0x0, 0x0, 0x3b, 0x0, 0x0,

    /* U+DF "ß" */
    0x9, 0xdc, 0x10, 0x3b, 0x8, 0x60, 0x59, 0xa,
    0x40, 0x59, 0xd, 0x0, 0x59, 0xd, 0x40, 0x59,
    0x1, 0xd3, 0x59, 0x0, 0x77, 0x59, 0x9b, 0xc1,

    /* U+E0 "à" */
    0x4, 0xb0, 0x0, 0x3, 0x10, 0x9, 0xcc, 0x23,
    0x80, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+E1 "á" */
    0x0, 0x1c, 0x10, 0x3, 0x10, 0x9, 0xdc, 0x22,
    0x60, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+E2 "â" */
    0x1, 0xa8, 0x0, 0x21, 0x20, 0x9, 0xdc, 0x22,
    0x60, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+E3 "ã" */
    0x0, 0x0, 0x0, 0x8c, 0xb4, 0x0, 0x0, 0x0,
    0x9d, 0xc2, 0x26, 0x4, 0xa0, 0x7b, 0xcb, 0x5a,
    0x3, 0xb6, 0x90, 0x7b, 0xc, 0xd9, 0xb0,

    /* U+E4 "ä" */
    0x9, 0x38, 0x50, 0x0, 0x0, 0x9, 0xdc, 0x22,
    0x60, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+E5 "å" */
    0x0, 0x85, 0x0, 0x25, 0x80, 0x0, 0x85, 0x0,
    0x9d, 0xc2, 0x26, 0x4, 0xa0, 0x7b, 0xcb, 0x5a,
    0x3, 0xb6, 0x90, 0x7b, 0xc, 0xd9, 0xb0,

    /* U+E6 "æ" */
    0x1b, 0xdb, 0x6c, 0xd5, 0x3, 0x50, 0x7d, 0x0,
    0xd0, 0x1a, 0xcd, 0xec, 0xcd, 0x18, 0x80, 0x5a,
    0x0, 0x0, 0x96, 0x8, 0xe1, 0x3, 0x2, 0xdd,
    0x94, 0xcd, 0x90,

    /* U+E7 "ç" */
    0x8, 0xdc, 0x34, 0xb0, 0x2c, 0x86, 0x0, 0x17,
    0x60, 0x0, 0x4b, 0x2, 0xb0, 0x8e, 0xc2, 0x0,
    0x85, 0x0, 0x9, 0x60,

    /* U+E8 "è" */
    0x5, 0xa0, 0x0, 0x3, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+E9 "é" */
    0x0, 0x2b, 0x0, 0x3, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+EA "ê" */
    0x1, 0xb7, 0x0, 0x20, 0x30, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+EB "ë" */
    0xa, 0x29, 0x30, 0x0, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+EC "ì" */
    0xb, 0x30, 0x3, 0x4, 0xa0, 0x4a, 0x4, 0xa0,
    0x4a, 0x4, 0xa0, 0x4a,

    /* U+ED "í" */
    0xa, 0x40, 0x20, 0x4a, 0x4, 0xa0, 0x4a, 0x4,
    0xa0, 0x4a, 0x4, 0xa0,

    /* U+EE "î" */
    0x8, 0xa1, 0x2, 0x2, 0x4, 0xa0, 0x4, 0xa0,
    0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0,

    /* U+EF "ï" */
    0x39, 0x2b, 0x0, 0x0, 0x4, 0xa0, 0x4, 0xa0,
    0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0,

    /* U+F0 "ð" */
    0x0, 0x0, 0x0, 0x9, 0xc5, 0x70, 0x0, 0x9f,
    0x30, 0x0, 0x65, 0xa0, 0x5, 0xdb, 0xe0, 0x1d,
    0x11, 0xd2, 0x59, 0x0, 0xb3, 0x59, 0x0, 0xc2,
    0x1d, 0x2, 0xd0, 0x6, 0xdd, 0x30,

    /* U+F1 "ñ" */
    0x0, 0x0, 0x0, 0x8c, 0xb4, 0x0, 0x0, 0x5,
    0xbb, 0xe4, 0x5c, 0x3, 0xc5, 0x90, 0x1d, 0x59,
    0x1, 0xd5, 0x90, 0x1d, 0x59, 0x1, 0xd0,

    /* U+F2 "ò" */
    0x4, 0xb0, 0x0, 0x0, 0x31, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+F3 "ó" */
    0x0, 0x2c, 0x0, 0x0, 0x31, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+F4 "ô" */
    0x1, 0xa8, 0x0, 0x2, 0x12, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+F5 "õ" */
    0x0, 0x0, 0x0, 0x8, 0xcb, 0x40, 0x0, 0x0,
    0x0, 0x7, 0xdd, 0x40, 0x4c, 0x2, 0xd0, 0x86,
    0x0, 0xb2, 0x76, 0x0, 0xb3, 0x3c, 0x1, 0xe0,
    0x7, 0xdd, 0x40,

    /* U+F6 "ö" */
    0xa, 0x38, 0x40, 0x0, 0x0, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+F7 "÷" */
    0x0, 0xa4, 0x0, 0x0, 0x10, 0x0, 0xaf, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0xa4, 0x0, 0x0,
    0x10, 0x0,

    /* U+F8 "ø" */
    0x0, 0x0, 0x40, 0x8, 0xdd, 0x60, 0x4b, 0x9,
    0xd0, 0x86, 0x26, 0xb2, 0x86, 0x90, 0xb3, 0x4c,
    0x71, 0xe0, 0xb, 0xdd, 0x40, 0x4, 0x0, 0x0,

    /* U+F9 "ù" */
    0x4, 0xa0, 0x0, 0x2, 0x0, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+FA "ú" */
    0x0, 0x2b, 0x0, 0x2, 0x0, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+FB "û" */
    0x2, 0xa7, 0x0, 0x20, 0x20, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+FC "ü" */
    0xa, 0x29, 0x30, 0x0, 0x0, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+FD "ý" */
    0x0, 0x78, 0x0, 0x3, 0x0, 0xb3, 0x8, 0x76,
    0x80, 0xc2, 0x1d, 0x1c, 0x0, 0xb7, 0x70, 0x6,
    0xf2, 0x0, 0x1d, 0x0, 0x6, 0x70, 0x8, 0xd1,
    0x0,

    /* U+FE "þ" */
    0x4a, 0x0, 0x0, 0x4a, 0x0, 0x0, 0x4c, 0xce,
    0x50, 0x4c, 0x2, 0xe0, 0x4a, 0x0, 0xc2, 0x4a,
    0x0, 0xc2, 0x4c, 0x2, 0xe0, 0x4c, 0xcd, 0x50,
    0x4a, 0x0, 0x0, 0x4a, 0x0, 0x0,

    /* U+FF "ÿ" */
    0xd, 0xd, 0x0, 0x0, 0x0, 0xb3, 0x8, 0x76,
    0x80, 0xc2, 0x1d, 0x1c, 0x0, 0xb7, 0x70, 0x6,
    0xf2, 0x0, 0x1d, 0x0, 0x6, 0x70, 0x8, 0xd1,
    0x0,

    /* U+100 "Ā" */
    0x4, 0xcc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+101 "ā" */
    0x9, 0xcc, 0x60, 0x0, 0x0, 0x9, 0xdc, 0x22,
    0x60, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+102 "Ă" */
    0x1, 0xa1, 0xa0, 0x0, 0x7, 0xa2, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0, 0xd5,
    0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30, 0xb3,
    0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d, 0xb,
    0x40, 0x0, 0xb3,

    /* U+103 "ă" */
    0x4, 0xaa, 0x10, 0x0, 0x0, 0x8, 0xdc, 0x23,
    0xa0, 0x4a, 0x7, 0xbc, 0xb5, 0xa0, 0x3b, 0x69,
    0x7, 0xb0, 0xcd, 0x9b,

    /* U+104 "Ą" */
    0x0, 0x4d, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x0,
    0xd5, 0x80, 0x0, 0x59, 0xd, 0x0, 0xa, 0x30,
    0xb3, 0x0, 0xfd, 0xde, 0x80, 0x59, 0x0, 0x1d,
    0xb, 0x40, 0x0, 0xb3, 0x0, 0x0, 0x29, 0x0,
    0x0, 0x3, 0xc2,

    /* U+105 "ą" */
    0x9, 0xdc, 0x22, 0x60, 0x4a, 0x7, 0xbc, 0xb5,
    0xa0, 0x3b, 0x69, 0x7, 0xb0, 0xcd, 0xac, 0x0,
    0xa, 0x20, 0x0, 0xa8,

    /* U+106 "Ć" */
    0x0, 0x3, 0x50, 0x0, 0x0, 0xb1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xdb, 0x20, 0xd, 0x30,
    0x5b, 0x4, 0xa0, 0x0, 0x90, 0x68, 0x0, 0x0,
    0x6, 0x80, 0x0, 0x0, 0x4a, 0x0, 0x8, 0x0,
    0xd3, 0x5, 0xb0, 0x3, 0xcd, 0xb1, 0x0,

    /* U+107 "ć" */
    0x0, 0x4a, 0x0, 0x4, 0x0, 0x8, 0xdc, 0x34,
    0xb0, 0x2c, 0x86, 0x0, 0x17, 0x60, 0x0, 0x4b,
    0x2, 0xb0, 0x8d, 0xc2,

    /* U+108 "Ĉ" */
    0x0, 0x16, 0x0, 0x0, 0xa, 0x76, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xdb, 0x20, 0xd, 0x30,
    0x5b, 0x4, 0xa0, 0x0, 0x90, 0x68, 0x0, 0x0,
    0x6, 0x80, 0x0, 0x0, 0x4a, 0x0, 0x8, 0x0,
    0xd3, 0x5, 0xb0, 0x3, 0xcd, 0xb1, 0x0,

    /* U+109 "ĉ" */
    0x3, 0xb5, 0x0, 0x30, 0x30, 0x8, 0xdc, 0x34,
    0xb0, 0x2c, 0x86, 0x0, 0x17, 0x60, 0x0, 0x4b,
    0x2, 0xb0, 0x8d, 0xc2,

    /* U+10A "Ċ" */
    0x0, 0x2b, 0x0, 0x0, 0x0, 0x10, 0x0, 0x3,
    0xcd, 0xb2, 0x0, 0xd3, 0x5, 0xb0, 0x4a, 0x0,
    0x9, 0x6, 0x80, 0x0, 0x0, 0x68, 0x0, 0x0,
    0x4, 0xa0, 0x0, 0x80, 0xd, 0x30, 0x5b, 0x0,
    0x3c, 0xdb, 0x10,

    /* U+10B "ċ" */
    0x0, 0xc0, 0x0, 0x1, 0x0, 0x8, 0xdc, 0x34,
    0xb0, 0x2c, 0x86, 0x0, 0x17, 0x60, 0x0, 0x4b,
    0x2, 0xb0, 0x8d, 0xc2,

    /* U+10C "Č" */
    0x0, 0x51, 0x50, 0x0, 0x6, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xdb, 0x20, 0xd, 0x30,
    0x5b, 0x4, 0xa0, 0x0, 0x90, 0x68, 0x0, 0x0,
    0x6, 0x80, 0x0, 0x0, 0x4a, 0x0, 0x8, 0x0,
    0xd3, 0x5, 0xb0, 0x3, 0xcd, 0xb1, 0x0,

    /* U+10D "č" */
    0x6, 0x69, 0x0, 0x3, 0x0, 0x8, 0xdc, 0x24,
    0xb0, 0x4a, 0x86, 0x0, 0x67, 0x60, 0x0, 0x4b,
    0x2, 0xa0, 0x8d, 0xc3,

    /* U+10E "Ď" */
    0x2, 0x99, 0x20, 0x0, 0x43, 0x0, 0x2f, 0xed,
    0x70, 0x2c, 0x0, 0xb6, 0x2c, 0x0, 0x2c, 0x2c,
    0x0, 0xe, 0x2c, 0x0, 0xe, 0x2c, 0x0, 0x2c,
    0x2c, 0x0, 0xb6, 0x2f, 0xde, 0x70,

    /* U+10F "ď" */
    0x0, 0x0, 0xe6, 0x60, 0x0, 0xe, 0x71, 0x9,
    0xda, 0xe0, 0x4, 0xb0, 0x2e, 0x0, 0x76, 0x0,
    0xe0, 0x7, 0x60, 0xe, 0x0, 0x4b, 0x2, 0xe0,
    0x0, 0x9c, 0xae, 0x0,

    /* U+110 "Đ" */
    0xf, 0xde, 0x80, 0x0, 0xe0, 0x9, 0x80, 0xe,
    0x0, 0xe, 0xc, 0xfd, 0x10, 0xd1, 0xe, 0x0,
    0xd, 0x10, 0xe0, 0x0, 0xe0, 0xe, 0x0, 0x98,
    0x0, 0xfd, 0xe9, 0x0,

    /* U+111 "đ" */
    0x0, 0x3d, 0xfa, 0x0, 0x0, 0xe0, 0x9, 0xda,
    0xe0, 0x4b, 0x2, 0xe0, 0x76, 0x0, 0xe0, 0x76,
    0x0, 0xe0, 0x4b, 0x2, 0xe0, 0x9, 0xca, 0xe0,

    /* U+112 "Ē" */
    0x7, 0xcc, 0x80, 0x0, 0x0, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+113 "ē" */
    0xa, 0xcc, 0x50, 0x0, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+114 "Ĕ" */
    0x5, 0x65, 0x60, 0x0, 0x99, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+115 "ĕ" */
    0x5, 0xaa, 0x10, 0x0, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+116 "Ė" */
    0x0, 0x67, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+117 "ė" */
    0x0, 0xa3, 0x0, 0x0, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+118 "Ę" */
    0x2f, 0xdd, 0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2f, 0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,
    0x0, 0x5, 0x60, 0x0, 0x6, 0xc0,

    /* U+119 "ę" */
    0x7, 0xdc, 0x33, 0xa0, 0x2c, 0x7e, 0xdd, 0xd7,
    0x70, 0x0, 0x4c, 0x1, 0x60, 0x8d, 0xd3, 0x0,
    0x74, 0x0, 0x7, 0xc0,

    /* U+11A "Ě" */
    0x2, 0x99, 0x30, 0x0, 0x34, 0x0, 0x2f, 0xdd,
    0xd4, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f,
    0xdd, 0xb0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd4,

    /* U+11B "ě" */
    0x4, 0x79, 0x0, 0x3, 0x0, 0x7, 0xdc, 0x33,
    0xa0, 0x2c, 0x7e, 0xdd, 0xd7, 0x70, 0x0, 0x4c,
    0x1, 0x60, 0x8d, 0xd4,

    /* U+11C "Ĝ" */
    0x0, 0x15, 0x0, 0x0, 0xa, 0x75, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xdc, 0x20, 0xd, 0x30,
    0x4c, 0x4, 0xb0, 0x0, 0x60, 0x68, 0x0, 0x0,
    0x6, 0x80, 0x6d, 0xe1, 0x4b, 0x0, 0xd, 0x10,
    0xd4, 0x1, 0xe1, 0x2, 0xce, 0xd6, 0x0,

    /* U+11D "ĝ" */
    0x2, 0xb6, 0x0, 0x30, 0x30, 0x9, 0xda, 0xd4,
    0xb0, 0x2e, 0x76, 0x0, 0xe7, 0x60, 0xe, 0x4b,
    0x3, 0xe0, 0x9e, 0xae, 0x3, 0x3, 0xc0, 0x9d,
    0xc3,

    /* U+11E "Ğ" */
    0x0, 0x9a, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xcd, 0xc2, 0x0, 0xd3, 0x4, 0xc0, 0x4b, 0x0,
    0x6, 0x6, 0x80, 0x0, 0x0, 0x68, 0x6, 0xde,
    0x14, 0xb0, 0x0, 0xd1, 0xd, 0x40, 0x1e, 0x10,
    0x2c, 0xed, 0x60,

    /* U+11F "ğ" */
    0x6, 0xa9, 0x0, 0x0, 0x0, 0x9, 0xda, 0xd4,
    0xb0, 0x2e, 0x76, 0x0, 0xe7, 0x60, 0xe, 0x4b,
    0x3, 0xe0, 0x9e, 0xae, 0x3, 0x3, 0xc0, 0x9d,
    0xc3,

    /* U+120 "Ġ" */
    0x0, 0x2a, 0x0, 0x0, 0x0, 0x10, 0x0, 0x3,
    0xcd, 0xc2, 0x0, 0xd3, 0x4, 0xc0, 0x4b, 0x0,
    0x6, 0x6, 0x80, 0x0, 0x0, 0x68, 0x6, 0xde,
    0x14, 0xb0, 0x0, 0xd1, 0xd, 0x40, 0x1e, 0x10,
    0x2c, 0xed, 0x60,

    /* U+121 "ġ" */
    0x0, 0xa2, 0x0, 0x0, 0x0, 0x9, 0xda, 0xd4,
    0xb0, 0x2e, 0x76, 0x0, 0xe7, 0x60, 0xe, 0x4b,
    0x3, 0xe0, 0x9e, 0xae, 0x3, 0x3, 0xc0, 0x9d,
    0xc3,

    /* U+122 "Ģ" */
    0x3, 0xcd, 0xc2, 0x0, 0xd3, 0x4, 0xc0, 0x4b,
    0x0, 0x6, 0x6, 0x80, 0x0, 0x0, 0x68, 0x6,
    0xde, 0x14, 0xb0, 0x0, 0xd1, 0xd, 0x40, 0x1e,
    0x10, 0x2c, 0xed, 0x60, 0x0, 0x6, 0x0, 0x0,
    0x0, 0xd0, 0x0, 0x0, 0x14, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x10, 0x0, 0x8, 0x40, 0x0, 0xc2, 0x0,
    0x0, 0x0, 0x9, 0xda, 0xd4, 0xb0, 0x2e, 0x76,
    0x0, 0xe7, 0x60, 0xe, 0x4b, 0x3, 0xe0, 0x9e,
    0xae, 0x3, 0x3, 0xc0, 0x9d, 0xc3,

    /* U+124 "Ĥ" */
    0x0, 0x3c, 0x30, 0x0, 0x6, 0x5, 0x0, 0x2c,
    0x0, 0xa, 0x42, 0xc0, 0x0, 0xa4, 0x2c, 0x0,
    0xa, 0x42, 0xfd, 0xdd, 0xf4, 0x2c, 0x0, 0xa,
    0x42, 0xc0, 0x0, 0xa4, 0x2c, 0x0, 0xa, 0x42,
    0xc0, 0x0, 0xa4,

    /* U+125 "ĥ" */
    0x4, 0xc2, 0x0, 0x60, 0x50, 0x59, 0x0, 0x5,
    0x90, 0x0, 0x5b, 0xbe, 0x45, 0xc0, 0x3c, 0x59,
    0x1, 0xd5, 0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90,
    0x1d,

    /* U+126 "Ħ" */
    0x3b, 0x0, 0xb, 0x43, 0xb0, 0x0, 0xb4, 0xbf,
    0xcc, 0xce, 0xc3, 0xfd, 0xdd, 0xf4, 0x3b, 0x0,
    0xb, 0x43, 0xb0, 0x0, 0xb4, 0x3b, 0x0, 0xb,
    0x43, 0xb0, 0x0, 0xb4,

    /* U+127 "ħ" */
    0x1d, 0xfc, 0x0, 0x2, 0xb0, 0x0, 0x2, 0xdb,
    0xe6, 0x2, 0xe1, 0x1e, 0x2, 0xb0, 0xe, 0x2,
    0xb0, 0xe, 0x2, 0xb0, 0xe, 0x2, 0xb0, 0xe,

    /* U+128 "Ĩ" */
    0x2a, 0xca, 0x0, 0x0, 0x0, 0x1, 0xd0, 0x0,
    0x1d, 0x0, 0x1, 0xd0, 0x0, 0x1d, 0x0, 0x1,
    0xd0, 0x0, 0x1d, 0x0, 0x1, 0xd0, 0x0, 0x1d,
    0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x3b, 0xc9, 0x0, 0x0, 0x4, 0xa0,
    0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0,
    0x4, 0xa0,

    /* U+12A "Ī" */
    0x3c, 0xcc, 0x0, 0x0, 0x0, 0x1, 0xd0, 0x0,
    0x1d, 0x0, 0x1, 0xd0, 0x0, 0x1d, 0x0, 0x1,
    0xd0, 0x0, 0x1d, 0x0, 0x1, 0xd0, 0x0, 0x1d,
    0x0,

    /* U+12B "ī" */
    0x4c, 0xcb, 0x0, 0x0, 0x4, 0xa0, 0x4, 0xa0,
    0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0,

    /* U+12C "Ĭ" */
    0xb, 0xb, 0x6, 0xa3, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0, 0x1, 0xd0,
    0x1, 0xd0, 0x1, 0xd0,

    /* U+12D "ĭ" */
    0x19, 0xa5, 0x0, 0x0, 0x4, 0xa0, 0x4, 0xa0,
    0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0, 0x4, 0xa0,

    /* U+12E "Į" */
    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x2f,
    0x92, 0xa9,

    /* U+12F "į" */
    0x3, 0xa0, 0x0, 0x3, 0xa0, 0x3a, 0x3, 0xa0,
    0x3a, 0x3, 0xa0, 0x4c, 0xa, 0x10, 0xc7,

    /* U+130 "İ" */
    0x1b, 0x1, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
    0x1d, 0x1d,

    /* U+131 "ı" */
    0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a,

    /* U+132 "Ĳ" */
    0x1d, 0x0, 0x0, 0x77, 0x1d, 0x0, 0x0, 0x77,
    0x1d, 0x0, 0x0, 0x77, 0x1d, 0x0, 0x0, 0x77,
    0x1d, 0x0, 0x0, 0x77, 0x1d, 0x3, 0x0, 0x77,
    0x1d, 0xe, 0x10, 0xa4, 0x1d, 0x4, 0xcc, 0x90,

    /* U+133 "ĳ" */
    0x3a, 0xc, 0x0, 0x0, 0x0, 0x3a, 0xd, 0x3,
    0xa0, 0xd0, 0x3a, 0xd, 0x3, 0xa0, 0xd0, 0x3a,
    0xd, 0x3, 0xa0, 0xd0, 0x0, 0xe, 0x0, 0xc,
    0xa0,

    /* U+134 "Ĵ" */
    0x0, 0x8, 0xa0, 0x0, 0x14, 0x23, 0x0, 0x3,
    0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0, 0x0,
    0x3, 0xc0, 0x0, 0x3, 0xc0, 0x30, 0x3, 0xb0,
    0x96, 0x7, 0x90, 0x1c, 0xdb, 0x10,

    /* U+135 "ĵ" */
    0x6, 0xb1, 0x3, 0x3, 0x2, 0xc0, 0x2, 0xc0,
    0x2, 0xc0, 0x2, 0xc0, 0x2, 0xc0, 0x2, 0xc0,
    0x4, 0xb0, 0x4d, 0x40,

    /* U+136 "Ķ" */
    0x2c, 0x0, 0x7a, 0x2, 0xc0, 0x4d, 0x0, 0x2c,
    0x2d, 0x20, 0x2, 0xcd, 0x60, 0x0, 0x2f, 0xad,
    0x0, 0x2, 0xc0, 0x89, 0x0, 0x2c, 0x0, 0xd4,
    0x2, 0xc0, 0x3, 0xd0, 0x0, 0x39, 0x0, 0x0,
    0x6, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0x59, 0x0, 0x0, 0x59, 0x0, 0x0, 0x59, 0xa,
    0x60, 0x59, 0x89, 0x0, 0x5d, 0xe0, 0x0, 0x5d,
    0xb6, 0x0, 0x59, 0x1d, 0x20, 0x59, 0x5, 0xb0,
    0x0, 0xd0, 0x0, 0x1, 0xb0, 0x0, 0x0, 0x0,
    0x0,

    /* U+138 "ĸ" */
    0x4a, 0x4, 0xc0, 0x4a, 0xd, 0x20, 0x4a, 0x88,
    0x0, 0x4f, 0xf2, 0x0, 0x4a, 0x4d, 0x10, 0x4a,
    0x5, 0xc0,

    /* U+139 "Ĺ" */
    0x9, 0x60, 0x0, 0x5, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0,
    0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,

    /* U+13A "ĺ" */
    0x4, 0x41, 0xb0, 0x0, 0x3, 0xa0, 0x3a, 0x3,
    0xa0, 0x3a, 0x3, 0xa0, 0x3a, 0x3, 0xa0, 0x3a,
    0x0,

    /* U+13B "Ļ" */
    0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,
    0x0, 0x33, 0x0, 0x0, 0x75, 0x0, 0x0, 0x50,
    0x0,

    /* U+13C "ļ" */
    0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a,
    0x15, 0x48, 0x41,

    /* U+13D "Ľ" */
    0x2c, 0xd, 0x0, 0x2c, 0x1a, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,

    /* U+13E "ľ" */
    0x3a, 0x84, 0x3a, 0xa1, 0x3a, 0x0, 0x3a, 0x0,
    0x3a, 0x0, 0x3a, 0x0, 0x3a, 0x0, 0x3a, 0x0,

    /* U+13F "Ŀ" */
    0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x2c, 0x1c, 0x0, 0x2c, 0x1, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,

    /* U+140 "ŀ" */
    0x3a, 0x0, 0x3a, 0x0, 0x3a, 0x0, 0x3a, 0xa2,
    0x3a, 0x10, 0x3a, 0x0, 0x3a, 0x0, 0x3a, 0x0,

    /* U+141 "Ł" */
    0x2c, 0x0, 0x0, 0x2c, 0x0, 0x0, 0x2c, 0x0,
    0x0, 0x4e, 0xa0, 0x0, 0x8c, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x2f, 0xdd, 0xd1,

    /* U+142 "ł" */
    0x2c, 0x2, 0xc0, 0x2c, 0x2, 0xe5, 0x8c, 0x2,
    0xc0, 0x2c, 0x2, 0xc0,

    /* U+143 "Ń" */
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x50, 0x0, 0x2f,
    0x10, 0xa, 0x42, 0xfa, 0x0, 0xa4, 0x2c, 0xd3,
    0xa, 0x42, 0xc4, 0xc0, 0xa4, 0x2c, 0xb, 0x6a,
    0x42, 0xc0, 0x2e, 0xb4, 0x2c, 0x0, 0x8f, 0x42,
    0xc0, 0x0, 0xe4,

    /* U+144 "ń" */
    0x0, 0x2b, 0x0, 0x3, 0x10, 0x5b, 0xbe, 0x45,
    0xc0, 0x3c, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59,
    0x1, 0xd5, 0x90, 0x1d,

    /* U+145 "Ņ" */
    0x2f, 0x10, 0xa, 0x42, 0xfa, 0x0, 0xa4, 0x2c,
    0xd3, 0xa, 0x42, 0xc4, 0xc0, 0xa4, 0x2c, 0xb,
    0x6a, 0x42, 0xc0, 0x2e, 0xb4, 0x2c, 0x0, 0x8f,
    0x42, 0xc0, 0x0, 0xe4, 0x0, 0x6, 0x0, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0x14, 0x0, 0x0,

    /* U+146 "ņ" */
    0x5b, 0xbe, 0x45, 0xc0, 0x3c, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x0,
    0x51, 0x0, 0xc, 0x0, 0x0, 0x50, 0x0,

    /* U+147 "Ň" */
    0x0, 0x86, 0x90, 0x0, 0x0, 0x60, 0x0, 0x2f,
    0x10, 0xa, 0x42, 0xfa, 0x0, 0xa4, 0x2c, 0xd3,
    0xa, 0x42, 0xc4, 0xc0, 0xa4, 0x2c, 0xb, 0x6a,
    0x42, 0xc0, 0x2e, 0xb4, 0x2c, 0x0, 0x8f, 0x42,
    0xc0, 0x0, 0xe4,

    /* U+148 "ň" */
    0x4, 0x79, 0x0, 0x2, 0x0, 0x5b, 0xbe, 0x45,
    0xc0, 0x3c, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59,
    0x1, 0xd5, 0x90, 0x1d,

    /* U+149 "ŉ" */
    0xd, 0x0, 0x0, 0x26, 0x0, 0x0, 0x5, 0xbb,
    0xe4, 0x5, 0xc0, 0x3c, 0x5, 0x90, 0x1d, 0x5,
    0x90, 0x1d, 0x5, 0x90, 0x1d, 0x5, 0x90, 0x1d,

    /* U+14A "Ŋ" */
    0x3e, 0x10, 0xc, 0x23, 0xf9, 0x0, 0xc2, 0x3c,
    0xd2, 0xc, 0x23, 0xb4, 0xb0, 0xc2, 0x3b, 0xb,
    0x4c, 0x23, 0xb0, 0x3d, 0xc2, 0x3b, 0x0, 0x9f,
    0x23, 0xb0, 0x1, 0xf2, 0x0, 0x0, 0xd, 0x10,
    0x0, 0xd, 0xa0,

    /* U+14B "ŋ" */
    0x4a, 0xbe, 0x54, 0xb0, 0x2d, 0x49, 0x0, 0xe4,
    0x90, 0xe, 0x49, 0x0, 0xe4, 0x90, 0xe, 0x0,
    0x1, 0xe0, 0x2, 0xe7,

    /* U+14C "Ō" */
    0x2, 0xcc, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+14D "ō" */
    0xa, 0xcc, 0x50, 0x0, 0x0, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+14E "Ŏ" */
    0x0, 0xc0, 0xc0, 0x0, 0x5, 0xa4, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+14F "ŏ" */
    0x5, 0xaa, 0x10, 0x0, 0x0, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+150 "Ő" */
    0x0, 0x3b, 0x95, 0x0, 0x6, 0x36, 0x0, 0x2,
    0xce, 0xb1, 0x0, 0xd4, 0x5, 0xc0, 0x4b, 0x0,
    0xd, 0x26, 0x80, 0x0, 0xa4, 0x68, 0x0, 0xa,
    0x44, 0xb0, 0x0, 0xd2, 0xd, 0x40, 0x5c, 0x0,
    0x2c, 0xeb, 0x10,

    /* U+151 "ő" */
    0x0, 0xc6, 0xa0, 0x2, 0x57, 0x0, 0x7, 0xdd,
    0x40, 0x4c, 0x2, 0xd0, 0x86, 0x0, 0xb2, 0x76,
    0x0, 0xb3, 0x3c, 0x1, 0xe0, 0x7, 0xdd, 0x40,

    /* U+152 "Œ" */
    0x5, 0xdf, 0xff, 0xff, 0xb1, 0xd2, 0xb, 0x30,
    0x0, 0x68, 0x0, 0xb3, 0x0, 0x7, 0x60, 0xb,
    0xed, 0xd4, 0x76, 0x0, 0xb3, 0x0, 0x6, 0x80,
    0xb, 0x30, 0x0, 0x1d, 0x10, 0xb3, 0x0, 0x0,
    0x5d, 0xdf, 0xed, 0xda,

    /* U+153 "œ" */
    0x8, 0xdd, 0x39, 0xdc, 0x13, 0xc0, 0x2f, 0x80,
    0x59, 0x76, 0x0, 0xcd, 0xdd, 0xa7, 0x60, 0xc,
    0x50, 0x0, 0x3c, 0x2, 0xeb, 0x0, 0x20, 0x7d,
    0xd3, 0x8d, 0xd4,

    /* U+154 "Ŕ" */
    0x0, 0xc, 0x20, 0x0, 0x23, 0x0, 0x2f, 0xee,
    0xa0, 0x2c, 0x0, 0x97, 0x2c, 0x0, 0x4a, 0x2c,
    0x0, 0xa7, 0x2f, 0xde, 0xa0, 0x2c, 0x4, 0xb0,
    0x2c, 0x0, 0xc3, 0x2c, 0x0, 0x4b,

    /* U+155 "ŕ" */
    0x0, 0xc2, 0x1, 0x10, 0x5c, 0xd3, 0x5c, 0x0,
    0x59, 0x0, 0x59, 0x0, 0x59, 0x0, 0x59, 0x0,

    /* U+156 "Ŗ" */
    0x2f, 0xee, 0xa0, 0x2c, 0x0, 0x97, 0x2c, 0x0,
    0x4a, 0x2c, 0x0, 0xa7, 0x2f, 0xde, 0xa0, 0x2c,
    0x4, 0xb0, 0x2c, 0x0, 0xc3, 0x2c, 0x0, 0x4b,
    0x0, 0x33, 0x0, 0x0, 0x84, 0x0, 0x0, 0x50,
    0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x5c, 0xd3, 0x5c, 0x0, 0x59, 0x0,
    0x59, 0x0, 0x59, 0x0, 0x59, 0x0, 0x14, 0x0,
    0x58, 0x0, 0x41, 0x0,

    /* U+158 "Ř" */
    0x2, 0x9a, 0x20, 0x0, 0x43, 0x0, 0x2f, 0xee,
    0xa0, 0x2c, 0x0, 0x97, 0x2c, 0x0, 0x4a, 0x2c,
    0x0, 0xa7, 0x2f, 0xde, 0xa0, 0x2c, 0x4, 0xb0,
    0x2c, 0x0, 0xc3, 0x2c, 0x0, 0x4b,

    /* U+159 "ř" */
    0x28, 0x92, 0x1, 0x10, 0x5c, 0xd3, 0x5c, 0x0,
    0x59, 0x0, 0x59, 0x0, 0x59, 0x0, 0x59, 0x0,

    /* U+15A "Ś" */
    0x0, 0xc, 0x30, 0x0, 0x23, 0x0, 0x7, 0xdd,
    0x80, 0x3c, 0x0, 0xb5, 0x5b, 0x0, 0x22, 0xb,
    0xb5, 0x0, 0x0, 0x4a, 0xd1, 0x32, 0x0, 0x87,
    0x6a, 0x0, 0x96, 0x8, 0xdd, 0xa0,

    /* U+15B "ś" */
    0x0, 0x2b, 0x0, 0x3, 0x0, 0xa, 0xdb, 0x4,
    0xa0, 0x87, 0x1d, 0x84, 0x10, 0x5, 0xc5, 0x56,
    0x5, 0x91, 0xbd, 0xc2,

    /* U+15C "Ŝ" */
    0x0, 0x9a, 0x0, 0x2, 0x43, 0x20, 0x7, 0xdd,
    0x80, 0x3c, 0x0, 0xb5, 0x5b, 0x0, 0x22, 0xb,
    0xb5, 0x0, 0x0, 0x4a, 0xd1, 0x32, 0x0, 0x87,
    0x6a, 0x0, 0x96, 0x8, 0xdd, 0xa0,

    /* U+15D "ŝ" */
    0x2, 0xb7, 0x0, 0x30, 0x30, 0xa, 0xdc, 0x14,
    0xa0, 0x56, 0x1d, 0x82, 0x0, 0x5, 0xc5, 0x67,
    0x5, 0x90, 0xad, 0xc2,

    /* U+15E "Ş" */
    0x7, 0xdd, 0x80, 0x3c, 0x0, 0xb5, 0x5b, 0x0,
    0x22, 0xb, 0xb5, 0x0, 0x0, 0x4a, 0xd1, 0x32,
    0x0, 0x87, 0x6a, 0x0, 0x96, 0x8, 0xee, 0xa0,
    0x0, 0x2a, 0x0, 0x0, 0x3b, 0x0,

    /* U+15F "ş" */
    0xa, 0xdc, 0x14, 0xa0, 0x56, 0x1d, 0x82, 0x0,
    0x5, 0xc5, 0x67, 0x5, 0x90, 0xad, 0xc2, 0x0,
    0x67, 0x0, 0x7, 0x80,

    /* U+160 "Š" */
    0x2, 0x99, 0x30, 0x0, 0x34, 0x0, 0x7, 0xdd,
    0x80, 0x3c, 0x0, 0xb5, 0x5b, 0x0, 0x22, 0xb,
    0xb5, 0x0, 0x0, 0x4a, 0xd1, 0x32, 0x0, 0x87,
    0x6a, 0x0, 0x96, 0x8, 0xdd, 0xa0,

    /* U+161 "š" */
    0x4, 0x79, 0x0, 0x3, 0x0, 0xa, 0xdb, 0x4,
    0xa0, 0x87, 0x1d, 0x84, 0x10, 0x5, 0xc5, 0x56,
    0x5, 0x91, 0xbd, 0xc2,

    /* U+162 "Ţ" */
    0xad, 0xee, 0xda, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x39, 0x0, 0x0, 0x4a, 0x0,

    /* U+163 "ţ" */
    0x7, 0x0, 0xe, 0x0, 0xbf, 0xa0, 0xe, 0x0,
    0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xa, 0xd0,
    0x1, 0xa1, 0x2, 0xb1,

    /* U+164 "Ť" */
    0x2, 0x99, 0x20, 0x0, 0x43, 0x0, 0xad, 0xee,
    0xda, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+165 "ť" */
    0x0, 0x39, 0x7, 0x64, 0xe, 0x0, 0xbf, 0xa0,
    0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0,
    0xa, 0xc0,

    /* U+166 "Ŧ" */
    0xad, 0xee, 0xda, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x6, 0xee, 0x70, 0x0, 0x77, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x70, 0x0, 0xe, 0x0, 0xb, 0xfa, 0x0,
    0xe, 0x0, 0xd, 0xfd, 0x0, 0xe, 0x0, 0x0,
    0xe0, 0x0, 0xa, 0xc0,

    /* U+168 "Ũ" */
    0x3, 0xbc, 0x90, 0x0, 0x0, 0x0, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+169 "ũ" */
    0x0, 0x0, 0x0, 0x9c, 0xb4, 0x0, 0x0, 0x5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59,
    0x1, 0xd3, 0xb0, 0x4d, 0xb, 0xda, 0xd0,

    /* U+16A "Ū" */
    0x4, 0xcc, 0xb0, 0x0, 0x0, 0x0, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+16B "ū" */
    0xa, 0xcc, 0x50, 0x0, 0x0, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+16C "Ŭ" */
    0x1, 0xa1, 0xa0, 0x0, 0x7a, 0x20, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+16D "ŭ" */
    0x5, 0xa9, 0x10, 0x0, 0x0, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x3b,
    0x4, 0xd0, 0xbd, 0xad,

    /* U+16E "Ů" */
    0x0, 0x58, 0x0, 0x0, 0x84, 0x40, 0x0, 0x48,
    0x0, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d,
    0x4a, 0x0, 0x2c, 0x1d, 0x10, 0x79, 0x5, 0xde,
    0xa1,

    /* U+16F "ů" */
    0x0, 0x85, 0x0, 0x34, 0x80, 0x0, 0x85, 0x5,
    0x90, 0x1d, 0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59,
    0x1, 0xd3, 0xb0, 0x4d, 0xb, 0xda, 0xd0,

    /* U+170 "Ű" */
    0x0, 0x68, 0xc3, 0x0, 0x74, 0x50, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59,
    0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a, 0x0, 0x2c,
    0x1d, 0x10, 0x79, 0x5, 0xde, 0xa1,

    /* U+171 "ű" */
    0x0, 0xc6, 0xa0, 0x2, 0x58, 0x0, 0x59, 0x1,
    0xd0, 0x59, 0x1, 0xd0, 0x59, 0x1, 0xd0, 0x59,
    0x1, 0xd0, 0x3b, 0x4, 0xd0, 0xb, 0xda, 0xd0,

    /* U+172 "Ų" */
    0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0,
    0x1d, 0x59, 0x0, 0x1d, 0x59, 0x0, 0x1d, 0x4a,
    0x0, 0x2c, 0x1d, 0x10, 0x79, 0x5, 0xde, 0xb1,
    0x0, 0xc, 0x0, 0x0, 0xc, 0x70,

    /* U+173 "ų" */
    0x59, 0x1, 0xd5, 0x90, 0x1d, 0x59, 0x1, 0xd5,
    0x90, 0x1d, 0x3b, 0x4, 0xd0, 0xbd, 0xad, 0x0,
    0x9, 0x20, 0x0, 0x99,

    /* U+174 "Ŵ" */
    0x0, 0x3, 0xc3, 0x0, 0x0, 0x0, 0x60, 0x50,
    0x0, 0x95, 0x0, 0xf0, 0x6, 0x86, 0x80, 0x4f,
    0x40, 0x95, 0x2b, 0x8, 0x98, 0xc, 0x10, 0xe0,
    0xc1, 0xb0, 0xd0, 0xb, 0x3c, 0xc, 0x3b, 0x0,
    0x89, 0x80, 0x89, 0x70, 0x4, 0xf4, 0x4, 0xf4,
    0x0, 0x1f, 0x0, 0xf, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x2a, 0x70, 0x0, 0x0, 0x20, 0x20, 0x0,
    0xa3, 0xc, 0x30, 0xb2, 0x67, 0xe, 0x80, 0xd0,
    0x2b, 0x47, 0xc3, 0xa0, 0xd, 0x92, 0xb8, 0x60,
    0xa, 0xd0, 0x6f, 0x20, 0x6, 0x90, 0x2e, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x99, 0x0, 0x2, 0x33, 0x20, 0xa5, 0x0,
    0x6a, 0x3d, 0x0, 0xd2, 0xb, 0x45, 0xb0, 0x3,
    0xcc, 0x30, 0x0, 0xbb, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+177 "ŷ" */
    0x5, 0xb4, 0x0, 0x20, 0x20, 0xb3, 0x8, 0x76,
    0x80, 0xc2, 0x1d, 0x1c, 0x0, 0xb7, 0x70, 0x6,
    0xf2, 0x0, 0x1d, 0x0, 0x6, 0x70, 0x8, 0xd1,
    0x0,

    /* U+178 "Ÿ" */
    0x7, 0x65, 0x70, 0x0, 0x0, 0x0, 0xa5, 0x0,
    0x6a, 0x3d, 0x0, 0xd2, 0xb, 0x45, 0xb0, 0x3,
    0xcc, 0x30, 0x0, 0xbb, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0,

    /* U+179 "Ź" */
    0x0, 0xc, 0x20, 0x0, 0x23, 0x0, 0x7d, 0xdd,
    0xf6, 0x0, 0x1, 0xe1, 0x0, 0xb, 0x50, 0x0,
    0x4c, 0x0, 0x0, 0xd2, 0x0, 0x8, 0x80, 0x0,
    0x2d, 0x0, 0x0, 0x9f, 0xdd, 0xd8,

    /* U+17A "ź" */
    0x0, 0x68, 0x0, 0x3, 0x0, 0x7d, 0xdf, 0x70,
    0x2, 0xd0, 0x0, 0xc4, 0x0, 0x6a, 0x0, 0x1d,
    0x10, 0x8, 0xed, 0xd8,

    /* U+17B "Ż" */
    0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xdd,
    0xf6, 0x0, 0x1, 0xe1, 0x0, 0xb, 0x50, 0x0,
    0x4c, 0x0, 0x0, 0xd2, 0x0, 0x8, 0x80, 0x0,
    0x2d, 0x0, 0x0, 0x9f, 0xdd, 0xd8,

    /* U+17C "ż" */
    0x0, 0xd0, 0x0, 0x0, 0x0, 0x7d, 0xdf, 0x70,
    0x2, 0xd0, 0x0, 0xc4, 0x0, 0x6a, 0x0, 0x1d,
    0x10, 0x8, 0xed, 0xd8,

    /* U+17D "Ž" */
    0x2, 0x99, 0x20, 0x0, 0x33, 0x0, 0x7d, 0xdd,
    0xf6, 0x0, 0x1, 0xe1, 0x0, 0xb, 0x50, 0x0,
    0x4c, 0x0, 0x0, 0xd2, 0x0, 0x8, 0x80, 0x0,
    0x2d, 0x0, 0x0, 0x9f, 0xdd, 0xd8,

    /* U+17E "ž" */
    0x7, 0x68, 0x0, 0x3, 0x0, 0x7d, 0xdf, 0x70,
    0x2, 0xd0, 0x0, 0xc4, 0x0, 0x6a, 0x0, 0x1d,
    0x10, 0x8, 0xed, 0xd8,

    /* U+17F "ſ" */
    0x8, 0xd0, 0x2d, 0x0, 0x3b, 0x0, 0x3b, 0x0,
    0x3b, 0x0, 0x3b, 0x0, 0x3b, 0x0, 0x3b, 0x0,
    0x3b, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x4, 0x9c, 0x10, 0x0, 0x16,
    0xbf, 0xff, 0xf2, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0x20, 0x5, 0xff, 0xd9, 0x41, 0xf2, 0x0, 0x5f,
    0x20, 0x0, 0x1f, 0x20, 0x5, 0xe0, 0x0, 0x1,
    0xf2, 0x0, 0x5e, 0x0, 0x7, 0x9f, 0x20, 0x48,
    0xe0, 0x7, 0xff, 0xf2, 0xaf, 0xfe, 0x0, 0x2b,
    0xd8, 0x7, 0xff, 0x90, 0x0, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x41, 0x88, 0x88, 0x88, 0x14, 0xeb, 0xe7, 0x77,
    0x7e, 0xbe, 0xa2, 0xd0, 0x0, 0xd, 0x2a, 0xeb,
    0xe3, 0x33, 0x3e, 0xbe, 0xb4, 0xfb, 0xbb, 0xbf,
    0x4b, 0xd9, 0xd0, 0x0, 0xd, 0x9d, 0xb5, 0xd0,
    0x0, 0xd, 0x5b, 0xb7, 0xff, 0xff, 0xff, 0x7b,

    /* U+F00B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xd6, 0xff,
    0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0x67,
    0x52, 0x77, 0x77, 0x76, 0xef, 0xc6, 0xff, 0xff,
    0xfe, 0xff, 0xe7, 0xff, 0xff, 0xff, 0x67, 0x52,
    0x77, 0x77, 0x76, 0xef, 0xc6, 0xff, 0xff, 0xfe,
    0xff, 0xe7, 0xff, 0xff, 0xff, 0x78, 0x63, 0x88,
    0x88, 0x87,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0,
    0x6, 0xfd, 0x0, 0x0, 0x0, 0x6f, 0xf7, 0x7c,
    0x10, 0x6, 0xff, 0x70, 0xdf, 0xd1, 0x6f, 0xf7,
    0x0, 0x1d, 0xfe, 0xff, 0x70, 0x0, 0x1, 0xdf,
    0xf7, 0x0, 0x0, 0x0, 0x1c, 0x60, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x0, 0x0, 0xc, 0xd1, 0x2, 0xea, 0xaf,
    0xd4, 0xef, 0x80, 0xaf, 0xff, 0x80, 0x2, 0xff,
    0xf1, 0x2, 0xef, 0xdf, 0xd1, 0xdf, 0x80, 0xaf,
    0xb6, 0x70, 0x0, 0x85,

    /* U+F011 "" */
    0x0, 0x0, 0xa6, 0x0, 0x0, 0x2, 0xa0, 0xea,
    0x29, 0x0, 0xe, 0xe1, 0xea, 0x5f, 0xa0, 0x7f,
    0x40, 0xea, 0x8, 0xf3, 0xbd, 0x0, 0xea, 0x1,
    0xf7, 0xcc, 0x0, 0xb7, 0x0, 0xf8, 0xaf, 0x0,
    0x0, 0x4, 0xf6, 0x4f, 0xa0, 0x0, 0x1d, 0xf1,
    0x9, 0xfd, 0x89, 0xef, 0x50, 0x0, 0x6d, 0xff,
    0xc4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x1, 0x88, 0x10, 0x0, 0x0, 0x5, 0xff,
    0x40, 0x0, 0x1e, 0xcf, 0xff, 0xfc, 0xd0, 0x7f,
    0xff, 0xdd, 0xff, 0xf7, 0x2d, 0xfa, 0x0, 0xbf,
    0xd1, 0xb, 0xf7, 0x0, 0x8f, 0xa0, 0x6f, 0xfe,
    0x55, 0xef, 0xf6, 0x4f, 0xff, 0xff, 0xff, 0xf3,
    0x6, 0x3a, 0xff, 0xa3, 0x60, 0x0, 0x3, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x90, 0xf8, 0x0, 0x0, 0x9, 0xf8, 0xec,
    0xf8, 0x0, 0x1, 0xbe, 0x5a, 0x5c, 0xf8, 0x0,
    0x2d, 0xd5, 0xef, 0xf6, 0xaf, 0x50, 0xda, 0x6f,
    0xff, 0xff, 0x87, 0xf1, 0x11, 0xff, 0xff, 0xff,
    0xf5, 0x10, 0x2, 0xff, 0xc3, 0x9f, 0xf6, 0x0,
    0x2, 0xff, 0xb0, 0x7f, 0xf6, 0x0, 0x1, 0xbb,
    0x70, 0x4b, 0xb3, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x88, 0x20, 0x0, 0x0, 0x1, 0xff,
    0x60, 0x0, 0x0, 0x1, 0xff, 0x60, 0x0, 0x0,
    0x1, 0xff, 0x60, 0x0, 0x1, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x5f, 0xff, 0xfa, 0x0, 0x0, 0x5,
    0xff, 0xb0, 0x0, 0x8b, 0xb9, 0x8b, 0x8b, 0xb9,
    0xdf, 0xff, 0xff, 0xfe, 0xdf, 0xcf, 0xff, 0xff,
    0xfc, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F01C "" */
    0x0, 0x24, 0x44, 0x44, 0x30, 0x0, 0x1, 0xef,
    0xff, 0xff, 0xf4, 0x0, 0xb, 0xc0, 0x0, 0x0,
    0x8e, 0x10, 0x6e, 0x10, 0x0, 0x0, 0xc, 0xa0,
    0xee, 0xcb, 0x10, 0xa, 0xcd, 0xf2, 0xff, 0xff,
    0xb8, 0x9f, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe1,

    /* U+F021 "" */
    0x0, 0x4, 0x87, 0x30, 0x5f, 0x2, 0xdf, 0xfe,
    0xfc, 0x7f, 0x1e, 0xd3, 0x0, 0x3c, 0xff, 0x9f,
    0x10, 0x5, 0xfe, 0xff, 0x44, 0x0, 0x2, 0x66,
    0x66, 0x12, 0x22, 0x0, 0x0, 0x11, 0xff, 0xff,
    0x50, 0x0, 0xda, 0xff, 0xa3, 0x10, 0x8, 0xf4,
    0xfc, 0xfb, 0x66, 0xbf, 0x80, 0xf5, 0x5c, 0xff,
    0xd5, 0x0, 0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x70, 0x0, 0xbf, 0xab, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x3e, 0xf0, 0x0, 0x2c,

    /* U+F027 "" */
    0x0, 0x0, 0x70, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0xab, 0xdf, 0xf0, 0x20, 0xff, 0xff, 0xf0, 0xa6,
    0xff, 0xff, 0xf0, 0x59, 0xff, 0xff, 0xf0, 0x92,
    0x0, 0x3e, 0xf0, 0x0, 0x0, 0x2, 0xc0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0,
    0x70, 0x0, 0xaa, 0x0, 0x0, 0xb, 0xf0, 0xa,
    0x4a, 0x70, 0xab, 0xdf, 0xf0, 0x23, 0xe2, 0xe0,
    0xff, 0xff, 0xf0, 0xa6, 0x95, 0xc2, 0xff, 0xff,
    0xf0, 0x59, 0x76, 0xc3, 0xff, 0xff, 0xf0, 0x92,
    0xc3, 0xe1, 0x0, 0x3e, 0xf0, 0x9, 0xa6, 0xb0,
    0x0, 0x2, 0xc0, 0x3, 0x3e, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xc3, 0x0,

    /* U+F03E "" */
    0x24, 0x44, 0x44, 0x44, 0x42, 0xff, 0xef, 0xff,
    0xff, 0xff, 0xf3, 0xd, 0xff, 0xef, 0xff, 0xf8,
    0x4e, 0xfe, 0x25, 0xff, 0xff, 0x9d, 0xe2, 0x0,
    0x6f, 0xf9, 0x1, 0x20, 0x0, 0x4f, 0xf7, 0x44,
    0x44, 0x44, 0x7f, 0xcf, 0xff, 0xff, 0xff, 0xfc,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0xe, 0x70, 0x3, 0xe4, 0xe7,
    0x4, 0xff, 0x5e, 0x75, 0xff, 0xf5, 0xec, 0xff,
    0xff, 0x5e, 0xff, 0xff, 0xf5, 0xea, 0xef, 0xff,
    0x5e, 0x71, 0xdf, 0xf5, 0xe7, 0x1, 0xcf, 0x59,
    0x50, 0x0, 0x92,

    /* U+F04B "" */
    0x88, 0x0, 0x0, 0x0, 0xf, 0xfe, 0x50, 0x0,
    0x0, 0xff, 0xff, 0xc3, 0x0, 0xf, 0xff, 0xff,
    0xf9, 0x10, 0xff, 0xff, 0xff, 0xfe, 0x5f, 0xff,
    0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xf8, 0xf,
    0xff, 0xff, 0xb2, 0x0, 0xff, 0xfd, 0x40, 0x0,
    0xe, 0xf7, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x0,

    /* U+F04C "" */
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0x90, 0xdf,
    0xf9, 0xff, 0xfc, 0xf, 0xff, 0xcf, 0xff, 0xc0,
    0xff, 0xfc, 0xff, 0xfc, 0xf, 0xff, 0xcf, 0xff,
    0xc0, 0xff, 0xfc, 0xff, 0xfc, 0xf, 0xff, 0xcf,
    0xff, 0xc0, 0xff, 0xfc, 0xff, 0xfb, 0xf, 0xff,
    0xb8, 0xbb, 0x50, 0x8b, 0xb5,

    /* U+F04D "" */
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xcf,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff,
    0xb8, 0xbb, 0xbb, 0xbb, 0xb5,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0xb, 0xa0, 0x0, 0xe7, 0xcf,
    0xb0, 0xe, 0x7c, 0xff, 0xc1, 0xe7, 0xcf, 0xff,
    0xdf, 0x7c, 0xff, 0xff, 0xf7, 0xcf, 0xff, 0x9e,
    0x7c, 0xff, 0x70, 0xe7, 0xcf, 0x60, 0xe, 0x77,
    0x50, 0x0, 0x95,

    /* U+F052 "" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x60, 0x0, 0x0, 0x9, 0xff, 0xf5, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x40, 0x6, 0xff, 0xff, 0xff,
    0xf3, 0xe, 0xff, 0xff, 0xff, 0xfa, 0x3, 0x66,
    0x66, 0x66, 0x62, 0xd, 0xff, 0xff, 0xff, 0xf9,
    0xf, 0xff, 0xff, 0xff, 0xfb, 0x6, 0x88, 0x88,
    0x88, 0x84,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xc7, 0x0, 0x1d,
    0xf5, 0x1, 0xdf, 0x50, 0x1d, 0xf5, 0x0, 0x4f,
    0xd0, 0x0, 0x6, 0xfc, 0x0, 0x0, 0x6f, 0xc0,
    0x0, 0x6, 0xf9, 0x0, 0x0, 0x51,

    /* U+F054 "" */
    0x0, 0x0, 0x0, 0x3e, 0x30, 0x0, 0x2e, 0xf3,
    0x0, 0x2, 0xef, 0x30, 0x0, 0x2e, 0xe3, 0x0,
    0x9, 0xf8, 0x0, 0x8f, 0xa0, 0x8, 0xfa, 0x0,
    0x5f, 0xa0, 0x0, 0x6, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x8f, 0x40,
    0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x0, 0x9f,
    0x50, 0x0, 0x9b, 0xbd, 0xfc, 0xbb, 0x6f, 0xff,
    0xff, 0xff, 0xfb, 0x13, 0x3a, 0xf7, 0x33, 0x10,
    0x0, 0x9f, 0x50, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x39, 0x10, 0x0,

    /* U+F068 "" */
    0xbd, 0xdd, 0xdd, 0xdd, 0x8e, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F06E "" */
    0x0, 0x4, 0x8a, 0x95, 0x0, 0x0, 0x1, 0xcf,
    0x84, 0x6e, 0xe3, 0x0, 0x1e, 0xf5, 0x8, 0x72,
    0xff, 0x40, 0xbf, 0xe0, 0x2d, 0xf5, 0xbf, 0xe0,
    0xdf, 0xe3, 0xff, 0xf6, 0xaf, 0xf1, 0x4f, 0xf3,
    0xaf, 0xd1, 0xef, 0x70, 0x5, 0xfd, 0x31, 0x2b,
    0xf7, 0x0, 0x0, 0x19, 0xdf, 0xea, 0x30, 0x0,

    /* U+F070 "" */
    0xb6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x16, 0xaa, 0x83, 0x0, 0x0, 0x3, 0xef, 0xe6,
    0x49, 0xfb, 0x0, 0x0, 0x1, 0xbe, 0x49, 0x28,
    0xfd, 0x0, 0x1d, 0x40, 0x8f, 0xfe, 0x1f, 0xf9,
    0x4, 0xff, 0x50, 0x5f, 0xf1, 0xff, 0xb0, 0xa,
    0xfc, 0x0, 0x2d, 0xdf, 0xf2, 0x0, 0xa, 0xfa,
    0x10, 0x1b, 0xf7, 0x0, 0x0, 0x4, 0xbe, 0xe4,
    0x8, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x2, 0xe6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xd, 0xe7, 0xcf,
    0x20, 0x0, 0x0, 0x7, 0xfc, 0x8, 0xfb, 0x0,
    0x0, 0x1, 0xef, 0xd0, 0x9f, 0xf4, 0x0, 0x0,
    0x9f, 0xff, 0x5c, 0xff, 0xd0, 0x0, 0x2f, 0xff,
    0xe1, 0xaf, 0xff, 0x60, 0xb, 0xff, 0xfe, 0x2b,
    0xff, 0xfe, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x1, 0x33, 0x33, 0x33, 0x33, 0x32, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xc1, 0xef, 0xd1, 0x3, 0xef, 0xfc, 0x99,
    0xfb, 0x2e, 0xec, 0xf8, 0x0, 0x54, 0xde, 0x25,
    0x70, 0x0, 0xc, 0xf4, 0x1, 0x10, 0x0, 0xbf,
    0x5c, 0x78, 0xd1, 0xff, 0xf6, 0xa, 0xff, 0xfd,
    0x78, 0x60, 0x0, 0x7c, 0xf6, 0x0, 0x0, 0x0,
    0x5, 0x60,

    /* U+F077 "" */
    0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0xaf, 0x60,
    0x0, 0x0, 0xaf, 0xef, 0x60, 0x0, 0xaf, 0x90,
    0xcf, 0x60, 0x9f, 0x80, 0x0, 0xcf, 0x57, 0x80,
    0x0, 0x0, 0xa4,

    /* U+F078 "" */
    0x11, 0x0, 0x0, 0x2, 0xc, 0xe2, 0x0, 0x5,
    0xf8, 0x3f, 0xe2, 0x5, 0xfd, 0x10, 0x3f, 0xe7,
    0xfd, 0x10, 0x0, 0x3f, 0xfd, 0x10, 0x0, 0x0,
    0x3b, 0x10, 0x0,

    /* U+F079 "" */
    0x0, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xc3, 0xff, 0xff, 0xf5, 0x0, 0xbe, 0xfe, 0xb3,
    0x44, 0x4e, 0x60, 0x4, 0x3f, 0x34, 0x0, 0x0,
    0xd6, 0x0, 0x2, 0xf2, 0x0, 0x0, 0xd, 0x60,
    0x0, 0x2f, 0x20, 0x0, 0x8c, 0xea, 0xf1, 0x1,
    0xff, 0xff, 0xf7, 0xdf, 0xf7, 0x0, 0x4, 0x44,
    0x44, 0x11, 0xc7, 0x0,

    /* U+F07B "" */
    0x58, 0x88, 0x20, 0x0, 0x0, 0xff, 0xff, 0xe4,
    0x44, 0x41, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfc,

    /* U+F093 "" */
    0x0, 0x0, 0x33, 0x0, 0x0, 0x0, 0x3, 0xff,
    0x40, 0x0, 0x0, 0x3f, 0xff, 0xf4, 0x0, 0x2,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x36, 0xff, 0x63,
    0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0, 0x4,
    0xff, 0x40, 0x0, 0x9a, 0xa5, 0xff, 0x5a, 0xa9,
    0xff, 0xff, 0xdd, 0xfe, 0xdf, 0xff, 0xff, 0xff,
    0xfc, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0xa8, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x6f, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x5f,
    0xd0, 0x0, 0x39, 0x10, 0x4f, 0xf4, 0x0, 0xbf,
    0xfc, 0x9f, 0xf6, 0x0, 0xd, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x9f, 0xfd, 0x81, 0x0, 0x0, 0x1,
    0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfe, 0x30, 0x5,
    0xc6, 0xe7, 0xbb, 0x5, 0xff, 0x4d, 0xbd, 0xb4,
    0xff, 0x40, 0x3c, 0xff, 0xff, 0x40, 0x0, 0x8,
    0xff, 0xb0, 0x0, 0x6f, 0xff, 0xdf, 0x80, 0xe,
    0x7b, 0xb2, 0xef, 0x80, 0xdb, 0xd9, 0x2, 0xef,
    0x73, 0xca, 0x10, 0x2, 0x72,

    /* U+F0C5 "" */
    0x0, 0x5d, 0xdd, 0x48, 0x0, 0x8, 0xff, 0xf6,
    0xf8, 0xcc, 0x8f, 0xff, 0x84, 0x3f, 0xe8, 0xff,
    0xff, 0xfc, 0xfe, 0x8f, 0xff, 0xff, 0xcf, 0xe8,
    0xff, 0xff, 0xfc, 0xfe, 0x8f, 0xff, 0xff, 0xcf,
    0xe7, 0xff, 0xff, 0xfc, 0xff, 0x46, 0x66, 0x66,
    0x3f, 0xff, 0xff, 0xf4, 0x0, 0x34, 0x44, 0x43,
    0x0, 0x0,

    /* U+F0C7 "" */
    0x2, 0x22, 0x22, 0x0, 0xe, 0xff, 0xff, 0xfe,
    0x20, 0xf5, 0x22, 0x22, 0xfe, 0x1f, 0x40, 0x0,
    0xe, 0xf8, 0xf7, 0x44, 0x44, 0xff, 0x9f, 0xff,
    0xff, 0xff, 0xf9, 0xff, 0xf6, 0xc, 0xff, 0x9f,
    0xff, 0x20, 0x9f, 0xf9, 0xff, 0xfc, 0x7f, 0xff,
    0x9a, 0xdd, 0xdd, 0xdd, 0xd4,

    /* U+F0E7 "" */
    0x3, 0xaa, 0xa2, 0x0, 0x7, 0xff, 0xf2, 0x0,
    0x9, 0xff, 0xd0, 0x0, 0xb, 0xff, 0xd8, 0x81,
    0xe, 0xff, 0xff, 0xe1, 0xe, 0xff, 0xff, 0x60,
    0x0, 0x5, 0xfd, 0x0, 0x0, 0x9, 0xf4, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0x2, 0x0, 0x0,

    /* U+F0EA "" */
    0x1, 0x79, 0x11, 0x0, 0xf, 0xfc, 0x9f, 0xf4,
    0x0, 0xff, 0xfd, 0xcc, 0x30, 0xf, 0xfa, 0x79,
    0x93, 0x40, 0xff, 0x8e, 0xff, 0x6f, 0x5f, 0xf8,
    0xef, 0xf7, 0x64, 0xff, 0x8e, 0xff, 0xff, 0xcf,
    0xf8, 0xef, 0xff, 0xfc, 0x46, 0x3e, 0xff, 0xff,
    0xc0, 0x0, 0xdf, 0xff, 0xfc, 0x0, 0x2, 0x44,
    0x44, 0x20,

    /* U+F0F3 "" */
    0x0, 0x1, 0x90, 0x0, 0x0, 0x2, 0xaf, 0x81,
    0x0, 0x2, 0xff, 0xff, 0xd0, 0x0, 0x9f, 0xff,
    0xff, 0x50, 0xc, 0xff, 0xff, 0xf8, 0x0, 0xef,
    0xff, 0xff, 0xa0, 0x3f, 0xff, 0xff, 0xfe, 0xd,
    0xff, 0xff, 0xff, 0xf9, 0x46, 0x66, 0x66, 0x66,
    0x20, 0x0, 0xbf, 0x70, 0x0, 0x0, 0x0, 0x30,
    0x0, 0x0,

    /* U+F11C "" */
    0x24, 0x44, 0x44, 0x44, 0x44, 0x30, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xf4, 0xa0, 0xa0, 0xb0,
    0xb0, 0xf4, 0xff, 0xbe, 0xae, 0xae, 0xaf, 0xf4,
    0xff, 0x3a, 0xa, 0xa, 0xf, 0xf4, 0xfb, 0xea,
    0xaa, 0xaa, 0xea, 0xf4, 0xf7, 0xb4, 0x44, 0x44,
    0xc4, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe1,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x29, 0x70, 0x0, 0x0,
    0x0, 0x3a, 0xff, 0xe0, 0x0, 0x0, 0x4b, 0xff,
    0xff, 0x70, 0x0, 0x5d, 0xff, 0xff, 0xff, 0x10,
    0xc, 0xff, 0xff, 0xff, 0xf9, 0x0, 0xa, 0xee,
    0xef, 0xff, 0xf2, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x30, 0x0,
    0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x0,

    /* U+F15B "" */
    0xef, 0xff, 0x5b, 0x0, 0xff, 0xff, 0x6f, 0xb0,
    0xff, 0xff, 0x68, 0x83, 0xff, 0xff, 0xfd, 0xd6,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0,

    /* U+F1EB "" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x5,
    0xbf, 0xff, 0xfd, 0x81, 0x0, 0x2c, 0xfe, 0xa8,
    0x78, 0xcf, 0xf7, 0xd, 0xf7, 0x0, 0x0, 0x0,
    0x3c, 0xf5, 0x22, 0x5, 0xbe, 0xfd, 0x81, 0x5,
    0x0, 0x9, 0xfe, 0xa9, 0xcf, 0xe2, 0x0, 0x0,
    0x37, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x0,
    0x8c, 0x20, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x10, 0x0,
    0x0,

    /* U+F240 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xf, 0x75,
    0x55, 0x55, 0x55, 0x5a, 0xf2, 0xf6, 0xff, 0xff,
    0xff, 0xfd, 0x4f, 0x5f, 0x6f, 0xff, 0xff, 0xff,
    0xd1, 0xf5, 0xf5, 0x77, 0x77, 0x77, 0x76, 0x8f,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0,

    /* U+F241 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xf, 0x75,
    0x55, 0x55, 0x54, 0x4a, 0xf2, 0xf6, 0xff, 0xff,
    0xff, 0x0, 0x4f, 0x5f, 0x6f, 0xff, 0xff, 0xf0,
    0x1, 0xf5, 0xf5, 0x77, 0x77, 0x77, 0x0, 0x8f,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0,

    /* U+F242 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xf, 0x75,
    0x55, 0x54, 0x44, 0x4a, 0xf2, 0xf6, 0xff, 0xff,
    0x20, 0x0, 0x4f, 0x5f, 0x6f, 0xff, 0xf2, 0x0,
    0x1, 0xf5, 0xf5, 0x77, 0x77, 0x10, 0x0, 0x8f,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0,

    /* U+F243 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xf, 0x75,
    0x54, 0x44, 0x44, 0x4a, 0xf2, 0xf6, 0xff, 0x50,
    0x0, 0x0, 0x4f, 0x5f, 0x6f, 0xf5, 0x0, 0x0,
    0x1, 0xf5, 0xf5, 0x77, 0x20, 0x0, 0x0, 0x8f,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0,

    /* U+F244 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xf, 0x74,
    0x44, 0x44, 0x44, 0x4a, 0xf2, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x5f, 0x40, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x5b, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xbd, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa1,
    0x3, 0x0, 0x0, 0xa, 0xf7, 0x39, 0x0, 0x0,
    0x7, 0x60, 0xff, 0xea, 0xbf, 0xaa, 0xaa, 0xdf,
    0x45, 0xa3, 0x0, 0x93, 0x0, 0x4, 0x10, 0x0,
    0x0, 0x1, 0xb8, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x6b, 0xca, 0x40, 0x0, 0x9f, 0xf6, 0xff,
    0x40, 0x1f, 0xff, 0x26, 0xfb, 0x4, 0xf6, 0xb4,
    0x6b, 0xf0, 0x6f, 0xf4, 0x6, 0xff, 0x6, 0xff,
    0x90, 0xbf, 0xf0, 0x5f, 0x95, 0x34, 0xcf, 0x2,
    0xfb, 0xf3, 0x4d, 0xc0, 0xc, 0xff, 0x3d, 0xf7,
    0x0, 0x1b, 0xfe, 0xf9, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0,

    /* U+F2ED "" */
    0x12, 0x3b, 0xca, 0x22, 0x1f, 0xff, 0xff, 0xff,
    0xfb, 0x36, 0x66, 0x66, 0x66, 0x16, 0xff, 0xff,
    0xff, 0xf2, 0x6f, 0x6f, 0x6f, 0x7f, 0x26, 0xf6,
    0xf6, 0xf7, 0xf2, 0x6f, 0x6f, 0x6f, 0x7f, 0x26,
    0xf6, 0xf6, 0xf7, 0xf2, 0x6f, 0x6f, 0x6f, 0x7f,
    0x24, 0xff, 0xff, 0xff, 0xf1, 0x3, 0x44, 0x44,
    0x42, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x97, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf8, 0x0, 0x0, 0x0, 0xa5, 0xef,
    0xe0, 0x0, 0x0, 0xbf, 0xe5, 0xd4, 0x0, 0x0,
    0xbf, 0xff, 0xe0, 0x0, 0x0, 0xbf, 0xff, 0xf4,
    0x0, 0x0, 0xbf, 0xff, 0xf4, 0x0, 0x0, 0xaf,
    0xff, 0xf4, 0x0, 0x0, 0xd, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x2,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x5, 0x88, 0x88, 0x88, 0x86, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x8, 0xff, 0xf9,
    0x6f, 0x69, 0xff, 0x88, 0xff, 0xff, 0xc1, 0x21,
    0xcf, 0xf8, 0xdf, 0xff, 0xff, 0x50, 0x5f, 0xff,
    0x82, 0xef, 0xff, 0x71, 0x91, 0x7f, 0xf8, 0x2,
    0xef, 0xfe, 0xdf, 0xde, 0xff, 0x70, 0x2, 0xdf,
    0xff, 0xff, 0xff, 0xe3,

    /* U+F7C2 "" */
    0x1, 0xdf, 0xff, 0xe5, 0x1d, 0x6c, 0x5a, 0xab,
    0xdf, 0x3b, 0x18, 0x8b, 0xff, 0xdf, 0xde, 0xeb,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xfb, 0xbf, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x8, 0x10,
    0x0, 0x7, 0xf0, 0xb, 0xf2, 0x0, 0x0, 0x8f,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xfa,
    0x99, 0x99, 0x99, 0x0, 0x6f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 40, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 41, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8, .adv_w = 51, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 13, .adv_w = 99, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41, .adv_w = 90, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 74, .adv_w = 117, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 102, .adv_w = 99, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 130, .adv_w = 28, .box_w = 2, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 133, .adv_w = 55, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 157, .adv_w = 56, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 175, .adv_w = 69, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 188, .adv_w = 91, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 206, .adv_w = 31, .box_w = 2, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 209, .adv_w = 44, .box_w = 3, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 211, .adv_w = 42, .box_w = 2, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 213, .adv_w = 66, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 231, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 255, .adv_w = 90, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 271, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 295, .adv_w = 90, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 315, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 339, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 363, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 387, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 411, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 435, .adv_w = 90, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 455, .adv_w = 39, .box_w = 2, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 461, .adv_w = 34, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 469, .adv_w = 81, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 482, .adv_w = 88, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 490, .adv_w = 84, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 503, .adv_w = 76, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 523, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 568, .adv_w = 104, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 596, .adv_w = 100, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 620, .adv_w = 104, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 648, .adv_w = 105, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 672, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 696, .adv_w = 88, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 720, .adv_w = 109, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 748, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 776, .adv_w = 44, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 784, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 804, .adv_w = 100, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 832, .adv_w = 86, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 856, .adv_w = 140, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 888, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 916, .adv_w = 110, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 944, .adv_w = 101, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 968, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1003, .adv_w = 99, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1027, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1051, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1075, .adv_w = 104, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1099, .adv_w = 102, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1127, .adv_w = 142, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1163, .adv_w = 100, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1187, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1211, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1235, .adv_w = 42, .box_w = 3, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1252, .adv_w = 66, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1275, .adv_w = 42, .box_w = 2, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1286, .adv_w = 67, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 1294, .adv_w = 72, .box_w = 5, .box_h = 1, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1297, .adv_w = 49, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 1300, .adv_w = 87, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1315, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1339, .adv_w = 84, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1354, .adv_w = 90, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1374, .adv_w = 85, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1389, .adv_w = 56, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1407, .adv_w = 90, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1427, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1447, .adv_w = 39, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1455, .adv_w = 38, .box_w = 3, .box_h = 10, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 1470, .adv_w = 81, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1494, .adv_w = 39, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1502, .adv_w = 140, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1529, .adv_w = 88, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1544, .adv_w = 91, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1562, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1586, .adv_w = 91, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1606, .adv_w = 54, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1620, .adv_w = 83, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1635, .adv_w = 52, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1647, .adv_w = 88, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1662, .adv_w = 78, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1677, .adv_w = 120, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1701, .adv_w = 79, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1716, .adv_w = 76, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1736, .adv_w = 79, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1751, .adv_w = 54, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1773, .adv_w = 39, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1783, .adv_w = 54, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1805, .adv_w = 109, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1812, .adv_w = 40, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1812, .adv_w = 39, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1820, .adv_w = 88, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1843, .adv_w = 93, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1867, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1899, .adv_w = 84, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1923, .adv_w = 38, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1933, .adv_w = 98, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1966, .adv_w = 67, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 1970, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2006, .adv_w = 71, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2014, .adv_w = 75, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2027, .adv_w = 89, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2035, .adv_w = 44, .box_w = 3, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2037, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2073, .adv_w = 73, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 2075, .adv_w = 60, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 2081, .adv_w = 85, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2099, .adv_w = 59, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2107, .adv_w = 59, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2115, .adv_w = 50, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 2118, .adv_w = 91, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2138, .adv_w = 78, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2158, .adv_w = 42, .box_w = 2, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2161, .adv_w = 40, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2166, .adv_w = 59, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2172, .adv_w = 73, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2180, .adv_w = 75, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 2193, .adv_w = 117, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2221, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2257, .adv_w = 124, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2289, .adv_w = 76, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2309, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2344, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2379, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2414, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2449, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2484, .adv_w = 104, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2523, .adv_w = 150, .box_w = 11, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2567, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2602, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2632, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2662, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2692, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2722, .adv_w = 44, .box_w = 3, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2737, .adv_w = 44, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2752, .adv_w = 44, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2772, .adv_w = 44, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2792, .adv_w = 107, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2820, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2855, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2890, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2925, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2960, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2995, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3030, .adv_w = 85, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 3045, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3077, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3107, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3137, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3167, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3197, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3227, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3251, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3275, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3295, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3315, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3335, .adv_w = 87, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3358, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3378, .adv_w = 87, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3401, .adv_w = 135, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3428, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3448, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3468, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3488, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3508, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3528, .adv_w = 40, .box_w = 3, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3540, .adv_w = 40, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3552, .adv_w = 40, .box_w = 4, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3568, .adv_w = 40, .box_w = 4, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3584, .adv_w = 94, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3614, .adv_w = 88, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3637, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3661, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3685, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3709, .adv_w = 91, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3736, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3760, .adv_w = 91, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3778, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3802, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3822, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3842, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3862, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3882, .adv_w = 76, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3907, .adv_w = 92, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3937, .adv_w = 76, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3962, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3997, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4017, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4052, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4072, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4107, .adv_w = 87, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4127, .adv_w = 104, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4166, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4186, .adv_w = 104, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4225, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4245, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4280, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4300, .adv_w = 104, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4339, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4359, .adv_w = 105, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4389, .adv_w = 102, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4417, .adv_w = 107, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4445, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4469, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4499, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4519, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4549, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4569, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4599, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4619, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4649, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4669, .adv_w = 91, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4699, .adv_w = 85, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4719, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4758, .adv_w = 90, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4783, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4818, .adv_w = 90, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4843, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4878, .adv_w = 90, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4903, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4942, .adv_w = 90, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4972, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5007, .adv_w = 88, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5032, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5060, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5084, .adv_w = 44, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5109, .adv_w = 40, .box_w = 4, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5127, .adv_w = 44, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5152, .adv_w = 40, .box_w = 4, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5168, .adv_w = 44, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5188, .adv_w = 40, .box_w = 4, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5204, .adv_w = 44, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5214, .adv_w = 39, .box_w = 3, .box_h = 10, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 5229, .adv_w = 44, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5239, .adv_w = 40, .box_w = 2, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5245, .adv_w = 132, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5277, .adv_w = 77, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5302, .adv_w = 88, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5332, .adv_w = 40, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 5352, .adv_w = 100, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5391, .adv_w = 81, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5424, .adv_w = 89, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5442, .adv_w = 86, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5472, .adv_w = 39, .box_w = 3, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5489, .adv_w = 86, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5522, .adv_w = 39, .box_w = 2, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5533, .adv_w = 86, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5557, .adv_w = 51, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5573, .adv_w = 86, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5597, .adv_w = 56, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5613, .adv_w = 86, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5637, .adv_w = 43, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5649, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5684, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5704, .adv_w = 114, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5743, .adv_w = 88, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5766, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5801, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5821, .adv_w = 88, .box_w = 6, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5845, .adv_w = 111, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5880, .adv_w = 91, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5900, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5935, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5959, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5994, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6018, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6053, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6077, .adv_w = 153, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6113, .adv_w = 145, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6140, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6170, .adv_w = 54, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6186, .adv_w = 99, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6219, .adv_w = 54, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6239, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6269, .adv_w = 54, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6285, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6315, .adv_w = 83, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6335, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6365, .adv_w = 83, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6385, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6415, .adv_w = 83, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6435, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6465, .adv_w = 83, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6485, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6515, .adv_w = 52, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6535, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6565, .adv_w = 55, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6583, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6607, .adv_w = 52, .box_w = 5, .box_h = 8, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6627, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6657, .adv_w = 88, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6680, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6710, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6730, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6760, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6780, .adv_w = 104, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6813, .adv_w = 88, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6836, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6866, .adv_w = 88, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6890, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6920, .adv_w = 88, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6940, .adv_w = 142, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6985, .adv_w = 120, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7017, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7047, .adv_w = 76, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7072, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7102, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7132, .adv_w = 79, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7152, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7182, .adv_w = 79, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7202, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7232, .adv_w = 79, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7252, .adv_w = 40, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7270, .adv_w = 160, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7331, .adv_w = 160, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7371, .adv_w = 160, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7421, .adv_w = 160, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7461, .adv_w = 110, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7489, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7544, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7599, .adv_w = 180, .box_w = 12, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7659, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7714, .adv_w = 180, .box_w = 12, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7762, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7817, .adv_w = 80, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7837, .adv_w = 120, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7869, .adv_w = 180, .box_w = 12, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7929, .adv_w = 160, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7969, .adv_w = 140, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8004, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8054, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8099, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8144, .adv_w = 140, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8179, .adv_w = 140, .box_w = 10, .box_h = 10, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 8229, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8259, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8289, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8334, .adv_w = 140, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 8348, .adv_w = 180, .box_w = 12, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8396, .adv_w = 200, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8468, .adv_w = 180, .box_w = 13, .box_h = 11, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 8540, .adv_w = 160, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8590, .adv_w = 140, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8617, .adv_w = 140, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8644, .adv_w = 200, .box_w = 13, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8696, .adv_w = 160, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8736, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8791, .adv_w = 160, .box_w = 11, .box_h = 11, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 8852, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8897, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8947, .adv_w = 140, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8992, .adv_w = 100, .box_w = 8, .box_h = 11, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 9036, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9086, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9136, .adv_w = 180, .box_w = 12, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9184, .adv_w = 160, .box_w = 12, .box_h = 11, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 9250, .adv_w = 120, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9294, .adv_w = 200, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9359, .adv_w = 200, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9405, .adv_w = 200, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9451, .adv_w = 200, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9497, .adv_w = 200, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9543, .adv_w = 200, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9589, .adv_w = 200, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9648, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9698, .adv_w = 140, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9748, .adv_w = 160, .box_w = 11, .box_h = 11, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 9809, .adv_w = 200, .box_w = 13, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9861, .adv_w = 120, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9905, .adv_w = 161, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 320,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 0, 8,
    10, 10, 10, 10, 12, 12, 12, 12,
    9, 12, 9, 9, 9, 9, 9, 0,
    0, 13, 13, 13, 13, 23, 0, 0,
    26, 26, 26, 26, 26, 26, 0, 28,
    29, 29, 29, 29, 0, 0, 0, 0,
    0, 31, 33, 33, 33, 33, 33, 0,
    0, 0, 0, 0, 0, 36, 27, 36,
    6, 26, 6, 26, 6, 26, 8, 28,
    8, 28, 8, 28, 8, 28, 9, 0,
    9, 0, 10, 29, 10, 29, 10, 29,
    10, 29, 10, 29, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 31, 0, 0,
    12, 0, 12, 0, 12, 0, 12, 0,
    12, 0, 0, 0, 13, 0, 14, 0,
    0, 15, 0, 15, 0, 15, 0, 15,
    0, 0, 0, 12, 31, 12, 31, 12,
    31, 31, 0, 0, 9, 33, 9, 33,
    9, 33, 0, 0, 0, 34, 0, 34,
    0, 34, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 0, 19, 0, 19, 0,
    13, 0, 13, 0, 13, 0, 13, 0,
    13, 0, 13, 0, 21, 0, 23, 36,
    23, 24, 39, 24, 39, 24, 39, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 36, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 37, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 38, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 0,
    11, 15, 15, 15, 15, 19, 0, 0,
    22, 22, 22, 22, 22, 22, 39, 23,
    23, 23, 23, 23, 0, 0, 0, 0,
    0, 25, 26, 26, 26, 26, 26, 0,
    40, 30, 30, 30, 30, 31, 0, 31,
    10, 22, 10, 22, 10, 22, 11, 23,
    11, 23, 11, 23, 11, 23, 0, 23,
    0, 0, 0, 23, 0, 23, 0, 23,
    0, 23, 0, 23, 11, 23, 11, 23,
    11, 23, 11, 23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 25, 0,
    25, 25, 0, 0, 11, 26, 11, 26,
    11, 26, 11, 23, 0, 0, 0, 0,
    0, 0, 13, 28, 13, 28, 13, 28,
    13, 28, 14, 0, 14, 0, 0, 0,
    15, 30, 15, 30, 15, 30, 15, 30,
    15, 30, 15, 30, 17, 0, 19, 31,
    19, 20, 34, 20, 34, 20, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, -9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -5, 0,
    -2, -5, 0, -6, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    1, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, 0, 0, 0, 0, 0, 0,
    -5, 0, -1, 0, 0, -10, -1, -7,
    -5, 0, -7, 0, 0, 0, 0, 0,
    0, -1, 0, 0, -1, -1, -4, -3,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, -2,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -2, 0, 0, 0, -2, 0, -2,
    0, -2, -3, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, -1, -1,
    0, -1, 0, 0, 0, -1, -2, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -18, 0, 0,
    0, -13, 0, -21, 0, 2, 0, 0,
    0, 0, 0, 0, 0, -3, -2, 0,
    0, -2, -2, 0, 0, -2, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -2, 0, 0,
    0, 1, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -2, -2, 0, 0, 0, -2, -3, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -26, 0, 0, 0, 0, 0, 0,
    0, 1, -5, 0, 0, -21, -4, -14,
    -11, 0, -19, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -10, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -25, 0, 0,
    0, -11, 0, -16, 0, 0, 0, 0,
    0, -2, 0, -2, 0, -1, -1, 0,
    0, -1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -2,
    -2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -1,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, -17, -18, 0,
    0, -6, -2, -19, -1, 1, 0, 1,
    1, 0, 1, 0, 0, -9, -8, 0,
    -9, -8, -6, -9, 0, -7, -6, -4,
    -6, -5, 0, -26, -17, -14, -9, -7,
    0, 0, 0, 2, 0, -18, -3, 0,
    0, -6, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, -4, -3, 0,
    0, -4, -2, 0, 0, -2, -1, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, -10, -5, 0,
    0, -3, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 1, -3, -2, 0,
    0, -2, -2, 0, 0, -1, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, -2, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -2, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 2, -4, -16, -4, 0,
    0, -7, -2, -7, -1, 1, -7, 1,
    1, 1, 1, 0, 1, -6, -5, -2,
    -3, -5, -3, -5, -2, -3, -2, 0,
    -2, -2, 1, -6, -4, -7, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, -1, -2, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -1, -1, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -1, 1,
    0, -2, 0, 0, 4, 0, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, 1,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 40,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_10 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 14,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_10*/


