#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "lvgl/lvgl.h"
#include "lv_conf.h"
#include "millis.h"


#define TICK_DEF 10
#define TICKER_TIME 0.001 * TICK_DEF

Ticker ticker;                                             //Initialize your system tick
LCD_DISCO_F746NG lcd;                      //Initialize your display driver
TS_DISCO_F746NG ts;                          //Initialize your touchpad driver
TS_StateTypeDef TS_State;                   //Initialize your touch state sctruct

int X;
int Y;
char text[30];

void initialisation();

/*********************
 *  STATIC PROTOTYPES
 *********************/
static void entete_create(void);
static void sb_create(void);
static void content_create(void);
static void theme_select_event_handler(lv_obj_t * roller, lv_event_t event);
static void hue_select_event_cb(lv_obj_t * roller, lv_event_t event);
static void init_all_themes(uint16_t hue);
static void bar_set_value(lv_obj_t * bar, int16_t value);
/*********************
 *  STATIC VARIABLES
 *********************/
static lv_obj_t * enteteOBJ;
static lv_obj_t * entete;
static lv_obj_t * sb;
static lv_obj_t * content;
static lv_theme_t * th_act;
static lv_obj_t * BPMESURE;
static lv_obj_t * BPPARA;
static lv_obj_t * BPMENU3;
static lv_obj_t * BPMENU4;
static lv_obj_t * BPMENU5;
static lv_obj_t * BPMENU6;
static lv_obj_t * AffMillis;
static lv_obj_t * label;
static lv_obj_t * label1;



LV_FONT_DECLARE(arial_20)        //Declare a font

void lv_ticker_func();
void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p);
bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data);
static void event_handler(lv_obj_t * obj, lv_event_t event);
//void btn_event_cb(lv_obj_t * btn, lv_event_t event);


static void BPMESURE_ACT(lv_obj_t * btn, lv_event_t event);
static void BPPARA_ACT(lv_obj_t * btn, lv_event_t event);
static void BPMENU3_ACT(lv_obj_t * btn, lv_event_t event);
static void BPMENU4_ACT(lv_obj_t * btn, lv_event_t event);
static void BPMENU5_ACT(lv_obj_t * btn, lv_event_t event);
static void BPMENU6_ACT(lv_obj_t * btn, lv_event_t event);
static void ddlist_event_cb(lv_obj_t * ddlist, lv_event_t event);
static lv_obj_t * slider;

int PosX_MenuDepart = 0;
int PosX_MenuCible = 0;
bool DdeAlignMenu = 0;

static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event);
static void Reglage_G_RGB(lv_obj_t * obj, lv_event_t event);
static void Reglage_B_RGB(lv_obj_t * obj, lv_event_t event);

static void AFF_PAGE_REGL_COLOR(void);


int TestAff = 0;

static void Affect_Couleur(void);
static lv_style_t btn_rel, btn_pr, btn_tgl_rel, btn_tgl_pr, btn_ina,Style_page,Style_texte;
static lv_style_t * Style_EC;

static lv_obj_t * btn_relache;
static lv_obj_t * btn_presse;
static lv_obj_t * btn_tgl_presse;
static lv_obj_t * btn_inactif;



static void PAGE1_FCT(void);
static lv_obj_t * PAGE_REGL_COLOR;
static void PAGE_REGL_COLOR_FCT();
static lv_obj_t  * Val_R;
static lv_obj_t  * Val_G;
static lv_obj_t  * Val_B;
static lv_obj_t  * R;
static lv_obj_t  * G;
static lv_obj_t  * B;
static lv_obj_t  * btn_close;



uint8_t Reglage_R;
uint8_t Reglage_G;
uint8_t Reglage_B;
uint32_t Reglage_RGB;

static lv_obj_t * Reglage1;
static lv_obj_t * Reglage2;
static lv_obj_t * Reglage3;
static lv_obj_t * Reglage4;
static lv_obj_t * Reglage5;
static lv_obj_t * Reglage6;
static lv_obj_t * Reglage7;
static lv_obj_t * Reglage8;
static lv_obj_t * Reglage9;
static lv_obj_t * Reglage10;
static lv_obj_t * Reglage11;
static lv_obj_t * Reglage12;
static lv_obj_t * Reglage13;
static lv_obj_t * Reglage14;
static lv_obj_t * Reglage15;
static lv_obj_t * Reglage16;
static lv_obj_t * Reglage17;
static lv_obj_t * Reglage18;
static lv_obj_t * Reglage19;
static void Reglage1_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage2_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage3_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage4_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage5_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage6_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage7_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage8_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage9_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage10_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage11_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage12_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage13_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage14_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage15_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage16_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage17_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage18_ACT(lv_obj_t * CB, lv_event_t event);
static void Reglage19_ACT(lv_obj_t * CB, lv_event_t event);

uint8_t R1=210,G1=255,B1=255,
        R2=0 ,G2=0 ,B2=0,
        R3=114 ,G3=179 ,B3=244,
        R4=255,G4=255,B4=240,
        R5=0,G5=145,B5=145,
        R6=0,G6=0,B6=0,
        R7=255,G7=255,B7=240,
        R8=114 ,G8=179 ,B8=244,
        R9=0,G9=145,B9=145,
        R10=155,G10=238,B10=131,
        R11=145,G11=145,B11=145,
        R12=51,G12=37,B12=22,
        R13=255,G13=255,B13=255,
        R14=153,G14=158,B14=117,
        R15=107,G15=154,B15=199,
        R16=107,G16=154,B16=199,
        R17=107,G17=154,B17=199,
        R18=107,G18=154,B18=199,
        R19=107,G19=154,B19=199;
      
   
int NumCouleur=0;

static void ClosePage(lv_obj_t * btn, lv_event_t event);
lv_obj_t * th_roller ;



static const char * th_options = {
#if LV_USE_THEME_DEFAULT
    "Default"
#endif

#if LV_USE_THEME_NIGHT
    "\nNight"
#endif

#if LV_USE_THEME_MATERIAL
    "\nMaterial"
#endif

#if LV_USE_THEME_ALIEN
    "\nAlien"
#endif

#if LV_USE_THEME_ZEN
    "\nZen"
#endif

#if LV_USE_THEME_NEMO
    "\nNemo"
#endif

#if LV_USE_THEME_MONO
    "\nMono"
#endif


    ""
};

static lv_theme_t * themes[8];



int main()
{
    printf("Example of MbedOS5 with LittlevGL on Disco F746NI \n");
    //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"LittlevGL DEMO", CENTER_MODE);
    ticker.attach(&lv_ticker_func,TICKER_TIME);
    wait(0.5);
    lv_init();                                  //Initialize the LittlevGL

    static lv_disp_buf_t disp_buf;
    static lv_color_t buf[LV_HOR_RES_MAX * 10]; //Declare a buffer for 10 lines
    lv_disp_buf_init(&disp_buf, buf, NULL, LV_HOR_RES_MAX * 10); //Initialize the display buffer

    //Implement and register a function which can copy a pixel array to an area of your display
    lv_disp_drv_t disp_drv;               //Descriptor of a display driver
    lv_disp_drv_init(&disp_drv);          //Basic initialization
    disp_drv.flush_cb = my_disp_flush;    //Set your driver function
    disp_drv.buffer = &disp_buf;          //Assign the buffer to the display
    lv_disp_drv_register(&disp_drv);      //Finally register the driver

    //Implement and register a function which can read an input device. E.g. for a touch pad
    ts.Init(lcd.GetXSize(), lcd.GetYSize());   //ST touch initialization
    lv_indev_drv_t indev_drv;                  //Descriptor of a input device driver
    lv_indev_drv_init(&indev_drv);             //Basic initialization
    indev_drv.type = LV_INDEV_TYPE_POINTER;    //Touch pad is a pointer-like device
    indev_drv.read_cb = my_touchpad_read;      //Set your driver function
    lv_indev_drv_register(&indev_drv);         //Finally register the driver




    initialisation();
    entete_create();
 //   sb_create();
    content_create();
  //  PAGE1_FCT();
    PAGE_REGL_COLOR_FCT();
    
    
        lv_roller_set_selected(th_roller,0,0);
        th_act = themes[0];
        lv_theme_set_current(th_act);
         th_act = themes[0];
    lv_theme_set_current(th_act);



//     lv_style_copy(&btn_rel, &lv_style_plain);
//    lv_style_copy(&btn_pr, &lv_style_plain);
//    lv_style_copy(&btn_tgl_rel, &lv_style_plain);
//    lv_style_copy(&btn_tgl_pr, &lv_style_plain);
//    lv_style_copy(&btn_ina, &lv_style_plain);

    while(1) {
        lv_task_handler(); //Call lv_task_handler() periodically every few milliseconds. It will redraw the screen if required, handle input devices etc.

        //     TestAff=millis();
        //  sprintf(text, " %d ", millis());
     //   sprintf(text, " %d ", TestAff);

     //   lv_label_set_text(AffMillis, text);
        //  lv_label_set_text(AffMillis, "123");



        if (DdeAlignMenu) {
            if (PosX_MenuDepart>PosX_MenuCible) {
                PosX_MenuDepart=PosX_MenuDepart-1;
                lv_obj_set_pos(entete, PosX_MenuDepart, 0);
            }
            if (PosX_MenuDepart<PosX_MenuCible) {
                PosX_MenuDepart=PosX_MenuDepart+1;
                lv_obj_set_pos(entete, PosX_MenuDepart, 0);
            }
            if (PosX_MenuDepart==PosX_MenuCible) {
                DdeAlignMenu=0;
            }

        }

        // lv_label_set_text(label11, text);  //Set the text
        wait_ms(1);
    }
}






void initialisation(void)
{
    // By doing this, we hide the first (empty) option.
    if(th_options[0] == '\n') {
        th_options++;
    }

    init_all_themes(0);
    th_act = themes[0];
    lv_theme_set_current(th_act);

    lv_obj_t * scr = lv_obj_create(NULL, NULL);
    lv_disp_load_scr(scr);
}



static void entete_create(void)
{
    entete = lv_cont_create(lv_disp_get_scr_act(NULL), NULL);

    lv_obj_set_size(entete,900,40);

    lv_cont_set_fit2(entete,LV_FIT_TIGHT, LV_FIT_NONE);
    lv_obj_set_pos(entete, 50, 0);
    lv_obj_set_drag_dir(entete, LV_DRAG_DIR_HOR);

    lv_obj_t * sym = lv_label_create(entete, NULL);
    lv_label_set_text(sym, LV_SYMBOL_GPS LV_SYMBOL_WIFI LV_SYMBOL_BLUETOOTH LV_SYMBOL_VOLUME_MAX);
    lv_obj_align(sym, NULL, LV_ALIGN_IN_RIGHT_MID, -LV_DPI/10, 0);

    //BP MESURE
    BPMESURE = lv_btn_create(entete, NULL);
    lv_btn_set_ink_in_time(BPMESURE, 200);
    lv_btn_set_ink_wait_time(BPMESURE, 100);
    lv_btn_set_ink_out_time(BPMESURE, 500);
    lv_obj_t * label = lv_label_create(BPMESURE, NULL);
    lv_label_set_text(label, "Mesures");
    lv_obj_set_size(BPMESURE,100,40);
    lv_obj_set_drag_parent(BPMESURE, true);
    lv_obj_set_event_cb(BPMESURE, BPMESURE_ACT);

    //BP PARAMETRES
    BPPARA = lv_btn_create(entete, NULL);
    lv_btn_set_ink_in_time(BPPARA, 200);
    lv_btn_set_ink_wait_time(BPPARA, 100);
    lv_btn_set_ink_out_time(BPPARA, 500);
    label = lv_label_create(BPPARA, NULL);
    lv_label_set_text(label, "Parametres");
    lv_obj_set_size(BPPARA,100,40);
    lv_btn_set_toggle(BPPARA, true);
    lv_btn_toggle(BPPARA);

    //  lv_obj_set_drag(BPPARA, true);
    lv_obj_align(BPPARA, BPMESURE, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(BPPARA, true);
    lv_obj_set_event_cb(BPPARA, BPPARA_ACT);

    //BP MENU3
    BPMENU3 = lv_btn_create(entete, NULL);
    label = lv_label_create(BPMENU3, NULL);
    lv_label_set_text(label, "BPMENU3");
    lv_obj_set_size(BPMENU3,100,40);
    lv_obj_align(BPMENU3, BPPARA, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(BPMENU3, true);
    lv_obj_set_event_cb(BPMENU3, BPMENU3_ACT);

    //BP BPMENU4
    BPMENU4 = lv_btn_create(entete, NULL);
    label = lv_label_create(BPMENU4, NULL);
    lv_label_set_text(label, "BPMENU4");
    lv_obj_set_size(BPMENU4,100,40);
    lv_obj_align(BPMENU4, BPMENU3, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(BPMENU4, true);
    lv_obj_set_event_cb(BPMENU4, BPMENU4_ACT);

    //BP BPMENU5
    BPMENU5 = lv_btn_create(entete, NULL);
    label = lv_label_create(BPMENU5, NULL);
    lv_label_set_text(label, "BPMENU5");
    lv_obj_set_size(BPMENU5,100,40);
    lv_obj_align(BPMENU5, BPMENU4, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(BPMENU5, true);
    lv_obj_set_event_cb(BPMENU5, BPMENU5_ACT);

    //BP BPMENU6
    BPMENU6 = lv_btn_create(entete, NULL);
    label = lv_label_create(BPMENU6, NULL);
    lv_label_set_text(label, "BPMENU6");
    lv_obj_set_size(BPMENU6,100,40);
    lv_obj_align(BPMENU6, BPMENU5, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(BPMENU6, true);
    lv_obj_set_event_cb(BPMENU6, BPMENU6_ACT);

}

 static void Reglage1_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(Style_page.body.main_color);        
        NumCouleur=1;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage2_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(Style_page.text.color);        
        NumCouleur=2;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage3_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.main_color);        
        NumCouleur=3;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage4_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.grad_color);        
        NumCouleur=4;
        AFF_PAGE_REGL_COLOR();
    }
}

static void Reglage5_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=5;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage6_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.text.color);        
        NumCouleur=6;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage7_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_pr.body.main_color);        
        NumCouleur=7;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage8_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_pr.body.grad_color);        
        NumCouleur=8;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage9_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_pr.body.border.color);        
        NumCouleur=9;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage10_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_pr.text.color );        
        NumCouleur=10;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage11_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_ina.body.main_color);        
        NumCouleur=11;
        AFF_PAGE_REGL_COLOR();
    }
}

static void Reglage12_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_ina.body.grad_color);        
        NumCouleur=12;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage13_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_ina.body.border.color);        
        NumCouleur=13;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage14_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32( btn_ina.text.color);        
        NumCouleur=14;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage15_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=15;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage16_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=16;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage17_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=17;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage18_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=18;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Reglage19_ACT(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        Reglage_RGB=lv_color_to32(btn_rel.body.border.color);        
        NumCouleur=19;
        AFF_PAGE_REGL_COLOR();
    }
}
static void Affect_Couleur(void)
{
    //  btn_rel.body.main_color     = lv_color_hsv_to_rgb(Reglage_R, Reglage_G, Reglage_B);
    //  lv_obj_refresh_style(btn_relache);
    //  lv_obj_report_style_mod(&btn_rel);
        //  lv_obj_set_style(btn_relache, &btn_rel);
        
    sprintf(text, "fond         1: R=%d  G=%d  B=%d",R1,G1,B1); lv_cb_set_text(Reglage1,text); 
    sprintf(text, "texte        2: R=%d  G=%d  B=%d",R2,G2,B2); lv_cb_set_text(Reglage2,text);  
    sprintf(text, "couleur      3: R=%d  G=%d  B=%d",R3,G3,B3); lv_cb_set_text(Reglage3,text); 
    sprintf(text, "degrade      4: R=%d  G=%d  B=%d",R4,G4,B4); lv_cb_set_text(Reglage4,text); 
    sprintf(text, "bord         5: R=%d  G=%d  B=%d",R5,G5,B5); lv_cb_set_text(Reglage5,text); 
    sprintf(text, "texte        6: R=%d  G=%d  B=%d",R6,G6,B6); lv_cb_set_text(Reglage6,text);      
    sprintf(text, "couleur      7: R=%d  G=%d  B=%d",R7,G7,B7); lv_cb_set_text(Reglage7,text); 
    sprintf(text, "degrade      8: R=%d  G=%d  B=%d",R8,G8,B8); lv_cb_set_text(Reglage8,text); 
    sprintf(text, "bord         9: R=%d  G=%d  B=%d",R9,G9,B9); lv_cb_set_text(Reglage9,text);  
    sprintf(text, "texte        10: R=%d  G=%d  B=%d",R10,G10,B10); lv_cb_set_text(Reglage10,text);    
    sprintf(text, "couleur      11: R=%d  G=%d  B=%d",R11,G11,B11); lv_cb_set_text(Reglage11,text);  
    sprintf(text, "degrade     12: R=%d  G=%d  B=%d",R12,G12,B12); lv_cb_set_text(Reglage12,text);  
    sprintf(text, "bord        13: R=%d  G=%d  B=%d",R13,G13,B13); lv_cb_set_text(Reglage13,text);  
    sprintf(text, "texte       14: R=%d  G=%d  B=%d",R14,G14,B14); lv_cb_set_text(Reglage14,text);    
    
    if (NumCouleur==1){ R1=Reglage_R;G1=Reglage_G;B1=Reglage_B;}
    if (NumCouleur==2){ R2=Reglage_R;G2=Reglage_G;B2=Reglage_B;}
    if (NumCouleur==3){ R3=Reglage_R;G3=Reglage_G;B3=Reglage_B;}
    if (NumCouleur==4){ R4=Reglage_R;G4=Reglage_G;B4=Reglage_B;}
    if (NumCouleur==5){ R5=Reglage_R;G5=Reglage_G;B5=Reglage_B;}
    if (NumCouleur==6){ R6=Reglage_R;G6=Reglage_G;B6=Reglage_B;}
    if (NumCouleur==7){ R7=Reglage_R;G7=Reglage_G;B7=Reglage_B;}
    if (NumCouleur==8){ R8=Reglage_R;G8=Reglage_G;B8=Reglage_B;}
    if (NumCouleur==9){ R9=Reglage_R;G9=Reglage_G;B9=Reglage_B;}
    if (NumCouleur==10){ R10=Reglage_R;G10=Reglage_G;B10=Reglage_B;}
    if (NumCouleur==11){ R11=Reglage_R;G11=Reglage_G;B11=Reglage_B;}
    if (NumCouleur==12){ R12=Reglage_R;G12=Reglage_G;B12=Reglage_B;}
    if (NumCouleur==13){ R13=Reglage_R;G13=Reglage_G;B13=Reglage_B;}
    if (NumCouleur==14){ R14=Reglage_R;G14=Reglage_G;B14=Reglage_B;}
    if (NumCouleur==15){ R15=Reglage_R;G15=Reglage_G;B15=Reglage_B;}
    if (NumCouleur==16){ R16=Reglage_R;G16=Reglage_G;B16=Reglage_B;}
    if (NumCouleur==17){ R17=Reglage_R;G17=Reglage_G;B17=Reglage_B;}
    if (NumCouleur==18){ R18=Reglage_R;G18=Reglage_G;B18=Reglage_B;}
    if (NumCouleur==19){ R19=Reglage_R;G19=Reglage_G;B19=Reglage_B;}

          
    lv_style_copy(&Style_page, &lv_style_btn_rel);  

    Style_page.body.main_color     = LV_COLOR_MAKE(R1, G1, B1); 
    Style_page.body.grad_color     = LV_COLOR_MAKE(R1, G1, B1); 
    Style_page.body.border.color     = LV_COLOR_MAKE(R1, G1, B1);
    Style_page.text.color          = LV_COLOR_MAKE(R2, G2, B2); 
    Style_page.body.opa     = 200;
     
    lv_page_set_style(content, LV_PAGE_STYLE_BG,  &Style_page);
    
 //   label1.body.main_color     = LV_COLOR_MAKE(R1, G1, B1);     
    lv_obj_set_style(label1, &Style_page);        


    lv_style_copy(&btn_rel, &lv_style_btn_rel); 
 //   btn_rel.line.width   = R7;
 //   btn_rel.line.rounded = G7;     
 //   btn_rel.body.shadow.width   = B7;
 //   btn_rel.body.shadow.color   = LV_COLOR_MAKE(R8, G8, B8);        
 //   btn_rel.body.padding.left   = R9;
 //   btn_rel.body.padding.right  = G9;
  //  btn_rel.body.padding.top    = B9;
  //  lv_style_btn_rel.body.padding.bottom = R10;
  //  lv_style_btn_rel.body.padding.inner  = G10; 
    btn_rel.body.main_color     = LV_COLOR_MAKE(R3, G3, B3);
    btn_rel.body.grad_color     = LV_COLOR_MAKE(R4, G4, B4);
    btn_rel.body.border.color   = LV_COLOR_MAKE(R5, G5, B5);
    btn_rel.text.color          = LV_COLOR_MAKE(R6, G6, B6); 


    lv_style_copy(&btn_pr, &lv_style_btn_pr);
    btn_pr.body.main_color = LV_COLOR_MAKE(R7, G7, B7);
    btn_pr.body.grad_color = LV_COLOR_MAKE(R8, G8, B8);
    btn_pr.body.border.color   = LV_COLOR_MAKE(R9, G9, B9);
    btn_pr.text.color          = LV_COLOR_MAKE(R10, G10, B10); 

    lv_style_copy(&btn_tgl_rel, &btn_rel);    

    lv_style_copy(&btn_tgl_pr, &btn_pr);

    lv_style_copy(&btn_ina, &lv_style_btn_ina);
    btn_ina.body.main_color = LV_COLOR_MAKE(R11, G11, B11);
    btn_ina.body.grad_color = LV_COLOR_MAKE(R12, G12, B12);
    btn_ina.body.border.color = LV_COLOR_MAKE(R13, G13, B13);
    btn_ina.text.color          = LV_COLOR_MAKE(R14, G14, B14); 


    lv_obj_set_style(btn_relache, &btn_rel);
    lv_obj_set_style(btn_presse, &btn_pr);
    lv_obj_set_style(btn_tgl_presse, &btn_tgl_rel);
    lv_obj_set_style(btn_inactif, &btn_ina);  
    
    
    lv_style_copy(&Style_texte, &lv_style_transp);  
    Style_texte.text.color  = LV_COLOR_MAKE(R2, G2, B2);   
    lv_obj_set_style(Reglage1, &Style_texte);                

}

static void PAGE_REGL_COLOR_FCT(void)
{

    // lv_obj_del(PAGE_REGL_COLOR);
    PAGE_REGL_COLOR = lv_cont_create(lv_disp_get_scr_act(NULL), NULL);
    lv_obj_set_size(PAGE_REGL_COLOR, 170, 240);
    lv_obj_set_pos(PAGE_REGL_COLOR,  200, 50);
    lv_obj_set_drag(PAGE_REGL_COLOR, true);
    // lv_obj_set_drag_parent(PAGE_REGL_COLOR, true);


    /*Create styles*/
    static lv_style_t style_bg,style_knob;
    static lv_style_t style_indic_R,style_indic_G,style_indic_B;


    lv_style_copy(&style_bg, &lv_style_pretty);
    style_bg.body.main_color =  LV_COLOR_BLACK;
    style_bg.body.grad_color =  LV_COLOR_BLACK;
    style_bg.body.radius = LV_RADIUS_CIRCLE;
    style_bg.body.border.color = LV_COLOR_SILVER;

    lv_style_copy(&style_indic_R, &lv_style_pretty_color);
    style_indic_R.body.main_color =  LV_COLOR_RED;
    style_indic_R.body.grad_color =  LV_COLOR_RED;
    style_indic_R.body.radius = LV_RADIUS_CIRCLE;
    style_indic_R.body.shadow.width = 4;
    style_indic_R.body.shadow.color = LV_COLOR_RED;
    style_indic_R.body.padding.left = 3;
    style_indic_R.body.padding.right = 3;
    style_indic_R.body.padding.top = 3;
    style_indic_R.body.padding.bottom = 3;

    lv_style_copy(&style_indic_G, &style_indic_R);
    style_indic_G.body.main_color =  LV_COLOR_GREEN;
    style_indic_G.body.grad_color =  LV_COLOR_GREEN;
    style_indic_G.body.shadow.color = LV_COLOR_GREEN;

    lv_style_copy(&style_indic_B, &style_indic_R);
    style_indic_B.body.main_color =  LV_COLOR_BLUE;
    style_indic_B.body.grad_color =  LV_COLOR_BLUE;
    style_indic_B.body.shadow.color = LV_COLOR_BLUE;

    lv_style_copy(&style_knob, &lv_style_pretty);
    style_knob.body.radius = LV_RADIUS_CIRCLE;
    style_knob.body.opa = LV_OPA_70;
    style_knob.body.padding.top = 10 ;
    style_knob.body.padding.bottom = 10 ;


    /*Create a slider ROUGE*/
    R = lv_slider_create(PAGE_REGL_COLOR, NULL);
    lv_obj_set_pos(R,  10, 40);
    lv_obj_set_width(R, 30);
    lv_obj_set_height(R, 180);
    lv_slider_set_range(R, 0, 255);
    lv_slider_set_value(R, Reglage_R, false);
    style_indic_R.body.main_color =  LV_COLOR_RED;
    style_indic_R.body.grad_color =  LV_COLOR_RED;
    style_indic_R.body.shadow.color = LV_COLOR_RED;
    lv_slider_set_style(R, LV_SLIDER_STYLE_BG, &style_bg);
    lv_slider_set_style(R, LV_SLIDER_STYLE_INDIC,&style_indic_R);
    lv_slider_set_style(R, LV_SLIDER_STYLE_KNOB, &style_knob);
    lv_obj_set_event_cb(R, Reglage_R_RGB);
    Val_R = lv_label_create(PAGE_REGL_COLOR, NULL);
    lv_obj_align(Val_R, R, LV_ALIGN_OUT_TOP_MID, 0, -5);
    sprintf(text, " %d ", lv_slider_get_value(R));
    lv_label_set_text(Val_R, text);


    /*Create a slider VERT*/
    G = lv_slider_create(PAGE_REGL_COLOR, NULL);
    lv_obj_set_pos(G,  60, 40);
    lv_obj_set_width(G, 30);
    lv_obj_set_height(G, 180);
    lv_slider_set_range(G, 0, 255);
    lv_slider_set_value(G, Reglage_G, false);
    lv_slider_set_style(G, LV_SLIDER_STYLE_BG, &style_bg);
    lv_slider_set_style(G, LV_SLIDER_STYLE_INDIC,&style_indic_G);
    lv_slider_set_style(G, LV_SLIDER_STYLE_KNOB, &style_knob);
    lv_obj_set_event_cb(G, Reglage_G_RGB);
    Val_G = lv_label_create(PAGE_REGL_COLOR, NULL);
    lv_obj_align(Val_G, G, LV_ALIGN_OUT_TOP_MID, 0, -5);
    sprintf(text, " %d ", lv_slider_get_value(G));
    lv_label_set_text(Val_G, text);

    /*Create a slider BLEU*/
    B = lv_slider_create(PAGE_REGL_COLOR, NULL);
    lv_obj_set_pos(B,  110, 40);
    lv_obj_set_width(B, 30);
    lv_obj_set_height(B, 180);
    lv_slider_set_range(B, 0, 255);
    lv_slider_set_value(B, Reglage_B, false);
    lv_slider_set_style(B, LV_SLIDER_STYLE_BG, &style_bg);
    lv_slider_set_style(B, LV_SLIDER_STYLE_INDIC,&style_indic_B);
    lv_slider_set_style(B, LV_SLIDER_STYLE_KNOB, &style_knob);
    lv_obj_set_event_cb(B, Reglage_B_RGB);
    Val_B = lv_label_create(PAGE_REGL_COLOR, NULL);
    lv_obj_align(Val_B, B, LV_ALIGN_OUT_TOP_MID, 0, -5);
    sprintf(text, " %d ", lv_slider_get_value(B));
    lv_label_set_text(Val_B, text);
    
    //BP
    btn_close = lv_btn_create(PAGE_REGL_COLOR, NULL);
    lv_obj_t * label = lv_label_create(btn_close, NULL);
    lv_obj_set_pos(btn_close,  150, 10);
    lv_label_set_text(label, "X");
    lv_obj_set_size(btn_close,20,20);
    lv_obj_set_event_cb(btn_close, ClosePage);
        
    lv_obj_set_style(btn_close,  &lv_style_pretty_color);

    lv_obj_set_hidden(PAGE_REGL_COLOR, 1);
}

static void ClosePage(lv_obj_t * CB, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        lv_obj_set_hidden(PAGE_REGL_COLOR, 1);
        lv_cb_set_checked(Reglage1, 0);
        lv_cb_set_checked(Reglage2, 0);
        lv_cb_set_checked(Reglage3, 0);
        lv_cb_set_checked(Reglage4, 0);
        lv_cb_set_checked(Reglage5, 0);
        lv_cb_set_checked(Reglage6, 0);
        lv_cb_set_checked(Reglage7, 0);
        lv_cb_set_checked(Reglage8, 0);
        lv_cb_set_checked(Reglage9, 0);
        lv_cb_set_checked(Reglage10, 0);        
        lv_cb_set_checked(Reglage11, 0);    
        lv_cb_set_checked(Reglage12, 0);    
        lv_cb_set_checked(Reglage13, 0);    
        lv_cb_set_checked(Reglage14, 0);    
    //    lv_cb_set_checked(Reglage15, 0);    
    //    lv_cb_set_checked(Reglage16, 0);    
    //    lv_cb_set_checked(Reglage17, 0);    
    //    lv_cb_set_checked(Reglage18, 0);    
    //    lv_cb_set_checked(Reglage19, 0);
    }
}

static void AFF_PAGE_REGL_COLOR(void)
{
    Reglage_R=(Reglage_RGB >> 16) & 0xFF ;
    Reglage_G=(Reglage_RGB >> 8) & 0xFF ;
    Reglage_B=(Reglage_RGB) & 0xFF ;
    sprintf(text, " %d ",Reglage_R );lv_label_set_text(Val_R, text);
    sprintf(text, " %d ",Reglage_G );lv_label_set_text(Val_G, text);
    sprintf(text, " %d ",Reglage_B );lv_label_set_text(Val_B, text);
    lv_slider_set_value(R, Reglage_R, false);
    lv_slider_set_value(G, Reglage_G, false);
    lv_slider_set_value(B, Reglage_B, false);
    lv_obj_set_hidden(PAGE_REGL_COLOR, 0);
}

static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_PRESSING) {
        Reglage_R= lv_slider_get_value(obj);
        sprintf(text, " %d ",Reglage_R );
        lv_label_set_text(Val_R, text);
        Affect_Couleur();
    }
}
static void Reglage_G_RGB(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_PRESSING) {
        Reglage_G= lv_slider_get_value(obj);
        sprintf(text, " %d ",Reglage_G );;
        lv_label_set_text(Val_G, text);
        Affect_Couleur();
    }
}
static void Reglage_B_RGB(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_PRESSING) {
        Reglage_B= lv_slider_get_value(obj);
        sprintf(text, " %d ",Reglage_B );
        lv_label_set_text(Val_B, text);
        Affect_Couleur();
    }
}



static void content_create(void)
{
     lv_coord_t hres = lv_disp_get_hor_res(NULL);
    lv_coord_t vres = lv_disp_get_ver_res(NULL);

    content = lv_page_create(lv_disp_get_scr_act(NULL), NULL);
    lv_obj_set_size(content, hres, vres);
    lv_obj_set_pos(content,  0, 40);

    lv_page_set_scrl_layout(content, LV_LAYOUT_OFF);
    lv_page_set_scrl_fit2(content, LV_FIT_FLOOD, LV_FIT_TIGHT);

    lv_coord_t max_w = lv_page_get_fit_width(content);
    

    th_roller = lv_roller_create(content, NULL);
    lv_roller_set_options(th_roller, th_options, true);  
    lv_obj_set_pos(th_roller,  20, 0);
    lv_obj_set_event_cb(th_roller, theme_select_event_handler);

 
    AffMillis = lv_label_create(content, NULL);
    lv_label_set_text(AffMillis, "123");  
    lv_obj_set_pos(AffMillis,  150, 0);
    
    //BP
    btn_relache = lv_btn_create(content, NULL);    
    lv_obj_set_pos(btn_relache,  20, 100);
    lv_btn_set_ink_in_time(btn_relache, 200);
    lv_btn_set_ink_wait_time(btn_relache, 100);
    lv_btn_set_ink_out_time(btn_relache, 500);
    label = lv_label_create(btn_relache, NULL);
    lv_label_set_text(label, "BP RELACHE");
    lv_obj_set_size(btn_relache,100,40);
    lv_btn_set_toggle(btn_relache, true);
    lv_btn_toggle(btn_relache);
    lv_page_glue_obj(btn_relache, true); 
    
    
    //BP
    btn_presse = lv_btn_create(content, NULL);    
    lv_obj_set_pos(btn_presse,  20, 200);
    lv_btn_set_ink_in_time(btn_presse, 200);
    lv_btn_set_ink_wait_time(btn_presse, 100);
    lv_btn_set_ink_out_time(btn_presse, 500);
    label = lv_label_create(btn_presse, NULL);
    lv_label_set_text(label, "BP PRESSE");
    lv_obj_set_size(btn_presse,100,40);
    lv_btn_set_toggle(btn_presse, true);
    lv_btn_toggle(btn_presse);
    lv_page_glue_obj(btn_presse, true);   
    
        
     //BP
    btn_inactif = lv_btn_create(content, NULL);    
    lv_obj_set_pos(btn_inactif,  20, 300);
    lv_btn_set_ink_in_time(btn_inactif, 200);
    lv_btn_set_ink_wait_time(btn_inactif, 100);
    lv_btn_set_ink_out_time(btn_inactif, 500);
    label = lv_label_create(btn_inactif, NULL);
    lv_label_set_text(label, "BP INACTIF");
    lv_obj_set_size(btn_inactif,100,40);
    lv_page_glue_obj(btn_inactif, true);   
    
     //BP
    btn_tgl_presse = lv_btn_create(content, NULL);    
    lv_obj_set_pos(btn_tgl_presse,  20, 400);
    lv_btn_set_ink_in_time(btn_tgl_presse, 200);
    lv_btn_set_ink_wait_time(btn_tgl_presse, 100);
    lv_btn_set_ink_out_time(btn_tgl_presse, 500);
    label = lv_label_create(btn_tgl_presse, NULL);
    lv_label_set_text(label, "BP BASCULE");
    lv_obj_set_size(btn_tgl_presse,100,40);
    lv_btn_set_toggle(btn_tgl_presse, true);
    lv_btn_toggle(btn_tgl_presse);
    lv_page_glue_obj(btn_tgl_presse, true);
    
    

    //Check box
    Reglage1 = lv_cb_create(content, NULL);    
    lv_obj_set_pos(Reglage1,  150, 20);   
    lv_obj_set_event_cb(Reglage1, Reglage1_ACT); 
    lv_page_glue_obj(Reglage1, true);  
    
    Reglage2 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage2,  150, 40);
    lv_obj_set_event_cb(Reglage2, Reglage2_ACT);  
    lv_page_glue_obj(Reglage2, true);  
    
    Reglage3 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage3,  150, 80); 
    lv_obj_set_event_cb(Reglage3, Reglage3_ACT); 
    lv_page_glue_obj(Reglage3, true);      
    
    Reglage4 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage4,  150, 100); 
    lv_obj_set_event_cb(Reglage4, Reglage4_ACT);
    lv_page_glue_obj(Reglage4, true);        
    
    Reglage5 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage5,  150, 120); 
    lv_obj_set_event_cb(Reglage5, Reglage5_ACT);      
    lv_page_glue_obj(Reglage5, true);  
    
    Reglage6 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage6,  150, 140); 
    lv_obj_set_event_cb(Reglage6, Reglage6_ACT);  
    lv_page_glue_obj(Reglage6, true);  
    
    Reglage7 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage7,  150, 180); 
    lv_obj_set_event_cb(Reglage7, Reglage7_ACT);  
    lv_page_glue_obj(Reglage7, true);  
    
    Reglage8 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage8,  150, 200); 
    lv_obj_set_event_cb(Reglage8, Reglage8_ACT);  
    lv_page_glue_obj(Reglage8, true);  
    
    Reglage9 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage9,  150, 220); 
    lv_obj_set_event_cb(Reglage9, Reglage9_ACT);  
    lv_page_glue_obj(Reglage9, true);  
    
    Reglage10 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage10,  150, 240); 
    lv_obj_set_event_cb(Reglage10, Reglage10_ACT); 
    lv_page_glue_obj(Reglage10, true);   
    
    Reglage11 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage11,  150, 280); 
    lv_obj_set_event_cb(Reglage11, Reglage11_ACT);  
    lv_page_glue_obj(Reglage11, true);  
        
    Reglage12 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage12,  150, 300); 
    lv_obj_set_event_cb(Reglage12, Reglage12_ACT);  
    lv_page_glue_obj(Reglage12, true);  
    
     Reglage13 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage13,  150, 320); 
    lv_obj_set_event_cb(Reglage13, Reglage13_ACT);  
    lv_page_glue_obj(Reglage13, true);  
    
    Reglage14 = lv_cb_create(content, NULL); 
    lv_obj_set_pos(Reglage14,  150, 340); 
    lv_obj_set_event_cb(Reglage14, Reglage14_ACT);  
    lv_page_glue_obj(Reglage14, true);  
    
    label1 = lv_label_create(content, NULL);
    lv_label_set_text(label1, "FIN");
    lv_obj_set_pos(label1,  20, 450);
    
        
    Affect_Couleur();
 

}

static void theme_select_event_handler(lv_obj_t * roller, lv_event_t event)
{
    if(event == LV_EVENT_VALUE_CHANGED) {

        uint16_t opt = lv_roller_get_selected(roller);
        th_act = themes[opt];
        lv_theme_set_current(th_act);
        
  /*              
        const lv_style_t * Style_Get;

//        Style_Get=lv_btn_get_style(btn_relache, LV_BTN_STYLE_REL);
   //     Style_EC=lv_btn_get_style(btn_relache, LV_BTN_STYLE_REL);
       Style_Get =lv_obj_get_style(btn_relache);
      uint32_t couleur=btn_ina.body.main_color.ch.red;
      uint32_t couleur2=Style_Get.body.main_color.ch.red;
  //      couleur=Style_Get.body.grad_color ;
        lv_color32_t c32;
c32.full = lv_color_to32(btn_ina.body.main_color);






        sprintf(text, " %d ", couleur);
        lv_label_set_text(AffMillis, text);*/
        
 //           theme.style.btn.rel     = &lv_style_btn_rel;
 //   theme.style.btn.pr      = &lv_style_btn_pr;
 //   theme.style.btn.tgl_rel = &lv_style_btn_tgl_rel;
 //   theme.style.btn.tgl_pr  = &lv_style_btn_tgl_pr;
 //   theme.style.btn.ina     = &lv_style_btn_ina;
    }
}


static void init_all_themes(uint16_t hue)
{
    // NOTE: This must be adjusted if more themes are added.
    int i = 0;
#if LV_USE_THEME_DEFAULT
    themes[i++] = lv_theme_default_init(hue, NULL);
#endif

#if LV_USE_THEME_NIGHT
    themes[i++] = lv_theme_night_init(hue, NULL);
#endif

#if LV_USE_THEME_MATERIAL
    themes[i++] = lv_theme_material_init(hue, NULL);
#endif

#if LV_USE_THEME_ALIEN
    themes[i++] = lv_theme_alien_init(hue, NULL);
#endif

#if LV_USE_THEME_ZEN
    themes[i++] = lv_theme_zen_init(hue, NULL);
#endif

#if LV_USE_THEME_NEMO
    themes[i++] = lv_theme_nemo_init(hue, NULL);
#endif

#if LV_USE_THEME_MONO
    themes[i++] = lv_theme_mono_init(hue, NULL);
#endif


}


static void BPMESURE_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPMESURE);
        DdeAlignMenu=1;
    }
}
static void BPPARA_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPPARA);
        DdeAlignMenu=1;
    }
}
static void BPMENU3_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPMENU3);
        DdeAlignMenu=1;
    }
}
static void BPMENU4_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPMENU4);
        DdeAlignMenu=1;
    }
}
static void BPMENU5_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPMENU5);
        DdeAlignMenu=1;
    }
}
static void BPMENU6_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(entete);
        PosX_MenuCible = -lv_obj_get_x(BPMENU6);
        DdeAlignMenu=1;
    }
}

static  void ddlist_event_cb(lv_obj_t * ddlist, lv_event_t event)
{
    if(event == LV_EVENT_VALUE_CHANGED) {
        uint16_t opt = lv_ddlist_get_selected(ddlist);            //Get the id of selected option

        lv_slider_set_value(slider, (opt * 100) / 4, true);       //Modify the slider value according to the selection
    }

}



void lv_ticker_func()
{
    lv_tick_inc(TICK_DEF); //Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). It is required for the internal timing of LittlevGL.
}

void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p)
{
    //The most simple case (but also the slowest) to put all pixels to the screen one-by-one
    uint16_t x, y;
    for(y = area->y1; y <= area->y2; y++) {
        for(x = area->x1; x <= area->x2; x++) {

            lcd.DrawPixel( x, y, color_p->full);
            color_p++;
        }
    }

    // IMPORTANT!!!
    // Inform the graphics library that you are ready with the flushing
    lv_disp_flush_ready(disp_drv);
}

bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data)
{
    static lv_coord_t last_x = 0;
    static lv_coord_t last_y = 0;

    //Save the state and save the pressed coordinate
    ts.GetState(&TS_State);

    if(TS_State.touchDetected == 1) {
        data->state = LV_INDEV_STATE_PR;
    } else {
        data->state = LV_INDEV_STATE_REL;
    }

    //data->state = tttt ? LV_INDEV_STATE_PR : LV_INDEV_STATE_REL;
    //  if(data->state == LV_INDEV_STATE_PR){
    if(data->state == LV_INDEV_STATE_PR) {
        //touchpad_get_xy(&last_x, &last_y);
        last_x = TS_State.touchX[0];
        last_y = TS_State.touchY[0];
    }

    //Set the coordinates (if released use the last pressed coordinates)
    data->point.x = last_x;
    data->point.y = last_y;

    X = TS_State.touchDetected ;



    return false; //Return `false` because we are not buffering and no more data to read
}

static void event_handler(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        printf("Clicked\n");
    } else if(event == LV_EVENT_VALUE_CHANGED) {
        printf("Toggled\n");
    }
}