#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "lvgl/lvgl.h"
#include "lv_conf.h"
#include "millis.h"
#include "FastPWM.h"
#include <string>
#include "lv_i18n.h"

#include "lv_theme_rb.h" //GABOR

Ticker ticker;                //Initialize system tick
LCD_DISCO_F746NG lcd;         //Initialize display driver
TS_DISCO_F746NG ts;           //Initialize touchpad driver
TS_StateTypeDef TS_State;     //Initialize touch state sctruct

Serial serial(USBTX, USBRX);

/*********************
 *  ENTREES SORTIES
 *********************/
//TENSION BATTERIE
AnalogIn AI_TENSION_BAT(A4);

//PWM
FastPWM fastpwm(D12,1); //steup pwm output on pin d12 with a prescaler of 1   

//MARCHE POMPE
DigitalOut DO_POMPE(D13);

//COMPTEUR IMPULSION   
DigitalIn DI_CPTPuls(D7);
//InterruptIn DI_CPTPuls(D7); //


    
/**********************
 * VARIABLES GENERALES 
 **********************/
int X;
int Y;
Timer tempo;
bool Top1ms;
bool Top10ms;
bool Top100ms;
bool Top1s;
bool Top5s;
bool Top1min;
char text[100];
char text2[100];

float TensionBat;
float MoyTensBat[101];
int CsgPompe=0; 

uint64_t Micros=0;
uint64_t CalcTpsCy=0;
float TpsCy=0;

uint64_t MemMicros0=0;
uint64_t MemMicros1=0;
uint64_t MemMicros2=0;
uint64_t MemMicros3=0;
uint64_t MemMicros4=0;
uint64_t MemMicros5=0;


int CalcFmPuls;
int CalcFdPuls;
bool FmCPTPuls;
uint64_t TimerPuls=0;
uint64_t TpsPuls=0;
float Calcul=0;
uint64_t MemTpsPuls=0;
uint64_t MemTps16Puls=0;
int NumDent=0;
uint64_t CptPuls=0;
uint64_t CalcDebit=0;
float Debit;
float TpsEntre2Puls[20];
float TpsMinEntre2Puls;
float TpsMaxEntre2Puls;
float Volume;
float VolParTour=1200;//en ml

int hres = 480;
int vres = 272;
bool CDA_POMPE;


uint64_t test=0;

//VARIABLES GESTION MOT DE PASSE


/*********************
 *  OBJET PAGES
 *********************/
static lv_obj_t * BandeauHaut;
static void AFFBandeauHaut(int Num);
static lv_obj_t * SousMenu;
static void AFFSousMenu(int Num);
static lv_obj_t * Page;
int PageAff=0;
int MemPageAff=0;
static void AFFPage(int Num);


static lv_obj_t * PopupMDP;
static void AFFPopupMDP();

static void init_all_themes(uint16_t hue);

/*********************
 *  OBJET GENERAUX
 *********************/
static lv_obj_t *mbox;

/*****************************
 *  VARIABLES/OBJETS CONNEXION
 *****************************/
static lv_obj_t * SelectID;
static lv_obj_t * MDP;
static void SelectID_ACT(lv_obj_t * obj, lv_event_t event);
uint32_t TpsMdpEnCours=0;
struct Personne
{
    string Nom;
    string MDP; //mot de passe à 4 chiffres
    int Niveau; //0:aucun 1:Opérateur 2:superviseur 3:constructeur
    int Tps;    //Temps de connexion
};
Personne User[100];
Personne UserEC;
static void BpValidMDP_ACT(lv_obj_t * btn, lv_event_t event);
static void BpAnnulMDP_ACT(lv_obj_t * btn, lv_event_t event);
static void mboxMdp_ACT(lv_obj_t * btn, lv_event_t event);
static void mboxMdp_ACT2(lv_obj_t * btn, lv_event_t event);

/*********************
 *  OBJETS BP MENU
 *********************/
static lv_obj_t * M100;
static lv_obj_t * M200;
static lv_obj_t * M300;
static lv_obj_t * M400;
static lv_obj_t * M500;
static lv_obj_t * M600;

static lv_obj_t * SM101;
static lv_obj_t * SM102;
static lv_obj_t * SM103;
static lv_obj_t * SM104;
static lv_obj_t * SM105;

static lv_obj_t * SM201;
static lv_obj_t * SM202;

static lv_obj_t * SM301;

//FONCTIONS ASSOCIEES
static void M100_ACT(lv_obj_t * btn, lv_event_t event);
static void M200_ACT(lv_obj_t * btn, lv_event_t event);
static void M300_ACT(lv_obj_t * btn, lv_event_t event);
static void M400_ACT(lv_obj_t * btn, lv_event_t event);
static void M500_ACT(lv_obj_t * btn, lv_event_t event);
static void M600_ACT(lv_obj_t * btn, lv_event_t event);

static void SM101_ACT(lv_obj_t * btn, lv_event_t event);
static void SM102_ACT(lv_obj_t * btn, lv_event_t event);
static void SM103_ACT(lv_obj_t * btn, lv_event_t event);
static void SM104_ACT(lv_obj_t * btn, lv_event_t event);
static void SM105_ACT(lv_obj_t * btn, lv_event_t event);

static void SM201_ACT(lv_obj_t * btn, lv_event_t event);
static void SM202_ACT(lv_obj_t * btn, lv_event_t event);
static void SM203_ACT(lv_obj_t * btn, lv_event_t event);

static void SM301_ACT(lv_obj_t * btn, lv_event_t event);

/*********************
 *  OBJETS 
 *********************/ 
static lv_obj_t *FondGris ;
static lv_obj_t *FondGris2 ;

/*********************
 *  MATRICE DE BOUTONS 
 *********************/ 
static const char * PAVE_NUMERIQUE_MAP[] = {"7", "8", "9","\n",
                                  "4", "5","6", "\n",
                                  "1", "2", "3","\n", 
                                  "0", LV_SYMBOL_BACKSPACE, ""};
/*********************
 *  STYLES
 *********************/
static lv_style_t Style_texte1;
static lv_style_t Style_texte2;
static lv_style_t Style_BPM;
static lv_style_t Style_BPSM;
static lv_style_t Style_BPSMInactif;
static lv_style_t Style_BP;

/*********************
 *  MULTILANGUE
 *********************/ 
int Langue=1;
static void LANGUE_FR_ACT(lv_obj_t * btn, lv_event_t event);
static void LANGUE_EN_ACT(lv_obj_t * btn, lv_event_t event);

/*********************
 *  FONCTION
 *********************/
void initialisation();
void interruptCompteur();

static void BPRAZ_ACT(lv_obj_t * btn, lv_event_t event);
static void BPPOMPE_ACT(lv_obj_t * btn, lv_event_t event);
static lv_theme_t * th_act;
static lv_obj_t * label;
static lv_obj_t * label1;


static lv_obj_t * AffTensionBat;
static lv_obj_t * AffTpsCy;
static lv_obj_t * AffCptPuls;
static lv_obj_t * AffDebit;
static lv_obj_t * Aff1TpsEntre2Puls;
static lv_obj_t * Aff2TpsEntre2Puls;
static lv_obj_t * AffTpsMinEntre2Puls;
static lv_obj_t * AffTpsMaxEntre2Puls;
static lv_obj_t * AffVolume;
static lv_obj_t * BPRAZ;
static lv_obj_t * BPPOMPE;

int NumSousMenu=1;

LV_FONT_DECLARE(arial_20)        //Declare a font

void lv_ticker_func();
void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p);
bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data);
static void event_handler(lv_obj_t * obj, lv_event_t event);
//void btn_event_cb(lv_obj_t * btn, lv_event_t event);



static void ddlist_event_cb(lv_obj_t * ddlist, lv_event_t event);
static lv_obj_t * slider;

int PosX_MenuDepart = 0;
int PosX_MenuCible = 0;
bool DdeAlignMenu = 0;

int PosY_AnimSousMenu = 0;
int AnimSousMenu=0;
int TpsAvFermSousMenu=2000;

static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event);

int TestAff = 0;


static lv_obj_t  * Val_R;

static lv_obj_t  * R;


int Reglage_R;
uint8_t Reglage_G;
uint8_t Reglage_B;
uint32_t Reglage_RGB;


uint8_t R1=255,G1=255,B1=255,
        R2=0 ,G2=0 ,B2=0,
        R3=255 ,G3=255 ,B3=255,
        R4=0,G4=0,B4=0,
        R5=145,G5=145,B5=145,
        R6=255,G6=255,B6=255,
        R7=0,G7=0,B7=0,
        R8=73,G8=143,B8=64,
        R9=0,G9=255,B9=0,
        R10=155,G10=238,B10=131,
        R11=145,G11=145,B11=145,
        R12=51,G12=37,B12=22,
        R13=255,G13=255,B13=255,
        R14=153,G14=158,B14=117,
        R15=107,G15=154,B15=199,
        R16=107,G16=154,B16=199,
        R17=107,G17=154,B17=199,
        R18=107,G18=154,B18=199,
        R19=107,G19=154,B19=199;
      
   
int NumCouleur=0;


static lv_theme_t * themes[8];


int main()
{      
     //demarrage communication avec PC
    serial.baud(9600);
    serial.printf("DEBUT DE PROGRAMME\r\n");
    //Entree impulsion
    DI_CPTPuls.mode(PullUp);
    
    //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"LittlevGL DEMO", CENTER_MODE);
    ticker.attach(&lv_ticker_func,0.005);// Appel de la fonction LittlVGL toutes les 5ms
    wait(0.5);
    lv_init();                                  //Initialize the LittlevGL

    static lv_disp_buf_t disp_buf;
    static lv_color_t buf[LV_HOR_RES_MAX * 10]; //Declare a buffer for 10 lines
    lv_disp_buf_init(&disp_buf, buf, NULL, LV_HOR_RES_MAX * 10); //Initialize the display buffer

    //Implement and register a function which can copy a pixel array to an area of your display
    lv_disp_drv_t disp_drv;               //Descriptor of a display driver
    lv_disp_drv_init(&disp_drv);          //Basic initialization
    disp_drv.flush_cb = my_disp_flush;    //Set your driver function
    disp_drv.buffer = &disp_buf;          //Assign the buffer to the display
    lv_disp_drv_register(&disp_drv);      //Finally register the driver

    //Implement and register a function which can read an input device. E.g. for a touch pad
    ts.Init(lcd.GetXSize(), lcd.GetYSize());   //ST touch initialization
    lv_indev_drv_t indev_drv;                  //Descriptor of a input device driver
    lv_indev_drv_init(&indev_drv);             //Basic initialization
    indev_drv.type = LV_INDEV_TYPE_POINTER;    //Touch pad is a pointer-like device
    indev_drv.read_cb = my_touchpad_read;      //Set your driver function
    lv_indev_drv_register(&indev_drv);         //Finally register the driver

    //INITIALISATION MULTILANGUE
    lv_i18n_init(lv_i18n_language_pack);
    lv_i18n_set_locale("fr");
    //lv_i18n_set_locale("en-GB");

    initialisation();
    AFFBandeauHaut(0);
    AFFPage(101);
  
    //demarrage tempo générale
    tempo.start();    
    //Interruption compteur 
   // DI_CPTPuls.rise(&interruptCompteur);
    
    while(1) {
                   
        //TEMPO GENERALE
        Micros=tempo.read_high_resolution_us();           
       //TOP base de temps
        Top1ms=false;   if (Micros>=MemMicros0+1000) {      Top1ms=true;    MemMicros0=MemMicros0+1000;     } 
        Top10ms=false;  if (Micros>=MemMicros1+10000) {     Top10ms=true;   MemMicros1=MemMicros1+10000;    }  
        Top100ms=false; if (Micros>=MemMicros2+100000) {    Top100ms=true;  MemMicros2=MemMicros2+100000;   } 
        Top1s=false;    if (Micros>=MemMicros3+1000000) {   Top1s=true;     MemMicros3=MemMicros3+1000000;  }      
        Top5s=false;    if (Micros>=MemMicros4+5000000) {   Top5s=true;     MemMicros4=MemMicros4+5000000;  }   
        Top1min=false;  if (Micros>=MemMicros5+60000000) {  Top1min=true;   MemMicros5=MemMicros5+60000000; }     
        
        //CALCUL TEMPS DE CYCLE    
        CalcTpsCy++;
        if (Top1s){
            TpsCy=1000000000/CalcTpsCy;  
            TpsCy=TpsCy/1000;
            test=CalcTpsCy; 
            CalcTpsCy=0;           
        }  
        //Raffraichissement affichage toutes les 10ms        
        if (Top10ms){
            lv_task_handler(); 
        }  
                  
       //MISE A JOUR DES VARIABLES AFFICHEES 
        if (Top1s or MemPageAff!=PageAff){  
            MemPageAff=PageAff; 
            if (PageAff==101){
                sprintf(text, _("Temps de cycle = %3.3f us"),TpsCy);       lv_label_set_text(AffTpsCy, text);         
                sprintf(text, _("Tension= %3.3f V "),TensionBat );         lv_label_set_text(AffTensionBat, text);
                sprintf(text, "Nombre d'impulsion= %d ",CptPuls );      lv_label_set_text(AffCptPuls, text);
                sprintf(text, "Volume = %3.3f L",Volume );              lv_label_set_text(AffVolume, text);           
                sprintf(text, "Debit= %3.3f L/min ",Debit );            lv_label_set_text(AffDebit, text);   
                sprintf(text, "%3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f ",TpsEntre2Puls[1],TpsEntre2Puls[2],TpsEntre2Puls[3],TpsEntre2Puls[4],TpsEntre2Puls[5],TpsEntre2Puls[6],TpsEntre2Puls[7],TpsEntre2Puls[8]); lv_label_set_text(Aff1TpsEntre2Puls, text);
                sprintf(text, "%3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f ",TpsEntre2Puls[9],TpsEntre2Puls[10],TpsEntre2Puls[11],TpsEntre2Puls[12],TpsEntre2Puls[13],TpsEntre2Puls[14],TpsEntre2Puls[15],TpsEntre2Puls[16]); lv_label_set_text(Aff2TpsEntre2Puls, text);
                sprintf(text, "Temps mini entre 2 impulsions = %d ",Micros ); lv_label_set_text(AffTpsMinEntre2Puls, text);   
                sprintf(text, "Temps maxi entre 2 impulsions = %d",test ); lv_label_set_text(AffTpsMaxEntre2Puls, text);   
            }            
            if (PageAff==301){
                
            }
            
        }      
        
        //DETECTION IMPULSION        
        if (DI_CPTPuls and Top1ms){     CalcFdPuls=0;CalcFmPuls++;}
        if (not DI_CPTPuls and Top1ms){ CalcFmPuls=0;CalcFdPuls++;}
        if (CalcFmPuls>20 and not FmCPTPuls){interruptCompteur();FmCPTPuls=true;}
        if (CalcFdPuls>20 and FmCPTPuls){FmCPTPuls=false;}
        if (CalcFmPuls>500){CalcFmPuls=500;}
        if (CalcFdPuls>500){CalcFdPuls=500;}
       
        //MESURE TENSION BATTERIE
        if (Top10ms){
            MoyTensBat[0]=AI_TENSION_BAT.read()*3.3*2+0.018;
            TensionBat=0;
            for (int i=100;i>0;i--){
                MoyTensBat[i]=MoyTensBat[i-1];
                TensionBat=TensionBat+MoyTensBat[i];      
            }
            TensionBat=TensionBat/100;   
        }              
           
        //COMMANDE POMPE PWM
        if (Top100ms){
            CsgPompe=Reglage_R;
            fastpwm.period_ticks (10000); //setup the period for 100Khz 
            fastpwm.pulsewidth_ticks(CsgPompe);//setup duty cycle to 50%
        }
     
        //RAZ MOT DE PASSE
        if (TpsMdpEnCours>0 and Top1s){
            TpsMdpEnCours--;
            if (TpsMdpEnCours==0){
                mbox=lv_mbox_create(lv_disp_get_scr_act(NULL), NULL);              
                sprintf(text, "Fin de connexion pour %s",UserEC.Nom );
                lv_mbox_set_text(mbox, text);
                lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
                lv_mbox_start_auto_close(mbox, 3000);
                UserEC.Nom="";    
                UserEC.Niveau=0;     
            }
        }
        
        //ANIMATION MENU
        if (Top1ms){
            if (DdeAlignMenu) {
                if (PosX_MenuDepart>PosX_MenuCible) {
                    PosX_MenuDepart=PosX_MenuDepart-1;
                    lv_obj_set_pos(BandeauHaut, PosX_MenuDepart, 0);
                }
                if (PosX_MenuDepart<PosX_MenuCible) {
                    PosX_MenuDepart=PosX_MenuDepart+1;
                    lv_obj_set_pos(BandeauHaut, PosX_MenuDepart, 0);
                }
                if (PosX_MenuDepart==PosX_MenuCible) {
                    DdeAlignMenu=0;
                    AFFSousMenu(NumSousMenu);//affichage page sous menu
                }
            }  
        }
        
        //ANIMATION SOUS MENU
        if (Top1ms){
            
            //OUVERTURE SOUS MENU
            if (AnimSousMenu>0) {                
                PosY_AnimSousMenu=PosY_AnimSousMenu+2;
                lv_obj_set_size(SousMenu, 100, PosY_AnimSousMenu);
                if (PosY_AnimSousMenu>=AnimSousMenu){AnimSousMenu=0;}  
                TpsAvFermSousMenu=4000;    
            }   
            //TEMPS AVANT FERMEURE
            if (SousMenu and TpsAvFermSousMenu>0){TpsAvFermSousMenu--;}
            //FERMETURE SOUS MENU
            if (SousMenu and TpsAvFermSousMenu<=0) {                
                PosY_AnimSousMenu=PosY_AnimSousMenu-2;
                lv_obj_set_size(SousMenu, 100, PosY_AnimSousMenu);
                if (PosY_AnimSousMenu<=0){
                    lv_obj_del_async(SousMenu); 
                    SousMenu=NULL;
                }           
            }  
        }
        if (SousMenu and X>0){TpsAvFermSousMenu=4000;}
            
  /**/      
    }//FIN BOUCLE
}//FIN MAIN


//FONCTION INTERRUPTION COMPTEUR D'IMPULSION
void interruptCompteur()
{   
    //Timestamp pulsation
    TimerPuls=tempo.read_high_resolution_us();
    
    // Calcul temps entre 2 impulsions 
    TpsPuls=TimerPuls-MemTpsPuls;
    MemTpsPuls=TimerPuls;
    
    //Incrementation numéro de dent roue
    NumDent++;
    
     //Memorisation ecart entre chaque impulsion et Calcul des Min Max    
    Calcul=TpsPuls;
    Calcul=Calcul/1000;
    TpsEntre2Puls[NumDent]=Calcul;
    if (Calcul<TpsMinEntre2Puls){TpsMinEntre2Puls=Calcul;}
    if (Calcul>TpsMaxEntre2Puls){TpsMaxEntre2Puls=Calcul;}
        
    //Calcul débit
    if (NumDent>=16){
        CalcDebit=VolParTour;
        CalcDebit=60000000*CalcDebit/(TimerPuls-MemTps16Puls);
        Debit=CalcDebit;
        Debit=Debit/1000;
        MemTps16Puls=TimerPuls;
        NumDent=0;
    }
        
    //Nombre d'impulsion total   
    CptPuls++;
    
    //Calcul Volume
    Volume=CptPuls*VolParTour/16000;
     
}

void initialisation(void)
{
    //CHARGEMENT DU THEME
    th_act = lv_theme_rb_init(0, &RB_lv_font_roboto_12); //Gabor: When i change something in my Theme nothing's happen. Can you see in /lvgl_RB/lv_theme_rb.c
  //    th_act = lv_theme_night_init(0, NULL);
    lv_theme_set_current(th_act);

    lv_obj_t * scr = lv_obj_create(NULL, NULL);
    lv_disp_load_scr(scr);

    //INITIALISATION TABLEAU UTILISATEUR
     User[1].Nom="Romain BECAN";        User[1].MDP="1234";   User[1].Niveau=3; User[1].Tps=1;
     User[2].Nom="Guy HERVE";           User[2].MDP="5678";   User[2].Niveau=2; User[2].Tps=120;
     User[31].Nom="OPERATEUR 1";        User[31].MDP="4321";  User[31].Niveau=1; User[31].Tps=1;
     User[32].Nom="OPERATEUR 2";        User[32].MDP="4321";  User[32].Niveau=1; User[32].Tps=60;
     User[33].Nom="OPERATEUR 3";        User[33].MDP="4321";  User[33].Niveau=1; User[33].Tps=40;
     User[34].Nom="OPERATEUR 4";        User[34].MDP="4321";  User[34].Niveau=1; User[34].Tps=30;
     User[35].Nom="OPERATEUR 5";        User[35].MDP="4321";  User[35].Niveau=3; User[35].Tps=30;
     User[36].Nom="OPERATEUR 6";        User[36].MDP="4321";  User[36].Niveau=3; User[36].Tps=30;
     User[99].Nom="OPERATEUR 100";      User[99].MDP="4321";  User[99].Niveau=3; User[99].Tps=30;
}



static void AFFBandeauHaut(int Num)
{
    if(BandeauHaut) {
        lv_obj_del(BandeauHaut);
        BandeauHaut = NULL;
    } 
    
     // CREATION OBJET BANDEAU HAUT
    BandeauHaut = lv_cont_create(lv_scr_act(), NULL);
    lv_obj_set_size(BandeauHaut,900,40);
    lv_cont_set_fit2(BandeauHaut,LV_FIT_TIGHT, LV_FIT_NONE);
    lv_obj_set_pos(BandeauHaut, 50, 0);
    lv_obj_set_drag_dir(BandeauHaut, LV_DRAG_DIR_HOR);
    lv_obj_set_drag_throw(BandeauHaut, true);
    
    //MENU 1
    M100 = lv_btn_create(BandeauHaut, NULL);
    lv_btn_set_ink_in_time(M100, 200);
    lv_btn_set_ink_wait_time(M100, 100);
    lv_btn_set_ink_out_time(M100, 500);
    lv_obj_t * label = lv_label_create(M100, NULL);
    lv_label_set_text(label, _("M100"));
    lv_obj_set_size(M100,100,40);
    lv_obj_set_drag_parent(M100, true);
    lv_obj_set_event_cb(M100, M100_ACT);

    //MENU 2
    M200 = lv_btn_create(BandeauHaut, NULL);
    lv_btn_set_ink_in_time(M200, 200);
    lv_btn_set_ink_wait_time(M200, 100);
    lv_btn_set_ink_out_time(M200, 500);
    label = lv_label_create(M200, NULL);
    lv_label_set_text(label, _("M200"));
    lv_obj_set_size(M200,100,40);
    //lv_btn_set_toggle(M200, true);
  //  lv_btn_toggle(M200);
    // lv_obj_set_drag(M200, true);
    lv_obj_align(M200, M100, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(M200, true);
    lv_obj_set_event_cb(M200, M200_ACT);

    //MENU 3
    M300 = lv_btn_create(BandeauHaut, NULL);
    label = lv_label_create(M300, NULL);
    lv_label_set_text(label, _("M300"));
    lv_obj_set_size(M300,100,40);
    lv_obj_align(M300, M200, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(M300, true);
    lv_obj_set_event_cb(M300, M300_ACT);

    //MENU 4
    M400 = lv_btn_create(BandeauHaut, NULL);
    label = lv_label_create(M400, NULL);
    lv_label_set_text(label, _("M400"));
    lv_obj_set_size(M400,100,40);
    lv_obj_align(M400, M300, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(M400, true);
    lv_obj_set_event_cb(M400, M400_ACT);

    //MENU 5
    M500 = lv_btn_create(BandeauHaut, NULL);
    label = lv_label_create(M500, NULL);
    lv_label_set_text(label, _("M500"));
    lv_obj_set_size(M500,100,40);
    lv_obj_align(M500, M400, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(M500, true);
    lv_obj_set_event_cb(M500, M500_ACT);

    //BP BPMENU6
    M600 = lv_btn_create(BandeauHaut, NULL);
    label = lv_label_create(M600, NULL);
    lv_label_set_text(label, _("M600"));
    lv_obj_set_size(M600,100,40);
    lv_obj_align(M600, M500, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
    lv_obj_set_drag_parent(M600, true);
    lv_obj_set_event_cb(M600, M600_ACT);

}


static void AFFSousMenu(int Num)
{
    //SI SOUS MENU DEJA AFFICHE : SUPPRIMER PAGE AVANT CREATION NOUVELLE
    if(SousMenu) {
        lv_obj_del(SousMenu);
        SousMenu = NULL;
    } 
   
    /*Create a list*/
    SousMenu = lv_list_create(lv_scr_act(), NULL);
    lv_obj_set_size(SousMenu, 100, 100);
    lv_obj_set_pos(SousMenu, 0, 40);

    lv_style_copy(&Style_BPSM, &lv_style_btn_rel);    
    Style_BPSM.text.font = &lv_font_roboto_12;  
    Style_BPSM.body.main_color    = LV_COLOR_RED;
    Style_BPSM.body.padding.top    = LV_DPI / 40;
    Style_BPSM.body.padding.bottom = LV_DPI / 40;  
 //    G/ABOR: How to change the height of button in a list ?
 //    ROMAIN: You need to modify the paddings. See here: https://docs.littlevgl.com/en/html/object-types/list.html#style-usage
 //            Your intention with looked good you just need to apply it with lv_btn_set_style(SM101, LV_BTN_STYLE_REL, &Style_BPSM);
    
    //SOUS MENU 100
    if (Num==100){
        AnimSousMenu=200;//TAILLE FENETRE
        SM101 = lv_list_add_btn(SousMenu, NULL, "SM101");   
        lv_btn_set_style(SM101, LV_BTN_STYLE_REL, &Style_BPSM);
        lv_btn_set_style(SM101, LV_BTN_STYLE_PR, &Style_BPSM);
        if (UserEC.Niveau<0){lv_btn_set_state(SM101, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM101, SM101_ACT);
    
        SM102 = lv_list_add_btn(SousMenu, NULL, "SM102");
        if (UserEC.Niveau<0){lv_btn_set_state(SM102, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM102, SM102_ACT);
    
        SM103 = lv_list_add_btn(SousMenu, NULL, "SM103");
        if (UserEC.Niveau<1){lv_btn_set_state(SM103, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM103, SM103_ACT);
    
        SM104 = lv_list_add_btn(SousMenu, NULL, "NOM DE MENU LONG");
        if (UserEC.Niveau<0){lv_btn_set_state(SM104, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM104, SM104_ACT);
    
        SM105 = lv_list_add_btn(SousMenu, NULL, "SM104");
        if (UserEC.Niveau<0){lv_btn_set_state(SM105, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM105, SM105_ACT);
    }
    
    //SOUS MENU 200
    if (Num==200){
        AnimSousMenu=100;//TAILLE FENETRE
        SM201 = lv_list_add_btn(SousMenu, NULL, "SM201");   
        if (UserEC.Niveau<0){lv_btn_set_state(SM201, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM201, SM201_ACT);
    
        SM202 = lv_list_add_btn(SousMenu, NULL, "SM202");
        if (UserEC.Niveau<0){lv_btn_set_state(SM202, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM202, SM202_ACT);

    }
     //SOUS MENU 300
    if (Num==300){
        AnimSousMenu=300;//TAILLE FENETRE
        SM301 = lv_list_add_btn(SousMenu, NULL, _("SM301"));   
        if (UserEC.Niveau<0){lv_btn_set_state(SM301, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM301, SM301_ACT);
    }
          
}


static void AFFPage(int Num)
{
    if(Page) {
        lv_obj_del(Page);        
  //    lv_obj_clean(Page);
        Page = NULL;
    } 
    //MEMORISATION PAGE AFFICHEE
    PageAff=Num;
   
    Page = lv_page_create(lv_scr_act(), NULL);
    lv_obj_set_size(Page, hres, vres);
    lv_obj_set_pos(Page,  0, 40);
    

    lv_page_set_scrl_layout(Page, LV_LAYOUT_OFF);
    lv_page_set_scrl_fit2(Page, LV_FIT_FLOOD, LV_FIT_TIGHT);
    lv_coord_t max_w = lv_page_get_fit_width(Page);
    
    // PAGE 101: Mesures
    if (Num==101){
        
        //affichage données
        int i=0;
        AffTensionBat = lv_label_create(Page, NULL);  
        lv_obj_set_pos(AffTensionBat,  50, i);    
        
        AffTpsCy = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsCy,  50, i);
        
        AffCptPuls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffCptPuls,  50, i);
        
        AffVolume = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffVolume,  50, i);
        
        AffDebit = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffDebit,  50, i);
            
        Aff1TpsEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(Aff1TpsEntre2Puls,  50, i);
        
        Aff2TpsEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(Aff2TpsEntre2Puls,  50, i);
        
        AffTpsMinEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsMinEntre2Puls,  50, i);
        
        AffTpsMaxEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsMaxEntre2Puls,  50, i);
        
        //BP RAZ
        BPRAZ = lv_btn_create(Page, NULL);
        i=i+30;lv_obj_set_pos(BPRAZ,  50, i);
        label = lv_label_create(BPRAZ, NULL);
        lv_label_set_text(label, "RAZ");
        lv_obj_set_size(BPRAZ,60,40);
        lv_obj_set_event_cb(BPRAZ, BPRAZ_ACT);
        
        //BP POMPE
        BPPOMPE = lv_btn_create(Page, NULL);
        lv_obj_set_pos(BPPOMPE,  150, i);
        label = lv_label_create(BPPOMPE, NULL);
        lv_label_set_text(label, "POMPE");
        lv_obj_set_size(BPPOMPE,90,40);
        lv_btn_set_toggle(BPPOMPE, true);
        lv_obj_set_event_cb(BPPOMPE, BPPOMPE_ACT);
        
         // SLIDER
        static lv_style_t style_bg,style_knob;
        static lv_style_t style_indic_R;
    
    
        lv_style_copy(&style_bg, &lv_style_pretty);
        style_bg.body.main_color =  LV_COLOR_BLACK;
        style_bg.body.grad_color =  LV_COLOR_BLACK;
        style_bg.body.radius = LV_RADIUS_CIRCLE;
        style_bg.body.border.color = LV_COLOR_SILVER;
    
        lv_style_copy(&style_indic_R, &lv_style_pretty_color);
        style_indic_R.body.main_color =  LV_COLOR_RED;
        style_indic_R.body.grad_color =  LV_COLOR_RED;
        style_indic_R.body.radius = LV_RADIUS_CIRCLE;
        style_indic_R.body.shadow.width = 4;
        style_indic_R.body.shadow.color = LV_COLOR_RED;
        style_indic_R.body.padding.left = 3;
        style_indic_R.body.padding.right = 3;
        style_indic_R.body.padding.top = 3;
        style_indic_R.body.padding.bottom = 3;
    
        lv_style_copy(&style_knob, &lv_style_pretty);
        style_knob.body.radius = LV_RADIUS_CIRCLE;
        style_knob.body.opa = LV_OPA_70;
        style_knob.body.padding.top = 10 ;
        style_knob.body.padding.bottom = 10 ;
    
        /*Create a slider ROUGE*/
        R = lv_slider_create(Page, NULL);
        lv_obj_set_pos(R,  10, 40);
        lv_obj_set_width(R, 30);
        lv_obj_set_height(R, 180);
        lv_slider_set_range(R, 0, 10000);
        lv_slider_set_value(R, Reglage_R, false);
        style_indic_R.body.main_color =  LV_COLOR_RED;
        style_indic_R.body.grad_color =  LV_COLOR_RED;
        style_indic_R.body.shadow.color = LV_COLOR_RED;
        lv_slider_set_style(R, LV_SLIDER_STYLE_BG, &style_bg);
        lv_slider_set_style(R, LV_SLIDER_STYLE_INDIC,&style_indic_R);
        lv_slider_set_style(R, LV_SLIDER_STYLE_KNOB, &style_knob);
        lv_obj_set_event_cb(R, Reglage_R_RGB);
        Val_R = lv_label_create(Page, NULL);
        lv_obj_align(Val_R, R, LV_ALIGN_OUT_TOP_MID, 0, -5);
        sprintf(text, " %d ", lv_slider_get_value(R));
        lv_label_set_text(Val_R, text);
    }
    
    //PAGE 301 SELECTION LANGUE
    if (Num==301){
        //TITRE
        label = lv_label_create(Page, NULL);        
        lv_label_set_text(label, _("SELECTION LANGUE"));
        lv_obj_align(label, Page, LV_ALIGN_IN_TOP_MID, 0, 5);
        
        //BP SELECTION LANGUE: FRANCAIS        
        lv_obj_t * LANGUE_FR = lv_btn_create(Page, NULL);        
        lv_obj_align(LANGUE_FR, Page, LV_ALIGN_IN_TOP_MID, -80, 50);
        label = lv_label_create(LANGUE_FR, NULL);
        lv_label_set_text(label, _("Francais"));
        lv_obj_set_size(LANGUE_FR,100,40);
        lv_obj_set_event_cb(LANGUE_FR, LANGUE_FR_ACT);
        
        //BP SELECTION LANGUE: ANGLAIS
        lv_obj_t * LANGUE_EN = lv_btn_create(Page, NULL);        
        lv_obj_align(LANGUE_EN, Page, LV_ALIGN_IN_TOP_MID, 80, 50);
        label = lv_label_create(LANGUE_EN, NULL);
        lv_label_set_text(label, _("English"));
        lv_obj_set_size(LANGUE_EN,100,40);
        lv_obj_set_event_cb(LANGUE_EN, LANGUE_EN_ACT);
    }
    

}




//********************
// POPUP CONNEXION MDP
//********************
static void AFFPopupMDP(){
    //FOND GRISE 
    static lv_style_t modal_style;
    lv_style_copy(&modal_style, &lv_style_plain_color);
    modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
    modal_style.body.opa = LV_OPA_50;
    FondGris = lv_obj_create(lv_scr_act(), NULL);
    lv_obj_set_style(FondGris, &modal_style);
    lv_obj_set_pos(FondGris, 0, 0);
    lv_obj_set_size(FondGris, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_opa_scale_enable(FondGris, true); 
    
    // CREATION POPUP CONNEXION MDP
    PopupMDP = lv_obj_create(FondGris, NULL);
    lv_obj_set_size(PopupMDP,400,260); 
    lv_obj_align(PopupMDP, FondGris, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_opa_scale_enable(PopupMDP, true);
    lv_obj_set_opa_scale(PopupMDP, 240);
    
    //TITRE
    label = lv_label_create(PopupMDP, NULL);        
    lv_label_set_text(label, _("IDENTIFICATION"));
    lv_obj_align(label, PopupMDP, LV_ALIGN_IN_TOP_MID, 0, 3);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
    
    //CREATION LISTE UTILISATEUR POUR AFFICHAGE
    //G/ABOR: Mabye you have a better solution than:
    //ROMAIN: There is no much better way, but I have a few comments
    int i; 
    int j; 
    int k=0; 
    char p[2200];    
    
    //ROMAIN:
    // - p[i]=='\0'; it should be p[i]='\0'; isn't it?
    // - If so why not start from i = 0 to initalize?
    // - memset(p, '\0', sizeof(p)) can be a clearer option to initialize
    for (i = 1; i < 2200; i++) { p[i]=='\0';}    
    
    for (i = 1; i < 100; i++) { //ROMAIN: Why start from 1?
        string s=User[i].Nom; 
        if (s.length()>0){
            //ROMAIN: I suggest using memcpy instead
            // memcpy(&p[k], s, s.length())
            // k += s.length();
            // p[k] = '\n';
            // k++;
            for (j = 0; j < s.length(); j++) { 
                p[k] = s[j];
                k++;
            } 
            p[k]='\n';
            k++;
        }
    }    
    //ROMAIN: 
    // - you alraedy incremented k, so it should p[k] = '\0', shouldn't it?
    // - and you initialized p to '\0' so it's not required 
    p[k+1]='\0'; 
    char * ListeUser= p  ;
    
    //SELECTEUR UTILISATEUR    
    SelectID = lv_roller_create(PopupMDP, NULL);
    lv_roller_set_options(SelectID,ListeUser,LV_ROLLER_MODE_NORMAL);
    lv_roller_set_visible_row_count(SelectID, 9);  
    lv_roller_set_fix_width(SelectID, 170);
    lv_obj_align(SelectID, PopupMDP, LV_ALIGN_IN_TOP_LEFT, 10, 20); 
 
    //CHAMPS MOT DE PASSE
    MDP = lv_ta_create(PopupMDP, NULL);
    lv_ta_set_text(MDP, "");
    lv_ta_set_pwd_mode(MDP, true);
    lv_ta_set_one_line(MDP, true);
    lv_obj_set_width(MDP, 170);
    lv_obj_align(MDP, PopupMDP, LV_ALIGN_IN_TOP_RIGHT, -10, 20); 
    lv_obj_set_opa_scale_enable(MDP, true);
    lv_obj_set_opa_scale(MDP, LV_OPA_COVER); 
    lv_ta_set_max_length(MDP, 4);
        
    // PAVE NUMERIQUE SAISIE MOT DE PASSE
    static lv_style_t rel_style, pr_style; //STYLE CLAVIER
    lv_style_copy(&rel_style, &lv_style_btn_rel);
    rel_style.body.radius = 0;
    rel_style.body.border.width = 1;
    lv_style_copy(&pr_style, &lv_style_btn_pr);
    pr_style.body.radius = 0;
    pr_style.body.border.width = 1;
  
    lv_obj_t * PaveNumerique = lv_kb_create(PopupMDP, NULL);
    lv_obj_set_size(PaveNumerique,170,170);     
    lv_btnm_set_map(PaveNumerique, PAVE_NUMERIQUE_MAP);
    lv_btnm_set_btn_width(PaveNumerique, 10, 2);       
    lv_obj_align(PaveNumerique, PopupMDP, LV_ALIGN_IN_TOP_RIGHT, -10, 50); 
    lv_obj_set_opa_scale_enable(PaveNumerique, true);
    lv_obj_set_opa_scale(PaveNumerique, LV_OPA_COVER);     
    lv_kb_set_cursor_manage(PaveNumerique, true);
    lv_kb_set_style(PaveNumerique, LV_KB_STYLE_BG, &lv_style_transp_tight);
    lv_kb_set_style(PaveNumerique, LV_KB_STYLE_BTN_REL, &rel_style);
    lv_kb_set_style(PaveNumerique, LV_KB_STYLE_BTN_PR, &pr_style);     
    lv_kb_set_ta(PaveNumerique, MDP);    //ASSOCIATION CLAVIER ET CHAMPS MDP
    
    // STYLE DES BOUTONS       
    lv_style_copy(&Style_BP, &lv_style_btn_rel);   
    Style_BP.text.font = &lv_font_roboto_12; 
    Style_BP.body.main_color = LV_COLOR_MAKE(R3, G3, B3);
        
    //BP VALIDER
    lv_obj_t * BpValidMDP=lv_btn_create(PopupMDP, NULL);     
    lv_btn_set_style(BpValidMDP, LV_BTN_STYLE_REL,&Style_BP);
    lv_obj_set_size(BpValidMDP,100,30);     
    lv_obj_align(BpValidMDP, PopupMDP, LV_ALIGN_IN_BOTTOM_MID, -60, -5); 
    label = lv_label_create(BpValidMDP, NULL);        
    lv_label_set_text(label, "Valider");
    lv_obj_set_drag_parent(BpValidMDP, true);
    lv_obj_set_event_cb(BpValidMDP, BpValidMDP_ACT);
    lv_obj_set_opa_scale_enable(BpValidMDP, true);
    lv_obj_set_opa_scale(BpValidMDP, LV_OPA_COVER); 
        
    //BP ANNULER
    lv_obj_t * BpAnnulMDP=lv_btn_create(PopupMDP, NULL); 
    lv_btn_set_style(BpAnnulMDP, LV_BTN_STYLE_REL,&Style_BP);
    lv_obj_set_size(BpAnnulMDP,100,30); 
    lv_obj_align(BpAnnulMDP, PopupMDP, LV_ALIGN_IN_BOTTOM_MID, 60, -5); 
    label = lv_label_create(BpAnnulMDP, NULL);        
    lv_label_set_text(label, _("Annuler"));      
    
    lv_obj_set_drag_parent(BpAnnulMDP, true);
    lv_obj_set_event_cb(BpAnnulMDP, BpAnnulMDP_ACT);
    lv_obj_set_opa_scale_enable(BpAnnulMDP, true);
    lv_obj_set_opa_scale(BpAnnulMDP, LV_OPA_COVER);

}

static void BpValidMDP_ACT(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        //RECUPERATION DU NOM DE L'UTILISATEUR SELECTIONNE
        char NomSelect[20];        
        lv_roller_get_selected_str(SelectID, NomSelect, sizeof(NomSelect));
         
        //RECUPERATION MOT DE PASSE SAISIE 
        string MdpSaisie;
        MdpSaisie = lv_ta_get_text(MDP);
        
        //FOND GRISE 
        static lv_style_t modal_style;
        lv_style_copy(&modal_style, &lv_style_plain_color);
        modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
        modal_style.body.opa = LV_OPA_50;
        FondGris2 = lv_obj_create(lv_scr_act(), NULL);
        lv_obj_set_style(FondGris2, &modal_style);
        lv_obj_set_pos(FondGris2, 0, 0);
        lv_obj_set_size(FondGris2, LV_HOR_RES, LV_VER_RES);
        lv_obj_set_opa_scale_enable(FondGris2, true); 
        //COMPARAISON AVEC LISTE           
        static const char * btns2[] = {"Ok", ""}; 
        for (int i = 1; i < 100; i++) { 
            if (User[i].Nom==NomSelect)
                if (User[i].MDP==MdpSaisie){                   
                    mbox=lv_mbox_create(FondGris2, NULL);
                    lv_mbox_add_btns(mbox, btns2);
                    if (User[i].Niveau==1){sprintf(text2, "qu'operateur" );}
                    if (User[i].Niveau==2){sprintf(text2, "que superviseur");}  
                    if (User[i].Niveau==3){sprintf(text2, "que constructeur");}                    
                    sprintf(text, "Connexion autorisee a %s en tant %s pour une duree de %d min",User[i].Nom ,text2,User[i].Tps );
                    lv_mbox_set_text(mbox, text);
                    lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
                    lv_obj_set_event_cb(mbox, mboxMdp_ACT);                      
                    TpsMdpEnCours=User[i].Tps*60;
                    UserEC=User[i];                           
                    //RECLASSEMENT DU TABLEAU DES UTILISATEURS POUR AVOIR LE DERNIER CONNECTé EN PREMIER
                    User[0]=User[i];
                    for (int j = i; j >0; j--) { //DECALAGE TABLEAU
                       User[j]=User[j-1]; 
                    }
                    return;
                }           
         }  
         mbox=lv_mbox_create(FondGris2, NULL);
         lv_mbox_add_btns(mbox, btns2);
         lv_mbox_set_text(mbox, "MOT DE PASSE ERRONE");
         lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
         lv_obj_set_event_cb(mbox, mboxMdp_ACT2);                
    }
}
static void BpAnnulMDP_ACT(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
       // lv_obj_del_async(PopupMDP);
        lv_obj_del_async(FondGris);
    }
}

static void mboxMdp_ACT(lv_obj_t * obj, lv_event_t event)
{     
    lv_obj_del_async(FondGris);
    lv_obj_del_async(FondGris2);
    
  
}
static void mboxMdp_ACT2(lv_obj_t * obj, lv_event_t event)
{
    lv_obj_del_async(FondGris2);   
    lv_ta_set_text(MDP, "");
}


//**************************
// ACTION BOUTONS MENUS
//**************************

static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_PRESSING) {
        Reglage_R= lv_slider_get_value(obj);
        sprintf(text, " %d ",Reglage_R );
        lv_label_set_text(Val_R, text);
    }
}

static void BPRAZ_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        TpsMinEntre2Puls=999999;
        TpsMaxEntre2Puls=0;
        CptPuls=0;   
        Volume=0;
        for (NumDent=20;NumDent>0;NumDent--){
               TpsEntre2Puls[NumDent]=0;    
               MemTpsPuls=0;  
               MemTps16Puls=0;
        }
    }
}
static void BPPOMPE_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        DO_POMPE=!DO_POMPE;
    }
}
static void LANGUE_FR_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {       
        lv_i18n_set_locale("fr");     
        AFFBandeauHaut(0);
        AFFPage(PageAff);
    }
}
static void LANGUE_EN_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {        
       lv_i18n_set_locale("en-GB");       
       AFFBandeauHaut(0);
       AFFPage(PageAff);
   }
}
static void M100_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M100);
        DdeAlignMenu=1;
        NumSousMenu=100;
    }
}
static void M200_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M200);
        DdeAlignMenu=1;
        NumSousMenu=200;
    }
}
static void M300_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M300);
        DdeAlignMenu=1;
        NumSousMenu=300;
    }
}
static void M400_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M400);
        DdeAlignMenu=1;
        NumSousMenu=400;
    }
}
static void M500_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M500);
        DdeAlignMenu=1;
        NumSousMenu=500;
    }
}
static void M600_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M600);
        DdeAlignMenu=1;
        NumSousMenu=600;
    }
}
//**************************
// ACTION BOUTONS SOUS MENUS
//**************************
static void SM101_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
            AFFPage(101);
        }
    }
}

static void SM102_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}
static void SM103_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}
static void SM104_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}
static void SM105_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}

static void SM201_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}
static void SM202_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;
        }
    }
}


static void SM301_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){            
            AFFPopupMDP();
        }    
        else{               
            TpsAvFermSousMenu=0;            
            AFFPage(301);
        }
    }
}


//********************
// FONCTIONS GENERALES
//********************
void lv_ticker_func()
{
    lv_tick_inc(5); //Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). It is required for the internal timing of LittlevGL.
}

//FONCTION D'AFFICHAGE
void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p)
{
    //The most simple case (but also the slowest) to put all pixels to the screen one-by-one
    uint16_t x, y;
    for(y = area->y1; y <= area->y2; y++) {
        for(x = area->x1; x <= area->x2; x++) {

            lcd.DrawPixel( x, y, color_p->full);
            color_p++;
        }
    }

    // IMPORTANT!!!
    // Inform the graphics library that you are ready with the flushing
    lv_disp_flush_ready(disp_drv);
}

//FONCTION RECUPERATION COORDONNEES APPUI
bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data)
{
    static lv_coord_t last_x = 0;
    static lv_coord_t last_y = 0;

    //Save the state and save the pressed coordinate
    ts.GetState(&TS_State);

    if(TS_State.touchDetected == 1) {
        data->state = LV_INDEV_STATE_PR;
    } else {
        data->state = LV_INDEV_STATE_REL;
    }

    //data->state = tttt ? LV_INDEV_STATE_PR : LV_INDEV_STATE_REL;
    //  if(data->state == LV_INDEV_STATE_PR){
    if(data->state == LV_INDEV_STATE_PR) {
        //touchpad_get_xy(&last_x, &last_y);
        last_x = TS_State.touchX[0];
        last_y = TS_State.touchY[0];
    }

    //Set the coordinates (if released use the last pressed coordinates)
    data->point.x = last_x;
    data->point.y = last_y;

    X = TS_State.touchDetected ;



    return false; //Return `false` because we are not buffering and no more data to read
}

