#include "mbed.h"

#ifndef    __PINS_H__
#define    __PINS_H__

//#define HW_V3
#define HW_V4

#ifdef HW_V3
    //Communication interfaces
    #define P_UARTTX    p14
    #define P_UARTRX    p13
    
    #define P_I2CSDA    p18
    #define P_I2CSCL    p20
    
    #define P_SPIMOSI   p11
    #define P_SPIMISO   p15
    #define P_SPISCK    p16
    
    //Chip select
    #define P_AFECS     p10
    #define P_MEMCS     p22
    
    //Interrupt inputs
    #define P_ACC_INT   p31
    #define P_MAG_INT   p30
    #define P_BUTTON    p1
    
    //Pulse sensor dedicated pins
    #define P_AFEDIAG   p6
    #define P_AFERST    p8
    #define P_AFEPDN    p9
    #define P_AFEDRDY   p12
    
    //Power management and miscellaneous
    #define P_CHRG      p0
    #define P_PGOOD     p3
    #define P_STBY      p5
    #define P_PWR_EN    p7
    #define P_TEMP_EN   p24
    #define P_BATT_EN   p2
    
    #define P_VIB       p21
    
    #define P_AMB_TEMP  p26
    #define P_BATT_IN   p27
    
    #define A_TEMP_SKIN 0x3E
#endif

#ifdef HW_V4
    //Communication interfaces
    #define P_UARTTX    p14
    #define P_UARTRX    p13
    
    #define P_I2CSDA    p18
    #define P_I2CSCL    p20
    
    #define P_SPIMOSI   p11
    #define P_SPIMISO   p15
    #define P_SPISCK    p16
    
    //Chip select
    #define P_AFECS     p10
    #define P_MEMCS     p22
    
    //Interrupt inputs
    #define P_ACC_INT   p31
    #define P_MAG_INT   p30
    #define P_BUTTON    p24
    
    //Pulse sensor dedicated pins
    #define P_AFEDIAG   p6
    #define P_AFERST    p8
    #define P_AFEPDN    p9
    #define P_AFEDRDY   p12
    
    //Power management and miscellaneous
    #define P_CHRG      p23
    #define P_STBY      p5
    #define P_PWR_EN    p7
    #define P_BATT_EN   p2
    
    #define P_VIB       p21
    #define P_VIB_EN    p19
    
    #define P_AMB_TEMP  p5
    #define P_BATT_IN   p1
    
    #define P_VUSB      p3
    
    #define A_TEMP_SKIN 0x3E
#endif

#endif // __PINS_H__