#include "mbed.h"
#include "flash.h"
#include "pins.h"

Serial pc(p14, p13);
SPI spi(P_SPIMOSI,P_SPIMISO,P_SPISCK);
Flash flash(&spi);

DigitalOut memcs(P_MEMCS);
DigitalOut afecs(P_AFECS);

int main()
{
    spi.format(8,0);
    spi.frequency(1000000);
    
    pc.baud(115200);
    NRF_UART0->PSELRTS = 0xFFFFFFFF;
    NRF_UART0->PSELCTS = 0xFFFFFFFF;
    printf("Init\r\n");

    // Disable HR sensor SPI
    memcs = 1;
    afecs = 0;
    spi.write(0);
    spi.write(0);
    spi.write(0);
    spi.write(0);
    spi.write(0x31);
    spi.write(0x00);
    spi.write(0x80);
    spi.write(0x12);
    afecs = 1;
    
    flash.init();
    printf("Flash init DONE\r\n");
}
