#ifndef __FLASH_H__
#define __FLASH_H__

#include "mbed.h"
#include "MX25L4006E.h"

#define LAST_MEMORY_ADDR             0x07FFFF
#define LAST_DATA_ADDR               0x07FFF8 // floor((LAST_MEMORY_ADDR-NEXT_WRITTING_ADDR_INIT)/DATA_BLOCK_SIZE)

#define ADDR_MEMORY_MARK             0x000000
#define ADDR_NEXT_WRITING            0x000004
#define ADDR_NEXT_READING            0x000007

#define INIT_VAL_MEMORY_MARK             0xAAAAAAAA
#define INIT_VAL_NEXT_WRITING_ADDR       0x010000
#define INIT_VAL_NEXT_READING_ADDR       0x010000

class Flash {
public:
    Flash(SPI *spi);
    bool init(void);

    struct DataStruct {
        uint8_t struct_type;
        int32_t timestamp;
        int32_t data;
    };
    
    void writeData(DataStruct d);
    DataStruct readData(uint32_t addr);    
    void bulkReadData(void);
    
    // DEBUG FUNCTIONS
    void printData();
    void generateDumbData();
    
private:
    MX25L4006E memory;
    
    // Address of the next data structure to be written in the memory
    uint32_t nextWritingAddr;
    // Address of the next data structure to be sent to the mobile app
    uint32_t nextReadingAddr;
    
    void resetConfigSector(void);

    AnalogIn batt;

    // DEBUG FUNCTION
    void printFlash(uint32_t address, uint32_t length);
};

#endif /* __FLASH_H__ */