#include "flash.h"

Flash::Flash(SPI *spi) :
    memory(spi),
    batt(P_BATT_IN)
    {

    }

/*
 * THIS IS JUST A TEST METHOD, DON NOT USE IN PRODUCTION FW
 */
bool Flash::init()
{

    if (memory.init()) {
        printf("Starting a test on the flash memory----------------------------------------\r\n\r\n");
        
        /*
         * Print initial state of the memory before writing/reading anything else.
         */
        printf("Initial state of the memory...\r\n");
        printFlash(0, 16);
        
        /*
         * Print memory after a sector erase (should contain all 0xFF)
         */
        memory.CMD_SE(0);
        printf("Memory after erasing sector (should be 0xFF)...\r\n");
        printFlash(0, 16);
        
        uint32_t buff_read;        
        memory.CMD_READ(ADDR_MEMORY_MARK, (uint8_t *) &buff_read, 4);
        if (buff_read != 0xFFFFFFFF) {
            printf("*******************************\r\n");
            printf("********* FLASH ERROR *********\r\n");
            printf("*******************************\r\n");
            return false;
        }
        
        /*
         * Print memory after initialization and after writing 4 positions
         */
        printf("Initializing memory\r\n");        
        resetConfigSector();

        srand((uint32_t)batt.read_u16());
        uint32_t val = rand(); //0xABCDEF12;
        uint32_t val_read;
        if( memory.CMD_PP(12, (uint8_t *) &val, 4) == MX25L4006E::FlashOperationSuccess ) printf("Exito escribiendo\r\n");
        memory.CMD_READ(12, (uint8_t *) &val_read, 4);
        
        printf("Memory after initialization and writing 0x%08X in position 0x0000000C...\r\n", val);
        printFlash(0, 16);
        if (val != val_read) {
            printf("*******************************\r\n");
            printf("********* FLASH ERROR *********\r\n");
            printf("*******************************\r\n");
            return false;
        }

        printf("Flash OK\r\n");
        printf("End of the test -----------------------------------------------------------\r\n\r\n");

        return true;
    } else {
        return false;
    }
}

void Flash::resetConfigSector()
{
    uint32_t buff_write = INIT_VAL_MEMORY_MARK;    
    uint32_t val;
    
    // erase all sectors
    //memory.CMD_SE(0);    <<<---------------------------- Commented just in this test project (NOT IN THE REAL FW)
    
    // set initial values
    memory.CMD_PP(ADDR_MEMORY_MARK, (uint8_t *)&buff_write, 4);
    val = INIT_VAL_NEXT_WRITING_ADDR;
    memory.CMD_PP(ADDR_NEXT_WRITING, (uint8_t *)&val, 3);
    val = INIT_VAL_NEXT_READING_ADDR;
    memory.CMD_PP(ADDR_NEXT_READING,  (uint8_t *)&val, 3);
    
    return;
}

void Flash::writeData(DataStruct d)
{
    printf("ADDR 0x%08X %i,%i,%u\r\n", nextWritingAddr, d.struct_type, d.timestamp, (uint8_t) d.data);
    memory.CMD_PP(nextWritingAddr, (uint8_t *) &d.struct_type, 1);
    nextWritingAddr++;
    memory.CMD_PP(nextWritingAddr, (uint8_t *) &d.timestamp, 4);
    nextWritingAddr+=4;
    memory.CMD_PP(nextWritingAddr, (uint8_t *) &d.data, 4);
    nextWritingAddr+=4;
    
    if (nextWritingAddr == LAST_DATA_ADDR)
        nextWritingAddr = INIT_VAL_NEXT_WRITING_ADDR;
        
    memory.CMD_PP(ADDR_NEXT_WRITING, (uint8_t *)&nextWritingAddr, 3);

    return;
}

void Flash::bulkReadData()
{
    short saveReadingAddr = 0; // to save in flash memory the next reading address only each (10) read blocks
    DataStruct d;
    
    while(nextReadingAddr != nextWritingAddr)
    {
        d = readData(nextReadingAddr);
        nextReadingAddr+=9;
          
        if (nextReadingAddr == LAST_DATA_ADDR)
            nextReadingAddr = INIT_VAL_NEXT_READING_ADDR;

        if (saveReadingAddr < 10)
        {
            memory.CMD_PP(ADDR_NEXT_READING, (uint8_t *)&nextReadingAddr, 3);
            saveReadingAddr++;
        }
        else
        {
            saveReadingAddr = 0;
        }
        // TODO send data over BT
    }
    memory.CMD_PP(ADDR_NEXT_READING, (uint8_t *)&nextReadingAddr, 3);
    
    return;
}

Flash::DataStruct Flash::readData(uint32_t addr)
{
    DataStruct d;
    uint8_t buffer[4];

    memory.CMD_READ(addr, (uint8_t *) &d.struct_type, 1);
    memory.CMD_READ(addr+1, buffer, 4);
    d.timestamp = (uint32_t) buffer[0] + ((uint32_t) buffer[1] << 8) + ((uint32_t) buffer[2] << 16) + ((uint32_t) buffer[3] << 24);
    memory.CMD_READ(addr+5, buffer, 4);
    d.data = (uint32_t) buffer[0] + ((uint32_t) buffer[1] << 8) + ((uint32_t) buffer[2] << 16) + ((uint32_t) buffer[3] << 24);

    return d;
}


// ------------------------------------------------
//              DEBUG FUNCTIONS
// ------------------------------------------------
void Flash::printData()
{
    uint32_t addr = INIT_VAL_NEXT_READING_ADDR;
    DataStruct d;
    printFlash(INIT_VAL_NEXT_READING_ADDR, 18);
    while(addr != nextWritingAddr)
    {
        d = readData(addr);
        switch(d.struct_type)
        {
            case 0:
                printf("Heart Rate,%i,%u\r\n", d.timestamp, (uint8_t) d.data);
                break;
            case 1:
                printf("Steps,%i,%u\r\n", d.timestamp, (uint32_t) d.data);
                break;
            case 2:
                printf("X-axis,%i,%u\r\n", d.timestamp, (uint8_t) d.data);
                break;                    
            case 3:
                printf("Y-axis,%i,%u\r\n", d.timestamp, (uint8_t) d.data);
                break;
            case 4:
                printf("Z-axis,%i,%u\r\n", d.timestamp, (uint8_t) d.data);
                break;
            case 5:
                printf("XYZ-axis,%i,%u\r\n", d.timestamp, (uint8_t) d.data);
                break;
            case 6:
                printf("Amb temp,%i,%i\r\n", d.timestamp, (int8_t) d.data);
                break;
            case 7:
                printf("Skin temp,%i,%i\r\n", d.timestamp, (int8_t) d.data);
                break;
            default:
                printf("Incorrect structure type (%u) at addr 0x%08X\r\n", d.struct_type, addr);
        }
        addr+=9;
    }
}

void Flash::printFlash(uint32_t address, uint32_t length)
{
    uint8_t buff_read[length];
    memory.CMD_READ(address, buff_read, length);
    printf("   ADDR      |   VAL\r\n");
    printf("---------------------\r\n");       
    for (int i=0 ; i<length ; i++)
        printf("0x%08X   |   0x%02X\r\n", address++, buff_read[i]);
        
    return;
}

void Flash::generateDumbData()
{
    printf("Generating dumb data... ");
    DataStruct d;
    d.struct_type = 0;
    d.timestamp = 10000;
    d.data = 25;
            
    for(int i=0 ; i<20 ; i++)
    {
        writeData(d);

        if (++d.struct_type == 8) d.struct_type = 0;
        d.timestamp+=10000;
        d.data+=5;        
    }
    printf("DONE\r\n");
    return;
}