/*
 * np_app_ncn_interface.c
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#include "np_config.h"
#include "np_app_ncn_interface.h"
#include "np_app_spi.h"
#include "np_app_crc.h"
#include "np_command.h"
#include "np_apis.h"
#include "np_app_pm.h"
#include "np_driver_pm.h"
#include "np_system.h"

uint8_t mdk_app_version[3] = {0x00};	//the code of developer version
uint8_t mdk_mdk_version[3] = {0x00};	//the mdk version
uint8_t t_message[64];					// buffer for message cache
uint8_t source_address;					// the message is coming from this port address
volatile uint8_t flag_jump_bsl;			//uint8_t flag_jump_bsl = 0x00;
uint8_t my_node 			= 0x00;		// To record "this" module's node number

/*
 * Description:MDK set a manually output address for next POST message
 * Parameter: null
 * Return: null
 */
void np_function_set_post_address(uint8_t address) {
	source_address = address;
}

/*
 * Description: get one message from the FIFO buffer
 * Parameter  : pData - pointer of the space for hold the one message
 * Return     : the length of the message
 */
uint8_t np_function_ncn_interface_get_message(uint8_t *pData) {
	uint8_t t_i = 0x00;

	// Clean the usage
	spi_get_buf.used_buffer_length -= spi_get_buf.message_len[spi_get_buf.readout_message_pointer];
	// Case If:
	// One message over 79 to another 0 to 79 loop
	// Case else:
	// One message from n to m, but n and m is one same 0 to 79 loop
	if ( (spi_get_buf.readout_buffer_pointer + spi_get_buf.message_len[spi_get_buf.readout_message_pointer]) > FIFO_BUFFER_OVERLOAD ) {
		// Read until pointer reach 79
		while (spi_get_buf.readout_buffer_pointer <= FIFO_BUFFER_OVERLOAD ) {
			pData[t_i++] = spi_get_buf.buffer[spi_get_buf.readout_buffer_pointer++];
			spi_get_buf.message_len[spi_get_buf.readout_message_pointer]--;
		}
		// Pointer reset to 0
		spi_get_buf.readout_buffer_pointer = 0;
		// Read out the rest
		while ( spi_get_buf.message_len[spi_get_buf.readout_message_pointer] ) {
			pData[t_i++] = spi_get_buf.buffer[spi_get_buf.readout_buffer_pointer++];
			spi_get_buf.message_len[spi_get_buf.readout_message_pointer]--;
		}
	} else {
		while ( spi_get_buf.message_len[spi_get_buf.readout_message_pointer] ) {
			pData[t_i++] = spi_get_buf.buffer[spi_get_buf.readout_buffer_pointer++];
			spi_get_buf.message_len[spi_get_buf.readout_message_pointer]--;
		}
	}

	spi_get_buf.readout_message_pointer++;
	if ( spi_get_buf.readout_message_pointer > FIFO_MESSAGE_OVERLOAD)
		spi_get_buf.readout_message_pointer = 0;
	return t_i;
}

/*
 * Description: add one message into the FIFO buffer
 * Parameter: 
 * 		command :The command of this message;
 * 		pData   :pointer of the new parameters inside the message,
 * 		pLen 	:the length of the parameters
 * Return: null
 */
uint8_t np_function_ncn_interface_post_message(uint16_t command, uint8_t *pData, uint8_t pLen) {
	uint8_t		t_i = 0x00;
	uint16_t	t_crc16 = 0x0000;
	uint8_t		message_len = 0x00;

	message_len = pLen+11;
	if ( (spi_post_buf.used_buffer_length+message_len) > FIFO_BUFFER_OVERLOAD ) {
		// Over buffer, ERROR!
		return 1;
	}
	// Assembling a message for sending out
	t_message[0] = 0x7E;
	t_message[1] = my_node;
	t_message[2] = source_address;
	t_message[3] = pLen+3;
	t_message[4] = command>>8;
	t_message[5] = command;
	t_message[6] = pLen;
	for ( t_i = 0; t_i < pLen; t_i++ )
		t_message[7+t_i] = pData[t_i];
	t_crc16 = np_function_crc_calculate(&t_message[1], pLen+6);
	t_message[7+pLen] = t_crc16>>8;
	t_message[8+pLen] = t_crc16;
	t_message[9+pLen] = 0x7E;
	t_message[10+pLen] = '$';	//keep first TX byte of next communication is '$' .Meaningless on here

	// Fill in the information into the POST FIFO structure
	spi_post_buf.used_buffer_length += message_len;
	spi_post_buf.message_len[spi_post_buf.fillin_message_pointer++] = message_len;
	if ( spi_post_buf.fillin_message_pointer > FIFO_MESSAGE_OVERLOAD ) {
		spi_post_buf.fillin_message_pointer = 0;
	}
	t_i = 0;
	// Caes if:
	// The reset of the space need to put into the next buffer loop
	// Case else:
	// The reset of the space enough in the same buffer loop
	if ( (spi_post_buf.fillin_buffer_pointer+message_len) > FIFO_BUFFER_OVERLOAD ) {
		while ( spi_post_buf.fillin_buffer_pointer <= FIFO_BUFFER_OVERLOAD ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
		spi_post_buf.fillin_buffer_pointer = 0;
		while ( message_len ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
	} else {
		while ( message_len ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
	}

	spi_post_buf.message_num++;

	return 0;
}

/*
 * Description: add one message into the FIFO buffer, but information especially to Gateway
 * Parameter: 
 * 		command :The command of this message;
 * 		pData   :pointer of the new parameters inside the message,
 * 		pLen 	:the length of the parameters
 * Return: null
 */
uint8_t np_function_ncn_interface_post_message_to_station(uint16_t command, uint8_t *pData, uint8_t pLen) {
	uint8_t 	t_i = 0x00;
	uint16_t 	t_crc16 = 0x0000;
	uint8_t 	message_len = 0x00;

	message_len = pLen+11;
	if ( (spi_post_buf.used_buffer_length+message_len) > FIFO_BUFFER_OVERLOAD ) {
		// Over buffer, ERROR!
		return 1;
	}
	// Assembling a message for sending out
	t_message[0] = 0x7E;
	t_message[1] = my_node;
	t_message[2] = 0x01;
	t_message[3] = pLen+3;
	t_message[4] = command>>8;
	t_message[5] = command;
	t_message[6] = pLen;
	for ( t_i = 0; t_i < pLen; t_i++ )
		t_message[7+t_i] = pData[t_i];
	t_crc16 = np_function_crc_calculate(&t_message[1], pLen+6);
	t_message[7+pLen] = t_crc16>>8;
	t_message[8+pLen] = t_crc16;
	t_message[9+pLen] = 0x7E;
	t_message[10+pLen] = '$';	//keep first TX byte of next communication is '$' .Meaningless on here

	// Fill in the information into the POST FIFO structure
	spi_post_buf.used_buffer_length += message_len;
	spi_post_buf.message_len[spi_post_buf.fillin_message_pointer++] = message_len;
	if ( spi_post_buf.fillin_message_pointer > FIFO_MESSAGE_OVERLOAD ) {
		spi_post_buf.fillin_message_pointer = 0;
	}
	t_i = 0;
	// Caes if:
	// The reset of the space need to put into the next buffer loop
	// Case else:
	// The reset of the space enough in the same buffer loop
	if ( (spi_post_buf.fillin_buffer_pointer+message_len) > FIFO_BUFFER_OVERLOAD ) {
		while ( spi_post_buf.fillin_buffer_pointer <= FIFO_BUFFER_OVERLOAD ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
		spi_post_buf.fillin_buffer_pointer = 0;
		while ( message_len ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
	} else {
		while ( message_len ) {
			spi_post_buf.buffer[spi_post_buf.fillin_buffer_pointer++] = t_message[t_i++];
			message_len--;
		}
	}

	spi_post_buf.message_num++;


	return 0;
}


/*
 * Description: unpack the message and process it, here is the core of the message(s),
 * 				received -> understanding -> process
 * Parameter: null
 * Return: null
 */
void np_function_ncn_interface_parse(void) {
	uint16_t t_crc_value = 0x0000;
	uint16_t command = 0x0000;

	np_function_ncn_interface_get_message(t_message);

	// CRC16 Check
	t_crc_value = t_message[4+t_message[3]];
	t_crc_value = (t_crc_value<<8)|t_message[5+t_message[3]];
	if ( np_function_crc_check(&t_message[1], t_message[3]+3, t_crc_value) ) {
		// CRC16 NOT pass
		return;
	}

	// If this message is for me?
	if ( t_message[2] != my_node ) {
		// NOT for me
		return;
	}

	np_function_set_post_address(t_message[1]);

	// Only one command inside payload, if more than one, this logic need to change
	command = t_message[4];
	command = (command<<8)|t_message[5];

	// Developer command code from 0x2700-0x27ff
	if ( (command >= 0x2700)&&(command <= 0x27ff) ) {
		uint8_t t_i = 0;
		uint8_t t_we_have_response = FALSE;
		// Search and run the right function
		for ( ; t_i < mdk_cmd_func_number; t_i++ ) {
			if ( command == mdk_cmd_func_table_ptr[t_i].command ) {
				mdk_cmd_func_table_ptr[t_i].function(&t_message[7], t_message[6]);
				t_we_have_response = TRUE;
			}
		}
		// If the command is not existing, then we need to response a ERROR
		if ( t_we_have_response == FALSE ) {
			uint8_t data[2];
			data[0] = command >> 8;
			data[0] = command & 0xFF;
			np_function_ncn_interface_post_message(ERROR_NO_CMD, data, 0x02);
		}
	} else {
		// NP define command code
		switch (command) {
		case ASK_APP_INFO:{
			np_function_ncn_interface_post_message(ANS_APP_INFO,
					mdk_app_version, 0x03);
		}
			break;

		case REQ_INTO_BSL:{
			RAM_SOURCE_ADDR = source_address;
	    	flag_jump_bsl = 0x01;
		}
			break;

		case CMD_MDK_REQ_START: {
			uint8_t data = SUCCESS;
//			np_api_start();
			np_function_ncn_interface_post_message(CMD_MDK_RSP_START, &data,
					0x01);
			break;
		}
		case CMD_MDK_REQ_STOP: {
			uint8_t data = SUCCESS;
//			np_api_stop();
			np_function_ncn_interface_post_message(CMD_MDK_RSP_STOP, &data,
					0x01);
			break;
		}

		case CMD_MDK_REQ_LPM4:{
			uint8_t data = SUCCESS;
//			if(t_message[7] == 1){
//				np_function_lpm4_automode_set();
//				if(np_function_pm_mode_get() & LPM_0){
//					np_function_set_run_the_loop(TRUE);
//				}
//			}else if(t_message[7] == 0){
//				if(developer_lpm4_setting == 0){
//					np_function_lpm4_automode_clear();
//				}
//			}
			np_function_ncn_interface_post_message(CMD_MDK_RSP_LPM4, &data,0x01);
		}
		break;

		case ASK_STATUS: {
			uint8_t t_data[1] = { 0x01 };
			np_function_ncn_interface_post_message(ANS_STATUS, t_data, 0x01);
			break;
		}

		case REQ_TEST_COMM:{
			#if CASE_TEST_CODE_ENABLE
			#else
			//MDK version
			np_function_ncn_interface_post_message(RSP_TEST_COMM,mdk_mdk_version, 0x03);
			#endif
		}
		break;

		default: {
			uint8_t data[2];
			data[0] = command >> 8;
			data[1] = command;
			np_function_ncn_interface_post_message(ERROR_NO_CMD, data, 0x02);
			break;
		}
		}
	}
}

/*
 * Description: the message handler
 * Parameter: null
 * Return: null
 */
void np_function_ncn_interface_loop(void) {
	if ( spi_get_buf.message_num ) {
		np_function_ncn_interface_parse();
		spi_get_buf.message_num--;
	}
	if ( spi_status == SPI_BUSY )
		return;
	if ( spi_post_buf.message_num ) {
		if ( np_app_spi_is_aviable() ) {
			np_app_spi_apply_post();
		}
	}
}

