/*
 * np_module_mdk_v1.h
 *	developer call the API of MDK by the include file.
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#ifndef NP_MODULE_MDK_V1_H_
#define NP_MODULE_MDK_V1_H_

#include <stdint.h>

#ifdef __cplusplus
	extern "C" {
#endif

typedef void (*my_VOID_UCUC)(uint8_t*, uint8_t);
typedef void (*app_function)(void);

typedef struct {
	uint16_t	 	command;
	my_VOID_UCUC	function;
} MDK_REGISTER_CMD;

#define MDK_REGISTER_SUCCESS	0x00
#define MDK_REGISTER_FAILD		0x01

void delay_ms(uint32_t t_ms);
/*
 * Description: API to make the app initial by the api
 * Parameter: np_app_setup-the initial function of APP
 * Return: null
 */
void np_api_setup(app_function np_app_setup);

/*
 * Description: initialize mdk
 * Parameter: null
 * Return: null
 */
void np_api_init();

/*
 * Description: signal ready to start
 * Parameter: null
 * Return: null
 */
void np_api_start();

/*
 * Description: check for bootloader request
 * Parameter: null
 * Return: null
 */
void np_api_bsl_chk();

/*
 * Description: API to run the loop function of APP, "np_app_loop()" will run on while(1),running forever when software on app mode
 * Parameter: np_app_loop-the loop function of APP
 * Return: null
 */
void np_api_loop(app_function np_app_loop);

/*
 * Description: API to set app firmware version
 * Parameter: null
 * Return: null
 */
void np_api_set_app_version(uint8_t HV, uint8_t MV, uint8_t LV);
/*
 * Description: API to register developer's command callback function
 * Parameter  : 
 * 		cmd_func_table:the callback function about the command. 
 *			  		   The callback function will be called when MDK get the corresponding command. 
 *		num           :The callback function number
 * Return     : 0-success;  1-fail
 */
uint8_t np_api_register(MDK_REGISTER_CMD* cmd_func_table, uint8_t num);

/*
 * Description: API to upload data to Phone
 * Parameter: 
 *		rcmd : The command of the message.
 *		pData: Pointer of the space for hold the parameter of the message.
 *		pLen : The length of the "pData"
 * Return    : 0-success;  1-fail
 */
uint8_t np_api_upload(uint16_t rcmd,uint8_t *pData, uint8_t pLen);

/*
 * Description: API to upload data to Gateway
 *		rcmd : The command of the message.
 *		pData: Pointer of the space for hold the parameter of the message.
 *		pLen : The length of the "pData"
 * Return    : 0-success;  1-fail
 */
uint8_t np_api_upload_to_station(uint16_t rcmd, uint8_t *pData, uint8_t pLen);

/*
 * Description: API to set a manually output address for next POST message
 * Parameter: address-the source address of next message
 * Return: null
 */
void np_api_set_post_address(uint8_t address);

#ifdef __cplusplus
	}
#endif

#endif /* NP_MODULE_MDK_V1_H_ */
