/*
 * np_driver_pm.c
 *
 *  Created on: 2016714
 *      Author: Alan.Lin
 */

#if 0
uint8_t mdk_auto_lpm_flag = 0;

/*
 * Description: enable the global interrupt
 * Parameter: null
 * Return: null
 *
 * Author: Coody.Liu
 *
 * Copyright: NexPack.Ltd
 */
void np_driver_pm_gie_set(void) {
	__bis_SR_register(GIE);
}

/*
 * Description: disable the global interrupt
 * Parameter: null
 * Return: null
 *
 * Author: Coody.Liu
 *
 * Copyright: NexPack.Ltd
 */
void np_driver_pm_gie_clear(void) {
	__bic_SR_register(GIE);
}

/*
 * Description: entry auto power save mode
 * Parameter: null
 * Return: null
 *
 * Author: Coody.Liu
 *
 * Copyright: NexPack.Ltd
 */
void np_driver_lpm0_automode_set(void) {
	mdk_auto_lpm_flag |= LPM_0;
}

/*
 * Description: exit auto power save mode
 * Parameter: null
 * Return: null
 *
 * Author: Coody.Liu
 *
 * Copyright: NexPack.Ltd
 */
void np_driver_lpm0_automode_clear(void) {
	mdk_auto_lpm_flag &= ~LPM_0;
}

/*
 * Description: enter auto power lpm4 mode
 * Parameter: null
 * Return: null
 *
 * Author: Alan.Lin
 *
 * Copyright: NexPack.Ltd
 */
void np_driver_lpm4_automode_set(void){
	mdk_auto_lpm_flag |= LPM_4;
}
/*
 * Description: exit auto power lpm4 mode
 * Parameter: null
 * Return: null
 *
 * Author: Alan.Lin
 *
 * Copyright: NexPack.Ltd
 */

void np_driver_lpm4_automode_clear(void){
	mdk_auto_lpm_flag &= ~LPM_4;
}

/*
 * Description: get the status of auto power save mode
 * Parameter: null
 * Return: null
 *
 * Author: Coody.Liu
 *
 * Copyright: NexPack.Ltd
 */
uint8_t np_driver_lpm_mode_get(void) {
	return mdk_auto_lpm_flag;
}

#endif
