#include "mbed.h"
#include "nexpaq_mdk.h"

#ifdef __cplusplus
extern "C" {
#endif
extern volatile uint8_t flag_jump_bsl;
#ifdef __cplusplus
}
#endif
DigitalOut ledR(P2_4, LED_OFF);
DigitalOut ledG(P2_5, LED_OFF);
DigitalOut ledB(P2_6, LED_OFF);

AnalogIn ain0(AIN_4);

//Serial pc(P2_1, P2_0); // tx, rx

//DigitalIn button(P0_1, PullUp);

/***** Definitions *****/
#define     FUNCTION_TABLE_NUM                  1
#define     UUID_NUM                            16          //UUID number is 16, don't change it
#define     LOOP_DELAY                          1000
#define PROX_THRESHOLD 50

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
        {0x2700, my_function_CMD_2700},     // Command -> function
};

//int lastBtn = 1;
//unsigned char btnPress = 0x01;
//int lastPrx = 0;
//unsigned char prxPress = 0x02;

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len){
    unsigned char response = 0x00;
    ledR = (pData[0]>0) ? LED_ON : LED_OFF ;
    ledG = (pData[1]>0) ? LED_ON : LED_OFF ;
    ledB = (pData[2]>0) ? LED_ON : LED_OFF ;
    np_api_upload(0x2701, &response, 1);
} 

/******************************************************************************/
void app_setup(){
    time_t initSeconds = 0;
    set_time(initSeconds);
    printf("App Setup \r\n\n");
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
         //Register failed handle code
        error("MDK Register Failed");

   }
}  

void app_loop() {
    unsigned char result = 0.0;
    
    result = ain0.read_u16();
    time_t endSeconds = time(NULL);    
    printf("AIN_0 = %f  Time = %d\r\n", result, endSeconds);   
    ledR = !ledR;
    np_api_upload(0x2800, &result, 1);
 
}

int main(void){
    
    np_api_init();
    app_setup();
    np_api_start(); 
    printf("Hello World\r\n\n");
    while(1){
        Thread::wait(LOOP_DELAY);
        //wait(LOOP_DELAY);
        
        app_loop(); 
        np_api_bsl_chk();
    }

    return 0;
}






