/*
 * np_apis.c
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#include "np_apis.h"
#include "np_app_ncn_interface.h"
#include "np_app_spi.h"
#include "np_system.h"

MDK_REGISTER_CMD *mdk_cmd_func_table_ptr;
uint8_t mdk_cmd_func_number;

/*
 * Description:	APP to set firmware version of APP by the api
 * Parameter:	null
 * Return:		null
 */
void np_api_set_app_version(uint8_t HV, uint8_t MV, uint8_t LV) {
	mdk_app_version[0] = HV;
	mdk_app_version[1] = MV;
	mdk_app_version[2] = LV;
}

/*
 * Description:	APP to register processing function of command by the api
 * Parameter:
 * 		cmd_func_table: pointer of the space for hold the pointer of processing functions.
 *		num			  :	the number of the processing function.
 *
 * Return: 0-success;  1-fail
 */
uint8_t np_api_register(MDK_REGISTER_CMD* cmd_func_table, uint8_t num) {
	uint8_t t_i = 0;
	uint8_t t_num = num;

	for ( ; t_i < t_num; t_i++ ) {
		if ( (cmd_func_table[t_i].command > 0x27ff) || (cmd_func_table[t_i].command < 0x2700) ) {
			return 1;
		}
	}
	mdk_cmd_func_table_ptr = cmd_func_table;
	mdk_cmd_func_number = num;

	return 0;
}

/*
 * Description: APP to upload message to Phone/ble by the api
 * Parameter  : 
 *		rcmd : The command of the message.
 *		pData: Pointer of the space for hold the parameter of the message.
 *		pLen : The length of the "pData"
 *		
 * Return     : 0-success;  1-fail
 */
uint8_t np_api_upload(uint16_t rcmd, uint8_t *pData, uint8_t pLen) {
	// Over the fifo buffer
	if ( spi_post_buf.used_buffer_length + pLen > FIFO_BUFFER_OVERLOAD )
		return 1;
	np_function_ncn_interface_post_message(rcmd, pData, pLen);

	return 0;
}

/*
 * Description: APP to upload data to Gateway by the api
 * Parameter  : 
 *		rcmd : The command of the message.
 *		pData: Pointer of the space for hold the parameter of the message.
 *		pLen : The length of the "pData"
 *		
 * Return     : 0-success;  1-fail

 */
uint8_t np_api_upload_to_station(uint16_t rcmd, uint8_t *pData, uint8_t pLen) {
	// Over the fifo buffer
	if ( spi_post_buf.used_buffer_length + pLen > FIFO_BUFFER_OVERLOAD )
		return 1;
	np_function_ncn_interface_post_message_to_station(rcmd, pData, pLen);

	return 0;
}

/*
 * Description:APP set a manually output address for next POST message
 * Parameter: null
 * Return: null
 */
void np_api_set_post_address(uint8_t address) {
	source_address = address;
}

/*
 * Description: system initial ,include MDK initial and app initial
 * Parameter: null
 * Return: null
 */
void np_api_setup(app_function np_app_setup){
	np_system_initial(np_app_setup);
}

/*
 * Description: system loop function, will loop forever.
 * Parameter: null
 * Return: null
 */
void np_api_loop(app_function np_app_loop){
	np_system_loop(np_app_loop);
}

/*
 * Description: initialize
 * Parameter: null
 * Return: null
 */
void np_api_init(){
	np_sys_init();
}

/*
 * Description: signal ready
 * Parameter: null
 * Return: null
 */
void np_api_start(){
	np_sys_start();
}

/*
 * Description: bootloader check
 * Parameter: null
 * Return: null
 */
void np_api_bsl_chk(){
	np_sys_bsl_chk();
}

#if 0
/*
 * Description: API to set auto enter lpm0 mode
 * Parameter: null
 * Return: null
 */
void np_api_lpm0_automode_set(void) {
	np_function_lpm0_automode_set();
}

/*
 * Description: API to set auto exit lpm0 mode
 * Parameter: null
 * Return: null
 */
void np_api_lpm0_automode_clear(void) {
	np_function_lpm0_automode_clear();
}


uint8_t np_api_lpm_mode_get(void){
	return np_function_pm_mode_get();
}

/*
 * Description: API to get the sleep status about sleeping on lpm0 or lpm4
 * Parameter: null
 * Return: LPM0/LPM4/LPM_NONE
 */
uint8_t np_api_lpm_status_get(void){
	return np_function_get_lpm_status();
}

void np_mdk_set_run_the_loop(uint8_t t_data){
	np_function_set_run_the_loop(t_data);
}

void np_mdk_start_loop_head_set(void){
	wakeup_run_loop_flag = 1;
}

void np_mdk_lpm4_automode_clear_flag(void){
	np_function_lpm4_automode_clear();
}

void np_api_lpm4_automode_set(void) {
	if(np_function_pm_mode_get() & LPM_0){
		np_mdk_set_run_the_loop(TRUE);//if developer set lpm4 on interrupt and firmware is running on lpm0,need wakup lpm0 and enter lpm4
	}

	np_function_lpm4_automode_set();
	developer_lpm4_setting = 1;
}

void np_api_lpm4_automode_clear(void) {
	np_mdk_lpm4_automode_clear_flag();
	np_mdk_start_loop_head_set();
	developer_lpm4_setting = 0;
}

void np_mdk_exit_lpm4_work(void){
	np_function_exit_lpm4_work();
}

#endif
