/*
 * np_app_spi.c
 *
 *  Created on: July 14, 2016
 *      Author: Alan.Lin
 *
 *  Copyright: NexPack Ltd.
 */

#include "np_driver_spi.h"
#include "np_app_spi.h"
#include "mxc_sys.h"

typedef	enum
{
	SPI_IS_READ 	= 0x00,
	SPI_IS_WRITE 	= 0x80
}E_SPIReadWrite;

uint8_t spi_count 		= 0x00;			// The counter inside the SPI transfer process
uint8_t spi_status 		= SPI_FREE;		// SPI_FREE ( we can use the SPI to transfer message), SPI_BUSY (we can NOT use the SPI to transfer message)
uint8_t spi_rw 			= 0x00;			// To record this SPI transfer is a POST or GET process
// The fifo buffer structure design for POST/GET message(s)
FIFO_GET spi_get_buf 	= { {0x00}, {0x00}, 0x00, 0x00, 0x00, 0x00, 0x00 };
FIFO_POST spi_post_buf 	= { {0x00}, {0x00}, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

const gpio_cfg_t gpio_req_spi[] = {
										{ PORT_4, PIN_3, GPIO_FUNC_GPIO, GPIO_PAD_INPUT_PULLUP},	/* Input*/
										{ PORT_4, PIN_3, GPIO_FUNC_GPIO, GPIO_PAD_NORMAL},			/* Output*/
							 	  };

/*
 * Description: to get the message from spi reading data
 * Parameter  : spi_read-the data received by spi slave
 * Return     : null
 */
void np_app_spis_message (uint8_t spi_read) {

	if ( (spi_status == SPI_FREE)&&(spi_read == '$') ) {		//Check the first byte is '$'(0x24).
		spi_status = SPI_BUSY;
		spi_count = 0x00;
		np_driver_spis_put_byte_to_tx_buff(0);
	} else if ( spi_status == SPI_BUSY ) {
		if ( spi_count == 0x00 ) {
			// Get this byte to know if Gateway want to POST/SET message
			spi_rw = spi_read;
			if ( spi_rw == SPI_IS_WRITE ) {
				// Send the high Byte of message length, but the message for module will least then 64 bytes.
				np_driver_spis_put_byte_to_tx_buff(0);
			} else if ( spi_rw == SPI_IS_READ ) {
				np_driver_spis_put_byte_to_tx_buff(0);
			} else {
				np_driver_spis_put_byte_to_tx_buff(0);
				spi_status = SPI_FREE;
			}
		} else if ( spi_count == 0x01 ) {
			if ( spi_rw == SPI_IS_WRITE ) {
				if ( spi_post_buf.message_num ) {
					// Send the low Byte of message length
					np_driver_spis_put_byte_to_tx_buff(spi_post_buf.message_len[spi_post_buf.post_message_pointer]-1);
				} else {
					np_driver_spis_put_byte_to_tx_buff(0);
					spi_status = SPI_FREE;
				}
			} else if ( spi_rw == SPI_IS_READ ) {
				np_driver_spis_put_byte_to_tx_buff(0);
				// Received the high Byte of message length, but the message for module will least then 64 bytes.
				// So we will skip here
			}
		} else if ( spi_count == 0x02 ) {
			if ( spi_rw == SPI_IS_WRITE ) {
				// Send the first byte here
				np_driver_spis_put_byte_to_tx_buff(spi_post_buf.buffer[spi_post_buf.post_buffer_pointer++]);
				// Do NOT over the buffer
				if ( spi_post_buf.post_buffer_pointer > FIFO_BUFFER_OVERLOAD )
					spi_post_buf.post_buffer_pointer = 0;
			} else if ( spi_rw == SPI_IS_READ ) {
				np_driver_spis_put_byte_to_tx_buff(0);
				// Received the low Byte of message length
				spi_get_buf.message_len[spi_get_buf.get_message_pointer] = spi_read;
			}
		} else {
			if ( spi_rw == SPI_IS_WRITE ) {
				// Send the first byte here
				np_driver_spis_put_byte_to_tx_buff(spi_post_buf.buffer[spi_post_buf.post_buffer_pointer++]);
				// Do NOT over the buffer
				if ( spi_post_buf.post_buffer_pointer > FIFO_BUFFER_OVERLOAD )
					spi_post_buf.post_buffer_pointer = 0;

				if ( spi_post_buf.message_len[spi_post_buf.post_message_pointer]+1 <= spi_count ) {
					// If we do NOT sent more bytes in 1ms, means we finished the sending
					spi_status = SPI_FREE;

					spi_post_buf.used_buffer_length -= spi_post_buf.message_len[spi_post_buf.post_message_pointer];
					spi_post_buf.post_message_pointer++;
					// Do NOT over the buffer
					if ( spi_post_buf.post_message_pointer > FIFO_MESSAGE_OVERLOAD )
						spi_post_buf.post_message_pointer = 0;
					spi_post_buf.message_num--;
				}
			} else if ( spi_rw == SPI_IS_READ ) {
				// Start to received the message body
				spi_get_buf.buffer[spi_get_buf.get_buffer_pointer++] = spi_read;
				// Do NOT over the buffer
				if ( spi_get_buf.get_buffer_pointer > FIFO_BUFFER_OVERLOAD )
					spi_get_buf.get_buffer_pointer = 0;

				if ( spi_get_buf.message_len[spi_get_buf.get_message_pointer]+2 <= spi_count ) {
					// If we do NOT received more bytes in 1ms, means we finished the last receiving
					// Then free the SPI and add one more message
					spi_status = SPI_FREE;

					spi_get_buf.used_buffer_length += spi_get_buf.message_len[spi_get_buf.get_message_pointer];
					spi_get_buf.get_message_pointer++;
					// Do NOT over the buffer
					if ( spi_get_buf.get_message_pointer > FIFO_MESSAGE_OVERLOAD )
						spi_get_buf.get_message_pointer = 0;
					spi_get_buf.message_num++;
					np_driver_spis_put_byte_to_tx_buff('$');	//keep first TX byte of next communication is '$'.Meaningless on here
				}else{
					np_driver_spis_put_byte_to_tx_buff(0);
				}
			}
		}
		spi_count++;
	}
}


/*
 * Description: check the CS pin if it got selected, if yes, we could not use it, SPI bus is busy
 * Parameter  : null
 * Return     : 0x01-BUSY , 0x00-FREE
 */
uint32_t np_app_spi_is_aviable(void) {
	#if 0//mxc32625  high level available
	return GPIO_InGet(&gpio_req_spi[0]);
	#else
	return (!GPIO_InGet(&gpio_req_spi[0]));
	#endif
}

/*
 * Description: give a pulse on the SPI bus, signal to Gateway,spi slave want to have a spi comunication.
 * Parameter  : null
 * Return     : null
 */
void np_app_spi_apply_post(void) {

	GPIO_Config(&gpio_req_spi[1]);//Output

	GPIO_OutSet(&gpio_req_spi[1]);
	GPIO_OutClr(&gpio_req_spi[1]);

	GPIO_Config(&gpio_req_spi[0]);//Input
}

