#include <iostream>
#include "m.bed"
#include "Motor.h"

bool loop = true

Motor::Motor(PinName pwm, PinName fwd, PinName rev):
        _pwm(pwm), _fwd(fwd), _rev(rev) {

    // Set initial condition of PWM
    _pwm.period(0.002);
    _pwm = 0;

    // Initial condition of output enables
    _fwd = 0;
    _rev = 0;
}

void Motor::speed(float speed) {
    _fwd = (speed > (float)0.0);
    _rev = (speed < (float)0.0);
    _pwm = fabs(speed);
}

void Motor::period(float period){

    _pwm.period(period);

}
int main () {
    Motor MotorA (PC_7, PA_9, PA_8);   
    Motor MotorB (PA_7, PA_6, PA_5);
    Motor MotorC (PB_3, PA_10, PA_2);
    
    while (loop == true) {
        MotorA.speed (-0.5);
        MotorB.speed (0.5);
        }
    
    return 0;
    }