#include <iostream>
#include "Motor.h"
#include "mbed.h"

bool loop = true;

Motor::Motor(PinName pwm, PinName fwd, PinName rev):
        _pwm(pwm), _fwd(fwd), _rev(rev) {

    // Set initial condition of PWM
    _pwm.period(0.002);
    _pwm = 0;

    // Initial condition of output enables
    _fwd = 0;
    _rev = 0;
}

void Motor::speed(float speed) {
    _fwd = (speed > (float)0.0);
    _rev = (speed < (float)0.0);
    _pwm = fabs(speed);
}

void Motor::period(float period){
    _pwm.period(period);
}

// Ilustrasi Kondisi Motor :
/* 
          +__________-     -- > Motor 3


    -                      +
     \                    /
      \                  /   --- > Kiri : Motor 1, Kanan : Motor 2
       \                /
        +              -
*/


int main () {
    Motor Motor1 (PC_7, PA_9, PA_8);   // Deklarasi objek motor
    Motor Motor2 (PA_7, PA_6, PA_5);
    Motor Motor3 (PB_3, PA_10, PA_2);
        
    while (loop == true) {
    Motor1.speed(-0.5);
    Motor2.speed(-0.5);
    Motor3.speed(0.5);
    }    
    return 0;
}