#include "Motor.h"

//-------------------------------------------------------------------------------------
Motor::Motor(D5, D8, D7):
        _pwm(D5), _fwd(D8), _rev(D7) {

    _pwm.period(0.002);
    _pwm = 0;
    _fwd = 0;
    _rev = 0;
}
void Motor::speed(float speed) {
    _fwd = (speed > (float)0.0);
    _rev = (speed < (float)0.0);
    _pwm = fabs(speed);
}
void Motor::period(float period){
    _pwm.period(period);

}
void Motor::brake(int highLow){
    if(highLow == BRAKE_HIGH){
        _fwd = 1;
        _rev = 1;
    }
    else if(highLow == BRAKE_LOW){
        _fwd = 0;
        _rev = 0;
    }
}
void Motor::forcebrake(){
    _pwm = 1.0;
    _fwd = 1;
    _rev = 1;
}
//-------------------------------------------------------------------------------------


//------------------Ke Depan----------------------------
//---------------------^^-----------------------------
//---------------------||-----------------------------
//----------------------------------------------------
//----Motor depan-----OOOO----------------------------
//---------------------||--------------__>------------
//---------------------||--------------__>---Ke Kanan-----
//-------------------//--\\----------------------------
//------------------//----\\--------------------------
//-----Motor kiri--OOO----OOO----Motor Kanan----------

int main() {
  string arah, rotate;

  Motor depan();
  Motor kiri();
  Motor kanan();

//Kekuatan motor-yang-berotasi-dan-menyebabkan-base-bergerak-clockwise adalah positif
//Kekuatan motor-yang-berotasi-dan-menyebabkan-base-bergerak-clockwise adalah positif
//Kekuatan motor-yang-berotasi-dan-menyebabkan-base-bergerak-clockwise adalah positif

  do {
    getline (cin, arah);
    getline (cin, rotate);
    
    if (arah == "depan"){       //Base bergerak ke depan
      kanan.speed(-1.0);
      kiri.speed(1.0);
    }
    
    if (arah == "belakang"){    //Base bergerak ke belakang
      kiri.speed(-1.0);
      kanan.speed(1.0);
    }
    
    if (arah == "kiri") {       //Base bergerak ke kiri
      depan.speed(-1.0);
      kiri.speed(1.0);
      kanan.speed(-1.0);
    }
    
    if (arah == "kanan") {      //Base bergerak ke kanan
      depan.speed(1.0);
      kiri.speed(-1.0);
      kanan.speed(1.0);
    }

    if (rotate == "clockwise") {        //Base begerak searah jarum jam (pivot kanan)
      depan.speed(1.0);
      kiri.speed(1.0);
      kanan.speed(1.0);
    }
    
    if (rotate == "counterclock") {     //Base begerak searah jarum jam (pivot kanan)
      depan.speed(-1.0);
      kiri.speed(-1.0);
      kanan.speed(-1.0);
    }
    
    if (arah == "kanan" && rotate == "clockwise"){ //Base begerak searah jarum jam dan translasi ke kanan (belum berhasil)
      depan.speed(1.0);                
      kiri.speed(0.75);
      kanan.speed(-0.5);
    }
  } while();
}