//

#include <Motor.h>
#include <encoderKRAI.h>
#include <mbed.h>
// declare
Motor main_motor(PA_7, PA_5, PA_6 );// input pin
Motor main_motorB(PB_0 ,PC_0, PC_1); //input pin
Motor main_motorC(PB_1, PB_14, PB_15 );// input pin
DigitalOut pneu(PC_6);// input pin
DigitalOut pneu1(PC_5);// input pin
DigitalOut pneu2(PC_8);// input pin
DigitalIn infrared(PB_12, PullUp); // input pin
encoderKRAI encoder(PC_2,PC_3,538,encoderKRAI::X4_ENCODING);// input pin
Serial pc(USBTX, USBRX,115200);

int count, count_ball ;
double pulse, total_pulse,total_pulse_in_degree,theta,pwm;
double kp,ki,kd;
bool not_stop ;
double galat, integral, derivative;
double last_galat ;


void BacaEncoder(){// read encoder
    pulse = (double)encoder.getPulses();
    encoder.reset();
    total_pulse += pulse;
    total_pulse_in_degree = total_pulse*360/538;
}
  
    
    
void PID(double theta){
        //pid
        galat = theta - total_pulse_in_degree;
        derivative = galat - last_galat;

        pwm =  (0.006*galat);

        //limit the power of motor, the max power can be changed
        if (pwm > 0.6) pwm = 0.6;
        else if (pwm < -0.6) pwm = -0.6;
}

void MoveMotor(double theta){
    not_stop = 1;
    last_galat = theta;
    total_pulse =0;
    integral = 0;

    // move motor
    last_galat = theta;
    while ((not_stop) && theta!=0){
        BacaEncoder();
        //PID(theta);
        galat = theta - total_pulse_in_degree;
        derivative = galat - last_galat;
        integral += galat;
        pwm =  (0.0165*galat)+(derivative) ;

        //limit the power of motor, the max power can be changed
        if (pwm > 0.6) pwm = 0.6;
        else if (pwm < -0.6) pwm = -0.6;
        // set speed motor
        if (fabs(galat) > 0.6 || (fabs(pwm) > 0.1)) main_motor.speed(pwm);
        else {
            main_motor.speed(0);
            main_motor.brake(1);
            not_stop = 0;
            break;
        }
        
        last_galat = galat;
        pc.printf("%f.2 \n", total_pulse_in_degree);
        if (fabs(total_pulse_in_degree) > 120){
            main_motor.speed(0);
            main_motor.brake(1);            
            not_stop = 0;
            break;
        }
    }
}
int t1;

int main(){
    encoder.reset();
    while (1){
        //MoveMotor(3600);
        main_motor.speed(0.5);
        main_motorB.speed(0.5);
        main_motorC.speed(0.5);
        }
    /*
    pneu = 1;
    encoder.reset();
    int state = 1;
    wait(1);
    count_ball = 0;
    
    while (count_ball<6){
        pc.printf("%f.2 \n", total_pulse_in_degree);
        if (state && !infrared) {
            wait(1); 
            state = 0 ;
            pneu = 0;                   // menembakkan bola
            wait(1);
            count_ball++;
                    // menggerakkan motor
            if (count_ball == 2) MoveMotor(60);
            else if (count_ball == 4) MoveMotor(90);
            wait(1);
            

        } else {
            pneu = 1;
            state = 1;
            wait(1);
        }
    if (count_ball==6) pneu = 1;
    
    }*/
}
