/*

  Neopixel LED controller for mbed LPC1114 (RAMdaccha)
 
  2014/12/13 by morecat_lab

  This program depends on neopixel library.
  http://developer.mbed.org/users/JacobBramley/code/PixelArray/

*/
#include "mbed.h"
#include "neopixel.h"
#include "LAMd.h"

neopixel::Pixel pattern[] = {
    {0x55, 0, 0xff},  // magenta
    {0, 0, 0xff},  // blue
    {0xaf, 0xaf, 0xaf}, // white
    {0, 0xff, 0xff},  // cyan
    {0xaf, 0xaf, 0}, // yellow
    {0, 0xff, 0}, // greem
    {0x2f, 0, 0}, // red
};

#define MAX_PATTERN (sizeof pattern / sizeof (struct neopixel::Pixel))
#define MAX_INDEX (MAX_PATTERN *256)
#define NLED (4)
#define ONE_COLOR


 void generate(neopixel::Pixel * out, uint32_t index, uintptr_t val) {
#ifdef ONE_COLOR
    uint32_t pat1 = val / 256;
#else
    uint32_t pat1 = val / 256 + index;
#endif
    uint32_t pat2;
    uint32_t seq = val % 256;
    
    if (pat1 >= MAX_PATTERN) {
        pat1 = 0;
    }
    pat2 = pat1 + 1;
    if (pat2 >= MAX_PATTERN) {
        pat2 = 0;
    }
    out->red   = (pattern[pat1].red   * (256-seq) + pattern[pat2].red   * seq) /256;
    out->green = (pattern[pat1].green * (256-seq) + pattern[pat2].green * seq) /256;
    out->blue  = (pattern[pat1].blue  * (256-seq) + pattern[pat2].blue  * seq) /256;
 }


int main() {
  
     
  
    DigitalIn(P1_22, PullDown); 
    neopixel::PixelArray array(P1_22);
       
       
    uint32_t val = 0;
    while (1) {
      if ((++val) >= MAX_INDEX) {
        val = 0;
      }
      array.update(generate, NLED, val);
      wait_ms(10);
     
    }
}
