#include "mbed.h"
 
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut LE(PA_3); // PA_3
DigitalOut OE(PA_4); // PA_4
//AnalogIn ain(PB_15);

#define DURATION 400

#define CHAR_BIT 8
 
////////////////////////// SPI //////////////////////////
void write(uint16_t val) {
    LE=0;
    OE=1;
    
    spi.write(val);
    LE=1;
    wait_us(1);
    LE=0;
    OE=0;
}
 
////////////////////////// RANDOM NUMBERS //////////////////////////

/*
// C/C++ idiom which translates to a single operation on AVR/x86
// Source:  http://stackoverflow.com/questions/776508/best-practices-for-circular-shift-rotate-operations-in-c
uint32_t rotr(uint32_t x, unsigned int n)
{
    const typeof(n) mask = (CHAR_BIT*sizeof(x)-1);
    //n &= mask;  // avoid undef behaviour with NDEBUG.  0 overhead for most types / compilers
    return (x<<( (-n)&mask )) | (x>>n);
}

uint32_t rot_const(uint32_t x)
{
    return rotr(x, 3);
}

uint32_t seed = 0;
uint32_t hw_rand(uint32_t n)
{
    uint32_t r = 0, i;
    for (i=0; i<n; i++) {
        r ^= ain.read_u16();
        r = rot_const(r);
    }
    //SERIAL("Rand: %d\r\n", r);
    return r;
}
*/

////////////////////////// DEMO //////////////////////////

void spike(uint8_t k) {
    if(k>8) k = 0;

    // RISE: from bottom to top
    uint8_t i, t = DURATION;
    uint16_t val = 0;
    //for(i=k;i<8;i++) {
    //    t = (uint8_t) (t*1.1);
    //}
    for(i=0;i<k;i++) {
        val <<= 2;
        val |= 3;
        write(val);
        wait_ms(t);
        t = (uint8_t) (t*0.88);
    }
    wait_ms(DURATION);
    
    // FALL: from top to bottom
    t = DURATION;
    while(val) {
        val >>= 2;
        write(val);
        wait_ms(t);
        t = (uint8_t) (t*0.9);
    }
}

void demo(int n) {
    int k;
    for(int i=0;i<n;i++) {
        //seed ^= hw_rand(20);
        //k = seed % 83;
        k = rand() % 89;
        spike(k/10 + (k%10 ? 1 : 0));
        wait_ms(100);
    }
}
 
////////////////////////// MAIN //////////////////////////


int main() {
    //seed = hw_rand(4000);
    
    spi.format(16,0); //16-bit mode and SPI mode 0 (Data transfered on first rising edge of clock)
    spi.frequency(1000000); //1 Mhz SPI clock frequency.
    LE=0; //Serial data is transferred to the output latch when LE is high. The data is latched when LE goes low. 
    OE=1; //Output enable high
   
    while(1) {
        demo(10);
        //write(0xAAAA);
        wait_ms(1000);
        //write(0x5555);
        //wait_ms(1000);
    }
}
 