#include "mbed.h"

#define IDLE            0
#define SINGLE_PRESS    1
#define DOUBLE_PRESS    2
#define LONG_PRESS      3


DigitalOut myled(LED1);
Timeout t;
Timer tmr;
Serial pc(USBTX, USBRX);
InterruptIn joy(p14);
int cnt = 0;

int current_state = IDLE;


void timeout_func(){
//    printf("you have pressed the button %d times \r\n", cnt);
    int tm_val = tmr.read_ms();
//    printf("tm value is %d \r\n", tm_val);
    tmr.reset();
    if(tm_val > 500)
        current_state = LONG_PRESS;
    else{
            
        switch(cnt){
            case 0:
                current_state = IDLE;
                
                break;
            case 1:
                current_state = SINGLE_PRESS;
                break;
            case 2:
                current_state = DOUBLE_PRESS;
                break;
            default:
                current_state = IDLE;
                break;
                    
        }
    }
    cnt=0;    
    
}

void rise_func(){
//    printf("rise_func %d\r\n", cnt++); 
    tmr.start();
    cnt++;   
    t.attach(&timeout_func, 0.7);    
}

void fall_func(){
//    printf("fall_func \r\n");    
    tmr.stop();
}

int numbr = 0;


int main() {
    pc.baud(115200);
    joy.rise(&rise_func);
    joy.fall(&fall_func);
    while(1){
            if(current_state == IDLE){
                // stay idle
            }else if(current_state == SINGLE_PRESS){
                numbr = numbr+1;
            }else if(current_state == DOUBLE_PRESS){
                numbr = numbr+2;
            }else if(current_state == LONG_PRESS){
                numbr = 0;
            }else{
                //stay idle
            }
            printf("incrementing value %d\r\n", numbr);
            wait(2);
        }
        
    
}
