#include "mbed.h"

DigitalOut myled(LED1);

char sens1[] = "co2,13,o2,32,pm10,12,pm2.5,36,t,29.17;";
char sens_bad1[] = "co12,o2,32,pm10,12,pm2.5,36,t,29.17;";  // missing characters
char sens_bad2[] = "co2,,o2,32,pm10,12,pm2.5,36,t,29.17;";  // missing sensor value
char sens_bad3[] = "co2,12,o2,32,pm10,12.00,pm2.5,36,t,29.17;"; //int is changed to float
char sens_bad4[] = "co2,12,o2,32,pm2.5,36,t,29.17;"; //a sensor pair value is missing
char sens_bad5[] = ",,,,,,,,,;"; //missing values

void parseSentences(char* inpTxt){
    int gas_co2 = 0;
    int gas_o2 = 0;
    int pm10 = 0;
    int pm2_5 = 0;
    float temp_c = 0;
    
    printf("\r\n%s \r\n ", inpTxt);
    int ret_val = sscanf(inpTxt, "co2,%d,o2,%d,pm10,%d,pm2.5,%d,t,%f;",
                &gas_co2,  &gas_o2, &pm10, &pm2_5, &temp_c);
    if(ret_val == 5){
        printf("gas_co2 %d \r\n", gas_co2);
        printf("gas_o2 %d \r\n", gas_o2);
        printf("pm10 %d \r\n", pm10);
        printf("pm2_5 %d \r\n", pm2_5);
        printf("temp_c %f \r\n", temp_c);    
    } else 
        printf("PARSE FAIL!! ret_val %d \r\n", ret_val);    

}

int main() {
    parseSentences(sens_bad1);
    parseSentences(sens_bad2);
    parseSentences(sens_bad3);
    parseSentences(sens_bad4);
    parseSentences(sens_bad5);
    parseSentences(sens1);
    
}
