#include "mbed.h"

// Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
class Watchdog
{
public:
// Load timeout value in watchdog timer and enable
    void kick(float s)
    {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick()
    {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

// Setup the watchdog timer
Watchdog wdt;

int main()
{
    printf("\r\n\n\n\nSystemCoreClock = %d MHz\n\r", SystemCoreClock/1000000);
    int count = 0;
    // On reset, indicate a watchdog reset or a pushbutton reset on LED 4 or 3
    if ((LPC_WDT->WDMOD >> 2) & 1)
        printf("WDT reset has happened: %d \r\n", count);
    else printf("normal reset/power up: %d \r\n", count);

    // setup a 10 second timeout on watchdog timer hardware
    // needs to be longer than worst case main loop exection time
    wdt.kick(10);

    // Main program loop - resets watchdog once each loop iteration
    // Would typically have a lot of code in loop with many calls
    while (1) {
        printf("Normal activity: %d \r", count);
        wait(1);
        // Simulate a fault lock up with an infinite while loop, but only after 25 loop iterations
        if (count == 10){
            printf("\r\n Going into a infinite loop : %d \r\n", count);               
                while (1) {};
        }
        count ++;
        // End of main loop so "kick" to reset watchdog timer and avoid a reset
        wdt.kick();
    }
}
