#include "mbed.h"
#include "MSS.h"
#include "VEML6075.h"

#define MSU_VEML6075_ADDRESS   0x10

VEML6075 *veml6075 = 0 ;

int main() {
    float uvi, uva, uvb, uva_cie, uvb_cie ;
    
    VEML6075 *veml6075 = new VEML6075(PIN_SDA, PIN_SCL, MSU_VEML6075_ADDRESS) ;
    veml6075->setUVConf(0x00) ;
    
    printf("=== VEML6075 Test for %s ( %s ) ===\n", BOARD_NAME, __DATE__ ) ;
    printf("   UVI,    UVA, UVA_CIE,   UVB, UVB_CIE\n") ;
    
    while(1) {
        uvi = veml6075->UVI() ;
        uva = veml6075->getUVA() ;
        uva_cie = veml6075->getUVA_CIE() ;
        uvb = veml6075->getUVB() ;
        uvb_cie = veml6075->getUVB_CIE() ;

        printf("%.4f, %.4f, %.4f, %.4f, %.4f\n",
        uvi, uva, uva_cie, uvb, uvb_cie) ;
        wait(1) ;
    }
}
