#include "mbed.h"
#include "MSS.h"
#include "VEML6040.h"

#define MSU_VEML6040_ADDRESS  0x10

VEML6040 *veml6040 = 0 ;

int main() {
    uint16_t R, G, B, W ;
    veml6040 = new VEML6040(PIN_SDA, PIN_SCL, MSU_VEML6040_ADDRESS) ;
    veml6040->setCOLORConf(0x00) ;
    
    printf("=== VEML6040 Test for %s ( %s ) ===\n", BOARD_NAME, __DATE__) ;
    printf("     R,      G,      B,      W\n") ;
    while(1) {
        veml6040->getRData(&R) ;
        veml6040->getGData(&G) ;
        veml6040->getBData(&B) ;
        veml6040->getWData(&W) ;
        printf("%6d, %6d, %6d, %6d\n", R,G,B,W) ;
        wait(1) ;
    }
}
