#include "mbed.h"
#include "MSS.h"
#include "VCNL4100.h"

#define MSU_VCNL4100_I2C_ADDRESS 0x60
VCNL4100 *vcnl4100 = 0 ;

DigitalOut myled(LED1);

int main() {
    uint8_t psData = 0x00 ;
    uint16_t alsData = 0x00 ;
    vcnl4100 = new VCNL4100(PIN_SDA, PIN_SCL, MSU_VCNL4100_I2C_ADDRESS) ;
    
    printf("=== test VCNL4100 for %s (%s)\n", BOARD_NAME, __DATE__) ;
    printf("Proximity, Ambient Light\n") ;
    
    vcnl4100->setAlsConf(0x00) ;
    vcnl4100->setPsConf12(0x0000) ;
    vcnl4100->setSpo(0xA0) ;
    
    while(1) {
        psData = vcnl4100->getPsData() ;
        alsData = vcnl4100->getAlsData() ;
        printf("0x%02X, 0x%04X\n", psData, alsData) ;
        wait(1);
    }
}
