#include "mbed.h"
#include "MSS.h"
#include "MPL3115A2.h"
#define MPL3115A2_I2C_ADDRESS (0x60)

int main() {
    double alt, bar, temp ;
    MPL3115A2 mpl(PIN_SDA, PIN_SCL, MPL3115A2_I2C_ADDRESS) ;
    
    printf("=== test MPL3115A2 for %s (%s) ===\n",BOARD_NAME, __DATE__) ;
    printf("Altitude(m), Pressure(hPa),   Temperature(c)\n") ;
    
    while(1) {
        alt = mpl.getAltitude() ;
        bar = mpl.getPressure() ;
        temp = mpl.getTemperature() ;
        printf("%6.2f,   %6.2f, %6.2f\n",alt, bar, temp) ;
        wait(1) ;
    }
}
