#include "mbed.h"
#include "MSS.h"
#include "MMA8452Q.h"

#define MMA8452_I2C_ADDRESS (0x1d)
 
int main(void) {
     float x, y, z ;

     MMA8452Q acc(PIN_SDA, PIN_SCL, MMA8452_I2C_ADDRESS);
     
     printf("=== test MMA8452Q for %s (%s) ===\n",BOARD_NAME, __DATE__) ;
     printf(" X,     Y,     Z\n") ;
 
     while (true) {       
         x = acc.getAccX() ;
         y = acc.getAccY() ;
         z = acc.getAccZ() ;
         printf("%.2f, %.2f, %.2f\n",x, y, z) ;
         wait(0.1);
    }
}

