#include "mbed.h"
#include "MAX44008.h"

#define MAX44008_I2C_ADDRESS (0x41) 

#if defined (TARGET_KL25Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL46Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_K64F)
#define PIN_SCL  PTE24
#define PIN_SDA  PTE25
#elif defined (TARGET_K22F)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL05Z)
#define PIN_SCL  PTB3
#define PIN_SDA  PTB4
#elif define (TARGET_F411RE)
#define PIN_SCL  PB_8
#define PIN_SDA  PB_9
#else
 #error TARGET NOT DEFINED
#endif

MAX44008 *max44008 = 0 ;

void reportMAX44008(MAX44008 *max44008)
{
    uint16_t amb_c, amb_r, amb_g, amb_b, amb_ir, amb_ircomp, amb_temp ;
    amb_c = max44008->getAMB_CLEAR() ;
    amb_r = max44008->getAMB_RED() ;
    amb_g = max44008->getAMB_GREEN() ;
    amb_b = max44008->getAMB_BLUE() ;
    amb_ir = max44008->getIR() ;
    amb_ircomp = max44008->getIRCOMP() ;
    amb_temp = max44008->getTEMP() ;
    printf("--- MAX44008 ---\n") ;
    printf("   C[ %04X ]\n", amb_c) ;
    printf("R[ %04X ] G[ %04X ] B[ %04X ]\n",amb_r, amb_g, amb_b) ;
    printf("IR[ %04X ] IRCOMP [ %04X ]\n",amb_ir, amb_ircomp) ;
    printf("   TEMP [ %04X ]\n",amb_temp) ;
    printf("\n") ;
}

#define MODE_CLEAR_RGB_IR     0x02

int main() {
    max44008 = new MAX44008(PIN_SDA, PIN_SCL, MAX44008_I2C_ADDRESS) ;
    max44008->setMode(MODE_CLEAR_RGB_IR) ;
    
    while(1) {
        reportMAX44008(max44008) ;
        wait(1) ;
    }
}
