#include "mbed.h"
#include "MAX44005.h"

#define MAX44005_I2C_ADDRESS (0x44) 

#if defined (TARGET_KL25Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL46Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_K64F)
#define PIN_SCL  PTE24
#define PIN_SDA  PTE25
#elif defined (TARGET_K22F)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL05Z)
#define PIN_SCL  PTB3
#define PIN_SDA  PTB4
#elif define (TARGET_F411RE)
#define PIN_SCL  PB_8
#define PIN_SDA  PB_9
#else
 #error TARGET NOT DEFINED
#endif

MAX44005 *max44005 = 0 ;

void reportMAX44005(MAX44005 *max44005)
{
    uint16_t amb_c, amb_r, amb_g, amb_b, amb_ir, amb_ircomp, amb_temp ;
    amb_c = max44005->getAMB_CLEAR() ;
    amb_r = max44005->getAMB_RED() ;
    amb_g = max44005->getAMB_GREEN() ;
    amb_b = max44005->getAMB_BLUE() ;
    amb_ir = max44005->getIR() ;
    amb_ircomp = max44005->getIRCOMP() ;
    amb_temp = max44005->getTEMP() ;
    printf("--- MAX44005 ---\n") ;
    printf("   C[ %04X ]\n", amb_c) ;
    printf("R[ %04X ] G[ %04X ] B[ %04X ]\n",amb_r, amb_g, amb_b) ;
    printf("IR[ %04X ] IRCOMP [ %04X ]\n",amb_ir, amb_ircomp) ;
    printf("   TEMP [ %04X ]\n",amb_temp) ;
    printf("\n") ;
}

DigitalOut myled(LED1);

int main() {
    max44005 = new MAX44005(PIN_SDA, PIN_SCL, MAX44005_I2C_ADDRESS) ;
    max44005->enableTEMP() ;
    max44005->setMode(0x04) ;
    
    while(1) {
        reportMAX44005(max44005) ;
        wait(1);
    }
}
