#include "mbed.h"
#include "MAX44000.h"

#define MAX44000_I2C_ADDRESS (0x4A)

#if defined (TARGET_KL25Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL46Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_K64F)
#define PIN_SCL  PTE24
#define PIN_SDA  PTE25
#elif defined (TARGET_K22F)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL05Z)
#define PIN_SCL  PTB3
#define PIN_SDA  PTB4
#elif defined (TARGET_NUCLEO_F411RE)
#define PIN_SCL  PB_8
#define PIN_SDA  PB_9
#else
 #error TARGET NOT DEFINED
#endif

int main() {
  uint16_t als ;
  uint8_t prox, overflow ;
  MAX44000 max44000(PIN_SDA, PIN_SCL, MAX44000_I2C_ADDRESS) ;
    
  while(1) {
    max44000.getADC(&overflow, &als, &prox) ;
    printf("ALS[ %04X ]", als) ;
    if (overflow) {
        printf(" overflow ") ;
    } else {
        printf("          ") ;
    }
    printf("PRX[ %02X ]\n", prox) ;
    wait(1);
  }
}
