#ifndef _MSS_H_
#define _MSS_H_

#if defined (TARGET_KL25Z)
/* I2C */
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
/* SPI */
#define PIN_SCK  PTD1
#define PIN_MISO PTD3
#define PIN_MOSI PTD2
#define PIN_CS0  PTD0
/* Interrupt */
#define PIN_INT0 PTD5
#define PIN_INT1 PTA13
#define PIN_INT2 PTC9  /* This pin does not support interrupt */
#define PIN_INT3 PTC8  /* This pin does not support interrupt */
#define PIN_INT4 PTA5
#define PIN_INT5 PTA4
/* Analog Input */
#define PIN_AN0  PTB0
#define PIN_AN1  PTB1
#define PIN_AN2  PTB2
#define PIN_AN3  PTB3
#define PIN_AN4  PTC2
#define PIN_AN5  PTC1
#define BOARD_NAME "FRDM-KL25Z"

#elif defined (TARGET_KL46Z)
/* I2C */
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
/* SPI */
#define PIN_SCK  PTD5
#define PIN_MISO PTD7
#define PIN_MOSI PTD6
#define PIN_CS0  PTD4
/* Interrupt */
#define PIN_INT0 PTD2
#define PIN_INT1 PTA13
#define PIN_INT2 PTC9  /* This pin does not support interrupt */
#define PIN_INT3 PTC8  /* This pin does not support interrupt */
#define PIN_INT4 PTA5
#define PIN_INT5 PTA4
/* Analog Input */
#define PIN_AN0  PTB0
#define PIN_AN1  PTB1
#define PIN_AN2  PTB2
#define PIN_AN3  PTB3
#define PIN_AN4  PTC2
#define PIN_AN5  PTC1
#define BOARD_NAME "FRDM-KL46Z"

#elif defined (TARGET_K64F)
/* I2C */
#define PIN_SCL  PTE24
#define PIN_SDA  PTE25
/* SPI */
#define PIN_SCK  PTD1
#define PIN_MISO PTD3
#define PIN_MOSI PTD2
#define PIN_CS0  PTD0
/* Interrupt */
#define PIN_INT0 PTC4
#define PIN_INT1 PTA0
#define PIN_INT2 PTC3
#define PIN_INT3 PTC2
#define PIN_INT4 PTA2
#define PIN_INT5 PTB23
/* Analog Input */
#define PIN_AN0  PTB2
#define PIN_AN1  PTB3
#define PIN_AN2  PTB10
#define PIN_AN3  PTB11
#define PIN_AN4  PTC11
#define PIN_AN5  PTC10
#define BOARD_NAME "FRDM-K64Z"

/**
 * NOTE: On FRDM-K22F
 * Both I2C and UART are assigned to 
 * the same pins PTE1/PTE0.
 * So MSS does not work as is.
 */
#elif defined (TARGET_K22F) 
/* I2C */
/* for quattro-II/f-shaft-II */
#if 1
#define PIN_SCL  PTB2
#define PIN_SDA  PTB3
#endif
#if 0
#define PIN_SCL  PTC10
#define PIN_SDA  PTC11
#endif 
/* SPI */
#define PIN_SCK  PTD5
#define PIN_MISO PTD7
#define PIN_MOSI PTD6
#define PIN_CS0  PTD4
/* Interrupt */
//#define PIN_INT0 PTA1
//#define PIN_INT1 PTB19
//#define PIN_INT2 PTC6
//#define PIN_INT3 PTC3
//#define PIN_INT4 PTB18
//#define PIN_INT5 PTA4
#define PIN_INT0 PTB16
#define PIN_INT1 PTB17
#define PIN_INT2 PTB18
#define PIN_INT3 PTB19
/* Analog Input */
#define PIN_AN0  PTB0
#define PIN_AN1  PTB1
#define PIN_AN2  PTC1
#define PIN_AN3  PTC2
// #define PIN_AN4  PTB3
// #define PIN_AN5  PTB2
// #define BOARD_NAME "FRDM-K22F"
#define BOARD_NAME "f-shaft-II"

#elif defined (TARGET_KL05Z)
/* I2C */
#define PIN_SCL  PTB3
#define PIN_SDA  PTB4
/* SPI */
#define PIN_SCK  PTB0
#define PIN_MISO PTA6
#define PIN_MOSI PTA7
#define PIN_CS0  PTA5
/* Interrupt */
#define PIN_INT0 PTB11
#define PIN_INT1 PTB10
#define PIN_INT2 PTB7
#define PIN_INT3 PTB6
#define PIN_INT4 PTA12
#define PIN_INT5 PTA10
/* Analog Input */
#define PIN_AN0  PTB8
#define PIN_AN1  PTB9
#define PIN_AN2  PTA8
#define PIN_AN3  PTA0
#define PIN_AN4  PTA9
#define PIN_AN5  PTB13
#define BOARD_NAME "FRDM-KL05Z"

#elif defined (TARGET_F411RE)
/* I2C */
#define PIN_SCL  PB_8
#define PIN_SDA  PB_9
/* SPI */
#define PIN_SCK  PA_5
#define PIN_MISO PA_6
#define PIN_MOSI PA_7
#define PIN_CS0  PB_6
/* Interrupt */
#define PIN_INT0 PC_7
#define PIN_INT1 PA_9
#define PIN_INT2 PA_8
#define PIN_INT3 PB_10
#define PIN_INT4 PB_4
#define PIN_INT5 PB_5
/* Analog In */
#define PIN_AN0  PA_0
#define PIN_AN1  PA_1
#define PIN_AN2  PA_4
#define PIN_AN3  PB_0
#define PIN_AN4  PC_1
#define PIN_AN5  PC_0
#define BOARD_NAME "NUCLEO-F411RE"

#elif defined (TARGET_MAX32600MBED)
/* I2C */
#define PIN_SCL  P2_7
#define PIN_SDA  P2_6
/* SPI */
#define PIN_SCK  P2_0
#define PIN_MISO P2_2
#define PIN_MOSI P2_1
#define PIN_CS0  P2_3
/* Interrupt */
#define PIN_INT0 P2_4
#define PIN_INT1 P2_5
#define PIN_INT2 P1_7
#define PIN_INT3 P1_6
#define PIN_INT4 P1_5
#define PIN_INT5 P1_4
/* Analog In */
#define PIN_AN0  AIN_0P
#define PIN_AN1  AIN_1P
#define PIN_AN2  AIN_2P
#define PIN_AN3  AIN_3P
#define PIN_AN4  AIN_4P
#define PIN_AN5  AIN_5P
#define BOARD_NAME "MAX32600MBED"

#else
 #error TARGET NOT DEFINED
/* I2C */
#define PIN_SCL  D15
#define PIN_SDA  D14
/* SPI */
#define PIN_SCK  D13
#define PIN_MISO D12
#define PIN_MOSI D11
#define PIN_CS0  D10
/* Interrupt */
#define PIN_INT0 D9
#define PIN_INT1 D8
#define PIN_INT2 D7
#define PIN_INT3 D6
#define PIN_INT4 D5
#define PIN_INT5 D4
/* Analog In */
#define PIN_AN0  A0
#define PIN_AN1  A1
#define PIN_AN2  A2
#define PIN_AN3  A3
#define PIN_AN4  A4
#define PIN_AN5  A5
/* MSS on board LEDs */
#define LED_D1   D13
#define LED_D2   D12
#define LED_D3   D11
#define LED_D4   D10
#define LED_D5   D3
#define LED_D6   D2
#define LED_D7   D1
#define LED_D8   D0



#endif

#endif /* _MSS_H_ */